/*
 * Decompiled with CFR 0.152.
 */
package com.gemstone.gemfire.internal.cache.wan.concurrent;

import com.gemstone.gemfire.cache.util.Gateway;
import com.gemstone.gemfire.internal.cache.wan.WANTestBase;
import dunit.AsyncInvocation;

public class ConcurrentAsyncEventQueueDUnitTest
extends WANTestBase {
    private static final long serialVersionUID = 1L;

    public ConcurrentAsyncEventQueueDUnitTest(String name) {
        super(name);
    }

    @Override
    public void setUp() throws Exception {
        super.setUp();
    }

    public void testConcurrentSerialAsyncEventQueueAttributes() {
        Integer lnPort = (Integer)vm0.invoke(WANTestBase.class, "createFirstLocatorWithDSId", new Object[]{1});
        vm4.invoke(WANTestBase.class, "createCache", new Object[]{lnPort});
        vm4.invoke(WANTestBase.class, "createConcurrentAsyncEventQueue", new Object[]{"ln", false, 100, 150, true, true, "testDS", true, 5, Gateway.OrderPolicy.THREAD});
        vm4.invoke(WANTestBase.class, "validateConcurrentAsyncEventQueueAttributes", new Object[]{"ln", 100, 150, 5, true, "testDS", true, true, 5, Gateway.OrderPolicy.THREAD});
    }

    public void testConcurrentParallelAsyncEventQueueAttributesOrderPolicyKey() {
        Integer lnPort = (Integer)vm0.invoke(WANTestBase.class, "createFirstLocatorWithDSId", new Object[]{1});
        vm4.invoke(WANTestBase.class, "createCache", new Object[]{lnPort});
        vm4.invoke(WANTestBase.class, "createConcurrentAsyncEventQueue", new Object[]{"ln", true, 100, 150, true, true, "testDS", true, 5, Gateway.OrderPolicy.KEY});
        vm4.invoke(WANTestBase.class, "validateConcurrentAsyncEventQueueAttributes", new Object[]{"ln", 100, 150, 5, true, "testDS", true, true, 5, Gateway.OrderPolicy.KEY});
    }

    public void testConcurrentParallelAsyncEventQueueAttributesOrderPolicyPartition() {
        Integer lnPort = (Integer)vm0.invoke(WANTestBase.class, "createFirstLocatorWithDSId", new Object[]{1});
        vm4.invoke(WANTestBase.class, "createCache", new Object[]{lnPort});
        vm4.invoke(WANTestBase.class, "createConcurrentAsyncEventQueue", new Object[]{"ln", true, 100, 150, true, true, "testDS", true, 5, Gateway.OrderPolicy.PARTITION});
        vm4.invoke(WANTestBase.class, "validateConcurrentAsyncEventQueueAttributes", new Object[]{"ln", 100, 150, 5, true, "testDS", true, true, 5, Gateway.OrderPolicy.PARTITION});
    }

    public void testReplicatedSerialAsyncEventQueueWithMultipleDispatcherThreadsOrderPolicyKey() {
        Integer lnPort = (Integer)vm0.invoke(WANTestBase.class, "createFirstLocatorWithDSId", new Object[]{1});
        vm4.invoke(WANTestBase.class, "createCache", new Object[]{lnPort});
        vm5.invoke(WANTestBase.class, "createCache", new Object[]{lnPort});
        vm6.invoke(WANTestBase.class, "createCache", new Object[]{lnPort});
        vm7.invoke(WANTestBase.class, "createCache", new Object[]{lnPort});
        vm4.invoke(WANTestBase.class, "createConcurrentAsyncEventQueue", new Object[]{"ln", false, 100, 100, true, false, null, false, 3, Gateway.OrderPolicy.KEY});
        vm5.invoke(WANTestBase.class, "createConcurrentAsyncEventQueue", new Object[]{"ln", false, 100, 100, true, false, null, false, 3, Gateway.OrderPolicy.KEY});
        vm6.invoke(WANTestBase.class, "createConcurrentAsyncEventQueue", new Object[]{"ln", false, 100, 100, true, false, null, false, 3, Gateway.OrderPolicy.KEY});
        vm7.invoke(WANTestBase.class, "createConcurrentAsyncEventQueue", new Object[]{"ln", false, 100, 100, true, false, null, false, 3, Gateway.OrderPolicy.KEY});
        vm4.invoke(WANTestBase.class, "createReplicatedRegionWithAsyncEventQueue", new Object[]{testName + "_RR", "ln", this.isOffHeap()});
        vm5.invoke(WANTestBase.class, "createReplicatedRegionWithAsyncEventQueue", new Object[]{testName + "_RR", "ln", this.isOffHeap()});
        vm6.invoke(WANTestBase.class, "createReplicatedRegionWithAsyncEventQueue", new Object[]{testName + "_RR", "ln", this.isOffHeap()});
        vm7.invoke(WANTestBase.class, "createReplicatedRegionWithAsyncEventQueue", new Object[]{testName + "_RR", "ln", this.isOffHeap()});
        vm4.invoke(WANTestBase.class, "doPuts", new Object[]{testName + "_RR", 1000});
        vm4.invoke(WANTestBase.class, "waitForAsyncQueueToGetEmpty", new Object[]{"ln"});
        vm5.invoke(WANTestBase.class, "waitForAsyncQueueToGetEmpty", new Object[]{"ln"});
        vm6.invoke(WANTestBase.class, "waitForAsyncQueueToGetEmpty", new Object[]{"ln"});
        vm7.invoke(WANTestBase.class, "waitForAsyncQueueToGetEmpty", new Object[]{"ln"});
        vm4.invoke(WANTestBase.class, "validateAsyncEventListener", new Object[]{"ln", 1000});
        vm5.invoke(WANTestBase.class, "validateAsyncEventListener", new Object[]{"ln", 0});
        vm6.invoke(WANTestBase.class, "validateAsyncEventListener", new Object[]{"ln", 0});
        vm7.invoke(WANTestBase.class, "validateAsyncEventListener", new Object[]{"ln", 0});
    }

    public void testReplicatedSerialAsyncEventQueueWithMultipleDispatcherThreadsOrderPolicyThread() {
        Integer lnPort = (Integer)vm0.invoke(WANTestBase.class, "createFirstLocatorWithDSId", new Object[]{1});
        vm4.invoke(WANTestBase.class, "createCache", new Object[]{lnPort});
        vm5.invoke(WANTestBase.class, "createCache", new Object[]{lnPort});
        vm6.invoke(WANTestBase.class, "createCache", new Object[]{lnPort});
        vm7.invoke(WANTestBase.class, "createCache", new Object[]{lnPort});
        vm4.invoke(WANTestBase.class, "createConcurrentAsyncEventQueue", new Object[]{"ln", false, 100, 100, true, false, null, false, 3, Gateway.OrderPolicy.THREAD});
        vm5.invoke(WANTestBase.class, "createConcurrentAsyncEventQueue", new Object[]{"ln", false, 100, 100, true, false, null, false, 3, Gateway.OrderPolicy.THREAD});
        vm6.invoke(WANTestBase.class, "createConcurrentAsyncEventQueue", new Object[]{"ln", false, 100, 100, true, false, null, false, 3, Gateway.OrderPolicy.THREAD});
        vm7.invoke(WANTestBase.class, "createConcurrentAsyncEventQueue", new Object[]{"ln", false, 100, 100, true, false, null, false, 3, Gateway.OrderPolicy.THREAD});
        vm4.invoke(WANTestBase.class, "createReplicatedRegionWithAsyncEventQueue", new Object[]{testName + "_RR", "ln", this.isOffHeap()});
        vm5.invoke(WANTestBase.class, "createReplicatedRegionWithAsyncEventQueue", new Object[]{testName + "_RR", "ln", this.isOffHeap()});
        vm6.invoke(WANTestBase.class, "createReplicatedRegionWithAsyncEventQueue", new Object[]{testName + "_RR", "ln", this.isOffHeap()});
        vm7.invoke(WANTestBase.class, "createReplicatedRegionWithAsyncEventQueue", new Object[]{testName + "_RR", "ln", this.isOffHeap()});
        AsyncInvocation inv1 = vm4.invokeAsync(WANTestBase.class, "doPuts", new Object[]{testName + "_RR", 500});
        AsyncInvocation inv2 = vm4.invokeAsync(WANTestBase.class, "doNextPuts", new Object[]{testName + "_RR", 500, 1000});
        AsyncInvocation inv3 = vm4.invokeAsync(WANTestBase.class, "doNextPuts", new Object[]{testName + "_RR", 1000, 1500});
        try {
            inv1.join();
            inv2.join();
            inv3.join();
        }
        catch (InterruptedException ie) {
            ConcurrentAsyncEventQueueDUnitTest.fail("Cought interrupted exception while waiting for the task tgo complete.", ie);
        }
        vm4.invoke(WANTestBase.class, "waitForAsyncQueueToGetEmpty", new Object[]{"ln"});
        vm5.invoke(WANTestBase.class, "waitForAsyncQueueToGetEmpty", new Object[]{"ln"});
        vm6.invoke(WANTestBase.class, "waitForAsyncQueueToGetEmpty", new Object[]{"ln"});
        vm7.invoke(WANTestBase.class, "waitForAsyncQueueToGetEmpty", new Object[]{"ln"});
        vm4.invoke(WANTestBase.class, "validateAsyncEventListener", new Object[]{"ln", 1500});
        vm5.invoke(WANTestBase.class, "validateAsyncEventListener", new Object[]{"ln", 0});
        vm6.invoke(WANTestBase.class, "validateAsyncEventListener", new Object[]{"ln", 0});
        vm7.invoke(WANTestBase.class, "validateAsyncEventListener", new Object[]{"ln", 0});
    }

    public void testPartitionedParallelAsyncEventQueueWithMultipleDispatcherThreadsOrderPolicyKey() {
        Integer lnPort = (Integer)vm0.invoke(WANTestBase.class, "createFirstLocatorWithDSId", new Object[]{1});
        vm4.invoke(WANTestBase.class, "createCache", new Object[]{lnPort});
        vm5.invoke(WANTestBase.class, "createCache", new Object[]{lnPort});
        vm6.invoke(WANTestBase.class, "createCache", new Object[]{lnPort});
        vm7.invoke(WANTestBase.class, "createCache", new Object[]{lnPort});
        vm4.invoke(WANTestBase.class, "createConcurrentAsyncEventQueue", new Object[]{"ln", true, 100, 100, true, false, null, false, 3, Gateway.OrderPolicy.KEY});
        vm5.invoke(WANTestBase.class, "createConcurrentAsyncEventQueue", new Object[]{"ln", true, 100, 100, true, false, null, false, 3, Gateway.OrderPolicy.KEY});
        vm6.invoke(WANTestBase.class, "createConcurrentAsyncEventQueue", new Object[]{"ln", true, 100, 100, true, false, null, false, 3, Gateway.OrderPolicy.KEY});
        vm7.invoke(WANTestBase.class, "createConcurrentAsyncEventQueue", new Object[]{"ln", true, 100, 100, true, false, null, false, 3, Gateway.OrderPolicy.KEY});
        vm4.invoke(WANTestBase.class, "createPartitionedRegionWithAsyncEventQueue", new Object[]{testName + "_PR", "ln", this.isOffHeap()});
        vm5.invoke(WANTestBase.class, "createPartitionedRegionWithAsyncEventQueue", new Object[]{testName + "_PR", "ln", this.isOffHeap()});
        vm6.invoke(WANTestBase.class, "createPartitionedRegionWithAsyncEventQueue", new Object[]{testName + "_PR", "ln", this.isOffHeap()});
        vm7.invoke(WANTestBase.class, "createPartitionedRegionWithAsyncEventQueue", new Object[]{testName + "_PR", "ln", this.isOffHeap()});
        vm4.invoke(WANTestBase.class, "doPuts", new Object[]{testName + "_PR", 1000});
        vm4.invoke(WANTestBase.class, "waitForAsyncQueueToGetEmpty", new Object[]{"ln"});
        vm5.invoke(WANTestBase.class, "waitForAsyncQueueToGetEmpty", new Object[]{"ln"});
        vm6.invoke(WANTestBase.class, "waitForAsyncQueueToGetEmpty", new Object[]{"ln"});
        vm7.invoke(WANTestBase.class, "waitForAsyncQueueToGetEmpty", new Object[]{"ln"});
        int vm4size = (Integer)vm4.invoke(WANTestBase.class, "getAsyncEventListenerMapSize", new Object[]{"ln"});
        int vm5size = (Integer)vm5.invoke(WANTestBase.class, "getAsyncEventListenerMapSize", new Object[]{"ln"});
        int vm6size = (Integer)vm6.invoke(WANTestBase.class, "getAsyncEventListenerMapSize", new Object[]{"ln"});
        int vm7size = (Integer)vm7.invoke(WANTestBase.class, "getAsyncEventListenerMapSize", new Object[]{"ln"});
        ConcurrentAsyncEventQueueDUnitTest.assertEquals((int)(vm4size + vm5size + vm6size + vm7size), (int)1000);
    }

    public void testPartitionedParallelAsyncEventQueueWithMultipleDispatcherThreadsOrderPolicyPartition() {
        Integer lnPort = (Integer)vm0.invoke(WANTestBase.class, "createFirstLocatorWithDSId", new Object[]{1});
        vm4.invoke(WANTestBase.class, "createCache", new Object[]{lnPort});
        vm5.invoke(WANTestBase.class, "createCache", new Object[]{lnPort});
        vm6.invoke(WANTestBase.class, "createCache", new Object[]{lnPort});
        vm7.invoke(WANTestBase.class, "createCache", new Object[]{lnPort});
        vm4.invoke(WANTestBase.class, "createConcurrentAsyncEventQueue", new Object[]{"ln", true, 100, 100, true, false, null, false, 3, Gateway.OrderPolicy.PARTITION});
        vm5.invoke(WANTestBase.class, "createConcurrentAsyncEventQueue", new Object[]{"ln", true, 100, 100, true, false, null, false, 3, Gateway.OrderPolicy.PARTITION});
        vm6.invoke(WANTestBase.class, "createConcurrentAsyncEventQueue", new Object[]{"ln", true, 100, 100, true, false, null, false, 3, Gateway.OrderPolicy.PARTITION});
        vm7.invoke(WANTestBase.class, "createConcurrentAsyncEventQueue", new Object[]{"ln", true, 100, 100, true, false, null, false, 3, Gateway.OrderPolicy.PARTITION});
        vm4.invoke(WANTestBase.class, "createPartitionedRegionWithAsyncEventQueue", new Object[]{testName + "_PR", "ln", this.isOffHeap()});
        vm5.invoke(WANTestBase.class, "createPartitionedRegionWithAsyncEventQueue", new Object[]{testName + "_PR", "ln", this.isOffHeap()});
        vm6.invoke(WANTestBase.class, "createPartitionedRegionWithAsyncEventQueue", new Object[]{testName + "_PR", "ln", this.isOffHeap()});
        vm7.invoke(WANTestBase.class, "createPartitionedRegionWithAsyncEventQueue", new Object[]{testName + "_PR", "ln", this.isOffHeap()});
        vm4.invoke(WANTestBase.class, "doPuts", new Object[]{testName + "_PR", 1000});
        vm4.invoke(WANTestBase.class, "waitForAsyncQueueToGetEmpty", new Object[]{"ln"});
        vm5.invoke(WANTestBase.class, "waitForAsyncQueueToGetEmpty", new Object[]{"ln"});
        vm6.invoke(WANTestBase.class, "waitForAsyncQueueToGetEmpty", new Object[]{"ln"});
        vm7.invoke(WANTestBase.class, "waitForAsyncQueueToGetEmpty", new Object[]{"ln"});
        int vm4size = (Integer)vm4.invoke(WANTestBase.class, "getAsyncEventListenerMapSize", new Object[]{"ln"});
        int vm5size = (Integer)vm5.invoke(WANTestBase.class, "getAsyncEventListenerMapSize", new Object[]{"ln"});
        int vm6size = (Integer)vm6.invoke(WANTestBase.class, "getAsyncEventListenerMapSize", new Object[]{"ln"});
        int vm7size = (Integer)vm7.invoke(WANTestBase.class, "getAsyncEventListenerMapSize", new Object[]{"ln"});
        ConcurrentAsyncEventQueueDUnitTest.assertEquals((int)1000, (int)(vm4size + vm5size + vm6size + vm7size));
    }
}

