/*
 * Decompiled with CFR 0.152.
 */
package com.gemstone.gemfire.internal.cache.wan.misc;

import com.gemstone.gemfire.cache.CacheClosedException;
import com.gemstone.gemfire.cache.DataPolicy;
import com.gemstone.gemfire.cache.Region;
import com.gemstone.gemfire.cache.Scope;
import com.gemstone.gemfire.internal.cache.ForceReattemptException;
import com.gemstone.gemfire.internal.cache.wan.WANTestBase;
import dunit.AsyncInvocation;
import dunit.DistributedTestCase;

public class ReplicatedRegion_ParallelWANPropogationDUnitTest
extends WANTestBase {
    final String expectedExceptions;
    private static final long serialVersionUID = 1L;

    public ReplicatedRegion_ParallelWANPropogationDUnitTest(String name) {
        super(name);
        this.expectedExceptions = null;
    }

    public void test_PGS_Started_DR_CREATED_NO_RECEIVER() throws Exception {
        try {
            Integer lnPort = (Integer)vm0.invoke(WANTestBase.class, "createFirstLocatorWithDSId", new Object[]{1});
            Integer nyPort = (Integer)vm1.invoke(WANTestBase.class, "createFirstRemoteLocator", new Object[]{2, lnPort});
            vm4.invoke(WANTestBase.class, "createCache", new Object[]{lnPort});
            vm4.invoke(WANTestBase.class, "createSender", new Object[]{"ln1", 2, true, 10, 100, false, false, null, false});
            vm4.invoke(WANTestBase.class, "createReplicatedRegion", new Object[]{testName + "_RR", "ln1", this.isOffHeap()});
            vm4.invoke(WANTestBase.class, "doPuts", new Object[]{testName + "_RR", 1000});
            vm4.invoke(WANTestBase.class, "validateQueueContents", new Object[]{"ln1", 1000});
        }
        catch (Exception e) {
            ReplicatedRegion_ParallelWANPropogationDUnitTest.fail("Unexpected exception", e);
        }
    }

    public void test_DR_CREATED_PGS_STARTED_NO_RECEIVER() throws Exception {
        try {
            Integer lnPort = (Integer)vm0.invoke(WANTestBase.class, "createFirstLocatorWithDSId", new Object[]{1});
            Integer nyPort = (Integer)vm1.invoke(WANTestBase.class, "createFirstRemoteLocator", new Object[]{2, lnPort});
            vm4.invoke(WANTestBase.class, "createCache", new Object[]{lnPort});
            vm4.invoke(WANTestBase.class, "createReplicatedRegion", new Object[]{testName + "_RR", "ln1", this.isOffHeap()});
            vm4.invoke(WANTestBase.class, "createSender", new Object[]{"ln1", 2, true, 10, 100, false, false, null, false});
            vm4.invoke(WANTestBase.class, "doPuts", new Object[]{testName + "_RR", 1000});
            vm4.invoke(WANTestBase.class, "validateQueueContents", new Object[]{"ln1", 1000});
        }
        catch (Exception e) {
            ReplicatedRegion_ParallelWANPropogationDUnitTest.fail("Unexpected exception", e);
        }
    }

    public void test_DR_PGS_1Node_Put_ValidateQueue_No_Receiver() throws Exception {
        try {
            Integer lnPort = (Integer)vm0.invoke(WANTestBase.class, "createFirstLocatorWithDSId", new Object[]{1});
            Integer nyPort = (Integer)vm1.invoke(WANTestBase.class, "createFirstRemoteLocator", new Object[]{2, lnPort});
            vm4.invoke(WANTestBase.class, "createCache", new Object[]{lnPort});
            vm4.invoke(WANTestBase.class, "createReplicatedRegion", new Object[]{testName + "_RR", "ln1", this.isOffHeap()});
            vm4.invoke(WANTestBase.class, "createSender", new Object[]{"ln1", 2, true, 10, 100, false, false, null, true});
            vm4.invoke(WANTestBase.class, "startSender", new Object[]{"ln1"});
            vm4.invoke(WANTestBase.class, "doPuts", new Object[]{testName + "_RR", 10000});
            vm4.invoke(WANTestBase.class, "validateRegionSize", new Object[]{testName + "_RR", 10000});
            vm4.invoke(WANTestBase.class, "validateQueueContents", new Object[]{"ln1", 10000});
        }
        catch (Exception e) {
            ReplicatedRegion_ParallelWANPropogationDUnitTest.fail("Unexpected exception", e);
        }
    }

    public void test_DR_PGS_2Nodes_Put_ValidateQueue_No_Receiver() throws Exception {
        try {
            Integer lnPort = (Integer)vm0.invoke(WANTestBase.class, "createFirstLocatorWithDSId", new Object[]{1});
            Integer nyPort = (Integer)vm1.invoke(WANTestBase.class, "createFirstRemoteLocator", new Object[]{2, lnPort});
            vm4.invoke(WANTestBase.class, "createCache", new Object[]{lnPort});
            vm5.invoke(WANTestBase.class, "createCache", new Object[]{lnPort});
            vm4.invoke(WANTestBase.class, "createReplicatedRegion", new Object[]{testName + "_RR", "ln1", this.isOffHeap()});
            vm5.invoke(WANTestBase.class, "createReplicatedRegion", new Object[]{testName + "_RR", "ln1", this.isOffHeap()});
            vm4.invoke(WANTestBase.class, "createSender", new Object[]{"ln1", 2, true, 10, 100, false, false, null, true});
            vm5.invoke(WANTestBase.class, "createSender", new Object[]{"ln1", 2, true, 10, 100, false, false, null, true});
            vm4.invoke(WANTestBase.class, "startSender", new Object[]{"ln1"});
            vm5.invoke(WANTestBase.class, "startSender", new Object[]{"ln1"});
            vm4.invoke(WANTestBase.class, "doPuts", new Object[]{testName + "_RR", 1000});
            vm4.invoke(WANTestBase.class, "validateRegionSize", new Object[]{testName + "_RR", 1000});
            vm5.invoke(WANTestBase.class, "validateRegionSize", new Object[]{testName + "_RR", 1000});
            vm4.invoke(WANTestBase.class, "validateQueueContents", new Object[]{"ln1", 1000});
            vm5.invoke(WANTestBase.class, "validateQueueContents", new Object[]{"ln1", 1000});
        }
        catch (Exception e) {
            ReplicatedRegion_ParallelWANPropogationDUnitTest.fail("Unexpected exception", e);
        }
    }

    public void test_DR_PGS_1Nodes_Put_Receiver() throws Exception {
        try {
            Integer lnPort = (Integer)vm0.invoke(WANTestBase.class, "createFirstLocatorWithDSId", new Object[]{1});
            Integer nyPort = (Integer)vm1.invoke(WANTestBase.class, "createFirstRemoteLocator", new Object[]{2, lnPort});
            vm2.invoke(WANTestBase.class, "createReceiver", new Object[]{nyPort});
            vm2.invoke(WANTestBase.class, "createReplicatedRegion", new Object[]{testName + "_RR", null, this.isOffHeap()});
            vm4.invoke(WANTestBase.class, "createCache", new Object[]{lnPort});
            vm4.invoke(WANTestBase.class, "createReplicatedRegion", new Object[]{testName + "_RR", "ln1", this.isOffHeap()});
            vm4.invoke(WANTestBase.class, "createSender", new Object[]{"ln1", 2, true, 10, 100, false, false, null, true});
            vm4.invoke(WANTestBase.class, "startSender", new Object[]{"ln1"});
            vm4.invoke(WANTestBase.class, "doPuts", new Object[]{testName + "_RR", 1000});
            vm4.invoke(WANTestBase.class, "validateRegionSize", new Object[]{testName + "_RR", 1000});
            vm4.invoke(WANTestBase.class, "validateQueueContents", new Object[]{"ln1", 0});
            vm2.invoke(WANTestBase.class, "validateRegionSize", new Object[]{testName + "_RR", 1000});
        }
        catch (Exception e) {
            ReplicatedRegion_ParallelWANPropogationDUnitTest.fail("Unexpected exception", e);
        }
    }

    public void test_DR_PGS_2Nodes_Put_Receiver() throws Exception {
        try {
            Integer lnPort = (Integer)vm0.invoke(WANTestBase.class, "createFirstLocatorWithDSId", new Object[]{1});
            Integer nyPort = (Integer)vm1.invoke(WANTestBase.class, "createFirstRemoteLocator", new Object[]{2, lnPort});
            vm2.invoke(WANTestBase.class, "createReceiver", new Object[]{nyPort});
            vm2.invoke(WANTestBase.class, "createReplicatedRegion", new Object[]{testName + "_RR", null, this.isOffHeap()});
            vm4.invoke(WANTestBase.class, "createCache", new Object[]{lnPort});
            vm5.invoke(WANTestBase.class, "createCache", new Object[]{lnPort});
            vm4.invoke(WANTestBase.class, "createReplicatedRegion", new Object[]{testName + "_RR", "ln1", this.isOffHeap()});
            vm5.invoke(WANTestBase.class, "createReplicatedRegion", new Object[]{testName + "_RR", "ln1", this.isOffHeap()});
            vm4.invoke(WANTestBase.class, "createSender", new Object[]{"ln1", 2, true, 10, 100, false, false, null, true});
            vm5.invoke(WANTestBase.class, "createSender", new Object[]{"ln1", 2, true, 10, 100, false, false, null, true});
            vm4.invoke(WANTestBase.class, "startSender", new Object[]{"ln1"});
            vm5.invoke(WANTestBase.class, "startSender", new Object[]{"ln1"});
            vm4.invoke(WANTestBase.class, "doPuts", new Object[]{testName + "_RR", 1000});
            vm4.invoke(WANTestBase.class, "validateRegionSize", new Object[]{testName + "_RR", 1000});
            vm5.invoke(WANTestBase.class, "validateRegionSize", new Object[]{testName + "_RR", 1000});
            vm4.invoke(WANTestBase.class, "validateQueueContents", new Object[]{"ln1", 0});
            vm5.invoke(WANTestBase.class, "validateQueueContents", new Object[]{"ln1", 0});
            vm2.invoke(WANTestBase.class, "validateRegionSize", new Object[]{testName + "_RR", 1000});
        }
        catch (Exception e) {
            ReplicatedRegion_ParallelWANPropogationDUnitTest.fail("Unexpected exception", e);
        }
    }

    public void test_DR_PGS_2Nodes_EMPTY_Put_Receiver() throws Exception {
        try {
            Integer lnPort = (Integer)vm0.invoke(WANTestBase.class, "createFirstLocatorWithDSId", new Object[]{1});
            Integer nyPort = (Integer)vm1.invoke(WANTestBase.class, "createFirstRemoteLocator", new Object[]{2, lnPort});
            vm2.invoke(WANTestBase.class, "createReceiver", new Object[]{nyPort});
            vm2.invoke(WANTestBase.class, "createReplicatedRegion", new Object[]{testName + "_RR", null, this.isOffHeap()});
            vm4.invoke(WANTestBase.class, "createCache", new Object[]{lnPort});
            vm5.invoke(WANTestBase.class, "createCache", new Object[]{lnPort});
            vm4.invoke(WANTestBase.class, "createReplicatedRegion", new Object[]{testName + "_RR", "ln1", Scope.DISTRIBUTED_ACK, DataPolicy.EMPTY, this.isOffHeap()});
            vm5.invoke(WANTestBase.class, "createReplicatedRegion", new Object[]{testName + "_RR", "ln1", Scope.DISTRIBUTED_ACK, DataPolicy.REPLICATE, this.isOffHeap()});
            vm4.invoke(WANTestBase.class, "createSender", new Object[]{"ln1", 2, true, 10, 100, false, false, null, true});
            vm5.invoke(WANTestBase.class, "createSender", new Object[]{"ln1", 2, true, 10, 100, false, false, null, true});
            vm4.invoke(WANTestBase.class, "startSender", new Object[]{"ln1"});
            vm5.invoke(WANTestBase.class, "startSender", new Object[]{"ln1"});
            vm4.invoke(WANTestBase.class, "doPuts", new Object[]{testName + "_RR", 1000});
            vm5.invoke(WANTestBase.class, "validateRegionSize", new Object[]{testName + "_RR", 1000});
            vm4.invoke(WANTestBase.class, "validateQueueContents", new Object[]{"ln1", 0});
            vm5.invoke(WANTestBase.class, "validateQueueContents", new Object[]{"ln1", 0});
            vm2.invoke(WANTestBase.class, "validateRegionSize", new Object[]{testName + "_RR", 1000});
        }
        catch (Exception e) {
            ReplicatedRegion_ParallelWANPropogationDUnitTest.fail("Unexpected exception", e);
        }
    }

    public void test_DR_PR_PGS_4Nodes_Put_Receiver_2Nodes() throws Exception {
        try {
            Integer lnPort = (Integer)vm0.invoke(WANTestBase.class, "createFirstLocatorWithDSId", new Object[]{1});
            Integer nyPort = (Integer)vm1.invoke(WANTestBase.class, "createFirstRemoteLocator", new Object[]{2, lnPort});
            vm2.invoke(WANTestBase.class, "createReceiver", new Object[]{nyPort});
            vm3.invoke(WANTestBase.class, "createReceiver", new Object[]{nyPort});
            vm2.invoke(WANTestBase.class, "createReplicatedRegion", new Object[]{testName + "_RR", null, this.isOffHeap()});
            vm3.invoke(WANTestBase.class, "createReplicatedRegion", new Object[]{testName + "_RR", null, this.isOffHeap()});
            vm2.invoke(WANTestBase.class, "createPartitionedRegion", new Object[]{testName + "_PR", null, 1, 100, this.isOffHeap()});
            vm3.invoke(WANTestBase.class, "createPartitionedRegion", new Object[]{testName + "_PR", null, 1, 100, this.isOffHeap()});
            vm4.invoke(WANTestBase.class, "createCache", new Object[]{lnPort});
            vm5.invoke(WANTestBase.class, "createCache", new Object[]{lnPort});
            vm6.invoke(WANTestBase.class, "createCache", new Object[]{lnPort});
            vm7.invoke(WANTestBase.class, "createCache", new Object[]{lnPort});
            vm4.invoke(WANTestBase.class, "createPartitionedRegion", new Object[]{testName + "_PR", "ln", 1, 100, this.isOffHeap()});
            vm5.invoke(WANTestBase.class, "createPartitionedRegion", new Object[]{testName + "_PR", "ln", 1, 100, this.isOffHeap()});
            vm6.invoke(WANTestBase.class, "createPartitionedRegion", new Object[]{testName + "_PR", "ln", 1, 100, this.isOffHeap()});
            vm7.invoke(WANTestBase.class, "createPartitionedRegion", new Object[]{testName + "_PR", "ln", 1, 100, this.isOffHeap()});
            vm4.invoke(WANTestBase.class, "createReplicatedRegion", new Object[]{testName + "_RR", "ln", this.isOffHeap()});
            vm5.invoke(WANTestBase.class, "createReplicatedRegion", new Object[]{testName + "_RR", "ln", this.isOffHeap()});
            vm6.invoke(WANTestBase.class, "createReplicatedRegion", new Object[]{testName + "_RR", "ln", this.isOffHeap()});
            vm7.invoke(WANTestBase.class, "createReplicatedRegion", new Object[]{testName + "_RR", "ln", this.isOffHeap()});
            vm4.invoke(WANTestBase.class, "createSender", new Object[]{"ln", 2, true, 10, 100, false, false, null, true});
            vm5.invoke(WANTestBase.class, "createSender", new Object[]{"ln", 2, true, 10, 100, false, false, null, true});
            vm6.invoke(WANTestBase.class, "createSender", new Object[]{"ln", 2, true, 10, 100, false, false, null, true});
            vm7.invoke(WANTestBase.class, "createSender", new Object[]{"ln", 2, true, 10, 100, false, false, null, true});
            vm4.invoke(WANTestBase.class, "startSender", new Object[]{"ln"});
            vm5.invoke(WANTestBase.class, "startSender", new Object[]{"ln"});
            vm6.invoke(WANTestBase.class, "startSender", new Object[]{"ln"});
            vm7.invoke(WANTestBase.class, "startSender", new Object[]{"ln"});
            vm4.invoke(WANTestBase.class, "waitForSenderRunningState", new Object[]{"ln"});
            vm5.invoke(WANTestBase.class, "waitForSenderRunningState", new Object[]{"ln"});
            vm6.invoke(WANTestBase.class, "waitForSenderRunningState", new Object[]{"ln"});
            vm7.invoke(WANTestBase.class, "waitForSenderRunningState", new Object[]{"ln"});
            vm4.invoke(WANTestBase.class, "doPuts", new Object[]{testName + "_RR", 1000});
            vm5.invoke(WANTestBase.class, "doNextPuts", new Object[]{testName + "_PR", 1000, 2000});
            vm4.invoke(WANTestBase.class, "validateRegionSize", new Object[]{testName + "_PR", 1000});
            vm5.invoke(WANTestBase.class, "validateRegionSize", new Object[]{testName + "_RR", 1000});
            vm4.invoke(WANTestBase.class, "validateQueueContents", new Object[]{"ln", 0});
            vm5.invoke(WANTestBase.class, "validateQueueContents", new Object[]{"ln", 0});
            vm2.invoke(WANTestBase.class, "validateRegionSize", new Object[]{testName + "_RR", 1000});
            vm3.invoke(WANTestBase.class, "validateRegionSize", new Object[]{testName + "_RR", 1000});
            vm2.invoke(WANTestBase.class, "validateRegionSize", new Object[]{testName + "_PR", 1000});
            vm3.invoke(WANTestBase.class, "validateRegionSize", new Object[]{testName + "_PR", 1000});
        }
        catch (Exception e) {
            ReplicatedRegion_ParallelWANPropogationDUnitTest.fail("Unexpected exception", e);
        }
    }

    public void test_DR_PGS_NOMANUALSTART_4Nodes_Put_ValidateReceiver() throws Exception {
        try {
            Integer lnPort = (Integer)vm0.invoke(WANTestBase.class, "createFirstLocatorWithDSId", new Object[]{1});
            Integer nyPort = (Integer)vm1.invoke(WANTestBase.class, "createFirstRemoteLocator", new Object[]{2, lnPort});
            vm2.invoke(WANTestBase.class, "createReceiver", new Object[]{nyPort});
            vm2.invoke(WANTestBase.class, "createReplicatedRegion", new Object[]{testName + "_RR", null, this.isOffHeap()});
            vm4.invoke(WANTestBase.class, "createCache", new Object[]{lnPort});
            vm5.invoke(WANTestBase.class, "createCache", new Object[]{lnPort});
            vm6.invoke(WANTestBase.class, "createCache", new Object[]{lnPort});
            vm7.invoke(WANTestBase.class, "createCache", new Object[]{lnPort});
            vm4.invoke(WANTestBase.class, "createSender", new Object[]{"ln1", 2, true, 10, 100, false, false, null, false});
            vm5.invoke(WANTestBase.class, "createSender", new Object[]{"ln1", 2, true, 10, 100, false, false, null, false});
            vm6.invoke(WANTestBase.class, "createSender", new Object[]{"ln1", 2, true, 10, 100, false, false, null, false});
            vm7.invoke(WANTestBase.class, "createSender", new Object[]{"ln1", 2, true, 10, 100, false, false, null, false});
            vm4.invoke(WANTestBase.class, "createReplicatedRegion", new Object[]{testName + "_RR", "ln1", this.isOffHeap()});
            vm5.invoke(WANTestBase.class, "createReplicatedRegion", new Object[]{testName + "_RR", "ln1", this.isOffHeap()});
            vm6.invoke(WANTestBase.class, "createReplicatedRegion", new Object[]{testName + "_RR", "ln1", this.isOffHeap()});
            vm7.invoke(WANTestBase.class, "createReplicatedRegion", new Object[]{testName + "_RR", "ln1", this.isOffHeap()});
            vm4.invoke(WANTestBase.class, "doPuts", new Object[]{testName + "_RR", 1000});
            vm4.invoke(WANTestBase.class, "validateRegionSize", new Object[]{testName + "_RR", 1000});
            vm5.invoke(WANTestBase.class, "validateRegionSize", new Object[]{testName + "_RR", 1000});
            vm6.invoke(WANTestBase.class, "validateRegionSize", new Object[]{testName + "_RR", 1000});
            vm7.invoke(WANTestBase.class, "validateRegionSize", new Object[]{testName + "_RR", 1000});
            vm4.invoke(WANTestBase.class, "validateQueueContents", new Object[]{"ln1", 0});
            vm5.invoke(WANTestBase.class, "validateQueueContents", new Object[]{"ln1", 0});
            vm6.invoke(WANTestBase.class, "validateQueueContents", new Object[]{"ln1", 0});
            vm7.invoke(WANTestBase.class, "validateQueueContents", new Object[]{"ln1", 0});
            vm2.invoke(WANTestBase.class, "validateRegionSize", new Object[]{testName + "_RR", 1000});
        }
        catch (Exception e) {
            ReplicatedRegion_ParallelWANPropogationDUnitTest.fail("Unexpected exception", e);
        }
    }

    public void test_DR_PGS_4Nodes_Put_CLOSE4NODESCACHE_RECREATE_PUT_ValidateReceiver() throws Exception {
        try {
            Integer lnPort = (Integer)vm0.invoke(WANTestBase.class, "createFirstLocatorWithDSId", new Object[]{1});
            Integer nyPort = (Integer)vm1.invoke(WANTestBase.class, "createFirstRemoteLocator", new Object[]{2, lnPort});
            vm2.invoke(WANTestBase.class, "createReceiver", new Object[]{nyPort});
            vm3.invoke(WANTestBase.class, "createReceiver", new Object[]{nyPort});
            vm4.invoke(WANTestBase.class, "createCache", new Object[]{lnPort});
            vm5.invoke(WANTestBase.class, "createCache", new Object[]{lnPort});
            vm6.invoke(WANTestBase.class, "createCache", new Object[]{lnPort});
            vm7.invoke(WANTestBase.class, "createCache", new Object[]{lnPort});
            vm4.invoke(WANTestBase.class, "createSender", new Object[]{"ln", 2, true, 100, 10, false, false, null, true});
            vm5.invoke(WANTestBase.class, "createSender", new Object[]{"ln", 2, true, 100, 10, false, false, null, true});
            vm6.invoke(WANTestBase.class, "createSender", new Object[]{"ln", 2, true, 100, 10, false, false, null, true});
            vm7.invoke(WANTestBase.class, "createSender", new Object[]{"ln", 2, true, 100, 10, false, false, null, true});
            vm4.invoke(WANTestBase.class, "createReplicatedRegion", new Object[]{testName + "_RR", "ln", this.isOffHeap()});
            vm5.invoke(WANTestBase.class, "createReplicatedRegion", new Object[]{testName + "_RR", "ln", this.isOffHeap()});
            vm6.invoke(WANTestBase.class, "createReplicatedRegion", new Object[]{testName + "_RR", "ln", this.isOffHeap()});
            vm7.invoke(WANTestBase.class, "createReplicatedRegion", new Object[]{testName + "_RR", "ln", this.isOffHeap()});
            vm4.invoke(WANTestBase.class, "startSender", new Object[]{"ln"});
            vm5.invoke(WANTestBase.class, "startSender", new Object[]{"ln"});
            vm6.invoke(WANTestBase.class, "startSender", new Object[]{"ln"});
            vm7.invoke(WANTestBase.class, "startSender", new Object[]{"ln"});
            vm2.invoke(WANTestBase.class, "createReplicatedRegion", new Object[]{testName + "_RR", null, this.isOffHeap()});
            vm3.invoke(WANTestBase.class, "createReplicatedRegion", new Object[]{testName + "_RR", null, this.isOffHeap()});
            vm4.invoke(WANTestBase.class, "waitForSenderRunningState", new Object[]{"ln"});
            vm5.invoke(WANTestBase.class, "waitForSenderRunningState", new Object[]{"ln"});
            vm6.invoke(WANTestBase.class, "waitForSenderRunningState", new Object[]{"ln"});
            vm7.invoke(WANTestBase.class, "waitForSenderRunningState", new Object[]{"ln"});
            vm4.invoke(WANTestBase.class, "doPuts", new Object[]{testName + "_RR", 1000});
            vm2.invoke(WANTestBase.class, "validateRegionSize", new Object[]{testName + "_RR", 1000});
            vm4.invoke(WANTestBase.class, "killSender", new Object[0]);
            vm5.invoke(WANTestBase.class, "killSender", new Object[0]);
            vm6.invoke(WANTestBase.class, "killSender", new Object[0]);
            vm7.invoke(WANTestBase.class, "killSender", new Object[0]);
            vm4.invoke(WANTestBase.class, "createCache", new Object[]{lnPort});
            vm5.invoke(WANTestBase.class, "createCache", new Object[]{lnPort});
            vm6.invoke(WANTestBase.class, "createCache", new Object[]{lnPort});
            vm7.invoke(WANTestBase.class, "createCache", new Object[]{lnPort});
            vm4.invoke(WANTestBase.class, "createSender", new Object[]{"ln", 2, true, 100, 10, false, false, null, true});
            vm5.invoke(WANTestBase.class, "createSender", new Object[]{"ln", 2, true, 100, 10, false, false, null, true});
            vm6.invoke(WANTestBase.class, "createSender", new Object[]{"ln", 2, true, 100, 10, false, false, null, true});
            vm7.invoke(WANTestBase.class, "createSender", new Object[]{"ln", 2, true, 100, 10, false, false, null, true});
            vm4.invoke(WANTestBase.class, "createReplicatedRegion", new Object[]{testName + "_RR", "ln", this.isOffHeap()});
            vm5.invoke(WANTestBase.class, "createReplicatedRegion", new Object[]{testName + "_RR", "ln", this.isOffHeap()});
            vm6.invoke(WANTestBase.class, "createReplicatedRegion", new Object[]{testName + "_RR", "ln", this.isOffHeap()});
            vm7.invoke(WANTestBase.class, "createReplicatedRegion", new Object[]{testName + "_RR", "ln", this.isOffHeap()});
            vm4.invoke(WANTestBase.class, "startSender", new Object[]{"ln"});
            vm5.invoke(WANTestBase.class, "startSender", new Object[]{"ln"});
            vm6.invoke(WANTestBase.class, "startSender", new Object[]{"ln"});
            vm7.invoke(WANTestBase.class, "startSender", new Object[]{"ln"});
            vm4.invoke(WANTestBase.class, "waitForSenderRunningState", new Object[]{"ln"});
            vm5.invoke(WANTestBase.class, "waitForSenderRunningState", new Object[]{"ln"});
            vm6.invoke(WANTestBase.class, "waitForSenderRunningState", new Object[]{"ln"});
            vm7.invoke(WANTestBase.class, "waitForSenderRunningState", new Object[]{"ln"});
            vm4.invoke(WANTestBase.class, "doNextPuts", new Object[]{testName + "_RR", 1000, 2000});
            vm4.invoke(WANTestBase.class, "validateParallelSenderQueueAllBucketsDrained", new Object[]{"ln"});
            vm5.invoke(WANTestBase.class, "validateParallelSenderQueueAllBucketsDrained", new Object[]{"ln"});
            vm6.invoke(WANTestBase.class, "validateParallelSenderQueueAllBucketsDrained", new Object[]{"ln"});
            vm7.invoke(WANTestBase.class, "validateParallelSenderQueueAllBucketsDrained", new Object[]{"ln"});
            vm2.invoke(WANTestBase.class, "validateRegionSize", new Object[]{testName + "_RR", 2000});
            vm3.invoke(WANTestBase.class, "validateRegionSize", new Object[]{testName + "_RR", 2000});
        }
        catch (Exception e) {
            ReplicatedRegion_ParallelWANPropogationDUnitTest.fail("Unexpected exception", e);
        }
    }

    public void test_DR_NO_ACK_PGS_2Nodes_Put_ValidateQueue_Receiver() throws Exception {
        try {
            Integer lnPort = (Integer)vm0.invoke(WANTestBase.class, "createFirstLocatorWithDSId", new Object[]{1});
            Integer nyPort = (Integer)vm1.invoke(WANTestBase.class, "createFirstRemoteLocator", new Object[]{2, lnPort});
            vm2.invoke(WANTestBase.class, "createReceiver", new Object[]{nyPort});
            vm2.invoke(WANTestBase.class, "createReplicatedRegion", new Object[]{testName + "_RR", null, this.isOffHeap()});
            vm4.invoke(WANTestBase.class, "createCache", new Object[]{lnPort});
            vm5.invoke(WANTestBase.class, "createCache", new Object[]{lnPort});
            vm4.invoke(WANTestBase.class, "createReplicatedRegion", new Object[]{testName + "_RR", "ln1", Scope.DISTRIBUTED_NO_ACK, DataPolicy.REPLICATE, this.isOffHeap()});
            vm5.invoke(WANTestBase.class, "createReplicatedRegion", new Object[]{testName + "_RR", "ln1", Scope.DISTRIBUTED_NO_ACK, DataPolicy.REPLICATE, this.isOffHeap()});
            vm4.invoke(WANTestBase.class, "createSender", new Object[]{"ln1", 2, true, 10, 100, false, false, null, true});
            vm5.invoke(WANTestBase.class, "createSender", new Object[]{"ln1", 2, true, 10, 100, false, false, null, true});
            vm4.invoke(WANTestBase.class, "startSender", new Object[]{"ln1"});
            vm5.invoke(WANTestBase.class, "startSender", new Object[]{"ln1"});
            vm4.invoke(WANTestBase.class, "doPuts", new Object[]{testName + "_RR", 1000});
            vm4.invoke(WANTestBase.class, "validateRegionSize", new Object[]{testName + "_RR", 1000});
            vm5.invoke(WANTestBase.class, "validateRegionSize", new Object[]{testName + "_RR", 1000});
            vm4.invoke(WANTestBase.class, "validateQueueContents", new Object[]{"ln1", 0});
            vm5.invoke(WANTestBase.class, "validateQueueContents", new Object[]{"ln1", 0});
            vm2.invoke(WANTestBase.class, "validateRegionSize", new Object[]{testName + "_RR", 1000});
        }
        catch (Exception e) {
            ReplicatedRegion_ParallelWANPropogationDUnitTest.fail("Unexpected exception", e);
        }
    }

    public void test_DR_PGS_2NODES_1NODESDOWN_Validate_Receiver() throws Exception {
        Integer lnPort = (Integer)vm0.invoke(WANTestBase.class, "createFirstLocatorWithDSId", new Object[]{1});
        Integer nyPort = (Integer)vm1.invoke(WANTestBase.class, "createFirstRemoteLocator", new Object[]{2, lnPort});
        vm2.invoke(WANTestBase.class, "createReceiver", new Object[]{nyPort});
        vm3.invoke(WANTestBase.class, "createReceiver", new Object[]{nyPort});
        vm4.invoke(WANTestBase.class, "createCache", new Object[]{lnPort});
        vm5.invoke(WANTestBase.class, "createCache", new Object[]{lnPort});
        vm4.invoke(WANTestBase.class, "createSender", new Object[]{"ln", 2, true, 100, 10, false, false, null, true});
        vm5.invoke(WANTestBase.class, "createSender", new Object[]{"ln", 2, true, 100, 10, false, false, null, true});
        vm4.invoke(WANTestBase.class, "createReplicatedRegion", new Object[]{testName + "_RR", "ln", this.isOffHeap()});
        vm5.invoke(WANTestBase.class, "createReplicatedRegion", new Object[]{testName + "_RR", "ln", this.isOffHeap()});
        vm4.invoke(WANTestBase.class, "startSender", new Object[]{"ln"});
        vm5.invoke(WANTestBase.class, "startSender", new Object[]{"ln"});
        vm2.invoke(WANTestBase.class, "createReplicatedRegion", new Object[]{testName + "_RR", "ln", this.isOffHeap()});
        vm3.invoke(WANTestBase.class, "createReplicatedRegion", new Object[]{testName + "_RR", "ln", this.isOffHeap()});
        vm4.invoke(WANTestBase.class, "waitForSenderRunningState", new Object[]{"ln"});
        vm5.invoke(WANTestBase.class, "waitForSenderRunningState", new Object[]{"ln"});
        ReplicatedRegion_ParallelWANPropogationDUnitTest.pauseWaitCriteria(60000L);
        AsyncInvocation inv1 = vm4.invokeAsync(ReplicatedRegion_ParallelWANPropogationDUnitTest.class, "doPuts0", new Object[]{testName + "_RR", 1000});
        ReplicatedRegion_ParallelWANPropogationDUnitTest.pause(1000);
        AsyncInvocation inv2 = vm5.invokeAsync(WANTestBase.class, "killSender");
        try {
            inv1.join();
            inv2.join();
        }
        catch (Exception e) {
            ReplicatedRegion_ParallelWANPropogationDUnitTest.fail("UnExpected Exception", e);
        }
        Integer size = (Integer)vm4.invoke(WANTestBase.class, "getQueueContentSize", new Object[]{"ln"});
        ReplicatedRegion_ParallelWANPropogationDUnitTest.getLogWriter().info("The size of the queue is in vm4 " + size);
        vm4.invoke(WANTestBase.class, "validateParallelSenderQueueAllBucketsDrained", new Object[]{"ln"});
        size = (Integer)vm4.invoke(WANTestBase.class, "getQueueContentSize", new Object[]{"ln"});
        ReplicatedRegion_ParallelWANPropogationDUnitTest.getLogWriter().info("The size of the queue is in vm4 " + size);
        vm2.invoke(WANTestBase.class, "validateRegionSize", new Object[]{testName + "_RR", 1000});
    }

    public void test_DR_PGS_4NODES_2NODESDOWN_Validate_Receiver() throws Exception {
        Integer lnPort = (Integer)vm0.invoke(WANTestBase.class, "createFirstLocatorWithDSId", new Object[]{1});
        Integer nyPort = (Integer)vm1.invoke(WANTestBase.class, "createFirstRemoteLocator", new Object[]{2, lnPort});
        vm2.invoke(WANTestBase.class, "createReceiver", new Object[]{nyPort});
        vm3.invoke(WANTestBase.class, "createReceiver", new Object[]{nyPort});
        vm4.invoke(WANTestBase.class, "createCache", new Object[]{lnPort});
        vm5.invoke(WANTestBase.class, "createCache", new Object[]{lnPort});
        vm6.invoke(WANTestBase.class, "createCache", new Object[]{lnPort});
        vm7.invoke(WANTestBase.class, "createCache", new Object[]{lnPort});
        vm4.invoke(WANTestBase.class, "createSender", new Object[]{"ln", 2, true, 100, 10, false, false, null, true});
        vm5.invoke(WANTestBase.class, "createSender", new Object[]{"ln", 2, true, 100, 10, false, false, null, true});
        vm6.invoke(WANTestBase.class, "createSender", new Object[]{"ln", 2, true, 100, 10, false, false, null, true});
        vm7.invoke(WANTestBase.class, "createSender", new Object[]{"ln", 2, true, 100, 10, false, false, null, true});
        vm4.invoke(WANTestBase.class, "createReplicatedRegion", new Object[]{testName + "_RR", "ln", this.isOffHeap()});
        vm5.invoke(WANTestBase.class, "createReplicatedRegion", new Object[]{testName + "_RR", "ln", this.isOffHeap()});
        vm6.invoke(WANTestBase.class, "createReplicatedRegion", new Object[]{testName + "_RR", "ln", this.isOffHeap()});
        vm7.invoke(WANTestBase.class, "createReplicatedRegion", new Object[]{testName + "_RR", "ln", this.isOffHeap()});
        vm4.invoke(WANTestBase.class, "startSender", new Object[]{"ln"});
        vm5.invoke(WANTestBase.class, "startSender", new Object[]{"ln"});
        vm6.invoke(WANTestBase.class, "startSender", new Object[]{"ln"});
        vm7.invoke(WANTestBase.class, "startSender", new Object[]{"ln"});
        vm2.invoke(WANTestBase.class, "createReplicatedRegion", new Object[]{testName + "_RR", "ln", this.isOffHeap()});
        vm3.invoke(WANTestBase.class, "createReplicatedRegion", new Object[]{testName + "_RR", "ln", this.isOffHeap()});
        vm4.invoke(WANTestBase.class, "waitForSenderRunningState", new Object[]{"ln"});
        vm5.invoke(WANTestBase.class, "waitForSenderRunningState", new Object[]{"ln"});
        vm6.invoke(WANTestBase.class, "waitForSenderRunningState", new Object[]{"ln"});
        vm7.invoke(WANTestBase.class, "waitForSenderRunningState", new Object[]{"ln"});
        ReplicatedRegion_ParallelWANPropogationDUnitTest.pauseWaitCriteria(60000L);
        AsyncInvocation inv1 = vm7.invokeAsync(ReplicatedRegion_ParallelWANPropogationDUnitTest.class, "doPuts0", new Object[]{testName + "_RR", 10000});
        ReplicatedRegion_ParallelWANPropogationDUnitTest.pauseWaitCriteria(1000L);
        AsyncInvocation inv2 = vm4.invokeAsync(WANTestBase.class, "killSender");
        ReplicatedRegion_ParallelWANPropogationDUnitTest.pauseWaitCriteria(2000L);
        AsyncInvocation inv3 = vm6.invokeAsync(ReplicatedRegion_ParallelWANPropogationDUnitTest.class, "doPuts1", new Object[]{testName + "_RR", 10000});
        ReplicatedRegion_ParallelWANPropogationDUnitTest.pauseWaitCriteria(1500L);
        AsyncInvocation inv4 = vm5.invokeAsync(WANTestBase.class, "killSender");
        try {
            inv1.join();
            inv2.join();
            inv3.join();
            inv4.join();
        }
        catch (Exception e) {
            ReplicatedRegion_ParallelWANPropogationDUnitTest.fail("UnExpected Exception", e);
        }
        vm6.invoke(WANTestBase.class, "validateParallelSenderQueueAllBucketsDrained", new Object[]{"ln"});
        vm7.invoke(WANTestBase.class, "validateParallelSenderQueueAllBucketsDrained", new Object[]{"ln"});
        vm2.invoke(WANTestBase.class, "validateRegionSize", new Object[]{testName + "_RR", 10000});
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void doPuts0(String regionName, int numPuts) {
        DistributedTestCase.ExpectedException exp = ReplicatedRegion_ParallelWANPropogationDUnitTest.addExpectedException(ForceReattemptException.class.getName());
        DistributedTestCase.ExpectedException exp1 = ReplicatedRegion_ParallelWANPropogationDUnitTest.addExpectedException(CacheClosedException.class.getName());
        try {
            Region r = cache.getRegion("/" + regionName);
            ReplicatedRegion_ParallelWANPropogationDUnitTest.assertNotNull((Object)r);
            for (long i = 0L; i < (long)numPuts; ++i) {
                ReplicatedRegion_ParallelWANPropogationDUnitTest.getLogWriter().info("Put : key : " + i);
                r.put((Object)i, (Object)("0_" + i));
            }
        }
        finally {
            exp.remove();
            exp1.remove();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void doPuts1(String regionName, int numPuts) {
        DistributedTestCase.ExpectedException exp = ReplicatedRegion_ParallelWANPropogationDUnitTest.addExpectedException(ForceReattemptException.class.getName());
        DistributedTestCase.ExpectedException exp1 = ReplicatedRegion_ParallelWANPropogationDUnitTest.addExpectedException(CacheClosedException.class.getName());
        try {
            Region r = cache.getRegion("/" + regionName);
            ReplicatedRegion_ParallelWANPropogationDUnitTest.assertNotNull((Object)r);
            for (long i = 0L; i < (long)numPuts; ++i) {
                ReplicatedRegion_ParallelWANPropogationDUnitTest.getLogWriter().info("Put : key : " + i);
                r.put((Object)i, (Object)("1_" + i));
            }
        }
        finally {
            exp.remove();
            exp1.remove();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void doPuts2(String regionName, int numPuts) {
        DistributedTestCase.ExpectedException exp = ReplicatedRegion_ParallelWANPropogationDUnitTest.addExpectedException(ForceReattemptException.class.getName());
        DistributedTestCase.ExpectedException exp1 = ReplicatedRegion_ParallelWANPropogationDUnitTest.addExpectedException(CacheClosedException.class.getName());
        try {
            Region r = cache.getRegion("/" + regionName);
            ReplicatedRegion_ParallelWANPropogationDUnitTest.assertNotNull((Object)r);
            for (long i = 0L; i < (long)numPuts; ++i) {
                ReplicatedRegion_ParallelWANPropogationDUnitTest.getLogWriter().info("Put : key : " + i);
                r.put((Object)i, (Object)("2_" + i));
            }
        }
        finally {
            exp.remove();
            exp1.remove();
        }
    }
}

