/*
 * Decompiled with CFR 0.152.
 */
package com.gemstone.gemfire.internal.cache.wan.misc;

import com.gemstone.gemfire.admin.AdminDistributedSystemFactory;
import com.gemstone.gemfire.admin.AdminException;
import com.gemstone.gemfire.admin.DistributedSystemConfig;
import com.gemstone.gemfire.admin.internal.AdminDistributedSystemImpl;
import com.gemstone.gemfire.cache.Region;
import com.gemstone.gemfire.distributed.DistributedSystem;
import com.gemstone.gemfire.internal.cache.wan.WANTestBase;
import dunit.AsyncInvocation;
import dunit.DistributedTestCase;
import dunit.SerializableRunnable;
import dunit.VM;
import java.util.Set;
import junit.framework.TestCase;

public class ShutdownAllPersistentGatewaySenderDUnitTest
extends WANTestBase {
    private static final long MAX_WAIT = 70000L;
    private static final int NUM_KEYS = 1000;
    private static final long serialVersionUID = 1L;

    public ShutdownAllPersistentGatewaySenderDUnitTest(String name) {
        super(name);
    }

    public void testGatewaySender() throws Exception {
        Integer lnPort = (Integer)vm0.invoke(WANTestBase.class, "createFirstLocatorWithDSId", new Object[]{1});
        Integer nyPort = (Integer)vm1.invoke(WANTestBase.class, "createFirstRemoteLocator", new Object[]{2, lnPort});
        vm2.invoke(WANTestBase.class, "createCache", new Object[]{nyPort});
        vm3.invoke(WANTestBase.class, "createCache", new Object[]{nyPort});
        vm2.invoke(WANTestBase.class, "createReceiverAfterCache", new Object[]{nyPort});
        vm2.invoke(WANTestBase.class, "createPersistentPartitionedRegion", new Object[]{testName + "_PR", "ln", 1, 100, this.isOffHeap()});
        vm3.invoke(WANTestBase.class, "createPersistentPartitionedRegion", new Object[]{testName + "_PR", "ln", 1, 100, this.isOffHeap()});
        vm4.invoke(WANTestBase.class, "createCache", new Object[]{lnPort});
        vm4.invoke(WANTestBase.class, "createSender", new Object[]{"ln", 2, false, 100, 400, false, false, null, true});
        vm4.invoke(WANTestBase.class, "startSender", new Object[]{"ln"});
        vm4.invoke(WANTestBase.class, "createPersistentPartitionedRegion", new Object[]{testName + "_PR", "ln", 1, 100, this.isOffHeap()});
        AsyncInvocation vm4_future = vm4.invokeAsync(WANTestBase.class, "doPuts", new Object[]{testName + "_PR", 1000});
        ShutdownAllPersistentGatewaySenderDUnitTest.pause(2000);
        this.shutDownAllMembers(vm2, 2, 70000L);
        ShutdownAllPersistentGatewaySenderDUnitTest.getLogWriter().info("restart in VM2");
        vm2.invoke(WANTestBase.class, "createCache", new Object[]{nyPort});
        vm3.invoke(WANTestBase.class, "createCache", new Object[]{nyPort});
        AsyncInvocation vm3_future = vm3.invokeAsync(WANTestBase.class, "createPersistentPartitionedRegion", new Object[]{testName + "_PR", "ln", 1, 100, this.isOffHeap()});
        vm2.invoke(WANTestBase.class, "createPersistentPartitionedRegion", new Object[]{testName + "_PR", "ln", 1, 100, this.isOffHeap()});
        vm3_future.join(70000L);
        vm3.invoke(new SerializableRunnable(){

            @Override
            public void run() {
                Region region = cache.getRegion(DistributedTestCase.testName + "_PR");
                cache.getLogger().info("vm1's region size before restart gatewayhub is " + region.size());
            }
        });
        vm2.invoke(WANTestBase.class, "createReceiverAfterCache", new Object[]{nyPort});
        vm4_future.join(70000L);
        vm4.invoke(new SerializableRunnable(){

            @Override
            public void run() {
                Region region = cache.getRegion(DistributedTestCase.testName + "_PR");
                TestCase.assertEquals((int)1000, (int)region.size());
            }
        });
        vm2.invoke(new SerializableRunnable(){

            @Override
            public void run() {
                final Region region = cache.getRegion(DistributedTestCase.testName + "_PR");
                cache.getLogger().info("vm1's region size after restart gatewayhub is " + region.size());
                DistributedTestCase.waitForCriterion(new DistributedTestCase.WaitCriterion(){

                    @Override
                    public boolean done() {
                        Object lastvalue = region.get((Object)999);
                        if (lastvalue != null && lastvalue.equals(999)) {
                            region.getCache().getLogger().info("Last key has arrived, its value is " + lastvalue + ", end of wait.");
                            return true;
                        }
                        return region.size() == 1000;
                    }

                    @Override
                    public String description() {
                        return "Waiting for destination region to reach size: 1000, current is " + region.size();
                    }
                }, 70000L, 100L, true);
                TestCase.assertEquals((int)1000, (int)region.size());
            }
        });
    }

    private void shutDownAllMembers(VM vm, final int expnum, final long timeout) {
        vm.invoke(new SerializableRunnable("Shutdown all the members"){

            @Override
            public void run() {
                AdminDistributedSystemImpl adminDS = null;
                try {
                    DistributedSystemConfig config = AdminDistributedSystemFactory.defineDistributedSystem((DistributedSystem)cache.getDistributedSystem(), (String)"");
                    adminDS = (AdminDistributedSystemImpl)AdminDistributedSystemFactory.getDistributedSystem((DistributedSystemConfig)config);
                    adminDS.connect();
                    Set members = adminDS.shutDownAllMembers(timeout);
                    int num = members == null ? 0 : members.size();
                    TestCase.assertEquals((int)expnum, (int)num);
                }
                catch (AdminException e) {
                    throw new RuntimeException(e);
                }
                finally {
                    if (adminDS != null) {
                        adminDS.disconnect();
                    }
                }
            }
        });
    }
}

