/*
 * Decompiled with CFR 0.152.
 */
package com.gemstone.gemfire.internal.cache.wan.misc;

import com.gemstone.gemfire.cache.Cache;
import com.gemstone.gemfire.cache.CacheFactory;
import com.gemstone.gemfire.cache.client.ClientCacheFactory;
import com.gemstone.gemfire.cache.client.PoolManager;
import com.gemstone.gemfire.cache.client.internal.Connection;
import com.gemstone.gemfire.cache.client.internal.PoolImpl;
import com.gemstone.gemfire.cache.server.CacheServer;
import com.gemstone.gemfire.cache.wan.GatewayReceiver;
import com.gemstone.gemfire.cache.wan.GatewayReceiverFactory;
import com.gemstone.gemfire.distributed.DistributedSystem;
import com.gemstone.gemfire.distributed.internal.InternalDistributedSystem;
import com.gemstone.gemfire.internal.AvailablePortHelper;
import com.gemstone.gemfire.internal.cache.PoolFactoryImpl;
import com.gemstone.gemfire.internal.cache.wan.WANTestBase;
import dunit.Host;
import java.io.IOException;
import java.util.Properties;

public class WANLocatorServerDUnitTest
extends WANTestBase {
    static PoolImpl proxy;

    public WANLocatorServerDUnitTest(String name) {
        super(name);
    }

    @Override
    public void setUp() throws Exception {
        super.setUp();
        Host host = Host.getHost(0);
    }

    public void test_3Locators_2Servers() {
        int port1 = AvailablePortHelper.getRandomAvailablePortForDUnitSite();
        int port2 = AvailablePortHelper.getRandomAvailablePortForDUnitSite();
        int port3 = AvailablePortHelper.getRandomAvailablePortForDUnitSite();
        vm0.invoke(WANLocatorServerDUnitTest.class, "createLocator", new Object[]{port1, port2, port3, port1});
        vm1.invoke(WANLocatorServerDUnitTest.class, "createLocator", new Object[]{port1, port2, port3, port2});
        vm2.invoke(WANLocatorServerDUnitTest.class, "createLocator", new Object[]{port1, port2, port3, port3});
        vm3.invoke(WANLocatorServerDUnitTest.class, "createReceiver", new Object[]{port1, port2, port3});
        vm5.invoke(WANLocatorServerDUnitTest.class, "createClient", new Object[]{port1, port2, port3});
        vm0.invoke(WANLocatorServerDUnitTest.class, "disconnect");
        vm1.invoke(WANLocatorServerDUnitTest.class, "disconnect");
        vm2.invoke(WANLocatorServerDUnitTest.class, "disconnect");
        vm0.invoke(WANLocatorServerDUnitTest.class, "createLocator", new Object[]{port1, port2, port3, port1});
        vm1.invoke(WANLocatorServerDUnitTest.class, "createLocator", new Object[]{port1, port2, port3, port2});
        vm2.invoke(WANLocatorServerDUnitTest.class, "createLocator", new Object[]{port1, port2, port3, port3});
        vm5.invoke(WANLocatorServerDUnitTest.class, "tryNewConnection");
    }

    public static void createLocator(Integer port1, Integer port2, Integer port3, Integer startingPort) {
        WANTestBase test = new WANTestBase(testName);
        Properties props = new Properties();
        props.setProperty("mcast-port", "0");
        props.setProperty("distributed-system-id", "1");
        props.setProperty("locators", "localhost[" + port1 + "],localhost[" + port2 + "],localhost[" + port3 + "]");
        props.setProperty("start-locator", "localhost[" + startingPort + "],server=true,peer=true,hostname-for-clients=localhost");
        test.getSystem(props);
    }

    public static void createReceiver(Integer port1, Integer port2, Integer port3) {
        WANTestBase test = new WANTestBase(testName);
        Properties props = new Properties();
        props.setProperty("mcast-port", "0");
        props.setProperty("locators", "localhost[" + port1 + "],localhost[" + port2 + "],localhost[" + port3 + "]");
        InternalDistributedSystem ds = test.getSystem(props);
        cache = CacheFactory.create((DistributedSystem)ds);
        GatewayReceiverFactory fact = cache.createGatewayReceiverFactory();
        int port = AvailablePortHelper.getRandomAvailablePortForDUnitSite();
        fact.setStartPort(port);
        fact.setEndPort(port);
        GatewayReceiver receiver = fact.create();
        try {
            receiver.start();
        }
        catch (IOException e) {
            e.printStackTrace();
            WANLocatorServerDUnitTest.fail((String)("Test " + test.getName() + " failed to start GatewayRecevier on port " + port));
        }
    }

    public static void createServer(Integer port1, Integer port2, Integer port3) {
        WANTestBase test = new WANTestBase(testName);
        Properties props = new Properties();
        props.setProperty("mcast-port", "0");
        props.setProperty("locators", "localhost[" + port1 + "],localhost[" + port2 + "],localhost[" + port3 + "]");
        InternalDistributedSystem ds = test.getSystem(props);
        cache = CacheFactory.create((DistributedSystem)ds);
        CacheServer server = cache.addCacheServer();
        int port = AvailablePortHelper.getRandomAvailablePortForDUnitSite();
        server.setPort(port);
        try {
            server.start();
        }
        catch (IOException e) {
            e.printStackTrace();
            WANLocatorServerDUnitTest.fail((String)("Test " + test.getName() + " failed to start CacheServer on port " + port));
        }
        WANLocatorServerDUnitTest.getLogWriter().info("Server Started on port : " + port + " : server : " + server);
    }

    public static void disconnect() {
        WANTestBase test = new WANTestBase(testName);
        test.getSystem().disconnect();
    }

    public static void createClient(Integer port1, Integer port2, Integer port3) {
        ClientCacheFactory cf = new ClientCacheFactory();
        cache = (Cache)cf.create();
        PoolFactoryImpl pf = (PoolFactoryImpl)PoolManager.createFactory();
        pf.setReadTimeout(0);
        pf.setIdleTimeout(-1L);
        pf.setMinConnections(4);
        pf.setServerGroup("__recv__group");
        Properties props = new Properties();
        String locators = "localhost[" + port1 + "],localhost[" + port2 + "],localhost[" + port3 + "]";
        props.setProperty("locators", locators);
        pf.init(props, false, true);
        proxy = (PoolImpl)pf.create("KISHOR_POOL");
        Connection con1 = proxy.acquireConnection();
        try {
            con1.close(true);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static void tryNewConnection() {
        Connection con1 = null;
        try {
            con1 = proxy.acquireConnection();
        }
        catch (Exception e) {
            WANLocatorServerDUnitTest.fail("No Exception expected", e);
        }
    }
}

