/*
 * Decompiled with CFR 0.152.
 */
package com.gemstone.gemfire.internal.cache.wan.misc;

import com.gemstone.gemfire.GemFireConfigException;
import com.gemstone.gemfire.IncompatibleSystemException;
import com.gemstone.gemfire.internal.AvailablePortHelper;
import com.gemstone.gemfire.internal.cache.wan.WANTestBase;
import dunit.AsyncInvocation;
import dunit.Host;
import java.net.InetSocketAddress;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Set;

public class WanAutoDiscoveryDUnitTest
extends WANTestBase {
    public WanAutoDiscoveryDUnitTest(String name) {
        super(name);
    }

    @Override
    public void setUp() throws Exception {
        super.setUp();
        Host host = Host.getHost(0);
    }

    public void test_GatewaySender_Started_Before_Locator() {
        block2: {
            try {
                int port = AvailablePortHelper.getRandomAvailablePortForDUnitSite();
                vm0.invoke(WANTestBase.class, "createCache", new Object[]{port});
                vm0.invoke(WANTestBase.class, "createSender", new Object[]{"ln", 2, false, 100, 10, false, false, null, false});
                WanAutoDiscoveryDUnitTest.fail((String)"Expected GemFireConfigException but not thrown");
            }
            catch (Exception e) {
                if (e.getCause() instanceof GemFireConfigException) break block2;
                WanAutoDiscoveryDUnitTest.fail("Expected GemFireConfigException but received :", e);
            }
        }
    }

    public void __test_AllLocatorsinDSShouldHaveDistributedSystemId() throws Exception {
        block2: {
            try {
                Integer lnLocPort1 = (Integer)vm0.invoke(WANTestBase.class, "createFirstLocatorWithDSId", new Object[]{1});
                Integer lnLocPort2 = (Integer)vm1.invoke(WANTestBase.class, "createSecondLocator", new Object[]{2, lnLocPort1});
                WanAutoDiscoveryDUnitTest.fail((String)"Expected IncompatibleSystemException but not thrown");
            }
            catch (Exception e) {
                if (e.getCause() instanceof IncompatibleSystemException) break block2;
                WanAutoDiscoveryDUnitTest.fail("Expected IncompatibleSystemException but received :", e);
            }
        }
    }

    public void test_NY_Recognises_ALL_LN_Locators() throws Exception {
        ArrayList<Integer> locatorPorts = new ArrayList<Integer>();
        HashMap<Integer, ArrayList<Integer>> dsVsPort = new HashMap<Integer, ArrayList<Integer>>();
        dsVsPort.put(1, locatorPorts);
        Integer lnLocPort1 = (Integer)vm0.invoke(WANTestBase.class, "createFirstLocatorWithDSId", new Object[]{1});
        locatorPorts.add(lnLocPort1);
        Integer lnLocPort2 = (Integer)vm1.invoke(WANTestBase.class, "createSecondLocator", new Object[]{1, lnLocPort1});
        locatorPorts.add(lnLocPort2);
        locatorPorts = new ArrayList();
        dsVsPort.put(2, locatorPorts);
        Integer nyLocPort1 = (Integer)vm2.invoke(WANTestBase.class, "createFirstRemoteLocator", new Object[]{2, lnLocPort1});
        locatorPorts.add(nyLocPort1);
        Integer nyLocPort2 = (Integer)vm3.invoke(WANTestBase.class, "createSecondRemoteLocator", new Object[]{2, nyLocPort1, lnLocPort1});
        locatorPorts.add(nyLocPort2);
        vm0.invoke(WANTestBase.class, "checkAllSiteMetaData", new Object[]{dsVsPort});
        vm1.invoke(WANTestBase.class, "checkAllSiteMetaData", new Object[]{dsVsPort});
        vm2.invoke(WANTestBase.class, "checkAllSiteMetaData", new Object[]{dsVsPort});
        vm3.invoke(WANTestBase.class, "checkAllSiteMetaData", new Object[]{dsVsPort});
    }

    public void test_NY_Recognises_TK_AND_HK_Through_LN_Locator() {
        HashMap dsVsPort = new HashMap();
        ArrayList<Integer> locatorPorts = new ArrayList<Integer>();
        dsVsPort.put(1, locatorPorts);
        Integer lnLocPort1 = (Integer)vm0.invoke(WANTestBase.class, "createFirstLocatorWithDSId", new Object[]{1});
        locatorPorts.add(lnLocPort1);
        locatorPorts = new ArrayList();
        dsVsPort.put(2, locatorPorts);
        Integer nyLocPort1 = (Integer)vm1.invoke(WANTestBase.class, "createFirstRemoteLocator", new Object[]{2, lnLocPort1});
        locatorPorts.add(nyLocPort1);
        locatorPorts = new ArrayList();
        dsVsPort.put(3, locatorPorts);
        Integer tkLocPort = (Integer)vm2.invoke(WANTestBase.class, "createFirstRemoteLocator", new Object[]{3, lnLocPort1});
        locatorPorts.add(tkLocPort);
        locatorPorts = new ArrayList();
        dsVsPort.put(4, locatorPorts);
        Integer hkLocPort = (Integer)vm3.invoke(WANTestBase.class, "createFirstRemoteLocator", new Object[]{4, lnLocPort1});
        locatorPorts.add(hkLocPort);
        vm0.invoke(WANTestBase.class, "checkAllSiteMetaData", new Object[]{dsVsPort});
        vm1.invoke(WANTestBase.class, "checkAllSiteMetaData", new Object[]{dsVsPort});
        vm2.invoke(WANTestBase.class, "checkAllSiteMetaData", new Object[]{dsVsPort});
        vm3.invoke(WANTestBase.class, "checkAllSiteMetaData", new Object[]{dsVsPort});
    }

    public void test_TK_Recognises_LN_AND_NY() {
        HashMap dsVsPort = new HashMap();
        ArrayList<Integer> locatorPorts = new ArrayList<Integer>();
        dsVsPort.put(1, locatorPorts);
        Integer lnLocPort1 = (Integer)vm0.invoke(WANTestBase.class, "createFirstLocatorWithDSId", new Object[]{1});
        locatorPorts.add(lnLocPort1);
        locatorPorts = new ArrayList();
        dsVsPort.put(2, locatorPorts);
        Integer nyLocPort1 = (Integer)vm1.invoke(WANTestBase.class, "createFirstRemoteLocator", new Object[]{2, lnLocPort1});
        locatorPorts.add(nyLocPort1);
        locatorPorts = new ArrayList();
        dsVsPort.put(3, locatorPorts);
        Integer tkLocPort = (Integer)vm2.invoke(WANTestBase.class, "createFirstRemoteLocator", new Object[]{3, nyLocPort1});
        locatorPorts.add(tkLocPort);
        vm0.invoke(WANTestBase.class, "checkAllSiteMetaData", new Object[]{dsVsPort});
        vm1.invoke(WANTestBase.class, "checkAllSiteMetaData", new Object[]{dsVsPort});
        vm2.invoke(WANTestBase.class, "checkAllSiteMetaData", new Object[]{dsVsPort});
    }

    public void test_NY_Recognises_TK_AND_HK_Simeltenously() {
        HashMap dsVsPort = new HashMap();
        ArrayList<Integer> locatorPortsln = new ArrayList<Integer>();
        dsVsPort.put(1, locatorPortsln);
        Integer lnLocPort1 = (Integer)vm0.invoke(WANTestBase.class, "createFirstLocatorWithDSId", new Object[]{1});
        locatorPortsln.add(lnLocPort1);
        ArrayList<Integer> locatorPortsny = new ArrayList<Integer>();
        dsVsPort.put(2, locatorPortsny);
        Integer nyLocPort1 = (Integer)vm1.invoke(WANTestBase.class, "createFirstRemoteLocator", new Object[]{2, lnLocPort1});
        locatorPortsny.add(nyLocPort1);
        int AsyncInvocationArrSize = 4;
        AsyncInvocation[] async = new AsyncInvocation[AsyncInvocationArrSize];
        ArrayList<Integer> locatorPortstk = new ArrayList<Integer>();
        dsVsPort.put(3, locatorPortstk);
        async[0] = vm2.invokeAsync(WANTestBase.class, "createFirstRemoteLocator", new Object[]{3, lnLocPort1});
        ArrayList<Integer> locatorPortshk = new ArrayList<Integer>();
        dsVsPort.put(4, locatorPortshk);
        async[1] = vm3.invokeAsync(WANTestBase.class, "createFirstRemoteLocator", new Object[]{4, nyLocPort1});
        ArrayList locatorPortsln2 = new ArrayList();
        async[2] = vm4.invokeAsync(WANTestBase.class, "createSecondLocator", new Object[]{1, lnLocPort1});
        ArrayList locatorPortsny2 = new ArrayList();
        async[3] = vm5.invokeAsync(WANTestBase.class, "createSecondLocator", new Object[]{2, nyLocPort1});
        try {
            async[0].join();
            async[1].join();
            async[2].join();
            async[3].join();
        }
        catch (InterruptedException e) {
            e.printStackTrace();
            WanAutoDiscoveryDUnitTest.fail();
        }
        locatorPortstk.add((Integer)async[0].getReturnValue());
        locatorPortshk.add((Integer)async[1].getReturnValue());
        locatorPortsln.add((Integer)async[2].getReturnValue());
        locatorPortsny.add((Integer)async[3].getReturnValue());
        vm0.invoke(WANTestBase.class, "checkAllSiteMetaData", new Object[]{dsVsPort});
        vm1.invoke(WANTestBase.class, "checkAllSiteMetaData", new Object[]{dsVsPort});
        vm2.invoke(WANTestBase.class, "checkAllSiteMetaData", new Object[]{dsVsPort});
        vm3.invoke(WANTestBase.class, "checkAllSiteMetaData", new Object[]{dsVsPort});
    }

    public void test_LN_Sender_recogises_ALL_NY_Locators() {
        Integer lnLocPort1 = (Integer)vm0.invoke(WANTestBase.class, "createFirstLocatorWithDSId", new Object[]{1});
        Integer lnLocPort2 = (Integer)vm5.invoke(WANTestBase.class, "createSecondLocator", new Object[]{1, lnLocPort1});
        vm2.invoke(WANTestBase.class, "createCache", new Object[]{lnLocPort1, lnLocPort2});
        vm2.invoke(WANTestBase.class, "createSender", new Object[]{"ln", 2, false, 100, 10, false, false, null, true});
        Integer nyLocPort1 = (Integer)vm1.invoke(WANTestBase.class, "createFirstRemoteLocator", new Object[]{2, lnLocPort1});
        vm2.invoke(WANTestBase.class, "startSender", new Object[]{"ln"});
        vm2.invoke(WANTestBase.class, "createReplicatedRegion", new Object[]{testName + "_RR", "ln", this.isOffHeap()});
        vm2.invoke(WANTestBase.class, "doPuts", new Object[]{testName + "_RR", 10});
        Integer nyLocPort2 = (Integer)vm3.invoke(WANTestBase.class, "createSecondRemoteLocator", new Object[]{2, nyLocPort1, lnLocPort1});
        InetSocketAddress locatorToWaitFor = new InetSocketAddress("localhost", (int)nyLocPort2);
        vm2.invoke(WANTestBase.class, "checkLocatorsinSender", new Object[]{"ln", locatorToWaitFor});
        Integer nyLocPort3 = (Integer)vm4.invoke(WANTestBase.class, "createSecondRemoteLocator", new Object[]{2, nyLocPort1, lnLocPort1});
        locatorToWaitFor = new InetSocketAddress("localhost", (int)nyLocPort3);
        vm2.invoke(WANTestBase.class, "checkLocatorsinSender", new Object[]{"ln", locatorToWaitFor});
    }

    public void test_RingTopology() {
        HashSet<String> site1LocatorsPort = new HashSet<String>();
        int site1Port1 = AvailablePortHelper.getRandomAvailablePortForDUnitSite();
        site1LocatorsPort.add("localhost[" + site1Port1 + "]");
        HashSet<String> site2LocatorsPort = new HashSet<String>();
        int site2Port1 = AvailablePortHelper.getRandomAvailablePortForDUnitSite();
        site2LocatorsPort.add("localhost[" + site2Port1 + "]");
        HashSet<String> site3LocatorsPort = new HashSet<String>();
        int site3Port1 = AvailablePortHelper.getRandomAvailablePortForDUnitSite();
        site3LocatorsPort.add("localhost[" + site3Port1 + "]");
        HashSet<String> site4LocatorsPort = new HashSet<String>();
        int site4Port1 = AvailablePortHelper.getRandomAvailablePortForDUnitSite();
        site4LocatorsPort.add("localhost[" + site4Port1 + "]");
        HashMap<Integer, HashSet<String>> dsVsPort = new HashMap<Integer, HashSet<String>>();
        dsVsPort.put(1, site1LocatorsPort);
        dsVsPort.put(2, site2LocatorsPort);
        dsVsPort.put(3, site3LocatorsPort);
        dsVsPort.put(4, site4LocatorsPort);
        int AsyncInvocationArrSize = 9;
        AsyncInvocation[] async = new AsyncInvocation[AsyncInvocationArrSize];
        async[0] = vm0.invokeAsync(WANTestBase.class, "createLocator", new Object[]{1, site1Port1, site1LocatorsPort, site2LocatorsPort});
        async[1] = vm1.invokeAsync(WANTestBase.class, "createLocator", new Object[]{2, site2Port1, site2LocatorsPort, site3LocatorsPort});
        async[2] = vm2.invokeAsync(WANTestBase.class, "createLocator", new Object[]{3, site3Port1, site3LocatorsPort, site4LocatorsPort});
        async[3] = vm3.invokeAsync(WANTestBase.class, "createLocator", new Object[]{4, site4Port1, site4LocatorsPort, site1LocatorsPort});
        try {
            async[0].join();
            async[1].join();
            async[2].join();
            async[3].join();
        }
        catch (InterruptedException e) {
            e.printStackTrace();
            WanAutoDiscoveryDUnitTest.fail((String)"Could not join async operations");
        }
        vm0.invoke(WANTestBase.class, "checkAllSiteMetaDataFor3Sites", new Object[]{dsVsPort});
        vm1.invoke(WANTestBase.class, "checkAllSiteMetaDataFor3Sites", new Object[]{dsVsPort});
        vm2.invoke(WANTestBase.class, "checkAllSiteMetaDataFor3Sites", new Object[]{dsVsPort});
        vm3.invoke(WANTestBase.class, "checkAllSiteMetaDataFor3Sites", new Object[]{dsVsPort});
    }

    public void ___test_3Sites3Locators() {
        HashSet<String> site1LocatorsPort = new HashSet<String>();
        int site1Port1 = AvailablePortHelper.getRandomAvailablePortForDUnitSite();
        site1LocatorsPort.add("localhost[" + site1Port1 + "]");
        int site1Port2 = AvailablePortHelper.getRandomAvailablePortForDUnitSite();
        site1LocatorsPort.add("localhost[" + site1Port2 + "]");
        int site1Port3 = AvailablePortHelper.getRandomAvailablePortForDUnitSite();
        site1LocatorsPort.add("localhost[" + site1Port3 + "]");
        HashSet<String> site2LocatorsPort = new HashSet<String>();
        int site2Port1 = AvailablePortHelper.getRandomAvailablePortForDUnitSite();
        site2LocatorsPort.add("localhost[" + site2Port1 + "]");
        int site2Port2 = AvailablePortHelper.getRandomAvailablePortForDUnitSite();
        site2LocatorsPort.add("localhost[" + site2Port2 + "]");
        int site2Port3 = AvailablePortHelper.getRandomAvailablePortForDUnitSite();
        site2LocatorsPort.add("localhost[" + site2Port3 + "]");
        HashSet<String> site3LocatorsPort = new HashSet<String>();
        int site3Port1 = AvailablePortHelper.getRandomAvailablePortForDUnitSite();
        site3LocatorsPort.add("localhost[" + site3Port1 + "]");
        int site3Port2 = AvailablePortHelper.getRandomAvailablePortForDUnitSite();
        site3LocatorsPort.add("localhost[" + site3Port2 + "]");
        int site3Port3 = AvailablePortHelper.getRandomAvailablePortForDUnitSite();
        site3LocatorsPort.add("localhost[" + site3Port3 + "]");
        HashMap<Integer, Set<String>> dsVsPort = new HashMap<Integer, Set<String>>();
        dsVsPort.put(1, site1LocatorsPort);
        dsVsPort.put(2, site2LocatorsPort);
        dsVsPort.put(3, site3LocatorsPort);
        int AsyncInvocationArrSize = 9;
        AsyncInvocation[] async = new AsyncInvocation[AsyncInvocationArrSize];
        async[0] = vm0.invokeAsync(WANTestBase.class, "createLocator", new Object[]{1, site1Port1, site1LocatorsPort, site2LocatorsPort});
        async[8] = vm0.invokeAsync(WANTestBase.class, "checkAllSiteMetaDataFor3Sites", new Object[]{dsVsPort});
        async[1] = vm1.invokeAsync(WANTestBase.class, "createLocator", new Object[]{1, site1Port2, site1LocatorsPort, site2LocatorsPort});
        async[2] = vm2.invokeAsync(WANTestBase.class, "createLocator", new Object[]{1, site1Port3, site1LocatorsPort, site2LocatorsPort});
        async[3] = vm3.invokeAsync(WANTestBase.class, "createLocator", new Object[]{2, site2Port1, site2LocatorsPort, site3LocatorsPort});
        async[4] = vm4.invokeAsync(WANTestBase.class, "createLocator", new Object[]{2, site2Port2, site2LocatorsPort, site3LocatorsPort});
        async[5] = vm5.invokeAsync(WANTestBase.class, "createLocator", new Object[]{2, site2Port3, site2LocatorsPort, site3LocatorsPort});
        async[6] = vm6.invokeAsync(WANTestBase.class, "createLocator", new Object[]{3, site3Port1, site3LocatorsPort, site1LocatorsPort});
        async[7] = vm7.invokeAsync(WANTestBase.class, "createLocator", new Object[]{3, site3Port2, site3LocatorsPort, site1LocatorsPort});
        WANTestBase.createLocator(3, site3Port3, site3LocatorsPort, site1LocatorsPort);
        long startTime = System.currentTimeMillis();
        try {
            async[0].join();
            async[1].join();
            async[2].join();
            async[3].join();
            async[4].join();
            async[5].join();
            async[6].join();
            async[7].join();
            async[8].join();
        }
        catch (InterruptedException e) {
            e.printStackTrace();
            WanAutoDiscoveryDUnitTest.fail((String)"Could not join async operations");
        }
        Long endTime = null;
        try {
            endTime = (Long)async[8].getResult();
        }
        catch (Throwable e) {
            e.printStackTrace();
            WanAutoDiscoveryDUnitTest.fail("Could not get end time", e);
        }
        WanAutoDiscoveryDUnitTest.getLogWriter().info("Time taken for all 9 locators discovery in 3 sites: " + (endTime - startTime));
        vm0.invoke(WANTestBase.class, "checkAllSiteMetaDataFor3Sites", new Object[]{dsVsPort});
        vm1.invoke(WANTestBase.class, "checkAllSiteMetaDataFor3Sites", new Object[]{dsVsPort});
        vm2.invoke(WANTestBase.class, "checkAllSiteMetaDataFor3Sites", new Object[]{dsVsPort});
        vm3.invoke(WANTestBase.class, "checkAllSiteMetaDataFor3Sites", new Object[]{dsVsPort});
        vm4.invoke(WANTestBase.class, "checkAllSiteMetaDataFor3Sites", new Object[]{dsVsPort});
        vm5.invoke(WANTestBase.class, "checkAllSiteMetaDataFor3Sites", new Object[]{dsVsPort});
        vm6.invoke(WANTestBase.class, "checkAllSiteMetaDataFor3Sites", new Object[]{dsVsPort});
        vm7.invoke(WANTestBase.class, "checkAllSiteMetaDataFor3Sites", new Object[]{dsVsPort});
        WANTestBase.checkAllSiteMetaDataFor3Sites(dsVsPort);
    }

    public void test_LN_Peer_Locators_Exchange_Information() {
        ArrayList<Integer> locatorPorts = new ArrayList<Integer>();
        HashMap<Integer, ArrayList<Integer>> dsVsPort = new HashMap<Integer, ArrayList<Integer>>();
        dsVsPort.put(1, locatorPorts);
        Integer lnLocPort1 = (Integer)vm0.invoke(WANTestBase.class, "createFirstPeerLocator", new Object[]{1});
        locatorPorts.add(lnLocPort1);
        Integer lnLocPort2 = (Integer)vm1.invoke(WANTestBase.class, "createSecondPeerLocator", new Object[]{1, lnLocPort1});
        locatorPorts.add(lnLocPort2);
        vm0.invoke(WANTestBase.class, "checkAllSiteMetaData", new Object[]{dsVsPort});
        vm1.invoke(WANTestBase.class, "checkAllSiteMetaData", new Object[]{dsVsPort});
    }

    public void test_LN_NY_TK_5_PeerLocators_1_ServerLocator() {
        HashMap dsVsPort = new HashMap();
        ArrayList<Integer> locatorPorts = new ArrayList<Integer>();
        dsVsPort.put(1, locatorPorts);
        Integer lnLocPort1 = (Integer)vm0.invoke(WANTestBase.class, "createFirstPeerLocator", new Object[]{1});
        locatorPorts.add(lnLocPort1);
        Integer lnLocPort2 = (Integer)vm1.invoke(WANTestBase.class, "createSecondPeerLocator", new Object[]{1, lnLocPort1});
        locatorPorts.add(lnLocPort2);
        locatorPorts = new ArrayList();
        dsVsPort.put(2, locatorPorts);
        Integer nyLocPort1 = (Integer)vm2.invoke(WANTestBase.class, "createFirstRemotePeerLocator", new Object[]{2, lnLocPort1});
        locatorPorts.add(nyLocPort1);
        Integer nyLocPort2 = (Integer)vm3.invoke(WANTestBase.class, "createSecondRemotePeerLocator", new Object[]{2, nyLocPort1, lnLocPort2});
        locatorPorts.add(nyLocPort2);
        locatorPorts = new ArrayList();
        dsVsPort.put(3, locatorPorts);
        Integer tkLocPort1 = (Integer)vm4.invoke(WANTestBase.class, "createFirstRemotePeerLocator", new Object[]{3, nyLocPort1});
        locatorPorts.add(tkLocPort1);
        Integer tkLocPort2 = (Integer)vm5.invoke(WANTestBase.class, "createSecondRemotePeerLocator", new Object[]{3, tkLocPort1, nyLocPort1});
        locatorPorts.add(tkLocPort2);
        Integer tkLocPort3 = (Integer)vm6.invoke(WANTestBase.class, "createSecondRemoteLocator", new Object[]{3, tkLocPort1, nyLocPort2});
        locatorPorts.add(tkLocPort3);
        vm0.invoke(WANTestBase.class, "checkAllSiteMetaData", new Object[]{dsVsPort});
        vm1.invoke(WANTestBase.class, "checkAllSiteMetaData", new Object[]{dsVsPort});
        vm2.invoke(WANTestBase.class, "checkAllSiteMetaData", new Object[]{dsVsPort});
        vm3.invoke(WANTestBase.class, "checkAllSiteMetaData", new Object[]{dsVsPort});
        vm4.invoke(WANTestBase.class, "checkAllSiteMetaData", new Object[]{dsVsPort});
        vm5.invoke(WANTestBase.class, "checkAllSiteMetaData", new Object[]{dsVsPort});
        vm6.invoke(WANTestBase.class, "checkAllSiteMetaData", new Object[]{dsVsPort});
    }
}

