/*
 * Decompiled with CFR 0.152.
 */
package com.gemstone.gemfire.internal.cache.wan.parallel;

import com.gemstone.gemfire.cache.Region;
import com.gemstone.gemfire.cache.RegionDestroyedException;
import com.gemstone.gemfire.internal.cache.wan.AbstractGatewaySender;
import com.gemstone.gemfire.internal.cache.wan.GatewaySenderException;
import com.gemstone.gemfire.internal.cache.wan.WANTestBase;
import dunit.AsyncInvocation;
import dunit.DistributedTestCase;
import dunit.RMIException;

public class ParallelGatewaySenderOperationsDUnitTest
extends WANTestBase {
    private static final long serialVersionUID = 1L;

    public ParallelGatewaySenderOperationsDUnitTest(String name) {
        super(name);
    }

    @Override
    public void setUp() throws Exception {
        super.setUp();
    }

    public void testParallelGatewaySenderWithoutStarting() {
        Integer lnPort = (Integer)vm0.invoke(WANTestBase.class, "createFirstLocatorWithDSId", new Object[]{1});
        Integer nyPort = (Integer)vm1.invoke(WANTestBase.class, "createFirstRemoteLocator", new Object[]{2, lnPort});
        vm2.invoke(WANTestBase.class, "createReceiver", new Object[]{nyPort});
        vm3.invoke(WANTestBase.class, "createReceiver", new Object[]{nyPort});
        vm4.invoke(WANTestBase.class, "createCache", new Object[]{lnPort});
        vm5.invoke(WANTestBase.class, "createCache", new Object[]{lnPort});
        vm6.invoke(WANTestBase.class, "createCache", new Object[]{lnPort});
        vm7.invoke(WANTestBase.class, "createCache", new Object[]{lnPort});
        vm4.invoke(WANTestBase.class, "createSender", new Object[]{"ln", 2, true, 100, 10, false, false, null, true});
        vm5.invoke(WANTestBase.class, "createSender", new Object[]{"ln", 2, true, 100, 10, false, false, null, true});
        vm6.invoke(WANTestBase.class, "createSender", new Object[]{"ln", 2, true, 100, 10, false, false, null, true});
        vm7.invoke(WANTestBase.class, "createSender", new Object[]{"ln", 2, true, 100, 10, false, false, null, true});
        vm4.invoke(WANTestBase.class, "createPartitionedRegion", new Object[]{testName + "_PR", "ln", 1, 100, this.isOffHeap()});
        vm5.invoke(WANTestBase.class, "createPartitionedRegion", new Object[]{testName + "_PR", "ln", 1, 100, this.isOffHeap()});
        vm6.invoke(WANTestBase.class, "createPartitionedRegion", new Object[]{testName + "_PR", "ln", 1, 100, this.isOffHeap()});
        vm7.invoke(WANTestBase.class, "createPartitionedRegion", new Object[]{testName + "_PR", "ln", 1, 100, this.isOffHeap()});
        vm2.invoke(WANTestBase.class, "createPartitionedRegion", new Object[]{testName + "_PR", null, 1, 100, this.isOffHeap()});
        vm3.invoke(WANTestBase.class, "createPartitionedRegion", new Object[]{testName + "_PR", null, 1, 100, this.isOffHeap()});
        vm4.invoke(WANTestBase.class, "doPuts", new Object[]{testName + "_PR", 1000});
        vm4.invoke(WANTestBase.class, "verifySenderStoppedState", new Object[]{"ln"});
        vm5.invoke(WANTestBase.class, "verifySenderStoppedState", new Object[]{"ln"});
        vm6.invoke(WANTestBase.class, "verifySenderStoppedState", new Object[]{"ln"});
        vm7.invoke(WANTestBase.class, "verifySenderStoppedState", new Object[]{"ln"});
        vm2.invoke(WANTestBase.class, "validateRegionSize", new Object[]{testName + "_PR", 0});
        vm3.invoke(WANTestBase.class, "validateRegionSize", new Object[]{testName + "_PR", 0});
    }

    public void testParallelGatewaySenderStartOnAccessorNode() {
        Integer lnPort = (Integer)vm0.invoke(WANTestBase.class, "createFirstLocatorWithDSId", new Object[]{1});
        Integer nyPort = (Integer)vm1.invoke(WANTestBase.class, "createFirstRemoteLocator", new Object[]{2, lnPort});
        vm2.invoke(WANTestBase.class, "createReceiver", new Object[]{nyPort});
        vm3.invoke(WANTestBase.class, "createReceiver", new Object[]{nyPort});
        vm4.invoke(WANTestBase.class, "createCache", new Object[]{lnPort});
        vm5.invoke(WANTestBase.class, "createCache", new Object[]{lnPort});
        vm6.invoke(WANTestBase.class, "createCache", new Object[]{lnPort});
        vm7.invoke(WANTestBase.class, "createCache", new Object[]{lnPort});
        vm4.invoke(WANTestBase.class, "createSender", new Object[]{"ln", 2, true, 100, 10, false, false, null, true});
        vm5.invoke(WANTestBase.class, "createSender", new Object[]{"ln", 2, true, 100, 10, false, false, null, true});
        vm6.invoke(WANTestBase.class, "createSender", new Object[]{"ln", 2, true, 100, 10, false, false, null, true});
        vm7.invoke(WANTestBase.class, "createSender", new Object[]{"ln", 2, true, 100, 10, false, false, null, true});
        vm4.invoke(WANTestBase.class, "createPartitionedRegion", new Object[]{testName + "_PR", "ln", 1, 100, this.isOffHeap()});
        vm5.invoke(WANTestBase.class, "createPartitionedRegion", new Object[]{testName + "_PR", "ln", 1, 100, this.isOffHeap()});
        vm6.invoke(WANTestBase.class, "createPartitionedRegionAsAccessor", new Object[]{testName + "_PR", "ln", 1, 100});
        vm7.invoke(WANTestBase.class, "createPartitionedRegionAsAccessor", new Object[]{testName + "_PR", "ln", 1, 100});
        vm2.invoke(WANTestBase.class, "createPartitionedRegion", new Object[]{testName + "_PR", null, 1, 100, this.isOffHeap()});
        vm3.invoke(WANTestBase.class, "createPartitionedRegion", new Object[]{testName + "_PR", null, 1, 100, this.isOffHeap()});
        vm4.invoke(WANTestBase.class, "startSender", new Object[]{"ln"});
        vm5.invoke(WANTestBase.class, "startSender", new Object[]{"ln"});
        vm6.invoke(WANTestBase.class, "startSender", new Object[]{"ln"});
        vm7.invoke(WANTestBase.class, "startSender", new Object[]{"ln"});
        ParallelGatewaySenderOperationsDUnitTest.pause(2000);
        vm6.invoke(WANTestBase.class, "waitForSenderRunningState", new Object[]{"ln"});
        vm7.invoke(WANTestBase.class, "waitForSenderRunningState", new Object[]{"ln"});
        vm4.invoke(WANTestBase.class, "doPuts", new Object[]{testName + "_PR", 1000});
        vm4.invoke(WANTestBase.class, "validateParallelSenderQueueAllBucketsDrained", new Object[]{"ln"});
        vm5.invoke(WANTestBase.class, "validateParallelSenderQueueAllBucketsDrained", new Object[]{"ln"});
        vm2.invoke(WANTestBase.class, "validateRegionSize", new Object[]{testName + "_PR", 1000});
        vm3.invoke(WANTestBase.class, "validateRegionSize", new Object[]{testName + "_PR", 1000});
    }

    public void testParallelPropagationSenderPause() throws Exception {
        Integer lnPort = (Integer)vm0.invoke(WANTestBase.class, "createFirstLocatorWithDSId", new Object[]{1});
        Integer nyPort = (Integer)vm1.invoke(WANTestBase.class, "createFirstRemoteLocator", new Object[]{2, lnPort});
        vm2.invoke(WANTestBase.class, "createReceiver", new Object[]{nyPort});
        vm3.invoke(WANTestBase.class, "createReceiver", new Object[]{nyPort});
        vm4.invoke(WANTestBase.class, "createCache", new Object[]{lnPort});
        vm5.invoke(WANTestBase.class, "createCache", new Object[]{lnPort});
        vm6.invoke(WANTestBase.class, "createCache", new Object[]{lnPort});
        vm7.invoke(WANTestBase.class, "createCache", new Object[]{lnPort});
        vm4.invoke(WANTestBase.class, "createSender", new Object[]{"ln", 2, true, 100, 10, false, false, null, true});
        vm5.invoke(WANTestBase.class, "createSender", new Object[]{"ln", 2, true, 100, 10, false, false, null, true});
        vm6.invoke(WANTestBase.class, "createSender", new Object[]{"ln", 2, true, 100, 10, false, false, null, true});
        vm7.invoke(WANTestBase.class, "createSender", new Object[]{"ln", 2, true, 100, 10, false, false, null, true});
        vm4.invoke(WANTestBase.class, "createPartitionedRegion", new Object[]{testName + "_PR", "ln", 1, 100, this.isOffHeap()});
        vm5.invoke(WANTestBase.class, "createPartitionedRegion", new Object[]{testName + "_PR", "ln", 1, 100, this.isOffHeap()});
        vm6.invoke(WANTestBase.class, "createPartitionedRegion", new Object[]{testName + "_PR", "ln", 1, 100, this.isOffHeap()});
        vm7.invoke(WANTestBase.class, "createPartitionedRegion", new Object[]{testName + "_PR", "ln", 1, 100, this.isOffHeap()});
        vm4.invoke(WANTestBase.class, "startSender", new Object[]{"ln"});
        vm5.invoke(WANTestBase.class, "startSender", new Object[]{"ln"});
        vm6.invoke(WANTestBase.class, "startSender", new Object[]{"ln"});
        vm7.invoke(WANTestBase.class, "startSender", new Object[]{"ln"});
        vm2.invoke(WANTestBase.class, "createPartitionedRegion", new Object[]{testName + "_PR", null, 1, 100, this.isOffHeap()});
        vm3.invoke(WANTestBase.class, "createPartitionedRegion", new Object[]{testName + "_PR", null, 1, 100, this.isOffHeap()});
        vm4.invoke(WANTestBase.class, "waitForSenderRunningState", new Object[]{"ln"});
        vm5.invoke(WANTestBase.class, "waitForSenderRunningState", new Object[]{"ln"});
        vm6.invoke(WANTestBase.class, "waitForSenderRunningState", new Object[]{"ln"});
        vm7.invoke(WANTestBase.class, "waitForSenderRunningState", new Object[]{"ln"});
        vm4.invoke(WANTestBase.class, "doPuts", new Object[]{testName + "_PR", 100});
        vm4.invoke(WANTestBase.class, "pauseSender", new Object[]{"ln"});
        vm5.invoke(WANTestBase.class, "pauseSender", new Object[]{"ln"});
        vm6.invoke(WANTestBase.class, "pauseSender", new Object[]{"ln"});
        vm7.invoke(WANTestBase.class, "pauseSender", new Object[]{"ln"});
        vm4.invokeAsync(WANTestBase.class, "doPuts", new Object[]{testName + "_PR", 1000});
        vm2.invoke(WANTestBase.class, "validateRegionSizeRemainsSame", new Object[]{testName + "_PR", 100});
    }

    public void testParallelPropagationSenderResume() throws Exception {
        Integer lnPort = (Integer)vm0.invoke(WANTestBase.class, "createFirstLocatorWithDSId", new Object[]{1});
        Integer nyPort = (Integer)vm1.invoke(WANTestBase.class, "createFirstRemoteLocator", new Object[]{2, lnPort});
        vm2.invoke(WANTestBase.class, "createReceiver", new Object[]{nyPort});
        vm3.invoke(WANTestBase.class, "createReceiver", new Object[]{nyPort});
        vm4.invoke(WANTestBase.class, "createCache", new Object[]{lnPort});
        vm5.invoke(WANTestBase.class, "createCache", new Object[]{lnPort});
        vm6.invoke(WANTestBase.class, "createCache", new Object[]{lnPort});
        vm7.invoke(WANTestBase.class, "createCache", new Object[]{lnPort});
        vm4.invoke(WANTestBase.class, "createSender", new Object[]{"ln", 2, true, 100, 10, false, false, null, true});
        vm5.invoke(WANTestBase.class, "createSender", new Object[]{"ln", 2, true, 100, 10, false, false, null, true});
        vm6.invoke(WANTestBase.class, "createSender", new Object[]{"ln", 2, true, 100, 10, false, false, null, true});
        vm7.invoke(WANTestBase.class, "createSender", new Object[]{"ln", 2, true, 100, 10, false, false, null, true});
        vm4.invoke(WANTestBase.class, "createPartitionedRegion", new Object[]{testName + "_PR", "ln", 1, 100, this.isOffHeap()});
        vm5.invoke(WANTestBase.class, "createPartitionedRegion", new Object[]{testName + "_PR", "ln", 1, 100, this.isOffHeap()});
        vm6.invoke(WANTestBase.class, "createPartitionedRegion", new Object[]{testName + "_PR", "ln", 1, 100, this.isOffHeap()});
        vm7.invoke(WANTestBase.class, "createPartitionedRegion", new Object[]{testName + "_PR", "ln", 1, 100, this.isOffHeap()});
        vm4.invoke(WANTestBase.class, "startSender", new Object[]{"ln"});
        vm5.invoke(WANTestBase.class, "startSender", new Object[]{"ln"});
        vm6.invoke(WANTestBase.class, "startSender", new Object[]{"ln"});
        vm7.invoke(WANTestBase.class, "startSender", new Object[]{"ln"});
        vm2.invoke(WANTestBase.class, "createPartitionedRegion", new Object[]{testName + "_PR", null, 1, 100, this.isOffHeap()});
        vm3.invoke(WANTestBase.class, "createPartitionedRegion", new Object[]{testName + "_PR", null, 1, 100, this.isOffHeap()});
        vm4.invoke(WANTestBase.class, "waitForSenderRunningState", new Object[]{"ln"});
        vm5.invoke(WANTestBase.class, "waitForSenderRunningState", new Object[]{"ln"});
        vm6.invoke(WANTestBase.class, "waitForSenderRunningState", new Object[]{"ln"});
        vm7.invoke(WANTestBase.class, "waitForSenderRunningState", new Object[]{"ln"});
        vm4.invokeAsync(WANTestBase.class, "doPuts", new Object[]{testName + "_PR", 1000});
        vm4.invoke(WANTestBase.class, "pauseSender", new Object[]{"ln"});
        vm5.invoke(WANTestBase.class, "pauseSender", new Object[]{"ln"});
        vm6.invoke(WANTestBase.class, "pauseSender", new Object[]{"ln"});
        vm7.invoke(WANTestBase.class, "pauseSender", new Object[]{"ln"});
        ParallelGatewaySenderOperationsDUnitTest.pause(2000);
        vm4.invoke(WANTestBase.class, "resumeSender", new Object[]{"ln"});
        vm5.invoke(WANTestBase.class, "resumeSender", new Object[]{"ln"});
        vm6.invoke(WANTestBase.class, "resumeSender", new Object[]{"ln"});
        vm7.invoke(WANTestBase.class, "resumeSender", new Object[]{"ln"});
        ParallelGatewaySenderOperationsDUnitTest.pause(2000);
        vm4.invoke(WANTestBase.class, "validateParallelSenderQueueAllBucketsDrained", new Object[]{"ln"});
        vm5.invoke(WANTestBase.class, "validateParallelSenderQueueAllBucketsDrained", new Object[]{"ln"});
        vm6.invoke(WANTestBase.class, "validateParallelSenderQueueAllBucketsDrained", new Object[]{"ln"});
        vm7.invoke(WANTestBase.class, "validateParallelSenderQueueAllBucketsDrained", new Object[]{"ln"});
        vm2.invoke(WANTestBase.class, "validateRegionSize", new Object[]{testName + "_PR", 1000});
    }

    public void testParallelPropagationSenderResumeNegativeScenario() throws Exception {
        Integer lnPort = (Integer)vm0.invoke(WANTestBase.class, "createFirstLocatorWithDSId", new Object[]{1});
        Integer nyPort = (Integer)vm1.invoke(WANTestBase.class, "createFirstRemoteLocator", new Object[]{2, lnPort});
        vm2.invoke(WANTestBase.class, "createReceiver", new Object[]{nyPort});
        vm3.invoke(WANTestBase.class, "createReceiver", new Object[]{nyPort});
        vm4.invoke(WANTestBase.class, "createCache", new Object[]{lnPort});
        vm5.invoke(WANTestBase.class, "createCache", new Object[]{lnPort});
        vm4.invoke(WANTestBase.class, "createSender", new Object[]{"ln", 2, true, 100, 10, false, false, null, true});
        vm5.invoke(WANTestBase.class, "createSender", new Object[]{"ln", 2, true, 100, 10, false, false, null, true});
        vm4.invoke(WANTestBase.class, "createPartitionedRegion", new Object[]{testName + "_PR", "ln", 1, 100, this.isOffHeap()});
        vm5.invoke(WANTestBase.class, "createPartitionedRegion", new Object[]{testName + "_PR", "ln", 1, 100, this.isOffHeap()});
        vm2.invoke(WANTestBase.class, "createPartitionedRegion", new Object[]{testName + "_PR", null, 1, 100, this.isOffHeap()});
        vm3.invoke(WANTestBase.class, "createPartitionedRegion", new Object[]{testName + "_PR", null, 1, 100, this.isOffHeap()});
        vm4.invoke(WANTestBase.class, "startSender", new Object[]{"ln"});
        vm5.invoke(WANTestBase.class, "startSender", new Object[]{"ln"});
        vm4.invoke(WANTestBase.class, "waitForSenderRunningState", new Object[]{"ln"});
        vm5.invoke(WANTestBase.class, "waitForSenderRunningState", new Object[]{"ln"});
        vm4.invoke(WANTestBase.class, "doPuts", new Object[]{testName + "_PR", 100});
        vm4.invoke(WANTestBase.class, "validateQueueContents", new Object[]{"ln", 0});
        vm4.invoke(WANTestBase.class, "stopSender", new Object[]{"ln"});
        vm5.invoke(WANTestBase.class, "stopSender", new Object[]{"ln"});
        vm4.invoke(WANTestBase.class, "resumeSender", new Object[]{"ln"});
        vm5.invoke(WANTestBase.class, "resumeSender", new Object[]{"ln"});
        vm4.invoke(WANTestBase.class, "doPuts", new Object[]{testName + "_PR", 1000});
        vm2.invoke(WANTestBase.class, "validateRegionSize", new Object[]{testName + "_PR", 100});
    }

    public void testParallelPropagationSenderStop() throws Exception {
        Integer lnPort = (Integer)vm0.invoke(WANTestBase.class, "createFirstLocatorWithDSId", new Object[]{1});
        Integer nyPort = (Integer)vm1.invoke(WANTestBase.class, "createFirstRemoteLocator", new Object[]{2, lnPort});
        vm2.invoke(WANTestBase.class, "createReceiver", new Object[]{nyPort});
        vm3.invoke(WANTestBase.class, "createReceiver", new Object[]{nyPort});
        vm4.invoke(WANTestBase.class, "createCache", new Object[]{lnPort});
        vm5.invoke(WANTestBase.class, "createCache", new Object[]{lnPort});
        vm6.invoke(WANTestBase.class, "createCache", new Object[]{lnPort});
        vm7.invoke(WANTestBase.class, "createCache", new Object[]{lnPort});
        vm4.invoke(WANTestBase.class, "createSender", new Object[]{"ln", 2, true, 100, 10, false, false, null, true});
        vm5.invoke(WANTestBase.class, "createSender", new Object[]{"ln", 2, true, 100, 10, false, false, null, true});
        vm6.invoke(WANTestBase.class, "createSender", new Object[]{"ln", 2, true, 100, 10, false, false, null, true});
        vm7.invoke(WANTestBase.class, "createSender", new Object[]{"ln", 2, true, 100, 10, false, false, null, true});
        vm4.invoke(WANTestBase.class, "createPartitionedRegion", new Object[]{testName + "_PR", "ln", 1, 100, this.isOffHeap()});
        vm5.invoke(WANTestBase.class, "createPartitionedRegion", new Object[]{testName + "_PR", "ln", 1, 100, this.isOffHeap()});
        vm6.invoke(WANTestBase.class, "createPartitionedRegion", new Object[]{testName + "_PR", "ln", 1, 100, this.isOffHeap()});
        vm7.invoke(WANTestBase.class, "createPartitionedRegion", new Object[]{testName + "_PR", "ln", 1, 100, this.isOffHeap()});
        vm4.invoke(WANTestBase.class, "startSender", new Object[]{"ln"});
        vm5.invoke(WANTestBase.class, "startSender", new Object[]{"ln"});
        vm6.invoke(WANTestBase.class, "startSender", new Object[]{"ln"});
        vm7.invoke(WANTestBase.class, "startSender", new Object[]{"ln"});
        vm2.invoke(WANTestBase.class, "createPartitionedRegion", new Object[]{testName + "_PR", null, 1, 100, this.isOffHeap()});
        vm3.invoke(WANTestBase.class, "createPartitionedRegion", new Object[]{testName + "_PR", null, 1, 100, this.isOffHeap()});
        vm4.invoke(WANTestBase.class, "waitForSenderRunningState", new Object[]{"ln"});
        vm5.invoke(WANTestBase.class, "waitForSenderRunningState", new Object[]{"ln"});
        vm6.invoke(WANTestBase.class, "waitForSenderRunningState", new Object[]{"ln"});
        vm7.invoke(WANTestBase.class, "waitForSenderRunningState", new Object[]{"ln"});
        vm4.invoke(WANTestBase.class, "doPuts", new Object[]{testName + "_PR", 100});
        vm4.invoke(WANTestBase.class, "stopSender", new Object[]{"ln"});
        vm5.invoke(WANTestBase.class, "stopSender", new Object[]{"ln"});
        vm6.invoke(WANTestBase.class, "stopSender", new Object[]{"ln"});
        vm7.invoke(WANTestBase.class, "stopSender", new Object[]{"ln"});
        vm4.invokeAsync(WANTestBase.class, "doPuts", new Object[]{testName + "_PR", 1000});
        vm2.invoke(WANTestBase.class, "validateRegionSizeRemainsSame", new Object[]{testName + "_PR", 100});
    }

    public void testParallelPropagationSenderStartAfterStop() throws Exception {
        Integer lnPort = (Integer)vm0.invoke(WANTestBase.class, "createFirstLocatorWithDSId", new Object[]{1});
        Integer nyPort = (Integer)vm1.invoke(WANTestBase.class, "createFirstRemoteLocator", new Object[]{2, lnPort});
        vm2.invoke(WANTestBase.class, "createReceiver", new Object[]{nyPort});
        vm3.invoke(WANTestBase.class, "createReceiver", new Object[]{nyPort});
        vm4.invoke(WANTestBase.class, "createCache", new Object[]{lnPort});
        vm5.invoke(WANTestBase.class, "createCache", new Object[]{lnPort});
        vm6.invoke(WANTestBase.class, "createCache", new Object[]{lnPort});
        vm7.invoke(WANTestBase.class, "createCache", new Object[]{lnPort});
        vm4.invoke(WANTestBase.class, "createSender", new Object[]{"ln", 2, true, 100, 10, false, false, null, true});
        vm5.invoke(WANTestBase.class, "createSender", new Object[]{"ln", 2, true, 100, 10, false, false, null, true});
        vm6.invoke(WANTestBase.class, "createSender", new Object[]{"ln", 2, true, 100, 10, false, false, null, true});
        vm7.invoke(WANTestBase.class, "createSender", new Object[]{"ln", 2, true, 100, 10, false, false, null, true});
        vm4.invoke(WANTestBase.class, "createPartitionedRegion", new Object[]{testName + "_PR", "ln", 1, 100, this.isOffHeap()});
        vm5.invoke(WANTestBase.class, "createPartitionedRegion", new Object[]{testName + "_PR", "ln", 1, 100, this.isOffHeap()});
        vm6.invoke(WANTestBase.class, "createPartitionedRegion", new Object[]{testName + "_PR", "ln", 1, 100, this.isOffHeap()});
        vm7.invoke(WANTestBase.class, "createPartitionedRegion", new Object[]{testName + "_PR", "ln", 1, 100, this.isOffHeap()});
        vm4.invoke(WANTestBase.class, "startSender", new Object[]{"ln"});
        vm5.invoke(WANTestBase.class, "startSender", new Object[]{"ln"});
        vm6.invoke(WANTestBase.class, "startSender", new Object[]{"ln"});
        vm7.invoke(WANTestBase.class, "startSender", new Object[]{"ln"});
        vm2.invoke(WANTestBase.class, "createPartitionedRegion", new Object[]{testName + "_PR", null, 1, 100, this.isOffHeap()});
        vm3.invoke(WANTestBase.class, "createPartitionedRegion", new Object[]{testName + "_PR", null, 1, 100, this.isOffHeap()});
        vm4.invoke(WANTestBase.class, "waitForSenderRunningState", new Object[]{"ln"});
        vm5.invoke(WANTestBase.class, "waitForSenderRunningState", new Object[]{"ln"});
        vm6.invoke(WANTestBase.class, "waitForSenderRunningState", new Object[]{"ln"});
        vm7.invoke(WANTestBase.class, "waitForSenderRunningState", new Object[]{"ln"});
        vm4.invoke(WANTestBase.class, "doPuts", new Object[]{testName + "_PR", 200});
        vm4.invoke(WANTestBase.class, "stopSender", new Object[]{"ln"});
        vm5.invoke(WANTestBase.class, "stopSender", new Object[]{"ln"});
        vm6.invoke(WANTestBase.class, "stopSender", new Object[]{"ln"});
        vm7.invoke(WANTestBase.class, "stopSender", new Object[]{"ln"});
        ParallelGatewaySenderOperationsDUnitTest.pause(2000);
        vm4.invoke(WANTestBase.class, "doPuts", new Object[]{testName + "_PR", 1000});
        vm2.invoke(WANTestBase.class, "validateRegionSizeRemainsSame", new Object[]{testName + "_PR", 200});
        vm4.invoke(WANTestBase.class, "startSender", new Object[]{"ln"});
        vm5.invoke(WANTestBase.class, "startSender", new Object[]{"ln"});
        vm6.invoke(WANTestBase.class, "startSender", new Object[]{"ln"});
        vm7.invoke(WANTestBase.class, "startSender", new Object[]{"ln"});
        vm2.invoke(WANTestBase.class, "validateRegionSizeRemainsSame", new Object[]{testName + "_PR", 200});
        AsyncInvocation async = vm4.invokeAsync(WANTestBase.class, "doPuts", new Object[]{testName + "_PR", 1000});
        async.join();
        ParallelGatewaySenderOperationsDUnitTest.pause(2000);
        vm4.invoke(WANTestBase.class, "validateParallelSenderQueueAllBucketsDrained", new Object[]{"ln"});
        vm5.invoke(WANTestBase.class, "validateParallelSenderQueueAllBucketsDrained", new Object[]{"ln"});
        vm6.invoke(WANTestBase.class, "validateParallelSenderQueueAllBucketsDrained", new Object[]{"ln"});
        vm7.invoke(WANTestBase.class, "validateParallelSenderQueueAllBucketsDrained", new Object[]{"ln"});
        vm2.invoke(WANTestBase.class, "validateRegionSize", new Object[]{testName + "_PR", 1000});
    }

    public void Bug47553_testParallelPropagationSenderStartAfterStop_Scenario2() throws Exception {
        Integer lnPort = (Integer)vm0.invoke(WANTestBase.class, "createFirstLocatorWithDSId", new Object[]{1});
        Integer nyPort = (Integer)vm1.invoke(WANTestBase.class, "createFirstRemoteLocator", new Object[]{2, lnPort});
        vm2.invoke(WANTestBase.class, "createReceiver", new Object[]{nyPort});
        vm3.invoke(WANTestBase.class, "createReceiver", new Object[]{nyPort});
        vm4.invoke(WANTestBase.class, "createCache", new Object[]{lnPort});
        vm5.invoke(WANTestBase.class, "createCache", new Object[]{lnPort});
        vm6.invoke(WANTestBase.class, "createCache", new Object[]{lnPort});
        vm7.invoke(WANTestBase.class, "createCache", new Object[]{lnPort});
        vm4.invoke(WANTestBase.class, "createSender", new Object[]{"ln", 2, true, 100, 10, false, false, null, true});
        vm5.invoke(WANTestBase.class, "createSender", new Object[]{"ln", 2, true, 100, 10, false, false, null, true});
        vm6.invoke(WANTestBase.class, "createSender", new Object[]{"ln", 2, true, 100, 10, false, false, null, true});
        vm7.invoke(WANTestBase.class, "createSender", new Object[]{"ln", 2, true, 100, 10, false, false, null, true});
        vm4.invoke(WANTestBase.class, "createPartitionedRegion", new Object[]{testName + "_PR", "ln", 1, 100, this.isOffHeap()});
        vm5.invoke(WANTestBase.class, "createPartitionedRegion", new Object[]{testName + "_PR", "ln", 1, 100, this.isOffHeap()});
        vm6.invoke(WANTestBase.class, "createPartitionedRegion", new Object[]{testName + "_PR", "ln", 1, 100, this.isOffHeap()});
        vm7.invoke(WANTestBase.class, "createPartitionedRegion", new Object[]{testName + "_PR", "ln", 1, 100, this.isOffHeap()});
        vm4.invoke(WANTestBase.class, "startSender", new Object[]{"ln"});
        vm5.invoke(WANTestBase.class, "startSender", new Object[]{"ln"});
        vm6.invoke(WANTestBase.class, "startSender", new Object[]{"ln"});
        vm7.invoke(WANTestBase.class, "startSender", new Object[]{"ln"});
        vm2.invoke(WANTestBase.class, "createPartitionedRegion", new Object[]{testName + "_PR", null, 1, 100, this.isOffHeap()});
        vm3.invoke(WANTestBase.class, "createPartitionedRegion", new Object[]{testName + "_PR", null, 1, 100, this.isOffHeap()});
        vm4.invoke(WANTestBase.class, "waitForSenderRunningState", new Object[]{"ln"});
        vm5.invoke(WANTestBase.class, "waitForSenderRunningState", new Object[]{"ln"});
        vm6.invoke(WANTestBase.class, "waitForSenderRunningState", new Object[]{"ln"});
        vm7.invoke(WANTestBase.class, "waitForSenderRunningState", new Object[]{"ln"});
        ParallelGatewaySenderOperationsDUnitTest.getLogWriter().info("All the senders are now started");
        vm4.invoke(WANTestBase.class, "doPuts", new Object[]{testName + "_PR", 200});
        ParallelGatewaySenderOperationsDUnitTest.getLogWriter().info("Done few puts");
        vm4.invoke(WANTestBase.class, "stopSender", new Object[]{"ln"});
        vm5.invoke(WANTestBase.class, "stopSender", new Object[]{"ln"});
        vm6.invoke(WANTestBase.class, "stopSender", new Object[]{"ln"});
        vm7.invoke(WANTestBase.class, "stopSender", new Object[]{"ln"});
        ParallelGatewaySenderOperationsDUnitTest.getLogWriter().info("All the senders are stopped");
        ParallelGatewaySenderOperationsDUnitTest.pause(2000);
        vm4.invoke(WANTestBase.class, "doPuts", new Object[]{testName + "_PR", 1000});
        ParallelGatewaySenderOperationsDUnitTest.getLogWriter().info("Done some more puts in second run");
        vm2.invoke(WANTestBase.class, "validateRegionSizeRemainsSame", new Object[]{testName + "_PR", 200});
        AsyncInvocation async = vm4.invokeAsync(WANTestBase.class, "doPuts", new Object[]{testName + "_PR", 5000});
        ParallelGatewaySenderOperationsDUnitTest.getLogWriter().info("Started high number of puts by async thread");
        ParallelGatewaySenderOperationsDUnitTest.getLogWriter().info("Starting the senders at the same time");
        vm4.invokeAsync(WANTestBase.class, "startSender", new Object[]{"ln"});
        vm5.invokeAsync(WANTestBase.class, "startSender", new Object[]{"ln"});
        vm6.invokeAsync(WANTestBase.class, "startSender", new Object[]{"ln"});
        vm7.invokeAsync(WANTestBase.class, "startSender", new Object[]{"ln"});
        ParallelGatewaySenderOperationsDUnitTest.getLogWriter().info("All the senders are started");
        async.join();
        ParallelGatewaySenderOperationsDUnitTest.pause(2000);
        vm4.invoke(WANTestBase.class, "validateParallelSenderQueueAllBucketsDrained", new Object[]{"ln"});
        vm5.invoke(WANTestBase.class, "validateParallelSenderQueueAllBucketsDrained", new Object[]{"ln"});
        vm6.invoke(WANTestBase.class, "validateParallelSenderQueueAllBucketsDrained", new Object[]{"ln"});
        vm7.invoke(WANTestBase.class, "validateParallelSenderQueueAllBucketsDrained", new Object[]{"ln"});
        vm4.invoke(WANTestBase.class, "validateQueueContents", new Object[]{"ln", 0});
    }

    public void testParallelPropagationSenderStartAfterStopOnAccessorNode() throws Exception {
        Integer lnPort = (Integer)vm0.invoke(WANTestBase.class, "createFirstLocatorWithDSId", new Object[]{1});
        Integer nyPort = (Integer)vm1.invoke(WANTestBase.class, "createFirstRemoteLocator", new Object[]{2, lnPort});
        vm2.invoke(WANTestBase.class, "createReceiver", new Object[]{nyPort});
        vm3.invoke(WANTestBase.class, "createReceiver", new Object[]{nyPort});
        vm4.invoke(WANTestBase.class, "createCache", new Object[]{lnPort});
        vm5.invoke(WANTestBase.class, "createCache", new Object[]{lnPort});
        vm6.invoke(WANTestBase.class, "createCache", new Object[]{lnPort});
        vm7.invoke(WANTestBase.class, "createCache", new Object[]{lnPort});
        vm4.invoke(WANTestBase.class, "createSender", new Object[]{"ln", 2, true, 100, 10, false, false, null, true});
        vm5.invoke(WANTestBase.class, "createSender", new Object[]{"ln", 2, true, 100, 10, false, false, null, true});
        vm6.invoke(WANTestBase.class, "createSender", new Object[]{"ln", 2, true, 100, 10, false, false, null, true});
        vm7.invoke(WANTestBase.class, "createSender", new Object[]{"ln", 2, true, 100, 10, false, false, null, true});
        vm4.invoke(WANTestBase.class, "createPartitionedRegion", new Object[]{testName + "_PR", "ln", 1, 100, this.isOffHeap()});
        vm5.invoke(WANTestBase.class, "createPartitionedRegion", new Object[]{testName + "_PR", "ln", 1, 100, this.isOffHeap()});
        vm6.invoke(WANTestBase.class, "createPartitionedRegionAsAccessor", new Object[]{testName + "_PR", "ln", 1, 100});
        vm7.invoke(WANTestBase.class, "createPartitionedRegionAsAccessor", new Object[]{testName + "_PR", "ln", 1, 100});
        vm4.invoke(WANTestBase.class, "startSender", new Object[]{"ln"});
        vm5.invoke(WANTestBase.class, "startSender", new Object[]{"ln"});
        vm6.invoke(WANTestBase.class, "startSender", new Object[]{"ln"});
        vm7.invoke(WANTestBase.class, "startSender", new Object[]{"ln"});
        vm2.invoke(WANTestBase.class, "createPartitionedRegion", new Object[]{testName + "_PR", null, 1, 100, this.isOffHeap()});
        vm3.invoke(WANTestBase.class, "createPartitionedRegion", new Object[]{testName + "_PR", null, 1, 100, this.isOffHeap()});
        vm4.invoke(WANTestBase.class, "waitForSenderRunningState", new Object[]{"ln"});
        vm5.invoke(WANTestBase.class, "waitForSenderRunningState", new Object[]{"ln"});
        vm6.invoke(WANTestBase.class, "waitForSenderRunningState", new Object[]{"ln"});
        vm7.invoke(WANTestBase.class, "waitForSenderRunningState", new Object[]{"ln"});
        vm4.invoke(WANTestBase.class, "doPuts", new Object[]{testName + "_PR", 200});
        vm4.invoke(WANTestBase.class, "stopSender", new Object[]{"ln"});
        vm5.invoke(WANTestBase.class, "stopSender", new Object[]{"ln"});
        vm6.invoke(WANTestBase.class, "stopSender", new Object[]{"ln"});
        vm7.invoke(WANTestBase.class, "stopSender", new Object[]{"ln"});
        ParallelGatewaySenderOperationsDUnitTest.pause(2000);
        vm4.invoke(WANTestBase.class, "doPuts", new Object[]{testName + "_PR", 1000});
        vm2.invoke(WANTestBase.class, "validateRegionSizeRemainsSame", new Object[]{testName + "_PR", 200});
        vm4.invoke(WANTestBase.class, "startSender", new Object[]{"ln"});
        vm5.invoke(WANTestBase.class, "startSender", new Object[]{"ln"});
        vm6.invoke(WANTestBase.class, "startSender", new Object[]{"ln"});
        vm7.invoke(WANTestBase.class, "startSender", new Object[]{"ln"});
        vm2.invoke(WANTestBase.class, "validateRegionSizeRemainsSame", new Object[]{testName + "_PR", 200});
        AsyncInvocation async = vm4.invokeAsync(WANTestBase.class, "doPuts", new Object[]{testName + "_PR", 1000});
        async.join();
        ParallelGatewaySenderOperationsDUnitTest.pause(5000);
        vm4.invoke(WANTestBase.class, "validateParallelSenderQueueAllBucketsDrained", new Object[]{"ln"});
        vm5.invoke(WANTestBase.class, "validateParallelSenderQueueAllBucketsDrained", new Object[]{"ln"});
        vm2.invoke(WANTestBase.class, "validateRegionSize", new Object[]{testName + "_PR", 1000});
    }

    public void testStartPauseResumeParallelGatewaySender() throws Exception {
        Integer lnPort = (Integer)vm0.invoke(WANTestBase.class, "createFirstLocatorWithDSId", new Object[]{1});
        Integer nyPort = (Integer)vm1.invoke(WANTestBase.class, "createFirstRemoteLocator", new Object[]{2, lnPort});
        vm2.invoke(WANTestBase.class, "createReceiver", new Object[]{nyPort});
        vm3.invoke(WANTestBase.class, "createReceiver", new Object[]{nyPort});
        vm4.invoke(WANTestBase.class, "createCache", new Object[]{lnPort});
        vm5.invoke(WANTestBase.class, "createCache", new Object[]{lnPort});
        vm6.invoke(WANTestBase.class, "createCache", new Object[]{lnPort});
        vm7.invoke(WANTestBase.class, "createCache", new Object[]{lnPort});
        ParallelGatewaySenderOperationsDUnitTest.getLogWriter().info("Created cache on local site");
        vm4.invoke(WANTestBase.class, "createSender", new Object[]{"ln", 2, true, 100, 10, false, false, null, true});
        vm5.invoke(WANTestBase.class, "createSender", new Object[]{"ln", 2, true, 100, 10, false, false, null, true});
        vm6.invoke(WANTestBase.class, "createSender", new Object[]{"ln", 2, true, 100, 10, false, false, null, true});
        vm7.invoke(WANTestBase.class, "createSender", new Object[]{"ln", 2, true, 100, 10, false, false, null, true});
        ParallelGatewaySenderOperationsDUnitTest.getLogWriter().info("Created senders on local site");
        vm4.invoke(WANTestBase.class, "createPartitionedRegion", new Object[]{testName + "_PR", "ln", 1, 100, this.isOffHeap()});
        vm5.invoke(WANTestBase.class, "createPartitionedRegion", new Object[]{testName + "_PR", "ln", 1, 100, this.isOffHeap()});
        vm6.invoke(WANTestBase.class, "createPartitionedRegion", new Object[]{testName + "_PR", "ln", 1, 100, this.isOffHeap()});
        vm7.invoke(WANTestBase.class, "createPartitionedRegion", new Object[]{testName + "_PR", "ln", 1, 100, this.isOffHeap()});
        ParallelGatewaySenderOperationsDUnitTest.getLogWriter().info("Created PRs on local site");
        vm2.invoke(WANTestBase.class, "createPartitionedRegion", new Object[]{testName + "_PR", null, 1, 100, this.isOffHeap()});
        vm3.invoke(WANTestBase.class, "createPartitionedRegion", new Object[]{testName + "_PR", null, 1, 100, this.isOffHeap()});
        ParallelGatewaySenderOperationsDUnitTest.getLogWriter().info("Created PRs on remote site");
        vm4.invoke(WANTestBase.class, "doPuts", new Object[]{testName + "_PR", 1000});
        ParallelGatewaySenderOperationsDUnitTest.getLogWriter().info("Done 1000 puts on local site");
        vm4.invokeAsync(WANTestBase.class, "startSender", new Object[]{"ln"});
        vm5.invokeAsync(WANTestBase.class, "startSender", new Object[]{"ln"});
        vm6.invokeAsync(WANTestBase.class, "startSender", new Object[]{"ln"});
        vm7.invokeAsync(WANTestBase.class, "startSender", new Object[]{"ln"});
        vm4.invoke(WANTestBase.class, "waitForSenderRunningState", new Object[]{"ln"});
        vm5.invoke(WANTestBase.class, "waitForSenderRunningState", new Object[]{"ln"});
        vm6.invoke(WANTestBase.class, "waitForSenderRunningState", new Object[]{"ln"});
        vm7.invoke(WANTestBase.class, "waitForSenderRunningState", new Object[]{"ln"});
        ParallelGatewaySenderOperationsDUnitTest.getLogWriter().info("Started senders on local site");
        vm4.invoke(WANTestBase.class, "doPuts", new Object[]{testName + "_PR", 5000});
        ParallelGatewaySenderOperationsDUnitTest.getLogWriter().info("Done 5000 puts on local site");
        vm4.invoke(WANTestBase.class, "pauseSender", new Object[]{"ln"});
        vm5.invoke(WANTestBase.class, "pauseSender", new Object[]{"ln"});
        vm6.invoke(WANTestBase.class, "pauseSender", new Object[]{"ln"});
        vm7.invoke(WANTestBase.class, "pauseSender", new Object[]{"ln"});
        ParallelGatewaySenderOperationsDUnitTest.getLogWriter().info("Paused senders on local site");
        vm4.invoke(WANTestBase.class, "verifySenderPausedState", new Object[]{"ln"});
        vm5.invoke(WANTestBase.class, "verifySenderPausedState", new Object[]{"ln"});
        vm6.invoke(WANTestBase.class, "verifySenderPausedState", new Object[]{"ln"});
        vm7.invoke(WANTestBase.class, "verifySenderPausedState", new Object[]{"ln"});
        AsyncInvocation inv1 = vm4.invokeAsync(WANTestBase.class, "doPuts", new Object[]{testName + "_PR", 1000});
        ParallelGatewaySenderOperationsDUnitTest.getLogWriter().info("Started 1000 async puts on local site");
        vm4.invoke(WANTestBase.class, "resumeSender", new Object[]{"ln"});
        vm5.invoke(WANTestBase.class, "resumeSender", new Object[]{"ln"});
        vm6.invoke(WANTestBase.class, "resumeSender", new Object[]{"ln"});
        vm7.invoke(WANTestBase.class, "resumeSender", new Object[]{"ln"});
        ParallelGatewaySenderOperationsDUnitTest.getLogWriter().info("Resumed senders on local site");
        vm4.invoke(WANTestBase.class, "verifySenderResumedState", new Object[]{"ln"});
        vm5.invoke(WANTestBase.class, "verifySenderResumedState", new Object[]{"ln"});
        vm6.invoke(WANTestBase.class, "verifySenderResumedState", new Object[]{"ln"});
        vm7.invoke(WANTestBase.class, "verifySenderResumedState", new Object[]{"ln"});
        try {
            inv1.join();
        }
        catch (InterruptedException e) {
            e.printStackTrace();
            ParallelGatewaySenderOperationsDUnitTest.fail((String)"Interrupted the async invocation.");
        }
        vm4.invoke(WANTestBase.class, "validateParallelSenderQueueAllBucketsDrained", new Object[]{"ln"});
        vm5.invoke(WANTestBase.class, "validateParallelSenderQueueAllBucketsDrained", new Object[]{"ln"});
        vm6.invoke(WANTestBase.class, "validateParallelSenderQueueAllBucketsDrained", new Object[]{"ln"});
        vm7.invoke(WANTestBase.class, "validateParallelSenderQueueAllBucketsDrained", new Object[]{"ln"});
        vm2.invoke(WANTestBase.class, "validateRegionSize", new Object[]{testName + "_PR", 5000});
        vm3.invoke(WANTestBase.class, "validateRegionSize", new Object[]{testName + "_PR", 5000});
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testParallelGatewaySender_SingleNode_UserPR_localDestroy_RecreateRegion() throws Exception {
        Integer lnPort = (Integer)vm0.invoke(WANTestBase.class, "createFirstLocatorWithDSId", new Object[]{1});
        Integer nyPort = (Integer)vm1.invoke(WANTestBase.class, "createFirstRemoteLocator", new Object[]{2, lnPort});
        vm2.invoke(WANTestBase.class, "createReceiver", new Object[]{nyPort});
        try {
            vm4.invoke(ParallelGatewaySenderOperationsDUnitTest.class, "createCache_INFINITE_MAXIMUM_SHUTDOWN_WAIT_TIME", new Object[]{lnPort});
            vm4.invoke(WANTestBase.class, "createSender", new Object[]{"ln", 2, true, 100, 10, false, false, null, false});
            vm4.invoke(WANTestBase.class, "startSender", new Object[]{"ln"});
            vm4.invoke(WANTestBase.class, "pauseSender", new Object[]{"ln"});
            vm4.invoke(WANTestBase.class, "createPartitionedRegion", new Object[]{testName + "_PR", "ln", 1, 10, this.isOffHeap()});
            ParallelGatewaySenderOperationsDUnitTest.getLogWriter().info("Created PRs on local site");
            vm2.invoke(WANTestBase.class, "createPartitionedRegion", new Object[]{testName + "_PR", null, 1, 10, this.isOffHeap()});
            vm4.invoke(WANTestBase.class, "doPuts", new Object[]{testName + "_PR", 10});
            vm4.invoke(WANTestBase.class, "validateRegionSize", new Object[]{testName + "_PR", 10});
            vm2.invoke(WANTestBase.class, "validateRegionSize", new Object[]{testName + "_PR", 0});
            vm4.invoke(WANTestBase.class, "localDestroyRegion", new Object[]{testName + "_PR"});
            vm2.invoke(WANTestBase.class, "validateRegionSize", new Object[]{testName + "_PR", 0});
            vm4.invoke(WANTestBase.class, "resumeSender", new Object[]{"ln"});
            vm4.invoke(WANTestBase.class, "createPartitionedRegion", new Object[]{testName + "_PR", "ln", 1, 10, this.isOffHeap()});
            vm4.invoke(WANTestBase.class, "doPutsFrom", new Object[]{testName + "_PR", 10, 20});
            vm4.invoke(WANTestBase.class, "validateRegionSize", new Object[]{testName + "_PR", 10});
            vm2.invoke(WANTestBase.class, "validateRegionSize", new Object[]{testName + "_PR", 10});
        }
        finally {
            vm4.invoke(ParallelGatewaySenderOperationsDUnitTest.class, "clear_INFINITE_MAXIMUM_SHUTDOWN_WAIT_TIME");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testParallelGatewaySender_SingleNode_UserPR_Destroy_RecreateRegion() throws Exception {
        Integer lnPort = (Integer)vm0.invoke(WANTestBase.class, "createFirstLocatorWithDSId", new Object[]{1});
        Integer nyPort = (Integer)vm1.invoke(WANTestBase.class, "createFirstRemoteLocator", new Object[]{2, lnPort});
        vm2.invoke(WANTestBase.class, "createReceiver", new Object[]{nyPort});
        try {
            vm4.invoke(ParallelGatewaySenderOperationsDUnitTest.class, "createCache_INFINITE_MAXIMUM_SHUTDOWN_WAIT_TIME", new Object[]{lnPort});
            vm4.invoke(WANTestBase.class, "createSender", new Object[]{"ln", 2, true, 100, 10, false, false, null, false});
            vm4.invoke(WANTestBase.class, "startSender", new Object[]{"ln"});
            vm4.invoke(WANTestBase.class, "pauseSender", new Object[]{"ln"});
            vm4.invoke(WANTestBase.class, "createPartitionedRegion", new Object[]{testName + "_PR", "ln", 1, 10, this.isOffHeap()});
            ParallelGatewaySenderOperationsDUnitTest.getLogWriter().info("Created PRs on local site");
            vm2.invoke(WANTestBase.class, "createPartitionedRegion", new Object[]{testName + "_PR", null, 1, 10, this.isOffHeap()});
            vm4.invoke(WANTestBase.class, "doPuts", new Object[]{testName + "_PR", 10});
            vm4.invoke(WANTestBase.class, "validateRegionSize", new Object[]{testName + "_PR", 10});
            vm2.invoke(WANTestBase.class, "validateRegionSize", new Object[]{testName + "_PR", 0});
            vm4.invoke(WANTestBase.class, "resumeSender", new Object[]{"ln"});
            vm4.invoke(WANTestBase.class, "destroyRegion", new Object[]{testName + "_PR"});
            vm2.invoke(WANTestBase.class, "validateRegionSize", new Object[]{testName + "_PR", 10});
            vm4.invoke(WANTestBase.class, "createPartitionedRegion", new Object[]{testName + "_PR", "ln", 1, 10, this.isOffHeap()});
            vm4.invoke(WANTestBase.class, "doPutsFrom", new Object[]{testName + "_PR", 10, 20});
            vm4.invoke(WANTestBase.class, "validateRegionSize", new Object[]{testName + "_PR", 10});
            vm2.invoke(WANTestBase.class, "validateRegionSize", new Object[]{testName + "_PR", 20});
        }
        finally {
            vm4.invoke(ParallelGatewaySenderOperationsDUnitTest.class, "clear_INFINITE_MAXIMUM_SHUTDOWN_WAIT_TIME");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testParallelGatewaySender_SingleNode_UserPR_Close_RecreateRegion() throws Exception {
        DistributedTestCase.ExpectedException exp = ParallelGatewaySenderOperationsDUnitTest.addExpectedException(RegionDestroyedException.class.getName());
        try {
            Integer lnPort = (Integer)vm0.invoke(WANTestBase.class, "createFirstLocatorWithDSId", new Object[]{1});
            Integer nyPort = (Integer)vm1.invoke(WANTestBase.class, "createFirstRemoteLocator", new Object[]{2, lnPort});
            vm2.invoke(WANTestBase.class, "createReceiver", new Object[]{nyPort});
            try {
                vm4.invoke(ParallelGatewaySenderOperationsDUnitTest.class, "createCache_INFINITE_MAXIMUM_SHUTDOWN_WAIT_TIME", new Object[]{lnPort});
                ParallelGatewaySenderOperationsDUnitTest.getLogWriter().info("Created cache on local site");
                ParallelGatewaySenderOperationsDUnitTest.getLogWriter().info("Created senders on local site");
                vm4.invoke(WANTestBase.class, "createSender", new Object[]{"ln", 2, true, 100, 10, false, false, null, false});
                vm4.invoke(WANTestBase.class, "startSender", new Object[]{"ln"});
                vm4.invoke(WANTestBase.class, "pauseSender", new Object[]{"ln"});
                vm4.invoke(WANTestBase.class, "createPartitionedRegion", new Object[]{testName + "_PR", "ln", 1, 10, this.isOffHeap()});
                ParallelGatewaySenderOperationsDUnitTest.getLogWriter().info("Created PRs on local site");
                vm2.invoke(WANTestBase.class, "createPartitionedRegion", new Object[]{testName + "_PR", null, 1, 10, this.isOffHeap()});
                vm4.invoke(WANTestBase.class, "doPuts", new Object[]{testName + "_PR", 10});
                vm4.invoke(WANTestBase.class, "validateRegionSize", new Object[]{testName + "_PR", 10});
                vm2.invoke(WANTestBase.class, "validateRegionSize", new Object[]{testName + "_PR", 0});
                vm4.invoke(ParallelGatewaySenderOperationsDUnitTest.class, "closeRegion", new Object[]{testName + "_PR"});
                vm4.invoke(WANTestBase.class, "resumeSender", new Object[]{"ln"});
                ParallelGatewaySenderOperationsDUnitTest.pause(500);
                vm2.invoke(WANTestBase.class, "validateRegionSize", new Object[]{testName + "_PR", 0});
                vm4.invoke(WANTestBase.class, "createPartitionedRegion", new Object[]{testName + "_PR", "ln", 1, 10, this.isOffHeap()});
                vm4.invoke(WANTestBase.class, "doPutsFrom", new Object[]{testName + "_PR", 10, 20});
                vm4.invoke(WANTestBase.class, "validateRegionSize", new Object[]{testName + "_PR", 10});
                vm2.invoke(WANTestBase.class, "validateRegionSize", new Object[]{testName + "_PR", 10});
            }
            finally {
                vm4.invoke(ParallelGatewaySenderOperationsDUnitTest.class, "clear_INFINITE_MAXIMUM_SHUTDOWN_WAIT_TIME");
            }
        }
        finally {
            exp.remove();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testParallelGatewaySender_SingleNode_UserPR_localDestroy_SimultenuousPut_RecreateRegion() throws Exception {
        Integer lnPort = (Integer)vm0.invoke(WANTestBase.class, "createFirstLocatorWithDSId", new Object[]{1});
        Integer nyPort = (Integer)vm1.invoke(WANTestBase.class, "createFirstRemoteLocator", new Object[]{2, lnPort});
        vm2.invoke(WANTestBase.class, "createReceiver", new Object[]{nyPort});
        try {
            vm4.invoke(ParallelGatewaySenderOperationsDUnitTest.class, "createCache_INFINITE_MAXIMUM_SHUTDOWN_WAIT_TIME", new Object[]{lnPort});
            ParallelGatewaySenderOperationsDUnitTest.getLogWriter().info("Created cache on local site");
            ParallelGatewaySenderOperationsDUnitTest.getLogWriter().info("Created senders on local site");
            vm4.invoke(WANTestBase.class, "createSender", new Object[]{"ln", 2, true, 100, 10, false, false, null, false});
            vm4.invoke(WANTestBase.class, "startSender", new Object[]{"ln"});
            vm4.invoke(WANTestBase.class, "pauseSender", new Object[]{"ln"});
            vm4.invoke(WANTestBase.class, "createPartitionedRegion", new Object[]{testName + "_PR", "ln", 1, 10, this.isOffHeap()});
            ParallelGatewaySenderOperationsDUnitTest.getLogWriter().info("Created PRs on local site");
            vm2.invoke(WANTestBase.class, "createPartitionedRegion", new Object[]{testName + "_PR", null, 1, 10, this.isOffHeap()});
            vm4.invoke(WANTestBase.class, "doPuts", new Object[]{testName + "_PR", 10});
            vm4.invoke(WANTestBase.class, "validateRegionSize", new Object[]{testName + "_PR", 10});
            vm2.invoke(WANTestBase.class, "validateRegionSize", new Object[]{testName + "_PR", 0});
            AsyncInvocation putAsync = vm4.invokeAsync(WANTestBase.class, "doPutsFrom", new Object[]{testName + "_PR", 100, 2000});
            AsyncInvocation localDestroyAsync = vm4.invokeAsync(WANTestBase.class, "localDestroyRegion", new Object[]{testName + "_PR"});
            try {
                putAsync.join();
                localDestroyAsync.join();
            }
            catch (InterruptedException e) {
                e.printStackTrace();
                ParallelGatewaySenderOperationsDUnitTest.fail((String)"Interrupted the async invocation.");
            }
            if (localDestroyAsync.getException() != null) {
                ParallelGatewaySenderOperationsDUnitTest.fail("Not Expected Exception got", putAsync.getException());
            }
            if (putAsync.getException() != null && !(putAsync.getException() instanceof RegionDestroyedException)) {
                ParallelGatewaySenderOperationsDUnitTest.fail("Expected RegionDestroyedException but got", putAsync.getException());
            }
            vm4.invoke(WANTestBase.class, "resumeSender", new Object[]{"ln"});
            ParallelGatewaySenderOperationsDUnitTest.pause(500);
            vm2.invoke(WANTestBase.class, "validateRegionSize", new Object[]{testName + "_PR", 0});
            vm4.invoke(WANTestBase.class, "createPartitionedRegion", new Object[]{testName + "_PR", "ln", 1, 10, this.isOffHeap()});
            vm4.invoke(WANTestBase.class, "doPutsFrom", new Object[]{testName + "_PR", 10, 20});
            vm4.invoke(WANTestBase.class, "validateRegionSize", new Object[]{testName + "_PR", 10});
            vm2.invoke(WANTestBase.class, "validateRegionSize", new Object[]{testName + "_PR", 10});
        }
        finally {
            vm4.invoke(ParallelGatewaySenderOperationsDUnitTest.class, "clear_INFINITE_MAXIMUM_SHUTDOWN_WAIT_TIME");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testParallelGatewaySender_SingleNode_UserPR_Destroy_SimultenuousPut_RecreateRegion() throws Exception {
        Integer lnPort = (Integer)vm0.invoke(WANTestBase.class, "createFirstLocatorWithDSId", new Object[]{1});
        Integer nyPort = (Integer)vm1.invoke(WANTestBase.class, "createFirstRemoteLocator", new Object[]{2, lnPort});
        vm2.invoke(WANTestBase.class, "createReceiver", new Object[]{nyPort});
        try {
            vm4.invoke(ParallelGatewaySenderOperationsDUnitTest.class, "createCache_INFINITE_MAXIMUM_SHUTDOWN_WAIT_TIME", new Object[]{lnPort});
            vm4.invoke(WANTestBase.class, "createSender", new Object[]{"ln", 2, true, 100, 10, false, false, null, false});
            vm4.invoke(WANTestBase.class, "startSender", new Object[]{"ln"});
            vm4.invoke(WANTestBase.class, "pauseSender", new Object[]{"ln"});
            vm4.invoke(WANTestBase.class, "createPartitionedRegion", new Object[]{testName + "_PR", "ln", 1, 10, this.isOffHeap()});
            vm4.invoke(WANTestBase.class, "addCacheListenerAndDestroyRegion", new Object[]{testName + "_PR"});
            ParallelGatewaySenderOperationsDUnitTest.getLogWriter().info("Created PRs on local site");
            vm2.invoke(WANTestBase.class, "createPartitionedRegion", new Object[]{testName + "_PR", null, 1, 10, this.isOffHeap()});
            vm4.invoke(WANTestBase.class, "doPuts", new Object[]{testName + "_PR", 10});
            vm4.invoke(WANTestBase.class, "validateRegionSize", new Object[]{testName + "_PR", 10});
            vm2.invoke(WANTestBase.class, "validateRegionSize", new Object[]{testName + "_PR", 0});
            vm4.invoke(WANTestBase.class, "resumeSender", new Object[]{"ln"});
            AsyncInvocation putAsync = vm4.invokeAsync(WANTestBase.class, "doPutsFrom", new Object[]{testName + "_PR", 10, 101});
            try {
                putAsync.join();
            }
            catch (InterruptedException e) {
                e.printStackTrace();
                ParallelGatewaySenderOperationsDUnitTest.fail((String)"Interrupted the async invocation.");
            }
            ParallelGatewaySenderOperationsDUnitTest.getLogWriter().info("KBKBKB : Got the exception : " + putAsync.getException());
            if (putAsync.getException() != null && !(putAsync.getException() instanceof RegionDestroyedException)) {
                ParallelGatewaySenderOperationsDUnitTest.fail("Expected RegionDestroyedException but got", putAsync.getException());
            }
            vm2.invoke(ParallelGatewaySenderOperationsDUnitTest.class, "validateRegionSizeWithinRange", new Object[]{testName + "_PR", 10, 101});
            vm4.invoke(WANTestBase.class, "createPartitionedRegion", new Object[]{testName + "_PR", "ln", 1, 10, this.isOffHeap()});
            vm4.invoke(WANTestBase.class, "doPutsFrom", new Object[]{testName + "_PR", 10, 20});
            vm4.invoke(WANTestBase.class, "validateRegionSize", new Object[]{testName + "_PR", 10});
            vm2.invoke(ParallelGatewaySenderOperationsDUnitTest.class, "validateRegionSizeWithinRange", new Object[]{testName + "_PR", 20, 101});
        }
        finally {
            vm4.invoke(ParallelGatewaySenderOperationsDUnitTest.class, "clear_INFINITE_MAXIMUM_SHUTDOWN_WAIT_TIME");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testParallelGatewaySender_SingleNode_UserPR_Destroy_NodeDown() throws Exception {
        Integer lnPort = (Integer)vm0.invoke(WANTestBase.class, "createFirstLocatorWithDSId", new Object[]{1});
        Integer nyPort = (Integer)vm1.invoke(WANTestBase.class, "createFirstRemoteLocator", new Object[]{2, lnPort});
        vm2.invoke(WANTestBase.class, "createReceiver", new Object[]{nyPort});
        try {
            vm4.invoke(ParallelGatewaySenderOperationsDUnitTest.class, "createCache_INFINITE_MAXIMUM_SHUTDOWN_WAIT_TIME", new Object[]{lnPort});
            vm5.invoke(ParallelGatewaySenderOperationsDUnitTest.class, "createCache_INFINITE_MAXIMUM_SHUTDOWN_WAIT_TIME", new Object[]{lnPort});
            vm6.invoke(ParallelGatewaySenderOperationsDUnitTest.class, "createCache_INFINITE_MAXIMUM_SHUTDOWN_WAIT_TIME", new Object[]{lnPort});
            vm4.invoke(WANTestBase.class, "createSender", new Object[]{"ln", 2, true, 100, 10, false, false, null, false});
            vm5.invoke(WANTestBase.class, "createSender", new Object[]{"ln", 2, true, 100, 10, false, false, null, false});
            vm6.invoke(WANTestBase.class, "createSender", new Object[]{"ln", 2, true, 100, 10, false, false, null, false});
            vm4.invoke(WANTestBase.class, "startSender", new Object[]{"ln"});
            vm5.invoke(WANTestBase.class, "startSender", new Object[]{"ln"});
            vm6.invoke(WANTestBase.class, "startSender", new Object[]{"ln"});
            vm4.invoke(WANTestBase.class, "pauseSender", new Object[]{"ln"});
            vm5.invoke(WANTestBase.class, "pauseSender", new Object[]{"ln"});
            vm6.invoke(WANTestBase.class, "pauseSender", new Object[]{"ln"});
            vm4.invoke(WANTestBase.class, "createPartitionedRegion", new Object[]{testName + "_PR", "ln", 1, 10, this.isOffHeap()});
            vm5.invoke(WANTestBase.class, "createPartitionedRegion", new Object[]{testName + "_PR", "ln", 1, 10, this.isOffHeap()});
            vm6.invoke(WANTestBase.class, "createPartitionedRegion", new Object[]{testName + "_PR", "ln", 1, 10, this.isOffHeap()});
            ParallelGatewaySenderOperationsDUnitTest.getLogWriter().info("Created PRs on local site");
            vm2.invoke(WANTestBase.class, "createPartitionedRegion", new Object[]{testName + "_PR", null, 1, 10, this.isOffHeap()});
            vm4.invoke(WANTestBase.class, "doPuts", new Object[]{testName + "_PR", 10000});
            vm4.invoke(WANTestBase.class, "validateRegionSize", new Object[]{testName + "_PR", 10000});
            vm2.invoke(WANTestBase.class, "validateRegionSize", new Object[]{testName + "_PR", 0});
            vm4.invoke(WANTestBase.class, "resumeSender", new Object[]{"ln"});
            vm5.invoke(WANTestBase.class, "resumeSender", new Object[]{"ln"});
            vm6.invoke(WANTestBase.class, "resumeSender", new Object[]{"ln"});
            ParallelGatewaySenderOperationsDUnitTest.pause(200);
            AsyncInvocation localDestroyAsync = vm4.invokeAsync(WANTestBase.class, "destroyRegion", new Object[]{testName + "_PR"});
            AsyncInvocation closeAsync = vm4.invokeAsync(WANTestBase.class, "closeCache");
            try {
                localDestroyAsync.join();
                closeAsync.join();
            }
            catch (InterruptedException e) {
                e.printStackTrace();
                ParallelGatewaySenderOperationsDUnitTest.fail((String)"Interrupted the async invocation.");
            }
            vm2.invoke(WANTestBase.class, "validateRegionSize", new Object[]{testName + "_PR", 10000});
        }
        finally {
            vm4.invoke(ParallelGatewaySenderOperationsDUnitTest.class, "clear_INFINITE_MAXIMUM_SHUTDOWN_WAIT_TIME");
            vm5.invoke(ParallelGatewaySenderOperationsDUnitTest.class, "clear_INFINITE_MAXIMUM_SHUTDOWN_WAIT_TIME");
            vm6.invoke(ParallelGatewaySenderOperationsDUnitTest.class, "clear_INFINITE_MAXIMUM_SHUTDOWN_WAIT_TIME");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testParallelGatewaySender_SingleNode_UserPR_Close_SimultenuousPut_RecreateRegion() throws Exception {
        Integer lnPort = (Integer)vm0.invoke(WANTestBase.class, "createFirstLocatorWithDSId", new Object[]{1});
        Integer nyPort = (Integer)vm1.invoke(WANTestBase.class, "createFirstRemoteLocator", new Object[]{2, lnPort});
        vm2.invoke(WANTestBase.class, "createReceiver", new Object[]{nyPort});
        try {
            vm4.invoke(ParallelGatewaySenderOperationsDUnitTest.class, "createCache_INFINITE_MAXIMUM_SHUTDOWN_WAIT_TIME", new Object[]{lnPort});
            ParallelGatewaySenderOperationsDUnitTest.getLogWriter().info("Created cache on local site");
            ParallelGatewaySenderOperationsDUnitTest.getLogWriter().info("Created senders on local site");
            vm4.invoke(WANTestBase.class, "createSender", new Object[]{"ln", 2, true, 100, 10, false, false, null, false});
            vm4.invoke(WANTestBase.class, "startSender", new Object[]{"ln"});
            vm4.invoke(WANTestBase.class, "pauseSender", new Object[]{"ln"});
            vm4.invoke(WANTestBase.class, "createPartitionedRegion", new Object[]{testName + "_PR", "ln", 1, 10, this.isOffHeap()});
            ParallelGatewaySenderOperationsDUnitTest.getLogWriter().info("Created PRs on local site");
            vm2.invoke(WANTestBase.class, "createPartitionedRegion", new Object[]{testName + "_PR", null, 1, 10, this.isOffHeap()});
            vm4.invoke(WANTestBase.class, "doPuts", new Object[]{testName + "_PR", 10});
            vm4.invoke(WANTestBase.class, "validateRegionSize", new Object[]{testName + "_PR", 10});
            vm2.invoke(WANTestBase.class, "validateRegionSize", new Object[]{testName + "_PR", 0});
            AsyncInvocation putAsync = vm4.invokeAsync(WANTestBase.class, "doPutsFrom", new Object[]{testName + "_PR", 10, 2000});
            AsyncInvocation localDestroyAsync = vm4.invokeAsync(ParallelGatewaySenderOperationsDUnitTest.class, "closeRegion", new Object[]{testName + "_PR"});
            try {
                putAsync.join();
                localDestroyAsync.join();
            }
            catch (InterruptedException e) {
                e.printStackTrace();
                ParallelGatewaySenderOperationsDUnitTest.fail((String)"Interrupted the async invocation.");
            }
            vm2.invoke(WANTestBase.class, "validateRegionSize", new Object[]{testName + "_PR", 0});
            vm4.invoke(WANTestBase.class, "resumeSender", new Object[]{"ln"});
            vm4.invoke(WANTestBase.class, "createPartitionedRegion", new Object[]{testName + "_PR", "ln", 1, 10, this.isOffHeap()});
            vm4.invoke(WANTestBase.class, "doPutsFrom", new Object[]{testName + "_PR", 10, 20});
            vm4.invoke(WANTestBase.class, "validateRegionSize", new Object[]{testName + "_PR", 10});
            vm2.invoke(WANTestBase.class, "validateRegionSize", new Object[]{testName + "_PR", 10});
        }
        finally {
            vm4.invoke(ParallelGatewaySenderOperationsDUnitTest.class, "clear_INFINITE_MAXIMUM_SHUTDOWN_WAIT_TIME");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testParallelGatewaySenders_SingleNode_UserPR_localDestroy_RecreateRegion() throws Exception {
        Integer lnPort = (Integer)vm0.invoke(WANTestBase.class, "createFirstLocatorWithDSId", new Object[]{1});
        Integer nyPort = (Integer)vm1.invoke(WANTestBase.class, "createFirstRemoteLocator", new Object[]{2, lnPort});
        Integer tkPort = (Integer)vm2.invoke(WANTestBase.class, "createFirstRemoteLocator", new Object[]{3, lnPort});
        Integer pnPort = (Integer)vm3.invoke(WANTestBase.class, "createFirstRemoteLocator", new Object[]{4, lnPort});
        vm4.invoke(WANTestBase.class, "createReceiver", new Object[]{nyPort});
        vm5.invoke(WANTestBase.class, "createReceiver", new Object[]{tkPort});
        vm6.invoke(WANTestBase.class, "createReceiver", new Object[]{pnPort});
        try {
            vm7.invoke(ParallelGatewaySenderOperationsDUnitTest.class, "createCache_INFINITE_MAXIMUM_SHUTDOWN_WAIT_TIME", new Object[]{lnPort});
            ParallelGatewaySenderOperationsDUnitTest.getLogWriter().info("Created cache on local site");
            vm7.invoke(WANTestBase.class, "createSender", new Object[]{"ln1", 2, true, 100, 10, false, false, null, true});
            vm7.invoke(WANTestBase.class, "createSender", new Object[]{"ln2", 3, true, 100, 10, false, false, null, true});
            vm7.invoke(WANTestBase.class, "createSender", new Object[]{"ln3", 4, true, 100, 10, false, false, null, true});
            vm7.invoke(WANTestBase.class, "startSender", new Object[]{"ln1"});
            vm7.invoke(WANTestBase.class, "startSender", new Object[]{"ln2"});
            vm7.invoke(WANTestBase.class, "startSender", new Object[]{"ln3"});
            vm7.invoke(WANTestBase.class, "createPartitionedRegion", new Object[]{testName + "_PR", "ln1,ln2,ln3", 1, 10, this.isOffHeap()});
            ParallelGatewaySenderOperationsDUnitTest.getLogWriter().info("Created PRs on local site");
            vm4.invoke(WANTestBase.class, "createPartitionedRegion", new Object[]{testName + "_PR", null, 1, 10, this.isOffHeap()});
            vm5.invoke(WANTestBase.class, "createPartitionedRegion", new Object[]{testName + "_PR", null, 1, 10, this.isOffHeap()});
            vm6.invoke(WANTestBase.class, "createPartitionedRegion", new Object[]{testName + "_PR", null, 1, 10, this.isOffHeap()});
            vm7.invoke(WANTestBase.class, "doPuts", new Object[]{testName + "_PR", 10});
            ParallelGatewaySenderOperationsDUnitTest.pause(1000);
            vm7.invoke(WANTestBase.class, "localDestroyRegion", new Object[]{testName + "_PR"});
            vm7.invoke(WANTestBase.class, "createPartitionedRegion", new Object[]{testName + "_PR", "ln1,ln2,ln3", 1, 10, this.isOffHeap()});
            vm7.invoke(WANTestBase.class, "doPutsFrom", new Object[]{testName + "_PR", 10, 20});
            vm7.invoke(WANTestBase.class, "validateRegionSize", new Object[]{testName + "_PR", 10});
            vm4.invoke(WANTestBase.class, "validateRegionSize", new Object[]{testName + "_PR", 20});
            vm5.invoke(WANTestBase.class, "validateRegionSize", new Object[]{testName + "_PR", 20});
            vm6.invoke(WANTestBase.class, "validateRegionSize", new Object[]{testName + "_PR", 20});
        }
        finally {
            vm7.invoke(ParallelGatewaySenderOperationsDUnitTest.class, "clear_INFINITE_MAXIMUM_SHUTDOWN_WAIT_TIME");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testParallelGatewaySender_MultipleNode_UserPR_localDestroy_Recreate() throws Exception {
        Integer lnPort = (Integer)vm0.invoke(WANTestBase.class, "createFirstLocatorWithDSId", new Object[]{1});
        Integer nyPort = (Integer)vm1.invoke(WANTestBase.class, "createFirstRemoteLocator", new Object[]{2, lnPort});
        vm2.invoke(WANTestBase.class, "createReceiver", new Object[]{nyPort});
        try {
            vm4.invoke(ParallelGatewaySenderOperationsDUnitTest.class, "createCache_INFINITE_MAXIMUM_SHUTDOWN_WAIT_TIME", new Object[]{lnPort});
            vm5.invoke(ParallelGatewaySenderOperationsDUnitTest.class, "createCache_INFINITE_MAXIMUM_SHUTDOWN_WAIT_TIME", new Object[]{lnPort});
            vm4.invoke(WANTestBase.class, "createPartitionedRegion", new Object[]{testName + "_PR", "ln", 1, 100, this.isOffHeap()});
            vm5.invoke(WANTestBase.class, "createPartitionedRegion", new Object[]{testName + "_PR", "ln", 1, 100, this.isOffHeap()});
            vm4.invoke(WANTestBase.class, "createSender", new Object[]{"ln", 2, true, 100, 10, false, false, null, true});
            vm5.invoke(WANTestBase.class, "createSender", new Object[]{"ln", 2, true, 100, 10, false, false, null, true});
            vm4.invoke(WANTestBase.class, "startSender", new Object[]{"ln"});
            vm5.invoke(WANTestBase.class, "startSender", new Object[]{"ln"});
            ParallelGatewaySenderOperationsDUnitTest.getLogWriter().info("Created PRs on local site");
            vm2.invoke(WANTestBase.class, "createPartitionedRegion", new Object[]{testName + "_PR", null, 1, 100, this.isOffHeap()});
            AsyncInvocation inv1 = vm4.invokeAsync(WANTestBase.class, "doPuts", new Object[]{testName + "_PR", 1000});
            ParallelGatewaySenderOperationsDUnitTest.pause(1000);
            vm5.invoke(WANTestBase.class, "localDestroyRegion", new Object[]{testName + "_PR"});
            try {
                inv1.join();
            }
            catch (InterruptedException ex) {
                ex.printStackTrace();
                ParallelGatewaySenderOperationsDUnitTest.fail((String)"Interrupted the async invocation.");
            }
            vm4.invoke(WANTestBase.class, "validateRegionSize", new Object[]{testName + "_PR", 1000});
            vm2.invoke(WANTestBase.class, "validateRegionSize", new Object[]{testName + "_PR", 1000});
            vm5.invoke(WANTestBase.class, "createPartitionedRegion", new Object[]{testName + "_PR", "ln", 1, 100, this.isOffHeap()});
            vm4.invoke(WANTestBase.class, "doPutsFrom", new Object[]{testName + "_PR", 1000, 2000});
            vm4.invoke(WANTestBase.class, "validateRegionSize", new Object[]{testName + "_PR", 2000});
            vm2.invoke(WANTestBase.class, "validateRegionSize", new Object[]{testName + "_PR", 2000});
        }
        finally {
            vm4.invoke(ParallelGatewaySenderOperationsDUnitTest.class, "clear_INFINITE_MAXIMUM_SHUTDOWN_WAIT_TIME");
            vm5.invoke(ParallelGatewaySenderOperationsDUnitTest.class, "clear_INFINITE_MAXIMUM_SHUTDOWN_WAIT_TIME");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testParallelGatewaySenders_MultiplNode_UserPR_localDestroy_Recreate() throws Exception {
        Integer lnPort = (Integer)vm0.invoke(WANTestBase.class, "createFirstLocatorWithDSId", new Object[]{1});
        Integer nyPort = (Integer)vm1.invoke(WANTestBase.class, "createFirstRemoteLocator", new Object[]{2, lnPort});
        Integer tkPort = (Integer)vm2.invoke(WANTestBase.class, "createFirstRemoteLocator", new Object[]{3, lnPort});
        vm6.invoke(WANTestBase.class, "createReceiver", new Object[]{nyPort});
        vm7.invoke(WANTestBase.class, "createReceiver", new Object[]{tkPort});
        try {
            vm4.invoke(ParallelGatewaySenderOperationsDUnitTest.class, "createCache_INFINITE_MAXIMUM_SHUTDOWN_WAIT_TIME", new Object[]{lnPort});
            vm5.invoke(ParallelGatewaySenderOperationsDUnitTest.class, "createCache_INFINITE_MAXIMUM_SHUTDOWN_WAIT_TIME", new Object[]{lnPort});
            vm4.invoke(WANTestBase.class, "createPartitionedRegion", new Object[]{testName + "_PR", "ln1,ln2", 1, 100, this.isOffHeap()});
            vm5.invoke(WANTestBase.class, "createPartitionedRegion", new Object[]{testName + "_PR", "ln1,ln2", 1, 100, this.isOffHeap()});
            vm4.invoke(WANTestBase.class, "createSender", new Object[]{"ln1", 2, true, 100, 10, false, false, null, true});
            vm4.invoke(WANTestBase.class, "createSender", new Object[]{"ln2", 3, true, 100, 10, false, false, null, true});
            vm5.invoke(WANTestBase.class, "createSender", new Object[]{"ln1", 2, true, 100, 10, false, false, null, true});
            vm5.invoke(WANTestBase.class, "createSender", new Object[]{"ln2", 3, true, 100, 10, false, false, null, true});
            vm4.invoke(WANTestBase.class, "startSender", new Object[]{"ln1"});
            vm4.invoke(WANTestBase.class, "startSender", new Object[]{"ln2"});
            vm5.invoke(WANTestBase.class, "startSender", new Object[]{"ln1"});
            vm5.invoke(WANTestBase.class, "startSender", new Object[]{"ln2"});
            vm6.invoke(WANTestBase.class, "createPartitionedRegion", new Object[]{testName + "_PR", null, 1, 100, this.isOffHeap()});
            vm7.invoke(WANTestBase.class, "createPartitionedRegion", new Object[]{testName + "_PR", null, 1, 100, this.isOffHeap()});
            AsyncInvocation inv1 = vm4.invokeAsync(WANTestBase.class, "doPuts", new Object[]{testName + "_PR", 1000});
            ParallelGatewaySenderOperationsDUnitTest.pause(1000);
            vm5.invoke(WANTestBase.class, "localDestroyRegion", new Object[]{testName + "_PR"});
            try {
                inv1.join();
            }
            catch (InterruptedException ex) {
                ex.printStackTrace();
                ParallelGatewaySenderOperationsDUnitTest.fail((String)"Interrupted the async invocation.");
            }
            vm4.invoke(WANTestBase.class, "validateRegionSize", new Object[]{testName + "_PR", 1000});
            vm6.invoke(WANTestBase.class, "validateRegionSize", new Object[]{testName + "_PR", 1000});
            vm7.invoke(WANTestBase.class, "validateRegionSize", new Object[]{testName + "_PR", 1000});
            vm5.invoke(WANTestBase.class, "createPartitionedRegion", new Object[]{testName + "_PR", "ln1,ln2", 1, 100, this.isOffHeap()});
            vm4.invoke(WANTestBase.class, "doPutsFrom", new Object[]{testName + "_PR", 1000, 2000});
            vm4.invoke(WANTestBase.class, "validateRegionSize", new Object[]{testName + "_PR", 2000});
            vm6.invoke(WANTestBase.class, "validateRegionSize", new Object[]{testName + "_PR", 2000});
            vm7.invoke(WANTestBase.class, "validateRegionSize", new Object[]{testName + "_PR", 2000});
        }
        finally {
            vm4.invoke(ParallelGatewaySenderOperationsDUnitTest.class, "clear_INFINITE_MAXIMUM_SHUTDOWN_WAIT_TIME");
            vm5.invoke(ParallelGatewaySenderOperationsDUnitTest.class, "clear_INFINITE_MAXIMUM_SHUTDOWN_WAIT_TIME");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testParallelGatewaySender_ColocatedPartitionedRegions_localDestroy() throws Exception {
        Integer lnPort = (Integer)vm0.invoke(WANTestBase.class, "createFirstLocatorWithDSId", new Object[]{1});
        Integer nyPort = (Integer)vm1.invoke(WANTestBase.class, "createFirstRemoteLocator", new Object[]{2, lnPort});
        vm2.invoke(WANTestBase.class, "createReceiver", new Object[]{nyPort});
        try {
            vm4.invoke(ParallelGatewaySenderOperationsDUnitTest.class, "createCache_INFINITE_MAXIMUM_SHUTDOWN_WAIT_TIME", new Object[]{lnPort});
            vm5.invoke(ParallelGatewaySenderOperationsDUnitTest.class, "createCache_INFINITE_MAXIMUM_SHUTDOWN_WAIT_TIME", new Object[]{lnPort});
            vm4.invoke(WANTestBase.class, "createCustomerOrderShipmentPartitionedRegion", new Object[]{null, "ln", 1, 100, this.isOffHeap()});
            vm5.invoke(WANTestBase.class, "createCustomerOrderShipmentPartitionedRegion", new Object[]{null, "ln", 1, 100, this.isOffHeap()});
            vm4.invoke(WANTestBase.class, "createSender", new Object[]{"ln", 2, true, 100, 10, false, false, null, true});
            vm5.invoke(WANTestBase.class, "createSender", new Object[]{"ln", 2, true, 100, 10, false, false, null, true});
            vm4.invoke(WANTestBase.class, "startSender", new Object[]{"ln"});
            vm5.invoke(WANTestBase.class, "startSender", new Object[]{"ln"});
            ParallelGatewaySenderOperationsDUnitTest.getLogWriter().info("Created PRs on local site");
            vm2.invoke(WANTestBase.class, "createCustomerOrderShipmentPartitionedRegion", new Object[]{null, null, 1, 100, this.isOffHeap()});
            AsyncInvocation inv1 = vm4.invokeAsync(WANTestBase.class, "putcolocatedPartitionedRegion", new Object[]{2000});
            ParallelGatewaySenderOperationsDUnitTest.pause(1000);
            try {
                vm5.invoke(WANTestBase.class, "localDestroyRegion", new Object[]{"CUSTOMER"});
            }
            catch (Exception ex) {
                ParallelGatewaySenderOperationsDUnitTest.assertTrue((boolean)(ex.getCause() instanceof UnsupportedOperationException));
            }
            try {
                inv1.join();
            }
            catch (Exception e) {
                ParallelGatewaySenderOperationsDUnitTest.fail("Unexpected exception", e);
            }
            vm4.invoke(WANTestBase.class, "validateRegionSize", new Object[]{"CUSTOMER", 2000});
            vm5.invoke(WANTestBase.class, "validateRegionSize", new Object[]{"CUSTOMER", 2000});
            vm2.invoke(WANTestBase.class, "validateRegionSize", new Object[]{"CUSTOMER", 2000});
        }
        finally {
            vm4.invoke(ParallelGatewaySenderOperationsDUnitTest.class, "clear_INFINITE_MAXIMUM_SHUTDOWN_WAIT_TIME");
            vm5.invoke(ParallelGatewaySenderOperationsDUnitTest.class, "clear_INFINITE_MAXIMUM_SHUTDOWN_WAIT_TIME");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testParallelGatewaySender_ColocatedPartitionedRegions_destroy() throws Exception {
        Integer lnPort = (Integer)vm0.invoke(WANTestBase.class, "createFirstLocatorWithDSId", new Object[]{1});
        Integer nyPort = (Integer)vm1.invoke(WANTestBase.class, "createFirstRemoteLocator", new Object[]{2, lnPort});
        vm2.invoke(WANTestBase.class, "createReceiver", new Object[]{nyPort});
        try {
            vm4.invoke(ParallelGatewaySenderOperationsDUnitTest.class, "createCache_INFINITE_MAXIMUM_SHUTDOWN_WAIT_TIME", new Object[]{lnPort});
            vm5.invoke(ParallelGatewaySenderOperationsDUnitTest.class, "createCache_INFINITE_MAXIMUM_SHUTDOWN_WAIT_TIME", new Object[]{lnPort});
            vm4.invoke(WANTestBase.class, "createCustomerOrderShipmentPartitionedRegion", new Object[]{null, "ln", 1, 100, this.isOffHeap()});
            vm5.invoke(WANTestBase.class, "createCustomerOrderShipmentPartitionedRegion", new Object[]{null, "ln", 1, 100, this.isOffHeap()});
            vm4.invoke(WANTestBase.class, "createSender", new Object[]{"ln", 2, true, 100, 10, false, false, null, true});
            vm5.invoke(WANTestBase.class, "createSender", new Object[]{"ln", 2, true, 100, 10, false, false, null, true});
            vm4.invoke(WANTestBase.class, "startSender", new Object[]{"ln"});
            vm5.invoke(WANTestBase.class, "startSender", new Object[]{"ln"});
            ParallelGatewaySenderOperationsDUnitTest.getLogWriter().info("Created PRs on local site");
            vm2.invoke(WANTestBase.class, "createCustomerOrderShipmentPartitionedRegion", new Object[]{null, null, 1, 100, this.isOffHeap()});
            AsyncInvocation inv1 = vm4.invokeAsync(WANTestBase.class, "putcolocatedPartitionedRegion", new Object[]{2000});
            ParallelGatewaySenderOperationsDUnitTest.pause(1000);
            try {
                vm5.invoke(WANTestBase.class, "destroyRegion", new Object[]{"CUSTOMER"});
            }
            catch (Exception ex) {
                ParallelGatewaySenderOperationsDUnitTest.assertTrue((boolean)(ex.getCause() instanceof IllegalStateException));
                vm4.invoke(ParallelGatewaySenderOperationsDUnitTest.class, "clear_INFINITE_MAXIMUM_SHUTDOWN_WAIT_TIME");
                vm5.invoke(ParallelGatewaySenderOperationsDUnitTest.class, "clear_INFINITE_MAXIMUM_SHUTDOWN_WAIT_TIME");
                return;
            }
            ParallelGatewaySenderOperationsDUnitTest.fail((String)"Excpeted UnsupportedOperationException");
        }
        finally {
            vm4.invoke(ParallelGatewaySenderOperationsDUnitTest.class, "clear_INFINITE_MAXIMUM_SHUTDOWN_WAIT_TIME");
            vm5.invoke(ParallelGatewaySenderOperationsDUnitTest.class, "clear_INFINITE_MAXIMUM_SHUTDOWN_WAIT_TIME");
        }
    }

    public void testDestroyParallelGatewaySenderExceptionScenario() {
        Integer lnPort = (Integer)vm0.invoke(WANTestBase.class, "createFirstLocatorWithDSId", new Object[]{1});
        Integer nyPort = (Integer)vm1.invoke(WANTestBase.class, "createFirstRemoteLocator", new Object[]{2, lnPort});
        vm2.invoke(WANTestBase.class, "createReceiver", new Object[]{nyPort});
        vm3.invoke(WANTestBase.class, "createReceiver", new Object[]{nyPort});
        vm4.invoke(WANTestBase.class, "createCache", new Object[]{lnPort});
        vm5.invoke(WANTestBase.class, "createCache", new Object[]{lnPort});
        vm6.invoke(WANTestBase.class, "createCache", new Object[]{lnPort});
        vm7.invoke(WANTestBase.class, "createCache", new Object[]{lnPort});
        vm4.invoke(WANTestBase.class, "createSender", new Object[]{"ln", 2, true, 100, 10, false, false, null, true});
        vm5.invoke(WANTestBase.class, "createSender", new Object[]{"ln", 2, true, 100, 10, false, false, null, true});
        vm6.invoke(WANTestBase.class, "createSender", new Object[]{"ln", 2, true, 100, 10, false, false, null, true});
        vm7.invoke(WANTestBase.class, "createSender", new Object[]{"ln", 2, true, 100, 10, false, false, null, true});
        vm4.invoke(WANTestBase.class, "createPartitionedRegion", new Object[]{testName + "_PR", "ln", 1, 100, this.isOffHeap()});
        vm5.invoke(WANTestBase.class, "createPartitionedRegion", new Object[]{testName + "_PR", "ln", 1, 100, this.isOffHeap()});
        vm6.invoke(WANTestBase.class, "createPartitionedRegion", new Object[]{testName + "_PR", "ln", 1, 100, this.isOffHeap()});
        vm7.invoke(WANTestBase.class, "createPartitionedRegion", new Object[]{testName + "_PR", "ln", 1, 100, this.isOffHeap()});
        vm4.invoke(WANTestBase.class, "startSender", new Object[]{"ln"});
        vm5.invoke(WANTestBase.class, "startSender", new Object[]{"ln"});
        vm6.invoke(WANTestBase.class, "startSender", new Object[]{"ln"});
        vm7.invoke(WANTestBase.class, "startSender", new Object[]{"ln"});
        vm2.invoke(WANTestBase.class, "createPartitionedRegion", new Object[]{testName + "_PR", null, 1, 100, this.isOffHeap()});
        vm3.invoke(WANTestBase.class, "createPartitionedRegion", new Object[]{testName + "_PR", null, 1, 100, this.isOffHeap()});
        vm4.invoke(WANTestBase.class, "waitForSenderRunningState", new Object[]{"ln"});
        vm5.invoke(WANTestBase.class, "waitForSenderRunningState", new Object[]{"ln"});
        vm6.invoke(WANTestBase.class, "waitForSenderRunningState", new Object[]{"ln"});
        vm7.invoke(WANTestBase.class, "waitForSenderRunningState", new Object[]{"ln"});
        vm4.invoke(WANTestBase.class, "doPuts", new Object[]{testName + "_PR", 1000});
        try {
            vm4.invoke(WANTestBase.class, "destroySender", new Object[]{"ln"});
        }
        catch (RMIException e) {
            ParallelGatewaySenderOperationsDUnitTest.assertTrue((String)"Cause of the exception should be GatewaySenderException", (boolean)(e.getCause() instanceof GatewaySenderException));
        }
        try {
            vm5.invoke(WANTestBase.class, "destroySender", new Object[]{"ln"});
        }
        catch (RMIException e) {
            ParallelGatewaySenderOperationsDUnitTest.assertTrue((String)"Cause of the exception should be GatewaySenderException", (boolean)(e.getCause() instanceof GatewaySenderException));
        }
        vm2.invoke(WANTestBase.class, "validateRegionSize", new Object[]{testName + "_PR", 1000});
    }

    public void testDestroyParallelGatewaySender() {
        Integer lnPort = (Integer)vm0.invoke(WANTestBase.class, "createFirstLocatorWithDSId", new Object[]{1});
        Integer nyPort = (Integer)vm1.invoke(WANTestBase.class, "createFirstRemoteLocator", new Object[]{2, lnPort});
        vm2.invoke(WANTestBase.class, "createReceiver", new Object[]{nyPort});
        vm3.invoke(WANTestBase.class, "createReceiver", new Object[]{nyPort});
        vm4.invoke(WANTestBase.class, "createCache", new Object[]{lnPort});
        vm5.invoke(WANTestBase.class, "createCache", new Object[]{lnPort});
        vm6.invoke(WANTestBase.class, "createCache", new Object[]{lnPort});
        vm7.invoke(WANTestBase.class, "createCache", new Object[]{lnPort});
        vm4.invoke(WANTestBase.class, "createSender", new Object[]{"ln", 2, true, 100, 10, false, false, null, true});
        vm5.invoke(WANTestBase.class, "createSender", new Object[]{"ln", 2, true, 100, 10, false, false, null, true});
        vm6.invoke(WANTestBase.class, "createSender", new Object[]{"ln", 2, true, 100, 10, false, false, null, true});
        vm7.invoke(WANTestBase.class, "createSender", new Object[]{"ln", 2, true, 100, 10, false, false, null, true});
        vm4.invoke(WANTestBase.class, "createPartitionedRegion", new Object[]{testName + "_PR", "ln", 1, 100, this.isOffHeap()});
        vm5.invoke(WANTestBase.class, "createPartitionedRegion", new Object[]{testName + "_PR", "ln", 1, 100, this.isOffHeap()});
        vm6.invoke(WANTestBase.class, "createPartitionedRegion", new Object[]{testName + "_PR", "ln", 1, 100, this.isOffHeap()});
        vm7.invoke(WANTestBase.class, "createPartitionedRegion", new Object[]{testName + "_PR", "ln", 1, 100, this.isOffHeap()});
        vm4.invoke(WANTestBase.class, "startSender", new Object[]{"ln"});
        vm5.invoke(WANTestBase.class, "startSender", new Object[]{"ln"});
        vm6.invoke(WANTestBase.class, "startSender", new Object[]{"ln"});
        vm7.invoke(WANTestBase.class, "startSender", new Object[]{"ln"});
        vm2.invoke(WANTestBase.class, "createPartitionedRegion", new Object[]{testName + "_PR", null, 1, 100, this.isOffHeap()});
        vm3.invoke(WANTestBase.class, "createPartitionedRegion", new Object[]{testName + "_PR", null, 1, 100, this.isOffHeap()});
        vm4.invoke(WANTestBase.class, "waitForSenderRunningState", new Object[]{"ln"});
        vm5.invoke(WANTestBase.class, "waitForSenderRunningState", new Object[]{"ln"});
        vm6.invoke(WANTestBase.class, "waitForSenderRunningState", new Object[]{"ln"});
        vm7.invoke(WANTestBase.class, "waitForSenderRunningState", new Object[]{"ln"});
        vm4.invoke(WANTestBase.class, "doPuts", new Object[]{testName + "_PR", 1000});
        ParallelGatewaySenderOperationsDUnitTest.pause(2000);
        vm4.invoke(WANTestBase.class, "stopSender", new Object[]{"ln"});
        vm5.invoke(WANTestBase.class, "stopSender", new Object[]{"ln"});
        vm6.invoke(WANTestBase.class, "stopSender", new Object[]{"ln"});
        vm7.invoke(WANTestBase.class, "stopSender", new Object[]{"ln"});
        vm4.invoke(WANTestBase.class, "removeSenderFromTheRegion", new Object[]{"ln", testName + "_PR"});
        vm5.invoke(WANTestBase.class, "removeSenderFromTheRegion", new Object[]{"ln", testName + "_PR"});
        vm6.invoke(WANTestBase.class, "removeSenderFromTheRegion", new Object[]{"ln", testName + "_PR"});
        vm7.invoke(WANTestBase.class, "removeSenderFromTheRegion", new Object[]{"ln", testName + "_PR"});
        vm4.invoke(WANTestBase.class, "destroySender", new Object[]{"ln"});
        vm5.invoke(WANTestBase.class, "destroySender", new Object[]{"ln"});
        vm6.invoke(WANTestBase.class, "destroySender", new Object[]{"ln"});
        vm7.invoke(WANTestBase.class, "destroySender", new Object[]{"ln"});
        vm4.invoke(WANTestBase.class, "verifySenderDestroyed", new Object[]{"ln", true});
        vm5.invoke(WANTestBase.class, "verifySenderDestroyed", new Object[]{"ln", true});
        vm6.invoke(WANTestBase.class, "verifySenderDestroyed", new Object[]{"ln", true});
        vm7.invoke(WANTestBase.class, "verifySenderDestroyed", new Object[]{"ln", true});
    }

    public static void createCache_INFINITE_MAXIMUM_SHUTDOWN_WAIT_TIME(Integer locPort) {
        ParallelGatewaySenderOperationsDUnitTest.createCache(false, locPort);
        AbstractGatewaySender.MAXIMUM_SHUTDOWN_WAIT_TIME = -1;
    }

    public static void clear_INFINITE_MAXIMUM_SHUTDOWN_WAIT_TIME() {
        AbstractGatewaySender.MAXIMUM_SHUTDOWN_WAIT_TIME = 0;
    }

    public static void closeRegion(String regionName) {
        Region r = cache.getRegion("/" + regionName);
        ParallelGatewaySenderOperationsDUnitTest.assertNotNull((Object)r);
        r.close();
    }

    public static void validateRegionSizeWithinRange(String regionName, final int min, final int max) {
        final Region r = cache.getRegion("/" + regionName);
        ParallelGatewaySenderOperationsDUnitTest.assertNotNull((Object)r);
        DistributedTestCase.WaitCriterion wc = new DistributedTestCase.WaitCriterion(){

            @Override
            public boolean done() {
                return r.keySet().size() > min && r.keySet().size() <= max;
            }

            @Override
            public String description() {
                return "Expected region entries to be within range : " + min + " " + max + " but actual entries: " + r.keySet().size();
            }
        };
        DistributedTestCase.waitForCriterion(wc, 120000L, 500L, true);
    }
}

