/*
 * Decompiled with CFR 0.152.
 */
package com.gemstone.gemfire.internal.cache.wan.parallel;

import com.gemstone.gemfire.cache.AttributesFactory;
import com.gemstone.gemfire.cache.CacheFactory;
import com.gemstone.gemfire.cache.DataPolicy;
import com.gemstone.gemfire.cache.DiskStore;
import com.gemstone.gemfire.cache.DiskStoreFactory;
import com.gemstone.gemfire.cache.Region;
import com.gemstone.gemfire.cache.wan.GatewayEventFilter;
import com.gemstone.gemfire.cache.wan.GatewaySender;
import com.gemstone.gemfire.cache.wan.GatewaySenderFactory;
import com.gemstone.gemfire.cache.wan.GatewayTransportFilter;
import com.gemstone.gemfire.cache30.MyGatewayEventFilter1;
import com.gemstone.gemfire.cache30.MyGatewayTransportFilter1;
import com.gemstone.gemfire.cache30.MyGatewayTransportFilter2;
import com.gemstone.gemfire.distributed.DistributedSystem;
import com.gemstone.gemfire.distributed.internal.InternalDistributedSystem;
import com.gemstone.gemfire.internal.cache.RegionQueue;
import com.gemstone.gemfire.internal.cache.wan.WANTestBase;
import com.gemstone.gemfire.internal.cache.wan.parallel.ParallelGatewaySenderImpl;
import dunit.DistributedTestCase;
import dunit.VM;
import java.io.File;
import java.util.Properties;
import java.util.Set;

public class ParallelGatewaySenderQueueOverflowDUnitTest
extends WANTestBase {
    private static final long serialVersionUID = 1L;

    public ParallelGatewaySenderQueueOverflowDUnitTest(String name) {
        super(name);
    }

    @Override
    public void setUp() throws Exception {
        super.setUp();
    }

    public void testParallelSenderQueueEventsOverflow_NoDiskStoreSpecified() throws Exception {
        Integer lnPort = (Integer)vm0.invoke(WANTestBase.class, "createFirstLocatorWithDSId", new Object[]{1});
        Integer nyPort = (Integer)vm1.invoke(WANTestBase.class, "createFirstRemoteLocator", new Object[]{2, lnPort});
        vm2.invoke(WANTestBase.class, "createReceiver", new Object[]{nyPort});
        vm3.invoke(WANTestBase.class, "createReceiver", new Object[]{nyPort});
        vm4.invoke(WANTestBase.class, "createCache", new Object[]{lnPort});
        vm5.invoke(WANTestBase.class, "createCache", new Object[]{lnPort});
        vm6.invoke(WANTestBase.class, "createCache", new Object[]{lnPort});
        vm7.invoke(WANTestBase.class, "createCache", new Object[]{lnPort});
        vm4.invoke(WANTestBase.class, "createSenderWithoutDiskStore", new Object[]{"ln", 2, true, 10, 10, false, false, null, true});
        vm5.invoke(WANTestBase.class, "createSenderWithoutDiskStore", new Object[]{"ln", 2, true, 10, 10, false, false, null, true});
        vm6.invoke(WANTestBase.class, "createSenderWithoutDiskStore", new Object[]{"ln", 2, true, 10, 10, false, false, null, true});
        vm7.invoke(WANTestBase.class, "createSenderWithoutDiskStore", new Object[]{"ln", 2, true, 10, 10, false, false, null, true});
        vm4.invoke(WANTestBase.class, "createPartitionedRegion", new Object[]{testName, "ln", 1, 100, this.isOffHeap()});
        vm5.invoke(WANTestBase.class, "createPartitionedRegion", new Object[]{testName, "ln", 1, 100, this.isOffHeap()});
        vm6.invoke(WANTestBase.class, "createPartitionedRegion", new Object[]{testName, "ln", 1, 100, this.isOffHeap()});
        vm7.invoke(WANTestBase.class, "createPartitionedRegion", new Object[]{testName, "ln", 1, 100, this.isOffHeap()});
        vm4.invoke(WANTestBase.class, "startSender", new Object[]{"ln"});
        vm5.invoke(WANTestBase.class, "startSender", new Object[]{"ln"});
        vm6.invoke(WANTestBase.class, "startSender", new Object[]{"ln"});
        vm7.invoke(WANTestBase.class, "startSender", new Object[]{"ln"});
        vm4.invoke(WANTestBase.class, "pauseSender", new Object[]{"ln"});
        vm5.invoke(WANTestBase.class, "pauseSender", new Object[]{"ln"});
        vm6.invoke(WANTestBase.class, "pauseSender", new Object[]{"ln"});
        vm7.invoke(WANTestBase.class, "pauseSender", new Object[]{"ln"});
        ParallelGatewaySenderQueueOverflowDUnitTest.pause(1000);
        vm2.invoke(WANTestBase.class, "createPartitionedRegion", new Object[]{testName, null, 1, 100, this.isOffHeap()});
        vm3.invoke(WANTestBase.class, "createPartitionedRegion", new Object[]{testName, null, 1, 100, this.isOffHeap()});
        int numEventPuts = 50;
        vm4.invoke(WANTestBase.class, "doHeavyPuts", new Object[]{testName, numEventPuts});
        long numOvVm4 = (Long)vm4.invoke(WANTestBase.class, "getNumberOfEntriesOverflownToDisk", new Object[]{"ln"});
        long numOvVm5 = (Long)vm5.invoke(WANTestBase.class, "getNumberOfEntriesOverflownToDisk", new Object[]{"ln"});
        long numOvVm6 = (Long)vm6.invoke(WANTestBase.class, "getNumberOfEntriesOverflownToDisk", new Object[]{"ln"});
        long numOvVm7 = (Long)vm7.invoke(WANTestBase.class, "getNumberOfEntriesOverflownToDisk", new Object[]{"ln"});
        long numMemVm4 = (Long)vm4.invoke(WANTestBase.class, "getNumberOfEntriesInVM", new Object[]{"ln"});
        long numMemVm5 = (Long)vm5.invoke(WANTestBase.class, "getNumberOfEntriesInVM", new Object[]{"ln"});
        long numMemVm6 = (Long)vm6.invoke(WANTestBase.class, "getNumberOfEntriesInVM", new Object[]{"ln"});
        long numMemVm7 = (Long)vm7.invoke(WANTestBase.class, "getNumberOfEntriesInVM", new Object[]{"ln"});
        ParallelGatewaySenderQueueOverflowDUnitTest.getLogWriter().info("Entries overflown to disk: " + numOvVm4 + "," + numOvVm5 + "," + numOvVm6 + "," + numOvVm7);
        ParallelGatewaySenderQueueOverflowDUnitTest.getLogWriter().info("Entries in VM: " + numMemVm4 + "," + numMemVm5 + "," + numMemVm6 + "," + numMemVm7);
        long totalOverflown = numOvVm4 + numOvVm5 + numOvVm6 + numOvVm7;
        ParallelGatewaySenderQueueOverflowDUnitTest.assertTrue((String)"Total number of entries overflown to disk should be at least greater than 55", (totalOverflown > 55L ? 1 : 0) != 0);
        long totalInMemory = numMemVm4 + numMemVm5 + numMemVm6 + numMemVm7;
        ParallelGatewaySenderQueueOverflowDUnitTest.assertEquals((String)"Total number of entries on disk and in VM is incorrect", (long)(numEventPuts * 2), (long)(totalOverflown + totalInMemory));
        vm4.invoke(WANTestBase.class, "resumeSender", new Object[]{"ln"});
        vm5.invoke(WANTestBase.class, "resumeSender", new Object[]{"ln"});
        vm6.invoke(WANTestBase.class, "resumeSender", new Object[]{"ln"});
        vm7.invoke(WANTestBase.class, "resumeSender", new Object[]{"ln"});
        vm2.invoke(WANTestBase.class, "validateRegionSize", new Object[]{testName, 50});
        vm3.invoke(WANTestBase.class, "validateRegionSize", new Object[]{testName, 50});
    }

    public void testParallelSenderQueueEventsOverflow() throws Exception {
        Integer lnPort = (Integer)vm0.invoke(WANTestBase.class, "createFirstLocatorWithDSId", new Object[]{1});
        Integer nyPort = (Integer)vm1.invoke(WANTestBase.class, "createFirstRemoteLocator", new Object[]{2, lnPort});
        vm2.invoke(WANTestBase.class, "createReceiver", new Object[]{nyPort});
        vm3.invoke(WANTestBase.class, "createReceiver", new Object[]{nyPort});
        vm4.invoke(WANTestBase.class, "createCache", new Object[]{lnPort});
        vm5.invoke(WANTestBase.class, "createCache", new Object[]{lnPort});
        vm6.invoke(WANTestBase.class, "createCache", new Object[]{lnPort});
        vm7.invoke(WANTestBase.class, "createCache", new Object[]{lnPort});
        vm4.invoke(WANTestBase.class, "createSender", new Object[]{"ln", 2, true, 10, 10, false, false, null, true});
        vm5.invoke(WANTestBase.class, "createSender", new Object[]{"ln", 2, true, 10, 10, false, false, null, true});
        vm6.invoke(WANTestBase.class, "createSender", new Object[]{"ln", 2, true, 10, 10, false, false, null, true});
        vm7.invoke(WANTestBase.class, "createSender", new Object[]{"ln", 2, true, 10, 10, false, false, null, true});
        vm4.invoke(WANTestBase.class, "createPartitionedRegion", new Object[]{testName, "ln", 1, 100, this.isOffHeap()});
        vm5.invoke(WANTestBase.class, "createPartitionedRegion", new Object[]{testName, "ln", 1, 100, this.isOffHeap()});
        vm6.invoke(WANTestBase.class, "createPartitionedRegion", new Object[]{testName, "ln", 1, 100, this.isOffHeap()});
        vm7.invoke(WANTestBase.class, "createPartitionedRegion", new Object[]{testName, "ln", 1, 100, this.isOffHeap()});
        vm4.invoke(WANTestBase.class, "startSender", new Object[]{"ln"});
        vm5.invoke(WANTestBase.class, "startSender", new Object[]{"ln"});
        vm6.invoke(WANTestBase.class, "startSender", new Object[]{"ln"});
        vm7.invoke(WANTestBase.class, "startSender", new Object[]{"ln"});
        vm4.invoke(WANTestBase.class, "pauseSender", new Object[]{"ln"});
        vm5.invoke(WANTestBase.class, "pauseSender", new Object[]{"ln"});
        vm6.invoke(WANTestBase.class, "pauseSender", new Object[]{"ln"});
        vm7.invoke(WANTestBase.class, "pauseSender", new Object[]{"ln"});
        ParallelGatewaySenderQueueOverflowDUnitTest.pause(1000);
        vm2.invoke(WANTestBase.class, "createPartitionedRegion", new Object[]{testName, null, 1, 100, this.isOffHeap()});
        vm3.invoke(WANTestBase.class, "createPartitionedRegion", new Object[]{testName, null, 1, 100, this.isOffHeap()});
        int numEventPuts = 50;
        vm4.invoke(WANTestBase.class, "doHeavyPuts", new Object[]{testName, numEventPuts});
        long numOvVm4 = (Long)vm4.invoke(WANTestBase.class, "getNumberOfEntriesOverflownToDisk", new Object[]{"ln"});
        long numOvVm5 = (Long)vm5.invoke(WANTestBase.class, "getNumberOfEntriesOverflownToDisk", new Object[]{"ln"});
        long numOvVm6 = (Long)vm6.invoke(WANTestBase.class, "getNumberOfEntriesOverflownToDisk", new Object[]{"ln"});
        long numOvVm7 = (Long)vm7.invoke(WANTestBase.class, "getNumberOfEntriesOverflownToDisk", new Object[]{"ln"});
        long numMemVm4 = (Long)vm4.invoke(WANTestBase.class, "getNumberOfEntriesInVM", new Object[]{"ln"});
        long numMemVm5 = (Long)vm5.invoke(WANTestBase.class, "getNumberOfEntriesInVM", new Object[]{"ln"});
        long numMemVm6 = (Long)vm6.invoke(WANTestBase.class, "getNumberOfEntriesInVM", new Object[]{"ln"});
        long numMemVm7 = (Long)vm7.invoke(WANTestBase.class, "getNumberOfEntriesInVM", new Object[]{"ln"});
        ParallelGatewaySenderQueueOverflowDUnitTest.getLogWriter().info("Entries overflown to disk: " + numOvVm4 + "," + numOvVm5 + "," + numOvVm6 + "," + numOvVm7);
        ParallelGatewaySenderQueueOverflowDUnitTest.getLogWriter().info("Entries in VM: " + numMemVm4 + "," + numMemVm5 + "," + numMemVm6 + "," + numMemVm7);
        long totalOverflown = numOvVm4 + numOvVm5 + numOvVm6 + numOvVm7;
        ParallelGatewaySenderQueueOverflowDUnitTest.assertTrue((String)"Total number of entries overflown to disk should be at least greater than 55", (totalOverflown > 55L ? 1 : 0) != 0);
        long totalInMemory = numMemVm4 + numMemVm5 + numMemVm6 + numMemVm7;
        ParallelGatewaySenderQueueOverflowDUnitTest.assertEquals((String)"Total number of entries on disk and in VM is incorrect", (long)(numEventPuts * 2), (long)(totalOverflown + totalInMemory));
        vm4.invoke(WANTestBase.class, "resumeSender", new Object[]{"ln"});
        vm5.invoke(WANTestBase.class, "resumeSender", new Object[]{"ln"});
        vm6.invoke(WANTestBase.class, "resumeSender", new Object[]{"ln"});
        vm7.invoke(WANTestBase.class, "resumeSender", new Object[]{"ln"});
        vm2.invoke(WANTestBase.class, "validateRegionSize", new Object[]{testName, 50});
        vm3.invoke(WANTestBase.class, "validateRegionSize", new Object[]{testName, 50});
    }

    public void testParallelSenderQueueEventsOverflow_2() throws Exception {
        Integer lnPort = (Integer)vm0.invoke(WANTestBase.class, "createFirstLocatorWithDSId", new Object[]{1});
        Integer nyPort = (Integer)vm1.invoke(WANTestBase.class, "createFirstRemoteLocator", new Object[]{2, lnPort});
        vm2.invoke(WANTestBase.class, "createReceiver", new Object[]{nyPort});
        vm3.invoke(WANTestBase.class, "createReceiver", new Object[]{nyPort});
        vm4.invoke(WANTestBase.class, "createCache", new Object[]{lnPort});
        vm5.invoke(WANTestBase.class, "createCache", new Object[]{lnPort});
        vm6.invoke(WANTestBase.class, "createCache", new Object[]{lnPort});
        vm7.invoke(WANTestBase.class, "createCache", new Object[]{lnPort});
        vm4.invoke(WANTestBase.class, "createSender", new Object[]{"ln", 2, true, 10, 10, false, false, null, true});
        vm5.invoke(WANTestBase.class, "createSender", new Object[]{"ln", 2, true, 5, 10, false, false, null, true});
        vm6.invoke(WANTestBase.class, "createSender", new Object[]{"ln", 2, true, 5, 10, false, false, null, true});
        vm7.invoke(WANTestBase.class, "createSender", new Object[]{"ln", 2, true, 20, 10, false, false, null, true});
        vm4.invoke(WANTestBase.class, "createPartitionedRegion", new Object[]{testName, "ln", 1, 100, this.isOffHeap()});
        vm5.invoke(WANTestBase.class, "createPartitionedRegion", new Object[]{testName, "ln", 1, 100, this.isOffHeap()});
        vm6.invoke(WANTestBase.class, "createPartitionedRegion", new Object[]{testName, "ln", 1, 100, this.isOffHeap()});
        vm7.invoke(WANTestBase.class, "createPartitionedRegion", new Object[]{testName, "ln", 1, 100, this.isOffHeap()});
        vm4.invoke(WANTestBase.class, "startSender", new Object[]{"ln"});
        vm5.invoke(WANTestBase.class, "startSender", new Object[]{"ln"});
        vm6.invoke(WANTestBase.class, "startSender", new Object[]{"ln"});
        vm7.invoke(WANTestBase.class, "startSender", new Object[]{"ln"});
        vm4.invoke(WANTestBase.class, "pauseSender", new Object[]{"ln"});
        vm5.invoke(WANTestBase.class, "pauseSender", new Object[]{"ln"});
        vm6.invoke(WANTestBase.class, "pauseSender", new Object[]{"ln"});
        vm7.invoke(WANTestBase.class, "pauseSender", new Object[]{"ln"});
        ParallelGatewaySenderQueueOverflowDUnitTest.pause(1000);
        vm2.invoke(WANTestBase.class, "createPartitionedRegion", new Object[]{testName, null, 1, 100, this.isOffHeap()});
        vm3.invoke(WANTestBase.class, "createPartitionedRegion", new Object[]{testName, null, 1, 100, this.isOffHeap()});
        int numEventPuts = 50;
        vm4.invoke(WANTestBase.class, "doHeavyPuts", new Object[]{testName, numEventPuts});
        long numOvVm4 = (Long)vm4.invoke(WANTestBase.class, "getNumberOfEntriesOverflownToDisk", new Object[]{"ln"});
        long numOvVm5 = (Long)vm5.invoke(WANTestBase.class, "getNumberOfEntriesOverflownToDisk", new Object[]{"ln"});
        long numOvVm6 = (Long)vm6.invoke(WANTestBase.class, "getNumberOfEntriesOverflownToDisk", new Object[]{"ln"});
        long numOvVm7 = (Long)vm7.invoke(WANTestBase.class, "getNumberOfEntriesOverflownToDisk", new Object[]{"ln"});
        long numMemVm4 = (Long)vm4.invoke(WANTestBase.class, "getNumberOfEntriesInVM", new Object[]{"ln"});
        long numMemVm5 = (Long)vm5.invoke(WANTestBase.class, "getNumberOfEntriesInVM", new Object[]{"ln"});
        long numMemVm6 = (Long)vm6.invoke(WANTestBase.class, "getNumberOfEntriesInVM", new Object[]{"ln"});
        long numMemVm7 = (Long)vm7.invoke(WANTestBase.class, "getNumberOfEntriesInVM", new Object[]{"ln"});
        ParallelGatewaySenderQueueOverflowDUnitTest.getLogWriter().info("Entries overflown to disk: " + numOvVm4 + "," + numOvVm5 + "," + numOvVm6 + "," + numOvVm7);
        ParallelGatewaySenderQueueOverflowDUnitTest.getLogWriter().info("Entries in VM: " + numMemVm4 + "," + numMemVm5 + "," + numMemVm6 + "," + numMemVm7);
        long totalOverflown = numOvVm4 + numOvVm5 + numOvVm6 + numOvVm7;
        ParallelGatewaySenderQueueOverflowDUnitTest.assertTrue((String)"Total number of entries overflown to disk should be at least greater than 55", (totalOverflown > 55L ? 1 : 0) != 0);
        long totalInMemory = numMemVm4 + numMemVm5 + numMemVm6 + numMemVm7;
        ParallelGatewaySenderQueueOverflowDUnitTest.assertEquals((String)"Total number of entries on disk and in VM is incorrect", (long)(numEventPuts * 2), (long)(totalOverflown + totalInMemory));
        ParallelGatewaySenderQueueOverflowDUnitTest.assertTrue((String)"Number of entries in memory VM4 is incorrect. Should be less than 10", (numMemVm4 < 10L ? 1 : 0) != 0);
        ParallelGatewaySenderQueueOverflowDUnitTest.assertTrue((String)"Number of entries in memory VM5 is incorrect. Should be less than 5", (numMemVm5 < 5L ? 1 : 0) != 0);
        ParallelGatewaySenderQueueOverflowDUnitTest.assertTrue((String)"Number of entries in memory VM6 is incorrect. Should be less than 5", (numMemVm6 < 5L ? 1 : 0) != 0);
        ParallelGatewaySenderQueueOverflowDUnitTest.assertTrue((String)"Number of entries in memory VM7 is incorrect. Should be less than 20", (numMemVm7 < 20L ? 1 : 0) != 0);
        vm4.invoke(WANTestBase.class, "resumeSender", new Object[]{"ln"});
        vm5.invoke(WANTestBase.class, "resumeSender", new Object[]{"ln"});
        vm6.invoke(WANTestBase.class, "resumeSender", new Object[]{"ln"});
        vm7.invoke(WANTestBase.class, "resumeSender", new Object[]{"ln"});
        vm2.invoke(WANTestBase.class, "validateRegionSize", new Object[]{testName, 50});
        vm3.invoke(WANTestBase.class, "validateRegionSize", new Object[]{testName, 50});
    }

    public void testParallelSenderQueueNoEventsOverflow() throws Exception {
        Integer lnPort = (Integer)vm0.invoke(WANTestBase.class, "createFirstLocatorWithDSId", new Object[]{1});
        Integer nyPort = (Integer)vm1.invoke(WANTestBase.class, "createFirstRemoteLocator", new Object[]{2, lnPort});
        vm2.invoke(WANTestBase.class, "createReceiver", new Object[]{nyPort});
        vm3.invoke(WANTestBase.class, "createReceiver", new Object[]{nyPort});
        vm4.invoke(WANTestBase.class, "createCache", new Object[]{lnPort});
        vm5.invoke(WANTestBase.class, "createCache", new Object[]{lnPort});
        vm6.invoke(WANTestBase.class, "createCache", new Object[]{lnPort});
        vm7.invoke(WANTestBase.class, "createCache", new Object[]{lnPort});
        vm4.invoke(WANTestBase.class, "createSender", new Object[]{"ln", 2, true, 10, 10, false, false, null, true});
        vm5.invoke(WANTestBase.class, "createSender", new Object[]{"ln", 2, true, 10, 10, false, false, null, true});
        vm6.invoke(WANTestBase.class, "createSender", new Object[]{"ln", 2, true, 10, 10, false, false, null, true});
        vm7.invoke(WANTestBase.class, "createSender", new Object[]{"ln", 2, true, 10, 10, false, false, null, true});
        vm4.invoke(WANTestBase.class, "createPartitionedRegion", new Object[]{testName, "ln", 1, 100, this.isOffHeap()});
        vm5.invoke(WANTestBase.class, "createPartitionedRegion", new Object[]{testName, "ln", 1, 100, this.isOffHeap()});
        vm6.invoke(WANTestBase.class, "createPartitionedRegion", new Object[]{testName, "ln", 1, 100, this.isOffHeap()});
        vm7.invoke(WANTestBase.class, "createPartitionedRegion", new Object[]{testName, "ln", 1, 100, this.isOffHeap()});
        vm4.invoke(WANTestBase.class, "startSender", new Object[]{"ln"});
        vm5.invoke(WANTestBase.class, "startSender", new Object[]{"ln"});
        vm6.invoke(WANTestBase.class, "startSender", new Object[]{"ln"});
        vm7.invoke(WANTestBase.class, "startSender", new Object[]{"ln"});
        vm4.invoke(WANTestBase.class, "pauseSender", new Object[]{"ln"});
        vm5.invoke(WANTestBase.class, "pauseSender", new Object[]{"ln"});
        vm6.invoke(WANTestBase.class, "pauseSender", new Object[]{"ln"});
        vm7.invoke(WANTestBase.class, "pauseSender", new Object[]{"ln"});
        ParallelGatewaySenderQueueOverflowDUnitTest.pause(1000);
        vm2.invoke(WANTestBase.class, "createPartitionedRegion", new Object[]{testName, null, 1, 100, this.isOffHeap()});
        vm3.invoke(WANTestBase.class, "createPartitionedRegion", new Object[]{testName, null, 1, 100, this.isOffHeap()});
        int numEventPuts = 15;
        vm4.invoke(WANTestBase.class, "doHeavyPuts", new Object[]{testName, numEventPuts});
        long numOvVm4 = (Long)vm4.invoke(WANTestBase.class, "getNumberOfEntriesOverflownToDisk", new Object[]{"ln"});
        long numOvVm5 = (Long)vm5.invoke(WANTestBase.class, "getNumberOfEntriesOverflownToDisk", new Object[]{"ln"});
        long numOvVm6 = (Long)vm6.invoke(WANTestBase.class, "getNumberOfEntriesOverflownToDisk", new Object[]{"ln"});
        long numOvVm7 = (Long)vm7.invoke(WANTestBase.class, "getNumberOfEntriesOverflownToDisk", new Object[]{"ln"});
        long numMemVm4 = (Long)vm4.invoke(WANTestBase.class, "getNumberOfEntriesInVM", new Object[]{"ln"});
        long numMemVm5 = (Long)vm5.invoke(WANTestBase.class, "getNumberOfEntriesInVM", new Object[]{"ln"});
        long numMemVm6 = (Long)vm6.invoke(WANTestBase.class, "getNumberOfEntriesInVM", new Object[]{"ln"});
        long numMemVm7 = (Long)vm7.invoke(WANTestBase.class, "getNumberOfEntriesInVM", new Object[]{"ln"});
        ParallelGatewaySenderQueueOverflowDUnitTest.getLogWriter().info("Entries overflown to disk: " + numOvVm4 + "," + numOvVm5 + "," + numOvVm6 + "," + numOvVm7);
        ParallelGatewaySenderQueueOverflowDUnitTest.getLogWriter().info("Entries in VM: " + numMemVm4 + "," + numMemVm5 + "," + numMemVm6 + "," + numMemVm7);
        long totalOverflown = numOvVm4 + numOvVm5 + numOvVm6 + numOvVm7;
        ParallelGatewaySenderQueueOverflowDUnitTest.assertEquals((String)"Total number of entries overflown to disk is incorrect", (long)0L, (long)totalOverflown);
        long totalInMemory = numMemVm4 + numMemVm5 + numMemVm6 + numMemVm7;
        ParallelGatewaySenderQueueOverflowDUnitTest.assertEquals((String)"Total number of entries on disk and in VM is incorrect", (long)(numEventPuts * 2), (long)(totalOverflown + totalInMemory));
        vm4.invoke(WANTestBase.class, "resumeSender", new Object[]{"ln"});
        vm5.invoke(WANTestBase.class, "resumeSender", new Object[]{"ln"});
        vm6.invoke(WANTestBase.class, "resumeSender", new Object[]{"ln"});
        vm7.invoke(WANTestBase.class, "resumeSender", new Object[]{"ln"});
        vm2.invoke(WANTestBase.class, "validateRegionSize", new Object[]{testName, 15});
        vm3.invoke(WANTestBase.class, "validateRegionSize", new Object[]{testName, 15});
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void test_ValidateParallelGatewaySenderQueueAttributes_1() {
        Integer localLocPort = (Integer)vm0.invoke(WANTestBase.class, "createFirstLocatorWithDSId", new Object[]{1});
        Integer remoteLocPort = (Integer)vm1.invoke(WANTestBase.class, "createFirstRemoteLocator", new Object[]{2, localLocPort});
        WANTestBase test = new WANTestBase(testName);
        Properties props = new Properties();
        props.setProperty("mcast-port", "0");
        props.setProperty("locators", "localhost[" + localLocPort + "]");
        InternalDistributedSystem ds = test.getSystem(props);
        cache = CacheFactory.create((DistributedSystem)ds);
        File directory = new File("TKSender_disk_" + System.currentTimeMillis() + "_" + VM.getCurrentVMNum());
        directory.mkdir();
        File[] dirs1 = new File[]{directory};
        DiskStoreFactory dsf = cache.createDiskStoreFactory();
        dsf.setDiskDirs(dirs1);
        DiskStore diskStore = dsf.create("FORNY");
        GatewaySenderFactory fact = cache.createGatewaySenderFactory();
        fact.setParallel(true);
        fact.setBatchConflationEnabled(true);
        fact.setBatchSize(200);
        fact.setBatchTimeInterval(300);
        fact.setPersistenceEnabled(true);
        fact.setDiskSynchronous(true);
        fact.setDiskStoreName("FORNY");
        fact.setMaximumQueueMemory(200);
        fact.setAlertThreshold(1200);
        MyGatewayEventFilter1 myeventfilter1 = new MyGatewayEventFilter1();
        fact.addGatewayEventFilter((GatewayEventFilter)myeventfilter1);
        MyGatewayTransportFilter1 myStreamfilter1 = new MyGatewayTransportFilter1();
        fact.addGatewayTransportFilter((GatewayTransportFilter)myStreamfilter1);
        MyGatewayTransportFilter2 myStreamfilter2 = new MyGatewayTransportFilter2();
        fact.addGatewayTransportFilter((GatewayTransportFilter)myStreamfilter2);
        DistributedTestCase.ExpectedException exTKSender = ParallelGatewaySenderQueueOverflowDUnitTest.addExpectedException("Could not connect");
        try {
            GatewaySender sender1 = fact.create("TKSender", 2);
            AttributesFactory factory = new AttributesFactory();
            factory.addGatewaySenderId(sender1.getId());
            factory.setDataPolicy(DataPolicy.PERSISTENT_PARTITION);
            Region region = cache.createRegionFactory(factory.create()).create("test_ValidateGatewaySenderAttributes");
            Set senders = cache.getGatewaySenders();
            ParallelGatewaySenderQueueOverflowDUnitTest.assertEquals((int)senders.size(), (int)1);
            GatewaySender gatewaySender = (GatewaySender)senders.iterator().next();
            Set regionQueues = ((ParallelGatewaySenderImpl)gatewaySender).getQueues();
            ParallelGatewaySenderQueueOverflowDUnitTest.assertEquals((int)regionQueues.size(), (int)1);
            RegionQueue regionQueue = (RegionQueue)regionQueues.iterator().next();
            ParallelGatewaySenderQueueOverflowDUnitTest.assertEquals((boolean)true, (boolean)regionQueue.getRegion().getAttributes().isDiskSynchronous());
        }
        finally {
            exTKSender.remove();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void test_ValidateParallelGatewaySenderQueueAttributes_2() {
        Integer localLocPort = (Integer)vm0.invoke(WANTestBase.class, "createFirstLocatorWithDSId", new Object[]{1});
        Integer remoteLocPort = (Integer)vm1.invoke(WANTestBase.class, "createFirstRemoteLocator", new Object[]{2, localLocPort});
        WANTestBase test = new WANTestBase(testName);
        Properties props = new Properties();
        props.setProperty("mcast-port", "0");
        props.setProperty("locators", "localhost[" + localLocPort + "]");
        InternalDistributedSystem ds = test.getSystem(props);
        cache = CacheFactory.create((DistributedSystem)ds);
        GatewaySenderFactory fact = cache.createGatewaySenderFactory();
        fact.setParallel(true);
        fact.setBatchConflationEnabled(true);
        fact.setBatchSize(200);
        fact.setBatchTimeInterval(300);
        fact.setPersistenceEnabled(false);
        fact.setDiskSynchronous(true);
        fact.setMaximumQueueMemory(200);
        fact.setAlertThreshold(1200);
        MyGatewayEventFilter1 myeventfilter1 = new MyGatewayEventFilter1();
        fact.addGatewayEventFilter((GatewayEventFilter)myeventfilter1);
        MyGatewayTransportFilter1 myStreamfilter1 = new MyGatewayTransportFilter1();
        fact.addGatewayTransportFilter((GatewayTransportFilter)myStreamfilter1);
        MyGatewayTransportFilter2 myStreamfilter2 = new MyGatewayTransportFilter2();
        fact.addGatewayTransportFilter((GatewayTransportFilter)myStreamfilter2);
        DistributedTestCase.ExpectedException ex = ParallelGatewaySenderQueueOverflowDUnitTest.addExpectedException("Could not connect");
        try {
            GatewaySender sender1 = fact.create("TKSender", 2);
            AttributesFactory factory = new AttributesFactory();
            factory.addGatewaySenderId(sender1.getId());
            factory.setDataPolicy(DataPolicy.PARTITION);
            Region region = cache.createRegionFactory(factory.create()).create("test_ValidateGatewaySenderAttributes");
            Set senders = cache.getGatewaySenders();
            ParallelGatewaySenderQueueOverflowDUnitTest.assertEquals((int)senders.size(), (int)1);
            GatewaySender gatewaySender = (GatewaySender)senders.iterator().next();
            Set regionQueues = ((ParallelGatewaySenderImpl)gatewaySender).getQueues();
            ParallelGatewaySenderQueueOverflowDUnitTest.assertEquals((int)regionQueues.size(), (int)1);
            RegionQueue regionQueue = (RegionQueue)regionQueues.iterator().next();
            ParallelGatewaySenderQueueOverflowDUnitTest.assertEquals((boolean)false, (boolean)regionQueue.getRegion().getAttributes().isDiskSynchronous());
        }
        finally {
            ex.remove();
        }
    }
}

