/*
 * Decompiled with CFR 0.152.
 */
package com.gemstone.gemfire.internal.cache.wan.parallel;

import com.gemstone.gemfire.cache.AttributesFactory;
import com.gemstone.gemfire.cache.PartitionAttributesFactory;
import com.gemstone.gemfire.cache.Region;
import com.gemstone.gemfire.cache.wan.GatewaySender;
import com.gemstone.gemfire.cache.wan.GatewaySenderFactory;
import com.gemstone.gemfire.internal.cache.wan.WANTestBase;
import dunit.AsyncInvocation;
import dunit.DistributedTestCase;
import java.io.IOException;

public class ParallelWANPersistenceEnabledGatewaySenderDUnitTest
extends WANTestBase {
    private static final long serialVersionUID = 1L;

    public ParallelWANPersistenceEnabledGatewaySenderDUnitTest(String name) {
        super(name);
    }

    @Override
    public void setUp() throws Exception {
        super.setUp();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testPartitionedRegionWithGatewaySenderPersistenceEnabled() throws IOException {
        try {
            Integer lnPort = (Integer)vm0.invoke(WANTestBase.class, "createFirstLocatorWithDSId", new Object[]{1});
            Integer nyPort = (Integer)vm1.invoke(WANTestBase.class, "createFirstRemoteLocator", new Object[]{2, lnPort});
            ParallelWANPersistenceEnabledGatewaySenderDUnitTest.createCache(lnPort);
            GatewaySenderFactory fact = cache.createGatewaySenderFactory();
            fact.setPersistenceEnabled(true);
            fact.setParallel(true);
            DistributedTestCase.ExpectedException ex = ParallelWANPersistenceEnabledGatewaySenderDUnitTest.addExpectedException("Could not connect");
            try {
                GatewaySender sender1 = fact.create("NYSender", 2);
                AttributesFactory rFact = new AttributesFactory();
                rFact.addGatewaySenderId(sender1.getId());
                PartitionAttributesFactory pfact = new PartitionAttributesFactory();
                pfact.setTotalNumBuckets(100);
                pfact.setRedundantCopies(1);
                rFact.setPartitionAttributes(pfact.create());
                Region r = cache.createRegionFactory(rFact.create()).create("MyRegion");
                sender1.start();
            }
            finally {
                ex.remove();
            }
        }
        catch (Exception e) {
            ParallelWANPersistenceEnabledGatewaySenderDUnitTest.fail((String)("UnExpectd Exception :" + e));
        }
    }

    public void testPersistentPartitionedRegionWithGatewaySender() {
        Integer lnPort = (Integer)vm0.invoke(WANTestBase.class, "createFirstLocatorWithDSId", new Object[]{1});
        Integer nyPort = (Integer)vm1.invoke(WANTestBase.class, "createFirstRemoteLocator", new Object[]{2, lnPort});
        vm2.invoke(WANTestBase.class, "createReceiver", new Object[]{nyPort});
        vm3.invoke(WANTestBase.class, "createReceiver", new Object[]{nyPort});
        ParallelWANPersistenceEnabledGatewaySenderDUnitTest.getLogWriter().info("Created remote receivers");
        vm4.invoke(WANTestBase.class, "createCache", new Object[]{lnPort});
        vm5.invoke(WANTestBase.class, "createCache", new Object[]{lnPort});
        vm6.invoke(WANTestBase.class, "createCache", new Object[]{lnPort});
        vm7.invoke(WANTestBase.class, "createCache", new Object[]{lnPort});
        ParallelWANPersistenceEnabledGatewaySenderDUnitTest.getLogWriter().info("Created local site cache");
        vm4.invoke(WANTestBase.class, "createSender", new Object[]{"ln", 2, true, 100, 10, false, false, null, true});
        vm5.invoke(WANTestBase.class, "createSender", new Object[]{"ln", 2, true, 100, 10, false, false, null, true});
        vm6.invoke(WANTestBase.class, "createSender", new Object[]{"ln", 2, true, 100, 10, false, false, null, true});
        vm7.invoke(WANTestBase.class, "createSender", new Object[]{"ln", 2, true, 100, 10, false, false, null, true});
        ParallelWANPersistenceEnabledGatewaySenderDUnitTest.getLogWriter().info("Created local site senders");
        vm4.invoke(WANTestBase.class, "createPersistentPartitionedRegion", new Object[]{testName, "ln", 1, 100, this.isOffHeap()});
        vm5.invoke(WANTestBase.class, "createPersistentPartitionedRegion", new Object[]{testName, "ln", 1, 100, this.isOffHeap()});
        vm6.invoke(WANTestBase.class, "createPersistentPartitionedRegion", new Object[]{testName, "ln", 1, 100, this.isOffHeap()});
        vm7.invoke(WANTestBase.class, "createPersistentPartitionedRegion", new Object[]{testName, "ln", 1, 100, this.isOffHeap()});
        ParallelWANPersistenceEnabledGatewaySenderDUnitTest.getLogWriter().info("Created local site persistent PR");
        vm4.invoke(WANTestBase.class, "startSender", new Object[]{"ln"});
        ParallelWANPersistenceEnabledGatewaySenderDUnitTest.getLogWriter().info("Started sender on vm4");
        vm5.invoke(WANTestBase.class, "startSender", new Object[]{"ln"});
        vm6.invoke(WANTestBase.class, "startSender", new Object[]{"ln"});
        vm7.invoke(WANTestBase.class, "startSender", new Object[]{"ln"});
        ParallelWANPersistenceEnabledGatewaySenderDUnitTest.getLogWriter().info("Started the senders");
        vm2.invoke(WANTestBase.class, "createPersistentPartitionedRegion", new Object[]{testName, null, 1, 100, this.isOffHeap()});
        vm3.invoke(WANTestBase.class, "createPersistentPartitionedRegion", new Object[]{testName, null, 1, 100, this.isOffHeap()});
        vm4.invoke(WANTestBase.class, "doPuts", new Object[]{testName, 1000});
        vm2.invoke(WANTestBase.class, "validateRegionSize", new Object[]{testName, 1000});
        vm3.invoke(WANTestBase.class, "validateRegionSize", new Object[]{testName, 1000});
    }

    public void testPersistentPartitionedRegionWithGatewaySenderPersistenceEnabled() {
        Integer lnPort = (Integer)vm0.invoke(WANTestBase.class, "createFirstLocatorWithDSId", new Object[]{1});
        Integer nyPort = (Integer)vm1.invoke(WANTestBase.class, "createFirstRemoteLocator", new Object[]{2, lnPort});
        vm2.invoke(WANTestBase.class, "createReceiver", new Object[]{nyPort});
        vm3.invoke(WANTestBase.class, "createReceiver", new Object[]{nyPort});
        vm4.invoke(WANTestBase.class, "createCache", new Object[]{lnPort});
        vm5.invoke(WANTestBase.class, "createCache", new Object[]{lnPort});
        vm6.invoke(WANTestBase.class, "createCache", new Object[]{lnPort});
        vm7.invoke(WANTestBase.class, "createCache", new Object[]{lnPort});
        vm4.invoke(WANTestBase.class, "createSender", new Object[]{"ln", 2, true, 100, 10, false, true, null, true});
        vm5.invoke(WANTestBase.class, "createSender", new Object[]{"ln", 2, true, 100, 10, false, true, null, true});
        vm6.invoke(WANTestBase.class, "createSender", new Object[]{"ln", 2, true, 100, 10, false, true, null, true});
        vm7.invoke(WANTestBase.class, "createSender", new Object[]{"ln", 2, true, 100, 10, false, true, null, true});
        vm4.invoke(WANTestBase.class, "createPersistentPartitionedRegion", new Object[]{testName, "ln", 1, 100, this.isOffHeap()});
        vm5.invoke(WANTestBase.class, "createPersistentPartitionedRegion", new Object[]{testName, "ln", 1, 100, this.isOffHeap()});
        vm6.invoke(WANTestBase.class, "createPersistentPartitionedRegion", new Object[]{testName, "ln", 1, 100, this.isOffHeap()});
        vm7.invoke(WANTestBase.class, "createPersistentPartitionedRegion", new Object[]{testName, "ln", 1, 100, this.isOffHeap()});
        vm4.invoke(WANTestBase.class, "startSender", new Object[]{"ln"});
        vm5.invoke(WANTestBase.class, "startSender", new Object[]{"ln"});
        vm6.invoke(WANTestBase.class, "startSender", new Object[]{"ln"});
        vm7.invoke(WANTestBase.class, "startSender", new Object[]{"ln"});
        vm2.invoke(WANTestBase.class, "createPersistentPartitionedRegion", new Object[]{testName, null, 1, 100, this.isOffHeap()});
        vm3.invoke(WANTestBase.class, "createPersistentPartitionedRegion", new Object[]{testName, null, 1, 100, this.isOffHeap()});
        vm4.invoke(WANTestBase.class, "doPuts", new Object[]{testName, 1000});
        vm2.invoke(WANTestBase.class, "validateRegionSize", new Object[]{testName, 1000});
        vm3.invoke(WANTestBase.class, "validateRegionSize", new Object[]{testName, 1000});
    }

    public void testPartitionedRegionWithPersistentGatewaySender() {
        Integer lnPort = (Integer)vm0.invoke(WANTestBase.class, "createFirstLocatorWithDSId", new Object[]{1});
        Integer nyPort = (Integer)vm1.invoke(WANTestBase.class, "createFirstRemoteLocator", new Object[]{2, lnPort});
        vm2.invoke(WANTestBase.class, "createReceiver", new Object[]{nyPort});
        vm3.invoke(WANTestBase.class, "createReceiver", new Object[]{nyPort});
        ParallelWANPersistenceEnabledGatewaySenderDUnitTest.getLogWriter().info("Created remote receivers");
        vm4.invoke(WANTestBase.class, "createCache", new Object[]{lnPort});
        vm5.invoke(WANTestBase.class, "createCache", new Object[]{lnPort});
        vm6.invoke(WANTestBase.class, "createCache", new Object[]{lnPort});
        vm7.invoke(WANTestBase.class, "createCache", new Object[]{lnPort});
        ParallelWANPersistenceEnabledGatewaySenderDUnitTest.getLogWriter().info("Created local site cache");
        vm4.invoke(WANTestBase.class, "createSender", new Object[]{"ln", 2, true, 100, 10, false, true, null, true});
        vm5.invoke(WANTestBase.class, "createSender", new Object[]{"ln", 2, true, 100, 10, false, true, null, true});
        vm6.invoke(WANTestBase.class, "createSender", new Object[]{"ln", 2, true, 100, 10, false, true, null, true});
        vm7.invoke(WANTestBase.class, "createSender", new Object[]{"ln", 2, true, 100, 10, false, true, null, true});
        ParallelWANPersistenceEnabledGatewaySenderDUnitTest.getLogWriter().info("Created local site senders");
        vm4.invoke(WANTestBase.class, "createPartitionedRegion", new Object[]{testName, "ln", 1, 100, this.isOffHeap()});
        vm5.invoke(WANTestBase.class, "createPartitionedRegion", new Object[]{testName, "ln", 1, 100, this.isOffHeap()});
        vm6.invoke(WANTestBase.class, "createPartitionedRegion", new Object[]{testName, "ln", 1, 100, this.isOffHeap()});
        vm7.invoke(WANTestBase.class, "createPartitionedRegion", new Object[]{testName, "ln", 1, 100, this.isOffHeap()});
        ParallelWANPersistenceEnabledGatewaySenderDUnitTest.getLogWriter().info("Created local site persistent PR");
        vm4.invoke(WANTestBase.class, "startSender", new Object[]{"ln"});
        ParallelWANPersistenceEnabledGatewaySenderDUnitTest.getLogWriter().info("Started sender on vm4");
        vm5.invoke(WANTestBase.class, "startSender", new Object[]{"ln"});
        vm6.invoke(WANTestBase.class, "startSender", new Object[]{"ln"});
        vm7.invoke(WANTestBase.class, "startSender", new Object[]{"ln"});
        ParallelWANPersistenceEnabledGatewaySenderDUnitTest.getLogWriter().info("Started the senders");
        vm2.invoke(WANTestBase.class, "createPartitionedRegion", new Object[]{testName, null, 1, 100, this.isOffHeap()});
        vm3.invoke(WANTestBase.class, "createPartitionedRegion", new Object[]{testName, null, 1, 100, this.isOffHeap()});
        vm4.invoke(WANTestBase.class, "doPuts", new Object[]{testName, 1000});
        vm2.invoke(WANTestBase.class, "validateRegionSize", new Object[]{testName, 1000});
        vm3.invoke(WANTestBase.class, "validateRegionSize", new Object[]{testName, 1000});
    }

    public void testPRWithGatewaySenderPersistenceEnabled_Restart() {
        Integer lnPort = (Integer)vm0.invoke(WANTestBase.class, "createFirstLocatorWithDSId", new Object[]{1});
        Integer nyPort = (Integer)vm1.invoke(WANTestBase.class, "createFirstRemoteLocator", new Object[]{2, lnPort});
        vm2.invoke(WANTestBase.class, "createReceiver", new Object[]{nyPort});
        vm3.invoke(WANTestBase.class, "createReceiver", new Object[]{nyPort});
        vm4.invoke(WANTestBase.class, "createCache", new Object[]{lnPort});
        vm5.invoke(WANTestBase.class, "createCache", new Object[]{lnPort});
        vm6.invoke(WANTestBase.class, "createCache", new Object[]{lnPort});
        vm7.invoke(WANTestBase.class, "createCache", new Object[]{lnPort});
        String diskStore1 = (String)vm4.invoke(WANTestBase.class, "createSenderWithDiskStore", new Object[]{"ln", 2, true, 100, 10, false, true, null, null, true});
        String diskStore2 = (String)vm5.invoke(WANTestBase.class, "createSenderWithDiskStore", new Object[]{"ln", 2, true, 100, 10, false, true, null, null, true});
        String diskStore3 = (String)vm6.invoke(WANTestBase.class, "createSenderWithDiskStore", new Object[]{"ln", 2, true, 100, 10, false, true, null, null, true});
        String diskStore4 = (String)vm7.invoke(WANTestBase.class, "createSenderWithDiskStore", new Object[]{"ln", 2, true, 100, 10, false, true, null, null, true});
        ParallelWANPersistenceEnabledGatewaySenderDUnitTest.getLogWriter().info("The DS are: " + diskStore1 + "," + diskStore2 + "," + diskStore3 + "," + diskStore4);
        vm2.invoke(WANTestBase.class, "createPartitionedRegion", new Object[]{testName, null, 1, 100, this.isOffHeap()});
        vm3.invoke(WANTestBase.class, "createPartitionedRegion", new Object[]{testName, null, 1, 100, this.isOffHeap()});
        vm4.invoke(WANTestBase.class, "createPartitionedRegion", new Object[]{testName, "ln", 1, 100, this.isOffHeap()});
        vm5.invoke(WANTestBase.class, "createPartitionedRegion", new Object[]{testName, "ln", 1, 100, this.isOffHeap()});
        vm6.invoke(WANTestBase.class, "createPartitionedRegion", new Object[]{testName, "ln", 1, 100, this.isOffHeap()});
        vm7.invoke(WANTestBase.class, "createPartitionedRegion", new Object[]{testName, "ln", 1, 100, this.isOffHeap()});
        vm4.invoke(WANTestBase.class, "startSender", new Object[]{"ln"});
        vm5.invoke(WANTestBase.class, "startSender", new Object[]{"ln"});
        vm6.invoke(WANTestBase.class, "startSender", new Object[]{"ln"});
        vm7.invoke(WANTestBase.class, "startSender", new Object[]{"ln"});
        vm4.invoke(WANTestBase.class, "waitForSenderRunningState", new Object[]{"ln"});
        vm5.invoke(WANTestBase.class, "waitForSenderRunningState", new Object[]{"ln"});
        vm6.invoke(WANTestBase.class, "waitForSenderRunningState", new Object[]{"ln"});
        vm7.invoke(WANTestBase.class, "waitForSenderRunningState", new Object[]{"ln"});
        vm4.invoke(WANTestBase.class, "pauseSender", new Object[]{"ln"});
        vm5.invoke(WANTestBase.class, "pauseSender", new Object[]{"ln"});
        vm6.invoke(WANTestBase.class, "pauseSender", new Object[]{"ln"});
        vm7.invoke(WANTestBase.class, "pauseSender", new Object[]{"ln"});
        vm4.invoke(WANTestBase.class, "doPuts", new Object[]{testName, 3000});
        ParallelWANPersistenceEnabledGatewaySenderDUnitTest.getLogWriter().info("Completed puts in the region");
        vm4.invoke(WANTestBase.class, "killSender", new Object[0]);
        vm5.invoke(WANTestBase.class, "killSender", new Object[0]);
        vm6.invoke(WANTestBase.class, "killSender", new Object[0]);
        vm7.invoke(WANTestBase.class, "killSender", new Object[0]);
        ParallelWANPersistenceEnabledGatewaySenderDUnitTest.getLogWriter().info("Killed all the senders.");
        vm4.invoke(WANTestBase.class, "createCache", new Object[]{lnPort});
        vm5.invoke(WANTestBase.class, "createCache", new Object[]{lnPort});
        vm6.invoke(WANTestBase.class, "createCache", new Object[]{lnPort});
        vm7.invoke(WANTestBase.class, "createCache", new Object[]{lnPort});
        ParallelWANPersistenceEnabledGatewaySenderDUnitTest.getLogWriter().info("Created back the cache");
        vm4.invoke(WANTestBase.class, "createSenderWithDiskStore", new Object[]{"ln", 2, true, 100, 10, false, true, null, diskStore1, true});
        vm5.invoke(WANTestBase.class, "createSenderWithDiskStore", new Object[]{"ln", 2, true, 100, 10, false, true, null, diskStore2, true});
        vm6.invoke(WANTestBase.class, "createSenderWithDiskStore", new Object[]{"ln", 2, true, 100, 10, false, true, null, diskStore3, true});
        vm7.invoke(WANTestBase.class, "createSenderWithDiskStore", new Object[]{"ln", 2, true, 100, 10, false, true, null, diskStore4, true});
        ParallelWANPersistenceEnabledGatewaySenderDUnitTest.getLogWriter().info("Created the senders back from the disk store.");
        AsyncInvocation inv1 = vm4.invokeAsync(WANTestBase.class, "createPartitionedRegion", new Object[]{testName, "ln", 1, 100, this.isOffHeap()});
        AsyncInvocation inv2 = vm5.invokeAsync(WANTestBase.class, "createPartitionedRegion", new Object[]{testName, "ln", 1, 100, this.isOffHeap()});
        AsyncInvocation inv3 = vm6.invokeAsync(WANTestBase.class, "createPartitionedRegion", new Object[]{testName, "ln", 1, 100, this.isOffHeap()});
        AsyncInvocation inv4 = vm7.invokeAsync(WANTestBase.class, "createPartitionedRegion", new Object[]{testName, "ln", 1, 100, this.isOffHeap()});
        try {
            inv1.join();
            inv2.join();
            inv3.join();
            inv4.join();
        }
        catch (InterruptedException e) {
            e.printStackTrace();
            ParallelWANPersistenceEnabledGatewaySenderDUnitTest.fail();
        }
        ParallelWANPersistenceEnabledGatewaySenderDUnitTest.getLogWriter().info("Created back the partitioned regions");
        vm4.invokeAsync(WANTestBase.class, "startSender", new Object[]{"ln"});
        vm5.invokeAsync(WANTestBase.class, "startSender", new Object[]{"ln"});
        vm6.invokeAsync(WANTestBase.class, "startSender", new Object[]{"ln"});
        vm7.invokeAsync(WANTestBase.class, "startSender", new Object[]{"ln"});
        ParallelWANPersistenceEnabledGatewaySenderDUnitTest.getLogWriter().info("Waiting for senders running.");
        vm4.invoke(WANTestBase.class, "waitForSenderRunningState", new Object[]{"ln"});
        vm5.invoke(WANTestBase.class, "waitForSenderRunningState", new Object[]{"ln"});
        vm6.invoke(WANTestBase.class, "waitForSenderRunningState", new Object[]{"ln"});
        vm7.invoke(WANTestBase.class, "waitForSenderRunningState", new Object[]{"ln"});
        ParallelWANPersistenceEnabledGatewaySenderDUnitTest.getLogWriter().info("All the senders are now running...");
        vm2.invoke(WANTestBase.class, "validateRegionSize", new Object[]{testName, 3000});
        vm3.invoke(WANTestBase.class, "validateRegionSize", new Object[]{testName, 3000});
    }

    public void testPersistentPRWithGatewaySenderPersistenceEnabled_Restart() {
        Integer lnPort = (Integer)vm0.invoke(WANTestBase.class, "createFirstLocatorWithDSId", new Object[]{1});
        Integer nyPort = (Integer)vm1.invoke(WANTestBase.class, "createFirstRemoteLocator", new Object[]{2, lnPort});
        vm2.invoke(WANTestBase.class, "createReceiver", new Object[]{nyPort});
        vm3.invoke(WANTestBase.class, "createReceiver", new Object[]{nyPort});
        vm4.invoke(WANTestBase.class, "createCache", new Object[]{lnPort});
        vm5.invoke(WANTestBase.class, "createCache", new Object[]{lnPort});
        vm6.invoke(WANTestBase.class, "createCache", new Object[]{lnPort});
        vm7.invoke(WANTestBase.class, "createCache", new Object[]{lnPort});
        String diskStore1 = (String)vm4.invoke(WANTestBase.class, "createSenderWithDiskStore", new Object[]{"ln", 2, true, 100, 10, false, true, null, null, true});
        String diskStore2 = (String)vm5.invoke(WANTestBase.class, "createSenderWithDiskStore", new Object[]{"ln", 2, true, 100, 10, false, true, null, null, true});
        String diskStore3 = (String)vm6.invoke(WANTestBase.class, "createSenderWithDiskStore", new Object[]{"ln", 2, true, 100, 10, false, true, null, null, true});
        String diskStore4 = (String)vm7.invoke(WANTestBase.class, "createSenderWithDiskStore", new Object[]{"ln", 2, true, 100, 10, false, true, null, null, true});
        ParallelWANPersistenceEnabledGatewaySenderDUnitTest.getLogWriter().info("The DS are: " + diskStore1 + "," + diskStore2 + "," + diskStore3 + "," + diskStore4);
        vm2.invoke(WANTestBase.class, "createPersistentPartitionedRegion", new Object[]{testName, null, 1, 100, this.isOffHeap()});
        vm3.invoke(WANTestBase.class, "createPersistentPartitionedRegion", new Object[]{testName, null, 1, 100, this.isOffHeap()});
        vm4.invoke(WANTestBase.class, "createPersistentPartitionedRegion", new Object[]{testName, "ln", 1, 100, this.isOffHeap()});
        vm5.invoke(WANTestBase.class, "createPersistentPartitionedRegion", new Object[]{testName, "ln", 1, 100, this.isOffHeap()});
        vm6.invoke(WANTestBase.class, "createPersistentPartitionedRegion", new Object[]{testName, "ln", 1, 100, this.isOffHeap()});
        vm7.invoke(WANTestBase.class, "createPersistentPartitionedRegion", new Object[]{testName, "ln", 1, 100, this.isOffHeap()});
        vm4.invoke(WANTestBase.class, "startSender", new Object[]{"ln"});
        vm5.invoke(WANTestBase.class, "startSender", new Object[]{"ln"});
        vm6.invoke(WANTestBase.class, "startSender", new Object[]{"ln"});
        vm7.invoke(WANTestBase.class, "startSender", new Object[]{"ln"});
        vm4.invoke(WANTestBase.class, "waitForSenderRunningState", new Object[]{"ln"});
        vm5.invoke(WANTestBase.class, "waitForSenderRunningState", new Object[]{"ln"});
        vm6.invoke(WANTestBase.class, "waitForSenderRunningState", new Object[]{"ln"});
        vm7.invoke(WANTestBase.class, "waitForSenderRunningState", new Object[]{"ln"});
        vm4.invoke(WANTestBase.class, "pauseSender", new Object[]{"ln"});
        vm5.invoke(WANTestBase.class, "pauseSender", new Object[]{"ln"});
        vm6.invoke(WANTestBase.class, "pauseSender", new Object[]{"ln"});
        vm7.invoke(WANTestBase.class, "pauseSender", new Object[]{"ln"});
        vm4.invoke(WANTestBase.class, "doPuts", new Object[]{testName, 3000});
        ParallelWANPersistenceEnabledGatewaySenderDUnitTest.getLogWriter().info("Completed puts in the region");
        vm4.invoke(WANTestBase.class, "killSender", new Object[0]);
        vm5.invoke(WANTestBase.class, "killSender", new Object[0]);
        vm6.invoke(WANTestBase.class, "killSender", new Object[0]);
        vm7.invoke(WANTestBase.class, "killSender", new Object[0]);
        ParallelWANPersistenceEnabledGatewaySenderDUnitTest.getLogWriter().info("Killed all the senders.");
        vm4.invoke(WANTestBase.class, "createCache", new Object[]{lnPort});
        vm5.invoke(WANTestBase.class, "createCache", new Object[]{lnPort});
        vm6.invoke(WANTestBase.class, "createCache", new Object[]{lnPort});
        vm7.invoke(WANTestBase.class, "createCache", new Object[]{lnPort});
        ParallelWANPersistenceEnabledGatewaySenderDUnitTest.getLogWriter().info("Created back the cache");
        vm4.invoke(WANTestBase.class, "createSenderWithDiskStore", new Object[]{"ln", 2, true, 100, 10, false, true, null, diskStore1, true});
        vm5.invoke(WANTestBase.class, "createSenderWithDiskStore", new Object[]{"ln", 2, true, 100, 10, false, true, null, diskStore2, true});
        vm6.invoke(WANTestBase.class, "createSenderWithDiskStore", new Object[]{"ln", 2, true, 100, 10, false, true, null, diskStore3, true});
        vm7.invoke(WANTestBase.class, "createSenderWithDiskStore", new Object[]{"ln", 2, true, 100, 10, false, true, null, diskStore4, true});
        ParallelWANPersistenceEnabledGatewaySenderDUnitTest.getLogWriter().info("Created the senders back from the disk store.");
        AsyncInvocation inv1 = vm4.invokeAsync(WANTestBase.class, "createPersistentPartitionedRegion", new Object[]{testName, "ln", 1, 100, this.isOffHeap()});
        AsyncInvocation inv2 = vm5.invokeAsync(WANTestBase.class, "createPersistentPartitionedRegion", new Object[]{testName, "ln", 1, 100, this.isOffHeap()});
        AsyncInvocation inv3 = vm6.invokeAsync(WANTestBase.class, "createPersistentPartitionedRegion", new Object[]{testName, "ln", 1, 100, this.isOffHeap()});
        AsyncInvocation inv4 = vm7.invokeAsync(WANTestBase.class, "createPersistentPartitionedRegion", new Object[]{testName, "ln", 1, 100, this.isOffHeap()});
        try {
            inv1.join();
            inv2.join();
            inv3.join();
            inv4.join();
        }
        catch (InterruptedException e) {
            e.printStackTrace();
            ParallelWANPersistenceEnabledGatewaySenderDUnitTest.fail();
        }
        ParallelWANPersistenceEnabledGatewaySenderDUnitTest.getLogWriter().info("Created back the partitioned regions");
        vm4.invokeAsync(WANTestBase.class, "startSender", new Object[]{"ln"});
        vm5.invokeAsync(WANTestBase.class, "startSender", new Object[]{"ln"});
        vm6.invokeAsync(WANTestBase.class, "startSender", new Object[]{"ln"});
        vm7.invokeAsync(WANTestBase.class, "startSender", new Object[]{"ln"});
        ParallelWANPersistenceEnabledGatewaySenderDUnitTest.getLogWriter().info("Waiting for senders running.");
        vm4.invoke(WANTestBase.class, "waitForSenderRunningState", new Object[]{"ln"});
        vm5.invoke(WANTestBase.class, "waitForSenderRunningState", new Object[]{"ln"});
        vm6.invoke(WANTestBase.class, "waitForSenderRunningState", new Object[]{"ln"});
        vm7.invoke(WANTestBase.class, "waitForSenderRunningState", new Object[]{"ln"});
        ParallelWANPersistenceEnabledGatewaySenderDUnitTest.getLogWriter().info("All the senders are now running...");
        vm2.invoke(WANTestBase.class, "validateRegionSize", new Object[]{testName, 3000});
        vm3.invoke(WANTestBase.class, "validateRegionSize", new Object[]{testName, 3000});
    }

    public void testPersistentPRWithGatewaySenderPersistenceEnabled_Restart2() {
        Integer lnPort = (Integer)vm0.invoke(WANTestBase.class, "createFirstLocatorWithDSId", new Object[]{1});
        Integer nyPort = (Integer)vm1.invoke(WANTestBase.class, "createFirstRemoteLocator", new Object[]{2, lnPort});
        vm4.invoke(WANTestBase.class, "createCache", new Object[]{lnPort});
        vm5.invoke(WANTestBase.class, "createCache", new Object[]{lnPort});
        vm6.invoke(WANTestBase.class, "createCache", new Object[]{lnPort});
        vm7.invoke(WANTestBase.class, "createCache", new Object[]{lnPort});
        String diskStore1 = (String)vm4.invoke(WANTestBase.class, "createSenderWithDiskStore", new Object[]{"ln", 2, true, 100, 10, false, true, null, null, false});
        String diskStore2 = (String)vm5.invoke(WANTestBase.class, "createSenderWithDiskStore", new Object[]{"ln", 2, true, 100, 10, false, true, null, null, false});
        String diskStore3 = (String)vm6.invoke(WANTestBase.class, "createSenderWithDiskStore", new Object[]{"ln", 2, true, 100, 10, false, true, null, null, false});
        String diskStore4 = (String)vm7.invoke(WANTestBase.class, "createSenderWithDiskStore", new Object[]{"ln", 2, true, 100, 10, false, true, null, null, false});
        ParallelWANPersistenceEnabledGatewaySenderDUnitTest.getLogWriter().info("The DS are: " + diskStore1 + "," + diskStore2 + "," + diskStore3 + "," + diskStore4);
        vm4.invoke(WANTestBase.class, "createPersistentPartitionedRegion", new Object[]{testName, "ln", 1, 100, this.isOffHeap()});
        vm5.invoke(WANTestBase.class, "createPersistentPartitionedRegion", new Object[]{testName, "ln", 1, 100, this.isOffHeap()});
        vm6.invoke(WANTestBase.class, "createPersistentPartitionedRegion", new Object[]{testName, "ln", 1, 100, this.isOffHeap()});
        vm7.invoke(WANTestBase.class, "createPersistentPartitionedRegion", new Object[]{testName, "ln", 1, 100, this.isOffHeap()});
        vm4.invoke(WANTestBase.class, "startSender", new Object[]{"ln"});
        vm5.invoke(WANTestBase.class, "startSender", new Object[]{"ln"});
        vm6.invoke(WANTestBase.class, "startSender", new Object[]{"ln"});
        vm7.invoke(WANTestBase.class, "startSender", new Object[]{"ln"});
        vm4.invoke(WANTestBase.class, "waitForSenderRunningState", new Object[]{"ln"});
        vm5.invoke(WANTestBase.class, "waitForSenderRunningState", new Object[]{"ln"});
        vm6.invoke(WANTestBase.class, "waitForSenderRunningState", new Object[]{"ln"});
        vm7.invoke(WANTestBase.class, "waitForSenderRunningState", new Object[]{"ln"});
        vm4.invoke(WANTestBase.class, "pauseSender", new Object[]{"ln"});
        vm5.invoke(WANTestBase.class, "pauseSender", new Object[]{"ln"});
        vm6.invoke(WANTestBase.class, "pauseSender", new Object[]{"ln"});
        vm7.invoke(WANTestBase.class, "pauseSender", new Object[]{"ln"});
        vm4.invoke(WANTestBase.class, "doPuts", new Object[]{testName, 300});
        ParallelWANPersistenceEnabledGatewaySenderDUnitTest.getLogWriter().info("Completed puts in the region");
        vm4.invoke(WANTestBase.class, "killSender", new Object[0]);
        vm5.invoke(WANTestBase.class, "killSender", new Object[0]);
        vm6.invoke(WANTestBase.class, "killSender", new Object[0]);
        vm7.invoke(WANTestBase.class, "killSender", new Object[0]);
        ParallelWANPersistenceEnabledGatewaySenderDUnitTest.getLogWriter().info("Killed all the senders.");
        vm4.invoke(WANTestBase.class, "createCache", new Object[]{lnPort});
        vm5.invoke(WANTestBase.class, "createCache", new Object[]{lnPort});
        vm6.invoke(WANTestBase.class, "createCache", new Object[]{lnPort});
        vm7.invoke(WANTestBase.class, "createCache", new Object[]{lnPort});
        ParallelWANPersistenceEnabledGatewaySenderDUnitTest.getLogWriter().info("Created back the cache");
        vm4.invoke(WANTestBase.class, "createSenderWithDiskStore", new Object[]{"ln", 2, true, 100, 10, false, true, null, diskStore1, true});
        vm5.invoke(WANTestBase.class, "createSenderWithDiskStore", new Object[]{"ln", 2, true, 100, 10, false, true, null, diskStore2, true});
        vm6.invoke(WANTestBase.class, "createSenderWithDiskStore", new Object[]{"ln", 2, true, 100, 10, false, true, null, diskStore3, true});
        vm7.invoke(WANTestBase.class, "createSenderWithDiskStore", new Object[]{"ln", 2, true, 100, 10, false, true, null, diskStore4, true});
        ParallelWANPersistenceEnabledGatewaySenderDUnitTest.getLogWriter().info("Created the senders back from the disk store.");
        AsyncInvocation inv1 = vm4.invokeAsync(WANTestBase.class, "createPersistentPartitionedRegion", new Object[]{testName, "ln", 1, 100, this.isOffHeap()});
        AsyncInvocation inv2 = vm5.invokeAsync(WANTestBase.class, "createPersistentPartitionedRegion", new Object[]{testName, "ln", 1, 100, this.isOffHeap()});
        AsyncInvocation inv3 = vm6.invokeAsync(WANTestBase.class, "createPersistentPartitionedRegion", new Object[]{testName, "ln", 1, 100, this.isOffHeap()});
        AsyncInvocation inv4 = vm7.invokeAsync(WANTestBase.class, "createPersistentPartitionedRegion", new Object[]{testName, "ln", 1, 100, this.isOffHeap()});
        try {
            inv1.join();
            inv2.join();
            inv3.join();
            inv4.join();
        }
        catch (InterruptedException e) {
            e.printStackTrace();
            ParallelWANPersistenceEnabledGatewaySenderDUnitTest.fail();
        }
        ParallelWANPersistenceEnabledGatewaySenderDUnitTest.getLogWriter().info("Created back the partitioned regions");
        vm4.invoke(WANTestBase.class, "unsetRemoveFromQueueOnException", new Object[]{"ln"});
        vm5.invoke(WANTestBase.class, "unsetRemoveFromQueueOnException", new Object[]{"ln"});
        vm6.invoke(WANTestBase.class, "unsetRemoveFromQueueOnException", new Object[]{"ln"});
        vm7.invoke(WANTestBase.class, "unsetRemoveFromQueueOnException", new Object[]{"ln"});
        vm4.invokeAsync(WANTestBase.class, "startSender", new Object[]{"ln"});
        vm5.invokeAsync(WANTestBase.class, "startSender", new Object[]{"ln"});
        vm6.invokeAsync(WANTestBase.class, "startSender", new Object[]{"ln"});
        vm7.invokeAsync(WANTestBase.class, "startSender", new Object[]{"ln"});
        ParallelWANPersistenceEnabledGatewaySenderDUnitTest.getLogWriter().info("Waiting for senders running.");
        vm4.invoke(WANTestBase.class, "waitForSenderRunningState", new Object[]{"ln"});
        vm5.invoke(WANTestBase.class, "waitForSenderRunningState", new Object[]{"ln"});
        vm6.invoke(WANTestBase.class, "waitForSenderRunningState", new Object[]{"ln"});
        vm7.invoke(WANTestBase.class, "waitForSenderRunningState", new Object[]{"ln"});
        ParallelWANPersistenceEnabledGatewaySenderDUnitTest.getLogWriter().info("Creating the receiver.");
        vm2.invoke(WANTestBase.class, "createReceiver", new Object[]{nyPort});
        vm3.invoke(WANTestBase.class, "createReceiver", new Object[]{nyPort});
        ParallelWANPersistenceEnabledGatewaySenderDUnitTest.getLogWriter().info("Creating the partitioned region at receiver. ");
        vm2.invoke(WANTestBase.class, "createPersistentPartitionedRegion", new Object[]{testName, null, 1, 100, this.isOffHeap()});
        vm3.invoke(WANTestBase.class, "createPersistentPartitionedRegion", new Object[]{testName, null, 1, 100, this.isOffHeap()});
        vm4.invoke(WANTestBase.class, "pauseSender", new Object[]{"ln"});
        vm5.invoke(WANTestBase.class, "pauseSender", new Object[]{"ln"});
        vm6.invoke(WANTestBase.class, "pauseSender", new Object[]{"ln"});
        vm7.invoke(WANTestBase.class, "pauseSender", new Object[]{"ln"});
        ParallelWANPersistenceEnabledGatewaySenderDUnitTest.getLogWriter().info("Doing some extra puts. ");
        vm4.invoke(WANTestBase.class, "doPutsAfter300", new Object[]{testName, 1000});
        vm4.invoke(WANTestBase.class, "resumeSender", new Object[]{"ln"});
        vm5.invoke(WANTestBase.class, "resumeSender", new Object[]{"ln"});
        vm6.invoke(WANTestBase.class, "resumeSender", new Object[]{"ln"});
        vm7.invoke(WANTestBase.class, "resumeSender", new Object[]{"ln"});
        ParallelWANPersistenceEnabledGatewaySenderDUnitTest.getLogWriter().info("Validating the region size at the receiver end. ");
        vm2.invoke(WANTestBase.class, "validateRegionSize", new Object[]{testName, 1000});
        vm3.invoke(WANTestBase.class, "validateRegionSize", new Object[]{testName, 1000});
    }

    public void testPersistentPRWithGatewaySenderPersistenceEnabled_Restart_Scenario2() {
        Integer lnPort = (Integer)vm0.invoke(WANTestBase.class, "createFirstLocatorWithDSId", new Object[]{1});
        Integer nyPort = (Integer)vm1.invoke(WANTestBase.class, "createFirstRemoteLocator", new Object[]{2, lnPort});
        vm2.invoke(WANTestBase.class, "createReceiver", new Object[]{nyPort});
        vm3.invoke(WANTestBase.class, "createReceiver", new Object[]{nyPort});
        vm4.invoke(WANTestBase.class, "createCache", new Object[]{lnPort});
        vm5.invoke(WANTestBase.class, "createCache", new Object[]{lnPort});
        vm6.invoke(WANTestBase.class, "createCache", new Object[]{lnPort});
        vm7.invoke(WANTestBase.class, "createCache", new Object[]{lnPort});
        String diskStore1 = (String)vm4.invoke(WANTestBase.class, "createSenderWithDiskStore", new Object[]{"ln", 2, true, 100, 10, false, true, null, null, true});
        String diskStore2 = (String)vm5.invoke(WANTestBase.class, "createSenderWithDiskStore", new Object[]{"ln", 2, true, 100, 10, false, true, null, null, true});
        String diskStore3 = (String)vm6.invoke(WANTestBase.class, "createSenderWithDiskStore", new Object[]{"ln", 2, true, 100, 10, false, true, null, null, true});
        String diskStore4 = (String)vm7.invoke(WANTestBase.class, "createSenderWithDiskStore", new Object[]{"ln", 2, true, 100, 10, false, true, null, null, true});
        ParallelWANPersistenceEnabledGatewaySenderDUnitTest.getLogWriter().info("The DS are: " + diskStore1 + "," + diskStore2 + "," + diskStore3 + "," + diskStore4);
        vm2.invoke(WANTestBase.class, "createPersistentPartitionedRegion", new Object[]{testName, null, 1, 100, this.isOffHeap()});
        vm3.invoke(WANTestBase.class, "createPersistentPartitionedRegion", new Object[]{testName, null, 1, 100, this.isOffHeap()});
        vm4.invoke(WANTestBase.class, "createPersistentPartitionedRegion", new Object[]{testName, "ln", 1, 100, this.isOffHeap()});
        vm5.invoke(WANTestBase.class, "createPersistentPartitionedRegion", new Object[]{testName, "ln", 1, 100, this.isOffHeap()});
        vm6.invoke(WANTestBase.class, "createPersistentPartitionedRegion", new Object[]{testName, "ln", 1, 100, this.isOffHeap()});
        vm7.invoke(WANTestBase.class, "createPersistentPartitionedRegion", new Object[]{testName, "ln", 1, 100, this.isOffHeap()});
        vm4.invoke(WANTestBase.class, "startSender", new Object[]{"ln"});
        vm5.invoke(WANTestBase.class, "startSender", new Object[]{"ln"});
        vm6.invoke(WANTestBase.class, "startSender", new Object[]{"ln"});
        vm7.invoke(WANTestBase.class, "startSender", new Object[]{"ln"});
        vm4.invoke(WANTestBase.class, "waitForSenderRunningState", new Object[]{"ln"});
        vm5.invoke(WANTestBase.class, "waitForSenderRunningState", new Object[]{"ln"});
        vm6.invoke(WANTestBase.class, "waitForSenderRunningState", new Object[]{"ln"});
        vm7.invoke(WANTestBase.class, "waitForSenderRunningState", new Object[]{"ln"});
        vm4.invoke(WANTestBase.class, "pauseSender", new Object[]{"ln"});
        vm5.invoke(WANTestBase.class, "pauseSender", new Object[]{"ln"});
        vm6.invoke(WANTestBase.class, "pauseSender", new Object[]{"ln"});
        vm7.invoke(WANTestBase.class, "pauseSender", new Object[]{"ln"});
        vm4.invoke(WANTestBase.class, "doPuts", new Object[]{testName, 3000});
        ParallelWANPersistenceEnabledGatewaySenderDUnitTest.getLogWriter().info("Completed puts in the region");
        vm4.invoke(WANTestBase.class, "killSender", new Object[0]);
        vm5.invoke(WANTestBase.class, "killSender", new Object[0]);
        vm6.invoke(WANTestBase.class, "killSender", new Object[0]);
        vm7.invoke(WANTestBase.class, "killSender", new Object[0]);
        ParallelWANPersistenceEnabledGatewaySenderDUnitTest.getLogWriter().info("Killed all the senders.");
        vm4.invoke(WANTestBase.class, "createCache", new Object[]{lnPort});
        vm5.invoke(WANTestBase.class, "createCache", new Object[]{lnPort});
        vm6.invoke(WANTestBase.class, "createCache", new Object[]{lnPort});
        vm7.invoke(WANTestBase.class, "createCache", new Object[]{lnPort});
        ParallelWANPersistenceEnabledGatewaySenderDUnitTest.getLogWriter().info("Created back the cache");
        vm4.invoke(WANTestBase.class, "createSenderWithDiskStore", new Object[]{"ln", 2, true, 100, 10, false, true, null, diskStore1, true});
        vm5.invoke(WANTestBase.class, "createSenderWithDiskStore", new Object[]{"ln", 2, true, 100, 10, false, true, null, diskStore2, true});
        vm6.invoke(WANTestBase.class, "createSenderWithDiskStore", new Object[]{"ln", 2, true, 100, 10, false, true, null, diskStore3, true});
        vm7.invoke(WANTestBase.class, "createSenderWithDiskStore", new Object[]{"ln", 2, true, 100, 10, false, true, null, diskStore4, true});
        ParallelWANPersistenceEnabledGatewaySenderDUnitTest.getLogWriter().info("Created the senders back from the disk store.");
        AsyncInvocation inv1 = vm4.invokeAsync(WANTestBase.class, "createPersistentPartitionedRegion", new Object[]{testName, "ln", 1, 100, this.isOffHeap()});
        AsyncInvocation inv2 = vm5.invokeAsync(WANTestBase.class, "createPersistentPartitionedRegion", new Object[]{testName, "ln", 1, 100, this.isOffHeap()});
        AsyncInvocation inv3 = vm6.invokeAsync(WANTestBase.class, "createPersistentPartitionedRegion", new Object[]{testName, "ln", 1, 100, this.isOffHeap()});
        AsyncInvocation inv4 = vm7.invokeAsync(WANTestBase.class, "createPersistentPartitionedRegion", new Object[]{testName, "ln", 1, 100, this.isOffHeap()});
        try {
            inv1.join();
            inv2.join();
            inv3.join();
            inv4.join();
        }
        catch (InterruptedException e) {
            e.printStackTrace();
            ParallelWANPersistenceEnabledGatewaySenderDUnitTest.fail();
        }
        ParallelWANPersistenceEnabledGatewaySenderDUnitTest.getLogWriter().info("Created back the partitioned regions");
        vm4.invokeAsync(WANTestBase.class, "startSender", new Object[]{"ln"});
        vm5.invokeAsync(WANTestBase.class, "startSender", new Object[]{"ln"});
        vm6.invokeAsync(WANTestBase.class, "startSender", new Object[]{"ln"});
        vm7.invokeAsync(WANTestBase.class, "startSender", new Object[]{"ln"});
        ParallelWANPersistenceEnabledGatewaySenderDUnitTest.getLogWriter().info("Waiting for senders running.");
        vm4.invoke(WANTestBase.class, "waitForSenderRunningState", new Object[]{"ln"});
        vm5.invoke(WANTestBase.class, "waitForSenderRunningState", new Object[]{"ln"});
        vm6.invoke(WANTestBase.class, "waitForSenderRunningState", new Object[]{"ln"});
        vm7.invoke(WANTestBase.class, "waitForSenderRunningState", new Object[]{"ln"});
        ParallelWANPersistenceEnabledGatewaySenderDUnitTest.getLogWriter().info("All the senders are now running...");
        AsyncInvocation async1 = vm4.invokeAsync(WANTestBase.class, "doPuts", new Object[]{testName, 1000});
        try {
            async1.join();
        }
        catch (InterruptedException e) {
            e.printStackTrace();
        }
        vm2.invoke(WANTestBase.class, "validateRegionSize", new Object[]{testName, 3000});
        vm3.invoke(WANTestBase.class, "validateRegionSize", new Object[]{testName, 3000});
    }

    public void testPersistentPRWithPersistentGatewaySender_Restart_Bug44275() {
        Integer lnPort = (Integer)vm0.invoke(WANTestBase.class, "createFirstLocatorWithDSId", new Object[]{1});
        Integer nyPort = (Integer)vm1.invoke(WANTestBase.class, "createFirstRemoteLocator", new Object[]{2, lnPort});
        vm2.invoke(WANTestBase.class, "createReceiver", new Object[]{nyPort});
        vm3.invoke(WANTestBase.class, "createReceiver", new Object[]{nyPort});
        vm4.invoke(WANTestBase.class, "createCache", new Object[]{lnPort});
        vm5.invoke(WANTestBase.class, "createCache", new Object[]{lnPort});
        vm6.invoke(WANTestBase.class, "createCache", new Object[]{lnPort});
        vm7.invoke(WANTestBase.class, "createCache", new Object[]{lnPort});
        String diskStore1 = (String)vm4.invoke(WANTestBase.class, "createSenderWithDiskStore", new Object[]{"ln", 2, true, 100, 10, false, true, null, null, true});
        String diskStore2 = (String)vm5.invoke(WANTestBase.class, "createSenderWithDiskStore", new Object[]{"ln", 2, true, 100, 10, false, true, null, null, true});
        String diskStore3 = (String)vm6.invoke(WANTestBase.class, "createSenderWithDiskStore", new Object[]{"ln", 2, true, 100, 10, false, true, null, null, true});
        String diskStore4 = (String)vm7.invoke(WANTestBase.class, "createSenderWithDiskStore", new Object[]{"ln", 2, true, 100, 10, false, true, null, null, true});
        ParallelWANPersistenceEnabledGatewaySenderDUnitTest.getLogWriter().info("The DS are: " + diskStore1 + "," + diskStore2 + "," + diskStore3 + "," + diskStore4);
        vm2.invoke(WANTestBase.class, "createPersistentPartitionedRegion", new Object[]{testName, null, 1, 100, this.isOffHeap()});
        vm3.invoke(WANTestBase.class, "createPersistentPartitionedRegion", new Object[]{testName, null, 1, 100, this.isOffHeap()});
        vm4.invoke(WANTestBase.class, "createPersistentPartitionedRegion", new Object[]{testName, "ln", 1, 100, this.isOffHeap()});
        vm5.invoke(WANTestBase.class, "createPersistentPartitionedRegion", new Object[]{testName, "ln", 1, 100, this.isOffHeap()});
        vm6.invoke(WANTestBase.class, "createPersistentPartitionedRegion", new Object[]{testName, "ln", 1, 100, this.isOffHeap()});
        vm7.invoke(WANTestBase.class, "createPersistentPartitionedRegion", new Object[]{testName, "ln", 1, 100, this.isOffHeap()});
        vm4.invoke(WANTestBase.class, "startSender", new Object[]{"ln"});
        vm5.invoke(WANTestBase.class, "startSender", new Object[]{"ln"});
        vm6.invoke(WANTestBase.class, "startSender", new Object[]{"ln"});
        vm7.invoke(WANTestBase.class, "startSender", new Object[]{"ln"});
        vm4.invoke(WANTestBase.class, "waitForSenderRunningState", new Object[]{"ln"});
        vm5.invoke(WANTestBase.class, "waitForSenderRunningState", new Object[]{"ln"});
        vm6.invoke(WANTestBase.class, "waitForSenderRunningState", new Object[]{"ln"});
        vm7.invoke(WANTestBase.class, "waitForSenderRunningState", new Object[]{"ln"});
        vm4.invoke(WANTestBase.class, "pauseSender", new Object[]{"ln"});
        vm5.invoke(WANTestBase.class, "pauseSender", new Object[]{"ln"});
        vm6.invoke(WANTestBase.class, "pauseSender", new Object[]{"ln"});
        vm7.invoke(WANTestBase.class, "pauseSender", new Object[]{"ln"});
        vm4.invoke(WANTestBase.class, "doPutsWithKeyAsString", new Object[]{testName, 1000});
        ParallelWANPersistenceEnabledGatewaySenderDUnitTest.getLogWriter().info("Completed puts in the region");
        vm4.invoke(WANTestBase.class, "killSender", new Object[0]);
        vm5.invoke(WANTestBase.class, "killSender", new Object[0]);
        vm6.invoke(WANTestBase.class, "killSender", new Object[0]);
        vm7.invoke(WANTestBase.class, "killSender", new Object[0]);
        ParallelWANPersistenceEnabledGatewaySenderDUnitTest.getLogWriter().info("Killed all the senders.");
        vm4.invoke(WANTestBase.class, "createCache", new Object[]{lnPort});
        vm5.invoke(WANTestBase.class, "createCache", new Object[]{lnPort});
        vm6.invoke(WANTestBase.class, "createCache", new Object[]{lnPort});
        vm7.invoke(WANTestBase.class, "createCache", new Object[]{lnPort});
        ParallelWANPersistenceEnabledGatewaySenderDUnitTest.getLogWriter().info("Created back the cache");
        vm4.invoke(WANTestBase.class, "createSenderWithDiskStore", new Object[]{"ln", 2, true, 100, 10, false, true, null, diskStore1, true});
        vm5.invoke(WANTestBase.class, "createSenderWithDiskStore", new Object[]{"ln", 2, true, 100, 10, false, true, null, diskStore2, true});
        vm6.invoke(WANTestBase.class, "createSenderWithDiskStore", new Object[]{"ln", 2, true, 100, 10, false, true, null, diskStore3, true});
        vm7.invoke(WANTestBase.class, "createSenderWithDiskStore", new Object[]{"ln", 2, true, 100, 10, false, true, null, diskStore4, true});
        ParallelWANPersistenceEnabledGatewaySenderDUnitTest.getLogWriter().info("Created the senders back from the disk store.");
        AsyncInvocation inv1 = vm4.invokeAsync(WANTestBase.class, "createPersistentPartitionedRegion", new Object[]{testName, "ln", 1, 100, this.isOffHeap()});
        AsyncInvocation inv2 = vm5.invokeAsync(WANTestBase.class, "createPersistentPartitionedRegion", new Object[]{testName, "ln", 1, 100, this.isOffHeap()});
        AsyncInvocation inv3 = vm6.invokeAsync(WANTestBase.class, "createPersistentPartitionedRegion", new Object[]{testName, "ln", 1, 100, this.isOffHeap()});
        AsyncInvocation inv4 = vm7.invokeAsync(WANTestBase.class, "createPersistentPartitionedRegion", new Object[]{testName, "ln", 1, 100, this.isOffHeap()});
        try {
            inv1.join();
            inv2.join();
            inv3.join();
            inv4.join();
        }
        catch (InterruptedException e) {
            e.printStackTrace();
            ParallelWANPersistenceEnabledGatewaySenderDUnitTest.fail();
        }
        ParallelWANPersistenceEnabledGatewaySenderDUnitTest.getLogWriter().info("Created back the partitioned regions");
        vm4.invokeAsync(WANTestBase.class, "startSender", new Object[]{"ln"});
        vm5.invokeAsync(WANTestBase.class, "startSender", new Object[]{"ln"});
        vm6.invokeAsync(WANTestBase.class, "startSender", new Object[]{"ln"});
        vm7.invokeAsync(WANTestBase.class, "startSender", new Object[]{"ln"});
        ParallelWANPersistenceEnabledGatewaySenderDUnitTest.getLogWriter().info("Waiting for senders running.");
        vm4.invoke(WANTestBase.class, "waitForSenderRunningState", new Object[]{"ln"});
        vm5.invoke(WANTestBase.class, "waitForSenderRunningState", new Object[]{"ln"});
        vm6.invoke(WANTestBase.class, "waitForSenderRunningState", new Object[]{"ln"});
        vm7.invoke(WANTestBase.class, "waitForSenderRunningState", new Object[]{"ln"});
        ParallelWANPersistenceEnabledGatewaySenderDUnitTest.getLogWriter().info("All the senders are now running...");
        vm2.invoke(WANTestBase.class, "validateRegionSize", new Object[]{testName, 1000});
        vm3.invoke(WANTestBase.class, "validateRegionSize", new Object[]{testName, 1000});
    }

    public void testPersistentPRWithPersistentGatewaySender_Restart_DoOps() {
        Integer lnPort = (Integer)vm0.invoke(WANTestBase.class, "createFirstLocatorWithDSId", new Object[]{1});
        Integer nyPort = (Integer)vm1.invoke(WANTestBase.class, "createFirstRemoteLocator", new Object[]{2, lnPort});
        vm2.invoke(WANTestBase.class, "createReceiver", new Object[]{nyPort});
        vm3.invoke(WANTestBase.class, "createReceiver", new Object[]{nyPort});
        vm4.invoke(WANTestBase.class, "createCache", new Object[]{lnPort});
        vm5.invoke(WANTestBase.class, "createCache", new Object[]{lnPort});
        vm6.invoke(WANTestBase.class, "createCache", new Object[]{lnPort});
        vm7.invoke(WANTestBase.class, "createCache", new Object[]{lnPort});
        String diskStore1 = (String)vm4.invoke(WANTestBase.class, "createSenderWithDiskStore", new Object[]{"ln", 2, true, 100, 10, false, true, null, null, true});
        String diskStore2 = (String)vm5.invoke(WANTestBase.class, "createSenderWithDiskStore", new Object[]{"ln", 2, true, 100, 10, false, true, null, null, true});
        String diskStore3 = (String)vm6.invoke(WANTestBase.class, "createSenderWithDiskStore", new Object[]{"ln", 2, true, 100, 10, false, true, null, null, true});
        String diskStore4 = (String)vm7.invoke(WANTestBase.class, "createSenderWithDiskStore", new Object[]{"ln", 2, true, 100, 10, false, true, null, null, true});
        ParallelWANPersistenceEnabledGatewaySenderDUnitTest.getLogWriter().info("The DS are: " + diskStore1 + "," + diskStore2 + "," + diskStore3 + "," + diskStore4);
        vm2.invoke(WANTestBase.class, "createPersistentPartitionedRegion", new Object[]{testName, null, 1, 100, this.isOffHeap()});
        vm3.invoke(WANTestBase.class, "createPersistentPartitionedRegion", new Object[]{testName, null, 1, 100, this.isOffHeap()});
        vm4.invoke(WANTestBase.class, "createPersistentPartitionedRegion", new Object[]{testName, "ln", 1, 100, this.isOffHeap()});
        vm5.invoke(WANTestBase.class, "createPersistentPartitionedRegion", new Object[]{testName, "ln", 1, 100, this.isOffHeap()});
        vm6.invoke(WANTestBase.class, "createPersistentPartitionedRegion", new Object[]{testName, "ln", 1, 100, this.isOffHeap()});
        vm7.invoke(WANTestBase.class, "createPersistentPartitionedRegion", new Object[]{testName, "ln", 1, 100, this.isOffHeap()});
        vm4.invoke(WANTestBase.class, "startSender", new Object[]{"ln"});
        vm5.invoke(WANTestBase.class, "startSender", new Object[]{"ln"});
        vm6.invoke(WANTestBase.class, "startSender", new Object[]{"ln"});
        vm7.invoke(WANTestBase.class, "startSender", new Object[]{"ln"});
        vm4.invoke(WANTestBase.class, "waitForSenderRunningState", new Object[]{"ln"});
        vm5.invoke(WANTestBase.class, "waitForSenderRunningState", new Object[]{"ln"});
        vm6.invoke(WANTestBase.class, "waitForSenderRunningState", new Object[]{"ln"});
        vm7.invoke(WANTestBase.class, "waitForSenderRunningState", new Object[]{"ln"});
        vm4.invoke(WANTestBase.class, "pauseSender", new Object[]{"ln"});
        vm5.invoke(WANTestBase.class, "pauseSender", new Object[]{"ln"});
        vm6.invoke(WANTestBase.class, "pauseSender", new Object[]{"ln"});
        vm7.invoke(WANTestBase.class, "pauseSender", new Object[]{"ln"});
        vm4.invoke(WANTestBase.class, "doPutsWithKeyAsString", new Object[]{testName, 1000});
        ParallelWANPersistenceEnabledGatewaySenderDUnitTest.getLogWriter().info("Completed puts in the region");
        vm4.invoke(WANTestBase.class, "killSender", new Object[0]);
        vm5.invoke(WANTestBase.class, "killSender", new Object[0]);
        vm6.invoke(WANTestBase.class, "killSender", new Object[0]);
        vm7.invoke(WANTestBase.class, "killSender", new Object[0]);
        ParallelWANPersistenceEnabledGatewaySenderDUnitTest.getLogWriter().info("Killed all the senders.");
        vm4.invoke(WANTestBase.class, "createCache", new Object[]{lnPort});
        vm5.invoke(WANTestBase.class, "createCache", new Object[]{lnPort});
        vm6.invoke(WANTestBase.class, "createCache", new Object[]{lnPort});
        vm7.invoke(WANTestBase.class, "createCache", new Object[]{lnPort});
        ParallelWANPersistenceEnabledGatewaySenderDUnitTest.getLogWriter().info("Created back the cache");
        vm4.invoke(WANTestBase.class, "createSenderWithDiskStore", new Object[]{"ln", 2, true, 100, 10, false, true, null, diskStore1, true});
        vm5.invoke(WANTestBase.class, "createSenderWithDiskStore", new Object[]{"ln", 2, true, 100, 10, false, true, null, diskStore2, true});
        vm6.invoke(WANTestBase.class, "createSenderWithDiskStore", new Object[]{"ln", 2, true, 100, 10, false, true, null, diskStore3, true});
        vm7.invoke(WANTestBase.class, "createSenderWithDiskStore", new Object[]{"ln", 2, true, 100, 10, false, true, null, diskStore4, true});
        ParallelWANPersistenceEnabledGatewaySenderDUnitTest.getLogWriter().info("Created the senders back from the disk store.");
        vm4.invoke(WANTestBase.class, "createPersistentPartitionedRegion", new Object[]{testName, "ln", 1, 100, this.isOffHeap()});
        vm5.invoke(WANTestBase.class, "createPersistentPartitionedRegion", new Object[]{testName, "ln", 1, 100, this.isOffHeap()});
        vm6.invoke(WANTestBase.class, "createPersistentPartitionedRegion", new Object[]{testName, "ln", 1, 100, this.isOffHeap()});
        vm7.invoke(WANTestBase.class, "createPersistentPartitionedRegion", new Object[]{testName, "ln", 1, 100, this.isOffHeap()});
        ParallelWANPersistenceEnabledGatewaySenderDUnitTest.getLogWriter().info("Created back the partitioned regions");
        vm4.invokeAsync(WANTestBase.class, "startSender", new Object[]{"ln"});
        vm5.invokeAsync(WANTestBase.class, "startSender", new Object[]{"ln"});
        vm6.invokeAsync(WANTestBase.class, "startSender", new Object[]{"ln"});
        vm7.invokeAsync(WANTestBase.class, "startSender", new Object[]{"ln"});
        ParallelWANPersistenceEnabledGatewaySenderDUnitTest.getLogWriter().info("Waiting for senders running.");
        vm4.invoke(WANTestBase.class, "waitForSenderRunningState", new Object[]{"ln"});
        vm5.invoke(WANTestBase.class, "waitForSenderRunningState", new Object[]{"ln"});
        vm6.invoke(WANTestBase.class, "waitForSenderRunningState", new Object[]{"ln"});
        vm7.invoke(WANTestBase.class, "waitForSenderRunningState", new Object[]{"ln"});
        ParallelWANPersistenceEnabledGatewaySenderDUnitTest.getLogWriter().info("All the senders are now running...");
        vm2.invoke(WANTestBase.class, "validateRegionSize", new Object[]{testName, 1000});
        vm3.invoke(WANTestBase.class, "validateRegionSize", new Object[]{testName, 1000});
        vm4.invoke(WANTestBase.class, "validateRegionSize", new Object[]{testName, 1000});
        vm5.invoke(WANTestBase.class, "validateRegionSize", new Object[]{testName, 1000});
        vm6.invoke(WANTestBase.class, "validateRegionSize", new Object[]{testName, 1000});
        vm7.invoke(WANTestBase.class, "validateRegionSize", new Object[]{testName, 1000});
        vm4.invoke(WANTestBase.class, "doPutsWithKeyAsString", new Object[]{testName, 10000});
        ParallelWANPersistenceEnabledGatewaySenderDUnitTest.getLogWriter().info("Completed puts in the region");
        vm2.invoke(WANTestBase.class, "validateRegionSize", new Object[]{testName, 10000});
        vm3.invoke(WANTestBase.class, "validateRegionSize", new Object[]{testName, 10000});
    }

    public void testPersistentPR_Restart() {
        Integer lnPort = (Integer)vm0.invoke(WANTestBase.class, "createFirstLocatorWithDSId", new Object[]{1});
        vm4.invoke(WANTestBase.class, "createCache", new Object[]{lnPort});
        vm5.invoke(WANTestBase.class, "createCache", new Object[]{lnPort});
        vm6.invoke(WANTestBase.class, "createCache", new Object[]{lnPort});
        vm7.invoke(WANTestBase.class, "createCache", new Object[]{lnPort});
        vm4.invoke(WANTestBase.class, "createPersistentPartitionedRegion", new Object[]{testName, "ln", 1, 100, this.isOffHeap()});
        vm5.invoke(WANTestBase.class, "createPersistentPartitionedRegion", new Object[]{testName, "ln", 1, 100, this.isOffHeap()});
        vm6.invoke(WANTestBase.class, "createPersistentPartitionedRegion", new Object[]{testName, "ln", 1, 100, this.isOffHeap()});
        vm7.invoke(WANTestBase.class, "createPersistentPartitionedRegion", new Object[]{testName, "ln", 1, 100, this.isOffHeap()});
        vm4.invoke(WANTestBase.class, "doPutsWithKeyAsString", new Object[]{testName, 1000});
        ParallelWANPersistenceEnabledGatewaySenderDUnitTest.getLogWriter().info("Completed puts in the region");
        vm4.invoke(WANTestBase.class, "killSender", new Object[0]);
        vm5.invoke(WANTestBase.class, "killSender", new Object[0]);
        vm6.invoke(WANTestBase.class, "killSender", new Object[0]);
        vm7.invoke(WANTestBase.class, "killSender", new Object[0]);
        ParallelWANPersistenceEnabledGatewaySenderDUnitTest.getLogWriter().info("Killed all the senders.");
        vm4.invoke(WANTestBase.class, "createCache", new Object[]{lnPort});
        vm5.invoke(WANTestBase.class, "createCache", new Object[]{lnPort});
        vm6.invoke(WANTestBase.class, "createCache", new Object[]{lnPort});
        vm7.invoke(WANTestBase.class, "createCache", new Object[]{lnPort});
        ParallelWANPersistenceEnabledGatewaySenderDUnitTest.getLogWriter().info("Created back the cache");
        AsyncInvocation inv1 = vm4.invokeAsync(WANTestBase.class, "createPersistentPartitionedRegion", new Object[]{testName, "ln", 1, 100, this.isOffHeap()});
        AsyncInvocation inv2 = vm5.invokeAsync(WANTestBase.class, "createPersistentPartitionedRegion", new Object[]{testName, "ln", 1, 100, this.isOffHeap()});
        AsyncInvocation inv3 = vm6.invokeAsync(WANTestBase.class, "createPersistentPartitionedRegion", new Object[]{testName, "ln", 1, 100, this.isOffHeap()});
        AsyncInvocation inv4 = vm7.invokeAsync(WANTestBase.class, "createPersistentPartitionedRegion", new Object[]{testName, "ln", 1, 100, this.isOffHeap()});
        try {
            inv1.join();
            inv2.join();
            inv3.join();
            inv4.join();
        }
        catch (InterruptedException e) {
            e.printStackTrace();
            ParallelWANPersistenceEnabledGatewaySenderDUnitTest.fail();
        }
        ParallelWANPersistenceEnabledGatewaySenderDUnitTest.getLogWriter().info("Created back the partitioned regions");
        vm4.invoke(WANTestBase.class, "validateRegionSize", new Object[]{testName, 1000});
        vm5.invoke(WANTestBase.class, "validateRegionSize", new Object[]{testName, 1000});
        vm6.invoke(WANTestBase.class, "validateRegionSize", new Object[]{testName, 1000});
        vm7.invoke(WANTestBase.class, "validateRegionSize", new Object[]{testName, 1000});
    }

    public void NotSupported_testPersistentPartitionedRegionWithGatewaySenderPersistenceEnabled_Restart2() {
        Integer lnPort = (Integer)vm0.invoke(WANTestBase.class, "createFirstLocatorWithDSId", new Object[]{1});
        Integer nyPort = (Integer)vm1.invoke(WANTestBase.class, "createFirstRemoteLocator", new Object[]{2, lnPort});
        vm2.invoke(WANTestBase.class, "createReceiver", new Object[]{nyPort});
        vm3.invoke(WANTestBase.class, "createReceiver", new Object[]{nyPort});
        vm4.invoke(WANTestBase.class, "createCache", new Object[]{lnPort});
        vm5.invoke(WANTestBase.class, "createCache", new Object[]{lnPort});
        vm6.invoke(WANTestBase.class, "createCache", new Object[]{lnPort});
        vm7.invoke(WANTestBase.class, "createCache", new Object[]{lnPort});
        String diskStore1 = (String)vm4.invoke(WANTestBase.class, "createSenderWithDiskStore", new Object[]{"ln", 2, true, 100, 10, false, true, null, null, true});
        String diskStore2 = (String)vm5.invoke(WANTestBase.class, "createSenderWithDiskStore", new Object[]{"ln", 2, true, 100, 10, false, true, null, null, true});
        String diskStore3 = (String)vm6.invoke(WANTestBase.class, "createSenderWithDiskStore", new Object[]{"ln", 2, true, 100, 10, false, true, null, null, true});
        String diskStore4 = (String)vm7.invoke(WANTestBase.class, "createSenderWithDiskStore", new Object[]{"ln", 2, true, 100, 10, false, true, null, null, true});
        ParallelWANPersistenceEnabledGatewaySenderDUnitTest.getLogWriter().info("The DS are: " + diskStore1 + "," + diskStore2 + "," + diskStore3 + "," + diskStore4);
        vm2.invoke(WANTestBase.class, "createPersistentPartitionedRegion", new Object[]{testName, null, 1, 100, this.isOffHeap()});
        vm3.invoke(WANTestBase.class, "createPersistentPartitionedRegion", new Object[]{testName, null, 1, 100, this.isOffHeap()});
        vm4.invoke(WANTestBase.class, "createPersistentPartitionedRegion", new Object[]{testName, "ln", 1, 100, this.isOffHeap()});
        vm5.invoke(WANTestBase.class, "createPersistentPartitionedRegion", new Object[]{testName, "ln", 1, 100, this.isOffHeap()});
        vm6.invoke(WANTestBase.class, "createPersistentPartitionedRegion", new Object[]{testName, "ln", 1, 100, this.isOffHeap()});
        vm7.invoke(WANTestBase.class, "createPersistentPartitionedRegion", new Object[]{testName, "ln", 1, 100, this.isOffHeap()});
        vm4.invoke(WANTestBase.class, "startSender", new Object[]{"ln"});
        vm5.invoke(WANTestBase.class, "startSender", new Object[]{"ln"});
        vm6.invoke(WANTestBase.class, "startSender", new Object[]{"ln"});
        vm7.invoke(WANTestBase.class, "startSender", new Object[]{"ln"});
        vm4.invoke(WANTestBase.class, "waitForSenderRunningState", new Object[]{"ln"});
        vm5.invoke(WANTestBase.class, "waitForSenderRunningState", new Object[]{"ln"});
        vm6.invoke(WANTestBase.class, "waitForSenderRunningState", new Object[]{"ln"});
        vm7.invoke(WANTestBase.class, "waitForSenderRunningState", new Object[]{"ln"});
        vm4.invoke(WANTestBase.class, "pauseSender", new Object[]{"ln"});
        vm5.invoke(WANTestBase.class, "pauseSender", new Object[]{"ln"});
        vm6.invoke(WANTestBase.class, "pauseSender", new Object[]{"ln"});
        vm7.invoke(WANTestBase.class, "pauseSender", new Object[]{"ln"});
        vm4.invoke(WANTestBase.class, "doPuts", new Object[]{testName, 1000});
        ParallelWANPersistenceEnabledGatewaySenderDUnitTest.getLogWriter().info("Completed puts in the region");
        vm4.invoke(WANTestBase.class, "killSender", new Object[0]);
        vm5.invoke(WANTestBase.class, "killSender", new Object[0]);
        vm6.invoke(WANTestBase.class, "killSender", new Object[0]);
        vm7.invoke(WANTestBase.class, "killSender", new Object[0]);
        ParallelWANPersistenceEnabledGatewaySenderDUnitTest.getLogWriter().info("Killed all the senders.");
        vm4.invoke(WANTestBase.class, "createCache", new Object[]{lnPort});
        vm5.invoke(WANTestBase.class, "createCache", new Object[]{lnPort});
        vm6.invoke(WANTestBase.class, "createCache", new Object[]{lnPort});
        vm7.invoke(WANTestBase.class, "createCache", new Object[]{lnPort});
        ParallelWANPersistenceEnabledGatewaySenderDUnitTest.getLogWriter().info("Created back the cache");
        vm4.invoke(WANTestBase.class, "createSenderWithDiskStore", new Object[]{"ln", 2, true, 100, 10, false, true, null, diskStore1, true});
        vm5.invoke(WANTestBase.class, "createSenderWithDiskStore", new Object[]{"ln", 2, true, 100, 10, false, true, null, diskStore2, true});
        vm6.invoke(WANTestBase.class, "createSenderWithDiskStore", new Object[]{"ln", 2, true, 100, 10, false, true, null, diskStore3, true});
        vm7.invoke(WANTestBase.class, "createSenderWithDiskStore", new Object[]{"ln", 2, true, 100, 10, false, true, null, diskStore4, true});
        ParallelWANPersistenceEnabledGatewaySenderDUnitTest.getLogWriter().info("Created the senders back from the disk store.");
        vm4.invoke(WANTestBase.class, "startSender", new Object[]{"ln"});
        vm5.invoke(WANTestBase.class, "startSender", new Object[]{"ln"});
        vm6.invoke(WANTestBase.class, "startSender", new Object[]{"ln"});
        vm7.invoke(WANTestBase.class, "startSender", new Object[]{"ln"});
        ParallelWANPersistenceEnabledGatewaySenderDUnitTest.getLogWriter().info("Started the senders.");
        ParallelWANPersistenceEnabledGatewaySenderDUnitTest.getLogWriter().info("Waiting for senders running.");
        vm4.invoke(WANTestBase.class, "waitForSenderRunningState", new Object[]{"ln"});
        vm5.invoke(WANTestBase.class, "waitForSenderRunningState", new Object[]{"ln"});
        vm6.invoke(WANTestBase.class, "waitForSenderRunningState", new Object[]{"ln"});
        vm7.invoke(WANTestBase.class, "waitForSenderRunningState", new Object[]{"ln"});
        ParallelWANPersistenceEnabledGatewaySenderDUnitTest.getLogWriter().info("All the senders are now running...");
        vm2.invoke(WANTestBase.class, "validateRegionSize", new Object[]{testName, 1000});
        vm3.invoke(WANTestBase.class, "validateRegionSize", new Object[]{testName, 1000});
    }

    public void NotSupported_testNonPersistentPartitionedRegionWithGatewaySenderPersistenceEnabled_Restart() {
        Integer lnPort = (Integer)vm0.invoke(WANTestBase.class, "createFirstLocatorWithDSId", new Object[]{1});
        Integer nyPort = (Integer)vm1.invoke(WANTestBase.class, "createFirstRemoteLocator", new Object[]{2, lnPort});
        vm2.invoke(WANTestBase.class, "createReceiver", new Object[]{nyPort});
        vm3.invoke(WANTestBase.class, "createReceiver", new Object[]{nyPort});
        vm4.invoke(WANTestBase.class, "createCache", new Object[]{lnPort});
        vm5.invoke(WANTestBase.class, "createCache", new Object[]{lnPort});
        vm6.invoke(WANTestBase.class, "createCache", new Object[]{lnPort});
        vm7.invoke(WANTestBase.class, "createCache", new Object[]{lnPort});
        String diskStore1 = (String)vm4.invoke(WANTestBase.class, "createSenderWithDiskStore", new Object[]{"ln", 2, true, 100, 10, false, true, null, null, true});
        String diskStore2 = (String)vm5.invoke(WANTestBase.class, "createSenderWithDiskStore", new Object[]{"ln", 2, true, 100, 10, false, true, null, null, true});
        String diskStore3 = (String)vm6.invoke(WANTestBase.class, "createSenderWithDiskStore", new Object[]{"ln", 2, true, 100, 10, false, true, null, null, true});
        String diskStore4 = (String)vm7.invoke(WANTestBase.class, "createSenderWithDiskStore", new Object[]{"ln", 2, true, 100, 10, false, true, null, null, true});
        ParallelWANPersistenceEnabledGatewaySenderDUnitTest.getLogWriter().info("The DS are: " + diskStore1 + "," + diskStore2 + "," + diskStore3 + "," + diskStore4);
        vm2.invoke(WANTestBase.class, "createPartitionedRegion", new Object[]{testName, null, 1, 100, this.isOffHeap()});
        vm3.invoke(WANTestBase.class, "createPartitionedRegion", new Object[]{testName, null, 1, 100, this.isOffHeap()});
        vm4.invoke(WANTestBase.class, "createPartitionedRegion", new Object[]{testName, "ln", 1, 100, this.isOffHeap()});
        vm5.invoke(WANTestBase.class, "createPartitionedRegion", new Object[]{testName, "ln", 1, 100, this.isOffHeap()});
        vm6.invoke(WANTestBase.class, "createPartitionedRegion", new Object[]{testName, "ln", 1, 100, this.isOffHeap()});
        vm7.invoke(WANTestBase.class, "createPartitionedRegion", new Object[]{testName, "ln", 1, 100, this.isOffHeap()});
        vm4.invoke(WANTestBase.class, "startSender", new Object[]{"ln"});
        vm5.invoke(WANTestBase.class, "startSender", new Object[]{"ln"});
        vm6.invoke(WANTestBase.class, "startSender", new Object[]{"ln"});
        vm7.invoke(WANTestBase.class, "startSender", new Object[]{"ln"});
        vm4.invoke(WANTestBase.class, "waitForSenderRunningState", new Object[]{"ln"});
        vm5.invoke(WANTestBase.class, "waitForSenderRunningState", new Object[]{"ln"});
        vm6.invoke(WANTestBase.class, "waitForSenderRunningState", new Object[]{"ln"});
        vm7.invoke(WANTestBase.class, "waitForSenderRunningState", new Object[]{"ln"});
        vm4.invoke(WANTestBase.class, "pauseSender", new Object[]{"ln"});
        vm5.invoke(WANTestBase.class, "pauseSender", new Object[]{"ln"});
        vm6.invoke(WANTestBase.class, "pauseSender", new Object[]{"ln"});
        vm7.invoke(WANTestBase.class, "pauseSender", new Object[]{"ln"});
        vm4.invoke(WANTestBase.class, "doPuts", new Object[]{testName, 1000});
        ParallelWANPersistenceEnabledGatewaySenderDUnitTest.getLogWriter().info("Completed puts in the region");
        vm4.invoke(WANTestBase.class, "killSender", new Object[0]);
        vm5.invoke(WANTestBase.class, "killSender", new Object[0]);
        vm6.invoke(WANTestBase.class, "killSender", new Object[0]);
        vm7.invoke(WANTestBase.class, "killSender", new Object[0]);
        ParallelWANPersistenceEnabledGatewaySenderDUnitTest.getLogWriter().info("Killed all the senders. The local site has been brought down.");
        vm4.invoke(WANTestBase.class, "createCache", new Object[]{lnPort});
        vm5.invoke(WANTestBase.class, "createCache", new Object[]{lnPort});
        vm6.invoke(WANTestBase.class, "createCache", new Object[]{lnPort});
        vm7.invoke(WANTestBase.class, "createCache", new Object[]{lnPort});
        ParallelWANPersistenceEnabledGatewaySenderDUnitTest.getLogWriter().info("Created back the cache");
        vm4.invoke(WANTestBase.class, "createSenderWithDiskStore", new Object[]{"ln", 2, true, 100, 10, false, true, null, diskStore1, true});
        vm5.invoke(WANTestBase.class, "createSenderWithDiskStore", new Object[]{"ln", 2, true, 100, 10, false, true, null, diskStore2, true});
        vm6.invoke(WANTestBase.class, "createSenderWithDiskStore", new Object[]{"ln", 2, true, 100, 10, false, true, null, diskStore3, true});
        vm7.invoke(WANTestBase.class, "createSenderWithDiskStore", new Object[]{"ln", 2, true, 100, 10, false, true, null, diskStore4, true});
        ParallelWANPersistenceEnabledGatewaySenderDUnitTest.getLogWriter().info("Created the senders back from the disk store.");
        vm4.invoke(WANTestBase.class, "createPartitionedRegion", new Object[]{testName, "ln", 1, 100, this.isOffHeap()});
        vm5.invoke(WANTestBase.class, "createPartitionedRegion", new Object[]{testName, "ln", 1, 100, this.isOffHeap()});
        vm6.invoke(WANTestBase.class, "createPartitionedRegion", new Object[]{testName, "ln", 1, 100, this.isOffHeap()});
        vm7.invoke(WANTestBase.class, "createPartitionedRegion", new Object[]{testName, "ln", 1, 100, this.isOffHeap()});
        ParallelWANPersistenceEnabledGatewaySenderDUnitTest.getLogWriter().info("Created back the partitioned regions");
        vm4.invoke(WANTestBase.class, "startSender", new Object[]{"ln"});
        vm5.invoke(WANTestBase.class, "startSender", new Object[]{"ln"});
        vm6.invoke(WANTestBase.class, "startSender", new Object[]{"ln"});
        vm7.invoke(WANTestBase.class, "startSender", new Object[]{"ln"});
        ParallelWANPersistenceEnabledGatewaySenderDUnitTest.getLogWriter().info("Started the senders.");
        ParallelWANPersistenceEnabledGatewaySenderDUnitTest.getLogWriter().info("Waiting for senders running.");
        vm4.invoke(WANTestBase.class, "waitForSenderRunningState", new Object[]{"ln"});
        vm5.invoke(WANTestBase.class, "waitForSenderRunningState", new Object[]{"ln"});
        vm6.invoke(WANTestBase.class, "waitForSenderRunningState", new Object[]{"ln"});
        vm7.invoke(WANTestBase.class, "waitForSenderRunningState", new Object[]{"ln"});
        ParallelWANPersistenceEnabledGatewaySenderDUnitTest.getLogWriter().info("All the senders are now running...");
        vm2.invoke(WANTestBase.class, "validateRegionSize", new Object[]{testName, 1000});
        vm3.invoke(WANTestBase.class, "validateRegionSize", new Object[]{testName, 1000});
    }

    public void testPersistentPartitionedRegionWithGatewaySender_Restart() {
        Integer lnPort = (Integer)vm0.invoke(WANTestBase.class, "createFirstLocatorWithDSId", new Object[]{1});
        Integer nyPort = (Integer)vm1.invoke(WANTestBase.class, "createFirstRemoteLocator", new Object[]{2, lnPort});
        vm2.invoke(WANTestBase.class, "createReceiver", new Object[]{nyPort});
        vm3.invoke(WANTestBase.class, "createReceiver", new Object[]{nyPort});
        vm4.invoke(WANTestBase.class, "createCache", new Object[]{lnPort});
        vm5.invoke(WANTestBase.class, "createCache", new Object[]{lnPort});
        vm6.invoke(WANTestBase.class, "createCache", new Object[]{lnPort});
        vm7.invoke(WANTestBase.class, "createCache", new Object[]{lnPort});
        vm4.invoke(WANTestBase.class, "createSender", new Object[]{"ln", 2, true, 100, 10, false, false, null, true});
        vm5.invoke(WANTestBase.class, "createSender", new Object[]{"ln", 2, true, 100, 10, false, false, null, true});
        vm6.invoke(WANTestBase.class, "createSender", new Object[]{"ln", 2, true, 100, 10, false, false, null, true});
        vm7.invoke(WANTestBase.class, "createSender", new Object[]{"ln", 2, true, 100, 10, false, false, null, true});
        vm2.invoke(WANTestBase.class, "createPersistentPartitionedRegion", new Object[]{testName, null, 1, 100, this.isOffHeap()});
        vm3.invoke(WANTestBase.class, "createPersistentPartitionedRegion", new Object[]{testName, null, 1, 100, this.isOffHeap()});
        vm4.invoke(WANTestBase.class, "createPersistentPartitionedRegion", new Object[]{testName, "ln", 1, 100, this.isOffHeap()});
        vm5.invoke(WANTestBase.class, "createPersistentPartitionedRegion", new Object[]{testName, "ln", 1, 100, this.isOffHeap()});
        vm6.invoke(WANTestBase.class, "createPersistentPartitionedRegion", new Object[]{testName, "ln", 1, 100, this.isOffHeap()});
        vm7.invoke(WANTestBase.class, "createPersistentPartitionedRegion", new Object[]{testName, "ln", 1, 100, this.isOffHeap()});
        vm4.invoke(WANTestBase.class, "startSender", new Object[]{"ln"});
        vm5.invoke(WANTestBase.class, "startSender", new Object[]{"ln"});
        vm6.invoke(WANTestBase.class, "startSender", new Object[]{"ln"});
        vm7.invoke(WANTestBase.class, "startSender", new Object[]{"ln"});
        vm4.invoke(WANTestBase.class, "waitForSenderRunningState", new Object[]{"ln"});
        vm5.invoke(WANTestBase.class, "waitForSenderRunningState", new Object[]{"ln"});
        vm6.invoke(WANTestBase.class, "waitForSenderRunningState", new Object[]{"ln"});
        vm7.invoke(WANTestBase.class, "waitForSenderRunningState", new Object[]{"ln"});
        vm4.invoke(WANTestBase.class, "pauseSender", new Object[]{"ln"});
        vm5.invoke(WANTestBase.class, "pauseSender", new Object[]{"ln"});
        vm6.invoke(WANTestBase.class, "pauseSender", new Object[]{"ln"});
        vm7.invoke(WANTestBase.class, "pauseSender", new Object[]{"ln"});
        vm4.invoke(WANTestBase.class, "doPuts", new Object[]{testName, 3000});
        ParallelWANPersistenceEnabledGatewaySenderDUnitTest.getLogWriter().info("Completed puts in the region");
        vm4.invoke(WANTestBase.class, "killSender", new Object[0]);
        vm5.invoke(WANTestBase.class, "killSender", new Object[0]);
        vm6.invoke(WANTestBase.class, "killSender", new Object[0]);
        vm7.invoke(WANTestBase.class, "killSender", new Object[0]);
        ParallelWANPersistenceEnabledGatewaySenderDUnitTest.getLogWriter().info("Killed all the senders.");
        vm4.invoke(WANTestBase.class, "createCache", new Object[]{lnPort});
        vm5.invoke(WANTestBase.class, "createCache", new Object[]{lnPort});
        vm6.invoke(WANTestBase.class, "createCache", new Object[]{lnPort});
        vm7.invoke(WANTestBase.class, "createCache", new Object[]{lnPort});
        ParallelWANPersistenceEnabledGatewaySenderDUnitTest.getLogWriter().info("Created back the cache");
        vm4.invoke(WANTestBase.class, "createSender", new Object[]{"ln", 2, true, 100, 10, false, false, null, true});
        vm5.invoke(WANTestBase.class, "createSender", new Object[]{"ln", 2, true, 100, 10, false, false, null, true});
        vm6.invoke(WANTestBase.class, "createSender", new Object[]{"ln", 2, true, 100, 10, false, false, null, true});
        vm7.invoke(WANTestBase.class, "createSender", new Object[]{"ln", 2, true, 100, 10, false, false, null, true});
        ParallelWANPersistenceEnabledGatewaySenderDUnitTest.getLogWriter().info("Created the senders again");
        AsyncInvocation inv1 = vm4.invokeAsync(WANTestBase.class, "createPersistentPartitionedRegion", new Object[]{testName, "ln", 1, 100, this.isOffHeap()});
        AsyncInvocation inv2 = vm5.invokeAsync(WANTestBase.class, "createPersistentPartitionedRegion", new Object[]{testName, "ln", 1, 100, this.isOffHeap()});
        AsyncInvocation inv3 = vm6.invokeAsync(WANTestBase.class, "createPersistentPartitionedRegion", new Object[]{testName, "ln", 1, 100, this.isOffHeap()});
        AsyncInvocation inv4 = vm7.invokeAsync(WANTestBase.class, "createPersistentPartitionedRegion", new Object[]{testName, "ln", 1, 100, this.isOffHeap()});
        try {
            inv1.join();
            inv2.join();
            inv3.join();
            inv4.join();
        }
        catch (InterruptedException e) {
            e.printStackTrace();
            ParallelWANPersistenceEnabledGatewaySenderDUnitTest.fail();
        }
        ParallelWANPersistenceEnabledGatewaySenderDUnitTest.getLogWriter().info("Created back the partitioned regions");
        vm4.invoke(WANTestBase.class, "setRemoveFromQueueOnException", new Object[]{"ln", true});
        vm5.invoke(WANTestBase.class, "setRemoveFromQueueOnException", new Object[]{"ln", true});
        vm6.invoke(WANTestBase.class, "setRemoveFromQueueOnException", new Object[]{"ln", true});
        vm7.invoke(WANTestBase.class, "setRemoveFromQueueOnException", new Object[]{"ln", true});
        vm4.invokeAsync(WANTestBase.class, "startSender", new Object[]{"ln"});
        vm5.invokeAsync(WANTestBase.class, "startSender", new Object[]{"ln"});
        vm6.invokeAsync(WANTestBase.class, "startSender", new Object[]{"ln"});
        vm7.invokeAsync(WANTestBase.class, "startSender", new Object[]{"ln"});
        ParallelWANPersistenceEnabledGatewaySenderDUnitTest.getLogWriter().info("Started the senders.");
        ParallelWANPersistenceEnabledGatewaySenderDUnitTest.getLogWriter().info("Waiting for senders running.");
        vm4.invoke(WANTestBase.class, "waitForSenderRunningState", new Object[]{"ln"});
        vm5.invoke(WANTestBase.class, "waitForSenderRunningState", new Object[]{"ln"});
        vm6.invoke(WANTestBase.class, "waitForSenderRunningState", new Object[]{"ln"});
        vm7.invoke(WANTestBase.class, "waitForSenderRunningState", new Object[]{"ln"});
        ParallelWANPersistenceEnabledGatewaySenderDUnitTest.getLogWriter().info("All the senders are now running...");
        vm4.invoke(WANTestBase.class, "doPuts", new Object[]{testName, 3000});
        ParallelWANPersistenceEnabledGatewaySenderDUnitTest.getLogWriter().info("Completed puts in the region");
        vm2.invoke(WANTestBase.class, "validateRegionSize", new Object[]{testName, 3000});
        vm3.invoke(WANTestBase.class, "validateRegionSize", new Object[]{testName, 3000});
    }

    public void testParallelPropagationWithSenderPerisistenceEnabledForAccessor() {
        Integer lnPort = (Integer)vm0.invoke(WANTestBase.class, "createFirstLocatorWithDSId", new Object[]{1});
        Integer nyPort = (Integer)vm1.invoke(WANTestBase.class, "createFirstRemoteLocator", new Object[]{2, lnPort});
        vm2.invoke(WANTestBase.class, "createReceiver", new Object[]{nyPort});
        vm3.invoke(WANTestBase.class, "createReceiver", new Object[]{nyPort});
        vm4.invoke(WANTestBase.class, "createCache", new Object[]{lnPort});
        vm5.invoke(WANTestBase.class, "createCache", new Object[]{lnPort});
        vm6.invoke(WANTestBase.class, "createCache", new Object[]{lnPort});
        vm7.invoke(WANTestBase.class, "createCache", new Object[]{lnPort});
        vm4.invoke(WANTestBase.class, "createSender", new Object[]{"ln", 2, true, 100, 10, false, true, null, true});
        vm5.invoke(WANTestBase.class, "createSender", new Object[]{"ln", 2, true, 100, 10, false, true, null, true});
        vm6.invoke(WANTestBase.class, "createSender", new Object[]{"ln", 2, true, 100, 10, false, true, null, true});
        vm7.invoke(WANTestBase.class, "createSender", new Object[]{"ln", 2, true, 100, 10, false, true, null, true});
        vm4.invoke(WANTestBase.class, "createPartitionedRegion", new Object[]{testName + "_PR", "ln", 1, 100, this.isOffHeap()});
        vm5.invoke(WANTestBase.class, "createPartitionedRegion", new Object[]{testName + "_PR", "ln", 1, 100, this.isOffHeap()});
        vm6.invoke(WANTestBase.class, "createPartitionedRegionAsAccessor", new Object[]{testName + "_PR", "ln", 1, 100});
        vm7.invoke(WANTestBase.class, "createPartitionedRegionAsAccessor", new Object[]{testName + "_PR", "ln", 1, 100});
        vm2.invoke(WANTestBase.class, "createPartitionedRegion", new Object[]{testName + "_PR", null, 1, 100, this.isOffHeap()});
        vm3.invoke(WANTestBase.class, "createPartitionedRegion", new Object[]{testName + "_PR", null, 1, 100, this.isOffHeap()});
        vm4.invoke(WANTestBase.class, "startSender", new Object[]{"ln"});
        vm5.invoke(WANTestBase.class, "startSender", new Object[]{"ln"});
        vm6.invoke(WANTestBase.class, "startSender", new Object[]{"ln"});
        vm7.invoke(WANTestBase.class, "startSender", new Object[]{"ln"});
        vm4.invoke(WANTestBase.class, "doPuts", new Object[]{testName + "_PR", 1000});
        ParallelWANPersistenceEnabledGatewaySenderDUnitTest.getLogWriter().info("Completed puts in the region");
        vm2.invoke(WANTestBase.class, "validateRegionSize", new Object[]{testName + "_PR", 1000});
        vm3.invoke(WANTestBase.class, "validateRegionSize", new Object[]{testName + "_PR", 1000});
    }
}

