/*
 * Decompiled with CFR 0.152.
 */
package com.gemstone.gemfire.internal.cache.wan.parallel;

import com.gemstone.gemfire.internal.cache.wan.WANTestBase;
import dunit.AsyncInvocation;
import java.util.ArrayList;
import java.util.HashMap;

public class ParallelWANStatsDUnitTest
extends WANTestBase {
    private static final long serialVersionUID = 1L;

    public ParallelWANStatsDUnitTest(String name) {
        super(name);
    }

    @Override
    public void setUp() throws Exception {
        super.setUp();
    }

    public void testPartitionedRegionParallelPropagation_BeforeDispatch() throws Exception {
        Integer lnPort = (Integer)vm0.invoke(WANTestBase.class, "createFirstLocatorWithDSId", new Object[]{1});
        Integer nyPort = (Integer)vm1.invoke(WANTestBase.class, "createFirstRemoteLocator", new Object[]{2, lnPort});
        vm2.invoke(WANTestBase.class, "createReceiver", new Object[]{nyPort});
        vm3.invoke(WANTestBase.class, "createReceiver", new Object[]{nyPort});
        vm4.invoke(WANTestBase.class, "createCache", new Object[]{lnPort});
        vm5.invoke(WANTestBase.class, "createCache", new Object[]{lnPort});
        vm6.invoke(WANTestBase.class, "createCache", new Object[]{lnPort});
        vm7.invoke(WANTestBase.class, "createCache", new Object[]{lnPort});
        vm4.invoke(WANTestBase.class, "createSender", new Object[]{"ln", 2, true, 100, 10, true, false, null, true});
        vm5.invoke(WANTestBase.class, "createSender", new Object[]{"ln", 2, true, 100, 10, true, false, null, true});
        vm6.invoke(WANTestBase.class, "createSender", new Object[]{"ln", 2, true, 100, 10, true, false, null, true});
        vm7.invoke(WANTestBase.class, "createSender", new Object[]{"ln", 2, true, 100, 10, true, false, null, true});
        vm4.invoke(WANTestBase.class, "createPartitionedRegion", new Object[]{testName, "ln", 0, 100, this.isOffHeap()});
        vm5.invoke(WANTestBase.class, "createPartitionedRegion", new Object[]{testName, "ln", 0, 100, this.isOffHeap()});
        vm6.invoke(WANTestBase.class, "createPartitionedRegion", new Object[]{testName, "ln", 0, 100, this.isOffHeap()});
        vm7.invoke(WANTestBase.class, "createPartitionedRegion", new Object[]{testName, "ln", 0, 100, this.isOffHeap()});
        vm4.invoke(WANTestBase.class, "startSender", new Object[]{"ln"});
        vm5.invoke(WANTestBase.class, "startSender", new Object[]{"ln"});
        vm6.invoke(WANTestBase.class, "startSender", new Object[]{"ln"});
        vm7.invoke(WANTestBase.class, "startSender", new Object[]{"ln"});
        ParallelWANStatsDUnitTest.pause(3000);
        vm4.invoke(WANTestBase.class, "pauseSender", new Object[]{"ln"});
        vm5.invoke(WANTestBase.class, "pauseSender", new Object[]{"ln"});
        vm6.invoke(WANTestBase.class, "pauseSender", new Object[]{"ln"});
        vm7.invoke(WANTestBase.class, "pauseSender", new Object[]{"ln"});
        vm2.invoke(WANTestBase.class, "createPartitionedRegion", new Object[]{testName, null, 1, 100, this.isOffHeap()});
        vm3.invoke(WANTestBase.class, "createPartitionedRegion", new Object[]{testName, null, 1, 100, this.isOffHeap()});
        ParallelWANStatsDUnitTest.pause(2000);
        HashMap<Integer, Integer> keyValues = new HashMap<Integer, Integer>();
        HashMap updateKeyValues = new HashMap();
        for (int i = 0; i < 1000; ++i) {
            keyValues.put(i, i);
        }
        vm4.invoke(WANTestBase.class, "putGivenKeyValue", new Object[]{testName, keyValues});
        vm4.invoke(WANTestBase.class, "checkQueueSize", new Object[]{"ln", keyValues.size()});
        ArrayList v4List = (ArrayList)vm4.invoke(WANTestBase.class, "getSenderStats", new Object[]{"ln", 1000});
        ArrayList v5List = (ArrayList)vm5.invoke(WANTestBase.class, "getSenderStats", new Object[]{"ln", 1000});
        ArrayList v6List = (ArrayList)vm6.invoke(WANTestBase.class, "getSenderStats", new Object[]{"ln", 1000});
        ArrayList v7List = (ArrayList)vm7.invoke(WANTestBase.class, "getSenderStats", new Object[]{"ln", 1000});
        ParallelWANStatsDUnitTest.assertEquals((int)1000, (int)((Integer)v4List.get(0) + (Integer)v5List.get(0) + (Integer)v6List.get(0) + (Integer)v7List.get(0)));
        ParallelWANStatsDUnitTest.assertEquals((int)1000, (int)((Integer)v4List.get(1) + (Integer)v5List.get(1) + (Integer)v6List.get(1) + (Integer)v7List.get(1)));
        ParallelWANStatsDUnitTest.assertEquals((int)1000, (int)((Integer)v4List.get(2) + (Integer)v5List.get(2) + (Integer)v6List.get(2) + (Integer)v7List.get(2)));
        ParallelWANStatsDUnitTest.assertEquals((int)0, (int)((Integer)v4List.get(3) + (Integer)v5List.get(3) + (Integer)v6List.get(3) + (Integer)v7List.get(3)));
        ParallelWANStatsDUnitTest.assertEquals((int)0, (int)((Integer)v4List.get(4) + (Integer)v5List.get(4) + (Integer)v6List.get(4) + (Integer)v7List.get(4)));
        ParallelWANStatsDUnitTest.assertEquals((int)0, (int)((Integer)v4List.get(5) + (Integer)v5List.get(5) + (Integer)v6List.get(5) + (Integer)v7List.get(5)));
    }

    public void testPartitionedRegionParallelPropagation_AfterDispatch_NoRedundacny() throws Exception {
        Integer lnPort = (Integer)vm0.invoke(WANTestBase.class, "createFirstLocatorWithDSId", new Object[]{1});
        Integer nyPort = (Integer)vm1.invoke(WANTestBase.class, "createFirstRemoteLocator", new Object[]{2, lnPort});
        vm2.invoke(WANTestBase.class, "createReceiver", new Object[]{nyPort});
        vm4.invoke(WANTestBase.class, "createCache", new Object[]{lnPort});
        vm5.invoke(WANTestBase.class, "createCache", new Object[]{lnPort});
        vm6.invoke(WANTestBase.class, "createCache", new Object[]{lnPort});
        vm7.invoke(WANTestBase.class, "createCache", new Object[]{lnPort});
        vm4.invoke(WANTestBase.class, "createSender", new Object[]{"ln", 2, true, 100, 10, false, false, null, true});
        vm5.invoke(WANTestBase.class, "createSender", new Object[]{"ln", 2, true, 100, 10, false, false, null, true});
        vm6.invoke(WANTestBase.class, "createSender", new Object[]{"ln", 2, true, 100, 10, false, false, null, true});
        vm7.invoke(WANTestBase.class, "createSender", new Object[]{"ln", 2, true, 100, 10, false, false, null, true});
        vm2.invoke(WANTestBase.class, "createPartitionedRegion", new Object[]{testName + "_PR", null, 0, 100, this.isOffHeap()});
        vm4.invoke(WANTestBase.class, "createPartitionedRegion", new Object[]{testName + "_PR", "ln", 0, 100, this.isOffHeap()});
        vm5.invoke(WANTestBase.class, "createPartitionedRegion", new Object[]{testName + "_PR", "ln", 0, 100, this.isOffHeap()});
        vm6.invoke(WANTestBase.class, "createPartitionedRegion", new Object[]{testName + "_PR", "ln", 0, 100, this.isOffHeap()});
        vm7.invoke(WANTestBase.class, "createPartitionedRegion", new Object[]{testName + "_PR", "ln", 0, 100, this.isOffHeap()});
        vm4.invoke(WANTestBase.class, "startSender", new Object[]{"ln"});
        vm5.invoke(WANTestBase.class, "startSender", new Object[]{"ln"});
        vm6.invoke(WANTestBase.class, "startSender", new Object[]{"ln"});
        vm7.invoke(WANTestBase.class, "startSender", new Object[]{"ln"});
        vm4.invoke(WANTestBase.class, "doPuts", new Object[]{testName + "_PR", 1000});
        vm2.invoke(WANTestBase.class, "validateRegionSize", new Object[]{testName + "_PR", 1000});
        ArrayList v4List = (ArrayList)vm4.invoke(WANTestBase.class, "getSenderStats", new Object[]{"ln", 0});
        ArrayList v5List = (ArrayList)vm5.invoke(WANTestBase.class, "getSenderStats", new Object[]{"ln", 0});
        ArrayList v6List = (ArrayList)vm6.invoke(WANTestBase.class, "getSenderStats", new Object[]{"ln", 0});
        ArrayList v7List = (ArrayList)vm7.invoke(WANTestBase.class, "getSenderStats", new Object[]{"ln", 0});
        ParallelWANStatsDUnitTest.assertEquals((int)0, (int)((Integer)v4List.get(0) + (Integer)v5List.get(0) + (Integer)v6List.get(0) + (Integer)v7List.get(0)));
        ParallelWANStatsDUnitTest.assertEquals((int)1000, (int)((Integer)v4List.get(1) + (Integer)v5List.get(1) + (Integer)v6List.get(1) + (Integer)v7List.get(1)));
        ParallelWANStatsDUnitTest.assertEquals((int)1000, (int)((Integer)v4List.get(2) + (Integer)v5List.get(2) + (Integer)v6List.get(2) + (Integer)v7List.get(2)));
        ParallelWANStatsDUnitTest.assertEquals((int)1000, (int)((Integer)v4List.get(3) + (Integer)v5List.get(3) + (Integer)v6List.get(3) + (Integer)v7List.get(3)));
        ParallelWANStatsDUnitTest.assertTrue(((Integer)v4List.get(4) + (Integer)v5List.get(4) + (Integer)v6List.get(4) + (Integer)v7List.get(4) >= 100 ? 1 : 0) != 0);
        ParallelWANStatsDUnitTest.assertEquals((int)0, (int)((Integer)v4List.get(5) + (Integer)v5List.get(5) + (Integer)v6List.get(5) + (Integer)v7List.get(5)));
        vm2.invoke(WANTestBase.class, "checkGatewayReceiverStats", new Object[]{100, 1000, 1000});
    }

    public void testPartitionedRegionParallelPropagation_AfterDispatch_Redundancy_3() throws Exception {
        Integer lnPort = (Integer)vm0.invoke(WANTestBase.class, "createFirstLocatorWithDSId", new Object[]{1});
        Integer nyPort = (Integer)vm1.invoke(WANTestBase.class, "createFirstRemoteLocator", new Object[]{2, lnPort});
        vm2.invoke(WANTestBase.class, "createReceiver", new Object[]{nyPort});
        vm4.invoke(WANTestBase.class, "createCache", new Object[]{lnPort});
        vm5.invoke(WANTestBase.class, "createCache", new Object[]{lnPort});
        vm6.invoke(WANTestBase.class, "createCache", new Object[]{lnPort});
        vm7.invoke(WANTestBase.class, "createCache", new Object[]{lnPort});
        vm4.invoke(WANTestBase.class, "createSender", new Object[]{"ln", 2, true, 100, 10, false, false, null, true});
        vm5.invoke(WANTestBase.class, "createSender", new Object[]{"ln", 2, true, 100, 10, false, false, null, true});
        vm6.invoke(WANTestBase.class, "createSender", new Object[]{"ln", 2, true, 100, 10, false, false, null, true});
        vm7.invoke(WANTestBase.class, "createSender", new Object[]{"ln", 2, true, 100, 10, false, false, null, true});
        vm2.invoke(WANTestBase.class, "createPartitionedRegion", new Object[]{testName + "_PR", null, 0, 100, this.isOffHeap()});
        vm4.invoke(WANTestBase.class, "createPartitionedRegion", new Object[]{testName + "_PR", "ln", 3, 100, this.isOffHeap()});
        vm5.invoke(WANTestBase.class, "createPartitionedRegion", new Object[]{testName + "_PR", "ln", 3, 100, this.isOffHeap()});
        vm6.invoke(WANTestBase.class, "createPartitionedRegion", new Object[]{testName + "_PR", "ln", 3, 100, this.isOffHeap()});
        vm7.invoke(WANTestBase.class, "createPartitionedRegion", new Object[]{testName + "_PR", "ln", 3, 100, this.isOffHeap()});
        vm4.invoke(WANTestBase.class, "startSender", new Object[]{"ln"});
        vm5.invoke(WANTestBase.class, "startSender", new Object[]{"ln"});
        vm6.invoke(WANTestBase.class, "startSender", new Object[]{"ln"});
        vm7.invoke(WANTestBase.class, "startSender", new Object[]{"ln"});
        vm4.invoke(WANTestBase.class, "doPuts", new Object[]{testName + "_PR", 1000});
        vm2.invoke(WANTestBase.class, "validateRegionSize", new Object[]{testName + "_PR", 1000});
        ArrayList v4List = (ArrayList)vm4.invoke(WANTestBase.class, "getSenderStats", new Object[]{"ln", 0});
        ArrayList v5List = (ArrayList)vm5.invoke(WANTestBase.class, "getSenderStats", new Object[]{"ln", 0});
        ArrayList v6List = (ArrayList)vm6.invoke(WANTestBase.class, "getSenderStats", new Object[]{"ln", 0});
        ArrayList v7List = (ArrayList)vm7.invoke(WANTestBase.class, "getSenderStats", new Object[]{"ln", 0});
        ParallelWANStatsDUnitTest.assertEquals((int)0, (int)((Integer)v4List.get(0) + (Integer)v5List.get(0) + (Integer)v6List.get(0) + (Integer)v7List.get(0)));
        ParallelWANStatsDUnitTest.assertEquals((int)4000, (int)((Integer)v4List.get(1) + (Integer)v5List.get(1) + (Integer)v6List.get(1) + (Integer)v7List.get(1)));
        ParallelWANStatsDUnitTest.assertEquals((int)4000, (int)((Integer)v4List.get(2) + (Integer)v5List.get(2) + (Integer)v6List.get(2) + (Integer)v7List.get(2)));
        ParallelWANStatsDUnitTest.assertEquals((int)1000, (int)((Integer)v4List.get(3) + (Integer)v5List.get(3) + (Integer)v6List.get(3) + (Integer)v7List.get(3)));
        ParallelWANStatsDUnitTest.assertTrue(((Integer)v4List.get(4) + (Integer)v5List.get(4) + (Integer)v6List.get(4) + (Integer)v7List.get(4) >= 100 ? 1 : 0) != 0);
        ParallelWANStatsDUnitTest.assertEquals((int)0, (int)((Integer)v4List.get(5) + (Integer)v5List.get(5) + (Integer)v6List.get(5) + (Integer)v7List.get(5)));
        vm2.invoke(WANTestBase.class, "checkGatewayReceiverStats", new Object[]{100, 1000, 1000});
    }

    public void testWANStatsTwoWanSites_Bug44331() throws Exception {
        Integer lnPort = ParallelWANStatsDUnitTest.createFirstLocatorWithDSId(1);
        Integer nyPort = (Integer)vm0.invoke(WANTestBase.class, "createFirstRemoteLocator", new Object[]{2, lnPort});
        Integer tkPort = (Integer)vm1.invoke(WANTestBase.class, "createFirstRemoteLocator", new Object[]{3, lnPort});
        vm2.invoke(WANTestBase.class, "createReceiver", new Object[]{nyPort});
        vm3.invoke(WANTestBase.class, "createReceiver", new Object[]{tkPort});
        vm4.invoke(WANTestBase.class, "createCache", new Object[]{lnPort});
        vm4.invoke(WANTestBase.class, "createSender", new Object[]{"ln1", 2, true, 100, 10, false, false, null, true});
        vm4.invoke(WANTestBase.class, "createSender", new Object[]{"ln2", 3, true, 100, 10, false, false, null, true});
        vm2.invoke(WANTestBase.class, "createPartitionedRegion", new Object[]{testName + "_PR", null, 0, 100, this.isOffHeap()});
        vm3.invoke(WANTestBase.class, "createPartitionedRegion", new Object[]{testName + "_PR", null, 0, 100, this.isOffHeap()});
        vm4.invoke(WANTestBase.class, "createPartitionedRegion", new Object[]{testName + "_PR", "ln1,ln2", 0, 100, this.isOffHeap()});
        vm4.invoke(WANTestBase.class, "startSender", new Object[]{"ln1"});
        vm4.invoke(WANTestBase.class, "startSender", new Object[]{"ln2"});
        vm4.invoke(WANTestBase.class, "doPuts", new Object[]{testName + "_PR", 1000});
        ParallelWANStatsDUnitTest.pause(10000);
        vm2.invoke(WANTestBase.class, "validateRegionSize", new Object[]{testName + "_PR", 1000});
        vm3.invoke(WANTestBase.class, "validateRegionSize", new Object[]{testName + "_PR", 1000});
        ArrayList v4Sender1List = (ArrayList)vm4.invoke(WANTestBase.class, "getSenderStats", new Object[]{"ln1", 0});
        ArrayList v4Sender2List = (ArrayList)vm4.invoke(WANTestBase.class, "getSenderStats", new Object[]{"ln2", 0});
        ParallelWANStatsDUnitTest.assertEquals((int)0, (int)((Integer)v4Sender1List.get(0)));
        ParallelWANStatsDUnitTest.assertEquals((int)1000, (int)((Integer)v4Sender1List.get(1)));
        ParallelWANStatsDUnitTest.assertEquals((int)1000, (int)((Integer)v4Sender1List.get(2)));
        ParallelWANStatsDUnitTest.assertEquals((int)1000, (int)((Integer)v4Sender1List.get(3)));
        ParallelWANStatsDUnitTest.assertTrue(((Integer)v4Sender1List.get(4) >= 100 ? 1 : 0) != 0);
        ParallelWANStatsDUnitTest.assertEquals((int)0, (int)((Integer)v4Sender1List.get(5)));
        ParallelWANStatsDUnitTest.assertEquals((int)0, (int)((Integer)v4Sender2List.get(0)));
        ParallelWANStatsDUnitTest.assertEquals((int)1000, (int)((Integer)v4Sender2List.get(1)));
        ParallelWANStatsDUnitTest.assertEquals((int)1000, (int)((Integer)v4Sender2List.get(2)));
        ParallelWANStatsDUnitTest.assertEquals((int)1000, (int)((Integer)v4Sender2List.get(3)));
        ParallelWANStatsDUnitTest.assertTrue(((Integer)v4Sender2List.get(4) >= 100 ? 1 : 0) != 0);
        ParallelWANStatsDUnitTest.assertEquals((int)0, (int)((Integer)v4Sender2List.get(5)));
        vm2.invoke(WANTestBase.class, "checkGatewayReceiverStats", new Object[]{100, 1000, 1000});
        vm3.invoke(WANTestBase.class, "checkGatewayReceiverStats", new Object[]{100, 1000, 1000});
    }

    public void testParallelPropagationHA() throws Exception {
        Integer lnPort = (Integer)vm0.invoke(WANTestBase.class, "createFirstLocatorWithDSId", new Object[]{1});
        Integer nyPort = (Integer)vm1.invoke(WANTestBase.class, "createFirstRemoteLocator", new Object[]{2, lnPort});
        vm2.invoke(WANTestBase.class, "createReceiver", new Object[]{nyPort});
        vm4.invoke(WANTestBase.class, "createCache", new Object[]{lnPort});
        vm5.invoke(WANTestBase.class, "createCache", new Object[]{lnPort});
        vm6.invoke(WANTestBase.class, "createCache", new Object[]{lnPort});
        vm7.invoke(WANTestBase.class, "createCache", new Object[]{lnPort});
        vm4.invoke(WANTestBase.class, "createSender", new Object[]{"ln", 2, true, 100, 10, false, false, null, true});
        vm5.invoke(WANTestBase.class, "createSender", new Object[]{"ln", 2, true, 100, 10, false, false, null, true});
        vm6.invoke(WANTestBase.class, "createSender", new Object[]{"ln", 2, true, 100, 10, false, false, null, true});
        vm7.invoke(WANTestBase.class, "createSender", new Object[]{"ln", 2, true, 100, 10, false, false, null, true});
        vm2.invoke(WANTestBase.class, "createPartitionedRegion", new Object[]{testName + "_PR", null, 0, 100, this.isOffHeap()});
        vm4.invoke(WANTestBase.class, "createPartitionedRegion", new Object[]{testName + "_PR", "ln", 3, 100, this.isOffHeap()});
        vm5.invoke(WANTestBase.class, "createPartitionedRegion", new Object[]{testName + "_PR", "ln", 3, 100, this.isOffHeap()});
        vm6.invoke(WANTestBase.class, "createPartitionedRegion", new Object[]{testName + "_PR", "ln", 3, 100, this.isOffHeap()});
        vm7.invoke(WANTestBase.class, "createPartitionedRegion", new Object[]{testName + "_PR", "ln", 3, 100, this.isOffHeap()});
        vm4.invoke(WANTestBase.class, "startSender", new Object[]{"ln"});
        vm5.invoke(WANTestBase.class, "startSender", new Object[]{"ln"});
        vm6.invoke(WANTestBase.class, "startSender", new Object[]{"ln"});
        vm7.invoke(WANTestBase.class, "startSender", new Object[]{"ln"});
        AsyncInvocation inv1 = vm5.invokeAsync(WANTestBase.class, "doPuts", new Object[]{testName + "_PR", 10000});
        ParallelWANStatsDUnitTest.pause(2000);
        AsyncInvocation inv2 = vm4.invokeAsync(WANTestBase.class, "killSender");
        inv1.join();
        inv2.join();
        vm2.invoke(WANTestBase.class, "validateRegionSize", new Object[]{testName + "_PR", 10000});
        ArrayList v5List = (ArrayList)vm5.invoke(WANTestBase.class, "getSenderStats", new Object[]{"ln", 0});
        ArrayList v6List = (ArrayList)vm6.invoke(WANTestBase.class, "getSenderStats", new Object[]{"ln", 0});
        ArrayList v7List = (ArrayList)vm7.invoke(WANTestBase.class, "getSenderStats", new Object[]{"ln", 0});
        ParallelWANStatsDUnitTest.assertEquals((int)0, (int)((Integer)v5List.get(0) + (Integer)v6List.get(0) + (Integer)v7List.get(0)));
        ParallelWANStatsDUnitTest.assertEquals((int)30000, (int)((Integer)v5List.get(1) + (Integer)v6List.get(1) + (Integer)v7List.get(1)));
        ParallelWANStatsDUnitTest.assertEquals((int)30000, (int)((Integer)v5List.get(2) + (Integer)v6List.get(2) + (Integer)v7List.get(2)));
        ParallelWANStatsDUnitTest.assertEquals((int)0, (int)((Integer)v5List.get(5) + (Integer)v6List.get(5) + (Integer)v7List.get(5)));
        vm2.invoke(WANTestBase.class, "checkGatewayReceiverStatsHA", new Object[]{1000, 10000, 10000});
    }

    public void testParallePropagationWithRemoteRegionDestroy() throws Exception {
        Integer lnPort = (Integer)vm0.invoke(WANTestBase.class, "createFirstLocatorWithDSId", new Object[]{1});
        Integer nyPort = (Integer)vm1.invoke(WANTestBase.class, "createFirstRemoteLocator", new Object[]{2, lnPort});
        vm2.invoke(WANTestBase.class, "createReceiver", new Object[]{nyPort});
        vm4.invoke(WANTestBase.class, "createCache", new Object[]{lnPort});
        vm5.invoke(WANTestBase.class, "createCache", new Object[]{lnPort});
        vm6.invoke(WANTestBase.class, "createCache", new Object[]{lnPort});
        vm7.invoke(WANTestBase.class, "createCache", new Object[]{lnPort});
        vm4.invoke(WANTestBase.class, "createSender", new Object[]{"ln", 2, true, 100, 10, false, false, null, true});
        vm5.invoke(WANTestBase.class, "createSender", new Object[]{"ln", 2, true, 100, 10, false, false, null, true});
        vm6.invoke(WANTestBase.class, "createSender", new Object[]{"ln", 2, true, 100, 10, false, false, null, true});
        vm7.invoke(WANTestBase.class, "createSender", new Object[]{"ln", 2, true, 100, 10, false, false, null, true});
        vm2.invoke(WANTestBase.class, "createPartitionedRegion", new Object[]{testName + "_PR", null, 0, 100, this.isOffHeap()});
        vm2.invoke(WANTestBase.class, "addCacheListenerAndDestroyRegion", new Object[]{testName + "_PR"});
        vm4.invoke(WANTestBase.class, "createPartitionedRegion", new Object[]{testName + "_PR", "ln", 0, 100, this.isOffHeap()});
        vm5.invoke(WANTestBase.class, "createPartitionedRegion", new Object[]{testName + "_PR", "ln", 0, 100, this.isOffHeap()});
        vm6.invoke(WANTestBase.class, "createPartitionedRegion", new Object[]{testName + "_PR", "ln", 0, 100, this.isOffHeap()});
        vm7.invoke(WANTestBase.class, "createPartitionedRegion", new Object[]{testName + "_PR", "ln", 0, 100, this.isOffHeap()});
        vm4.invoke(WANTestBase.class, "startSender", new Object[]{"ln"});
        vm5.invoke(WANTestBase.class, "startSender", new Object[]{"ln"});
        vm6.invoke(WANTestBase.class, "startSender", new Object[]{"ln"});
        vm7.invoke(WANTestBase.class, "startSender", new Object[]{"ln"});
        vm4.invoke(WANTestBase.class, "doPuts", new Object[]{testName + "_PR", 20000});
        vm4.invoke(WANTestBase.class, "validateRegionSize", new Object[]{testName + "_PR", 20000});
        ArrayList v4List = (ArrayList)vm5.invoke(WANTestBase.class, "getSenderStats", new Object[]{"ln", -1});
        ArrayList v5List = (ArrayList)vm5.invoke(WANTestBase.class, "getSenderStats", new Object[]{"ln", -1});
        ArrayList v6List = (ArrayList)vm6.invoke(WANTestBase.class, "getSenderStats", new Object[]{"ln", -1});
        ArrayList v7List = (ArrayList)vm7.invoke(WANTestBase.class, "getSenderStats", new Object[]{"ln", -1});
        ParallelWANStatsDUnitTest.assertTrue(((Integer)v4List.get(4) + (Integer)v5List.get(4) + (Integer)v6List.get(4) + (Integer)v7List.get(4) >= 1 ? 1 : 0) != 0);
        ParallelWANStatsDUnitTest.assertTrue(((Integer)v4List.get(5) + (Integer)v5List.get(5) + (Integer)v6List.get(5) + (Integer)v7List.get(5) >= 1 ? 1 : 0) != 0);
    }

    public void testParallelPropogationWithFilter() throws Exception {
        Integer lnPort = (Integer)vm0.invoke(WANTestBase.class, "createFirstLocatorWithDSId", new Object[]{1});
        Integer nyPort = (Integer)vm1.invoke(WANTestBase.class, "createFirstRemoteLocator", new Object[]{2, lnPort});
        vm2.invoke(WANTestBase.class, "createReceiver", new Object[]{nyPort});
        vm4.invoke(WANTestBase.class, "createCache", new Object[]{lnPort});
        vm5.invoke(WANTestBase.class, "createCache", new Object[]{lnPort});
        vm6.invoke(WANTestBase.class, "createCache", new Object[]{lnPort});
        vm7.invoke(WANTestBase.class, "createCache", new Object[]{lnPort});
        vm4.invoke(WANTestBase.class, "createSender", new Object[]{"ln", 2, true, 100, 10, false, false, new WANTestBase.MyGatewayEventFilter(), true});
        vm5.invoke(WANTestBase.class, "createSender", new Object[]{"ln", 2, true, 100, 10, false, false, new WANTestBase.MyGatewayEventFilter(), true});
        vm6.invoke(WANTestBase.class, "createSender", new Object[]{"ln", 2, true, 100, 10, false, false, new WANTestBase.MyGatewayEventFilter(), true});
        vm7.invoke(WANTestBase.class, "createSender", new Object[]{"ln", 2, true, 100, 10, false, false, new WANTestBase.MyGatewayEventFilter(), true});
        vm4.invoke(WANTestBase.class, "createPartitionedRegion", new Object[]{testName, "ln", 0, 100, this.isOffHeap()});
        vm5.invoke(WANTestBase.class, "createPartitionedRegion", new Object[]{testName, "ln", 0, 100, this.isOffHeap()});
        vm6.invoke(WANTestBase.class, "createPartitionedRegion", new Object[]{testName, "ln", 0, 100, this.isOffHeap()});
        vm7.invoke(WANTestBase.class, "createPartitionedRegion", new Object[]{testName, "ln", 0, 100, this.isOffHeap()});
        vm4.invoke(WANTestBase.class, "startSender", new Object[]{"ln"});
        vm5.invoke(WANTestBase.class, "startSender", new Object[]{"ln"});
        vm6.invoke(WANTestBase.class, "startSender", new Object[]{"ln"});
        vm7.invoke(WANTestBase.class, "startSender", new Object[]{"ln"});
        vm2.invoke(WANTestBase.class, "createPartitionedRegion", new Object[]{testName, null, 1, 100, this.isOffHeap()});
        vm4.invoke(WANTestBase.class, "doPuts", new Object[]{testName, 1000});
        vm2.invoke(WANTestBase.class, "validateRegionSize", new Object[]{testName, 800});
        ArrayList v4List = (ArrayList)vm4.invoke(WANTestBase.class, "getSenderStats", new Object[]{"ln", 0});
        ArrayList v5List = (ArrayList)vm5.invoke(WANTestBase.class, "getSenderStats", new Object[]{"ln", 0});
        ArrayList v6List = (ArrayList)vm6.invoke(WANTestBase.class, "getSenderStats", new Object[]{"ln", 0});
        ArrayList v7List = (ArrayList)vm7.invoke(WANTestBase.class, "getSenderStats", new Object[]{"ln", 0});
        ParallelWANStatsDUnitTest.assertEquals((int)0, (int)((Integer)v4List.get(0) + (Integer)v5List.get(0) + (Integer)v6List.get(0) + (Integer)v7List.get(0)));
        ParallelWANStatsDUnitTest.assertEquals((int)1000, (int)((Integer)v4List.get(1) + (Integer)v5List.get(1) + (Integer)v6List.get(1) + (Integer)v7List.get(1)));
        ParallelWANStatsDUnitTest.assertEquals((int)900, (int)((Integer)v4List.get(2) + (Integer)v5List.get(2) + (Integer)v6List.get(2) + (Integer)v7List.get(2)));
        ParallelWANStatsDUnitTest.assertEquals((int)800, (int)((Integer)v4List.get(3) + (Integer)v5List.get(3) + (Integer)v6List.get(3) + (Integer)v7List.get(3)));
        ParallelWANStatsDUnitTest.assertTrue(((Integer)v4List.get(4) + (Integer)v5List.get(4) + (Integer)v6List.get(4) + (Integer)v7List.get(4) >= 80 ? 1 : 0) != 0);
        ParallelWANStatsDUnitTest.assertEquals((int)0, (int)((Integer)v4List.get(5) + (Integer)v5List.get(5) + (Integer)v6List.get(5) + (Integer)v7List.get(5)));
        ParallelWANStatsDUnitTest.assertEquals((int)200, (int)((Integer)v4List.get(6) + (Integer)v5List.get(6) + (Integer)v6List.get(6) + (Integer)v7List.get(6)));
        vm2.invoke(WANTestBase.class, "checkGatewayReceiverStats", new Object[]{80, 800, 800});
    }

    public void testParallelPropagationConflation() throws Exception {
        int i;
        Integer lnPort = (Integer)vm0.invoke(WANTestBase.class, "createFirstLocatorWithDSId", new Object[]{1});
        Integer nyPort = (Integer)vm1.invoke(WANTestBase.class, "createFirstRemoteLocator", new Object[]{2, lnPort});
        vm2.invoke(WANTestBase.class, "createReceiver", new Object[]{nyPort});
        vm4.invoke(WANTestBase.class, "createCache", new Object[]{lnPort});
        vm5.invoke(WANTestBase.class, "createCache", new Object[]{lnPort});
        vm6.invoke(WANTestBase.class, "createCache", new Object[]{lnPort});
        vm7.invoke(WANTestBase.class, "createCache", new Object[]{lnPort});
        vm4.invoke(WANTestBase.class, "createSender", new Object[]{"ln", 2, true, 100, 10, true, false, null, true});
        vm5.invoke(WANTestBase.class, "createSender", new Object[]{"ln", 2, true, 100, 10, true, false, null, true});
        vm6.invoke(WANTestBase.class, "createSender", new Object[]{"ln", 2, true, 100, 10, true, false, null, true});
        vm7.invoke(WANTestBase.class, "createSender", new Object[]{"ln", 2, true, 100, 10, true, false, null, true});
        vm4.invoke(WANTestBase.class, "createPartitionedRegion", new Object[]{testName, "ln", 0, 100, this.isOffHeap()});
        vm5.invoke(WANTestBase.class, "createPartitionedRegion", new Object[]{testName, "ln", 0, 100, this.isOffHeap()});
        vm6.invoke(WANTestBase.class, "createPartitionedRegion", new Object[]{testName, "ln", 0, 100, this.isOffHeap()});
        vm7.invoke(WANTestBase.class, "createPartitionedRegion", new Object[]{testName, "ln", 0, 100, this.isOffHeap()});
        vm4.invoke(WANTestBase.class, "startSender", new Object[]{"ln"});
        vm5.invoke(WANTestBase.class, "startSender", new Object[]{"ln"});
        vm6.invoke(WANTestBase.class, "startSender", new Object[]{"ln"});
        vm7.invoke(WANTestBase.class, "startSender", new Object[]{"ln"});
        ParallelWANStatsDUnitTest.pause(3000);
        vm4.invoke(WANTestBase.class, "pauseSender", new Object[]{"ln"});
        vm5.invoke(WANTestBase.class, "pauseSender", new Object[]{"ln"});
        vm6.invoke(WANTestBase.class, "pauseSender", new Object[]{"ln"});
        vm7.invoke(WANTestBase.class, "pauseSender", new Object[]{"ln"});
        vm2.invoke(WANTestBase.class, "createPartitionedRegion", new Object[]{testName, null, 1, 100, this.isOffHeap()});
        ParallelWANStatsDUnitTest.pause(2000);
        HashMap<Integer, Integer> keyValues = new HashMap<Integer, Integer>();
        HashMap<Integer, String> updateKeyValues = new HashMap<Integer, String>();
        for (i = 0; i < 1000; ++i) {
            keyValues.put(i, i);
        }
        vm4.invoke(WANTestBase.class, "putGivenKeyValue", new Object[]{testName, keyValues});
        vm4.invoke(WANTestBase.class, "checkQueueSize", new Object[]{"ln", keyValues.size()});
        for (i = 0; i < 500; ++i) {
            updateKeyValues.put(i, i + "_updated");
        }
        vm4.invoke(WANTestBase.class, "putGivenKeyValue", new Object[]{testName, updateKeyValues});
        vm4.invoke(WANTestBase.class, "checkQueueSize", new Object[]{"ln", keyValues.size()});
        vm2.invoke(WANTestBase.class, "validateRegionSize", new Object[]{testName, 0});
        vm2.invoke(WANTestBase.class, "checkGatewayReceiverStats", new Object[]{0, 0, 0});
        vm4.invoke(WANTestBase.class, "resumeSender", new Object[]{"ln"});
        vm5.invoke(WANTestBase.class, "resumeSender", new Object[]{"ln"});
        vm6.invoke(WANTestBase.class, "resumeSender", new Object[]{"ln"});
        vm7.invoke(WANTestBase.class, "resumeSender", new Object[]{"ln"});
        keyValues.putAll(updateKeyValues);
        vm2.invoke(WANTestBase.class, "validateRegionSize", new Object[]{testName, keyValues.size()});
        vm2.invoke(WANTestBase.class, "validateRegionContents", new Object[]{testName, keyValues});
        vm2.invoke(WANTestBase.class, "checkGatewayReceiverStats", new Object[]{0, 1000, 500});
        vm4.invoke(WANTestBase.class, "checkQueueSize", new Object[]{"ln", 0});
        ArrayList v4List = (ArrayList)vm4.invoke(WANTestBase.class, "getSenderStats", new Object[]{"ln", 0});
        ArrayList v5List = (ArrayList)vm5.invoke(WANTestBase.class, "getSenderStats", new Object[]{"ln", 0});
        ArrayList v6List = (ArrayList)vm6.invoke(WANTestBase.class, "getSenderStats", new Object[]{"ln", 0});
        ArrayList v7List = (ArrayList)vm7.invoke(WANTestBase.class, "getSenderStats", new Object[]{"ln", 0});
        ParallelWANStatsDUnitTest.assertEquals((int)0, (int)((Integer)v4List.get(0) + (Integer)v5List.get(0) + (Integer)v6List.get(0) + (Integer)v7List.get(0)));
        ParallelWANStatsDUnitTest.assertEquals((int)1500, (int)((Integer)v4List.get(1) + (Integer)v5List.get(1) + (Integer)v6List.get(1) + (Integer)v7List.get(1)));
        ParallelWANStatsDUnitTest.assertEquals((int)1500, (int)((Integer)v4List.get(2) + (Integer)v5List.get(2) + (Integer)v6List.get(2) + (Integer)v7List.get(2)));
        ParallelWANStatsDUnitTest.assertEquals((int)1000, (int)((Integer)v4List.get(3) + (Integer)v5List.get(3) + (Integer)v6List.get(3) + (Integer)v7List.get(3)));
        ParallelWANStatsDUnitTest.assertTrue(((Integer)v4List.get(4) + (Integer)v5List.get(4) + (Integer)v6List.get(4) + (Integer)v7List.get(4) >= 100 ? 1 : 0) != 0);
        ParallelWANStatsDUnitTest.assertEquals((int)0, (int)((Integer)v4List.get(5) + (Integer)v5List.get(5) + (Integer)v6List.get(5) + (Integer)v7List.get(5)));
        ParallelWANStatsDUnitTest.assertEquals((int)500, (int)((Integer)v4List.get(7) + (Integer)v5List.get(7) + (Integer)v6List.get(7) + (Integer)v7List.get(7)));
    }
}

