/*
 * Decompiled with CFR 0.152.
 */
package com.gemstone.gemfire.internal.cache.wan.serial;

import com.gemstone.gemfire.cache.asyncqueue.AsyncEventListener;
import com.gemstone.gemfire.cache.wan.GatewaySender;
import com.gemstone.gemfire.internal.AvailablePortHelper;
import com.gemstone.gemfire.internal.cache.wan.AbstractGatewaySender;
import com.gemstone.gemfire.internal.cache.wan.MyGatewaySenderEventListener;
import com.gemstone.gemfire.internal.cache.wan.MyGatewaySenderEventListener2;
import com.gemstone.gemfire.internal.cache.wan.WANTestBase;
import com.gemstone.gemfire.internal.cache.wan.serial.SerialGatewaySenderImpl;
import dunit.DistributedTestCase;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class SerialGatewaySenderEventListenerDUnitTest
extends WANTestBase {
    private static final long serialVersionUID = 1L;

    public SerialGatewaySenderEventListenerDUnitTest(String name) {
        super(name);
    }

    @Override
    public void setUp() throws Exception {
        super.setUp();
    }

    public void __testGatewaySenderEventListenerInvocationWithoutLocator() {
        int mPort = AvailablePortHelper.getRandomAvailablePortForDUnitSite();
        vm4.invoke(WANTestBase.class, "createCacheWithoutLocator", new Object[]{mPort});
        vm5.invoke(WANTestBase.class, "createCacheWithoutLocator", new Object[]{mPort});
        vm6.invoke(WANTestBase.class, "createCacheWithoutLocator", new Object[]{mPort});
        vm7.invoke(WANTestBase.class, "createCacheWithoutLocator", new Object[]{mPort});
        vm4.invoke(WANTestBase.class, "createSenderWithListener", new Object[]{"ln", 2, false, 100, 10, false, false, null, false, true});
        vm5.invoke(WANTestBase.class, "createSenderWithListener", new Object[]{"ln", 2, false, 100, 10, false, false, null, false, true});
        vm4.invoke(WANTestBase.class, "startSender", new Object[]{"ln"});
        vm5.invoke(WANTestBase.class, "startSender", new Object[]{"ln"});
        vm4.invoke(WANTestBase.class, "createReplicatedRegion", new Object[]{testName + "_RR", "ln", this.isOffHeap()});
        vm5.invoke(WANTestBase.class, "createReplicatedRegion", new Object[]{testName + "_RR", "ln", this.isOffHeap()});
        vm6.invoke(WANTestBase.class, "createReplicatedRegion", new Object[]{testName + "_RR", "ln", this.isOffHeap()});
        vm7.invoke(WANTestBase.class, "createReplicatedRegion", new Object[]{testName + "_RR", "ln", this.isOffHeap()});
        HashMap<Integer, Integer> keyValues = new HashMap<Integer, Integer>();
        for (int i = 0; i < 1000; ++i) {
            keyValues.put(i, i);
        }
        vm4.invoke(WANTestBase.class, "putGivenKeyValue", new Object[]{testName + "_RR", keyValues});
        vm4.invoke(WANTestBase.class, "validateRegionSize", new Object[]{testName + "_RR", keyValues.size()});
        vm5.invoke(WANTestBase.class, "validateRegionSize", new Object[]{testName + "_RR", keyValues.size()});
        vm4.invoke(WANTestBase.class, "printEventListenerMap", new Object[0]);
        vm5.invoke(WANTestBase.class, "printEventListenerMap", new Object[0]);
        vm4.invoke(SerialGatewaySenderEventListenerDUnitTest.class, "validateReceivedEventsMapSizeListener1", new Object[]{"ln", keyValues});
    }

    public void testGatewaySenderEventListenerInvocation() {
        Integer lnPort = (Integer)vm0.invoke(WANTestBase.class, "createFirstLocatorWithDSId", new Object[]{1});
        Integer nyPort = (Integer)vm1.invoke(WANTestBase.class, "createFirstRemoteLocator", new Object[]{2, lnPort});
        vm2.invoke(WANTestBase.class, "createReceiver", new Object[]{nyPort});
        vm3.invoke(WANTestBase.class, "createReceiver", new Object[]{nyPort});
        vm4.invoke(WANTestBase.class, "createCache", new Object[]{lnPort});
        vm5.invoke(WANTestBase.class, "createCache", new Object[]{lnPort});
        vm6.invoke(WANTestBase.class, "createCache", new Object[]{lnPort});
        vm7.invoke(WANTestBase.class, "createCache", new Object[]{lnPort});
        vm4.invoke(WANTestBase.class, "createSenderWithListener", new Object[]{"ln", 2, false, 100, 10, false, false, null, false, true});
        vm5.invoke(WANTestBase.class, "createSenderWithListener", new Object[]{"ln", 2, false, 100, 10, false, false, null, false, true});
        vm2.invoke(WANTestBase.class, "createReplicatedRegion", new Object[]{testName + "_RR", null, this.isOffHeap()});
        vm3.invoke(WANTestBase.class, "createReplicatedRegion", new Object[]{testName + "_RR", null, this.isOffHeap()});
        vm4.invoke(WANTestBase.class, "startSender", new Object[]{"ln"});
        vm5.invoke(WANTestBase.class, "startSender", new Object[]{"ln"});
        vm4.invoke(WANTestBase.class, "createReplicatedRegion", new Object[]{testName + "_RR", "ln", this.isOffHeap()});
        vm5.invoke(WANTestBase.class, "createReplicatedRegion", new Object[]{testName + "_RR", "ln", this.isOffHeap()});
        vm6.invoke(WANTestBase.class, "createReplicatedRegion", new Object[]{testName + "_RR", "ln", this.isOffHeap()});
        vm7.invoke(WANTestBase.class, "createReplicatedRegion", new Object[]{testName + "_RR", "ln", this.isOffHeap()});
        HashMap<Integer, Integer> keyValues = new HashMap<Integer, Integer>();
        for (int i = 0; i < 1000; ++i) {
            keyValues.put(i, i);
        }
        vm4.invoke(WANTestBase.class, "putGivenKeyValue", new Object[]{testName + "_RR", keyValues});
        vm4.invoke(WANTestBase.class, "validateRegionSize", new Object[]{testName + "_RR", keyValues.size()});
        vm5.invoke(WANTestBase.class, "validateRegionSize", new Object[]{testName + "_RR", keyValues.size()});
        vm2.invoke(WANTestBase.class, "validateRegionSize", new Object[]{testName + "_RR", 0});
        vm3.invoke(WANTestBase.class, "validateRegionSize", new Object[]{testName + "_RR", 0});
        vm4.invoke(SerialGatewaySenderEventListenerDUnitTest.class, "validateReceivedEventsMapSizeListener1", new Object[]{"ln", keyValues});
    }

    public void testGatewaySender2EventListenerInvocation() {
        Integer lnPort = (Integer)vm0.invoke(WANTestBase.class, "createFirstLocatorWithDSId", new Object[]{1});
        Integer nyPort = (Integer)vm1.invoke(WANTestBase.class, "createFirstRemoteLocator", new Object[]{2, lnPort});
        vm2.invoke(WANTestBase.class, "createReceiver", new Object[]{nyPort});
        vm3.invoke(WANTestBase.class, "createReceiver", new Object[]{nyPort});
        vm4.invoke(WANTestBase.class, "createCache", new Object[]{lnPort});
        vm5.invoke(WANTestBase.class, "createCache", new Object[]{lnPort});
        vm6.invoke(WANTestBase.class, "createCache", new Object[]{lnPort});
        vm7.invoke(WANTestBase.class, "createCache", new Object[]{lnPort});
        vm4.invoke(WANTestBase.class, "createSenderWithListener", new Object[]{"ln", 2, false, 100, 10, false, false, null, true, true});
        vm5.invoke(WANTestBase.class, "createSenderWithListener", new Object[]{"ln", 2, false, 100, 10, false, false, null, true, true});
        vm2.invoke(WANTestBase.class, "createReplicatedRegion", new Object[]{testName + "_RR", null, this.isOffHeap()});
        vm3.invoke(WANTestBase.class, "createReplicatedRegion", new Object[]{testName + "_RR", null, this.isOffHeap()});
        vm4.invoke(WANTestBase.class, "startSender", new Object[]{"ln"});
        vm5.invoke(WANTestBase.class, "startSender", new Object[]{"ln"});
        vm4.invoke(WANTestBase.class, "createReplicatedRegion", new Object[]{testName + "_RR", "ln", this.isOffHeap()});
        vm5.invoke(WANTestBase.class, "createReplicatedRegion", new Object[]{testName + "_RR", "ln", this.isOffHeap()});
        vm6.invoke(WANTestBase.class, "createReplicatedRegion", new Object[]{testName + "_RR", "ln", this.isOffHeap()});
        vm7.invoke(WANTestBase.class, "createReplicatedRegion", new Object[]{testName + "_RR", "ln", this.isOffHeap()});
        HashMap<Integer, Integer> keyValues = new HashMap<Integer, Integer>();
        for (int i = 0; i < 1000; ++i) {
            keyValues.put(i, i);
        }
        vm4.invoke(WANTestBase.class, "putGivenKeyValue", new Object[]{testName + "_RR", keyValues});
        vm2.invoke(WANTestBase.class, "validateRegionSize", new Object[]{testName + "_RR", 0});
        vm3.invoke(WANTestBase.class, "validateRegionSize", new Object[]{testName + "_RR", 0});
        vm4.invoke(SerialGatewaySenderEventListenerDUnitTest.class, "validateReceivedEventsMapSizeListener2", new Object[]{"ln", keyValues});
    }

    public void testGatewaySenderEventListenerPoolImpl() {
        Integer lnPort = (Integer)vm0.invoke(WANTestBase.class, "createFirstLocatorWithDSId", new Object[]{1});
        Integer nyPort = (Integer)vm1.invoke(WANTestBase.class, "createFirstRemoteLocator", new Object[]{2, lnPort});
        vm2.invoke(WANTestBase.class, "createReceiver", new Object[]{nyPort});
        vm3.invoke(WANTestBase.class, "createReceiver", new Object[]{nyPort});
        vm4.invoke(WANTestBase.class, "createCache", new Object[]{lnPort});
        vm4.invoke(WANTestBase.class, "createSenderWithListener", new Object[]{"ln", 2, false, 100, 10, false, false, null, false, false});
        vm4.invoke(SerialGatewaySenderEventListenerDUnitTest.class, "validateNoPoolCreation", new Object[]{"ln"});
    }

    public void __testGatewaySenderEventListener_GatewayOperations() {
        int mPort = AvailablePortHelper.getRandomAvailablePortForDUnitSite();
        vm4.invoke(WANTestBase.class, "createCacheWithoutLocator", new Object[]{mPort});
        vm5.invoke(WANTestBase.class, "createCacheWithoutLocator", new Object[]{mPort});
        vm6.invoke(WANTestBase.class, "createCacheWithoutLocator", new Object[]{mPort});
        vm7.invoke(WANTestBase.class, "createCacheWithoutLocator", new Object[]{mPort});
        vm4.invoke(WANTestBase.class, "createSenderWithListener", new Object[]{"ln", 2, false, 100, 10, false, false, null, false, true});
        vm4.invoke(WANTestBase.class, "startSender", new Object[]{"ln"});
        vm4.invoke(WANTestBase.class, "createReplicatedRegion", new Object[]{testName + "_RR", "ln", this.isOffHeap()});
        vm5.invoke(WANTestBase.class, "createReplicatedRegion", new Object[]{testName + "_RR", "ln", this.isOffHeap()});
        vm6.invoke(WANTestBase.class, "createReplicatedRegion", new Object[]{testName + "_RR", "ln", this.isOffHeap()});
        vm7.invoke(WANTestBase.class, "createReplicatedRegion", new Object[]{testName + "_RR", "ln", this.isOffHeap()});
        HashMap<Integer, Integer> initialKeyValues = new HashMap<Integer, Integer>();
        for (int i = 0; i < 1000; ++i) {
            initialKeyValues.put(i, i);
        }
        vm4.invoke(WANTestBase.class, "putGivenKeyValue", new Object[]{testName + "_RR", initialKeyValues});
        vm4.invoke(SerialGatewaySenderEventListenerDUnitTest.class, "validateReceivedEventsMapSizeListener1", new Object[]{"ln", initialKeyValues});
        vm4.invoke(WANTestBase.class, "stopSender", new Object[]{"ln"});
        HashMap<Integer, Integer> keyValues = new HashMap<Integer, Integer>();
        for (int i = 1000; i < 2000; ++i) {
            keyValues.put(i, i);
        }
        vm4.invoke(WANTestBase.class, "putGivenKeyValue", new Object[]{testName + "_RR", keyValues});
        vm4.invoke(SerialGatewaySenderEventListenerDUnitTest.class, "validateReceivedEventsMapSizeListener1", new Object[]{"ln", initialKeyValues});
        vm4.invoke(WANTestBase.class, "startSender", new Object[]{"ln"});
        HashMap<Integer, Integer> finalKeyValues = new HashMap<Integer, Integer>();
        for (int i = 2000; i < 3000; ++i) {
            finalKeyValues.put(i, i);
        }
        vm4.invoke(WANTestBase.class, "putGivenKeyValue", new Object[]{testName + "_RR", finalKeyValues});
        finalKeyValues.putAll(initialKeyValues);
        vm4.invoke(SerialGatewaySenderEventListenerDUnitTest.class, "validateReceivedEventsMapSizeListener1", new Object[]{"ln", finalKeyValues});
    }

    public static void validateNoPoolCreation(String siteId) {
        Set senders = cache.getGatewaySenders();
        for (GatewaySender sender : senders) {
            if (!sender.getId().equals(siteId)) continue;
            SerialGatewaySenderImpl sImpl = (SerialGatewaySenderImpl)sender;
            SerialGatewaySenderEventListenerDUnitTest.assertNull((Object)sImpl.getProxy());
        }
    }

    public static void validateReceivedEventsMapSizeListener1(String senderId, final HashMap map) {
        List listeners;
        Set senders = cache.getGatewaySenders();
        GatewaySender sender = null;
        for (GatewaySender s : senders) {
            if (!s.getId().equals(senderId)) continue;
            sender = s;
            break;
        }
        if ((listeners = ((AbstractGatewaySender)sender).getAsyncEventListeners()).size() == 1) {
            final AsyncEventListener l = (AsyncEventListener)listeners.get(0);
            DistributedTestCase.WaitCriterion wc = new DistributedTestCase.WaitCriterion(){
                Map listenerMap;

                @Override
                public boolean done() {
                    this.listenerMap = ((MyGatewaySenderEventListener)l).getEventsMap();
                    boolean sizeCorrect = map.size() == this.listenerMap.size();
                    boolean keySetCorrect = this.listenerMap.keySet().containsAll(map.keySet());
                    boolean valuesCorrect = this.listenerMap.values().containsAll(map.values());
                    return sizeCorrect && keySetCorrect && valuesCorrect;
                }

                @Override
                public String description() {
                    return "Waiting for all sites to get updated, the sizes are " + this.listenerMap.size() + " and " + map.size();
                }
            };
            DistributedTestCase.waitForCriterion(wc, 60000L, 500L, true);
        }
    }

    public static void validateReceivedEventsMapSizeListener2(String senderId, final HashMap map) {
        List listeners;
        Set senders = cache.getGatewaySenders();
        GatewaySender sender = null;
        for (GatewaySender s : senders) {
            if (!s.getId().equals(senderId)) continue;
            sender = s;
            break;
        }
        if ((listeners = ((AbstractGatewaySender)sender).getAsyncEventListeners()).size() == 2) {
            final AsyncEventListener l1 = (AsyncEventListener)listeners.get(0);
            final AsyncEventListener l2 = (AsyncEventListener)listeners.get(1);
            DistributedTestCase.WaitCriterion wc = new DistributedTestCase.WaitCriterion(){
                Map listenerMap1;
                Map listenerMap2;

                @Override
                public boolean done() {
                    this.listenerMap1 = ((MyGatewaySenderEventListener)l1).getEventsMap();
                    this.listenerMap2 = ((MyGatewaySenderEventListener2)l2).getEventsMap();
                    boolean sizeCorrect = map.size() == this.listenerMap1.size();
                    boolean keySetCorrect = this.listenerMap1.keySet().containsAll(map.keySet());
                    boolean valuesCorrect = this.listenerMap1.values().containsAll(map.values());
                    boolean sizeCorrect2 = map.size() == this.listenerMap2.size();
                    boolean keySetCorrect2 = this.listenerMap2.keySet().containsAll(map.keySet());
                    boolean valuesCorrect2 = this.listenerMap2.values().containsAll(map.values());
                    return sizeCorrect && keySetCorrect && valuesCorrect && sizeCorrect2 && keySetCorrect2 && valuesCorrect2;
                }

                @Override
                public String description() {
                    return "Waiting for all sites to get updated, the sizes are " + this.listenerMap1.size() + " and listenerMap2 " + this.listenerMap2.size() + " expected map size " + map.size();
                }
            };
            DistributedTestCase.waitForCriterion(wc, 60000L, 500L, true);
        }
    }
}

