/*
 * Decompiled with CFR 0.152.
 */
package com.gemstone.gemfire.internal.cache.wan.serial;

import com.gemstone.gemfire.cache.CacheException;
import com.gemstone.gemfire.cache.EntryExistsException;
import com.gemstone.gemfire.cache.client.ServerOperationException;
import com.gemstone.gemfire.cache30.CacheSerializableRunnable;
import com.gemstone.gemfire.internal.cache.wan.BatchException70;
import com.gemstone.gemfire.internal.cache.wan.WANTestBase;
import dunit.AsyncInvocation;
import java.io.IOException;
import java.util.Map;

public class SerialWANPropogationDUnitTest
extends WANTestBase {
    private static final long serialVersionUID = 1L;

    public SerialWANPropogationDUnitTest(String name) {
        super(name);
    }

    @Override
    public void setUp() throws Exception {
        super.setUp();
    }

    public void testReplicatedSerialPropagation_withoutRemoteLocator() throws Exception {
        Integer lnPort = (Integer)vm0.invoke(WANTestBase.class, "createFirstLocatorWithDSId", new Object[]{1});
        vm4.invoke(WANTestBase.class, "createCache", new Object[]{lnPort});
        vm5.invoke(WANTestBase.class, "createCache", new Object[]{lnPort});
        vm6.invoke(WANTestBase.class, "createCache", new Object[]{lnPort});
        vm7.invoke(WANTestBase.class, "createCache", new Object[]{lnPort});
        vm4.invoke(WANTestBase.class, "createSender", new Object[]{"ln", 2, false, 100, 400, false, false, null, true});
        vm5.invoke(WANTestBase.class, "createSender", new Object[]{"ln", 2, false, 100, 400, false, false, null, true});
        vm4.invoke(WANTestBase.class, "startSender", new Object[]{"ln"});
        vm5.invoke(WANTestBase.class, "startSender", new Object[]{"ln"});
        vm4.invoke(WANTestBase.class, "createReplicatedRegion", new Object[]{testName + "_RR", "ln", this.isOffHeap()});
        vm5.invoke(WANTestBase.class, "createReplicatedRegion", new Object[]{testName + "_RR", "ln", this.isOffHeap()});
        vm6.invoke(WANTestBase.class, "createReplicatedRegion", new Object[]{testName + "_RR", "ln", this.isOffHeap()});
        vm7.invoke(WANTestBase.class, "createReplicatedRegion", new Object[]{testName + "_RR", "ln", this.isOffHeap()});
        vm4.invoke(WANTestBase.class, "doPuts", new Object[]{testName + "_RR", 1000});
        Integer nyPort = (Integer)vm1.invoke(WANTestBase.class, "createFirstRemoteLocator", new Object[]{2, lnPort});
        vm2.invoke(WANTestBase.class, "createCache", new Object[]{nyPort});
        vm3.invoke(WANTestBase.class, "createCache", new Object[]{nyPort});
        vm2.invoke(WANTestBase.class, "createReceiver2", new Object[]{nyPort});
        vm3.invoke(WANTestBase.class, "createReceiver2", new Object[]{nyPort});
        vm2.invoke(WANTestBase.class, "createReplicatedRegion", new Object[]{testName + "_RR", null, this.isOffHeap()});
        vm3.invoke(WANTestBase.class, "createReplicatedRegion", new Object[]{testName + "_RR", null, this.isOffHeap()});
        vm4.invoke(WANTestBase.class, "validateRegionSize", new Object[]{testName + "_RR", 1000});
        vm2.invoke(WANTestBase.class, "validateRegionSize", new Object[]{testName + "_RR", 1000});
        vm3.invoke(WANTestBase.class, "validateRegionSize", new Object[]{testName + "_RR", 1000});
    }

    public void testReplicatedSerialPropagation_withoutRemoteSite() throws Exception {
        Integer lnPort = (Integer)vm0.invoke(WANTestBase.class, "createFirstLocatorWithDSId", new Object[]{1});
        Integer nyPort = (Integer)vm1.invoke(WANTestBase.class, "createFirstRemoteLocator", new Object[]{2, lnPort});
        vm4.invoke(WANTestBase.class, "createCache", new Object[]{lnPort});
        vm5.invoke(WANTestBase.class, "createCache", new Object[]{lnPort});
        vm6.invoke(WANTestBase.class, "createCache", new Object[]{lnPort});
        vm7.invoke(WANTestBase.class, "createCache", new Object[]{lnPort});
        vm4.invoke(WANTestBase.class, "createSender", new Object[]{"ln", 2, false, 100, 400, false, false, null, true});
        vm5.invoke(WANTestBase.class, "createSender", new Object[]{"ln", 2, false, 100, 400, false, false, null, true});
        vm4.invoke(WANTestBase.class, "startSender", new Object[]{"ln"});
        vm5.invoke(WANTestBase.class, "startSender", new Object[]{"ln"});
        vm4.invoke(WANTestBase.class, "createReplicatedRegion", new Object[]{testName + "_RR", "ln", this.isOffHeap()});
        vm5.invoke(WANTestBase.class, "createReplicatedRegion", new Object[]{testName + "_RR", "ln", this.isOffHeap()});
        vm6.invoke(WANTestBase.class, "createReplicatedRegion", new Object[]{testName + "_RR", "ln", this.isOffHeap()});
        vm7.invoke(WANTestBase.class, "createReplicatedRegion", new Object[]{testName + "_RR", "ln", this.isOffHeap()});
        SerialWANPropogationDUnitTest.addExpectedException(BatchException70.class.getName());
        SerialWANPropogationDUnitTest.addExpectedException(ServerOperationException.class.getName());
        vm4.invoke(WANTestBase.class, "doPuts", new Object[]{testName + "_RR", 1000});
        vm2.invoke(WANTestBase.class, "createCache", new Object[]{nyPort});
        vm3.invoke(WANTestBase.class, "createCache", new Object[]{nyPort});
        vm2.invoke(WANTestBase.class, "createReceiver2", new Object[]{nyPort});
        vm3.invoke(WANTestBase.class, "createReceiver2", new Object[]{nyPort});
        vm2.invoke(WANTestBase.class, "createReplicatedRegion", new Object[]{testName + "_RR", null, this.isOffHeap()});
        vm3.invoke(WANTestBase.class, "createReplicatedRegion", new Object[]{testName + "_RR", null, this.isOffHeap()});
        vm4.invoke(WANTestBase.class, "validateRegionSize", new Object[]{testName + "_RR", 1000});
        vm2.invoke(WANTestBase.class, "validateRegionSize", new Object[]{testName + "_RR", 1000});
        vm3.invoke(WANTestBase.class, "validateRegionSize", new Object[]{testName + "_RR", 1000});
    }

    public void testReplicatedSerialPropagationWithoutRemoteSite_defect46595() throws Exception {
        Integer lnPort = (Integer)vm0.invoke(WANTestBase.class, "createFirstLocatorWithDSId", new Object[]{1});
        Integer nyPort = (Integer)vm1.invoke(WANTestBase.class, "createFirstRemoteLocator", new Object[]{2, lnPort});
        vm4.invoke(WANTestBase.class, "createCache", new Object[]{lnPort});
        vm5.invoke(WANTestBase.class, "createCache", new Object[]{lnPort});
        vm6.invoke(WANTestBase.class, "createCache", new Object[]{lnPort});
        vm7.invoke(WANTestBase.class, "createCache", new Object[]{lnPort});
        vm4.invoke(WANTestBase.class, "createSender", new Object[]{"ln", 2, false, 100, 5, false, false, null, true});
        vm5.invoke(WANTestBase.class, "createSender", new Object[]{"ln", 2, false, 100, 5, false, false, null, true});
        vm4.invoke(WANTestBase.class, "startSender", new Object[]{"ln"});
        vm5.invoke(WANTestBase.class, "startSender", new Object[]{"ln"});
        vm4.invoke(WANTestBase.class, "createReplicatedRegion", new Object[]{testName + "_RR", "ln", this.isOffHeap()});
        vm5.invoke(WANTestBase.class, "createReplicatedRegion", new Object[]{testName + "_RR", "ln", this.isOffHeap()});
        vm6.invoke(WANTestBase.class, "createReplicatedRegion", new Object[]{testName + "_RR", "ln", this.isOffHeap()});
        vm7.invoke(WANTestBase.class, "createReplicatedRegion", new Object[]{testName + "_RR", "ln", this.isOffHeap()});
        SerialWANPropogationDUnitTest.addExpectedException(BatchException70.class.getName());
        SerialWANPropogationDUnitTest.addExpectedException(ServerOperationException.class.getName());
        SerialWANPropogationDUnitTest.addExpectedException(IOException.class.getName());
        vm4.invoke(WANTestBase.class, "doPuts", new Object[]{testName + "_RR", 10000});
        SerialWANPropogationDUnitTest.pause(10000);
        vm2.invoke(WANTestBase.class, "createCache", new Object[]{nyPort});
        vm3.invoke(WANTestBase.class, "createCache", new Object[]{nyPort});
        vm2.invoke(WANTestBase.class, "createReceiver2", new Object[]{nyPort});
        vm3.invoke(WANTestBase.class, "createReceiver2", new Object[]{nyPort});
        vm2.invoke(WANTestBase.class, "createReplicatedRegion", new Object[]{testName + "_RR", null, this.isOffHeap()});
        vm3.invoke(WANTestBase.class, "createReplicatedRegion", new Object[]{testName + "_RR", null, this.isOffHeap()});
        vm4.invoke(WANTestBase.class, "validateRegionSize", new Object[]{testName + "_RR", 10000});
        vm2.invoke(WANTestBase.class, "validateRegionSize", new Object[]{testName + "_RR", 10000});
        vm3.invoke(WANTestBase.class, "validateRegionSize", new Object[]{testName + "_RR", 10000});
    }

    public void testReplicatedSerialPropagation() throws Exception {
        Integer lnPort = (Integer)vm0.invoke(WANTestBase.class, "createFirstLocatorWithDSId", new Object[]{1});
        Integer nyPort = (Integer)vm1.invoke(WANTestBase.class, "createFirstRemoteLocator", new Object[]{2, lnPort});
        vm2.invoke(WANTestBase.class, "createReceiver", new Object[]{nyPort});
        vm3.invoke(WANTestBase.class, "createReceiver", new Object[]{nyPort});
        vm4.invoke(WANTestBase.class, "createCache", new Object[]{lnPort});
        vm5.invoke(WANTestBase.class, "createCache", new Object[]{lnPort});
        vm6.invoke(WANTestBase.class, "createCache", new Object[]{lnPort});
        vm7.invoke(WANTestBase.class, "createCache", new Object[]{lnPort});
        vm4.invoke(WANTestBase.class, "createSender", new Object[]{"ln", 2, false, 100, 10, false, false, null, true});
        vm5.invoke(WANTestBase.class, "createSender", new Object[]{"ln", 2, false, 100, 10, false, false, null, true});
        vm2.invoke(WANTestBase.class, "createReplicatedRegion", new Object[]{testName + "_RR", null, this.isOffHeap()});
        vm3.invoke(WANTestBase.class, "createReplicatedRegion", new Object[]{testName + "_RR", null, this.isOffHeap()});
        vm4.invoke(WANTestBase.class, "startSender", new Object[]{"ln"});
        vm5.invoke(WANTestBase.class, "startSender", new Object[]{"ln"});
        vm4.invoke(WANTestBase.class, "createReplicatedRegion", new Object[]{testName + "_RR", "ln", this.isOffHeap()});
        vm5.invoke(WANTestBase.class, "createReplicatedRegion", new Object[]{testName + "_RR", "ln", this.isOffHeap()});
        vm6.invoke(WANTestBase.class, "createReplicatedRegion", new Object[]{testName + "_RR", "ln", this.isOffHeap()});
        vm7.invoke(WANTestBase.class, "createReplicatedRegion", new Object[]{testName + "_RR", "ln", this.isOffHeap()});
        vm4.invoke(WANTestBase.class, "doPuts", new Object[]{testName + "_RR", 1000});
        vm2.invoke(WANTestBase.class, "validateRegionSize", new Object[]{testName + "_RR", 1000});
        vm3.invoke(WANTestBase.class, "validateRegionSize", new Object[]{testName + "_RR", 1000});
    }

    public void testReplicatedSerialPropagationWithLocalSiteClosedAndRebuilt() throws Exception {
        Integer lnPort = (Integer)vm0.invoke(WANTestBase.class, "createFirstLocatorWithDSId", new Object[]{1});
        Integer nyPort = (Integer)vm1.invoke(WANTestBase.class, "createFirstRemoteLocator", new Object[]{2, lnPort});
        vm2.invoke(WANTestBase.class, "createReceiver", new Object[]{nyPort});
        vm3.invoke(WANTestBase.class, "createReceiver", new Object[]{nyPort});
        vm4.invoke(WANTestBase.class, "createCache", new Object[]{lnPort});
        vm5.invoke(WANTestBase.class, "createCache", new Object[]{lnPort});
        vm6.invoke(WANTestBase.class, "createCache", new Object[]{lnPort});
        vm7.invoke(WANTestBase.class, "createCache", new Object[]{lnPort});
        vm4.invoke(WANTestBase.class, "createSender", new Object[]{"ln", 2, false, 100, 10, false, false, null, true});
        vm5.invoke(WANTestBase.class, "createSender", new Object[]{"ln", 2, false, 100, 10, false, false, null, true});
        vm2.invoke(WANTestBase.class, "createReplicatedRegion", new Object[]{testName + "_RR", null, this.isOffHeap()});
        vm3.invoke(WANTestBase.class, "createReplicatedRegion", new Object[]{testName + "_RR", null, this.isOffHeap()});
        vm4.invoke(WANTestBase.class, "startSender", new Object[]{"ln"});
        vm5.invoke(WANTestBase.class, "startSender", new Object[]{"ln"});
        vm4.invoke(WANTestBase.class, "createReplicatedRegion", new Object[]{testName + "_RR", "ln", this.isOffHeap()});
        vm5.invoke(WANTestBase.class, "createReplicatedRegion", new Object[]{testName + "_RR", "ln", this.isOffHeap()});
        vm6.invoke(WANTestBase.class, "createReplicatedRegion", new Object[]{testName + "_RR", "ln", this.isOffHeap()});
        vm7.invoke(WANTestBase.class, "createReplicatedRegion", new Object[]{testName + "_RR", "ln", this.isOffHeap()});
        vm4.invoke(WANTestBase.class, "doPuts", new Object[]{testName + "_RR", 1000});
        vm4.invoke(WANTestBase.class, "killSender", new Object[0]);
        vm5.invoke(WANTestBase.class, "killSender", new Object[0]);
        vm6.invoke(WANTestBase.class, "killSender", new Object[0]);
        vm7.invoke(WANTestBase.class, "killSender", new Object[0]);
        Integer regionSize = (Integer)vm2.invoke(WANTestBase.class, "getRegionSize", new Object[]{testName + "_RR"});
        SerialWANPropogationDUnitTest.getLogWriter().info("Region size on remote is: " + regionSize);
        vm4.invoke(WANTestBase.class, "createCache", new Object[]{lnPort});
        vm5.invoke(WANTestBase.class, "createCache", new Object[]{lnPort});
        vm6.invoke(WANTestBase.class, "createCache", new Object[]{lnPort});
        vm7.invoke(WANTestBase.class, "createCache", new Object[]{lnPort});
        vm4.invoke(WANTestBase.class, "createSender", new Object[]{"ln", 2, false, 100, 10, false, false, null, true});
        vm5.invoke(WANTestBase.class, "createSender", new Object[]{"ln", 2, false, 100, 10, false, false, null, true});
        vm4.invoke(WANTestBase.class, "setRemoveFromQueueOnException", new Object[]{"ln", true});
        vm5.invoke(WANTestBase.class, "setRemoveFromQueueOnException", new Object[]{"ln", true});
        vm4.invoke(WANTestBase.class, "createReplicatedRegion", new Object[]{testName + "_RR", "ln", this.isOffHeap()});
        vm5.invoke(WANTestBase.class, "createReplicatedRegion", new Object[]{testName + "_RR", "ln", this.isOffHeap()});
        vm6.invoke(WANTestBase.class, "createReplicatedRegion", new Object[]{testName + "_RR", "ln", this.isOffHeap()});
        vm7.invoke(WANTestBase.class, "createReplicatedRegion", new Object[]{testName + "_RR", "ln", this.isOffHeap()});
        vm4.invoke(WANTestBase.class, "startSender", new Object[]{"ln"});
        vm5.invoke(WANTestBase.class, "startSender", new Object[]{"ln"});
        vm4.invoke(WANTestBase.class, "waitForSenderRunningState", new Object[]{"ln"});
        vm5.invoke(WANTestBase.class, "waitForSenderRunningState", new Object[]{"ln"});
        SerialWANPropogationDUnitTest.addExpectedException(EntryExistsException.class.getName());
        SerialWANPropogationDUnitTest.addExpectedException(BatchException70.class.getName());
        SerialWANPropogationDUnitTest.addExpectedException(ServerOperationException.class.getName());
        vm4.invoke(WANTestBase.class, "doPuts", new Object[]{testName + "_RR", 1000});
        vm2.invoke(WANTestBase.class, "validateRegionSize", new Object[]{testName + "_RR", 1000});
        vm3.invoke(WANTestBase.class, "validateRegionSize", new Object[]{testName + "_RR", 1000});
    }

    public void testReplicatedSerialPropagationWithLocalRegionDestroy() throws Exception {
        Integer lnPort = (Integer)vm0.invoke(WANTestBase.class, "createFirstLocatorWithDSId", new Object[]{1});
        Integer nyPort = (Integer)vm1.invoke(WANTestBase.class, "createFirstRemoteLocator", new Object[]{2, lnPort});
        vm2.invoke(WANTestBase.class, "createReceiver", new Object[]{nyPort});
        vm3.invoke(WANTestBase.class, "createReceiver", new Object[]{nyPort});
        vm4.invoke(WANTestBase.class, "createCache", new Object[]{lnPort});
        vm5.invoke(WANTestBase.class, "createCache", new Object[]{lnPort});
        vm6.invoke(WANTestBase.class, "createCache", new Object[]{lnPort});
        vm7.invoke(WANTestBase.class, "createCache", new Object[]{lnPort});
        vm4.invoke(WANTestBase.class, "createSender", new Object[]{"ln", 2, false, 100, 20, false, false, null, true});
        vm5.invoke(WANTestBase.class, "createSender", new Object[]{"ln", 2, false, 100, 20, false, false, null, true});
        vm2.invoke(WANTestBase.class, "createReplicatedRegion", new Object[]{testName + "_RR_1", null, this.isOffHeap()});
        vm3.invoke(WANTestBase.class, "createReplicatedRegion", new Object[]{testName + "_RR_1", null, this.isOffHeap()});
        vm2.invoke(WANTestBase.class, "createReplicatedRegion", new Object[]{testName + "_RR_2", null, this.isOffHeap()});
        vm3.invoke(WANTestBase.class, "createReplicatedRegion", new Object[]{testName + "_RR_2", null, this.isOffHeap()});
        vm4.invoke(WANTestBase.class, "startSender", new Object[]{"ln"});
        vm5.invoke(WANTestBase.class, "startSender", new Object[]{"ln"});
        vm4.invoke(WANTestBase.class, "createReplicatedRegion", new Object[]{testName + "_RR_1", "ln", this.isOffHeap()});
        vm5.invoke(WANTestBase.class, "createReplicatedRegion", new Object[]{testName + "_RR_1", "ln", this.isOffHeap()});
        vm6.invoke(WANTestBase.class, "createReplicatedRegion", new Object[]{testName + "_RR_1", "ln", this.isOffHeap()});
        vm7.invoke(WANTestBase.class, "createReplicatedRegion", new Object[]{testName + "_RR_1", "ln", this.isOffHeap()});
        vm4.invoke(WANTestBase.class, "createReplicatedRegion", new Object[]{testName + "_RR_2", "ln", this.isOffHeap()});
        vm5.invoke(WANTestBase.class, "createReplicatedRegion", new Object[]{testName + "_RR_2", "ln", this.isOffHeap()});
        vm6.invoke(WANTestBase.class, "createReplicatedRegion", new Object[]{testName + "_RR_2", "ln", this.isOffHeap()});
        vm7.invoke(WANTestBase.class, "createReplicatedRegion", new Object[]{testName + "_RR_2", "ln", this.isOffHeap()});
        AsyncInvocation inv1 = vm4.invokeAsync(WANTestBase.class, "doPuts", new Object[]{testName + "_RR_1", 1000});
        vm4.invoke(WANTestBase.class, "doPuts", new Object[]{testName + "_RR_2", 500});
        vm4.invoke(WANTestBase.class, "destroyRegion", new Object[]{testName + "_RR_2"});
        try {
            inv1.join();
        }
        catch (InterruptedException e) {
            e.printStackTrace();
            SerialWANPropogationDUnitTest.fail();
        }
        Thread.sleep(20L);
        vm2.invoke(WANTestBase.class, "validateRegionSize", new Object[]{testName + "_RR_1", 1000});
        vm3.invoke(WANTestBase.class, "validateRegionSize", new Object[]{testName + "_RR_2", 500});
    }

    public void testReplicatedSerialPropagationWithRemoteRegionDestroy() throws Exception {
        Integer lnPort = (Integer)vm0.invoke(WANTestBase.class, "createFirstLocatorWithDSId", new Object[]{1});
        Integer nyPort = (Integer)vm1.invoke(WANTestBase.class, "createFirstRemoteLocator", new Object[]{2, lnPort});
        vm2.invoke(WANTestBase.class, "createReceiver", new Object[]{nyPort});
        vm3.invoke(WANTestBase.class, "createReceiver", new Object[]{nyPort});
        vm4.invoke(WANTestBase.class, "createCache", new Object[]{lnPort});
        vm5.invoke(WANTestBase.class, "createCache", new Object[]{lnPort});
        vm6.invoke(WANTestBase.class, "createCache", new Object[]{lnPort});
        vm7.invoke(WANTestBase.class, "createCache", new Object[]{lnPort});
        vm4.invoke(WANTestBase.class, "createSender", new Object[]{"ln", 2, false, 100, 500, false, false, null, true});
        vm5.invoke(WANTestBase.class, "createSender", new Object[]{"ln", 2, false, 100, 500, false, false, null, true});
        vm2.invoke(WANTestBase.class, "createReplicatedRegion", new Object[]{testName + "_RR_1", null, this.isOffHeap()});
        vm3.invoke(WANTestBase.class, "createReplicatedRegion", new Object[]{testName + "_RR_1", null, this.isOffHeap()});
        vm4.invoke(WANTestBase.class, "startSender", new Object[]{"ln"});
        vm5.invoke(WANTestBase.class, "startSender", new Object[]{"ln"});
        vm4.invoke(WANTestBase.class, "createReplicatedRegion", new Object[]{testName + "_RR_1", "ln", this.isOffHeap()});
        vm5.invoke(WANTestBase.class, "createReplicatedRegion", new Object[]{testName + "_RR_1", "ln", this.isOffHeap()});
        vm6.invoke(WANTestBase.class, "createReplicatedRegion", new Object[]{testName + "_RR_1", "ln", this.isOffHeap()});
        vm7.invoke(WANTestBase.class, "createReplicatedRegion", new Object[]{testName + "_RR_1", "ln", this.isOffHeap()});
        SerialWANPropogationDUnitTest.addExpectedException(BatchException70.class.getName());
        SerialWANPropogationDUnitTest.addExpectedException(ServerOperationException.class.getName());
        AsyncInvocation inv1 = vm4.invokeAsync(WANTestBase.class, "doPuts", new Object[]{testName + "_RR_1", 1000});
        vm2.invoke(WANTestBase.class, "destroyRegion", new Object[]{testName + "_RR_1"});
        try {
            inv1.join();
        }
        catch (InterruptedException e) {
            e.printStackTrace();
            SerialWANPropogationDUnitTest.fail();
        }
        vm4.invoke(WANTestBase.class, "validateRegionSize", new Object[]{testName + "_RR_1", 1000});
        vm4.invoke(WANTestBase.class, "verifyRegionQueueNotEmpty", new Object[]{"ln"});
    }

    public void testReplicatedSerialPropagationWithRemoteRegionDestroy2() throws Exception {
        Integer lnPort = (Integer)vm0.invoke(WANTestBase.class, "createFirstLocatorWithDSId", new Object[]{1});
        Integer nyPort = (Integer)vm1.invoke(WANTestBase.class, "createFirstRemoteLocator", new Object[]{2, lnPort});
        vm2.invoke(WANTestBase.class, "createReceiver", new Object[]{nyPort});
        vm3.invoke(WANTestBase.class, "createReceiver", new Object[]{nyPort});
        vm4.invoke(WANTestBase.class, "createCache", new Object[]{lnPort});
        vm5.invoke(WANTestBase.class, "createCache", new Object[]{lnPort});
        vm6.invoke(WANTestBase.class, "createCache", new Object[]{lnPort});
        vm7.invoke(WANTestBase.class, "createCache", new Object[]{lnPort});
        vm4.invoke(WANTestBase.class, "createSender", new Object[]{"ln", 2, false, 100, 200, false, false, null, true});
        vm5.invoke(WANTestBase.class, "createSender", new Object[]{"ln", 2, false, 100, 200, false, false, null, true});
        vm2.invoke(WANTestBase.class, "createReplicatedRegion", new Object[]{testName + "_RR_1", null, this.isOffHeap()});
        vm3.invoke(WANTestBase.class, "createReplicatedRegion", new Object[]{testName + "_RR_1", null, this.isOffHeap()});
        vm2.invoke(WANTestBase.class, "createReplicatedRegion", new Object[]{testName + "_RR_2", null, this.isOffHeap()});
        vm3.invoke(WANTestBase.class, "createReplicatedRegion", new Object[]{testName + "_RR_2", null, this.isOffHeap()});
        vm4.invoke(WANTestBase.class, "startSender", new Object[]{"ln"});
        vm5.invoke(WANTestBase.class, "startSender", new Object[]{"ln"});
        vm4.invoke(WANTestBase.class, "createReplicatedRegion", new Object[]{testName + "_RR_1", "ln", this.isOffHeap()});
        vm5.invoke(WANTestBase.class, "createReplicatedRegion", new Object[]{testName + "_RR_1", "ln", this.isOffHeap()});
        vm6.invoke(WANTestBase.class, "createReplicatedRegion", new Object[]{testName + "_RR_1", "ln", this.isOffHeap()});
        vm7.invoke(WANTestBase.class, "createReplicatedRegion", new Object[]{testName + "_RR_1", "ln", this.isOffHeap()});
        vm4.invoke(WANTestBase.class, "createReplicatedRegion", new Object[]{testName + "_RR_2", "ln", this.isOffHeap()});
        vm5.invoke(WANTestBase.class, "createReplicatedRegion", new Object[]{testName + "_RR_2", "ln", this.isOffHeap()});
        vm6.invoke(WANTestBase.class, "createReplicatedRegion", new Object[]{testName + "_RR_2", "ln", this.isOffHeap()});
        vm7.invoke(WANTestBase.class, "createReplicatedRegion", new Object[]{testName + "_RR_2", "ln", this.isOffHeap()});
        vm2.invoke(WANTestBase.class, "destroyRegion", new Object[]{testName + "_RR_2"});
        SerialWANPropogationDUnitTest.addExpectedException(BatchException70.class.getName());
        SerialWANPropogationDUnitTest.addExpectedException(ServerOperationException.class.getName());
        vm4.invoke(WANTestBase.class, "doPuts", new Object[]{testName + "_RR_2", 1000});
        AsyncInvocation inv1 = vm4.invokeAsync(WANTestBase.class, "doPuts", new Object[]{testName + "_RR_1", 1000});
        try {
            inv1.join();
        }
        catch (InterruptedException e) {
            e.printStackTrace();
            SerialWANPropogationDUnitTest.fail();
        }
        vm2.invoke(WANTestBase.class, "validateRegionSize", new Object[]{testName + "_RR_1", 1000});
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testReplicatedSerialPropagationWithRemoteRegionDestroy3() throws Exception {
        Integer lnPort = (Integer)vm0.invoke(WANTestBase.class, "createFirstLocatorWithDSId", new Object[]{1});
        Integer nyPort = (Integer)vm1.invoke(WANTestBase.class, "createFirstRemoteLocator", new Object[]{2, lnPort});
        vm2.invoke(WANTestBase.class, "createReceiver", new Object[]{nyPort});
        vm3.invoke(WANTestBase.class, "createReceiver", new Object[]{nyPort});
        vm4.invoke(WANTestBase.class, "createCache", new Object[]{lnPort});
        vm5.invoke(WANTestBase.class, "createCache", new Object[]{lnPort});
        vm6.invoke(WANTestBase.class, "createCache", new Object[]{lnPort});
        vm7.invoke(WANTestBase.class, "createCache", new Object[]{lnPort});
        vm4.invoke(WANTestBase.class, "createSender", new Object[]{"ln", 2, false, 100, 200, false, false, null, true});
        vm5.invoke(WANTestBase.class, "createSender", new Object[]{"ln", 2, false, 100, 200, false, false, null, true});
        vm2.invoke(WANTestBase.class, "createReplicatedRegion", new Object[]{testName + "_RR_1", null, this.isOffHeap()});
        vm3.invoke(WANTestBase.class, "createReplicatedRegion", new Object[]{testName + "_RR_1", null, this.isOffHeap()});
        vm2.invoke(WANTestBase.class, "createReplicatedRegion", new Object[]{testName + "_RR_2", null, this.isOffHeap()});
        vm3.invoke(WANTestBase.class, "createReplicatedRegion", new Object[]{testName + "_RR_2", null, this.isOffHeap()});
        vm4.invoke(WANTestBase.class, "setRemoveFromQueueOnException", new Object[]{"ln", true});
        vm5.invoke(WANTestBase.class, "setRemoveFromQueueOnException", new Object[]{"ln", true});
        vm4.invoke(WANTestBase.class, "startSender", new Object[]{"ln"});
        vm5.invoke(WANTestBase.class, "startSender", new Object[]{"ln"});
        vm4.invoke(WANTestBase.class, "createReplicatedRegion", new Object[]{testName + "_RR_1", "ln", this.isOffHeap()});
        vm5.invoke(WANTestBase.class, "createReplicatedRegion", new Object[]{testName + "_RR_1", "ln", this.isOffHeap()});
        vm6.invoke(WANTestBase.class, "createReplicatedRegion", new Object[]{testName + "_RR_1", "ln", this.isOffHeap()});
        vm7.invoke(WANTestBase.class, "createReplicatedRegion", new Object[]{testName + "_RR_1", "ln", this.isOffHeap()});
        vm4.invoke(WANTestBase.class, "createReplicatedRegion", new Object[]{testName + "_RR_2", "ln", this.isOffHeap()});
        vm5.invoke(WANTestBase.class, "createReplicatedRegion", new Object[]{testName + "_RR_2", "ln", this.isOffHeap()});
        vm6.invoke(WANTestBase.class, "createReplicatedRegion", new Object[]{testName + "_RR_2", "ln", this.isOffHeap()});
        vm7.invoke(WANTestBase.class, "createReplicatedRegion", new Object[]{testName + "_RR_2", "ln", this.isOffHeap()});
        SerialWANPropogationDUnitTest.addExpectedException(BatchException70.class.getName());
        SerialWANPropogationDUnitTest.addExpectedException(ServerOperationException.class.getName());
        AsyncInvocation inv1 = vm4.invokeAsync(WANTestBase.class, "doPuts", new Object[]{testName + "_RR_1", 1000});
        AsyncInvocation inv2 = vm4.invokeAsync(WANTestBase.class, "doPuts", new Object[]{testName + "_RR_2", 1000});
        vm2.invoke(WANTestBase.class, "destroyRegion", new Object[]{testName + "_RR_2"});
        try {
            inv1.join();
            inv2.join();
        }
        catch (InterruptedException e) {
            e.printStackTrace();
            SerialWANPropogationDUnitTest.fail();
        }
        try {
            vm2.invoke(WANTestBase.class, "validateRegionSize", new Object[]{testName + "_RR_1", 1000});
        }
        catch (Throwable throwable) {
            System.setProperty("gemfire.GatewaySender.REMOVE_FROM_QUEUE_ON_EXCEPTION", "False");
            vm4.invoke(new CacheSerializableRunnable("UnSetting system property "){

                @Override
                public void run2() throws CacheException {
                    System.setProperty("gemfire.GatewaySender.REMOVE_FROM_QUEUE_ON_EXCEPTION", "False");
                }
            });
            vm5.invoke(new CacheSerializableRunnable("UnSetting system property "){

                @Override
                public void run2() throws CacheException {
                    System.setProperty("gemfire.GatewaySender.REMOVE_FROM_QUEUE_ON_EXCEPTION", "False");
                }
            });
            throw throwable;
        }
        System.setProperty("gemfire.GatewaySender.REMOVE_FROM_QUEUE_ON_EXCEPTION", "False");
        vm4.invoke(new /* invalid duplicate definition of identical inner class */);
        vm5.invoke(new /* invalid duplicate definition of identical inner class */);
    }

    public void testReplicatedSerialPropagationWithRemoteReceiverStopped() throws Exception {
        Integer lnPort = (Integer)vm0.invoke(WANTestBase.class, "createFirstLocatorWithDSId", new Object[]{1});
        Integer nyPort = (Integer)vm1.invoke(WANTestBase.class, "createFirstRemoteLocator", new Object[]{2, lnPort});
        vm2.invoke(WANTestBase.class, "createReceiver", new Object[]{nyPort});
        vm4.invoke(WANTestBase.class, "createCache", new Object[]{lnPort});
        vm5.invoke(WANTestBase.class, "createCache", new Object[]{lnPort});
        vm6.invoke(WANTestBase.class, "createCache", new Object[]{lnPort});
        vm7.invoke(WANTestBase.class, "createCache", new Object[]{lnPort});
        vm4.invoke(WANTestBase.class, "createSender", new Object[]{"ln", 2, false, 100, 350, false, false, null, true});
        vm5.invoke(WANTestBase.class, "createSender", new Object[]{"ln", 2, false, 100, 350, false, false, null, true});
        vm2.invoke(WANTestBase.class, "createReplicatedRegion", new Object[]{testName + "_RR_1", null, this.isOffHeap()});
        vm4.invoke(WANTestBase.class, "startSender", new Object[]{"ln"});
        vm5.invoke(WANTestBase.class, "startSender", new Object[]{"ln"});
        vm4.invoke(WANTestBase.class, "createReplicatedRegion", new Object[]{testName + "_RR_1", "ln", this.isOffHeap()});
        vm5.invoke(WANTestBase.class, "createReplicatedRegion", new Object[]{testName + "_RR_1", "ln", this.isOffHeap()});
        vm6.invoke(WANTestBase.class, "createReplicatedRegion", new Object[]{testName + "_RR_1", "ln", this.isOffHeap()});
        vm7.invoke(WANTestBase.class, "createReplicatedRegion", new Object[]{testName + "_RR_1", "ln", this.isOffHeap()});
        AsyncInvocation inv1 = vm4.invokeAsync(WANTestBase.class, "doPuts", new Object[]{testName + "_RR_1", 500});
        vm2.invoke(WANTestBase.class, "closeCache");
        try {
            inv1.join();
        }
        catch (InterruptedException e) {
            e.printStackTrace();
            SerialWANPropogationDUnitTest.fail();
        }
        vm4.invoke(WANTestBase.class, "validateRegionSize", new Object[]{testName + "_RR_1", 500});
        vm4.invoke(WANTestBase.class, "verifyRegionQueueNotEmpty", new Object[]{"ln"});
    }

    public void testReplicatedSerialPropagationWithRemoteReceiverRestarted() throws Exception {
        Integer lnPort = (Integer)vm0.invoke(WANTestBase.class, "createFirstLocatorWithDSId", new Object[]{1});
        Integer nyPort = (Integer)vm1.invoke(WANTestBase.class, "createFirstRemoteLocator", new Object[]{2, lnPort});
        vm2.invoke(WANTestBase.class, "createReceiver", new Object[]{nyPort});
        vm4.invoke(WANTestBase.class, "createCache", new Object[]{lnPort});
        vm5.invoke(WANTestBase.class, "createCache", new Object[]{lnPort});
        vm4.invoke(WANTestBase.class, "createSender", new Object[]{"ln", 2, false, 100, 350, false, false, null, true});
        vm2.invoke(WANTestBase.class, "createReplicatedRegion", new Object[]{testName + "_RR_1", null, this.isOffHeap()});
        vm4.invoke(WANTestBase.class, "startSender", new Object[]{"ln"});
        vm4.invoke(WANTestBase.class, "createReplicatedRegion", new Object[]{testName + "_RR_1", "ln", this.isOffHeap()});
        vm4.invoke(WANTestBase.class, "setRemoveFromQueueOnException", new Object[]{"ln", false});
        AsyncInvocation inv1 = vm4.invokeAsync(WANTestBase.class, "doPuts", new Object[]{testName + "_RR_1", 8000});
        SerialWANPropogationDUnitTest.pause(2000);
        vm2.invoke(WANTestBase.class, "closeCache");
        try {
            inv1.join();
        }
        catch (InterruptedException e) {
            e.printStackTrace();
            SerialWANPropogationDUnitTest.fail();
        }
        vm4.invoke(WANTestBase.class, "doPuts", new Object[]{testName + "_RR_1", 1000});
        vm4.invoke(WANTestBase.class, "validateRegionSize", new Object[]{testName + "_RR_1", 8000});
        vm2.invoke(WANTestBase.class, "createReceiver", new Object[]{nyPort});
        vm2.invoke(WANTestBase.class, "createReplicatedRegion", new Object[]{testName + "_RR_1", null, this.isOffHeap()});
        vm4.invoke(WANTestBase.class, "validateQueueContents", new Object[]{"ln", 0});
        vm2.invoke(WANTestBase.class, "checkMinimumGatewayReceiverStats", new Object[]{1, 1});
    }

    public void testReplicatedSerialPropagationWithRemoteReceiverRestarted_SenderReceiverPersistent() throws Exception {
        Integer lnPort = (Integer)vm0.invoke(WANTestBase.class, "createFirstLocatorWithDSId", new Object[]{1});
        Integer nyPort = (Integer)vm1.invoke(WANTestBase.class, "createFirstRemoteLocator", new Object[]{2, lnPort});
        vm2.invoke(WANTestBase.class, "createReceiver", new Object[]{nyPort});
        vm4.invoke(WANTestBase.class, "createCache", new Object[]{lnPort});
        vm5.invoke(WANTestBase.class, "createCache", new Object[]{lnPort});
        vm4.invoke(WANTestBase.class, "createSender", new Object[]{"ln", 2, false, 100, 350, false, true, null, true});
        vm5.invoke(WANTestBase.class, "createSender", new Object[]{"ln", 2, false, 100, 350, false, true, null, true});
        vm2.invoke(WANTestBase.class, "createPersistentReplicatedRegion", new Object[]{testName + "_RR_1", null, this.isOffHeap()});
        vm4.invoke(WANTestBase.class, "startSender", new Object[]{"ln"});
        vm5.invoke(WANTestBase.class, "startSender", new Object[]{"ln"});
        vm4.invoke(WANTestBase.class, "createReplicatedRegion", new Object[]{testName + "_RR_1", "ln", this.isOffHeap()});
        vm4.invoke(WANTestBase.class, "setRemoveFromQueueOnException", new Object[]{"ln", false});
        AsyncInvocation inv1 = vm4.invokeAsync(WANTestBase.class, "doPuts", new Object[]{testName + "_RR_1", 8000});
        SerialWANPropogationDUnitTest.pause(2000);
        vm2.invoke(WANTestBase.class, "closeCache");
        try {
            inv1.join();
        }
        catch (InterruptedException e) {
            e.printStackTrace();
            SerialWANPropogationDUnitTest.fail();
        }
        vm4.invoke(WANTestBase.class, "validateRegionSize", new Object[]{testName + "_RR_1", 8000});
        vm4.invoke(WANTestBase.class, "verifyRegionQueueNotEmpty", new Object[]{"ln"});
        vm2.invoke(WANTestBase.class, "createReceiver", new Object[]{nyPort});
        vm2.invoke(WANTestBase.class, "createPersistentReplicatedRegion", new Object[]{testName + "_RR_1", null, this.isOffHeap()});
        vm4.invoke(WANTestBase.class, "validateQueueContents", new Object[]{"ln", 0});
        vm2.invoke(WANTestBase.class, "checkMinimumGatewayReceiverStats", new Object[]{1, 1});
        vm2.invoke(WANTestBase.class, "validateRegionSize", new Object[]{testName + "_RR_1", 8000});
    }

    public void testReplicatedSerialPropagationWithRemoteSiteBouncedBack_ReceiverPersistent() throws Exception {
        Integer lnPort = (Integer)vm0.invoke(WANTestBase.class, "createFirstLocatorWithDSId", new Object[]{1});
        Integer nyPort = (Integer)vm1.invoke(WANTestBase.class, "createFirstRemoteLocator", new Object[]{2, lnPort});
        vm2.invoke(WANTestBase.class, "createReceiver", new Object[]{nyPort});
        vm4.invoke(WANTestBase.class, "createCache", new Object[]{lnPort});
        vm5.invoke(WANTestBase.class, "createCache", new Object[]{lnPort});
        vm4.invoke(WANTestBase.class, "createSender", new Object[]{"ln", 2, false, 100, 350, false, false, null, true});
        vm2.invoke(WANTestBase.class, "createPersistentReplicatedRegion", new Object[]{testName + "_RR_1", null, this.isOffHeap()});
        vm4.invoke(WANTestBase.class, "startSender", new Object[]{"ln"});
        vm4.invoke(WANTestBase.class, "createReplicatedRegion", new Object[]{testName + "_RR_1", "ln", this.isOffHeap()});
        vm4.invoke(WANTestBase.class, "setRemoveFromQueueOnException", new Object[]{"ln", false});
        AsyncInvocation inv1 = vm4.invokeAsync(WANTestBase.class, "doPuts", new Object[]{testName + "_RR_1", 8000});
        SerialWANPropogationDUnitTest.pause(2000);
        vm1.invoke(WANTestBase.class, "shutdownLocator");
        vm2.invoke(WANTestBase.class, "closeCache");
        try {
            inv1.join();
        }
        catch (InterruptedException e) {
            e.printStackTrace();
            SerialWANPropogationDUnitTest.fail();
        }
        vm4.invoke(WANTestBase.class, "doPuts", new Object[]{testName + "_RR_1", 1000});
        vm4.invoke(WANTestBase.class, "validateRegionSize", new Object[]{testName + "_RR_1", 8000});
        vm4.invoke(WANTestBase.class, "verifyRegionQueueNotEmpty", new Object[]{"ln"});
        vm1.invoke(WANTestBase.class, "bringBackLocatorOnOldPort", new Object[]{2, lnPort, nyPort});
        vm2.invoke(WANTestBase.class, "createReceiver", new Object[]{nyPort});
        vm2.invoke(WANTestBase.class, "createPersistentReplicatedRegion", new Object[]{testName + "_RR_1", null, this.isOffHeap()});
        vm4.invoke(WANTestBase.class, "validateQueueContents", new Object[]{"ln", 0});
        vm2.invoke(WANTestBase.class, "validateRegionSize", new Object[]{testName + "_RR_1", 8000});
        vm2.invoke(WANTestBase.class, "checkMinimumGatewayReceiverStats", new Object[]{1, 1});
    }

    public void testReplicatedSerialPropagationWithRemoteSiteBouncedBackWithMultipleRemoteLocators() throws Exception {
        Integer lnPort = (Integer)vm0.invoke(WANTestBase.class, "createFirstLocatorWithDSId", new Object[]{1});
        Integer nyPort1 = (Integer)vm1.invoke(WANTestBase.class, "createFirstRemoteLocator", new Object[]{2, lnPort});
        Integer nyPort2 = (Integer)vm3.invoke(WANTestBase.class, "createSecondRemoteLocator", new Object[]{2, nyPort1, lnPort});
        vm2.invoke(WANTestBase.class, "createReceiver", new Object[]{nyPort1});
        vm4.invoke(WANTestBase.class, "createCache", new Object[]{lnPort});
        vm5.invoke(WANTestBase.class, "createCache", new Object[]{lnPort});
        vm4.invoke(WANTestBase.class, "createSender", new Object[]{"ln", 2, false, 100, 350, false, false, null, true});
        vm2.invoke(WANTestBase.class, "createReplicatedRegion", new Object[]{testName + "_RR_1", null, this.isOffHeap()});
        vm4.invoke(WANTestBase.class, "startSender", new Object[]{"ln"});
        vm4.invoke(WANTestBase.class, "createReplicatedRegion", new Object[]{testName + "_RR_1", "ln", this.isOffHeap()});
        vm4.invoke(WANTestBase.class, "setRemoveFromQueueOnException", new Object[]{"ln", false});
        AsyncInvocation inv1 = vm4.invokeAsync(WANTestBase.class, "doPuts", new Object[]{testName + "_RR_1", 8000});
        SerialWANPropogationDUnitTest.pause(2000);
        vm1.invoke(WANTestBase.class, "shutdownLocator");
        vm2.invoke(WANTestBase.class, "closeCache");
        try {
            inv1.join();
        }
        catch (InterruptedException e) {
            e.printStackTrace();
            SerialWANPropogationDUnitTest.fail();
        }
        vm4.invoke(WANTestBase.class, "doPuts", new Object[]{testName + "_RR_1", 1000});
        vm4.invoke(WANTestBase.class, "validateRegionSize", new Object[]{testName + "_RR_1", 8000});
        vm4.invoke(WANTestBase.class, "verifyRegionQueueNotEmpty", new Object[]{"ln"});
        vm6.invoke(WANTestBase.class, "createReceiver", new Object[]{nyPort2});
        vm6.invoke(WANTestBase.class, "createReplicatedRegion", new Object[]{testName + "_RR_1", null, this.isOffHeap()});
        vm4.invoke(WANTestBase.class, "validateQueueContents", new Object[]{"ln", 0});
        vm6.invoke(WANTestBase.class, "checkMinimumGatewayReceiverStats", new Object[]{1, 1});
    }

    public void Bug47604_testReplicatedSerialPropagationWithRemoteReceiverRestartedOnOtherNode() throws Exception {
        Integer lnPort = (Integer)vm0.invoke(WANTestBase.class, "createFirstLocatorWithDSId", new Object[]{1});
        Integer nyPort = (Integer)vm1.invoke(WANTestBase.class, "createFirstRemoteLocator", new Object[]{2, lnPort});
        vm2.invoke(WANTestBase.class, "createReceiver", new Object[]{nyPort});
        vm3.invoke(WANTestBase.class, "createCache", new Object[]{nyPort});
        vm4.invoke(WANTestBase.class, "createCache", new Object[]{lnPort});
        vm5.invoke(WANTestBase.class, "createCache", new Object[]{lnPort});
        vm4.invoke(WANTestBase.class, "createSender", new Object[]{"ln", 2, false, 100, 350, false, false, null, true});
        vm5.invoke(WANTestBase.class, "createSender", new Object[]{"ln", 2, false, 100, 350, false, false, null, true});
        vm2.invoke(WANTestBase.class, "createPersistentReplicatedRegion", new Object[]{testName + "_RR_1", null, this.isOffHeap()});
        vm3.invoke(WANTestBase.class, "createPersistentReplicatedRegion", new Object[]{testName + "_RR_1", null, this.isOffHeap()});
        vm4.invoke(WANTestBase.class, "startSender", new Object[]{"ln"});
        vm4.invoke(WANTestBase.class, "createReplicatedRegion", new Object[]{testName + "_RR_1", "ln", this.isOffHeap()});
        AsyncInvocation inv1 = vm4.invokeAsync(WANTestBase.class, "doPuts", new Object[]{testName + "_RR_1", 8000});
        SerialWANPropogationDUnitTest.pause(2000);
        vm2.invoke(WANTestBase.class, "closeCache");
        vm3.invoke(WANTestBase.class, "closeCache");
        try {
            inv1.join();
        }
        catch (InterruptedException e) {
            e.printStackTrace();
            SerialWANPropogationDUnitTest.fail();
        }
        vm4.invoke(WANTestBase.class, "validateRegionSize", new Object[]{testName + "_RR_1", 8000});
        vm4.invoke(WANTestBase.class, "verifyRegionQueueNotEmpty", new Object[]{"ln"});
        vm3.invoke(WANTestBase.class, "createReceiver", new Object[]{nyPort});
        vm3.invoke(WANTestBase.class, "createPersistentReplicatedRegion", new Object[]{testName + "_RR_1", null, this.isOffHeap()});
        vm4.invoke(WANTestBase.class, "validateQueueContents", new Object[]{"ln", 0});
        vm3.invoke(WANTestBase.class, "checkMinimumGatewayReceiverStats", new Object[]{1, 1});
        vm3.invoke(WANTestBase.class, "validateRegionSize", new Object[]{testName + "_RR_1", 8000});
    }

    public void testReplicatedSerialPropagationToTwoWanSites() throws Exception {
        Integer lnPort = SerialWANPropogationDUnitTest.createFirstLocatorWithDSId(1);
        Integer nyPort = (Integer)vm0.invoke(WANTestBase.class, "createFirstRemoteLocator", new Object[]{2, lnPort});
        Integer tkPort = (Integer)vm1.invoke(WANTestBase.class, "createFirstRemoteLocator", new Object[]{3, lnPort});
        vm2.invoke(WANTestBase.class, "createReceiver", new Object[]{nyPort});
        vm3.invoke(WANTestBase.class, "createReceiver", new Object[]{tkPort});
        vm4.invoke(WANTestBase.class, "createCache", new Object[]{lnPort});
        vm5.invoke(WANTestBase.class, "createCache", new Object[]{lnPort});
        vm6.invoke(WANTestBase.class, "createCache", new Object[]{lnPort});
        vm7.invoke(WANTestBase.class, "createCache", new Object[]{lnPort});
        vm4.invoke(WANTestBase.class, "createSender", new Object[]{"lnSerial1", 2, false, 100, 10, false, false, null, true});
        vm5.invoke(WANTestBase.class, "createSender", new Object[]{"lnSerial1", 2, false, 100, 10, false, false, null, true});
        vm4.invoke(WANTestBase.class, "createSender", new Object[]{"lnSerial2", 3, false, 100, 10, false, false, null, true});
        vm5.invoke(WANTestBase.class, "createSender", new Object[]{"lnSerial2", 3, false, 100, 10, false, false, null, true});
        vm2.invoke(WANTestBase.class, "createReplicatedRegion", new Object[]{testName + "_RR", null, this.isOffHeap()});
        vm3.invoke(WANTestBase.class, "createReplicatedRegion", new Object[]{testName + "_RR", null, this.isOffHeap()});
        vm4.invoke(WANTestBase.class, "startSender", new Object[]{"lnSerial1"});
        vm5.invoke(WANTestBase.class, "startSender", new Object[]{"lnSerial1"});
        vm4.invoke(WANTestBase.class, "startSender", new Object[]{"lnSerial2"});
        vm5.invoke(WANTestBase.class, "startSender", new Object[]{"lnSerial2"});
        vm4.invoke(WANTestBase.class, "createReplicatedRegion", new Object[]{testName + "_RR", "lnSerial1,lnSerial2", this.isOffHeap()});
        vm5.invoke(WANTestBase.class, "createReplicatedRegion", new Object[]{testName + "_RR", "lnSerial1,lnSerial2", this.isOffHeap()});
        vm6.invoke(WANTestBase.class, "createReplicatedRegion", new Object[]{testName + "_RR", "lnSerial1,lnSerial2", this.isOffHeap()});
        vm7.invoke(WANTestBase.class, "createReplicatedRegion", new Object[]{testName + "_RR", "lnSerial1,lnSerial2", this.isOffHeap()});
        vm4.invoke(WANTestBase.class, "doPuts", new Object[]{testName + "_RR", 1000});
        vm2.invoke(WANTestBase.class, "validateRegionSize", new Object[]{testName + "_RR", 1000});
        vm3.invoke(WANTestBase.class, "validateRegionSize", new Object[]{testName + "_RR", 1000});
    }

    public void testReplicatedSerialPropagationHA() throws Exception {
        Integer lnPort = (Integer)vm0.invoke(WANTestBase.class, "createFirstLocatorWithDSId", new Object[]{1});
        Integer nyPort = (Integer)vm1.invoke(WANTestBase.class, "createFirstRemoteLocator", new Object[]{2, lnPort});
        vm2.invoke(WANTestBase.class, "createReceiver", new Object[]{nyPort});
        vm3.invoke(WANTestBase.class, "createReceiver", new Object[]{nyPort});
        vm4.invoke(WANTestBase.class, "createCache", new Object[]{lnPort});
        vm5.invoke(WANTestBase.class, "createCache", new Object[]{lnPort});
        vm6.invoke(WANTestBase.class, "createCache", new Object[]{lnPort});
        vm7.invoke(WANTestBase.class, "createCache", new Object[]{lnPort});
        vm4.invoke(WANTestBase.class, "createSender", new Object[]{"ln", 2, false, 100, 10, false, false, null, true});
        vm5.invoke(WANTestBase.class, "createSender", new Object[]{"ln", 2, false, 100, 10, false, false, null, true});
        vm2.invoke(WANTestBase.class, "createReplicatedRegion", new Object[]{testName + "_RR", null, this.isOffHeap()});
        vm3.invoke(WANTestBase.class, "createReplicatedRegion", new Object[]{testName + "_RR", null, this.isOffHeap()});
        vm4.invoke(WANTestBase.class, "startSender", new Object[]{"ln"});
        vm5.invoke(WANTestBase.class, "startSender", new Object[]{"ln"});
        vm4.invoke(WANTestBase.class, "createReplicatedRegion", new Object[]{testName + "_RR", "ln", this.isOffHeap()});
        vm5.invoke(WANTestBase.class, "createReplicatedRegion", new Object[]{testName + "_RR", "ln", this.isOffHeap()});
        vm6.invoke(WANTestBase.class, "createReplicatedRegion", new Object[]{testName + "_RR", "ln", this.isOffHeap()});
        vm7.invoke(WANTestBase.class, "createReplicatedRegion", new Object[]{testName + "_RR", "ln", this.isOffHeap()});
        AsyncInvocation inv1 = vm5.invokeAsync(WANTestBase.class, "doPuts", new Object[]{testName + "_RR", 10000});
        SerialWANPropogationDUnitTest.pause(2000);
        AsyncInvocation inv2 = vm4.invokeAsync(WANTestBase.class, "killSender");
        inv1.join();
        inv2.join();
        vm2.invoke(WANTestBase.class, "validateRegionSize", new Object[]{testName + "_RR", 10000});
        vm3.invoke(WANTestBase.class, "validateRegionSize", new Object[]{testName + "_RR", 10000});
    }

    public void testReplicatedSerialPropagationHA_ReceiverAffinity() throws Exception {
        Integer lnPort = (Integer)vm0.invoke(WANTestBase.class, "createFirstLocatorWithDSId", new Object[]{1});
        Integer nyPort = (Integer)vm1.invoke(WANTestBase.class, "createFirstRemoteLocator", new Object[]{2, lnPort});
        vm2.invoke(WANTestBase.class, "createReceiver", new Object[]{nyPort});
        vm3.invoke(WANTestBase.class, "createReceiver", new Object[]{nyPort});
        vm6.invoke(WANTestBase.class, "createReceiver", new Object[]{nyPort});
        vm7.invoke(WANTestBase.class, "createReceiver", new Object[]{nyPort});
        SerialWANPropogationDUnitTest.getLogWriter().info("Started receivers on remote site");
        vm4.invoke(WANTestBase.class, "createCache", new Object[]{lnPort});
        vm5.invoke(WANTestBase.class, "createCache", new Object[]{lnPort});
        vm4.invoke(WANTestBase.class, "createSender", new Object[]{"ln", 2, false, 100, 10, false, false, null, true});
        vm5.invoke(WANTestBase.class, "createSender", new Object[]{"ln", 2, false, 100, 10, false, false, null, true});
        vm2.invoke(WANTestBase.class, "createReplicatedRegion", new Object[]{testName + "_RR", null, this.isOffHeap()});
        vm3.invoke(WANTestBase.class, "createReplicatedRegion", new Object[]{testName + "_RR", null, this.isOffHeap()});
        vm6.invoke(WANTestBase.class, "createReplicatedRegion", new Object[]{testName + "_RR", null, this.isOffHeap()});
        vm7.invoke(WANTestBase.class, "createReplicatedRegion", new Object[]{testName + "_RR", null, this.isOffHeap()});
        vm4.invoke(WANTestBase.class, "startSender", new Object[]{"ln"});
        vm5.invoke(WANTestBase.class, "startSender", new Object[]{"ln"});
        SerialWANPropogationDUnitTest.getLogWriter().info("Started senders on local site");
        vm4.invoke(WANTestBase.class, "createReplicatedRegion", new Object[]{testName + "_RR", "ln", this.isOffHeap()});
        vm5.invoke(WANTestBase.class, "createReplicatedRegion", new Object[]{testName + "_RR", "ln", this.isOffHeap()});
        AsyncInvocation inv1 = vm5.invokeAsync(WANTestBase.class, "doPuts", new Object[]{testName + "_RR", 10000});
        SerialWANPropogationDUnitTest.getLogWriter().info("Started async puts on local site");
        SerialWANPropogationDUnitTest.pause(1000);
        Map oldConnectionInfo = (Map)vm4.invoke(WANTestBase.class, "getSenderToReceiverConnectionInfo", new Object[]{"ln"});
        SerialWANPropogationDUnitTest.assertNotNull((Object)oldConnectionInfo);
        String oldServerHost = (String)oldConnectionInfo.get("serverHost");
        int oldServerPort = (Integer)oldConnectionInfo.get("serverPort");
        SerialWANPropogationDUnitTest.getLogWriter().info("Got sender to receiver connection information");
        AsyncInvocation inv2 = vm4.invokeAsync(WANTestBase.class, "killSender");
        inv2.join();
        SerialWANPropogationDUnitTest.getLogWriter().info("Killed primary sender on local site");
        SerialWANPropogationDUnitTest.pause(5000);
        Map newConnectionInfo = (Map)vm5.invoke(WANTestBase.class, "getSenderToReceiverConnectionInfo", new Object[]{"ln"});
        SerialWANPropogationDUnitTest.assertNotNull((Object)newConnectionInfo);
        String newServerHost = (String)newConnectionInfo.get("serverHost");
        int newServerPort = (Integer)newConnectionInfo.get("serverPort");
        SerialWANPropogationDUnitTest.getLogWriter().info("Got new sender to receiver connection information");
        SerialWANPropogationDUnitTest.assertEquals((String)oldServerHost, (String)newServerHost);
        SerialWANPropogationDUnitTest.assertEquals((int)oldServerPort, (int)newServerPort);
        SerialWANPropogationDUnitTest.getLogWriter().info("Matched the new connection info with old connection info. Receiver affinity verified.");
        vm2.invoke(WANTestBase.class, "validateRegionSize", new Object[]{testName + "_RR", 10000});
        vm3.invoke(WANTestBase.class, "validateRegionSize", new Object[]{testName + "_RR", 10000});
    }

    public void testReplicatedSerialPropagationHA_ReceiverAffinityScenario2() throws Exception {
        Integer lnPort = (Integer)vm0.invoke(WANTestBase.class, "createFirstLocatorWithDSId", new Object[]{1});
        Integer nyPort = (Integer)vm1.invoke(WANTestBase.class, "createFirstRemoteLocator", new Object[]{2, lnPort});
        vm2.invoke(WANTestBase.class, "createReceiver", new Object[]{nyPort});
        vm3.invoke(WANTestBase.class, "createReceiver", new Object[]{nyPort});
        vm6.invoke(WANTestBase.class, "createReceiver", new Object[]{nyPort});
        vm7.invoke(WANTestBase.class, "createReceiver", new Object[]{nyPort});
        SerialWANPropogationDUnitTest.getLogWriter().info("Started receivers on remote site");
        vm4.invoke(WANTestBase.class, "createCache", new Object[]{lnPort});
        vm5.invoke(WANTestBase.class, "createCache", new Object[]{lnPort});
        vm4.invoke(WANTestBase.class, "createSender", new Object[]{"ln", 2, false, 100, 10, false, false, null, true});
        vm5.invoke(WANTestBase.class, "createSender", new Object[]{"ln", 2, false, 100, 10, false, false, null, true});
        vm2.invoke(WANTestBase.class, "createReplicatedRegion", new Object[]{testName + "_RR", null, this.isOffHeap()});
        vm3.invoke(WANTestBase.class, "createReplicatedRegion", new Object[]{testName + "_RR", null, this.isOffHeap()});
        vm6.invoke(WANTestBase.class, "createReplicatedRegion", new Object[]{testName + "_RR", null, this.isOffHeap()});
        vm7.invoke(WANTestBase.class, "createReplicatedRegion", new Object[]{testName + "_RR", null, this.isOffHeap()});
        vm4.invoke(WANTestBase.class, "startSender", new Object[]{"ln"});
        vm5.invoke(WANTestBase.class, "startSender", new Object[]{"ln"});
        SerialWANPropogationDUnitTest.getLogWriter().info("Started senders on local site");
        vm4.invoke(WANTestBase.class, "createReplicatedRegion", new Object[]{testName + "_RR", "ln", this.isOffHeap()});
        vm5.invoke(WANTestBase.class, "createReplicatedRegion", new Object[]{testName + "_RR", "ln", this.isOffHeap()});
        AsyncInvocation inv1 = vm5.invokeAsync(WANTestBase.class, "doPuts", new Object[]{testName + "_RR", 10000});
        SerialWANPropogationDUnitTest.getLogWriter().info("Started async puts on local site");
        SerialWANPropogationDUnitTest.pause(1000);
        Map oldConnectionInfo = (Map)vm4.invoke(WANTestBase.class, "getSenderToReceiverConnectionInfo", new Object[]{"ln"});
        SerialWANPropogationDUnitTest.assertNotNull((Object)oldConnectionInfo);
        String oldServerHost = (String)oldConnectionInfo.get("serverHost");
        int oldServerPort = (Integer)oldConnectionInfo.get("serverPort");
        SerialWANPropogationDUnitTest.getLogWriter().info("Got sender to receiver connection information");
        AsyncInvocation inv2 = vm4.invokeAsync(WANTestBase.class, "killSender");
        inv2.join();
        SerialWANPropogationDUnitTest.getLogWriter().info("Killed vm4 (primary sender) on local site");
        vm5.invoke(WANTestBase.class, "waitForSenderToBecomePrimary", new Object[]{"ln"});
        SerialWANPropogationDUnitTest.getLogWriter().info("vm5 sender has now acquired primary status");
        SerialWANPropogationDUnitTest.pause(5000);
        SerialWANPropogationDUnitTest.getLogWriter().info("Rebuilding vm4....");
        vm4.invoke(WANTestBase.class, "createCache", new Object[]{lnPort});
        vm4.invoke(WANTestBase.class, "createSender", new Object[]{"ln", 2, false, 100, 10, false, false, null, true});
        vm4.invoke(WANTestBase.class, "startSender", new Object[]{"ln"});
        vm4.invoke(WANTestBase.class, "createReplicatedRegion", new Object[]{testName + "_RR", "ln", this.isOffHeap()});
        SerialWANPropogationDUnitTest.getLogWriter().info("Rebuilt vm4");
        inv1.join();
        SerialWANPropogationDUnitTest.getLogWriter().info("puts in vm5 are done");
        inv2 = vm5.invokeAsync(WANTestBase.class, "killSender");
        inv2.join();
        vm4.invoke(WANTestBase.class, "waitForSenderToBecomePrimary", new Object[]{"ln"});
        Map newConnectionInfo = (Map)vm4.invoke(WANTestBase.class, "getSenderToReceiverConnectionInfo", new Object[]{"ln"});
        SerialWANPropogationDUnitTest.assertNotNull((Object)newConnectionInfo);
        String newServerHost = (String)newConnectionInfo.get("serverHost");
        int newServerPort = (Integer)newConnectionInfo.get("serverPort");
        SerialWANPropogationDUnitTest.getLogWriter().info("Got new sender to receiver connection information");
        SerialWANPropogationDUnitTest.assertEquals((String)oldServerHost, (String)newServerHost);
        SerialWANPropogationDUnitTest.assertEquals((int)oldServerPort, (int)newServerPort);
        SerialWANPropogationDUnitTest.getLogWriter().info("Matched the new connection info with old connection info. Receiver affinity verified.");
        vm2.invoke(WANTestBase.class, "validateRegionSize", new Object[]{testName + "_RR", 10000});
        vm3.invoke(WANTestBase.class, "validateRegionSize", new Object[]{testName + "_RR", 10000});
    }

    public void testNormalRegionSerialPropagation() throws Exception {
        Integer lnPort = (Integer)vm0.invoke(WANTestBase.class, "createFirstLocatorWithDSId", new Object[]{1});
        Integer nyPort = (Integer)vm1.invoke(WANTestBase.class, "createFirstRemoteLocator", new Object[]{2, lnPort});
        vm2.invoke(WANTestBase.class, "createReceiver", new Object[]{nyPort});
        vm4.invoke(WANTestBase.class, "createCache", new Object[]{lnPort});
        vm5.invoke(WANTestBase.class, "createCache", new Object[]{lnPort});
        vm4.invoke(WANTestBase.class, "createSender", new Object[]{"ln", 2, false, 100, 10, false, false, null, true});
        vm5.invoke(WANTestBase.class, "createSender", new Object[]{"ln", 2, false, 100, 10, false, false, null, true});
        vm2.invoke(WANTestBase.class, "createReplicatedRegion", new Object[]{testName + "_RR", null, this.isOffHeap()});
        vm4.invoke(WANTestBase.class, "startSender", new Object[]{"ln"});
        SerialWANPropogationDUnitTest.pause(500);
        vm5.invoke(WANTestBase.class, "startSender", new Object[]{"ln"});
        vm4.invoke(WANTestBase.class, "createNormalRegion", new Object[]{testName + "_RR", "ln"});
        vm5.invoke(WANTestBase.class, "createNormalRegion", new Object[]{testName + "_RR", "ln"});
        vm5.invoke(WANTestBase.class, "doPuts", new Object[]{testName + "_RR", 1000});
        vm4.invoke(WANTestBase.class, "checkQueueStats", new Object[]{"ln", 0, 0, 0, 0});
        vm5.invoke(WANTestBase.class, "checkQueueStats", new Object[]{"ln", 0, 1000, 0, 0});
        vm5.invoke(WANTestBase.class, "validateRegionSize", new Object[]{testName + "_RR", 1000});
        vm4.invoke(WANTestBase.class, "validateRegionSize", new Object[]{testName + "_RR", 0});
        vm2.invoke(WANTestBase.class, "validateRegionSize", new Object[]{testName + "_RR", 0});
        vm2.invoke(WANTestBase.class, "checkGatewayReceiverStats", new Object[]{0, 0, 0});
    }
}

