/*
 * Decompiled with CFR 0.152.
 */
package com.gemstone.gemfire.internal.cache.wan.wancommand;

import com.gemstone.gemfire.distributed.DistributedMember;
import com.gemstone.gemfire.internal.cache.wan.wancommand.WANCommandTestBase;
import com.gemstone.gemfire.management.cli.Result;
import com.gemstone.gemfire.management.internal.cli.result.CommandResult;
import com.gemstone.gemfire.management.internal.cli.result.TabularResultData;
import dunit.DistributedTestCase;
import dunit.Host;
import dunit.VM;
import hydra.Log;
import java.util.List;
import java.util.Properties;

public class WanCommandGatewaySenderStartDUnitTest
extends WANCommandTestBase {
    private static final long serialVersionUID = 1L;

    public WanCommandGatewaySenderStartDUnitTest(String name) {
        super(name);
    }

    @Override
    public void setUp() throws Exception {
        super.setUp();
    }

    public void testStartGatewaySender_ErrorConditions() {
        VM puneLocator = Host.getLocator();
        int punePort = (Integer)puneLocator.invoke(WANCommandTestBase.class, "getLocatorPort");
        Properties props = new Properties();
        props.setProperty("mcast-port", "0");
        props.setProperty("locators", "localhost[" + punePort + "]");
        this.createDefaultSetup(props);
        Integer nyPort = (Integer)vm2.invoke(WANCommandTestBase.class, "createFirstRemoteLocator", new Object[]{2, punePort});
        vm3.invoke(WANCommandTestBase.class, "createCache", new Object[]{punePort});
        vm3.invoke(WANCommandTestBase.class, "createSender", new Object[]{"ln", 2, false, 100, 400, false, false, null, true});
        DistributedMember vm1Member = (DistributedMember)vm3.invoke(WANCommandTestBase.class, "getMember");
        String command = "start gateway-sender --id=ln --member=" + vm1Member.getId() + " --" + "group" + "=SenserGroup1";
        CommandResult cmdResult = this.executeCommandWithIgnoredExceptions(command);
        if (cmdResult != null) {
            String strCmdResult = this.commandResultToString(cmdResult);
            Log.getLogWriter().info("testStartGatewaySender stringResult : " + strCmdResult + ">>>>");
            WanCommandGatewaySenderStartDUnitTest.assertEquals((Object)Result.Status.ERROR, (Object)cmdResult.getStatus());
            WanCommandGatewaySenderStartDUnitTest.assertTrue((boolean)strCmdResult.contains("Please provide either \"member\" or \"group\" option."));
        } else {
            WanCommandGatewaySenderStartDUnitTest.fail((String)"testStartGatewaySender failed as did not get CommandResult");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private CommandResult executeCommandWithIgnoredExceptions(String command) {
        DistributedTestCase.ExpectedException exln = WanCommandGatewaySenderStartDUnitTest.addExpectedException("Could not connect");
        try {
            CommandResult commandResult;
            CommandResult commandResult2 = commandResult = this.executeCommand(command);
            return commandResult2;
        }
        finally {
            exln.remove();
        }
    }

    public void testStartGatewaySender() {
        VM puneLocator = Host.getLocator();
        int punePort = (Integer)puneLocator.invoke(WANCommandTestBase.class, "getLocatorPort");
        Properties props = new Properties();
        props.setProperty("mcast-port", "0");
        props.setProperty("locators", "localhost[" + punePort + "]");
        this.createDefaultSetup(props);
        Integer nyPort = (Integer)vm2.invoke(WANCommandTestBase.class, "createFirstRemoteLocator", new Object[]{2, punePort});
        vm3.invoke(WANCommandTestBase.class, "createCache", new Object[]{punePort});
        vm3.invoke(WANCommandTestBase.class, "createSender", new Object[]{"ln", 2, false, 100, 400, false, false, null, true});
        vm4.invoke(WANCommandTestBase.class, "createCache", new Object[]{punePort});
        vm4.invoke(WANCommandTestBase.class, "createSender", new Object[]{"ln", 2, false, 100, 400, false, false, null, true});
        vm5.invoke(WANCommandTestBase.class, "createCache", new Object[]{punePort});
        vm5.invoke(WANCommandTestBase.class, "createSender", new Object[]{"ln", 2, false, 100, 400, false, false, null, true});
        vm3.invoke(WANCommandTestBase.class, "verifySenderState", new Object[]{"ln", false, false});
        vm4.invoke(WANCommandTestBase.class, "verifySenderState", new Object[]{"ln", false, false});
        vm5.invoke(WANCommandTestBase.class, "verifySenderState", new Object[]{"ln", false, false});
        WanCommandGatewaySenderStartDUnitTest.pause(10000);
        String command = "start gateway-sender --id=ln";
        CommandResult cmdResult = this.executeCommandWithIgnoredExceptions(command);
        if (cmdResult != null) {
            String strCmdResult = this.commandResultToString(cmdResult);
            Log.getLogWriter().info("testStartGatewaySender stringResult : " + strCmdResult + ">>>>");
            WanCommandGatewaySenderStartDUnitTest.assertEquals((Object)Result.Status.OK, (Object)cmdResult.getStatus());
            TabularResultData resultData = (TabularResultData)cmdResult.getResultData();
            List status = resultData.retrieveAllValues("Result");
            WanCommandGatewaySenderStartDUnitTest.assertEquals((int)4, (int)status.size());
            WanCommandGatewaySenderStartDUnitTest.assertTrue((boolean)status.contains("Error"));
            WanCommandGatewaySenderStartDUnitTest.assertTrue((boolean)status.contains("OK"));
        } else {
            WanCommandGatewaySenderStartDUnitTest.fail((String)"testStartGatewaySender failed as did not get CommandResult");
        }
        vm3.invoke(WANCommandTestBase.class, "verifySenderState", new Object[]{"ln", true, false});
        vm4.invoke(WANCommandTestBase.class, "verifySenderState", new Object[]{"ln", true, false});
        vm5.invoke(WANCommandTestBase.class, "verifySenderState", new Object[]{"ln", true, false});
    }

    public void testStartGatewaySender_onMember() {
        VM puneLocator = Host.getLocator();
        int punePort = (Integer)puneLocator.invoke(WANCommandTestBase.class, "getLocatorPort");
        Properties props = new Properties();
        props.setProperty("mcast-port", "0");
        props.setProperty("locators", "localhost[" + punePort + "]");
        this.createDefaultSetup(props);
        Integer nyPort = (Integer)vm2.invoke(WANCommandTestBase.class, "createFirstRemoteLocator", new Object[]{2, punePort});
        vm3.invoke(WANCommandTestBase.class, "createCache", new Object[]{punePort});
        vm3.invoke(WANCommandTestBase.class, "createSender", new Object[]{"ln", 2, false, 100, 400, false, false, null, true});
        vm3.invoke(WANCommandTestBase.class, "verifySenderState", new Object[]{"ln", false, false});
        DistributedMember vm1Member = (DistributedMember)vm3.invoke(WANCommandTestBase.class, "getMember");
        WanCommandGatewaySenderStartDUnitTest.pause(10000);
        String command = "start gateway-sender --id=ln --member=" + vm1Member.getId();
        CommandResult cmdResult = this.executeCommandWithIgnoredExceptions(command);
        if (cmdResult != null) {
            String strCmdResult = this.commandResultToString(cmdResult);
            Log.getLogWriter().info("testStartGatewaySender stringResult : " + strCmdResult + ">>>>");
            WanCommandGatewaySenderStartDUnitTest.assertEquals((Object)Result.Status.OK, (Object)cmdResult.getStatus());
            WanCommandGatewaySenderStartDUnitTest.assertTrue((boolean)strCmdResult.contains("is started on member"));
        } else {
            WanCommandGatewaySenderStartDUnitTest.fail((String)"testStartGatewaySender failed as did not get CommandResult");
        }
        vm3.invoke(WANCommandTestBase.class, "verifySenderState", new Object[]{"ln", true, false});
    }

    public void testStartGatewaySender_Group() {
        VM puneLocator = Host.getLocator();
        int punePort = (Integer)puneLocator.invoke(WANCommandTestBase.class, "getLocatorPort");
        Properties props = new Properties();
        props.setProperty("mcast-port", "0");
        props.setProperty("locators", "localhost[" + punePort + "]");
        this.createDefaultSetup(props);
        Integer nyPort = (Integer)vm2.invoke(WANCommandTestBase.class, "createFirstRemoteLocator", new Object[]{2, punePort});
        vm3.invoke(WANCommandTestBase.class, "createCacheWithGroups", new Object[]{punePort, "SenderGroup1"});
        vm3.invoke(WANCommandTestBase.class, "createSender", new Object[]{"ln", 2, false, 100, 400, false, false, null, true});
        vm4.invoke(WANCommandTestBase.class, "createCacheWithGroups", new Object[]{punePort, "SenderGroup1"});
        vm4.invoke(WANCommandTestBase.class, "createSender", new Object[]{"ln", 2, false, 100, 400, false, false, null, true});
        vm5.invoke(WANCommandTestBase.class, "createCacheWithGroups", new Object[]{punePort, "SenderGroup1"});
        vm5.invoke(WANCommandTestBase.class, "createSender", new Object[]{"ln", 2, false, 100, 400, false, false, null, true});
        vm3.invoke(WANCommandTestBase.class, "verifySenderState", new Object[]{"ln", false, false});
        vm4.invoke(WANCommandTestBase.class, "verifySenderState", new Object[]{"ln", false, false});
        vm5.invoke(WANCommandTestBase.class, "verifySenderState", new Object[]{"ln", false, false});
        WanCommandGatewaySenderStartDUnitTest.pause(10000);
        String command = "start gateway-sender --id=ln --group=SenderGroup1";
        CommandResult cmdResult = this.executeCommandWithIgnoredExceptions(command);
        if (cmdResult != null) {
            String strCmdResult = this.commandResultToString(cmdResult);
            Log.getLogWriter().info("testStartGatewaySender_Group stringResult : " + strCmdResult + ">>>>");
            WanCommandGatewaySenderStartDUnitTest.assertEquals((Object)Result.Status.OK, (Object)cmdResult.getStatus());
            TabularResultData resultData = (TabularResultData)cmdResult.getResultData();
            List status = resultData.retrieveAllValues("Result");
            WanCommandGatewaySenderStartDUnitTest.assertEquals((int)3, (int)status.size());
            WanCommandGatewaySenderStartDUnitTest.assertFalse((boolean)status.contains("Error"));
            WanCommandGatewaySenderStartDUnitTest.assertTrue((boolean)status.contains("OK"));
        } else {
            WanCommandGatewaySenderStartDUnitTest.fail((String)"testStartGatewaySender failed as did not get CommandResult");
        }
        vm3.invoke(WANCommandTestBase.class, "verifySenderState", new Object[]{"ln", true, false});
        vm4.invoke(WANCommandTestBase.class, "verifySenderState", new Object[]{"ln", true, false});
        vm5.invoke(WANCommandTestBase.class, "verifySenderState", new Object[]{"ln", true, false});
    }

    public void testStartGatewaySender_MultipleGroup() {
        VM puneLocator = Host.getLocator();
        int punePort = (Integer)puneLocator.invoke(WANCommandTestBase.class, "getLocatorPort");
        Properties props = new Properties();
        props.setProperty("mcast-port", "0");
        props.setProperty("locators", "localhost[" + punePort + "]");
        this.createDefaultSetup(props);
        Integer nyPort = (Integer)vm2.invoke(WANCommandTestBase.class, "createFirstRemoteLocator", new Object[]{2, punePort});
        vm3.invoke(WANCommandTestBase.class, "createCacheWithGroups", new Object[]{punePort, "SenderGroup1"});
        vm3.invoke(WANCommandTestBase.class, "createSender", new Object[]{"ln", 2, false, 100, 400, false, false, null, true});
        vm4.invoke(WANCommandTestBase.class, "createCacheWithGroups", new Object[]{punePort, "SenderGroup1"});
        vm4.invoke(WANCommandTestBase.class, "createSender", new Object[]{"ln", 2, false, 100, 400, false, false, null, true});
        vm5.invoke(WANCommandTestBase.class, "createCacheWithGroups", new Object[]{punePort, "SenderGroup1, SenderGroup2"});
        vm5.invoke(WANCommandTestBase.class, "createSender", new Object[]{"ln", 2, false, 100, 400, false, false, null, true});
        vm6.invoke(WANCommandTestBase.class, "createCacheWithGroups", new Object[]{punePort, "SenderGroup1, SenderGroup2"});
        vm6.invoke(WANCommandTestBase.class, "createSender", new Object[]{"ln", 2, false, 100, 400, false, false, null, true});
        vm7.invoke(WANCommandTestBase.class, "createCacheWithGroups", new Object[]{punePort, "SenderGroup3"});
        vm7.invoke(WANCommandTestBase.class, "createSender", new Object[]{"ln", 2, false, 100, 400, false, false, null, true});
        vm3.invoke(WANCommandTestBase.class, "verifySenderState", new Object[]{"ln", false, false});
        vm4.invoke(WANCommandTestBase.class, "verifySenderState", new Object[]{"ln", false, false});
        vm5.invoke(WANCommandTestBase.class, "verifySenderState", new Object[]{"ln", false, false});
        vm6.invoke(WANCommandTestBase.class, "verifySenderState", new Object[]{"ln", false, false});
        vm7.invoke(WANCommandTestBase.class, "verifySenderState", new Object[]{"ln", false, false});
        WanCommandGatewaySenderStartDUnitTest.pause(10000);
        String command = "start gateway-sender --id=ln --group=SenderGroup1,SenderGroup2";
        CommandResult cmdResult = this.executeCommandWithIgnoredExceptions(command);
        if (cmdResult != null) {
            String strCmdResult = this.commandResultToString(cmdResult);
            Log.getLogWriter().info("testStartGatewaySender_Group stringResult : " + strCmdResult + ">>>>");
            WanCommandGatewaySenderStartDUnitTest.assertEquals((Object)Result.Status.OK, (Object)cmdResult.getStatus());
            TabularResultData resultData = (TabularResultData)cmdResult.getResultData();
            List status = resultData.retrieveAllValues("Result");
            WanCommandGatewaySenderStartDUnitTest.assertEquals((int)4, (int)status.size());
            WanCommandGatewaySenderStartDUnitTest.assertFalse((boolean)status.contains("Error"));
            WanCommandGatewaySenderStartDUnitTest.assertTrue((boolean)status.contains("OK"));
        } else {
            WanCommandGatewaySenderStartDUnitTest.fail((String)"testStartGatewaySender failed as did not get CommandResult");
        }
        vm3.invoke(WANCommandTestBase.class, "verifySenderState", new Object[]{"ln", true, false});
        vm4.invoke(WANCommandTestBase.class, "verifySenderState", new Object[]{"ln", true, false});
        vm5.invoke(WANCommandTestBase.class, "verifySenderState", new Object[]{"ln", true, false});
        vm6.invoke(WANCommandTestBase.class, "verifySenderState", new Object[]{"ln", true, false});
        vm7.invoke(WANCommandTestBase.class, "verifySenderState", new Object[]{"ln", false, false});
    }

    public void testStartGatewaySender_Group_MissingSenderFromGroup() {
        VM puneLocator = Host.getLocator();
        int punePort = (Integer)puneLocator.invoke(WANCommandTestBase.class, "getLocatorPort");
        Properties props = new Properties();
        props.setProperty("mcast-port", "0");
        props.setProperty("locators", "localhost[" + punePort + "]");
        this.createDefaultSetup(props);
        Integer nyPort = (Integer)vm2.invoke(WANCommandTestBase.class, "createFirstRemoteLocator", new Object[]{2, punePort});
        vm3.invoke(WANCommandTestBase.class, "createCacheWithGroups", new Object[]{punePort, "SenderGroup1"});
        vm3.invoke(WANCommandTestBase.class, "createSender", new Object[]{"ln", 2, false, 100, 400, false, false, null, true});
        vm4.invoke(WANCommandTestBase.class, "createCacheWithGroups", new Object[]{punePort, "SenderGroup1"});
        vm5.invoke(WANCommandTestBase.class, "createCacheWithGroups", new Object[]{punePort, "SenderGroup1"});
        vm5.invoke(WANCommandTestBase.class, "createSender", new Object[]{"ln", 2, false, 100, 400, false, false, null, true});
        vm3.invoke(WANCommandTestBase.class, "verifySenderState", new Object[]{"ln", false, false});
        vm5.invoke(WANCommandTestBase.class, "verifySenderState", new Object[]{"ln", false, false});
        WanCommandGatewaySenderStartDUnitTest.pause(10000);
        String command = "start gateway-sender --id=ln --group=SenderGroup1";
        CommandResult cmdResult = this.executeCommandWithIgnoredExceptions(command);
        if (cmdResult != null) {
            String strCmdResult = this.commandResultToString(cmdResult);
            WanCommandGatewaySenderStartDUnitTest.assertTrue((boolean)strCmdResult.contains("Error"));
            WanCommandGatewaySenderStartDUnitTest.assertTrue((boolean)strCmdResult.contains("is not available"));
            Log.getLogWriter().info("testStartGatewaySender_Group stringResult : " + strCmdResult + ">>>>");
            WanCommandGatewaySenderStartDUnitTest.assertEquals((Object)Result.Status.OK, (Object)cmdResult.getStatus());
            TabularResultData resultData = (TabularResultData)cmdResult.getResultData();
            List status = resultData.retrieveAllValues("Result");
            WanCommandGatewaySenderStartDUnitTest.assertEquals((int)3, (int)status.size());
            WanCommandGatewaySenderStartDUnitTest.assertTrue((boolean)status.contains("Error"));
            WanCommandGatewaySenderStartDUnitTest.assertTrue((boolean)status.contains("OK"));
        } else {
            WanCommandGatewaySenderStartDUnitTest.fail((String)"testStartGatewaySender failed as did not get CommandResult");
        }
        vm3.invoke(WANCommandTestBase.class, "verifySenderState", new Object[]{"ln", true, false});
        vm5.invoke(WANCommandTestBase.class, "verifySenderState", new Object[]{"ln", true, false});
    }
}

