/*
 * Decompiled with CFR 0.152.
 */
package com.gemstone.gemfire.internal.cache.wan.wancommand;

import com.gemstone.gemfire.distributed.DistributedMember;
import com.gemstone.gemfire.internal.cache.wan.wancommand.WANCommandTestBase;
import com.gemstone.gemfire.management.cli.Result;
import com.gemstone.gemfire.management.internal.cli.result.CommandResult;
import com.gemstone.gemfire.management.internal.cli.result.CompositeResultData;
import com.gemstone.gemfire.management.internal.cli.result.TabularResultData;
import hydra.Log;
import java.util.List;
import java.util.Properties;

public class WanCommandStatusDUnitTest
extends WANCommandTestBase {
    private static final long serialVersionUID = 1L;

    public WanCommandStatusDUnitTest(String name) {
        super(name);
    }

    @Override
    public void setUp() throws Exception {
        super.setUp();
    }

    public void testGatewaySenderStatus() {
        String strCmdResult;
        List result_hosts;
        List result_Status;
        TabularResultData tableResultData;
        Integer lnPort = (Integer)vm1.invoke(WANCommandTestBase.class, "createFirstLocatorWithDSId", new Object[]{1});
        Properties props = new Properties();
        props.setProperty("mcast-port", "0");
        props.setProperty("locators", "localhost[" + lnPort + "]");
        this.createDefaultSetup(props);
        Integer nyPort = (Integer)vm2.invoke(WANCommandTestBase.class, "createFirstRemoteLocator", new Object[]{2, lnPort});
        vm6.invoke(WANCommandTestBase.class, "createAndStartReceiver", new Object[]{nyPort});
        vm3.invoke(WANCommandTestBase.class, "createCache", new Object[]{lnPort});
        vm3.invoke(WANCommandTestBase.class, "createSender", new Object[]{"ln_Serial", 2, false, 100, 400, false, false, null, true});
        vm3.invoke(WANCommandTestBase.class, "createSender", new Object[]{"ln_Parallel", 2, true, 100, 400, false, false, null, true});
        vm4.invoke(WANCommandTestBase.class, "createCache", new Object[]{lnPort});
        vm4.invoke(WANCommandTestBase.class, "createSender", new Object[]{"ln_Serial", 2, false, 100, 400, false, false, null, true});
        vm4.invoke(WANCommandTestBase.class, "createSender", new Object[]{"ln_Parallel", 2, true, 100, 400, false, false, null, true});
        vm5.invoke(WANCommandTestBase.class, "createCache", new Object[]{lnPort});
        vm5.invoke(WANCommandTestBase.class, "createSender", new Object[]{"ln_Serial", 2, false, 100, 400, false, false, null, true});
        vm5.invoke(WANCommandTestBase.class, "createSender", new Object[]{"ln_Parallel", 2, true, 100, 400, false, false, null, true});
        WanCommandStatusDUnitTest.pause(10000);
        String command = "status gateway-sender --id=ln_Serial";
        CommandResult cmdResult = this.executeCommand(command);
        if (cmdResult != null) {
            tableResultData = ((CompositeResultData)cmdResult.getResultData()).retrieveSection("Available GatewaySender Section").retrieveTable("GatewaySender Table");
            result_Status = tableResultData.retrieveAllValues("Status");
            WanCommandStatusDUnitTest.assertEquals((int)3, (int)result_Status.size());
            WanCommandStatusDUnitTest.assertFalse((boolean)result_Status.contains("Running"));
            tableResultData = ((CompositeResultData)cmdResult.getResultData()).retrieveSection("Not Available GatewaySender Section").retrieveTable("GatewaySender Table");
            result_hosts = tableResultData.retrieveAllValues("Member");
            WanCommandStatusDUnitTest.assertEquals((int)2, (int)result_hosts.size());
            strCmdResult = this.commandResultToString(cmdResult);
            Log.getLogWriter().info("testGatewaySenderStatus : " + strCmdResult + ">>>>> ");
            WanCommandStatusDUnitTest.assertEquals((Object)Result.Status.OK, (Object)cmdResult.getStatus());
        } else {
            WanCommandStatusDUnitTest.fail((String)"testListGatewaySender failed as did not get CommandResult");
        }
        vm3.invoke(WANCommandTestBase.class, "startSender", new Object[]{"ln_Serial"});
        vm3.invoke(WANCommandTestBase.class, "startSender", new Object[]{"ln_Parallel"});
        vm4.invoke(WANCommandTestBase.class, "startSender", new Object[]{"ln_Serial"});
        vm4.invoke(WANCommandTestBase.class, "startSender", new Object[]{"ln_Parallel"});
        vm5.invoke(WANCommandTestBase.class, "startSender", new Object[]{"ln_Serial"});
        vm5.invoke(WANCommandTestBase.class, "startSender", new Object[]{"ln_Parallel"});
        WanCommandStatusDUnitTest.pause(10000);
        command = "status gateway-sender --id=ln_Serial";
        cmdResult = this.executeCommand(command);
        if (cmdResult != null) {
            tableResultData = ((CompositeResultData)cmdResult.getResultData()).retrieveSection("Available GatewaySender Section").retrieveTable("GatewaySender Table");
            result_Status = tableResultData.retrieveAllValues("Status");
            WanCommandStatusDUnitTest.assertEquals((int)3, (int)result_Status.size());
            WanCommandStatusDUnitTest.assertFalse((boolean)result_Status.contains("Not Running"));
            tableResultData = ((CompositeResultData)cmdResult.getResultData()).retrieveSection("Not Available GatewaySender Section").retrieveTable("GatewaySender Table");
            result_hosts = tableResultData.retrieveAllValues("Member");
            WanCommandStatusDUnitTest.assertEquals((int)2, (int)result_hosts.size());
            strCmdResult = this.commandResultToString(cmdResult);
            Log.getLogWriter().info("testGatewaySenderStatus : " + strCmdResult + ">>>>> ");
            WanCommandStatusDUnitTest.assertEquals((Object)Result.Status.OK, (Object)cmdResult.getStatus());
        } else {
            WanCommandStatusDUnitTest.fail((String)"testListGatewaySender failed as did not get CommandResult");
        }
    }

    public void testGatewaySenderStatus_OnMember() {
        List result_Status;
        TabularResultData tableResultData;
        String strCmdResult;
        Integer lnPort = (Integer)vm1.invoke(WANCommandTestBase.class, "createFirstLocatorWithDSId", new Object[]{1});
        Properties props = new Properties();
        props.setProperty("mcast-port", "0");
        props.setProperty("locators", "localhost[" + lnPort + "]");
        this.createDefaultSetup(props);
        Integer nyPort = (Integer)vm2.invoke(WANCommandTestBase.class, "createFirstRemoteLocator", new Object[]{2, lnPort});
        vm6.invoke(WANCommandTestBase.class, "createAndStartReceiver", new Object[]{nyPort});
        vm3.invoke(WANCommandTestBase.class, "createCache", new Object[]{lnPort});
        vm3.invoke(WANCommandTestBase.class, "createSender", new Object[]{"ln_Serial", 2, false, 100, 400, false, false, null, true});
        vm3.invoke(WANCommandTestBase.class, "createSender", new Object[]{"ln_Parallel", 2, true, 100, 400, false, false, null, true});
        vm4.invoke(WANCommandTestBase.class, "createCache", new Object[]{lnPort});
        vm4.invoke(WANCommandTestBase.class, "createSender", new Object[]{"ln_Serial", 2, false, 100, 400, false, false, null, true});
        vm4.invoke(WANCommandTestBase.class, "createSender", new Object[]{"ln_Parallel", 2, true, 100, 400, false, false, null, true});
        vm5.invoke(WANCommandTestBase.class, "createCache", new Object[]{lnPort});
        DistributedMember vm1Member = (DistributedMember)vm3.invoke(WANCommandTestBase.class, "getMember");
        WanCommandStatusDUnitTest.pause(10000);
        String command = "status gateway-sender --id=ln_Serial --member=" + vm1Member.getId();
        CommandResult cmdResult = this.executeCommand(command);
        if (cmdResult != null) {
            strCmdResult = this.commandResultToString(cmdResult);
            Log.getLogWriter().info("testGatewaySenderStatus_OnMember : " + strCmdResult + ">>>>> ");
            tableResultData = ((CompositeResultData)cmdResult.getResultData()).retrieveSection("Available GatewaySender Section").retrieveTable("GatewaySender Table");
            result_Status = tableResultData.retrieveAllValues("Status");
            WanCommandStatusDUnitTest.assertEquals((int)1, (int)result_Status.size());
            WanCommandStatusDUnitTest.assertFalse((boolean)result_Status.contains("Running"));
            WanCommandStatusDUnitTest.assertEquals((Object)Result.Status.OK, (Object)cmdResult.getStatus());
        } else {
            WanCommandStatusDUnitTest.fail((String)"testListGatewaySender failed as did not get CommandResult");
        }
        vm3.invoke(WANCommandTestBase.class, "startSender", new Object[]{"ln_Serial"});
        vm3.invoke(WANCommandTestBase.class, "startSender", new Object[]{"ln_Parallel"});
        vm4.invoke(WANCommandTestBase.class, "startSender", new Object[]{"ln_Serial"});
        vm4.invoke(WANCommandTestBase.class, "startSender", new Object[]{"ln_Parallel"});
        WanCommandStatusDUnitTest.pause(10000);
        command = "status gateway-sender --id=ln_Serial --member=" + vm1Member.getId();
        cmdResult = this.executeCommand(command);
        if (cmdResult != null) {
            strCmdResult = this.commandResultToString(cmdResult);
            Log.getLogWriter().info("testGatewaySenderStatus_OnMember : " + strCmdResult + ">>>>> ");
            tableResultData = ((CompositeResultData)cmdResult.getResultData()).retrieveSection("Available GatewaySender Section").retrieveTable("GatewaySender Table");
            result_Status = tableResultData.retrieveAllValues("Status");
            WanCommandStatusDUnitTest.assertEquals((int)1, (int)result_Status.size());
            WanCommandStatusDUnitTest.assertFalse((boolean)result_Status.contains("Not Running"));
            WanCommandStatusDUnitTest.assertEquals((Object)Result.Status.OK, (Object)cmdResult.getStatus());
        } else {
            WanCommandStatusDUnitTest.fail((String)"testListGatewaySender failed as did not get CommandResult");
        }
        DistributedMember vm5Member = (DistributedMember)vm5.invoke(WANCommandTestBase.class, "getMember");
        command = "status gateway-sender --id=ln_Serial --member=" + vm5Member.getId();
        cmdResult = this.executeCommand(command);
        if (cmdResult != null) {
            WanCommandStatusDUnitTest.assertTrue((cmdResult != null ? 1 : 0) != 0);
            String strCmdResult2 = this.commandResultToString(cmdResult);
            Log.getLogWriter().info("testGatewaySenderStatus_OnMember : " + strCmdResult2 + ">>>>> ");
            WanCommandStatusDUnitTest.assertEquals((Object)Result.Status.OK, (Object)cmdResult.getStatus());
        } else {
            WanCommandStatusDUnitTest.fail((String)"testListGatewaySender failed as did not get CommandResult");
        }
    }

    public void testGatewaySenderStatus_OnGroups() {
        String strCmdResult;
        List result_hosts;
        List result_Status;
        TabularResultData tableResultData;
        Integer lnPort = (Integer)vm1.invoke(WANCommandTestBase.class, "createFirstLocatorWithDSId", new Object[]{1});
        Properties props = new Properties();
        props.setProperty("mcast-port", "0");
        props.setProperty("locators", "localhost[" + lnPort + "]");
        this.createDefaultSetup(props);
        Integer nyPort = (Integer)vm2.invoke(WANCommandTestBase.class, "createFirstRemoteLocator", new Object[]{2, lnPort});
        vm7.invoke(WANCommandTestBase.class, "createAndStartReceiver", new Object[]{nyPort});
        vm3.invoke(WANCommandTestBase.class, "createCacheWithGroups", new Object[]{lnPort, "Serial_Sender, Paralle_Sender"});
        vm3.invoke(WANCommandTestBase.class, "createSender", new Object[]{"ln_Serial", 2, false, 100, 400, false, false, null, true});
        vm3.invoke(WANCommandTestBase.class, "createSender", new Object[]{"ln_Parallel", 2, true, 100, 400, false, false, null, true});
        vm4.invoke(WANCommandTestBase.class, "createCacheWithGroups", new Object[]{lnPort, "Serial_Sender, Paralle_Sender"});
        vm4.invoke(WANCommandTestBase.class, "createSender", new Object[]{"ln_Serial", 2, false, 100, 400, false, false, null, true});
        vm4.invoke(WANCommandTestBase.class, "createSender", new Object[]{"ln_Parallel", 2, true, 100, 400, false, false, null, true});
        vm5.invoke(WANCommandTestBase.class, "createCacheWithGroups", new Object[]{lnPort, "Paralle_Sender"});
        vm5.invoke(WANCommandTestBase.class, "createSender", new Object[]{"ln_Serial", 2, false, 100, 400, false, false, null, true});
        vm5.invoke(WANCommandTestBase.class, "createSender", new Object[]{"ln_Parallel", 2, true, 100, 400, false, false, null, true});
        vm6.invoke(WANCommandTestBase.class, "createCacheWithGroups", new Object[]{lnPort, "Serial_Sender"});
        DistributedMember vm1Member = (DistributedMember)vm3.invoke(WANCommandTestBase.class, "getMember");
        WanCommandStatusDUnitTest.pause(10000);
        String command = "status gateway-sender --id=ln_Serial --group=Serial_Sender";
        CommandResult cmdResult = this.executeCommand(command);
        if (cmdResult != null) {
            tableResultData = ((CompositeResultData)cmdResult.getResultData()).retrieveSection("Available GatewaySender Section").retrieveTable("GatewaySender Table");
            result_Status = tableResultData.retrieveAllValues("Status");
            WanCommandStatusDUnitTest.assertEquals((int)2, (int)result_Status.size());
            WanCommandStatusDUnitTest.assertFalse((boolean)result_Status.contains("Running"));
            tableResultData = ((CompositeResultData)cmdResult.getResultData()).retrieveSection("Not Available GatewaySender Section").retrieveTable("GatewaySender Table");
            result_hosts = tableResultData.retrieveAllValues("Member");
            WanCommandStatusDUnitTest.assertEquals((int)1, (int)result_hosts.size());
            strCmdResult = this.commandResultToString(cmdResult);
            Log.getLogWriter().info("testGatewaySenderStatus_OnGroups : " + strCmdResult + ">>>>> ");
            WanCommandStatusDUnitTest.assertEquals((Object)Result.Status.OK, (Object)cmdResult.getStatus());
        } else {
            WanCommandStatusDUnitTest.fail((String)"testListGatewaySender failed as did not get CommandResult");
        }
        vm3.invoke(WANCommandTestBase.class, "startSender", new Object[]{"ln_Serial"});
        vm3.invoke(WANCommandTestBase.class, "startSender", new Object[]{"ln_Parallel"});
        vm4.invoke(WANCommandTestBase.class, "startSender", new Object[]{"ln_Serial"});
        vm4.invoke(WANCommandTestBase.class, "startSender", new Object[]{"ln_Parallel"});
        WanCommandStatusDUnitTest.pause(10000);
        command = "status gateway-sender --id=ln_Serial --group=Serial_Sender";
        cmdResult = this.executeCommand(command);
        if (cmdResult != null) {
            tableResultData = ((CompositeResultData)cmdResult.getResultData()).retrieveSection("Available GatewaySender Section").retrieveTable("GatewaySender Table");
            result_Status = tableResultData.retrieveAllValues("Status");
            WanCommandStatusDUnitTest.assertEquals((int)2, (int)result_Status.size());
            WanCommandStatusDUnitTest.assertFalse((boolean)result_Status.contains("Not Running"));
            tableResultData = ((CompositeResultData)cmdResult.getResultData()).retrieveSection("Not Available GatewaySender Section").retrieveTable("GatewaySender Table");
            result_hosts = tableResultData.retrieveAllValues("Member");
            WanCommandStatusDUnitTest.assertEquals((int)1, (int)result_hosts.size());
            strCmdResult = this.commandResultToString(cmdResult);
            Log.getLogWriter().info("testGatewaySenderStatus_OnGroups : " + strCmdResult + ">>>>> ");
            WanCommandStatusDUnitTest.assertEquals((Object)Result.Status.OK, (Object)cmdResult.getStatus());
        } else {
            WanCommandStatusDUnitTest.fail((String)"testListGatewaySender failed as did not get CommandResult");
        }
    }

    public void testGatewayReceiverStatus() {
        List result_hosts;
        List result_Status;
        TabularResultData tableResultData;
        String strCmdResult;
        Integer lnPort = (Integer)vm1.invoke(WANCommandTestBase.class, "createFirstLocatorWithDSId", new Object[]{1});
        Properties props = new Properties();
        props.setProperty("mcast-port", "0");
        props.setProperty("locators", "localhost[" + lnPort + "]");
        this.createDefaultSetup(props);
        Integer nyPort = (Integer)vm2.invoke(WANCommandTestBase.class, "createFirstRemoteLocator", new Object[]{2, lnPort});
        vm6.invoke(WANCommandTestBase.class, "createAndStartReceiver", new Object[]{nyPort});
        vm3.invoke(WANCommandTestBase.class, "createAndStartReceiver", new Object[]{lnPort});
        vm4.invoke(WANCommandTestBase.class, "createAndStartReceiver", new Object[]{lnPort});
        vm5.invoke(WANCommandTestBase.class, "createAndStartReceiver", new Object[]{lnPort});
        WanCommandStatusDUnitTest.pause(10000);
        String command = "status gateway-receiver";
        CommandResult cmdResult = this.executeCommand(command);
        if (cmdResult != null) {
            strCmdResult = this.commandResultToString(cmdResult);
            Log.getLogWriter().info("testGatewayReceiverStatus : " + strCmdResult + ">>>>> ");
            WanCommandStatusDUnitTest.assertEquals((Object)Result.Status.OK, (Object)cmdResult.getStatus());
            tableResultData = ((CompositeResultData)cmdResult.getResultData()).retrieveSection("Available GatewayReceiver Section").retrieveTable("GatewayReceiver Table");
            result_Status = tableResultData.retrieveAllValues("Status");
            WanCommandStatusDUnitTest.assertEquals((int)3, (int)result_Status.size());
            WanCommandStatusDUnitTest.assertFalse((boolean)result_Status.contains("Not Running"));
            tableResultData = ((CompositeResultData)cmdResult.getResultData()).retrieveSection("Not Available GatewayReceiver Section").retrieveTable("GatewayReceiver Table");
            result_hosts = tableResultData.retrieveAllValues("Member");
            WanCommandStatusDUnitTest.assertEquals((int)2, (int)result_hosts.size());
        } else {
            WanCommandStatusDUnitTest.fail((String)"testGatewayReceiverStatus failed as did not get CommandResult");
        }
        vm3.invoke(WANCommandTestBase.class, "stopReceiver");
        vm4.invoke(WANCommandTestBase.class, "stopReceiver");
        vm5.invoke(WANCommandTestBase.class, "stopReceiver");
        WanCommandStatusDUnitTest.pause(10000);
        command = "status gateway-receiver";
        cmdResult = this.executeCommand(command);
        if (cmdResult != null) {
            strCmdResult = this.commandResultToString(cmdResult);
            Log.getLogWriter().info("testGatewayReceiverStatus : " + strCmdResult + ">>>>> ");
            WanCommandStatusDUnitTest.assertEquals((Object)Result.Status.OK, (Object)cmdResult.getStatus());
            tableResultData = ((CompositeResultData)cmdResult.getResultData()).retrieveSection("Available GatewayReceiver Section").retrieveTable("GatewayReceiver Table");
            result_Status = tableResultData.retrieveAllValues("Status");
            WanCommandStatusDUnitTest.assertEquals((int)3, (int)result_Status.size());
            WanCommandStatusDUnitTest.assertFalse((boolean)result_Status.contains("Running"));
            tableResultData = ((CompositeResultData)cmdResult.getResultData()).retrieveSection("Not Available GatewayReceiver Section").retrieveTable("GatewayReceiver Table");
            result_hosts = tableResultData.retrieveAllValues("Member");
            WanCommandStatusDUnitTest.assertEquals((int)2, (int)result_hosts.size());
        } else {
            WanCommandStatusDUnitTest.fail((String)"testGatewayReceiverStatus failed as did not get CommandResult");
        }
    }

    public void testGatewayReceiverStatus_OnMember() {
        List result_Status;
        TabularResultData tableResultData;
        String strCmdResult;
        Integer lnPort = (Integer)vm1.invoke(WANCommandTestBase.class, "createFirstLocatorWithDSId", new Object[]{1});
        Properties props = new Properties();
        props.setProperty("mcast-port", "0");
        props.setProperty("locators", "localhost[" + lnPort + "]");
        this.createDefaultSetup(props);
        Integer nyPort = (Integer)vm2.invoke(WANCommandTestBase.class, "createFirstRemoteLocator", new Object[]{2, lnPort});
        vm6.invoke(WANCommandTestBase.class, "createAndStartReceiver", new Object[]{nyPort});
        vm3.invoke(WANCommandTestBase.class, "createAndStartReceiver", new Object[]{lnPort});
        vm4.invoke(WANCommandTestBase.class, "createAndStartReceiver", new Object[]{lnPort});
        vm5.invoke(WANCommandTestBase.class, "createAndStartReceiver", new Object[]{lnPort});
        DistributedMember vm3Member = (DistributedMember)vm3.invoke(WANCommandTestBase.class, "getMember");
        WanCommandStatusDUnitTest.pause(10000);
        String command = "status gateway-receiver --member=" + vm3Member.getId();
        CommandResult cmdResult = this.executeCommand(command);
        if (cmdResult != null) {
            strCmdResult = this.commandResultToString(cmdResult);
            Log.getLogWriter().info("testGatewayReceiverStatus : " + strCmdResult + ">>>>> ");
            WanCommandStatusDUnitTest.assertEquals((Object)Result.Status.OK, (Object)cmdResult.getStatus());
            tableResultData = ((CompositeResultData)cmdResult.getResultData()).retrieveSection("Available GatewayReceiver Section").retrieveTable("GatewayReceiver Table");
            result_Status = tableResultData.retrieveAllValues("Status");
            WanCommandStatusDUnitTest.assertEquals((int)1, (int)result_Status.size());
            WanCommandStatusDUnitTest.assertFalse((boolean)result_Status.contains("Not Running"));
        } else {
            WanCommandStatusDUnitTest.fail((String)"testGatewayReceiverStatus failed as did not get CommandResult");
        }
        vm3.invoke(WANCommandTestBase.class, "stopReceiver");
        vm4.invoke(WANCommandTestBase.class, "stopReceiver");
        vm5.invoke(WANCommandTestBase.class, "stopReceiver");
        WanCommandStatusDUnitTest.pause(10000);
        command = "status gateway-receiver --member=" + vm3Member.getId();
        cmdResult = this.executeCommand(command);
        if (cmdResult != null) {
            strCmdResult = this.commandResultToString(cmdResult);
            Log.getLogWriter().info("testGatewayReceiverStatus : " + strCmdResult + ">>>>> ");
            tableResultData = ((CompositeResultData)cmdResult.getResultData()).retrieveSection("Available GatewayReceiver Section").retrieveTable("GatewayReceiver Table");
            result_Status = tableResultData.retrieveAllValues("Status");
            WanCommandStatusDUnitTest.assertEquals((int)1, (int)result_Status.size());
            WanCommandStatusDUnitTest.assertFalse((boolean)result_Status.contains("Running"));
        } else {
            WanCommandStatusDUnitTest.fail((String)"testGatewayReceiverStatus failed as did not get CommandResult");
        }
    }

    public void testGatewayReceiverStatus_OnGroups() {
        List result_Status;
        TabularResultData tableResultData;
        String strCmdResult;
        Integer lnPort = (Integer)vm1.invoke(WANCommandTestBase.class, "createFirstLocatorWithDSId", new Object[]{1});
        Properties props = new Properties();
        props.setProperty("mcast-port", "0");
        props.setProperty("locators", "localhost[" + lnPort + "]");
        this.createDefaultSetup(props);
        Integer nyPort = (Integer)vm2.invoke(WANCommandTestBase.class, "createFirstRemoteLocator", new Object[]{2, lnPort});
        vm7.invoke(WANCommandTestBase.class, "createAndStartReceiver", new Object[]{nyPort});
        vm3.invoke(WANCommandTestBase.class, "createAndStartReceiverWithGroup", new Object[]{lnPort, "RG1, RG2"});
        vm4.invoke(WANCommandTestBase.class, "createAndStartReceiverWithGroup", new Object[]{lnPort, "RG1, RG2"});
        vm5.invoke(WANCommandTestBase.class, "createAndStartReceiverWithGroup", new Object[]{lnPort, "RG1"});
        vm6.invoke(WANCommandTestBase.class, "createAndStartReceiverWithGroup", new Object[]{lnPort, "RG2"});
        WanCommandStatusDUnitTest.pause(10000);
        String command = "status gateway-receiver --group=RG1";
        CommandResult cmdResult = this.executeCommand(command);
        if (cmdResult != null) {
            strCmdResult = this.commandResultToString(cmdResult);
            Log.getLogWriter().info("testGatewayReceiverStatus : " + strCmdResult + ">>>>> ");
            WanCommandStatusDUnitTest.assertEquals((Object)Result.Status.OK, (Object)cmdResult.getStatus());
            tableResultData = ((CompositeResultData)cmdResult.getResultData()).retrieveSection("Available GatewayReceiver Section").retrieveTable("GatewayReceiver Table");
            result_Status = tableResultData.retrieveAllValues("Status");
            WanCommandStatusDUnitTest.assertEquals((int)3, (int)result_Status.size());
            WanCommandStatusDUnitTest.assertFalse((boolean)result_Status.contains("Not Running"));
        } else {
            WanCommandStatusDUnitTest.fail((String)"testGatewayReceiverStatus failed as did not get CommandResult");
        }
        vm3.invoke(WANCommandTestBase.class, "stopReceiver");
        vm4.invoke(WANCommandTestBase.class, "stopReceiver");
        vm5.invoke(WANCommandTestBase.class, "stopReceiver");
        WanCommandStatusDUnitTest.pause(10000);
        command = "status gateway-receiver --group=RG1";
        cmdResult = this.executeCommand(command);
        if (cmdResult != null) {
            strCmdResult = this.commandResultToString(cmdResult);
            Log.getLogWriter().info("testGatewayReceiverStatus_OnGroups : " + strCmdResult + ">>>>> ");
            WanCommandStatusDUnitTest.assertEquals((Object)Result.Status.OK, (Object)cmdResult.getStatus());
            tableResultData = ((CompositeResultData)cmdResult.getResultData()).retrieveSection("Available GatewayReceiver Section").retrieveTable("GatewayReceiver Table");
            result_Status = tableResultData.retrieveAllValues("Status");
            WanCommandStatusDUnitTest.assertEquals((int)3, (int)result_Status.size());
            WanCommandStatusDUnitTest.assertFalse((boolean)result_Status.contains("Running"));
        } else {
            WanCommandStatusDUnitTest.fail((String)"testGatewayReceiverStatus failed as did not get CommandResult");
        }
    }
}

