/*
 * Decompiled with CFR 0.152.
 */
package com.gemstone.gemfire.internal.compression;

import com.gemstone.gemfire.cache.Region;
import com.gemstone.gemfire.cache30.CacheTestCase;
import com.gemstone.gemfire.compression.Compressor;
import com.gemstone.gemfire.compression.SnappyCompressor;
import com.gemstone.gemfire.internal.cache.LocalRegion;
import dunit.DistributedTestCase;
import dunit.Host;
import dunit.SerializableCallable;
import dunit.SerializableRunnable;
import dunit.VM;
import java.io.File;
import java.io.IOException;
import java.io.PrintStream;
import java.util.Properties;
import junit.framework.TestCase;

public class CompressionCacheConfigDUnitTest
extends CacheTestCase {
    public static final String REGION_NAME = "compressedRegion";
    private static final String GOOD_COMPRESSOR = "<?xml version=\"1.0\" encoding=\"UTF-8\"?>\n<!DOCTYPE cache PUBLIC \"-//GemStone Systems, Inc.//GemFire Declarative Cache 7.5//EN\" \"http://www.gemstone.com/dtd/cache7_5.dtd\">\n<cache lock-lease=\"120\" lock-timeout=\"60\" search-timeout=\"300\" is-server=\"true\" copy-on-read=\"false\">\n<region name=\"compressedRegion\">\n<region-attributes data-policy=\"replicate\" cloning-enabled=\"true\">\n<compressor>\n<class-name>com.gemstone.gemfire.compression.SnappyCompressor</class-name>\n</compressor>\n</region-attributes>\n</region>\n</cache>";
    private static final String BAD_COMPRESSOR = "<?xml version=\"1.0\" encoding=\"UTF-8\"?>\n<!DOCTYPE cache PUBLIC \"-//GemStone Systems, Inc.//GemFire Declarative Cache 7.5//EN\" \"http://www.gemstone.com/dtd/cache7_5.dtd\">\n<cache lock-lease=\"120\" lock-timeout=\"60\" search-timeout=\"300\" is-server=\"true\" copy-on-read=\"false\">\n<region name=\"compressedRegion\">\n<region-attributes data-policy=\"replicate\" cloning-enabled=\"true\">\n<compressor>\n<class-name>BAD_COMPRESSOR</class-name>\n</compressor>\n</region-attributes>\n</region>\n</cache>";

    public CompressionCacheConfigDUnitTest(String name) {
        super(name);
    }

    @Override
    public void setUp() throws Exception {
        super.setUp();
    }

    @Override
    public void tearDown2() throws Exception {
        super.tearDown2();
    }

    public void testCreateCacheWithGoodCompressor() throws Exception {
        try {
            SnappyCompressor.getDefaultInstance();
        }
        catch (Throwable t) {
            return;
        }
        File cacheXml = this.createCacheXml(GOOD_COMPRESSOR);
        CompressionCacheConfigDUnitTest.assertTrue((boolean)this.createCacheOnVM(this.getVM(0), cacheXml.getCanonicalPath()));
        this.assertCompressorOnVM(this.getVM(0), (Compressor)SnappyCompressor.getDefaultInstance(), REGION_NAME);
        this.cleanup(this.getVM(0));
        cacheXml.delete();
    }

    public void testCreateCacheWithBadCompressor() throws Exception {
        File cacheXml = this.createCacheXml(BAD_COMPRESSOR);
        CompressionCacheConfigDUnitTest.assertFalse((boolean)this.createCacheOnVM(this.getVM(0), cacheXml.getCanonicalPath()));
        cacheXml.delete();
    }

    private void assertCompressorOnVM(VM vm, final Compressor compressor, final String regionName) {
        vm.invoke(new SerializableRunnable(){

            @Override
            public void run() {
                Region region = CompressionCacheConfigDUnitTest.this.getCache().getRegion(regionName);
                TestCase.assertNotNull((Object)region);
                TestCase.assertTrue((boolean)compressor.equals(((LocalRegion)region).getCompressor()));
            }
        });
    }

    private boolean createCacheOnVM(VM vm, final String cacheXml) {
        return (Boolean)vm.invoke(new SerializableCallable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public Object call() throws Exception {
                try {
                    CacheTestCase.disconnectFromDS();
                    Properties props = new Properties();
                    props.setProperty("cache-xml-file", cacheXml);
                    DistributedTestCase.getLogWriter().info("<ExpectedException action=add>ClassNotFoundException</ExpectedException>");
                    CompressionCacheConfigDUnitTest.this.getSystem(props);
                    TestCase.assertNotNull((Object)CompressionCacheConfigDUnitTest.this.getCache());
                    Boolean bl = Boolean.TRUE;
                    return bl;
                }
                catch (Exception e) {
                    DistributedTestCase.getLogWriter().error("Could not create the cache", (Throwable)e);
                    Boolean bl = Boolean.FALSE;
                    return bl;
                }
                finally {
                    DistributedTestCase.getLogWriter().info("<ExpectedException action=remove>ClassNotFoundException</ExpectedException>");
                }
            }
        });
    }

    private File createCacheXml(String contents) throws IOException {
        File cacheXml = File.createTempFile("cache", "xml");
        PrintStream pstream = new PrintStream(cacheXml);
        pstream.print(contents);
        pstream.close();
        return cacheXml;
    }

    private VM getVM(int vm) {
        return Host.getHost(0).getVM(vm);
    }

    private void cleanup(VM vm) {
        vm.invoke(new SerializableRunnable(){

            @Override
            public void run() {
                Region region = CompressionCacheConfigDUnitTest.this.getCache().getRegion(CompressionCacheConfigDUnitTest.REGION_NAME);
                TestCase.assertNotNull((Object)region);
                region.destroyRegion();
                CacheTestCase.disconnectFromDS();
            }
        });
    }
}

