/*
 * Decompiled with CFR 0.152.
 */
package com.gemstone.gemfire.internal.compression;

import com.gemstone.gemfire.cache.CacheListener;
import com.gemstone.gemfire.cache.CacheWriter;
import com.gemstone.gemfire.cache.DataPolicy;
import com.gemstone.gemfire.cache.EntryEvent;
import com.gemstone.gemfire.cache.Region;
import com.gemstone.gemfire.cache.util.CacheListenerAdapter;
import com.gemstone.gemfire.cache.util.CacheWriterAdapter;
import com.gemstone.gemfire.cache30.CacheTestCase;
import com.gemstone.gemfire.compression.Compressor;
import com.gemstone.gemfire.compression.SnappyCompressor;
import com.gemstone.gemfire.internal.cache.EntryEventImpl;
import dunit.Host;
import dunit.SerializableCallable;
import dunit.SerializableRunnable;
import dunit.VM;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.TimeUnit;
import junit.framework.TestCase;

public class CompressionCacheListenerDUnitTest
extends CacheTestCase {
    public static final String REGION_NAME = "compressedRegion";
    public static final int TEST_VM = 0;
    public static final String KEY_1 = "key1";
    public static final String KEY_2 = "key2";
    public static final String KEY_3 = "key3";
    public static final String VALUE_1 = "Lorem ipsum dolor sit amet, consectetur adipiscing elit. Aliquam auctor bibendum tempus. Suspendisse potenti. Ut enim neque, mattis et mattis ac, vulputate quis leo. Cras a metus metus, eget cursus ipsum. Aliquam sagittis condimentum massa aliquet rhoncus. Aliquam sed luctus neque. In hac habitasse platea dictumst.";
    private static final String VALUE_2 = "Lorem ipsum dolor sit amet, consectetur adipiscing elit. Praesent sit amet lorem consequat est commodo lacinia. Duis tortor sem, facilisis quis tempus in, luctus lacinia metus. Vivamus augue justo, porttitor in vulputate accumsan, adipiscing sit amet sem. Quisque faucibus porta ipsum in pellentesque. Donec malesuada ultrices sapien sit amet tempus. Sed fringilla ipsum at tellus condimentum et hendrerit arcu pretium. Nulla non leo ligula. Etiam commodo tempor ligula non placerat. Vivamus vestibulum varius arcu a varius. Duis sit amet erat imperdiet dui mattis auctor et id orci. Suspendisse non elit augue. Quisque ac orci turpis, nec sollicitudin justo. Sed bibendum justo ut lacus aliquet lacinia et et neque. Proin hendrerit varius mauris vel lacinia. Proin pellentesque lacus vitae nisl euismod bibendum.";
    private static final String VALUE_3 = "In ut nisi nisi, eu malesuada mauris. Vestibulum nec tellus felis. Pellentesque mauris ligula, pretium nec consequat ut, adipiscing non lorem. Vivamus pulvinar viverra nisl, sit amet vestibulum tellus lobortis in. Pellentesque blandit ipsum sed neque rhoncus eu tristique risus porttitor. Vivamus molestie dapibus mi in lacinia. Suspendisse bibendum, purus at gravida accumsan, libero turpis elementum leo, eget posuere purus nibh ac dolor.";
    public static final BlockingQueue<EntryEvent> LISTENER_QUEUE = new LinkedBlockingQueue<EntryEvent>(1);
    private static final CacheListener<String, String> CACHE_LISTENER = new CacheListenerAdapter<String, String>(){

        public void afterCreate(EntryEvent<String, String> event) {
            LISTENER_QUEUE.add((EntryEvent)new EntryEventImpl((EntryEventImpl)event));
        }

        public void afterDestroy(EntryEvent<String, String> event) {
            LISTENER_QUEUE.add((EntryEvent)new EntryEventImpl((EntryEventImpl)event));
        }

        public void afterInvalidate(EntryEvent<String, String> event) {
            LISTENER_QUEUE.add((EntryEvent)new EntryEventImpl((EntryEventImpl)event));
        }

        public void afterUpdate(EntryEvent<String, String> event) {
            LISTENER_QUEUE.add((EntryEvent)new EntryEventImpl((EntryEventImpl)event));
        }
    };
    public static final BlockingQueue<EntryEvent> WRITER_QUEUE = new LinkedBlockingQueue<EntryEvent>(1);
    private static final CacheWriter<String, String> CACHE_WRITER = new CacheWriterAdapter<String, String>(){

        public void beforeCreate(EntryEvent<String, String> event) {
            WRITER_QUEUE.add((EntryEvent)new EntryEventImpl((EntryEventImpl)event));
        }

        public void beforeDestroy(EntryEvent<String, String> event) {
            WRITER_QUEUE.add((EntryEvent)new EntryEventImpl((EntryEventImpl)event));
        }

        public void beforeUpdate(EntryEvent<String, String> event) {
            WRITER_QUEUE.add((EntryEvent)new EntryEventImpl((EntryEventImpl)event));
        }
    };

    public CompressionCacheListenerDUnitTest(String name) {
        super(name);
    }

    @Override
    public void setUp() throws Exception {
        super.setUp();
        this.createRegion();
    }

    protected void createRegion() {
        try {
            SnappyCompressor.getDefaultInstance();
        }
        catch (Throwable t) {
            return;
        }
        this.createCompressedRegionOnVm(this.getVM(0), REGION_NAME, (Compressor)SnappyCompressor.getDefaultInstance());
    }

    @Override
    public void tearDown2() throws Exception {
        try {
            SnappyCompressor.getDefaultInstance();
            this.cleanup(this.getVM(0));
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        super.tearDown2();
    }

    protected VM getVM(int vm) {
        return Host.getHost(0).getVM(vm);
    }

    private void cleanup(VM vm) {
        vm.invoke(new SerializableRunnable(){

            @Override
            public void run() {
                CompressionCacheListenerDUnitTest.this.getCache().getRegion(CompressionCacheListenerDUnitTest.REGION_NAME).destroyRegion();
            }
        });
    }

    public void testCacheListenerAndWriter() {
        this.testCacheListenerAndWriterWithVM(this.getVM(0));
    }

    private void testCacheListenerAndWriterWithVM(VM vm) {
        try {
            SnappyCompressor.getDefaultInstance();
        }
        catch (Throwable t) {
            return;
        }
        vm.invoke(new SerializableRunnable(){

            @Override
            public void run() {
                try {
                    Region region = CompressionCacheListenerDUnitTest.this.getCache().getRegion(CompressionCacheListenerDUnitTest.REGION_NAME);
                    TestCase.assertNotNull((Object)region);
                    TestCase.assertNull((Object)region.get((Object)CompressionCacheListenerDUnitTest.KEY_1));
                    String oldValue = (String)region.put((Object)CompressionCacheListenerDUnitTest.KEY_1, (Object)CompressionCacheListenerDUnitTest.VALUE_1);
                    EntryEvent event = WRITER_QUEUE.poll(5L, TimeUnit.SECONDS);
                    TestCase.assertNotNull((Object)event);
                    TestCase.assertNull((Object)oldValue);
                    TestCase.assertNull((Object)event.getOldValue());
                    TestCase.assertEquals((String)CompressionCacheListenerDUnitTest.VALUE_1, (String)((String)event.getNewValue()));
                    TestCase.assertEquals((String)CompressionCacheListenerDUnitTest.KEY_1, (String)((String)event.getKey()));
                    event = LISTENER_QUEUE.poll(5L, TimeUnit.SECONDS);
                    TestCase.assertNotNull((Object)event);
                    TestCase.assertNull((Object)event.getOldValue());
                    TestCase.assertEquals((String)CompressionCacheListenerDUnitTest.VALUE_1, (String)((String)event.getNewValue()));
                    TestCase.assertEquals((String)CompressionCacheListenerDUnitTest.KEY_1, (String)((String)event.getKey()));
                    oldValue = (String)region.put((Object)CompressionCacheListenerDUnitTest.KEY_1, (Object)CompressionCacheListenerDUnitTest.VALUE_2);
                    event = WRITER_QUEUE.poll(5L, TimeUnit.SECONDS);
                    TestCase.assertNotNull((Object)event);
                    TestCase.assertNotNull((Object)oldValue);
                    TestCase.assertEquals((String)CompressionCacheListenerDUnitTest.VALUE_1, (String)oldValue);
                    TestCase.assertEquals((String)CompressionCacheListenerDUnitTest.VALUE_1, (String)((String)event.getOldValue()));
                    TestCase.assertEquals((String)CompressionCacheListenerDUnitTest.VALUE_2, (String)((String)event.getNewValue()));
                    TestCase.assertEquals((String)CompressionCacheListenerDUnitTest.KEY_1, (String)((String)event.getKey()));
                    event = LISTENER_QUEUE.poll(5L, TimeUnit.SECONDS);
                    TestCase.assertNotNull((Object)event);
                    TestCase.assertEquals((String)CompressionCacheListenerDUnitTest.VALUE_1, (String)((String)event.getOldValue()));
                    TestCase.assertEquals((String)CompressionCacheListenerDUnitTest.VALUE_2, (String)((String)event.getNewValue()));
                    TestCase.assertEquals((String)CompressionCacheListenerDUnitTest.KEY_1, (String)((String)event.getKey()));
                    region.invalidate((Object)CompressionCacheListenerDUnitTest.KEY_1);
                    event = LISTENER_QUEUE.poll(5L, TimeUnit.SECONDS);
                    TestCase.assertNotNull((Object)event);
                    TestCase.assertEquals((String)CompressionCacheListenerDUnitTest.VALUE_2, (String)((String)event.getOldValue()));
                    TestCase.assertNull((Object)event.getNewValue());
                    TestCase.assertEquals((String)CompressionCacheListenerDUnitTest.KEY_1, (String)((String)event.getKey()));
                    oldValue = (String)region.destroy((Object)CompressionCacheListenerDUnitTest.KEY_1);
                    event = WRITER_QUEUE.poll(5L, TimeUnit.SECONDS);
                    TestCase.assertNull((Object)oldValue);
                    TestCase.assertNotNull((Object)event);
                    TestCase.assertNull((Object)event.getOldValue());
                    TestCase.assertNull((Object)event.getNewValue());
                    TestCase.assertEquals((String)CompressionCacheListenerDUnitTest.KEY_1, (String)((String)event.getKey()));
                    event = LISTENER_QUEUE.poll(5L, TimeUnit.SECONDS);
                    TestCase.assertNotNull((Object)event);
                    TestCase.assertNull((Object)event.getOldValue());
                    TestCase.assertNull((Object)event.getNewValue());
                    TestCase.assertEquals((String)CompressionCacheListenerDUnitTest.KEY_1, (String)((String)event.getKey()));
                }
                catch (InterruptedException e) {
                    TestCase.fail();
                }
            }
        });
    }

    private boolean createCompressedRegionOnVm(VM vm, String name, Compressor compressor) {
        return this.createCompressedRegionOnVm(vm, name, compressor, false);
    }

    protected boolean createCompressedRegionOnVm(VM vm, final String name, final Compressor compressor, final boolean offHeap) {
        return (Boolean)vm.invoke(new SerializableCallable(){

            public Object call() throws Exception {
                try {
                    CompressionCacheListenerDUnitTest.this.createRegion(name, compressor, offHeap);
                }
                catch (IllegalStateException e) {
                    return Boolean.FALSE;
                }
                return Boolean.TRUE;
            }
        });
    }

    private Region createRegion(String name, Compressor compressor, boolean offHeap) {
        return this.getCache().createRegionFactory().addCacheListener(CACHE_LISTENER).setCacheWriter(CACHE_WRITER).setDataPolicy(DataPolicy.REPLICATE).setCompressor(compressor).setEnableOffHeapMemory(offHeap).create(name);
    }
}

