/*
 * Decompiled with CFR 0.152.
 */
package com.gemstone.gemfire.internal.compression;

import com.gemstone.gemfire.cache.DataPolicy;
import com.gemstone.gemfire.cache.Region;
import com.gemstone.gemfire.cache.client.ClientCache;
import com.gemstone.gemfire.cache.client.ClientCacheFactory;
import com.gemstone.gemfire.cache.client.ClientRegionShortcut;
import com.gemstone.gemfire.cache.server.CacheServer;
import com.gemstone.gemfire.cache30.CacheTestCase;
import com.gemstone.gemfire.compression.Compressor;
import com.gemstone.gemfire.compression.SnappyCompressor;
import dunit.DistributedTestCase;
import dunit.Host;
import dunit.SerializableCallable;
import dunit.SerializableRunnable;
import dunit.VM;
import dunit.eclipse.DUnitLauncher;
import java.io.IOException;
import junit.framework.TestCase;

public class CompressionRegionConfigDUnitTest
extends CacheTestCase {
    public static final String REGION_NAME = "compressedRegion";
    public static final String DISK_STORE = "diskStore";
    public static final String KEY_1 = "key1";
    public static final String VALUE_1 = "Lorem ipsum dolor sit amet, consectetur adipiscing elit. Aliquam auctor bibendum tempus. Suspendisse potenti. Ut enim neque, mattis et mattis ac, vulputate quis leo. Cras a metus metus, eget cursus ipsum. Aliquam sagittis condimentum massa aliquet rhoncus. Aliquam sed luctus neque. In hac habitasse platea dictumst.";

    public CompressionRegionConfigDUnitTest(String name) {
        super(name);
    }

    @Override
    public void setUp() throws Exception {
        super.setUp();
    }

    @Override
    public void tearDown2() throws Exception {
        super.tearDown2();
    }

    public void testReplicateRegion() throws Exception {
        SnappyCompressor compressor = null;
        try {
            compressor = SnappyCompressor.getDefaultInstance();
        }
        catch (Throwable t) {
            return;
        }
        CompressionRegionConfigDUnitTest.assertTrue((boolean)this.createCompressedRegionOnVm(this.getVM(0), REGION_NAME, DataPolicy.REPLICATE, (Compressor)compressor));
        CompressionRegionConfigDUnitTest.assertTrue((boolean)this.createCompressedRegionOnVm(this.getVM(1), REGION_NAME, DataPolicy.REPLICATE, (Compressor)compressor));
        CompressionRegionConfigDUnitTest.assertNull((Object)this.putUsingVM(this.getVM(0), KEY_1, VALUE_1));
        this.waitOnPut(this.getVM(1), KEY_1);
        CompressionRegionConfigDUnitTest.assertEquals((String)VALUE_1, (String)this.getUsingVM(this.getVM(1), KEY_1));
        this.cleanup(this.getVM(0));
    }

    public void testReplicatePersistentRegion() throws Exception {
        SnappyCompressor compressor = null;
        try {
            compressor = SnappyCompressor.getDefaultInstance();
        }
        catch (Throwable t) {
            return;
        }
        CompressionRegionConfigDUnitTest.assertTrue((boolean)this.createCompressedRegionOnVm(this.getVM(0), REGION_NAME, DataPolicy.PERSISTENT_REPLICATE, (Compressor)compressor, DISK_STORE));
        CompressionRegionConfigDUnitTest.assertTrue((boolean)this.createCompressedRegionOnVm(this.getVM(1), REGION_NAME, DataPolicy.PERSISTENT_REPLICATE, (Compressor)compressor));
        CompressionRegionConfigDUnitTest.assertNull((Object)this.putUsingVM(this.getVM(0), KEY_1, VALUE_1));
        this.waitOnPut(this.getVM(1), KEY_1);
        this.flushDiskStoreOnVM(this.getVM(0), DISK_STORE);
        this.closeRegionOnVM(this.getVM(1), REGION_NAME);
        CompressionRegionConfigDUnitTest.assertTrue((boolean)this.createCompressedRegionOnVm(this.getVM(1), REGION_NAME, DataPolicy.PERSISTENT_REPLICATE, (Compressor)compressor));
        CompressionRegionConfigDUnitTest.assertEquals((String)VALUE_1, (String)this.getUsingVM(this.getVM(1), KEY_1));
        this.cleanup(this.getVM(0));
    }

    public void testPartitionedRegion() {
        SnappyCompressor compressor = null;
        try {
            compressor = SnappyCompressor.getDefaultInstance();
        }
        catch (Throwable t) {
            return;
        }
        CompressionRegionConfigDUnitTest.assertTrue((boolean)this.createCompressedRegionOnVm(this.getVM(0), REGION_NAME, DataPolicy.PARTITION, (Compressor)compressor));
        CompressionRegionConfigDUnitTest.assertTrue((boolean)this.createCompressedRegionOnVm(this.getVM(1), REGION_NAME, DataPolicy.PARTITION, (Compressor)compressor));
        CompressionRegionConfigDUnitTest.assertNull((Object)this.putUsingVM(this.getVM(0), KEY_1, VALUE_1));
        this.waitOnPut(this.getVM(1), KEY_1);
        CompressionRegionConfigDUnitTest.assertEquals((String)VALUE_1, (String)this.getUsingVM(this.getVM(1), KEY_1));
        this.cleanup(this.getVM(0));
    }

    public void testPartitionedPersistentRegion() {
        SnappyCompressor compressor = null;
        try {
            compressor = SnappyCompressor.getDefaultInstance();
        }
        catch (Throwable t) {
            return;
        }
        CompressionRegionConfigDUnitTest.assertTrue((boolean)this.createCompressedRegionOnVm(this.getVM(0), REGION_NAME, DataPolicy.PERSISTENT_PARTITION, (Compressor)compressor, DISK_STORE));
        CompressionRegionConfigDUnitTest.assertTrue((boolean)this.createCompressedRegionOnVm(this.getVM(1), REGION_NAME, DataPolicy.PERSISTENT_PARTITION, (Compressor)compressor));
        CompressionRegionConfigDUnitTest.assertNull((Object)this.putUsingVM(this.getVM(0), KEY_1, VALUE_1));
        this.waitOnPut(this.getVM(1), KEY_1);
        this.flushDiskStoreOnVM(this.getVM(0), DISK_STORE);
        this.closeRegionOnVM(this.getVM(1), REGION_NAME);
        CompressionRegionConfigDUnitTest.assertTrue((boolean)this.createCompressedRegionOnVm(this.getVM(1), REGION_NAME, DataPolicy.PERSISTENT_PARTITION, (Compressor)compressor));
        CompressionRegionConfigDUnitTest.assertEquals((String)VALUE_1, (String)this.getUsingVM(this.getVM(1), KEY_1));
        this.cleanup(this.getVM(0));
    }

    public void testClientProxyRegion() {
        SnappyCompressor compressor = null;
        try {
            compressor = SnappyCompressor.getDefaultInstance();
        }
        catch (Throwable t) {
            return;
        }
        CompressionRegionConfigDUnitTest.assertTrue((boolean)this.createCompressedServerRegionOnVm(this.getVM(0), REGION_NAME, DataPolicy.REPLICATE, (Compressor)compressor));
        CompressionRegionConfigDUnitTest.assertTrue((boolean)this.createCompressedClientRegionOnVm(this.getVM(1), REGION_NAME, (Compressor)compressor, ClientRegionShortcut.PROXY));
        CompressionRegionConfigDUnitTest.assertNull((Object)this.putUsingClientVM(this.getVM(1), KEY_1, VALUE_1));
        CompressionRegionConfigDUnitTest.assertEquals((String)VALUE_1, (String)this.getUsingClientVM(this.getVM(1), KEY_1));
        CompressionRegionConfigDUnitTest.assertEquals((String)VALUE_1, (String)this.getUsingVM(this.getVM(0), KEY_1));
        this.cleanupClient(this.getVM(1));
        this.cleanup(this.getVM(0));
    }

    public void testCachingClientProxyRegion() {
        SnappyCompressor compressor = null;
        try {
            compressor = SnappyCompressor.getDefaultInstance();
        }
        catch (Throwable t) {
            return;
        }
        CompressionRegionConfigDUnitTest.assertTrue((boolean)this.createCompressedServerRegionOnVm(this.getVM(0), REGION_NAME, DataPolicy.REPLICATE, (Compressor)compressor));
        CompressionRegionConfigDUnitTest.assertTrue((boolean)this.createCompressedClientRegionOnVm(this.getVM(1), REGION_NAME, (Compressor)compressor, ClientRegionShortcut.CACHING_PROXY));
        CompressionRegionConfigDUnitTest.assertNull((Object)this.putUsingClientVM(this.getVM(1), KEY_1, VALUE_1));
        CompressionRegionConfigDUnitTest.assertEquals((String)VALUE_1, (String)this.getUsingClientVM(this.getVM(1), KEY_1));
        CompressionRegionConfigDUnitTest.assertEquals((String)VALUE_1, (String)this.getUsingVM(this.getVM(0), KEY_1));
        this.cleanupClient(this.getVM(1));
        this.cleanup(this.getVM(0));
    }

    private void closeRegionOnVM(VM vm, final String region) {
        vm.invoke(new SerializableRunnable(){

            @Override
            public void run() {
                CompressionRegionConfigDUnitTest.this.getCache().getRegion(region).close();
            }
        });
    }

    private void flushDiskStoreOnVM(VM vm, final String diskStore) {
        vm.invoke(new SerializableRunnable(){

            @Override
            public void run() {
                CompressionRegionConfigDUnitTest.this.getCache().findDiskStore(diskStore).flush();
            }
        });
    }

    private void waitOnPut(final VM vm, final String key) {
        DistributedTestCase.waitForCriterion(new DistributedTestCase.WaitCriterion(){

            @Override
            public boolean done() {
                return CompressionRegionConfigDUnitTest.this.getUsingVM(vm, key) != null;
            }

            @Override
            public String description() {
                return "Waiting on " + key + " to replicate.";
            }
        }, 2000L, 500L, true);
    }

    private String putUsingClientVM(VM vm, final String key, final String value) {
        return (String)vm.invoke(new SerializableCallable(){

            public Object call() throws Exception {
                ClientCache cache = CompressionRegionConfigDUnitTest.this.getClientCache(CompressionRegionConfigDUnitTest.this.getClientCacheFactory(CompressionRegionConfigDUnitTest.this.getLocatorPort()));
                Region region = cache.getRegion(CompressionRegionConfigDUnitTest.REGION_NAME);
                TestCase.assertNotNull((Object)region);
                return region.put((Object)key, (Object)value);
            }
        });
    }

    private String putUsingVM(VM vm, final String key, final String value) {
        return (String)vm.invoke(new SerializableCallable(){

            public Object call() throws Exception {
                Region region = CompressionRegionConfigDUnitTest.this.getCache().getRegion(CompressionRegionConfigDUnitTest.REGION_NAME);
                TestCase.assertNotNull((Object)region);
                return region.put((Object)key, (Object)value);
            }
        });
    }

    private String getUsingClientVM(VM vm, final String key) {
        return (String)vm.invoke(new SerializableCallable(){

            public Object call() throws Exception {
                ClientCache cache = CompressionRegionConfigDUnitTest.this.getClientCache(CompressionRegionConfigDUnitTest.this.getClientCacheFactory(CompressionRegionConfigDUnitTest.this.getLocatorPort()));
                Region region = cache.getRegion(CompressionRegionConfigDUnitTest.REGION_NAME);
                TestCase.assertNotNull((Object)region);
                return region.get((Object)key);
            }
        });
    }

    private String getUsingVM(VM vm, final String key) {
        return (String)vm.invoke(new SerializableCallable(){

            public Object call() throws Exception {
                Region region = CompressionRegionConfigDUnitTest.this.getCache().getRegion(CompressionRegionConfigDUnitTest.REGION_NAME);
                TestCase.assertNotNull((Object)region);
                return region.get((Object)key);
            }
        });
    }

    private VM getVM(int vm) {
        return Host.getHost(0).getVM(vm);
    }

    private void cleanupClient(VM vm) {
        vm.invoke(new SerializableRunnable(){

            @Override
            public void run() {
                CompressionRegionConfigDUnitTest.this.getClientCache(CompressionRegionConfigDUnitTest.this.getClientCacheFactory(CompressionRegionConfigDUnitTest.this.getLocatorPort())).getRegion(CompressionRegionConfigDUnitTest.REGION_NAME).close();
            }
        });
    }

    private void cleanup(VM vm) {
        vm.invoke(new SerializableRunnable(){

            @Override
            public void run() {
                Region region = CompressionRegionConfigDUnitTest.this.getCache().getRegion(CompressionRegionConfigDUnitTest.REGION_NAME);
                TestCase.assertNotNull((Object)region);
                region.destroyRegion();
            }
        });
    }

    private boolean createCompressedServerRegionOnVm(VM vm, final String name, final DataPolicy dataPolicy, final Compressor compressor) {
        return (Boolean)vm.invoke(new SerializableCallable(){

            public Object call() throws Exception {
                try {
                    TestCase.assertNotNull((Object)CompressionRegionConfigDUnitTest.this.createServerRegion(name, dataPolicy, compressor));
                }
                catch (Exception e) {
                    DistributedTestCase.getLogWriter().error("Could not create the compressed region", (Throwable)e);
                    return Boolean.FALSE;
                }
                return Boolean.TRUE;
            }
        });
    }

    private boolean createCompressedRegionOnVm(VM vm, final String name, final DataPolicy dataPolicy, final Compressor compressor) {
        return (Boolean)vm.invoke(new SerializableCallable(){

            public Object call() throws Exception {
                try {
                    TestCase.assertNotNull((Object)CompressionRegionConfigDUnitTest.this.createRegion(name, dataPolicy, compressor));
                }
                catch (Exception e) {
                    DistributedTestCase.getLogWriter().error("Could not create the compressed region", (Throwable)e);
                    return Boolean.FALSE;
                }
                return Boolean.TRUE;
            }
        });
    }

    private boolean createCompressedRegionOnVm(VM vm, final String name, final DataPolicy dataPolicy, final Compressor compressor, final String diskStoreName) {
        return (Boolean)vm.invoke(new SerializableCallable(){

            public Object call() throws Exception {
                try {
                    TestCase.assertNotNull((Object)CompressionRegionConfigDUnitTest.this.createRegion(name, dataPolicy, compressor, diskStoreName));
                }
                catch (Exception e) {
                    DistributedTestCase.getLogWriter().error("Could not create the compressed region", (Throwable)e);
                    return Boolean.FALSE;
                }
                return Boolean.TRUE;
            }
        });
    }

    private boolean createCompressedClientRegionOnVm(VM vm, final String name, final Compressor compressor, final ClientRegionShortcut shortcut) {
        return (Boolean)vm.invoke(new SerializableCallable(){

            public Object call() throws Exception {
                try {
                    TestCase.assertNotNull((Object)CompressionRegionConfigDUnitTest.this.createClientRegion(name, compressor, shortcut));
                }
                catch (Exception e) {
                    DistributedTestCase.getLogWriter().error("Could not create the compressed region", (Throwable)e);
                    return Boolean.FALSE;
                }
                return Boolean.TRUE;
            }
        });
    }

    private Region<String, String> createClientRegion(String name, Compressor compressor, ClientRegionShortcut shortcut) {
        ClientCacheFactory factory = this.getClientCacheFactory(this.getLocatorPort());
        return this.getClientCache(factory).createClientRegionFactory(shortcut).setCloningEnabled(true).setCompressor(compressor).create(name);
    }

    private Region<String, String> createRegion(String name, DataPolicy dataPolicy, Compressor compressor) {
        return this.getCache().createRegionFactory().setDataPolicy(dataPolicy).setCloningEnabled(true).setCompressor(compressor).create(name);
    }

    private Region<String, String> createServerRegion(String name, DataPolicy dataPolicy, Compressor compressor) throws IOException {
        Region region = this.getCache().createRegionFactory().setDataPolicy(dataPolicy).setCloningEnabled(true).setCompressor(compressor).create(name);
        CacheServer server = this.getCache().addCacheServer();
        server.start();
        return region;
    }

    private Region<String, String> createRegion(String name, DataPolicy dataPolicy, Compressor compressor, String diskStoreName) {
        this.getCache().createDiskStoreFactory().create(diskStoreName);
        return this.getCache().createRegionFactory().setDataPolicy(dataPolicy).setDiskStoreName(diskStoreName).setCloningEnabled(true).setCompressor(compressor).create(name);
    }

    private ClientCacheFactory getClientCacheFactory(int dunitLocatorPort) {
        return new ClientCacheFactory().addPoolLocator("localhost", dunitLocatorPort).setPoolSubscriptionEnabled(true);
    }

    private int getLocatorPort() {
        if (DUnitLauncher.isLaunched()) {
            String locatorString = DUnitLauncher.getLocatorString();
            int index = locatorString.indexOf("[");
            return Integer.parseInt(locatorString.substring(index + 1, locatorString.length() - 1));
        }
        return CompressionRegionConfigDUnitTest.getDUnitLocatorPort();
    }
}

