/*
 * Decompiled with CFR 0.152.
 */
package com.gemstone.gemfire.internal.compression;

import com.gemstone.gemfire.cache.DataPolicy;
import com.gemstone.gemfire.cache.Region;
import com.gemstone.gemfire.cache30.CacheTestCase;
import com.gemstone.gemfire.compression.Compressor;
import com.gemstone.gemfire.internal.cache.CachePerfStats;
import com.gemstone.gemfire.internal.cache.GemFireCacheImpl;
import com.gemstone.gemfire.internal.cache.LocalRegion;
import dunit.Host;
import dunit.SerializableCallable;
import dunit.SerializableRunnable;
import dunit.VM;
import java.io.Serializable;
import junit.framework.TestCase;

public class CompressionStatsDUnitTest
extends CacheTestCase {
    public static final String REGION_NAME = "compressedRegion";
    public static final String REGION_NAME_2 = "compressedRegion2";
    public static final int TEST_VM = 0;
    private static int index = 0;
    private final byte[] PRE_COMPRESS_BYTES = "1234567890123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890".getBytes();

    public CompressionStatsDUnitTest(String name) {
        super(name);
    }

    private void assertStartingValues(VM vm) {
        CompressionStatsDUnitTest.assertEquals((long)0L, (long)this.getTotalCompressionTimeOnVm(vm, null));
        CompressionStatsDUnitTest.assertEquals((long)0L, (long)this.getTotalCompressionTimeOnVm(vm, REGION_NAME));
        CompressionStatsDUnitTest.assertEquals((long)0L, (long)this.getTotalCompressionTimeOnVm(vm, REGION_NAME_2));
        CompressionStatsDUnitTest.assertEquals((long)0L, (long)this.getTotalDecompressionTimeOnVm(vm, null));
        CompressionStatsDUnitTest.assertEquals((long)0L, (long)this.getTotalDecompressionTimeOnVm(vm, REGION_NAME));
        CompressionStatsDUnitTest.assertEquals((long)0L, (long)this.getTotalDecompressionTimeOnVm(vm, REGION_NAME_2));
        CompressionStatsDUnitTest.assertEquals((long)0L, (long)this.getTotalCompressionsOnVm(vm, null));
        CompressionStatsDUnitTest.assertEquals((long)0L, (long)this.getTotalCompressionsOnVm(vm, REGION_NAME));
        CompressionStatsDUnitTest.assertEquals((long)0L, (long)this.getTotalCompressionsOnVm(vm, REGION_NAME_2));
        CompressionStatsDUnitTest.assertEquals((long)0L, (long)this.getTotalDecompressionsOnVm(vm, null));
        CompressionStatsDUnitTest.assertEquals((long)0L, (long)this.getTotalDecompressionsOnVm(vm, REGION_NAME));
        CompressionStatsDUnitTest.assertEquals((long)0L, (long)this.getTotalDecompressionsOnVm(vm, REGION_NAME_2));
        CompressionStatsDUnitTest.assertEquals((long)0L, (long)this.getTotalPreCompressedBytesOnVm(vm, null));
        CompressionStatsDUnitTest.assertEquals((long)0L, (long)this.getTotalPreCompressedBytesOnVm(vm, REGION_NAME));
        CompressionStatsDUnitTest.assertEquals((long)0L, (long)this.getTotalPreCompressedBytesOnVm(vm, REGION_NAME_2));
        CompressionStatsDUnitTest.assertEquals((long)0L, (long)this.getTotalPostCompressedBytesOnVm(vm, null));
        CompressionStatsDUnitTest.assertEquals((long)0L, (long)this.getTotalPostCompressedBytesOnVm(vm, REGION_NAME));
        CompressionStatsDUnitTest.assertEquals((long)0L, (long)this.getTotalPostCompressedBytesOnVm(vm, REGION_NAME_2));
    }

    private void assertRegionOneStats(VM vm, CompressionStats stats) {
        this.doPutsOnVm(vm, REGION_NAME, 100);
        stats.vmTotalCompressionTime = this.getTotalCompressionTimeOnVm(vm, null);
        CompressionStatsDUnitTest.assertTrue((stats.vmTotalCompressionTime > 0L ? 1 : 0) != 0);
        stats.region1TotalCompressionTime = this.getTotalCompressionTimeOnVm(vm, REGION_NAME);
        CompressionStatsDUnitTest.assertTrue((stats.region1TotalCompressionTime > 0L ? 1 : 0) != 0);
        stats.region2TotalCompressionTime = this.getTotalCompressionTimeOnVm(vm, REGION_NAME_2);
        CompressionStatsDUnitTest.assertEquals((long)0L, (long)stats.region2TotalCompressionTime);
        stats.vmTotalDecompressionTime = this.getTotalDecompressionTimeOnVm(vm, null);
        CompressionStatsDUnitTest.assertEquals((long)0L, (long)stats.vmTotalDecompressionTime);
        stats.region1TotalDecompressionTime = this.getTotalDecompressionTimeOnVm(vm, REGION_NAME);
        CompressionStatsDUnitTest.assertEquals((long)0L, (long)stats.region1TotalDecompressionTime);
        stats.region2TotalDecompressionTime = this.getTotalDecompressionTimeOnVm(vm, REGION_NAME_2);
        CompressionStatsDUnitTest.assertEquals((long)0L, (long)stats.region2TotalDecompressionTime);
        stats.vmTotalCompressions = this.getTotalCompressionsOnVm(vm, null);
        CompressionStatsDUnitTest.assertEquals((long)100L, (long)stats.vmTotalCompressions);
        stats.region1TotalCompressions = this.getTotalCompressionsOnVm(vm, REGION_NAME);
        CompressionStatsDUnitTest.assertEquals((long)100L, (long)stats.region1TotalCompressions);
        stats.region2TotalCompressions = this.getTotalCompressionsOnVm(vm, REGION_NAME_2);
        CompressionStatsDUnitTest.assertEquals((long)0L, (long)stats.region2TotalCompressions);
        stats.vmTotalDecompressions = this.getTotalDecompressionsOnVm(vm, null);
        CompressionStatsDUnitTest.assertEquals((long)0L, (long)stats.vmTotalDecompressions);
        stats.region1TotalDecompressions = this.getTotalDecompressionsOnVm(vm, REGION_NAME);
        CompressionStatsDUnitTest.assertEquals((long)0L, (long)stats.region1TotalDecompressions);
        stats.region2TotalDecompressions = this.getTotalDecompressionsOnVm(vm, REGION_NAME_2);
        CompressionStatsDUnitTest.assertEquals((long)0L, (long)stats.region2TotalDecompressions);
        stats.vmTotalPreCompressedBytes = this.getTotalPreCompressedBytesOnVm(vm, null);
        CompressionStatsDUnitTest.assertEquals((long)10200L, (long)stats.vmTotalPreCompressedBytes);
        stats.region1TotalPreCompressedBytes = this.getTotalPreCompressedBytesOnVm(vm, REGION_NAME);
        CompressionStatsDUnitTest.assertEquals((long)10200L, (long)stats.region1TotalPreCompressedBytes);
        stats.region2TotalPreCompressedBytes = this.getTotalPreCompressedBytesOnVm(vm, REGION_NAME_2);
        CompressionStatsDUnitTest.assertEquals((long)0L, (long)stats.region2TotalPreCompressedBytes);
        stats.vmTotalPostCompressedBytes = this.getTotalPostCompressedBytesOnVm(vm, null);
        CompressionStatsDUnitTest.assertEquals((long)5000L, (long)stats.vmTotalPostCompressedBytes);
        stats.region1TotalPostCompressedBytes = this.getTotalPostCompressedBytesOnVm(vm, REGION_NAME);
        CompressionStatsDUnitTest.assertEquals((long)5000L, (long)stats.region1TotalPostCompressedBytes);
        stats.region2TotalPostCompressedBytes = this.getTotalPostCompressedBytesOnVm(vm, REGION_NAME_2);
        CompressionStatsDUnitTest.assertEquals((long)0L, (long)stats.region2TotalPostCompressedBytes);
    }

    private void assertRegionTwoStats(VM vm, CompressionStats stats) {
        this.doPutsOnVm(vm, REGION_NAME_2, 100);
        stats.vmTotalCompressionTime = this.getTotalCompressionTimeOnVm(vm, null);
        CompressionStatsDUnitTest.assertTrue((stats.vmTotalCompressionTime > 0L ? 1 : 0) != 0);
        stats.region1TotalCompressionTime = this.getTotalCompressionTimeOnVm(vm, REGION_NAME);
        CompressionStatsDUnitTest.assertTrue((stats.region1TotalCompressionTime > 0L ? 1 : 0) != 0);
        stats.region2TotalCompressionTime = this.getTotalCompressionTimeOnVm(vm, REGION_NAME_2);
        CompressionStatsDUnitTest.assertTrue((stats.region2TotalCompressionTime > 0L ? 1 : 0) != 0);
        stats.vmTotalDecompressionTime = this.getTotalDecompressionTimeOnVm(vm, null);
        CompressionStatsDUnitTest.assertEquals((long)0L, (long)stats.vmTotalDecompressionTime);
        stats.region1TotalDecompressionTime = this.getTotalDecompressionTimeOnVm(vm, REGION_NAME);
        CompressionStatsDUnitTest.assertEquals((long)0L, (long)stats.region1TotalDecompressionTime);
        stats.region2TotalDecompressionTime = this.getTotalDecompressionTimeOnVm(vm, REGION_NAME_2);
        CompressionStatsDUnitTest.assertEquals((long)0L, (long)stats.region2TotalDecompressionTime);
        stats.vmTotalCompressions = this.getTotalCompressionsOnVm(vm, null);
        CompressionStatsDUnitTest.assertEquals((long)200L, (long)stats.vmTotalCompressions);
        stats.region1TotalCompressions = this.getTotalCompressionsOnVm(vm, REGION_NAME);
        CompressionStatsDUnitTest.assertEquals((long)100L, (long)stats.region1TotalCompressions);
        stats.region2TotalCompressions = this.getTotalCompressionsOnVm(vm, REGION_NAME_2);
        CompressionStatsDUnitTest.assertEquals((long)100L, (long)stats.region2TotalCompressions);
        stats.vmTotalDecompressions = this.getTotalDecompressionsOnVm(vm, null);
        CompressionStatsDUnitTest.assertEquals((long)0L, (long)stats.vmTotalDecompressions);
        stats.region1TotalDecompressions = this.getTotalDecompressionsOnVm(vm, REGION_NAME);
        CompressionStatsDUnitTest.assertEquals((long)0L, (long)stats.region1TotalDecompressions);
        stats.region2TotalDecompressions = this.getTotalDecompressionsOnVm(vm, REGION_NAME_2);
        CompressionStatsDUnitTest.assertEquals((long)0L, (long)stats.region2TotalDecompressions);
        stats.vmTotalPreCompressedBytes = this.getTotalPreCompressedBytesOnVm(vm, null);
        CompressionStatsDUnitTest.assertEquals((long)20400L, (long)stats.vmTotalPreCompressedBytes);
        stats.region1TotalPreCompressedBytes = this.getTotalPreCompressedBytesOnVm(vm, REGION_NAME);
        CompressionStatsDUnitTest.assertEquals((long)10200L, (long)stats.region1TotalPreCompressedBytes);
        stats.region2TotalPreCompressedBytes = this.getTotalPreCompressedBytesOnVm(vm, REGION_NAME_2);
        CompressionStatsDUnitTest.assertEquals((long)10200L, (long)stats.region2TotalPreCompressedBytes);
        stats.vmTotalPostCompressedBytes = this.getTotalPostCompressedBytesOnVm(vm, null);
        CompressionStatsDUnitTest.assertEquals((long)10000L, (long)stats.vmTotalPostCompressedBytes);
        stats.region1TotalPostCompressedBytes = this.getTotalPostCompressedBytesOnVm(vm, REGION_NAME);
        CompressionStatsDUnitTest.assertEquals((long)5000L, (long)stats.region1TotalPostCompressedBytes);
        stats.region2TotalPostCompressedBytes = this.getTotalPostCompressedBytesOnVm(vm, REGION_NAME_2);
        CompressionStatsDUnitTest.assertEquals((long)5000L, (long)stats.region2TotalPostCompressedBytes);
    }

    private void assertRegionOneStatsAfterGets(VM vm, CompressionStats stats) {
        this.doGetsOnVm(vm, REGION_NAME);
        stats.vmTotalDecompressionTime = this.getTotalDecompressionTimeOnVm(vm, null);
        CompressionStatsDUnitTest.assertTrue((stats.vmTotalDecompressionTime > 0L ? 1 : 0) != 0);
        stats.region1TotalDecompressionTime = this.getTotalDecompressionTimeOnVm(vm, REGION_NAME);
        CompressionStatsDUnitTest.assertTrue((stats.region1TotalDecompressionTime > 0L ? 1 : 0) != 0);
        stats.region2TotalDecompressionTime = this.getTotalDecompressionTimeOnVm(vm, REGION_NAME_2);
        CompressionStatsDUnitTest.assertEquals((long)0L, (long)stats.region2TotalDecompressionTime);
        stats.vmTotalDecompressions = this.getTotalDecompressionsOnVm(vm, null);
        CompressionStatsDUnitTest.assertEquals((long)100L, (long)stats.vmTotalDecompressions);
        stats.region1TotalDecompressions = this.getTotalDecompressionsOnVm(vm, REGION_NAME);
        CompressionStatsDUnitTest.assertEquals((long)100L, (long)stats.region1TotalDecompressions);
        stats.region2TotalDecompressions = this.getTotalDecompressionsOnVm(vm, REGION_NAME_2);
        CompressionStatsDUnitTest.assertEquals((long)0L, (long)stats.region2TotalDecompressions);
        stats.vmTotalPostCompressedBytes = this.getTotalPostCompressedBytesOnVm(vm, null);
        CompressionStatsDUnitTest.assertEquals((long)10000L, (long)stats.vmTotalPostCompressedBytes);
        stats.region1TotalPostCompressedBytes = this.getTotalPostCompressedBytesOnVm(vm, REGION_NAME);
        CompressionStatsDUnitTest.assertEquals((long)5000L, (long)stats.region1TotalPostCompressedBytes);
        stats.region2TotalPostCompressedBytes = this.getTotalPostCompressedBytesOnVm(vm, REGION_NAME_2);
        CompressionStatsDUnitTest.assertEquals((long)5000L, (long)stats.region2TotalPostCompressedBytes);
    }

    private void assertStatTotals(CompressionStats stats) {
        CompressionStatsDUnitTest.assertEquals((long)stats.vmTotalPreCompressedBytes, (long)(stats.region1TotalPreCompressedBytes + stats.region2TotalPreCompressedBytes));
        CompressionStatsDUnitTest.assertEquals((long)stats.vmTotalCompressions, (long)(stats.region1TotalCompressions + stats.region2TotalCompressions));
        CompressionStatsDUnitTest.assertEquals((long)stats.vmTotalCompressionTime, (long)(stats.region1TotalCompressionTime + stats.region2TotalCompressionTime));
        CompressionStatsDUnitTest.assertEquals((long)stats.vmTotalPostCompressedBytes, (long)(stats.region1TotalPostCompressedBytes + stats.region2TotalPostCompressedBytes));
        CompressionStatsDUnitTest.assertEquals((long)stats.vmTotalDecompressions, (long)(stats.region1TotalDecompressions + stats.region2TotalDecompressions));
        CompressionStatsDUnitTest.assertEquals((long)stats.vmTotalDecompressionTime, (long)(stats.region1TotalDecompressionTime + stats.region2TotalDecompressionTime));
    }

    public void testCompressionStats() {
        VM vm = Host.getHost(0).getVM(0);
        CompressionStatsDUnitTest.assertTrue((boolean)this.createCompressedRegionOnVm(vm, REGION_NAME, new StatCompressor()));
        CompressionStatsDUnitTest.assertTrue((boolean)this.createCompressedRegionOnVm(vm, REGION_NAME_2, new StatCompressor()));
        boolean previousClockStatsValue = this.enableClockStatsOnVm(vm, true);
        CompressionStats stats = new CompressionStats();
        this.assertStartingValues(vm);
        this.assertRegionOneStats(vm, stats);
        this.assertRegionTwoStats(vm, stats);
        this.assertRegionOneStatsAfterGets(vm, stats);
        this.assertStatTotals(stats);
        this.destroyRegionOnVm(vm, REGION_NAME);
        this.destroyRegionOnVm(vm, REGION_NAME_2);
        this.enableClockStatsOnVm(vm, previousClockStatsValue);
    }

    private void doGetsOnVm(VM vm, final String regionName) {
        vm.invoke(new SerializableRunnable(){

            @Override
            public void run() {
                Region region = CompressionStatsDUnitTest.this.getCache().getRegion(regionName);
                TestCase.assertNotNull((Object)region);
                for (int i = 0; i < index / 2; ++i) {
                    TestCase.assertNotNull((Object)region.get((Object)i));
                }
            }
        });
    }

    private void doPutsOnVm(VM vm, final String regionName, final int puts) {
        vm.invoke(new SerializableRunnable(){

            @Override
            public void run() {
                Region region = CompressionStatsDUnitTest.this.getCache().getRegion(regionName);
                TestCase.assertNotNull((Object)region);
                for (int i = 0; i < puts; ++i) {
                    region.put((Object)index++, (Object)CompressionStatsDUnitTest.this.PRE_COMPRESS_BYTES);
                }
            }
        });
    }

    private long getTotalPostCompressedBytesOnVm(VM vm, final String regionName) {
        return (Long)vm.invoke(new SerializableCallable(){

            public Object call() throws Exception {
                if (null == regionName) {
                    return CompressionStatsDUnitTest.this.getTotalPostCompressedBytes();
                }
                return CompressionStatsDUnitTest.this.getTotalPostCompressedBytes(regionName);
            }
        });
    }

    private long getTotalPostCompressedBytes() {
        GemFireCacheImpl cache = (GemFireCacheImpl)this.getCache();
        return cache.getCachePerfStats().getTotalPostCompressedBytes();
    }

    private long getTotalPostCompressedBytes(String regionName) {
        LocalRegion region = (LocalRegion)this.getCache().getRegion(regionName);
        CompressionStatsDUnitTest.assertNotNull((Object)region);
        return region.getCachePerfStats().getTotalPostCompressedBytes();
    }

    private long getTotalPreCompressedBytesOnVm(VM vm, final String regionName) {
        return (Long)vm.invoke(new SerializableCallable(){

            public Object call() throws Exception {
                if (null == regionName) {
                    return CompressionStatsDUnitTest.this.getTotalPreCompressedBytes();
                }
                return CompressionStatsDUnitTest.this.getTotalPreCompressedBytes(regionName);
            }
        });
    }

    private long getTotalPreCompressedBytes() {
        GemFireCacheImpl cache = (GemFireCacheImpl)this.getCache();
        return cache.getCachePerfStats().getTotalPreCompressedBytes();
    }

    private long getTotalPreCompressedBytes(String regionName) {
        LocalRegion region = (LocalRegion)this.getCache().getRegion(regionName);
        CompressionStatsDUnitTest.assertNotNull((Object)region);
        return region.getCachePerfStats().getTotalPreCompressedBytes();
    }

    private long getTotalDecompressionsOnVm(VM vm, final String regionName) {
        return (Long)vm.invoke(new SerializableCallable(){

            public Object call() throws Exception {
                if (null == regionName) {
                    return CompressionStatsDUnitTest.this.getTotalDecompressions();
                }
                return CompressionStatsDUnitTest.this.getTotalDecompressions(regionName);
            }
        });
    }

    private long getTotalDecompressions() {
        GemFireCacheImpl cache = (GemFireCacheImpl)this.getCache();
        return cache.getCachePerfStats().getTotalDecompressions();
    }

    private long getTotalDecompressions(String regionName) {
        LocalRegion region = (LocalRegion)this.getCache().getRegion(regionName);
        CompressionStatsDUnitTest.assertNotNull((Object)region);
        return region.getCachePerfStats().getTotalDecompressions();
    }

    private long getTotalCompressionsOnVm(VM vm, final String regionName) {
        return (Long)vm.invoke(new SerializableCallable(){

            public Object call() throws Exception {
                if (null == regionName) {
                    return CompressionStatsDUnitTest.this.getTotalCompressions();
                }
                return CompressionStatsDUnitTest.this.getTotalCompressions(regionName);
            }
        });
    }

    private long getTotalCompressions() {
        GemFireCacheImpl cache = (GemFireCacheImpl)this.getCache();
        return cache.getCachePerfStats().getTotalCompressions();
    }

    private long getTotalCompressions(String regionName) {
        LocalRegion region = (LocalRegion)this.getCache().getRegion(regionName);
        CompressionStatsDUnitTest.assertNotNull((Object)region);
        return region.getCachePerfStats().getTotalCompressions();
    }

    private long getTotalDecompressionTimeOnVm(VM vm, final String regionName) {
        return (Long)vm.invoke(new SerializableCallable(){

            public Object call() throws Exception {
                if (null == regionName) {
                    return CompressionStatsDUnitTest.this.getTotalDecompressionTime();
                }
                return CompressionStatsDUnitTest.this.getTotalDecompressionTime(regionName);
            }
        });
    }

    private long getTotalDecompressionTime() {
        GemFireCacheImpl cache = (GemFireCacheImpl)this.getCache();
        return cache.getCachePerfStats().getTotalDecompressionTime();
    }

    private long getTotalDecompressionTime(String regionName) {
        LocalRegion region = (LocalRegion)this.getCache().getRegion(regionName);
        CompressionStatsDUnitTest.assertNotNull((Object)region);
        return region.getCachePerfStats().getTotalDecompressionTime();
    }

    private long getTotalCompressionTimeOnVm(VM vm, final String regionName) {
        return (Long)vm.invoke(new SerializableCallable(){

            public Object call() throws Exception {
                if (null == regionName) {
                    return CompressionStatsDUnitTest.this.getTotalCompressionTime();
                }
                return CompressionStatsDUnitTest.this.getTotalCompressionTime(regionName);
            }
        });
    }

    private long getTotalCompressionTime() {
        GemFireCacheImpl cache = (GemFireCacheImpl)this.getCache();
        return cache.getCachePerfStats().getTotalCompressionTime();
    }

    private long getTotalCompressionTime(String regionName) {
        LocalRegion region = (LocalRegion)this.getCache().getRegion(regionName);
        CompressionStatsDUnitTest.assertNotNull((Object)region);
        return region.getCachePerfStats().getTotalCompressionTime();
    }

    private void destroyRegionOnVm(VM vm, final String regionName) {
        vm.invoke(new SerializableRunnable(){

            @Override
            public void run() {
                CompressionStatsDUnitTest.this.destroyRegion(regionName);
            }
        });
    }

    private void destroyRegion(String regionName) {
        Region region = this.getCache().getRegion(regionName);
        CompressionStatsDUnitTest.assertNotNull((Object)region);
        region.destroyRegion();
    }

    private boolean createCompressedRegionOnVm(VM vm, final String name, final Compressor compressor) {
        return (Boolean)vm.invoke(new SerializableCallable(){

            public Object call() throws Exception {
                try {
                    CompressionStatsDUnitTest.this.createRegion(name, compressor);
                }
                catch (IllegalStateException e) {
                    return Boolean.FALSE;
                }
                return Boolean.TRUE;
            }
        });
    }

    private Region createRegion(String name, Compressor compressor) {
        return this.getCache().createRegionFactory().setDataPolicy(DataPolicy.REPLICATE).setCloningEnabled(true).setCompressor(compressor).create(name);
    }

    private boolean enableClockStatsOnVm(VM vm, final boolean clockStatsEnabled) {
        return (Boolean)vm.invoke(new SerializableCallable(){

            public Object call() {
                return CompressionStatsDUnitTest.this.enableClockStats(clockStatsEnabled);
            }
        });
    }

    private boolean enableClockStats(boolean clockStatsEnabled) {
        boolean oldValue = CachePerfStats.enableClockStats;
        CachePerfStats.enableClockStats = clockStatsEnabled;
        return oldValue;
    }

    private static final class CompressionStats {
        long vmTotalCompressionTime = 0L;
        long region1TotalCompressionTime = 0L;
        long region2TotalCompressionTime = 0L;
        long vmTotalDecompressionTime = 0L;
        long region1TotalDecompressionTime = 0L;
        long region2TotalDecompressionTime = 0L;
        long vmTotalCompressions = 0L;
        long region1TotalCompressions = 0L;
        long region2TotalCompressions = 0L;
        long vmTotalDecompressions = 0L;
        long region1TotalDecompressions = 0L;
        long region2TotalDecompressions = 0L;
        long vmTotalPreCompressedBytes = 0L;
        long region1TotalPreCompressedBytes = 0L;
        long region2TotalPreCompressedBytes = 0L;
        long vmTotalPostCompressedBytes = 0L;
        long region1TotalPostCompressedBytes = 0L;
        long region2TotalPostCompressedBytes = 0L;

        private CompressionStats() {
        }
    }

    public static final class StatCompressor
    implements Compressor,
    Serializable {
        private static final long serialVersionUID = 8116784819434199537L;
        private final byte[] POST_COMPRESS_BYTES = "12345678901234567890123456789012345678901234567890".getBytes();
        static byte[] savedCompressInput = null;

        public byte[] compress(byte[] input) {
            if (savedCompressInput == null) {
                savedCompressInput = input;
            }
            return this.POST_COMPRESS_BYTES;
        }

        public byte[] decompress(byte[] input) {
            return savedCompressInput;
        }
    }
}

