/*
 * Decompiled with CFR 0.152.
 */
package com.gemstone.gemfire.internal.jta.dunit;

import com.gemstone.gemfire.cache.Cache;
import com.gemstone.gemfire.cache.CacheFactory;
import com.gemstone.gemfire.distributed.DistributedSystem;
import dunit.AsyncInvocation;
import dunit.DistributedTestCase;
import dunit.Host;
import dunit.VM;
import hydra.ProcessMgr;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.IOException;
import java.io.OutputStreamWriter;
import java.sql.Connection;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.Properties;
import javax.naming.Context;
import javax.naming.NamingException;
import javax.sql.DataSource;

public class BlockingTimeOutDUnitTest
extends DistributedTestCase {
    static DistributedSystem ds;
    static Cache cache;
    private static String tblName;
    private static final int BLOCKING_TIMEOUT = 1;

    private static String readFile(String filename) throws IOException {
        BufferedReader br = new BufferedReader(new FileReader(filename));
        String nextLine = "";
        StringBuffer sb = new StringBuffer();
        while ((nextLine = br.readLine()) != null) {
            sb.append(nextLine);
        }
        BlockingTimeOutDUnitTest.getLogWriter().fine("***********\n " + sb);
        return sb.toString();
    }

    public BlockingTimeOutDUnitTest(String name) {
        super(name);
    }

    private static String modifyFile(String str) throws IOException {
        String search = "<jndi-binding type=\"XAPooledDataSource\"";
        String last_search = "</jndi-binding>";
        String newDB = "newDB_" + ProcessMgr.getProcessId();
        String jndi_str = "<jndi-binding type=\"XAPooledDataSource\" jndi-name=\"XAPooledDataSource\"\t\t              jdbc-driver-class=\"org.apache.derby.jdbc.EmbeddedDriver\" init-pool-size=\"1\" max-pool-size=\"2\" idle-timeout-seconds=\"600\" blocking-timeout-seconds=\"1\" login-timeout-seconds=\"25\" conn-pooled-datasource-class=\"org.apache.derby.jdbc.EmbeddedConnectionPoolDataSource\" xa-datasource-class=\"org.apache.derby.jdbc.EmbeddedXADataSource\" user-name=\"mitul\" password=\"83f0069202c571faf1ae6c42b4ad46030e4e31c17409e19a\" connection-url=\"jdbc:derby:" + newDB + ";create=true\" >";
        String config_prop = "<config-property><config-property-name>description</config-property-name><config-property-type>java.lang.String</config-property-type><config-property-value>hi</config-property-value></config-property><config-property><config-property-name>user</config-property-name><config-property-type>java.lang.String</config-property-type><config-property-value>mitul</config-property-value></config-property><config-property><config-property-name>password</config-property-name><config-property-type>java.lang.String</config-property-type><config-property-value>83f0069202c571faf1ae6c42b4ad46030e4e31c17409e19a</config-property-value>\t</config-property><config-property><config-property-name>databaseName</config-property-name><config-property-type>java.lang.String</config-property-type><config-property-value>" + newDB + "</config-property-value>" + "</config-property>\n";
        String new_str = jndi_str + config_prop;
        int n1 = str.indexOf(search);
        BlockingTimeOutDUnitTest.getLogWriter().fine("Start Index = " + n1);
        int n2 = str.indexOf(last_search, n1);
        StringBuffer sbuff = new StringBuffer(str);
        BlockingTimeOutDUnitTest.getLogWriter().fine("END Index = " + n2);
        String modified_str = sbuff.replace(n1, n2, new_str).toString();
        return modified_str;
    }

    public static String init(String className) throws Exception {
        BlockingTimeOutDUnitTest.getLogWriter().fine("PATH11 ");
        Properties props = new Properties();
        String path = System.getProperty("CACHEXMLFILE");
        BlockingTimeOutDUnitTest.getLogWriter().fine("PATH2 " + path);
        String jtest = System.getProperty("JTESTS");
        int pid = ProcessMgr.getProcessId();
        path = System.getProperty("JTESTS") + "/lib/dunit-cachejta_" + pid + ".xml";
        BlockingTimeOutDUnitTest.getLogWriter().fine("PATH " + path);
        String file_as_str = BlockingTimeOutDUnitTest.readFile(jtest + "/lib/cachejta.xml");
        file_as_str = file_as_str.replaceAll("newDB", "newDB_" + pid);
        String modified_file_str = BlockingTimeOutDUnitTest.modifyFile(file_as_str);
        FileOutputStream fos = new FileOutputStream(path);
        BufferedWriter wr = new BufferedWriter(new OutputStreamWriter(fos));
        wr.write(modified_file_str);
        wr.flush();
        wr.close();
        props.setProperty("cache-xml-file", path);
        String tableName = "";
        try {
            ds = new BlockingTimeOutDUnitTest("temp").getSystem(props);
            cache = CacheFactory.create((DistributedSystem)ds);
            if (className != null && !className.equals("")) {
                String time = new Long(System.currentTimeMillis()).toString();
                tableName = className + time;
                BlockingTimeOutDUnitTest.createTable(tableName);
            }
        }
        catch (Exception e) {
            e.printStackTrace(System.err);
            throw new Exception("" + e);
        }
        tblName = tableName;
        return tableName;
    }

    public static void createTable(String tableName) throws NamingException, SQLException {
        Context ctx = cache.getJNDIContext();
        DataSource ds = (DataSource)ctx.lookup("java:/SimpleDataSource");
        String sql = "create table " + tableName + " (id integer NOT NULL, name varchar(50), CONSTRAINT the_key PRIMARY KEY(id))";
        BlockingTimeOutDUnitTest.getLogWriter().fine(sql);
        Connection conn = ds.getConnection();
        Statement sm = conn.createStatement();
        sm.execute(sql);
        sm.close();
        sm = conn.createStatement();
        for (int i = 1; i <= 10; ++i) {
            sql = "insert into " + tableName + " values (" + i + ",'name" + i + "')";
            sm.addBatch(sql);
            BlockingTimeOutDUnitTest.getLogWriter().fine(sql);
        }
        sm.executeBatch();
        conn.close();
    }

    public static void destroyTable() throws NamingException, SQLException, Throwable {
        try {
            String tableName = tblName;
            Context ctx = cache.getJNDIContext();
            DataSource ds = (DataSource)ctx.lookup("java:/SimpleDataSource");
            Connection conn = ds.getConnection();
            BlockingTimeOutDUnitTest.getLogWriter().fine(" trying to drop table: " + tableName);
            String sql = "drop table " + tableName;
            Statement sm = conn.createStatement();
            sm.execute(sql);
            conn.close();
        }
        catch (NamingException ne) {
            BlockingTimeOutDUnitTest.getLogWriter().fine("destroy table naming exception: " + ne);
            throw ne;
        }
        catch (SQLException se) {
            BlockingTimeOutDUnitTest.getLogWriter().fine("destroy table sql exception: " + se);
            throw se;
        }
        BlockingTimeOutDUnitTest.closeCache();
    }

    public static Cache getCache() {
        return cache;
    }

    public static void startCache() {
        try {
            if (cache.isClosed()) {
                cache = CacheFactory.create((DistributedSystem)ds);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static void closeCache() throws Throwable {
        try {
            if (!cache.isClosed()) {
                cache.close();
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        ds.disconnect();
    }

    @Override
    public void setUp() throws Exception {
        Host host = Host.getHost(0);
        VM vm0 = host.getVM(0);
        Object[] o = new Object[]{"BlockingTimeOutDUnitTest"};
        vm0.invoke(BlockingTimeOutDUnitTest.class, "init", o);
    }

    @Override
    public void tearDown2() throws NamingException, SQLException {
        Host host = Host.getHost(0);
        VM vm0 = host.getVM(0);
        vm0.invoke(BlockingTimeOutDUnitTest.class, "destroyTable");
    }

    public static void testBlockingTimeOut() throws Throwable {
        Host host = Host.getHost(0);
        VM vm0 = host.getVM(0);
        vm0.invokeAsync(BlockingTimeOutDUnitTest.class, "runTest1");
        AsyncInvocation asyncObj = vm0.invokeAsync(BlockingTimeOutDUnitTest.class, "runTest2");
        DistributedTestCase.join(asyncObj, 30000L, BlockingTimeOutDUnitTest.getLogWriter());
        if (asyncObj.exceptionOccurred()) {
            BlockingTimeOutDUnitTest.fail("asyncObj failed", asyncObj.getException());
        }
    }

    public static void runTest1() throws Exception {
        int MAX_CONNECTIONS = 2;
        DataSource ds = null;
        try {
            Context ctx = cache.getJNDIContext();
            ds = (DataSource)ctx.lookup("java:/XAPooledDataSource");
        }
        catch (NamingException e) {
            BlockingTimeOutDUnitTest.getLogWriter().fine("Naming Exception caught in lookup: " + e);
            BlockingTimeOutDUnitTest.fail((String)("failed in naming lookup: " + e));
            return;
        }
        catch (Exception e) {
            BlockingTimeOutDUnitTest.getLogWriter().fine("Exception caught during naming lookup: " + e);
            BlockingTimeOutDUnitTest.fail((String)("failed in naming lookup: " + e));
            return;
        }
        try {
            for (int count = 0; count < 2; ++count) {
                ds.getConnection();
            }
        }
        catch (SQLException e) {
            BlockingTimeOutDUnitTest.getLogWriter().fine("Success SQLException caught in runTest1: " + e);
            BlockingTimeOutDUnitTest.fail((String)("runTest1 SQL Exception caught: " + e));
        }
        catch (Exception e) {
            BlockingTimeOutDUnitTest.getLogWriter().fine("Exception caught in runTest1: " + e);
            BlockingTimeOutDUnitTest.fail((String)("Exception caught in runTest1: " + e));
            e.printStackTrace();
        }
    }

    public static void runTest2() throws Exception {
        int MAX_CONNECTIONS = 2;
        BlockingTimeOutDUnitTest.getLogWriter().fine("runTest2 sleeping");
        Thread.sleep(3000L);
        DataSource ds = null;
        try {
            Context ctx = cache.getJNDIContext();
            ds = (DataSource)ctx.lookup("java:/XAPooledDataSource");
        }
        catch (NamingException e) {
            BlockingTimeOutDUnitTest.getLogWriter().fine("Exception caught during naming lookup: " + e);
            BlockingTimeOutDUnitTest.fail((String)("failed in naming lookup: " + e));
            return;
        }
        catch (Exception e) {
            BlockingTimeOutDUnitTest.getLogWriter().fine("Exception caught during naming lookup: " + e);
            BlockingTimeOutDUnitTest.fail((String)("failed in because of unhandled excpetion: " + e));
            return;
        }
        try {
            for (int count = 0; count < 2; ++count) {
                Connection con = ds.getConnection();
                BlockingTimeOutDUnitTest.assertNotNull((String)"Connection object is null", (Object)con);
                BlockingTimeOutDUnitTest.getLogWriter().fine("runTest2 :acquired connection #" + count);
            }
        }
        catch (SQLException sqle) {
            BlockingTimeOutDUnitTest.getLogWriter().fine("SQLException caught in runTest2: " + sqle);
            BlockingTimeOutDUnitTest.fail((String)("failed because of SQL exception : " + sqle));
            sqle.printStackTrace();
        }
        catch (Exception e) {
            BlockingTimeOutDUnitTest.getLogWriter().fine("Exception caught in runTest2: " + e);
            BlockingTimeOutDUnitTest.fail((String)("failed because of unhandled exception : " + e));
            e.printStackTrace();
        }
    }
}

