/*
 * Decompiled with CFR 0.152.
 */
package com.gemstone.gemfire.internal.jta.dunit;

import com.gemstone.gemfire.cache.Cache;
import com.gemstone.gemfire.cache.Region;
import com.gemstone.gemfire.distributed.DistributedSystem;
import com.gemstone.gemfire.distributed.internal.InternalDistributedSystem;
import com.gemstone.gemfire.internal.jta.CacheUtils;
import com.gemstone.gemfire.internal.jta.JTAUtils;
import dunit.DistributedTestCase;
import dunit.Host;
import dunit.VM;
import java.sql.Connection;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.Properties;
import javax.naming.Context;
import javax.naming.NamingException;
import javax.sql.DataSource;
import javax.transaction.UserTransaction;

public class DataSourceJTADUnitTest
extends DistributedTestCase {
    public DataSourceJTADUnitTest(String name) {
        super(name);
    }

    @Override
    public void setUp() throws Exception {
    }

    @Override
    public void tearDown2() throws Exception {
    }

    public static void testInsertUpdateonSimpleandXAdsCommit() {
        Host host = Host.getHost(0);
        VM vm0 = host.getVM(0);
        vm0.invoke(DataSourceJTADUnitTest.class, "Scenario1");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void Scenario1() throws Exception {
        String tblName;
        Region currRegion = null;
        String tableName = null;
        int XA_INSERTS = 3;
        boolean SM_INSERTS = true;
        try {
            Properties props = new Properties();
            String path = System.getProperty("JTESTS") + "/lib/cachejta.xml";
            props.setProperty("cache-xml-file", path);
            InternalDistributedSystem ds = new DataSourceJTADUnitTest("temp").getSystem(props);
            tblName = tableName = CacheUtils.init((DistributedSystem)ds, (String)"JTATest");
            if (tableName == null || tableName.equals("")) {
                DataSourceJTADUnitTest.fail((String)" table name not created, Aborting test...");
            }
        }
        catch (Exception e) {
            DataSourceJTADUnitTest.fail((String)(" Aborting test at set up...[" + e + "]"));
        }
        DataSourceJTADUnitTest.getLogWriter().fine("init for testscenario 1 Successful!");
        Cache cache = CacheUtils.getCache();
        tblName = tableName;
        currRegion = cache.getRegion("/root");
        int tblIDFld = 1;
        String tblNameFld = "test1";
        JTAUtils jtaObj = new JTAUtils(cache, currRegion);
        jtaObj.deleteRows(tblName);
        Context ctx = cache.getJNDIContext();
        UserTransaction ta = null;
        Connection xa_conn = null;
        Connection sm_conn = null;
        try {
            ta = (UserTransaction)ctx.lookup("java:/UserTransaction");
        }
        catch (NamingException e) {
            DataSourceJTADUnitTest.fail((String)(" fail in user txn lookup " + e));
        }
        try {
            String sqlSTR;
            DataSource sds = (DataSource)ctx.lookup("java:/SimpleDataSource");
            ta.begin();
            DataSource da = (DataSource)ctx.lookup("java:/XAPooledDataSource");
            xa_conn = da.getConnection();
            sm_conn = sds.getConnection();
            Statement xa_stmt = xa_conn.createStatement();
            Statement sm_stmt = sm_conn.createStatement();
            for (int i = 0; i < 3; ++i) {
                sqlSTR = "insert into " + tblName + " values (" + (tblIDFld += i) + "," + "'" + tblNameFld + "'" + ")";
                xa_stmt.executeUpdate(sqlSTR);
            }
            for (int j = 0; j < 1; ++j) {
                tblIDFld = tblIDFld + j + 1;
                sqlSTR = "insert into " + tblName + " values (" + tblIDFld + "," + "'" + tblNameFld + "'" + ")";
                sm_stmt.executeUpdate(sqlSTR);
            }
            xa_stmt.close();
            sm_stmt.close();
            xa_conn.close();
            sm_conn.close();
            ta.commit();
            DataSourceJTADUnitTest.getLogWriter().fine("Rows are committed in the database");
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
        catch (Exception e) {
            DataSourceJTADUnitTest.fail((String)(" failed " + e));
        }
        finally {
            if (xa_conn != null) {
                try {
                    xa_conn.close();
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
        }
        try {
            int num_rows = jtaObj.getRows(tblName);
            DataSourceJTADUnitTest.getLogWriter().fine("\nNumber of rows in Table under tests are: " + num_rows);
            switch (num_rows) {
                case 4: {
                    DataSourceJTADUnitTest.getLogWriter().fine("Both Simple and XA DataSource transactions got committed!!");
                    break;
                }
                case 1: {
                    DataSourceJTADUnitTest.getLogWriter().fine("Only Simple DataSource transactions got committed!");
                    break;
                }
                case 3: {
                    DataSourceJTADUnitTest.getLogWriter().fine("Only XA DataSource transactions got committed!");
                    break;
                }
                default: {
                    DataSourceJTADUnitTest.getLogWriter().fine("Looks like that things are messed up...look into it");
                    break;
                }
            }
        }
        catch (SQLException sqle) {
            sqle.printStackTrace();
        }
        DataSourceJTADUnitTest.getLogWriter().fine("test task for testScenario1 Succeessful");
        try {
            DataSourceJTADUnitTest.getLogWriter().fine("Destroying table: " + tblName);
            CacheUtils.destroyTable((String)tblName);
            DataSourceJTADUnitTest.getLogWriter().fine("Closing cache...");
            DataSourceJTADUnitTest.getLogWriter().fine("destroyTable for testscenario 1 Successful!");
        }
        catch (Exception e) {
            DataSourceJTADUnitTest.fail((String)(" failed during tear down of this test..." + e));
        }
        finally {
            CacheUtils.closeCache();
            DistributedTestCase.disconnectFromDS();
        }
    }

    public static void testInsertUpdateonSimpleandXAdsRollback() {
        Host host = Host.getHost(0);
        VM vm0 = host.getVM(0);
        vm0.invoke(DataSourceJTADUnitTest.class, "Scenario2");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void Scenario2() throws Exception {
        String tblName;
        Region currRegion = null;
        String tableName = null;
        int XA_INSERTS = 3;
        boolean SM_INSERTS = true;
        try {
            Properties props = new Properties();
            String path = System.getProperty("JTESTS") + "/lib/cachejta.xml";
            props.setProperty("cache-xml-file", path);
            InternalDistributedSystem ds = new DataSourceJTADUnitTest("temp").getSystem(props);
            tableName = CacheUtils.init((DistributedSystem)ds, (String)"JTATest");
            DataSourceJTADUnitTest.getLogWriter().fine("Table name: " + tableName);
            tblName = tableName;
            if (tableName == null || tableName.equals("")) {
                DataSourceJTADUnitTest.fail((String)" table name not created, Aborting test...");
            }
        }
        catch (Exception e) {
            DataSourceJTADUnitTest.fail((String)(" Aborting test at set up...[" + e + "]"));
        }
        DataSourceJTADUnitTest.getLogWriter().fine("init for testscenario 2 Successful!");
        Cache cache = CacheUtils.getCache();
        tblName = tableName;
        currRegion = cache.getRegion("/root");
        int tblIDFld = 1;
        String tblNameFld = "test2";
        JTAUtils jtaObj = new JTAUtils(cache, currRegion);
        jtaObj.deleteRows(tblName);
        Context ctx = cache.getJNDIContext();
        UserTransaction ta = null;
        Connection xa_conn = null;
        Connection sm_conn = null;
        try {
            ta = (UserTransaction)ctx.lookup("java:/UserTransaction");
        }
        catch (NamingException e) {
            DataSourceJTADUnitTest.fail((String)(" fail in user txn lookup " + e));
        }
        try {
            String sqlSTR;
            DataSource sds = (DataSource)ctx.lookup("java:/SimpleDataSource");
            ta.begin();
            DataSource da = (DataSource)ctx.lookup("java:/XAPooledDataSource");
            xa_conn = da.getConnection();
            sm_conn = sds.getConnection();
            Statement xa_stmt = xa_conn.createStatement();
            Statement sm_stmt = sm_conn.createStatement();
            for (int i = 0; i < 3; ++i) {
                sqlSTR = "insert into " + tblName + " values (" + (tblIDFld += i) + "," + "'" + tblNameFld + "'" + ")";
                xa_stmt.executeUpdate(sqlSTR);
            }
            for (int j = 0; j < 1; ++j) {
                tblIDFld = tblIDFld + j + 1;
                sqlSTR = "insert into " + tblName + " values (" + tblIDFld + "," + "'" + tblNameFld + "'" + ")";
                sm_stmt.executeUpdate(sqlSTR);
            }
            xa_stmt.close();
            sm_stmt.close();
            xa_conn.close();
            sm_conn.close();
            ta.rollback();
            DataSourceJTADUnitTest.getLogWriter().fine("Rows are rolled back in the database");
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
        catch (Exception e) {
            DataSourceJTADUnitTest.fail((String)(" failed " + e));
        }
        finally {
            if (xa_conn != null) {
                try {
                    xa_conn.close();
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
        }
        try {
            int num_rows = jtaObj.getRows(tblName);
            DataSourceJTADUnitTest.getLogWriter().fine("\nNumber of rows in Table under tests are: " + num_rows);
            switch (num_rows) {
                case 0: {
                    DataSourceJTADUnitTest.getLogWriter().fine("Both Simple and XA DataSource transactions got rolled back!!");
                    break;
                }
                case 1: {
                    DataSourceJTADUnitTest.getLogWriter().fine("Only Simple DataSource transactions got committed!");
                    break;
                }
                case 3: {
                    DataSourceJTADUnitTest.getLogWriter().fine("Only XA DataSource transactions got committed!");
                    break;
                }
                default: {
                    DataSourceJTADUnitTest.getLogWriter().fine("Looks like that things are messed up...look into it");
                    break;
                }
            }
        }
        catch (SQLException sqle) {
            sqle.printStackTrace();
        }
        DataSourceJTADUnitTest.getLogWriter().fine("test task for testScenario2 Succeessful");
        try {
            DataSourceJTADUnitTest.getLogWriter().fine("Destroying table: " + tblName);
            CacheUtils.destroyTable((String)tblName);
            DataSourceJTADUnitTest.getLogWriter().fine("Closing cache...");
            DataSourceJTADUnitTest.getLogWriter().fine("destroyTable for testscenario 2 Successful!");
        }
        catch (Exception e) {
            DataSourceJTADUnitTest.fail((String)(" failed during tear down of this test..." + e));
        }
        finally {
            CacheUtils.closeCache();
            DistributedTestCase.disconnectFromDS();
        }
    }

    public static void testInsertsDDLRollback() {
        Host host = Host.getHost(0);
        VM vm0 = host.getVM(0);
        vm0.invoke(DataSourceJTADUnitTest.class, "Scenario4");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void Scenario4() throws Exception {
        String tblName;
        Region currRegion = null;
        String tableName = null;
        int XA_INSERTS = 3;
        try {
            Properties props = new Properties();
            String path = System.getProperty("JTESTS") + "/lib/cachejta.xml";
            props.setProperty("cache-xml-file", path);
            InternalDistributedSystem ds = new DataSourceJTADUnitTest("temp").getSystem(props);
            tblName = tableName = CacheUtils.init((DistributedSystem)ds, (String)"JTATest");
            if (tableName == null || tableName.equals("")) {
                DataSourceJTADUnitTest.fail((String)" table name not created, Aborting test...");
            }
        }
        catch (Exception e) {
            DataSourceJTADUnitTest.fail((String)(" Aborting test at set up...[" + e + "]"));
        }
        DataSourceJTADUnitTest.getLogWriter().fine("init for testscenario 4 Successful!");
        Cache cache = CacheUtils.getCache();
        tblName = tableName;
        currRegion = cache.getRegion("/root");
        int tblIDFld = 1;
        String tblNameFld = "test4";
        JTAUtils jtaObj = new JTAUtils(cache, currRegion);
        jtaObj.deleteRows(tblName);
        Context ctx = cache.getJNDIContext();
        UserTransaction ta = null;
        Connection xaCon = null;
        try {
            ta = (UserTransaction)ctx.lookup("java:/UserTransaction");
        }
        catch (NamingException e) {
            DataSourceJTADUnitTest.fail((String)(" fail in user txn lookup " + e));
        }
        try {
            ta.begin();
            DataSource da = (DataSource)ctx.lookup("java:/XAPooledDataSource");
            xaCon = da.getConnection();
            Statement stmt = xaCon.createStatement();
            for (int i = 0; i < 3; ++i) {
                String sqlSTR = "insert into " + tblName + " values (" + (tblIDFld += i) + "," + "'" + tblNameFld + "'" + ")";
                stmt.executeUpdate(sqlSTR);
            }
            String sql = "create table TEST (id integer, name varchar(50))";
            stmt.executeUpdate(sql);
            sql = "drop table TEST";
            stmt.executeUpdate(sql);
            stmt.close();
            xaCon.close();
            ta.rollback();
            DataSourceJTADUnitTest.getLogWriter().fine("Rows are rolled back in the database");
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
        catch (Exception e) {
            DataSourceJTADUnitTest.fail((String)(" failed " + e));
        }
        finally {
            if (xaCon != null) {
                try {
                    xaCon.close();
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
        }
        try {
            int num_rows = jtaObj.getRows(tblName);
            DataSourceJTADUnitTest.getLogWriter().fine("\nNumber of rows in Table under tests are: " + num_rows);
            switch (num_rows) {
                case 0: {
                    DataSourceJTADUnitTest.getLogWriter().fine("Nothing is committed to database");
                    break;
                }
                case 3: {
                    DataSourceJTADUnitTest.getLogWriter().fine("Inserts are committed to database...they should not!!:-(");
                    break;
                }
                default: {
                    DataSourceJTADUnitTest.getLogWriter().fine("Looks like that things are messed up...look into it");
                    break;
                }
            }
        }
        catch (SQLException sqle) {
            sqle.printStackTrace();
        }
        DataSourceJTADUnitTest.getLogWriter().fine("test task for testScenario4 Succeessful");
        try {
            DataSourceJTADUnitTest.getLogWriter().fine("Destroying table: " + tblName);
            CacheUtils.destroyTable((String)tblName);
            DataSourceJTADUnitTest.getLogWriter().fine("Closing cache...");
            DataSourceJTADUnitTest.getLogWriter().fine("destroyTable for testscenario 4 Successful!");
        }
        catch (Exception e) {
            DataSourceJTADUnitTest.fail((String)(" failed during tear down of this test..." + e));
        }
        finally {
            CacheUtils.closeCache();
            DistributedTestCase.disconnectFromDS();
        }
    }

    public static void testMultipleXAResourceCommit() {
        Host host = Host.getHost(0);
        VM vm0 = host.getVM(0);
        vm0.invoke(DataSourceJTADUnitTest.class, "Scenario5");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void Scenario5() throws Exception {
        String tblName;
        Region currRegion = null;
        String tableName = null;
        int XA_INSERTS = 3;
        try {
            Properties props = new Properties();
            String path = System.getProperty("JTESTS") + "/lib/cachejta.xml";
            props.setProperty("cache-xml-file", path);
            InternalDistributedSystem ds = new DataSourceJTADUnitTest("temp").getSystem(props);
            tblName = tableName = CacheUtils.init((DistributedSystem)ds, (String)"JTATest");
            if (tableName == null || tableName.equals("")) {
                DataSourceJTADUnitTest.fail((String)" table name not created, Aborting test...");
            }
        }
        catch (Exception e) {
            DataSourceJTADUnitTest.fail((String)(" Aborting test at set up...[" + e + "]"));
        }
        DataSourceJTADUnitTest.getLogWriter().fine("init for testscenario 5 Successful!");
        Cache cache = CacheUtils.getCache();
        tblName = tableName;
        currRegion = cache.getRegion("/root");
        int tblIDFld = 1;
        String tblNameFld = "test5";
        JTAUtils jtaObj = new JTAUtils(cache, currRegion);
        jtaObj.deleteRows(tblName);
        Context ctx = cache.getJNDIContext();
        UserTransaction ta = null;
        Connection xaCon1 = null;
        Connection xaCon2 = null;
        Connection xaCon3 = null;
        try {
            ta = (UserTransaction)ctx.lookup("java:/UserTransaction");
        }
        catch (NamingException e) {
            DataSourceJTADUnitTest.fail((String)(" fail in user txn lookup " + e));
        }
        try {
            String sqlSTR;
            ta.begin();
            DataSource da1 = (DataSource)ctx.lookup("java:/XAPooledDataSource");
            xaCon1 = da1.getConnection();
            Statement stmt1 = xaCon1.createStatement();
            for (int i = 0; i < 3; ++i) {
                sqlSTR = "insert into " + tblName + " values (" + (tblIDFld += i) + "," + "'" + tblNameFld + "'" + ")";
                stmt1.executeUpdate(sqlSTR);
            }
            stmt1.close();
            xaCon1.close();
            DataSource da2 = (DataSource)ctx.lookup("java:/XAPooledDataSource");
            xaCon2 = da2.getConnection();
            Statement stmt2 = xaCon2.createStatement();
            for (int i = 0; i < 3; ++i) {
                tblIDFld = tblIDFld + i + 5;
                sqlSTR = "insert into " + tblName + " values (" + tblIDFld + "," + "'" + tblNameFld + "'" + ")";
                stmt2.executeUpdate(sqlSTR);
            }
            stmt2.close();
            xaCon2.close();
            DataSource da3 = (DataSource)ctx.lookup("java:/XAPooledDataSource");
            xaCon3 = da3.getConnection();
            Statement stmt3 = xaCon3.createStatement();
            for (int i = 0; i < 3; ++i) {
                sqlSTR = "insert into " + tblName + " values (" + (tblIDFld += 10) + "," + "'" + tblNameFld + "'" + ")";
                stmt3.executeUpdate(sqlSTR);
            }
            stmt3.close();
            xaCon3.close();
            ta.commit();
            DataSourceJTADUnitTest.getLogWriter().fine("Rows are rolled back in the database");
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
        catch (Exception e) {
            DataSourceJTADUnitTest.fail((String)(" failed " + e));
        }
        finally {
            if (xaCon1 != null || xaCon2 != null || xaCon3 != null) {
                try {
                    xaCon1.close();
                    xaCon2.close();
                    xaCon3.close();
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
        }
        try {
            int num_rows = jtaObj.getRows(tblName);
            DataSourceJTADUnitTest.getLogWriter().fine("\nNumber of rows in Table under tests are: " + num_rows);
            switch (num_rows) {
                case 0: {
                    DataSourceJTADUnitTest.getLogWriter().fine("Nothing is committed to database");
                    break;
                }
                case 9: {
                    DataSourceJTADUnitTest.getLogWriter().fine("All inserts successfully are committed to database");
                    break;
                }
                default: {
                    DataSourceJTADUnitTest.getLogWriter().fine("Looks like that things are messed up...look into it");
                    break;
                }
            }
        }
        catch (SQLException sqle) {
            sqle.printStackTrace();
        }
        DataSourceJTADUnitTest.getLogWriter().fine("test task for testScenario5 Succeessful");
        try {
            DataSourceJTADUnitTest.getLogWriter().fine("Destroying table: " + tblName);
            CacheUtils.destroyTable((String)tblName);
            DataSourceJTADUnitTest.getLogWriter().fine("Closing cache...");
            DataSourceJTADUnitTest.getLogWriter().fine("destroyTable for testscenario 5 Successful!");
        }
        catch (Exception e) {
            DataSourceJTADUnitTest.fail((String)(" failed during tear down of this test..." + e));
        }
        finally {
            CacheUtils.closeCache();
            DistributedTestCase.disconnectFromDS();
        }
    }
}

