/*
 * Decompiled with CFR 0.152.
 */
package com.gemstone.gemfire.internal.jta.dunit;

import com.gemstone.gemfire.cache.AttributesFactory;
import com.gemstone.gemfire.cache.Cache;
import com.gemstone.gemfire.cache.CacheClosedException;
import com.gemstone.gemfire.cache.CacheException;
import com.gemstone.gemfire.cache.CacheExistsException;
import com.gemstone.gemfire.cache.CacheFactory;
import com.gemstone.gemfire.cache.CacheLoader;
import com.gemstone.gemfire.cache.CacheLoaderException;
import com.gemstone.gemfire.cache.CacheWriter;
import com.gemstone.gemfire.cache.CacheWriterException;
import com.gemstone.gemfire.cache.EntryEvent;
import com.gemstone.gemfire.cache.EntryNotFoundException;
import com.gemstone.gemfire.cache.LoaderHelper;
import com.gemstone.gemfire.cache.Region;
import com.gemstone.gemfire.cache.RegionEvent;
import com.gemstone.gemfire.cache.RegionFactory;
import com.gemstone.gemfire.cache.RegionShortcut;
import com.gemstone.gemfire.cache.TimeoutException;
import com.gemstone.gemfire.distributed.DistributedSystem;
import com.gemstone.gemfire.distributed.internal.InternalDistributedSystem;
import com.gemstone.gemfire.internal.jta.CacheUtils;
import com.gemstone.gemfire.internal.jta.JTAUtils;
import dunit.DistributedTestCase;
import dunit.Host;
import dunit.VM;
import hydra.ProcessMgr;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.IOException;
import java.io.OutputStreamWriter;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.Properties;
import javax.naming.Context;
import javax.naming.NamingException;
import javax.sql.DataSource;
import javax.transaction.Transaction;
import javax.transaction.TransactionManager;
import javax.transaction.UserTransaction;

public class JTADUnitTest
extends DistributedTestCase {
    public JTADUnitTest(String name) {
        super(name);
    }

    @Override
    public void setUp() throws Exception {
    }

    @Override
    public void tearDown2() throws Exception {
    }

    public DistributedSystem setProperty() {
        Properties props = new Properties();
        int pid = ProcessMgr.getProcessId();
        String path = System.getProperty("JTESTS") + "/lib/dunit-cachejta_" + pid + ".xml";
        try {
            String file_as_str = JTADUnitTest.readFile(System.getProperty("JTESTS") + "/lib/cachejta.xml");
            String modified_file_str = file_as_str.replaceAll("newDB", "newDB_" + pid);
            FileOutputStream fos = new FileOutputStream(path);
            BufferedWriter wr = new BufferedWriter(new OutputStreamWriter(fos));
            wr.write(modified_file_str);
            wr.flush();
            wr.close();
        }
        catch (IOException ioe) {
            JTADUnitTest.fail((String)("Failed while modifing cachejta.xml!" + ioe));
        }
        props.setProperty("cache-xml-file", path);
        return this.getSystem(props);
    }

    public static void test1() {
        Host host = Host.getHost(0);
        VM vm0 = host.getVM(0);
        JTADUnitTest.getLogWriter().fine("test1 is getting executed");
        vm0.invoke(JTADUnitTest.class, "Scenario1");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void Scenario1() throws Exception {
        String tblName;
        Region currRegion = null;
        String tableName = null;
        try {
            DistributedSystem ds = new JTADUnitTest("temp").setProperty();
            tableName = CacheUtils.init((DistributedSystem)ds, (String)"CacheTest");
            JTADUnitTest.getLogWriter().fine("Table name: " + tableName);
            tblName = tableName;
            if (tableName == null || tableName.equals("")) {
                JTADUnitTest.fail((String)" table name not created, Aborting test...");
            }
        }
        catch (Exception e) {
            JTADUnitTest.fail((String)(" Aborting test at set up...[" + e + "]"));
        }
        JTADUnitTest.getLogWriter().fine("init for testscenario 1 Successful!");
        Cache cache = CacheUtils.getCache();
        tblName = tableName;
        currRegion = cache.getRegion("/root");
        int tblIDFld = 1;
        String tblNameFld = "test1";
        JTAUtils jtaObj = new JTAUtils(cache, currRegion);
        jtaObj.deleteRows(tblName);
        Context ctx = cache.getJNDIContext();
        UserTransaction ta = null;
        Connection conn = null;
        try {
            ta = (UserTransaction)ctx.lookup("java:/UserTransaction");
        }
        catch (NamingException e) {
            JTADUnitTest.fail((String)(" fail in user txn lookup " + e));
        }
        try {
            ta.begin();
            DataSource da = (DataSource)ctx.lookup("java:/XAPooledDataSource");
            conn = da.getConnection();
            Statement stmt = conn.createStatement();
            String sqlSTR = "insert into " + tblName + " values (" + tblIDFld + "," + "'" + tblNameFld + "'" + ")";
            stmt.executeUpdate(sqlSTR);
            stmt.close();
            ta.commit();
            conn.close();
        }
        catch (NamingException e) {
            JTADUnitTest.fail((String)(" failed " + e));
            ta.rollback();
        }
        catch (SQLException e) {
            JTADUnitTest.fail((String)(" failed " + e));
            ta.rollback();
        }
        catch (Exception e) {
            JTADUnitTest.fail((String)(" failed " + e));
            ta.rollback();
        }
        finally {
            if (conn != null) {
                try {
                    conn.close();
                }
                catch (SQLException ex) {
                    JTADUnitTest.fail((String)("SQL exception: " + ex));
                }
            }
        }
        JTADUnitTest.getLogWriter().fine("test task for testscenario1 Succeessful");
        try {
            JTADUnitTest.getLogWriter().fine("Destroying table: " + tblName);
            CacheUtils.destroyTable((String)tblName);
            JTADUnitTest.getLogWriter().fine("Closing cache...");
            JTADUnitTest.getLogWriter().fine("destroyTable for testscenario 1 Successful!");
        }
        catch (Exception e) {
            JTADUnitTest.fail((String)(" failed during tear down of this test..." + e));
        }
        finally {
            CacheUtils.closeCache();
            DistributedTestCase.disconnectFromDS();
        }
    }

    public static void test2() {
        Host host = Host.getHost(0);
        VM vm0 = host.getVM(0);
        JTADUnitTest.getLogWriter().fine("test2 is getting executed");
        vm0.invoke(JTADUnitTest.class, "Scenario2");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void Scenario2() throws Exception {
        Region currRegion = null;
        String tblName = null;
        String tableName = null;
        try {
            DistributedSystem ds = new JTADUnitTest("temp").setProperty();
            tableName = CacheUtils.init((DistributedSystem)ds, (String)"CacheTest");
            JTADUnitTest.getLogWriter().fine("Table name: " + tableName);
            tblName = tableName;
            if (tableName == null || tableName.equals("")) {
                JTADUnitTest.fail((String)" table name not created, Aborting test...");
            }
        }
        catch (Exception e) {
            JTADUnitTest.fail((String)(" Aborting test at set up...[" + e + "]"));
        }
        JTADUnitTest.getLogWriter().fine("init for testscenario 2 Successful!");
        Cache cache = CacheUtils.getCache();
        currRegion = cache.getRegion("/root");
        int tblIDFld = 2;
        String tblNameFld = "test2";
        boolean rollback_chances = true;
        JTAUtils jtaObj = new JTAUtils(cache, currRegion);
        jtaObj.deleteRows(tblName);
        Context ctx = cache.getJNDIContext();
        JTADUnitTest.getLogWriter().fine(" looking up UserTransaction... ");
        UserTransaction ta = null;
        Connection conn = null;
        try {
            ta = (UserTransaction)ctx.lookup("java:/UserTransaction");
        }
        catch (NamingException e) {
            JTADUnitTest.fail((String)(" user txn lookup failed " + e));
        }
        try {
            ta.begin();
            DataSource da = (DataSource)ctx.lookup("java:/XAPooledDataSource");
            conn = da.getConnection();
            Statement stmt = conn.createStatement();
            String sqlSTR = "insert into " + tblName + " values (" + tblIDFld + "," + "'" + tblNameFld + "'" + ")";
            stmt.executeUpdate(sqlSTR);
            stmt.close();
            conn.close();
            ta.commit();
            rollback_chances = false;
            int ifAnyRows = jtaObj.getRows(tblName);
            if (ifAnyRows == 0) {
                JTADUnitTest.fail((String)" no rows retrieved even after txn commit after conn close.");
            }
        }
        catch (NamingException e) {
            JTADUnitTest.fail((String)(" failed " + e));
            if (rollback_chances) {
                ta.rollback();
            }
        }
        catch (SQLException e) {
            JTADUnitTest.fail((String)(" failed " + e));
            if (rollback_chances) {
                ta.rollback();
            }
        }
        catch (Exception e) {
            JTADUnitTest.fail((String)(" failed " + e));
            ta.rollback();
        }
        finally {
            if (conn != null) {
                try {
                    conn.close();
                }
                catch (SQLException e) {}
            }
        }
        JTADUnitTest.getLogWriter().fine("test task for testscenario2 Successful!");
        try {
            JTADUnitTest.getLogWriter().fine("Destroying table: " + tblName);
            CacheUtils.destroyTable((String)tblName);
            JTADUnitTest.getLogWriter().fine("Closing cache...");
            JTADUnitTest.getLogWriter().fine("destroyTable for testscenario 2 Successful!");
        }
        catch (Exception e) {
            JTADUnitTest.fail((String)(" failed during tear down of this test..." + e));
        }
        finally {
            CacheUtils.closeCache();
            DistributedTestCase.disconnectFromDS();
        }
    }

    public static void test3() {
        Host host = Host.getHost(0);
        VM vm0 = host.getVM(0);
        JTADUnitTest.getLogWriter().fine("test3 is getting executed");
        vm0.invoke(JTADUnitTest.class, "Scenario3");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void Scenario3() throws Exception {
        Region currRegion = null;
        String tblName = null;
        String tableName = null;
        try {
            DistributedSystem ds = new JTADUnitTest("temp").setProperty();
            tableName = CacheUtils.init((DistributedSystem)ds, (String)"CacheTest");
            JTADUnitTest.getLogWriter().fine("Table name: " + tableName);
            tblName = tableName;
            if (tableName == null || tableName.equals("")) {
                JTADUnitTest.fail((String)" table name not created, Aborting test...");
            }
        }
        catch (Exception e) {
            JTADUnitTest.fail((String)(" Aborting test at set up...[" + e + "]"));
        }
        JTADUnitTest.getLogWriter().fine("init for testscenario 3 Successful!");
        Cache cache = CacheUtils.getCache();
        currRegion = cache.getRegion("/root");
        int tblIDFld = 3;
        String tblNameFld = "test3";
        boolean rollback_chances = true;
        String DEFAULT_RGN = "root";
        JTAUtils jtaObj = new JTAUtils(cache, currRegion);
        jtaObj.deleteRows(tblName);
        Context ctx = cache.getJNDIContext();
        UserTransaction ta = null;
        Connection conn = null;
        try {
            ta = (UserTransaction)ctx.lookup("java:/UserTransaction");
        }
        catch (NamingException e) {
            JTADUnitTest.fail((String)(" user txn lookup failed " + e));
        }
        try {
            ta.begin();
            String current_region = jtaObj.currRegion.getName();
            JTADUnitTest.assertEquals((String)"the default region is not root", (String)"root", (String)current_region);
            jtaObj.getRegionFromCache("region1");
            String current_fullpath = jtaObj.currRegion.getFullPath();
            JTADUnitTest.assertEquals((String)"failed retrieving current region fullpath", (String)"/root/region1", (String)current_fullpath);
            jtaObj.put("key1", "value1");
            String str = jtaObj.get("key1");
            String tok = jtaObj.parseGetValue(str);
            JTADUnitTest.assertEquals((String)"get failed for corresponding put", (String)"\"value1\"", (String)tok);
            current_fullpath = jtaObj.currRegion.getFullPath();
            JTADUnitTest.assertEquals((String)"failed retrieving current region fullpath", (String)"/root/region1", (String)current_fullpath);
            DataSource da = (DataSource)ctx.lookup("java:/XAPooledDataSource");
            conn = da.getConnection();
            Statement stmt = conn.createStatement();
            String sqlSTR = "insert into " + tblName + " values (" + tblIDFld + "," + "'" + tblNameFld + "'" + ")";
            stmt.executeUpdate(sqlSTR);
            stmt.close();
            ta.commit();
            conn.close();
            rollback_chances = false;
            current_fullpath = jtaObj.currRegion.getFullPath();
            JTADUnitTest.assertEquals((String)"failed retrieving current region fullpath after txn commit", (String)"/root/region1", (String)current_fullpath);
            int ifAnyRows = jtaObj.getRows(tblName);
            JTADUnitTest.assertEquals((String)("rows retrieved is:" + ifAnyRows), (int)1, (int)ifAnyRows);
            str = jtaObj.get("key1");
            tok = jtaObj.parseGetValue(str);
            JTADUnitTest.assertEquals((String)("cache put didn't commit, value retrieved is: " + tok), (String)"\"value1\"", (String)tok);
        }
        catch (CacheExistsException e) {
            JTADUnitTest.fail((String)" test 3 failed ");
            ta.rollback();
        }
        catch (NamingException e) {
            JTADUnitTest.fail((String)(" test 3 failed " + e));
            if (rollback_chances) {
                ta.rollback();
            }
        }
        catch (SQLException e) {
            JTADUnitTest.fail((String)(" test 3 failed " + e));
            if (rollback_chances) {
                ta.rollback();
            }
        }
        catch (Exception e) {
            JTADUnitTest.fail((String)(" test 3 failed " + e));
            if (rollback_chances) {
                ta.rollback();
            }
        }
        finally {
            if (conn != null) {
                try {
                    conn.close();
                }
                catch (SQLException e) {}
            }
        }
        JTADUnitTest.getLogWriter().fine("test task for testscenarion3 Successful!");
        try {
            JTADUnitTest.getLogWriter().fine("Destroying table: " + tblName);
            CacheUtils.destroyTable((String)tblName);
            JTADUnitTest.getLogWriter().fine("Closing cache...");
            JTADUnitTest.getLogWriter().fine("destroyTable for testscenario 3 Successful!");
        }
        catch (Exception e) {
            JTADUnitTest.fail((String)(" failed during tear down of this test..." + e));
        }
        finally {
            CacheUtils.closeCache();
            DistributedTestCase.disconnectFromDS();
        }
    }

    public static void test4() {
        Host host = Host.getHost(0);
        VM vm0 = host.getVM(0);
        JTADUnitTest.getLogWriter().fine("test4 is getting executed");
        vm0.invoke(JTADUnitTest.class, "Scenario4");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void Scenario4() throws Exception {
        Region currRegion = null;
        String tblName = null;
        String tableName = null;
        try {
            DistributedSystem ds = new JTADUnitTest("temp").setProperty();
            tableName = CacheUtils.init((DistributedSystem)ds, (String)"CacheTest");
            JTADUnitTest.getLogWriter().fine("Table name: " + tableName);
            tblName = tableName;
            if (tableName == null || tableName.equals("")) {
                JTADUnitTest.fail((String)" table name not created, Aborting test...");
            }
        }
        catch (Exception e) {
            JTADUnitTest.fail((String)(" Aborting test at set up...[" + e + "]"));
        }
        JTADUnitTest.getLogWriter().fine("init for testscenario 4 Successful!");
        Cache cache = CacheUtils.getCache();
        currRegion = cache.getRegion("/root");
        int tblIDFld = 4;
        String tblNameFld = "test4";
        boolean rollback_chances = true;
        String DEFAULT_RGN = "root";
        JTAUtils jtaObj = new JTAUtils(cache, currRegion);
        jtaObj.deleteRows(tblName);
        Context ctx = cache.getJNDIContext();
        UserTransaction ta = null;
        Connection conn = null;
        try {
            ta = (UserTransaction)ctx.lookup("java:/UserTransaction");
        }
        catch (NamingException e) {
            JTADUnitTest.fail((String)(" user txn lookup failed " + e));
        }
        try {
            String current_region = jtaObj.currRegion.getName();
            JTADUnitTest.assertEquals((String)"default region is not root", (String)"root", (String)current_region);
            jtaObj.getRegionFromCache("region1");
            String current_fullpath = jtaObj.currRegion.getFullPath();
            JTADUnitTest.assertEquals((String)"failed retrieving current region fullpath after doing getRegionFromCache(region1)", (String)"/root/region1", (String)current_fullpath);
            jtaObj.put("key1", "test");
            ta.begin();
            jtaObj.put("key1", "value1");
            String str = jtaObj.get("key1");
            String tok = jtaObj.parseGetValue(str);
            JTADUnitTest.assertEquals((String)"get value do not match with the put", (String)"\"value1\"", (String)tok);
            current_fullpath = jtaObj.currRegion.getFullPath();
            JTADUnitTest.assertEquals((String)"failed retrieving current region fullpath", (String)"/root/region1", (String)current_fullpath);
            DataSource da = (DataSource)ctx.lookup("java:/XAPooledDataSource");
            conn = da.getConnection();
            Statement stmt = conn.createStatement();
            String sqlSTR = "insert into " + tblName + " values (" + tblIDFld + "," + "'" + tblNameFld + "'" + ")";
            stmt.executeUpdate(sqlSTR);
            stmt.close();
            ta.rollback();
            conn.close();
            rollback_chances = false;
            current_fullpath = jtaObj.currRegion.getFullPath();
            JTADUnitTest.assertEquals((String)"failed retirieving current region fullpath after txn rollback", (String)"/root/region1", (String)current_fullpath);
            int ifAnyRows = jtaObj.getRows(tblName);
            JTADUnitTest.assertEquals((String)("rows retrieved is: " + ifAnyRows), (int)0, (int)ifAnyRows);
            str = jtaObj.get("key1");
            tok = jtaObj.parseGetValue(str);
            JTADUnitTest.assertEquals((String)("value existing in cache is: " + tok), (String)"\"test\"", (String)tok);
        }
        catch (CacheExistsException e) {
            ta.rollback();
            JTADUnitTest.fail((String)(" failed " + (Object)((Object)e)));
        }
        catch (NamingException e) {
            if (rollback_chances) {
                ta.rollback();
            }
            JTADUnitTest.fail((String)(" failed " + e));
        }
        catch (SQLException e) {
            if (rollback_chances) {
                ta.rollback();
            }
            JTADUnitTest.fail((String)(" failed " + e));
        }
        catch (Exception e) {
            if (rollback_chances) {
                ta.rollback();
            }
            JTADUnitTest.fail((String)(" failed " + e));
        }
        finally {
            if (conn != null) {
                try {
                    conn.close();
                }
                catch (SQLException e) {}
            }
        }
        JTADUnitTest.getLogWriter().fine("testtask for testscenario 4 Successful!");
        try {
            JTADUnitTest.getLogWriter().fine("Destroying table: " + tblName);
            CacheUtils.destroyTable((String)tblName);
            JTADUnitTest.getLogWriter().fine("Closing cache...");
            JTADUnitTest.getLogWriter().fine("destroyTable for testscenario 4 Successful!");
        }
        catch (Exception e) {
            JTADUnitTest.fail((String)(" failed during tear down of this test..." + e));
        }
        finally {
            CacheUtils.closeCache();
            DistributedTestCase.disconnectFromDS();
        }
    }

    public static void test5() {
        Host host = Host.getHost(0);
        VM vm0 = host.getVM(0);
        JTADUnitTest.getLogWriter().fine("test5 is getting executed");
        vm0.invoke(JTADUnitTest.class, "Scenario5");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void Scenario5() throws Exception {
        String tblName;
        block41: {
            Region currRegion = null;
            tblName = null;
            String tableName = null;
            try {
                DistributedSystem ds = new JTADUnitTest("temp").setProperty();
                tableName = CacheUtils.init((DistributedSystem)ds, (String)"CacheTest");
                JTADUnitTest.getLogWriter().fine("Table name: " + tableName);
                tblName = tableName;
                if (tableName == null || tableName.equals("")) {
                    JTADUnitTest.fail((String)" table name not created, Aborting test...");
                }
            }
            catch (Exception e) {
                JTADUnitTest.fail((String)(" Aborting test at set up...[" + e + "]"));
            }
            JTADUnitTest.getLogWriter().fine("init for testscenario 5 Successful!");
            Cache cache = CacheUtils.getCache();
            currRegion = cache.getRegion("/root");
            int tblIDFld = 5;
            String tblNameFld = "test5";
            boolean rollback_chances = false;
            String DEFAULT_RGN = "root";
            JTAUtils jtaObj = new JTAUtils(cache, currRegion);
            jtaObj.deleteRows(tblName);
            Context ctx = cache.getJNDIContext();
            UserTransaction ta = null;
            Connection conn = null;
            try {
                ta = (UserTransaction)ctx.lookup("java:/UserTransaction");
            }
            catch (NamingException e) {
                JTADUnitTest.fail((String)(" failed in user txn lookup " + e));
            }
            try {
                String current_region = jtaObj.currRegion.getName();
                JTADUnitTest.assertEquals((String)"default region is not root", (String)"root", (String)current_region);
                jtaObj.getRegionFromCache("region1");
                String current_fullpath = jtaObj.currRegion.getFullPath();
                JTADUnitTest.assertEquals((String)"failed retirieving current fullpath", (String)"/root/region1", (String)current_fullpath);
                jtaObj.put("key1", "test");
                ta.begin();
                jtaObj.put("key1", "value1");
                String str = jtaObj.get("key1");
                String tok = jtaObj.parseGetValue(str);
                JTADUnitTest.assertEquals((String)"get value mismatch with put", (String)"\"value1\"", (String)tok);
                current_fullpath = jtaObj.currRegion.getFullPath();
                JTADUnitTest.assertEquals((String)("failed retrieving current fullpath, current fullpath: " + current_fullpath), (String)"/root/region1", (String)current_fullpath);
                DataSource da = (DataSource)ctx.lookup("java:/XAPooledDataSource");
                conn = da.getConnection();
                Statement stmt = conn.createStatement();
                String sqlSTR = "insert into " + tblName + " values (" + tblIDFld + "," + "'" + tblNameFld + "'" + ")";
                stmt.executeUpdate(sqlSTR);
                rollback_chances = true;
                sqlSTR = "insert into " + tblName + " values (" + tblIDFld + "," + "'" + tblNameFld + "'" + ")";
                stmt.executeUpdate(sqlSTR);
                stmt.close();
                ta.commit();
                conn.close();
            }
            catch (CacheExistsException e) {
                JTADUnitTest.fail((String)("test failed " + (Object)((Object)e)));
                ta.rollback();
            }
            catch (NamingException e) {
                JTADUnitTest.fail((String)("test failed " + e));
                ta.rollback();
            }
            catch (SQLException e) {
                if (rollback_chances) {
                    try {
                        ta.rollback();
                    }
                    catch (Exception ex) {
                        JTADUnitTest.fail((String)("failed: " + ex));
                    }
                    int ifAnyRows = 0;
                    try {
                        ifAnyRows = jtaObj.getRows(tblName);
                    }
                    catch (Exception ex) {
                        JTADUnitTest.fail((String)(" failed: " + ex));
                    }
                    JTADUnitTest.assertEquals((String)("rows found after rollback is: " + ifAnyRows), (int)0, (int)ifAnyRows);
                    String current_fullpath = jtaObj.currRegion.getFullPath();
                    JTADUnitTest.assertEquals((String)("failed retrieving current fullpath after rollback, fullpath is: " + current_fullpath), (String)"/root/region1", (String)current_fullpath);
                    String str1 = null;
                    try {
                        str1 = jtaObj.get("key1");
                    }
                    catch (CacheException ex) {
                        JTADUnitTest.fail((String)("failed getting value for 'key1': " + (Object)((Object)ex)));
                    }
                    String tok1 = jtaObj.parseGetValue(str1);
                    JTADUnitTest.assertEquals((String)("value found in cache: " + tok1 + ", after rollback"), (String)"\"test\"", (String)tok1);
                    break block41;
                }
                JTADUnitTest.fail((String)(" failed: " + e));
                ta.rollback();
            }
            catch (Exception e) {
                JTADUnitTest.fail((String)(" failed: " + e));
                ta.rollback();
            }
            finally {
                if (conn != null) {
                    try {
                        conn.close();
                    }
                    catch (SQLException ex) {
                        JTADUnitTest.fail((String)("Exception: " + ex));
                    }
                }
            }
        }
        JTADUnitTest.getLogWriter().fine("test task for testscenario 5 Successful");
        try {
            JTADUnitTest.getLogWriter().fine("Destroying table: " + tblName);
            CacheUtils.destroyTable((String)tblName);
            JTADUnitTest.getLogWriter().fine("Closing cache...");
            JTADUnitTest.getLogWriter().fine("destroyTable for testscenario5 Successful!");
        }
        catch (Exception e) {
            JTADUnitTest.fail((String)(" failed during tear down of this test..." + e));
        }
        finally {
            CacheUtils.closeCache();
            DistributedTestCase.disconnectFromDS();
        }
    }

    public static void test7() {
        Host host = Host.getHost(0);
        VM vm0 = host.getVM(0);
        JTADUnitTest.getLogWriter().fine("test7 is getting executed");
        vm0.invoke(JTADUnitTest.class, "Scenario7");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void Scenario7() throws Exception {
        Region currRegion = null;
        String tblName = null;
        String tableName = null;
        try {
            DistributedSystem ds = new JTADUnitTest("temp").setProperty();
            tableName = CacheUtils.init((DistributedSystem)ds, (String)"CacheTest");
            JTADUnitTest.getLogWriter().fine("Table name: " + tableName);
            tblName = tableName;
            if (tableName == null || tableName.equals("")) {
                JTADUnitTest.fail((String)" table name not created, Aborting test...");
            }
        }
        catch (Exception e) {
            JTADUnitTest.fail((String)(" Aborting test at set up...[" + e + "]"));
        }
        JTADUnitTest.getLogWriter().fine("init for testscenario 7 Successful!");
        Cache cache = CacheUtils.getCache();
        currRegion = cache.getRegion("/root");
        boolean rollback_chances = true;
        String DEFAULT_RGN = "root";
        JTAUtils jtaObj = new JTAUtils(cache, currRegion);
        jtaObj.deleteRows(tblName);
        Context ctx = cache.getJNDIContext();
        UserTransaction ta = null;
        Connection conn = null;
        try {
            ta = (UserTransaction)ctx.lookup("java:/UserTransaction");
        }
        catch (NamingException e) {
            JTADUnitTest.fail((String)(" user txn lookup failed: " + e));
        }
        try {
            ta.begin();
            String current_region = jtaObj.currRegion.getName();
            JTADUnitTest.assertEquals((String)"default region is not root", (String)"root", (String)current_region);
            jtaObj.getRegionFromCache("region1");
            String current_fullpath = jtaObj.currRegion.getFullPath();
            JTADUnitTest.assertEquals((String)"failed retrieving the current region fullpath", (String)"/root/region1", (String)current_fullpath);
            jtaObj.put("key1", "value1");
            String str = jtaObj.get("key1");
            String tok = jtaObj.parseGetValue(str);
            JTADUnitTest.assertEquals((String)"get value mismatch with put", (String)"\"value1\"", (String)tok);
            current_fullpath = jtaObj.currRegion.getFullPath();
            JTADUnitTest.assertEquals((String)"failed retrieving current region fullpath", (String)"/root/region1", (String)current_fullpath);
            DataSource da = (DataSource)ctx.lookup("java:/XAPooledDataSource");
            conn = da.getConnection();
            ta.commit();
            conn.close();
            rollback_chances = false;
            current_fullpath = jtaObj.currRegion.getFullPath();
            JTADUnitTest.assertEquals((String)("failed retrieving current region fullpath after txn commit, fullpath is: " + current_region), (String)"/root/region1", (String)current_fullpath);
            str = jtaObj.get("key1");
            tok = jtaObj.parseGetValue(str);
            JTADUnitTest.assertEquals((String)("cache value found is: " + tok), (String)"\"value1\"", (String)tok);
        }
        catch (CacheExistsException e) {
            JTADUnitTest.fail((String)(" failed due to: " + (Object)((Object)e)));
            if (rollback_chances) {
                ta.rollback();
            }
        }
        catch (NamingException e) {
            JTADUnitTest.fail((String)(" failed due to: " + e));
            ta.rollback();
        }
        catch (SQLException e) {
            JTADUnitTest.fail((String)(" failed due to: " + e));
            ta.rollback();
        }
        catch (Exception e) {
            JTADUnitTest.fail((String)(" failed due to: " + e));
            if (rollback_chances) {
                ta.rollback();
            }
        }
        finally {
            if (conn != null) {
                try {
                    conn.close();
                }
                catch (Exception e) {}
            }
        }
        JTADUnitTest.getLogWriter().fine("test task for tes scenario 7 Successful!");
        try {
            JTADUnitTest.getLogWriter().fine("Destroying table: " + tblName);
            CacheUtils.destroyTable((String)tblName);
            JTADUnitTest.getLogWriter().fine("Closing cache...");
            JTADUnitTest.getLogWriter().fine("destroyTable for testscenario 7 Successful!");
        }
        catch (Exception e) {
            JTADUnitTest.fail((String)(" failed during tear down of this test..." + e));
        }
        finally {
            CacheUtils.closeCache();
            DistributedTestCase.disconnectFromDS();
        }
    }

    public static void test9() {
        Host host = Host.getHost(0);
        VM vm0 = host.getVM(0);
        JTADUnitTest.getLogWriter().fine("test9 is getting executed");
        vm0.invoke(JTADUnitTest.class, "Scenario9");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void Scenario9() throws Exception {
        Region currRegion = null;
        String tblName = null;
        String tableName = null;
        try {
            DistributedSystem ds = new JTADUnitTest("temp").setProperty();
            tableName = CacheUtils.init((DistributedSystem)ds, (String)"CacheTest");
            JTADUnitTest.getLogWriter().fine("Table name: " + tableName);
            tblName = tableName;
            if (tableName == null || tableName.equals("")) {
                JTADUnitTest.fail((String)" table name not created, Aborting test...");
            }
        }
        catch (Exception e) {
            JTADUnitTest.fail((String)(" Aborting test at set up...[" + e + "]"));
        }
        JTADUnitTest.getLogWriter().fine("init for testscenario 9 Successful!");
        Cache cache = CacheUtils.getCache();
        currRegion = cache.getRegion("/root");
        int tblIDFld = 9;
        String tblNameFld = "test9";
        boolean rollback_chances = true;
        int first_field = tblIDFld;
        JTAUtils jtaObj = new JTAUtils(cache, currRegion);
        jtaObj.deleteRows(tblName);
        Context ctx = cache.getJNDIContext();
        UserTransaction ta = null;
        Connection conn = null;
        try {
            ta = (UserTransaction)ctx.lookup("java:/UserTransaction");
        }
        catch (NamingException e) {
            JTADUnitTest.fail((String)(" user txn lookup failed " + e));
        }
        try {
            ta.begin();
            DataSource da = (DataSource)ctx.lookup("java:/XAPooledDataSource");
            conn = da.getConnection();
            Statement stmt = conn.createStatement();
            String sqlSTR = "insert into " + tblName + " values (" + tblIDFld + "," + "'" + tblNameFld + "'" + ")";
            stmt.executeUpdate(sqlSTR);
            ta.commit();
            rollback_chances = false;
            sqlSTR = "insert into " + tblName + " values (" + ++tblIDFld + "," + "'" + tblNameFld + "'" + ")";
            stmt.executeUpdate(sqlSTR);
            stmt.close();
            conn.close();
            rollback_chances = true;
        }
        catch (NamingException e) {
            JTADUnitTest.fail((String)(" failed due to: " + e));
            ta.rollback();
        }
        catch (SQLException e) {
            if (!rollback_chances) {
                int ifAnyRows = jtaObj.getRows(tblName);
                JTADUnitTest.assertEquals((String)("rows found is: " + ifAnyRows), (int)1, (int)ifAnyRows);
                boolean matched = jtaObj.checkTableAgainstData(tblName, first_field + "");
                JTADUnitTest.assertEquals((String)"first entry to db is not found", (boolean)true, (boolean)matched);
            } else {
                ta.rollback();
                JTADUnitTest.fail((String)(" failed due to: " + e));
            }
        }
        catch (Exception e) {
            JTADUnitTest.fail((String)(" failed due to: " + e));
            if (rollback_chances) {
                ta.rollback();
            }
        }
        finally {
            if (conn != null) {
                try {
                    conn.close();
                }
                catch (SQLException e) {}
            }
        }
        JTADUnitTest.getLogWriter().fine("test task for testscenario 9 Successful");
        try {
            JTADUnitTest.getLogWriter().fine("Destroying table: " + tblName);
            CacheUtils.destroyTable((String)tblName);
            JTADUnitTest.getLogWriter().fine("Closing cache...");
            JTADUnitTest.getLogWriter().fine("destroyTable for testscenario 9 Successful!");
        }
        catch (Exception e) {
            JTADUnitTest.fail((String)(" failed during tear down of this test..." + e));
        }
        finally {
            CacheUtils.closeCache();
            DistributedTestCase.disconnectFromDS();
        }
    }

    public static void test10() {
        Host host = Host.getHost(0);
        VM vm0 = host.getVM(0);
        JTADUnitTest.getLogWriter().fine("test10 is getting executed");
        vm0.invoke(JTADUnitTest.class, "Scenario10");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void Scenario10() throws Exception {
        Region currRegion = null;
        String tblName = null;
        String tableName = null;
        try {
            DistributedSystem ds = new JTADUnitTest("temp").setProperty();
            tableName = CacheUtils.init((DistributedSystem)ds, (String)"CacheTest");
            JTADUnitTest.getLogWriter().fine("Table name: " + tableName);
            tblName = tableName;
            if (tableName == null || tableName.equals("")) {
                JTADUnitTest.fail((String)" table name not created, Aborting test...");
            }
        }
        catch (Exception e) {
            JTADUnitTest.fail((String)(" Aborting test at set up...[" + e + "]"));
        }
        JTADUnitTest.getLogWriter().fine("init for testscenario 10 Successful!");
        Cache cache = CacheUtils.getCache();
        currRegion = cache.getRegion("/root");
        int tblIDFld = 10;
        String tblNameFld = "test10";
        int rows_inserted = 0;
        int ifAnyRows = 0;
        int field1 = tblIDFld;
        int field2 = 0;
        JTAUtils jtaObj = new JTAUtils(cache, currRegion);
        jtaObj.deleteRows(tblName);
        Context ctx = cache.getJNDIContext();
        UserTransaction ta = null;
        Connection conn1 = null;
        Connection conn2 = null;
        try {
            ta = (UserTransaction)ctx.lookup("java:/UserTransaction");
        }
        catch (NamingException e) {
            JTADUnitTest.fail((String)(" user lookup failed: " + e));
        }
        try {
            ta.begin();
            DataSource da = (DataSource)ctx.lookup("java:/XAPooledDataSource");
            conn1 = da.getConnection();
            Statement stmt = conn1.createStatement();
            String sqlSTR = "insert into " + tblName + " values (" + tblIDFld + "," + "'" + tblNameFld + "'" + ")";
            stmt.executeUpdate(sqlSTR);
            ++rows_inserted;
            conn1.close();
            conn2 = da.getConnection();
            stmt = conn2.createStatement();
            field2 = ++tblIDFld;
            sqlSTR = "insert into " + tblName + " values (" + tblIDFld + "," + "'" + tblNameFld + "'" + ")";
            stmt.executeUpdate(sqlSTR);
            stmt.close();
            conn2.close();
            ta.commit();
            ifAnyRows = jtaObj.getRows(tblName);
            if (ifAnyRows == ++rows_inserted) {
                boolean matched1 = jtaObj.checkTableAgainstData(tblName, field1 + "");
                boolean matched2 = jtaObj.checkTableAgainstData(tblName, field2 + "");
                if (matched1) {
                    JTADUnitTest.getLogWriter().fine("(PK " + field1 + "found ");
                } else {
                    JTADUnitTest.getLogWriter().fine("(PK " + field1 + "not found ");
                }
                if (matched2) {
                    JTADUnitTest.getLogWriter().fine("PK " + field2 + "found)");
                } else {
                    JTADUnitTest.getLogWriter().fine("PK " + field2 + "not found)");
                }
                if (matched1 & matched2) {
                    JTADUnitTest.getLogWriter().fine("ok");
                } else {
                    JTADUnitTest.fail((String)" inserted data not found in DB !... failed");
                }
            } else {
                JTADUnitTest.fail((String)(" test interrupted, rows found=" + ifAnyRows + ", rows inserted=" + rows_inserted));
            }
        }
        catch (NamingException e) {
            ta.rollback();
        }
        catch (SQLException e) {
            ta.rollback();
        }
        catch (Exception e) {
            ta.rollback();
        }
        finally {
            if (conn1 != null) {
                try {
                    conn1.close();
                }
                catch (SQLException e) {}
            }
            if (conn2 != null) {
                try {
                    conn2.close();
                }
                catch (SQLException e) {}
            }
        }
        JTADUnitTest.getLogWriter().fine("test task for testscenario 10 Successful!");
        try {
            JTADUnitTest.getLogWriter().fine("Destroying table: " + tblName);
            CacheUtils.destroyTable((String)tblName);
            JTADUnitTest.getLogWriter().fine("Closing cache...");
            JTADUnitTest.getLogWriter().fine("destroyTable for testscenario 10 Successful!");
        }
        catch (Exception e) {
            JTADUnitTest.fail((String)(" failed during tear down of this test..." + e));
        }
        finally {
            CacheUtils.closeCache();
            DistributedTestCase.disconnectFromDS();
        }
    }

    public static void test11() {
        Host host = Host.getHost(0);
        VM vm0 = host.getVM(0);
        JTADUnitTest.getLogWriter().fine("test11 is getting executed");
        vm0.invoke(JTADUnitTest.class, "Scenario11");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void Scenario11() throws Exception {
        String tblName;
        block33: {
            Region currRegion = null;
            tblName = null;
            String tableName = null;
            try {
                DistributedSystem ds = new JTADUnitTest("temp").setProperty();
                tableName = CacheUtils.init((DistributedSystem)ds, (String)"CacheTest");
                JTADUnitTest.getLogWriter().fine("Table name: " + tableName);
                tblName = tableName;
                if (tableName == null || tableName.equals("")) {
                    JTADUnitTest.fail((String)" table name not created, Aborting test...");
                }
            }
            catch (Exception e) {
                JTADUnitTest.fail((String)(" Aborting test at set up...[" + e + "]"));
            }
            JTADUnitTest.getLogWriter().fine("init for testscenario 11 Successful!");
            Cache cache = CacheUtils.getCache();
            currRegion = cache.getRegion("/root");
            int tblIDFld = 11;
            String tblNameFld = "test11";
            boolean rollback_chances = false;
            JTAUtils jtaObj = new JTAUtils(cache, currRegion);
            jtaObj.deleteRows(tblName);
            Context ctx = cache.getJNDIContext();
            UserTransaction ta = null;
            Connection conn = null;
            try {
                ta = (UserTransaction)ctx.lookup("java:/UserTransaction");
            }
            catch (NamingException e) {
                JTADUnitTest.fail((String)("failed in user txn look up: " + e));
            }
            try {
                ta.begin();
                DataSource da = (DataSource)ctx.lookup("java:/SimpleDataSource");
                conn = da.getConnection();
                Statement stmt = conn.createStatement();
                String sqlSTR = "insert into " + tblName + " values (" + tblIDFld + "," + "'" + tblNameFld + "'" + ")";
                stmt.executeUpdate(sqlSTR);
                rollback_chances = true;
                sqlSTR = "insert into " + tblName + " values (" + tblIDFld + "," + "'" + tblNameFld + "'" + ")";
                stmt.executeUpdate(sqlSTR);
                stmt.close();
                ta.commit();
                conn.close();
            }
            catch (NamingException e) {
                ta.rollback();
            }
            catch (SQLException e) {
                if (rollback_chances) {
                    try {
                        ta.rollback();
                    }
                    catch (Exception ex) {
                        JTADUnitTest.fail((String)("failed due to : " + ex));
                    }
                    int ifAnyRows = jtaObj.getRows(tblName);
                    JTADUnitTest.assertEquals((String)"first row not found in case of Simple Datasource", (int)1, (int)ifAnyRows);
                    boolean matched = jtaObj.checkTableAgainstData(tblName, tblIDFld + "");
                    JTADUnitTest.assertEquals((String)"first row PK didn't matched", (boolean)true, (boolean)matched);
                    break block33;
                }
                ta.rollback();
            }
            catch (Exception e) {
                JTADUnitTest.fail((String)(" failed due to: " + e));
                ta.rollback();
            }
            finally {
                if (conn != null) {
                    try {
                        conn.close();
                    }
                    catch (SQLException e) {}
                }
            }
        }
        JTADUnitTest.getLogWriter().fine("test task for testscenario 11 Successful!");
        try {
            JTADUnitTest.getLogWriter().fine("Destroying table: " + tblName);
            CacheUtils.destroyTable((String)tblName);
            JTADUnitTest.getLogWriter().fine("Closing cache...");
            JTADUnitTest.getLogWriter().fine("destroyTable for testscenario 11 Successful!");
        }
        catch (Exception e) {
            JTADUnitTest.fail((String)(" failed during tear down of this test..." + e));
        }
        finally {
            CacheUtils.closeCache();
            DistributedTestCase.disconnectFromDS();
        }
    }

    public static void test14() {
        Host host = Host.getHost(0);
        VM vm0 = host.getVM(0);
        JTADUnitTest.getLogWriter().fine("test14 is getting executed");
        vm0.invoke(JTADUnitTest.class, "Scenario14");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void Scenario14() throws Exception {
        Region currRegion = null;
        String tblName = null;
        String tableName = null;
        try {
            DistributedSystem ds = new JTADUnitTest("temp").setProperty();
            tableName = CacheUtils.init((DistributedSystem)ds, (String)"CacheTest");
            JTADUnitTest.getLogWriter().fine("Table name: " + tableName);
            tblName = tableName;
            if (tableName == null || tableName.equals("")) {
                JTADUnitTest.fail((String)" table name not created, Aborting test...");
            }
        }
        catch (Exception e) {
            JTADUnitTest.fail((String)(" Aborting test at set up...[" + e + "]"));
        }
        JTADUnitTest.getLogWriter().fine("init for testscenario 14 Successful!");
        Cache cache = CacheUtils.getCache();
        currRegion = cache.getRegion("/root");
        String TABLEID = "2";
        JTAUtils jtaObj = new JTAUtils(cache, currRegion);
        try {
            Context ctx = cache.getJNDIContext();
            UserTransaction utx = (UserTransaction)ctx.lookup("java:/UserTransaction");
            utx.begin();
            AttributesFactory fac = new AttributesFactory(currRegion.getAttributes());
            fac.setCacheLoader((CacheLoader)new XACacheLoaderTxn(tblName));
            Region re = currRegion.createSubregion("employee", fac.create());
            String retVal = (String)re.get((Object)"2");
            if (!retVal.equals("newname")) {
                JTADUnitTest.fail((String)("Uncommitted value 'newname' not read by cacheloader name = " + retVal));
            }
            utx.rollback();
            DataSource ds = (DataSource)ctx.lookup("java:/XAPooledDataSource");
            Connection conn = ds.getConnection();
            Statement stm = conn.createStatement();
            String str = "select name from " + tblName + "  where id= (2)";
            ResultSet rs = stm.executeQuery(str);
            rs.next();
            String str1 = rs.getString(1);
            if (!str1.equals("name2")) {
                JTADUnitTest.fail((String)"Rollback not occured on XAConnection got in a cache loader");
            }
        }
        catch (Exception e) {
            JTADUnitTest.fail((String)(" failed due to :" + e));
        }
        JTADUnitTest.getLogWriter().fine("test task for testscenario 14 Successful!");
        try {
            JTADUnitTest.getLogWriter().fine("Destroying table: " + tblName);
            CacheUtils.destroyTable((String)tblName);
            JTADUnitTest.getLogWriter().fine("Closing cache...");
            JTADUnitTest.getLogWriter().fine("destroyTable for testscenario 14 Successful!");
        }
        catch (Exception e) {
            JTADUnitTest.fail((String)(" failed during tear down of this test..." + e));
        }
        finally {
            CacheUtils.closeCache();
            DistributedTestCase.disconnectFromDS();
        }
    }

    public static void test15() {
        Host host = Host.getHost(0);
        VM vm0 = host.getVM(0);
        JTADUnitTest.getLogWriter().fine("test15 is getting executed");
        vm0.invoke(JTADUnitTest.class, "Scenario15");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void Scenario15() throws Exception {
        Region currRegion = null;
        String tblName = null;
        String tableName = null;
        try {
            DistributedSystem ds = new JTADUnitTest("temp").setProperty();
            tableName = CacheUtils.init((DistributedSystem)ds, (String)"CacheTest");
            JTADUnitTest.getLogWriter().fine("Table name: " + tableName);
            tblName = tableName;
            if (tableName == null || tableName.equals("")) {
                JTADUnitTest.fail((String)" table name not created, Aborting test...");
            }
        }
        catch (Exception e) {
            JTADUnitTest.fail((String)(" Aborting test at set up...[" + e + "]"));
        }
        JTADUnitTest.getLogWriter().fine("init for testscenario 15 Successful!");
        Cache cache = CacheUtils.getCache();
        currRegion = cache.getRegion("/root");
        String tbl = "";
        boolean row_num = true;
        int ddl_return = 1;
        JTAUtils jtaObj = new JTAUtils(cache, currRegion);
        jtaObj.deleteRows(tblName);
        Context ctx = cache.getJNDIContext();
        Connection conn = null;
        Statement stmt = null;
        try {
            DataSource da = (DataSource)ctx.lookup("java:/XAPooledDataSource");
            conn = da.getConnection();
            stmt = conn.createStatement();
            String time = new Long(System.currentTimeMillis()).toString();
            tbl = "my_table" + time;
            String sql = "create table " + tbl + " (my_id integer NOT NULL, my_name varchar(50), CONSTRAINT my_keyx PRIMARY KEY(my_id))";
            ddl_return = stmt.executeUpdate(sql);
            sql = "select * from " + tbl;
            ResultSet rs = null;
            rs = stmt.executeQuery(sql);
            row_num = rs.next();
            rs.close();
            if (ddl_return == 0 && !row_num) {
                sql = "drop table " + tbl;
                try {
                    stmt = conn.createStatement();
                    stmt.executeUpdate(sql);
                }
                catch (SQLException e) {
                    JTADUnitTest.fail((String)(" failed to drop, " + e));
                }
            } else {
                JTADUnitTest.fail((String)"unable to create table");
            }
            stmt.close();
            conn.close();
        }
        catch (NamingException e) {
            JTADUnitTest.fail((String)("failed, " + e));
        }
        catch (SQLException e) {
            JTADUnitTest.fail((String)("failed, " + e));
        }
        catch (Exception e) {
            JTADUnitTest.fail((String)("failed, " + e));
        }
        finally {
            if (conn != null) {
                try {
                    conn.close();
                }
                catch (SQLException ex) {
                    JTADUnitTest.fail((String)("Exception: " + ex));
                }
            }
        }
        JTADUnitTest.getLogWriter().fine("test task for test scenario 15 Successful!");
        try {
            JTADUnitTest.getLogWriter().fine("Destroying table: " + tblName);
            CacheUtils.destroyTable((String)tblName);
            JTADUnitTest.getLogWriter().fine("Closing cache...");
            JTADUnitTest.getLogWriter().fine("destroyTable for testscenario 15 Successful!");
        }
        catch (Exception e) {
            JTADUnitTest.fail((String)(" failed during tear down of this test..." + e));
        }
        finally {
            CacheUtils.closeCache();
            DistributedTestCase.disconnectFromDS();
        }
    }

    public static void test16() {
        Host host = Host.getHost(0);
        VM vm0 = host.getVM(0);
        JTADUnitTest.getLogWriter().fine("test16 is getting executed");
        vm0.invoke(JTADUnitTest.class, "Scenario16");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void Scenario16() throws Exception {
        Region currRegion = null;
        String tblName = null;
        String tableName = null;
        try {
            DistributedSystem ds = new JTADUnitTest("temp").setProperty();
            tableName = CacheUtils.init((DistributedSystem)ds, (String)"CacheTest");
            JTADUnitTest.getLogWriter().fine("Table name: " + tableName);
            tblName = tableName;
            if (tableName == null || tableName.equals("")) {
                JTADUnitTest.fail((String)" table name not created, Aborting test...");
            }
        }
        catch (Exception e) {
            JTADUnitTest.fail((String)(" Aborting test at set up...[" + e + "]"));
        }
        JTADUnitTest.getLogWriter().fine("init for testscenario 16  Successful!");
        Cache cache = CacheUtils.getCache();
        currRegion = cache.getRegion("/root");
        String tbl = "";
        int ddl_return = 1;
        boolean row_num = true;
        JTAUtils jtaObj = new JTAUtils(cache, currRegion);
        jtaObj.deleteRows(tblName);
        Context ctx = cache.getJNDIContext();
        Connection conn = null;
        Statement stmt = null;
        try {
            DataSource da = (DataSource)ctx.lookup("java:/XAPooledDataSource");
            conn = da.getConnection();
            conn.setAutoCommit(false);
            stmt = conn.createStatement();
            String time = new Long(System.currentTimeMillis()).toString();
            tbl = "my_table" + time;
            String sql = "create table " + tbl + " (my_id integer NOT NULL, my_name varchar(50), CONSTRAINT my_key PRIMARY KEY(my_id))";
            ddl_return = stmt.executeUpdate(sql);
            sql = "select * from " + tbl;
            ResultSet rs = null;
            rs = stmt.executeQuery(sql);
            row_num = rs.next();
            rs.close();
            if (ddl_return == 0 && !row_num) {
                sql = "drop table " + tbl;
                try {
                    stmt = conn.createStatement();
                    stmt.executeUpdate(sql);
                }
                catch (SQLException e) {
                    JTADUnitTest.fail((String)(" failed to drop, " + e));
                }
            } else {
                JTADUnitTest.fail((String)"table do not exists");
            }
            conn.setAutoCommit(true);
            stmt.close();
            conn.close();
        }
        catch (NamingException e) {
            JTADUnitTest.fail((String)("failed, " + e));
        }
        catch (SQLException e) {
            JTADUnitTest.fail((String)("failed, " + e));
        }
        catch (Exception e) {
            JTADUnitTest.fail((String)("failed, " + e));
        }
        finally {
            if (conn != null) {
                try {
                    conn.close();
                }
                catch (SQLException e) {}
            }
        }
        JTADUnitTest.getLogWriter().fine("test task for testscenario 16 Successful!");
        try {
            JTADUnitTest.getLogWriter().fine("Destroying table: " + tblName);
            CacheUtils.destroyTable((String)tblName);
            JTADUnitTest.getLogWriter().fine("Closing cache...");
            JTADUnitTest.getLogWriter().fine("destroyTable for testscenario 16 Successful!");
        }
        catch (Exception e) {
            JTADUnitTest.fail((String)(" failed during tear down of this test..." + e));
        }
        finally {
            CacheUtils.closeCache();
            DistributedTestCase.disconnectFromDS();
        }
    }

    public static void test18() {
        Host host = Host.getHost(0);
        VM vm0 = host.getVM(0);
        JTADUnitTest.getLogWriter().fine("test18 is getting executed");
        vm0.invoke(JTADUnitTest.class, "Scenario18");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void Scenario18() throws Exception {
        Region currRegion = null;
        String tblName = null;
        String tableName = null;
        try {
            DistributedSystem ds = new JTADUnitTest("temp").setProperty();
            tableName = CacheUtils.init((DistributedSystem)ds, (String)"CacheTest");
            JTADUnitTest.getLogWriter().fine("Table name: " + tableName);
            tblName = tableName;
            if (tableName == null || tableName.equals("")) {
                JTADUnitTest.fail((String)" table name not created, Aborting test...");
            }
        }
        catch (Exception e) {
            JTADUnitTest.fail((String)(" Aborting test at set up...[" + e + "]"));
        }
        JTADUnitTest.getLogWriter().fine("init for testscenario 18 Successful!");
        Cache cache = CacheUtils.getCache();
        currRegion = cache.getRegion("/root");
        int tblIDFld = 18;
        String tblNameFld = "test18";
        boolean rollback_chances = true;
        int ifAnyRows = 0;
        JTAUtils jtaObj = new JTAUtils(cache, currRegion);
        jtaObj.deleteRows(tblName);
        Context ctx = cache.getJNDIContext();
        UserTransaction ta = null;
        Connection conn1 = null;
        Connection conn2 = null;
        Statement stmt = null;
        DataSource da = null;
        try {
            da = (DataSource)ctx.lookup("java:/PooledDataSource");
            conn1 = da.getConnection();
            ta = (UserTransaction)ctx.lookup("java:/UserTransaction");
        }
        catch (NamingException e) {
            JTADUnitTest.fail((String)("failed: " + e));
        }
        catch (SQLException e) {
            JTADUnitTest.fail((String)("failed: " + e));
        }
        try {
            ta.begin();
            stmt = conn1.createStatement();
            String sqlSTR = "insert into " + tblName + " values (" + tblIDFld + "," + "'" + tblNameFld + "'" + ")";
            stmt.executeUpdate(sqlSTR);
            stmt.close();
            ifAnyRows = jtaObj.getRows(tblName);
            if (ifAnyRows == 0) {
                JTADUnitTest.fail((String)"failed no rows are there...");
            }
            da = (DataSource)ctx.lookup("java:/XAPooledDataSource");
            conn2 = da.getConnection();
            stmt = conn2.createStatement();
            sqlSTR = "insert into " + tblName + " values (" + ++tblIDFld + "," + "'" + tblNameFld + "'" + ")";
            stmt.executeUpdate(sqlSTR);
            ta.rollback();
            stmt.close();
            conn2.close();
            conn1.close();
            rollback_chances = false;
            ifAnyRows = jtaObj.getRows(tblName);
            JTADUnitTest.assertEquals((String)"at least one row not retained after rollback", (int)1, (int)ifAnyRows);
            boolean matched = jtaObj.checkTableAgainstData(tblName, tblIDFld + "");
            if (matched) {
                JTADUnitTest.fail((String)(", PK " + tblIDFld + " found in db)" + "   " + "rollback for conn #2 failed"));
            }
        }
        catch (Exception e) {
            JTADUnitTest.fail((String)("failed, " + e));
            if (rollback_chances) {
                ta.rollback();
            }
        }
        finally {
            if (conn1 != null) {
                try {
                    conn1.close();
                }
                catch (SQLException ex) {
                    JTADUnitTest.fail((String)(" Exception: " + ex));
                }
            }
            if (conn2 != null) {
                try {
                    conn2.close();
                }
                catch (SQLException ex) {
                    JTADUnitTest.fail((String)(" Exception: " + ex));
                }
            }
        }
        JTADUnitTest.getLogWriter().fine("test task for testscenario 18 Successful!");
        try {
            JTADUnitTest.getLogWriter().fine("Destroying table: " + tblName);
            CacheUtils.destroyTable((String)tblName);
            JTADUnitTest.getLogWriter().fine("Closing cache...");
            JTADUnitTest.getLogWriter().fine("destroyTable for testscenario 18 Successful!");
        }
        catch (Exception e) {
            JTADUnitTest.fail((String)(" failed during tear down of this test..." + e));
        }
        finally {
            CacheUtils.closeCache();
            DistributedTestCase.disconnectFromDS();
        }
    }

    public static void test19() {
        Host host = Host.getHost(0);
        VM vm0 = host.getVM(0);
        JTADUnitTest.getLogWriter().fine("test19 is getting executed");
        vm0.invoke(JTADUnitTest.class, "Scenario19");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void Scenario19() {
        Region currRegion = null;
        String tblName = null;
        String tableName = null;
        try {
            DistributedSystem ds = new JTADUnitTest("temp").setProperty();
            tableName = CacheUtils.init((DistributedSystem)ds, (String)"CacheTest");
            JTADUnitTest.getLogWriter().fine("Table name: " + tableName);
            tblName = tableName;
            if (tableName == null || tableName.equals("")) {
                JTADUnitTest.fail((String)" table name not created, Aborting test...");
            }
        }
        catch (Exception e) {
            JTADUnitTest.fail((String)(" Aborting test at set up...[" + e + "]"));
        }
        JTADUnitTest.getLogWriter().fine("init for testscenario 19 Successful!");
        Cache cache = CacheUtils.getCache();
        currRegion = cache.getRegion("/root");
        JTAUtils jtaObj = new JTAUtils(cache, currRegion);
        String maxKey = new XACacheWriterTxn(tblName).getData("select max(id) from " + tblName);
        int nextKey = Integer.valueOf(maxKey) + 1;
        try {
            String value;
            Context ctx = cache.getJNDIContext();
            UserTransaction utx = (UserTransaction)ctx.lookup("java:/UserTransaction");
            AttributesFactory fac = new AttributesFactory(currRegion.getAttributes());
            Region nextEmployee = currRegion.createSubregion("nextemployee", fac.create());
            fac.setCacheWriter((CacheWriter)new XACacheWriterTxn(tblName));
            Region employee = currRegion.createSubregion("employee", fac.create());
            employee.put((Object)("" + nextKey), (Object)("name" + nextKey));
            String newMaxKey = new XACacheWriterTxn(tblName).getData("select max(id) from " + tblName);
            if (!newMaxKey.equals("" + nextKey)) {
                JTADUnitTest.fail((String)" Data was not found in Database ");
            }
            if (!(value = (String)nextEmployee.get((Object)("" + nextKey))).equals("name" + nextKey)) {
                JTADUnitTest.fail((String)" Data was not replicated in nextemployee region ");
            }
            utx.begin();
            employee.put((Object)("" + ++nextKey), (Object)("name" + nextKey));
            if (!employee.get((Object)("" + nextKey)).equals("name" + nextKey)) {
                JTADUnitTest.fail((String)" Got different value in get operation ");
            }
            utx.rollback();
            newMaxKey = new XACacheWriterTxn(tblName).getData("select max(id) from " + tblName);
            if (Integer.valueOf(newMaxKey) - nextKey != -1) {
                JTADUnitTest.fail((String)" Data was not rolledback in Database ");
            }
            if ((value = (String)nextEmployee.get((Object)("" + nextKey))) != null) {
                JTADUnitTest.fail((String)(" Data was not rolledback in nextemployee region : value found was : " + value));
            }
            utx.begin();
            employee.put((Object)("" + nextKey), (Object)("name" + nextKey));
            utx.commit();
            value = new XACacheWriterTxn(tblName).getData("select name from " + tblName + " where id = " + nextKey);
            if (!value.equals("name" + nextKey)) {
                JTADUnitTest.fail((String)" Data was not updated in Database ");
            }
            if (!(value = (String)nextEmployee.get((Object)("" + nextKey))).equals("name" + nextKey)) {
                JTADUnitTest.fail((String)" Data was not replicated in nextemployee region ");
            }
            utx.begin();
            employee.put((Object)("" + nextKey), (Object)("name" + (nextKey + 1)));
            utx.commit();
            value = new XACacheWriterTxn(tblName).getData("select name from " + tblName + " where id = " + nextKey);
            if (!value.equals("name" + (nextKey + 1))) {
                JTADUnitTest.fail((String)" Data was not updated in Database ");
            }
            if (!(value = (String)nextEmployee.get((Object)("" + nextKey))).equals("name" + (nextKey + 1))) {
                JTADUnitTest.fail((String)" Data was not replicated in nextemployee region ");
            }
            utx.begin();
            employee.destroy((Object)("" + nextKey));
            utx.commit();
            value = new XACacheWriterTxn(tblName).getData("select count(id) from " + tblName + " where id = " + nextKey);
            if (Integer.valueOf(value) != 0) {
                JTADUnitTest.fail((String)" Data was not not destroyed in Database ");
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            JTADUnitTest.fail((String)(" failed due to :" + e.getMessage()));
        }
        JTADUnitTest.getLogWriter().fine("test task for testscenario 19 Successful!");
        try {
            JTADUnitTest.getLogWriter().fine("Destroying table: " + tblName);
            CacheUtils.destroyTable((String)tblName);
            JTADUnitTest.getLogWriter().fine("Closing cache...");
            JTADUnitTest.getLogWriter().fine("destroyTable for testscenario 19 Successful!");
        }
        catch (Exception e) {
            JTADUnitTest.fail((String)(" failed during tear down of this test..." + e));
        }
        finally {
            CacheUtils.closeCache();
            DistributedTestCase.disconnectFromDS();
        }
    }

    public static void testBug46169() throws Exception {
        Host host = Host.getHost(0);
        VM vm0 = host.getVM(0);
        JTADUnitTest.getLogWriter().fine("testBug46169 is getting executed");
        vm0.invoke(JTADUnitTest.class, "bug46169");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void bug46169() throws Exception {
        String tableName = null;
        try {
            DistributedSystem ds = new JTADUnitTest("temp").setProperty();
            tableName = CacheUtils.init((DistributedSystem)ds, (String)"CacheTest");
            JTADUnitTest.getLogWriter().fine("Table name: " + tableName);
            if (tableName == null || tableName.equals("")) {
                JTADUnitTest.fail((String)" table name not created, Aborting test...");
            }
        }
        catch (Exception e) {
            JTADUnitTest.fail((String)(" Aborting test at set up...[" + e + "]"));
        }
        JTADUnitTest.getLogWriter().fine("init for bug46169 Successful!");
        Cache cache = CacheUtils.getCache();
        TransactionManager xmanager = (TransactionManager)cache.getJNDIContext().lookup("java:/TransactionManager");
        JTADUnitTest.assertNotNull((Object)xmanager);
        Transaction trans = xmanager.suspend();
        JTADUnitTest.assertNull((Object)trans);
        try {
            JTADUnitTest.getLogWriter().fine("Destroying table: " + tableName);
            CacheUtils.destroyTable((String)tableName);
            JTADUnitTest.getLogWriter().fine("Closing cache...");
            JTADUnitTest.getLogWriter().fine("destroyTable for bug46169 Successful!");
        }
        catch (Exception e) {
            JTADUnitTest.fail((String)(" failed during tear down of this test..." + e));
        }
        finally {
            CacheUtils.closeCache();
            DistributedTestCase.disconnectFromDS();
        }
    }

    public static void testBug46192() throws Exception {
        Host host = Host.getHost(0);
        VM vm0 = host.getVM(0);
        JTADUnitTest.getLogWriter().fine("testBug46192 is getting executed");
        vm0.invoke(JTADUnitTest.class, "bug46192");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void bug46192() throws Exception {
        String tableName = null;
        try {
            DistributedSystem ds = new JTADUnitTest("temp").setProperty();
            tableName = CacheUtils.init((DistributedSystem)ds, (String)"CacheTest");
            JTADUnitTest.getLogWriter().fine("Table name: " + tableName);
            if (tableName == null || tableName.equals("")) {
                JTADUnitTest.fail((String)" table name not created, Aborting test...");
            }
        }
        catch (Exception e) {
            JTADUnitTest.fail((String)(" Aborting test at set up...[" + e + "]"));
        }
        JTADUnitTest.getLogWriter().fine("init for bug46192 Successful!");
        Cache cache = CacheUtils.getCache();
        TransactionManager xmanager = (TransactionManager)cache.getJNDIContext().lookup("java:/TransactionManager");
        JTADUnitTest.assertNotNull((Object)xmanager);
        try {
            xmanager.rollback();
        }
        catch (IllegalStateException illegalStateException) {
        }
        catch (Exception e) {
            JTADUnitTest.fail("Wrong exception type when there is no transaction to rollback for current thread.", e);
        }
        try {
            xmanager.commit();
        }
        catch (IllegalStateException e) {
        }
        catch (Exception e) {
            JTADUnitTest.fail("Wrong exception type when there is no transaction to commit for current thread.", e);
        }
        try {
            JTADUnitTest.getLogWriter().fine("Destroying table: " + tableName);
            CacheUtils.destroyTable((String)tableName);
            JTADUnitTest.getLogWriter().fine("Closing cache...");
            JTADUnitTest.getLogWriter().fine("destroyTable for bug46192 Successful!");
        }
        catch (Exception e) {
            JTADUnitTest.fail((String)(" failed during tear down of this test..." + e));
        }
        finally {
            CacheUtils.closeCache();
            DistributedTestCase.disconnectFromDS();
        }
    }

    private static String readFile(String filename) throws IOException {
        BufferedReader br = new BufferedReader(new FileReader(filename));
        String nextLine = "";
        StringBuffer sb = new StringBuffer();
        while ((nextLine = br.readLine()) != null) {
            sb.append(nextLine);
        }
        JTADUnitTest.getLogWriter().fine("***********\n " + sb);
        return sb.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testBug43987() {
        InternalDistributedSystem ds = null;
        try {
            ds = this.getMcastSystem();
            CacheFactory cf = new CacheFactory(ds.getProperties());
            Cache c = cf.create();
            RegionFactory rf = c.createRegionFactory(RegionShortcut.REPLICATE);
            Region r = rf.create("JTA_reg");
            r.put((Object)"key", (Object)"value");
            c.close();
            Cache cache1 = cf.create();
            RegionFactory rf1 = cache1.createRegionFactory(RegionShortcut.REPLICATE);
            Region r1 = rf1.create("JTA_reg");
            r1.put((Object)"key1", (Object)"value");
        }
        finally {
            if (ds != null) {
                ds.disconnect();
            }
        }
    }

    static class XACacheWriterTxn
    implements CacheWriter {
        String tableName;

        public XACacheWriterTxn(String str) {
            this.tableName = str;
        }

        public void beforeUpdate(EntryEvent arg0) throws CacheWriterException {
            String key = (String)arg0.getKey();
            String newValue = (String)arg0.getNewValue();
            String oldValue = (String)arg0.getOldValue();
            String query = "update " + this.tableName + " set name = '" + newValue + "' where id = (" + new Integer(key) + ")";
            this.executeQuery(query);
            try {
                Region r = arg0.getRegion();
                Region newRegion = r.getParentRegion().getSubregion("nextemployee");
                newRegion.put((Object)key, (Object)newValue);
            }
            catch (TimeoutException te) {
                throw new CacheClosedException("Beforecreate timeout exception" + (Object)((Object)te));
            }
        }

        public void beforeCreate(EntryEvent arg0) throws CacheWriterException {
            String key = (String)arg0.getKey();
            String newValue = (String)arg0.getNewValue();
            String oldValue = (String)arg0.getOldValue();
            String query = "insert into " + this.tableName + " values (" + new Integer(key) + " , '" + newValue + "')";
            this.executeQuery(query);
            try {
                Region r = arg0.getRegion();
                Region newRegion = r.getParentRegion().getSubregion("nextemployee");
                newRegion.put((Object)key, (Object)newValue);
            }
            catch (TimeoutException te) {
                throw new CacheClosedException("Beforecreate timeout exception" + (Object)((Object)te));
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected String getData(String query) {
            String returnValue = "";
            Connection conn = null;
            Statement stm = null;
            try {
                Context ctx = CacheFactory.getAnyInstance().getJNDIContext();
                DataSource ds = (DataSource)ctx.lookup("java:/SimpleDataSource");
                conn = ds.getConnection();
                stm = conn.createStatement();
                ResultSet rs = stm.executeQuery(query);
                rs.next();
                returnValue = rs.getString(1);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            finally {
                try {
                    if (stm != null) {
                        stm.close();
                        stm = null;
                    }
                    if (conn != null) {
                        conn.close();
                        conn = null;
                    }
                }
                catch (SQLException sq) {
                    sq.printStackTrace();
                }
            }
            return returnValue;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private int executeQuery(String query) {
            int returnValue = 0;
            Connection conn = null;
            Statement stm = null;
            try {
                Context ctx = CacheFactory.getAnyInstance().getJNDIContext();
                DataSource ds = (DataSource)ctx.lookup("java:/XAPooledDataSource");
                conn = ds.getConnection();
                stm = conn.createStatement();
                returnValue = stm.executeUpdate(query);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            finally {
                try {
                    if (stm != null) {
                        stm.close();
                        stm = null;
                    }
                    if (conn != null) {
                        conn.close();
                        conn = null;
                    }
                }
                catch (SQLException sq) {
                    sq.printStackTrace();
                }
            }
            return returnValue;
        }

        public void beforeDestroy(EntryEvent arg0) throws CacheWriterException {
            String key = (String)arg0.getKey();
            String newValue = (String)arg0.getNewValue();
            String oldValue = (String)arg0.getOldValue();
            String query = "delete from " + this.tableName + " where id = (" + new Integer(key) + ")";
            this.executeQuery(query);
            try {
                Region r = arg0.getRegion();
                Region newRegion = r.getParentRegion().getSubregion("nextemployee");
                newRegion.destroy((Object)key);
            }
            catch (TimeoutException te) {
                throw new CacheClosedException("Beforecreate timeout exception" + (Object)((Object)te));
            }
            catch (EntryNotFoundException enfe) {
                throw new CacheClosedException("Beforecreate CapacityControllerException exception" + (Object)((Object)enfe));
            }
        }

        public void beforeRegionDestroy(RegionEvent arg0) throws CacheWriterException {
        }

        public void beforeRegionClear(RegionEvent arg0) throws CacheWriterException {
        }

        public void close() {
        }
    }

    static class XACacheLoaderTxn
    implements CacheLoader {
        String tableName;

        public XACacheLoaderTxn(String str) {
            this.tableName = str;
        }

        public final Object load(LoaderHelper helper) throws CacheLoaderException {
            DistributedTestCase.getLogWriter().fine("In Loader.load for" + helper.getKey());
            return this.loadFromDatabase(helper.getKey());
        }

        private Object loadFromDatabase(Object ob) {
            String obj = null;
            try {
                Context ctx = CacheFactory.getAnyInstance().getJNDIContext();
                DataSource ds = (DataSource)ctx.lookup("java:/XAPooledDataSource");
                Connection conn = ds.getConnection();
                Statement stm = conn.createStatement();
                String str = "update " + this.tableName + " set name ='newname' where id = (" + new Integer(ob.toString()) + ")";
                stm.executeUpdate(str);
                ResultSet rs = stm.executeQuery("select name from " + this.tableName + " where id = (" + new Integer(ob.toString()) + ")");
                rs.next();
                obj = rs.getString(1);
                stm.close();
                conn.close();
                return obj;
            }
            catch (Exception e) {
                e.printStackTrace();
                return obj;
            }
        }

        public void close() {
        }
    }
}

