/*
 * Decompiled with CFR 0.152.
 */
package com.gemstone.gemfire.internal.jta.dunit;

import com.gemstone.gemfire.cache.Cache;
import com.gemstone.gemfire.cache.CacheFactory;
import com.gemstone.gemfire.distributed.DistributedSystem;
import dunit.AsyncInvocation;
import dunit.DistributedTestCase;
import dunit.Host;
import dunit.VM;
import hydra.ProcessMgr;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.IOException;
import java.io.OutputStreamWriter;
import java.sql.Connection;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.Properties;
import javax.naming.Context;
import javax.naming.NamingException;
import javax.sql.DataSource;

public class LoginTimeOutDUnitTest
extends DistributedTestCase {
    static DistributedSystem ds;
    static Cache cache;
    private static String tblName;
    protected static volatile boolean runTest1Ready;
    protected static volatile boolean runTest2Done;

    private static String readFile(String filename) throws IOException {
        BufferedReader br = new BufferedReader(new FileReader(filename));
        String nextLine = "";
        StringBuffer sb = new StringBuffer();
        while ((nextLine = br.readLine()) != null) {
            sb.append(nextLine);
        }
        LoginTimeOutDUnitTest.getLogWriter().info("***********\n " + sb);
        return sb.toString();
    }

    public LoginTimeOutDUnitTest(String name) {
        super(name);
    }

    private static String modifyFile(String str) throws IOException {
        String search = "<jndi-binding type=\"XAPooledDataSource\"";
        String last_search = "</jndi-binding>";
        String newDB = "newDB_" + ProcessMgr.getProcessId();
        String jndi_str = "<jndi-binding type=\"XAPooledDataSource\" jndi-name=\"XAPooledDataSource\"          jdbc-driver-class=\"org.apache.derby.jdbc.EmbeddedDriver\" init-pool-size=\"1\" max-pool-size=\"1\" idle-timeout-seconds=\"600\" blocking-timeout-seconds=\"60\" login-timeout-seconds=\"1\" conn-pooled-datasource-class=\"org.apache.derby.jdbc.EmbeddedConnectionPoolDataSource\" xa-datasource-class=\"org.apache.derby.jdbc.EmbeddedXADataSource\" user-name=\"mitul\" password=\"83f0069202c571faf1ae6c42b4ad46030e4e31c17409e19a\" connection-url=\"jdbc:derby:" + newDB + ";create=true\" >";
        String config_prop = "<config-property><config-property-name>description</config-property-name><config-property-type>java.lang.String</config-property-type><config-property-value>hi</config-property-value></config-property><config-property><config-property-name>user</config-property-name><config-property-type>java.lang.String</config-property-type><config-property-value>mitul</config-property-value></config-property><config-property><config-property-name>password</config-property-name><config-property-type>java.lang.String</config-property-type><config-property-value>83f0069202c571faf1ae6c42b4ad46030e4e31c17409e19a</config-property-value>        </config-property><config-property><config-property-name>databaseName</config-property-name><config-property-type>java.lang.String</config-property-type><config-property-value>" + newDB + "</config-property-value>" + "</config-property>\n";
        String new_str = jndi_str + config_prop;
        int n1 = str.indexOf(search);
        LoginTimeOutDUnitTest.getLogWriter().info("Start Index = " + n1);
        int n2 = str.indexOf(last_search, n1);
        StringBuffer sbuff = new StringBuffer(str);
        LoginTimeOutDUnitTest.getLogWriter().info("END Index = " + n2);
        String modified_str = sbuff.replace(n1, n2, new_str).toString();
        return modified_str;
    }

    public static String init(String className) throws Exception {
        LoginTimeOutDUnitTest.getLogWriter().info("PATH11 ");
        Properties props = new Properties();
        String jtest = System.getProperty("JTESTS");
        int pid = ProcessMgr.getProcessId();
        String path = System.getProperty("JTESTS") + "/lib/dunit-cachejta_" + pid + ".xml";
        LoginTimeOutDUnitTest.getLogWriter().info("PATH " + path);
        String file_as_str = LoginTimeOutDUnitTest.readFile(jtest + "/lib/cachejta.xml");
        file_as_str = file_as_str.replaceAll("newDB", "newDB_" + pid);
        String modified_file_str = LoginTimeOutDUnitTest.modifyFile(file_as_str);
        FileOutputStream fos = new FileOutputStream(path);
        BufferedWriter wr = new BufferedWriter(new OutputStreamWriter(fos));
        wr.write(modified_file_str);
        wr.flush();
        wr.close();
        props.setProperty("cache-xml-file", path);
        String tableName = "";
        try {
            ds = new LoginTimeOutDUnitTest("temp").getSystem(props);
            cache = CacheFactory.create((DistributedSystem)ds);
            if (className != null && !className.equals("")) {
                String time = new Long(System.currentTimeMillis()).toString();
                tableName = className + time;
                LoginTimeOutDUnitTest.createTable(tableName);
            }
        }
        catch (Exception e) {
            e.printStackTrace(System.err);
            throw e;
        }
        tblName = tableName;
        return tableName;
    }

    public static void createTable(String tableName) throws NamingException, SQLException {
        Context ctx = cache.getJNDIContext();
        DataSource ds = (DataSource)ctx.lookup("java:/SimpleDataSource");
        String sql = "create table " + tableName + " (id integer NOT NULL, name varchar(50), CONSTRAINT the_key PRIMARY KEY(id))";
        LoginTimeOutDUnitTest.getLogWriter().info(sql);
        Connection conn = ds.getConnection();
        Statement sm = conn.createStatement();
        sm.execute(sql);
        sm.close();
        sm = conn.createStatement();
        for (int i = 1; i <= 10; ++i) {
            sql = "insert into " + tableName + " values (" + i + ",'name" + i + "')";
            sm.addBatch(sql);
            LoginTimeOutDUnitTest.getLogWriter().info(sql);
        }
        sm.executeBatch();
        conn.close();
    }

    public static void destroyTable() throws NamingException, SQLException {
        try {
            String tableName = tblName;
            Context ctx = cache.getJNDIContext();
            DataSource ds = (DataSource)ctx.lookup("java:/SimpleDataSource");
            Connection conn = ds.getConnection();
            LoginTimeOutDUnitTest.getLogWriter().info(" trying to drop table: " + tableName);
            String sql = "drop table " + tableName;
            Statement sm = conn.createStatement();
            sm.execute(sql);
            conn.close();
        }
        catch (NamingException ne) {
            LoginTimeOutDUnitTest.getLogWriter().info("destroy table naming exception: " + ne);
            throw ne;
        }
        catch (SQLException se) {
            LoginTimeOutDUnitTest.getLogWriter().info("destroy table sql exception: " + se);
            throw se;
        }
        LoginTimeOutDUnitTest.closeCache();
    }

    public static Cache getCache() {
        return cache;
    }

    public static void startCache() {
        try {
            if (cache.isClosed()) {
                cache = CacheFactory.create((DistributedSystem)ds);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static void closeCache() {
        try {
            if (!cache.isClosed()) {
                cache.close();
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        try {
            ds.disconnect();
        }
        catch (Exception e) {
            LoginTimeOutDUnitTest.getLogWriter().info("Error in disconnecting from Distributed System");
        }
    }

    @Override
    public void setUp() throws Exception {
        Host host = Host.getHost(0);
        VM vm0 = host.getVM(0);
        Object[] o = new Object[]{"LoginTimeOutDUnitTest"};
        vm0.invoke(LoginTimeOutDUnitTest.class, "init", o);
    }

    @Override
    public void tearDown2() throws NamingException, SQLException {
        Host host = Host.getHost(0);
        VM vm0 = host.getVM(0);
        vm0.invoke(LoginTimeOutDUnitTest.class, "destroyTable");
    }

    public static void testLoginTimeOut() throws Throwable {
        Host host = Host.getHost(0);
        VM vm0 = host.getVM(0);
        AsyncInvocation test1 = vm0.invokeAsync(LoginTimeOutDUnitTest.class, "runTest1");
        AsyncInvocation test2 = vm0.invokeAsync(LoginTimeOutDUnitTest.class, "runTest2");
        DistributedTestCase.join(test2, 30000L, LoginTimeOutDUnitTest.getLogWriter());
        if (test2.exceptionOccurred()) {
            LoginTimeOutDUnitTest.fail("asyncObj failed", test2.getException());
        }
        DistributedTestCase.join(test1, 30000L, LoginTimeOutDUnitTest.getLogWriter());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    public static void runTest1() throws Exception {
        block11: {
            boolean MAX_CONNECTIONS = true;
            DataSource ds = null;
            try {
                try {
                    Context ctx = cache.getJNDIContext();
                    ds = (DataSource)ctx.lookup("java:/XAPooledDataSource");
                }
                catch (NamingException e) {
                    LoginTimeOutDUnitTest.getLogWriter().info("Naming Exception caught in lookup: " + e);
                    LoginTimeOutDUnitTest.fail((String)("failed in naming lookup: " + e));
                    runTest1Ready = true;
                    return;
                }
                catch (Exception e) {
                    LoginTimeOutDUnitTest.getLogWriter().info("Exception caught during naming lookup: " + e);
                    LoginTimeOutDUnitTest.fail((String)("failed in naming lookup: " + e));
                    runTest1Ready = true;
                    return;
                }
                try {
                    for (int count = 0; count < 1; ++count) {
                        ds.getConnection();
                    }
                    break block11;
                }
                catch (Exception e) {
                    LoginTimeOutDUnitTest.getLogWriter().info("Exception caught in runTest1: " + e);
                    LoginTimeOutDUnitTest.fail((String)("Exception caught in runTest1: " + e));
                    e.printStackTrace();
                    break block11;
                }
                {
                    catch (Throwable throwable) {
                        throw throwable;
                    }
                }
            }
            finally {
                runTest1Ready = true;
            }
        }
        LoginTimeOutDUnitTest.getLogWriter().info("runTest1 got all of the goodies and is now sleeping");
        DistributedTestCase.WaitCriterion ev = new DistributedTestCase.WaitCriterion(){

            @Override
            public boolean done() {
                return runTest2Done;
            }

            @Override
            public String description() {
                return null;
            }
        };
        DistributedTestCase.waitForCriterion(ev, 60000L, 200L, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    public static void runTest2() throws Exception {
        block12: {
            try {
                LoginTimeOutDUnitTest.getLogWriter().info("runTest2 sleeping");
                DistributedTestCase.WaitCriterion ev = new DistributedTestCase.WaitCriterion(){

                    @Override
                    public boolean done() {
                        return runTest1Ready;
                    }

                    @Override
                    public String description() {
                        return null;
                    }
                };
                DistributedTestCase.waitForCriterion(ev, 60000L, 200L, true);
                DataSource ds = null;
                try {
                    Context ctx = cache.getJNDIContext();
                    ds = (DataSource)ctx.lookup("java:/XAPooledDataSource");
                }
                catch (NamingException e) {
                    LoginTimeOutDUnitTest.getLogWriter().info("Exception caught during naming lookup: " + e);
                    LoginTimeOutDUnitTest.fail((String)("failed in naming lookup: " + e));
                    runTest2Done = true;
                    return;
                }
                catch (Exception e) {
                    LoginTimeOutDUnitTest.getLogWriter().info("Exception caught during naming lookup: " + e);
                    LoginTimeOutDUnitTest.fail((String)("failed in because of unhandled excpetion: " + e));
                    runTest2Done = true;
                    return;
                }
                try {
                    LoginTimeOutDUnitTest.getLogWriter().info("runTest2 about to acquire connection ");
                    ds.getConnection();
                    LoginTimeOutDUnitTest.fail((String)"expected a Login time-out exceeded");
                }
                catch (SQLException sqle) {
                    if (sqle.getMessage().indexOf("Login time-out exceeded") == -1) {
                        LoginTimeOutDUnitTest.getLogWriter().info("Exception caught in runTest2: " + sqle);
                        sqle.printStackTrace();
                        LoginTimeOutDUnitTest.fail((String)("failed because of unhandled exception : " + sqle));
                    }
                    break block12;
                }
                catch (Exception e) {
                    LoginTimeOutDUnitTest.getLogWriter().info("Exception caught in runTest2: " + e);
                    e.printStackTrace();
                    LoginTimeOutDUnitTest.fail((String)("failed because of unhandled exception : " + e));
                }
                break block12;
                {
                    catch (Throwable throwable) {
                        throw throwable;
                    }
                }
            }
            finally {
                runTest2Done = true;
            }
        }
    }

    static {
        runTest1Ready = false;
        runTest2Done = false;
    }
}

