/*
 * Decompiled with CFR 0.152.
 */
package com.gemstone.gemfire.internal.jta.dunit;

import com.gemstone.gemfire.cache.Cache;
import com.gemstone.gemfire.cache.CacheFactory;
import com.gemstone.gemfire.distributed.DistributedSystem;
import dunit.AsyncInvocation;
import dunit.DistributedTestCase;
import dunit.Host;
import dunit.VM;
import hydra.ProcessMgr;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.IOException;
import java.io.OutputStreamWriter;
import java.sql.SQLException;
import java.util.Properties;
import javax.naming.Context;
import javax.naming.NamingException;
import javax.transaction.UserTransaction;

public class TxnTimeOutDUnitTest
extends DistributedTestCase {
    static DistributedSystem ds;
    static Cache cache;
    private static String tblName;
    private boolean exceptionOccured = false;

    public TxnTimeOutDUnitTest(String name) {
        super(name);
    }

    public static void init() throws Exception {
        Properties props = new Properties();
        int pid = ProcessMgr.getProcessId();
        String path = System.getProperty("JTESTS") + "/lib/dunit-cachejta_" + pid + ".xml";
        String file_as_str = TxnTimeOutDUnitTest.readFile(System.getProperty("JTESTS") + "/lib/cachejta.xml");
        String modified_file_str = file_as_str.replaceAll("newDB", "newDB_" + pid);
        FileOutputStream fos = new FileOutputStream(path);
        BufferedWriter wr = new BufferedWriter(new OutputStreamWriter(fos));
        wr.write(modified_file_str);
        wr.flush();
        wr.close();
        props.setProperty("cache-xml-file", path);
        props.setProperty("log-level", TxnTimeOutDUnitTest.getDUnitLogLevel());
        try {
            ds = new TxnTimeOutDUnitTest("temp").getSystem(props);
            if (cache == null || cache.isClosed()) {
                cache = CacheFactory.create((DistributedSystem)ds);
            }
        }
        catch (Exception e) {
            e.printStackTrace(System.err);
            throw new Exception("" + e);
        }
    }

    public static Cache getCache() {
        return cache;
    }

    public static void startCache() {
        try {
            if (cache.isClosed()) {
                cache = CacheFactory.create((DistributedSystem)ds);
            }
        }
        catch (Exception e) {
            TxnTimeOutDUnitTest.fail((String)("Exception in starting cache due to " + e));
            e.printStackTrace();
        }
    }

    public static void closeCache() {
        try {
            if (cache != null && !cache.isClosed()) {
                cache.close();
            }
            if (ds != null && ds.isConnected()) {
                ds.disconnect();
            }
        }
        catch (Exception e) {
            TxnTimeOutDUnitTest.fail((String)("Exception in closing cache or ds due to " + e));
            e.printStackTrace();
        }
    }

    @Override
    public void setUp() throws Exception {
        Host host = Host.getHost(0);
        VM vm0 = host.getVM(0);
        vm0.invoke(TxnTimeOutDUnitTest.class, "init");
    }

    @Override
    public void tearDown2() throws NamingException, SQLException {
        Host host = Host.getHost(0);
        VM vm0 = host.getVM(0);
        vm0.invoke(TxnTimeOutDUnitTest.class, "closeCache");
    }

    public void testMultiThreaded() throws NamingException, SQLException, Throwable {
        try {
            Host host = Host.getHost(0);
            VM vm0 = host.getVM(0);
            Object[] o = new Object[]{new Integer(2)};
            AsyncInvocation asyncObj1 = vm0.invokeAsync(TxnTimeOutDUnitTest.class, "runTest3", o);
            Object[] o1 = new Object[]{new Integer(2)};
            AsyncInvocation asyncObj2 = vm0.invokeAsync(TxnTimeOutDUnitTest.class, "runTest3", o1);
            Object[] o2 = new Object[]{new Integer(3)};
            AsyncInvocation asyncObj3 = vm0.invokeAsync(TxnTimeOutDUnitTest.class, "runTest3", o2);
            Object[] o3 = new Object[]{new Integer(3)};
            AsyncInvocation asyncObj4 = vm0.invokeAsync(TxnTimeOutDUnitTest.class, "runTest3", o3);
            Object[] o4 = new Object[]{new Integer(1)};
            AsyncInvocation asyncObj5 = vm0.invokeAsync(TxnTimeOutDUnitTest.class, "runTest3", o4);
            DistributedTestCase.join(asyncObj1, 300000L, TxnTimeOutDUnitTest.getLogWriter());
            if (asyncObj1.exceptionOccurred()) {
                TxnTimeOutDUnitTest.fail("asyncObj1 failed", asyncObj1.getException());
            }
            DistributedTestCase.join(asyncObj2, 300000L, TxnTimeOutDUnitTest.getLogWriter());
            if (asyncObj2.exceptionOccurred()) {
                TxnTimeOutDUnitTest.fail("asyncObj2 failed", asyncObj2.getException());
            }
            DistributedTestCase.join(asyncObj3, 300000L, TxnTimeOutDUnitTest.getLogWriter());
            if (asyncObj3.exceptionOccurred()) {
                TxnTimeOutDUnitTest.fail("asyncObj3 failed", asyncObj3.getException());
            }
            DistributedTestCase.join(asyncObj4, 300000L, TxnTimeOutDUnitTest.getLogWriter());
            if (asyncObj4.exceptionOccurred()) {
                TxnTimeOutDUnitTest.fail("asyncObj4 failed", asyncObj4.getException());
            }
            DistributedTestCase.join(asyncObj5, 300000L, TxnTimeOutDUnitTest.getLogWriter());
            if (asyncObj5.exceptionOccurred()) {
                TxnTimeOutDUnitTest.fail("asyncObj5 failed", asyncObj5.getException());
            }
        }
        catch (Exception e) {
            TxnTimeOutDUnitTest.fail((String)("exception occured in testMultiThreaded due to " + e));
            e.printStackTrace();
        }
    }

    public static void testLoginTimeOut() throws Throwable {
        Host host = Host.getHost(0);
        VM vm0 = host.getVM(0);
        AsyncInvocation asyncObj1 = vm0.invokeAsync(TxnTimeOutDUnitTest.class, "runTest2");
        AsyncInvocation asyncObj2 = vm0.invokeAsync(TxnTimeOutDUnitTest.class, "runTest1");
        DistributedTestCase.join(asyncObj1, 300000L, TxnTimeOutDUnitTest.getLogWriter());
        if (asyncObj1.exceptionOccurred()) {
            TxnTimeOutDUnitTest.fail("asyncObj1 failed", asyncObj1.getException());
        }
        DistributedTestCase.join(asyncObj2, 300000L, TxnTimeOutDUnitTest.getLogWriter());
        if (asyncObj2.exceptionOccurred()) {
            TxnTimeOutDUnitTest.fail("asyncObj2 failed", asyncObj2.getException());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void runTest1() throws Exception {
        boolean exceptionOccured = false;
        try {
            system.getLogWriter().fine("<ExpectedException action=add> +DistributedSystemDisconnectedException</ExpectedException>");
            Context ctx = cache.getJNDIContext();
            UserTransaction utx = (UserTransaction)ctx.lookup("java:/UserTransaction");
            utx.begin();
            utx.setTransactionTimeout(2);
            Thread.sleep(6000L);
            try {
                utx.commit();
            }
            catch (Exception e) {
                exceptionOccured = true;
            }
            if (!exceptionOccured) {
                TxnTimeOutDUnitTest.fail((String)"Exception did not occur although was supposed to occur");
            }
        }
        catch (Exception e) {
            TxnTimeOutDUnitTest.getLogWriter().fine("Exception caught " + e);
            TxnTimeOutDUnitTest.fail((String)("failed in naming lookup: " + e));
        }
        finally {
            system.getLogWriter().fine("<ExpectedException action=remove> +DistributedSystemDisconnectedException</ExpectedException>");
        }
    }

    public static void runTest2() throws Exception {
        boolean exceptionOccured = false;
        try {
            Context ctx = cache.getJNDIContext();
            UserTransaction utx = (UserTransaction)ctx.lookup("java:/UserTransaction");
            utx.begin();
            utx.setTransactionTimeout(2);
            Thread.sleep(6000L);
            try {
                utx.commit();
            }
            catch (Exception e) {
                exceptionOccured = true;
            }
            if (!exceptionOccured) {
                TxnTimeOutDUnitTest.fail((String)"Exception did not occur although was supposed to occur");
            }
        }
        catch (Exception e) {
            TxnTimeOutDUnitTest.getLogWriter().fine("Exception caught " + e);
            TxnTimeOutDUnitTest.fail((String)("failed in naming lookup: " + e));
        }
    }

    public static void runTest3(Object o) {
        boolean exceptionOccured = false;
        try {
            int sleeptime = (Integer)o;
            Context ctx = cache.getJNDIContext();
            UserTransaction utx = (UserTransaction)ctx.lookup("java:/UserTransaction");
            utx.begin();
            utx.setTransactionTimeout(sleeptime);
            Thread.sleep(sleeptime * 2000);
            try {
                utx.commit();
            }
            catch (Exception e) {
                exceptionOccured = true;
            }
            if (!exceptionOccured) {
                TxnTimeOutDUnitTest.fail((String)"exception did not occur although was supposed to occur");
            }
        }
        catch (Exception e) {
            TxnTimeOutDUnitTest.fail((String)("Exception in runTest3 due to " + e));
            e.printStackTrace();
        }
    }

    private static String readFile(String filename) throws IOException {
        BufferedReader br = new BufferedReader(new FileReader(filename));
        String nextLine = "";
        StringBuffer sb = new StringBuffer();
        while ((nextLine = br.readLine()) != null) {
            sb.append(nextLine);
        }
        TxnTimeOutDUnitTest.getLogWriter().fine("***********\n " + sb);
        return sb.toString();
    }

    static {
        cache = null;
    }
}

