/*
 * Decompiled with CFR 0.152.
 */
package com.gemstone.gemfire.internal.process;

import com.gemstone.gemfire.InternalGemFireError;
import com.gemstone.gemfire.internal.AvailablePortHelper;
import com.gemstone.gemfire.internal.process.ConnectionFailedException;
import com.gemstone.gemfire.internal.process.LocalProcessController;
import com.gemstone.gemfire.internal.process.LocalProcessControllerJUnitTest;
import com.gemstone.gemfire.internal.process.LocalProcessLauncher;
import com.gemstone.gemfire.internal.process.PidUnavailableException;
import com.gemstone.gemfire.internal.process.ProcessUtils;
import dunit.DistributedTestCase;
import dunit.Host;
import dunit.SerializableRunnable;
import java.io.File;
import java.io.IOException;
import java.lang.management.ManagementFactory;
import java.rmi.AlreadyBoundException;
import java.rmi.NotBoundException;
import java.rmi.Remote;
import java.rmi.RemoteException;
import java.rmi.registry.LocateRegistry;
import java.rmi.registry.Registry;
import java.rmi.server.UnicastRemoteObject;
import javax.management.MBeanServer;
import javax.management.ObjectName;
import junit.framework.TestCase;
import quickstart.ProcessWrapper;

public class LocalProcessControllerDUnitTest
extends DistributedTestCase {
    private static final String TEST_CASE = "LocalProcessControllerDUnitTest";
    private static final String FAILSAFE_BINDING = "LocalProcessControllerDUnitTest.FAILSAFE_BINDING";
    private int registryPort;

    public LocalProcessControllerDUnitTest(String name) {
        super(name);
    }

    @Override
    public void setUp() throws Exception {
        super.setUp();
        new File(TEST_CASE).mkdir();
        int[] tcpPorts = AvailablePortHelper.getRandomAvailableTCPPorts(1);
        this.registryPort = tcpPorts[0];
    }

    @Override
    public void tearDown2() throws Exception {
        this.invokeFailsafe();
    }

    public void testConnectPidMatchesDisconnect() throws Exception {
        final int pid = ProcessUtils.identifyPid();
        Host.getHost(0).getVM(0).invoke(new SerializableRunnable("LocalProcessControllerDUnitTest#testConnectPidMatchesDisconnect"){

            @Override
            public void run() {
                LocalProcessController stopper = null;
                try {
                    stopper = new LocalProcessController(pid);
                    stopper.connect();
                    TestCase.assertTrue((boolean)stopper.checkPidMatches());
                }
                catch (ConnectionFailedException e) {
                    throw new Error(e);
                }
                catch (IOException e) {
                    throw new Error(e);
                }
                catch (IllegalStateException e) {
                    throw new Error(e);
                }
                catch (PidUnavailableException e) {
                    throw new Error(e);
                }
                finally {
                    if (stopper != null) {
                        stopper.disconnect();
                    }
                }
            }
        });
    }

    public void testStartAndStopProcess() throws Exception {
        String testName = "testStartAndStopProcess";
        this.execAndValidate(new String[]{"" + this.registryPort, "testStartAndStopProcess"}, "LocalProcessControllerDUnitTest process running");
        File pidFile = new File(TEST_CASE + File.separator + "testStartAndStopProcess" + ".pid");
        ObjectName objectName = ObjectName.getInstance("LocalProcessControllerDUnitTest:testName=testStartAndStopProcess");
        String pidAttribute = "Pid";
        String method = "stop";
        LocalProcessController stopper = new LocalProcessController(pidFile);
        stopper.connect();
        LocalProcessControllerDUnitTest.assertTrue((boolean)stopper.checkPidMatches());
        stopper.disconnect();
        stopper.stop(objectName, "Pid", "stop", new String[]{"Process"}, new Object[]{Boolean.TRUE});
    }

    private void execAndValidate(String[] args, String regex) throws InterruptedException {
        ProcessWrapper process = new ProcessWrapper(this.getClass(), args);
        process.execute(null);
        if (regex != null) {
            process.waitForOutputToMatch(regex);
        }
    }

    private void invokeFailsafe() {
        try {
            Registry registry = LocateRegistry.getRegistry(this.registryPort);
            FailSafeRemote failsafe = (FailSafeRemote)registry.lookup(FAILSAFE_BINDING);
            failsafe.kill();
        }
        catch (RemoteException remoteException) {
        }
        catch (NotBoundException notBoundException) {
            // empty catch block
        }
    }

    public static void main(String[] args) throws Exception {
        if (args.length != 2) {
            throw new IllegalArgumentException("Requires two args: registry_port, test_name");
        }
        int registryPort = Integer.valueOf(args[0]);
        String testName = args[1];
        try {
            Registry registry = LocateRegistry.createRegistry(registryPort);
            FailSafe failsafe = new FailSafe();
            registry.bind(FAILSAFE_BINDING, failsafe);
        }
        catch (RemoteException ignore) {
            throw new InternalGemFireError((Throwable)ignore);
        }
        catch (AlreadyBoundException ignore) {
            throw new InternalGemFireError((Throwable)ignore);
        }
        File pidFile = new File(TEST_CASE + File.separator + testName + ".pid");
        LocalProcessLauncher launcher = new LocalProcessLauncher(pidFile, false);
        int pid = launcher.getPid();
        LocalProcessControllerJUnitTest.Process process = new LocalProcessControllerJUnitTest.Process(pid, true);
        ObjectName objectName = ObjectName.getInstance("LocalProcessControllerDUnitTest:testName=" + testName);
        MBeanServer server = ManagementFactory.getPlatformMBeanServer();
        server.registerMBean(process, objectName);
        process.waitUntilStopped();
    }

    public static class FailSafe
    extends UnicastRemoteObject
    implements FailSafeRemote {
        private static final long serialVersionUID = 4419392070588214807L;

        @Override
        public void kill() throws RemoteException {
            System.exit(0);
        }
    }

    public static interface FailSafeRemote
    extends Remote {
        public void kill() throws RemoteException;
    }
}

