/*
 * Decompiled with CFR 0.152.
 */
package com.gemstone.gemfire.internal.size;

import com.gemstone.gemfire.DataSerializable;
import com.gemstone.gemfire.DataSerializer;
import com.gemstone.gemfire.internal.HeapDataOutputStream;
import com.gemstone.gemfire.internal.shared.Version;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;

public class ObjectTraverserPerf {
    private static final int ITERATIONS = 1000;
    private static final int OBJECT_DEPTH = 1000;
    private static final boolean USE_SERIALIZATION = true;

    public static void main(String[] args) throws IllegalArgumentException, IllegalAccessException, IOException {
        int i;
        TestObject testObject = new TestObject(null);
        for (i = 0; i < 1000; ++i) {
            testObject = new TestObject(testObject);
        }
        for (i = 0; i < 1000; ++i) {
            ObjectTraverserPerf.calcSize(testObject);
        }
        long start = System.nanoTime();
        for (int i2 = 0; i2 < 1000; ++i2) {
            ObjectTraverserPerf.calcSize(testObject);
        }
        long end = System.nanoTime();
        System.out.println("Sized object of depth 1000 for 1000 iterations elapsed(ns) :" + (end - start));
    }

    private static void calcSize(TestObject testObject) throws IllegalAccessException, IOException {
        HeapDataOutputStream out = new HeapDataOutputStream(Version.CURRENT);
        testObject.toData((DataOutput)out);
    }

    public static class TestObject
    implements DataSerializable {
        public int field1;
        public int field2;
        public final String field3 = new String("hello");
        public final DataSerializable field4;

        public TestObject(DataSerializable field4) {
            this.field4 = field4;
        }

        public void fromData(DataInput in) throws IOException, ClassNotFoundException {
            throw new UnsupportedOperationException("Don't need this method for the test");
        }

        public void toData(DataOutput out) throws IOException {
            out.write(this.field1);
            out.write(this.field2);
            DataSerializer.writeString((String)this.field3, (DataOutput)out);
            if (this.field4 != null) {
                this.field4.toData(out);
            }
        }
    }
}

