/*
 * Decompiled with CFR 0.152.
 */
package com.gemstone.gemfire.management;

import com.gemstone.gemfire.cache.Cache;
import com.gemstone.gemfire.cache.client.internal.LocatorTestBase;
import com.gemstone.gemfire.cache.query.IndexExistsException;
import com.gemstone.gemfire.cache.query.IndexInvalidException;
import com.gemstone.gemfire.cache.query.IndexNameConflictException;
import com.gemstone.gemfire.cache.query.QueryService;
import com.gemstone.gemfire.cache.query.RegionNotFoundException;
import com.gemstone.gemfire.cache.query.cq.dunit.CqQueryDUnitTest;
import com.gemstone.gemfire.cache.query.internal.CqService;
import com.gemstone.gemfire.distributed.DistributedMember;
import com.gemstone.gemfire.distributed.Locator;
import com.gemstone.gemfire.internal.AvailablePortHelper;
import com.gemstone.gemfire.internal.cache.GemFireCacheImpl;
import com.gemstone.gemfire.management.CacheServerMXBean;
import com.gemstone.gemfire.management.DistributedSystemMXBean;
import com.gemstone.gemfire.management.LocatorMXBean;
import com.gemstone.gemfire.management.MBeanUtil;
import com.gemstone.gemfire.management.ManagementService;
import com.gemstone.gemfire.management.ManagementTestBase;
import com.gemstone.gemfire.management.internal.JmxManagerLocatorRequest;
import com.gemstone.gemfire.management.internal.JmxManagerLocatorResponse;
import com.gemstone.gemfire.management.internal.MBeanJMXAdapter;
import com.gemstone.gemfire.management.internal.SystemManagementService;
import dunit.DistributedTestCase;
import dunit.Host;
import dunit.SerializableRunnable;
import dunit.VM;
import java.io.File;
import java.io.IOException;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.Collections;
import java.util.Properties;
import javax.management.InstanceNotFoundException;
import javax.management.MBeanServer;
import javax.management.Notification;
import javax.management.NotificationListener;
import javax.management.ObjectName;
import junit.framework.TestCase;

public class CacheServerManagementDUnitTest
extends LocatorTestBase {
    private static final long serialVersionUID = 1L;
    private static int CONNECT_LOCATOR_TIMEOUT_MS = 30000;
    private ManagementTestBase helper;
    private static final String queryName = "testClientWithFeederAndCQ_0";
    private static final String indexName = "testIndex";
    private static MBeanServer mbeanServer = MBeanJMXAdapter.mbeanServer;
    protected CqQueryDUnitTest cqDUnitTest = new CqQueryDUnitTest("CqDataDUnitTest");

    public CacheServerManagementDUnitTest(String name) {
        super(name);
        this.helper = new ManagementTestBase(name);
    }

    @Override
    public void setUp() throws Exception {
        CacheServerManagementDUnitTest.disconnectAllFromDS();
        super.setUp();
    }

    @Override
    public void tearDown2() throws Exception {
        super.tearDown2();
        CacheServerManagementDUnitTest.disconnectAllFromDS();
    }

    public void testCacheServerMBean() throws Exception {
        Host host = Host.getHost(0);
        VM server = host.getVM(0);
        VM client = host.getVM(1);
        VM managingNode = host.getVM(2);
        this.helper.createManagementCache(managingNode);
        this.helper.startManagingNode(managingNode);
        int serverPort = AvailablePortHelper.getRandomAvailableTCPPort();
        this.cqDUnitTest.createServer(server, serverPort);
        DistributedMember member = this.helper.getMember(server);
        this.verifyCacheServer(server, serverPort);
        int port = server.invokeInt(CqQueryDUnitTest.class, "getCacheServerPort");
        String host0 = CacheServerManagementDUnitTest.getServerHostName(server.getHost());
        this.cqDUnitTest.createClient(client, port, host0);
        this.cqDUnitTest.createCQ(client, queryName, this.cqDUnitTest.cqs[0]);
        this.cqDUnitTest.executeCQ(client, queryName, false, null);
        int size = 10;
        this.cqDUnitTest.createValues(client, this.cqDUnitTest.regions[0], 10);
        this.cqDUnitTest.waitForCreated(client, queryName, "key-10");
        this.cqDUnitTest.validateCQ(client, queryName, CqQueryDUnitTest.noTest, 10, 0, 0, 10, 0, 0, 10);
        CacheServerManagementDUnitTest.pause(2000);
        this.checkNavigation(managingNode, member, serverPort);
        this.verifyIndex(server, serverPort);
        this.verifyCacheServerRemote(managingNode, member, serverPort);
        this.verifyClosedCQ(server);
        this.cqDUnitTest.closeClient(client);
        this.cqDUnitTest.closeServer(server);
        this.helper.stopManagingNode(managingNode);
        this.helper.closeCache(client);
        this.helper.closeCache(server);
        this.helper.closeCache(managingNode);
    }

    public void testCacheClient() throws Exception {
        Host host = Host.getHost(0);
        VM locator = host.getVM(0);
        VM server = host.getVM(1);
        VM client = host.getVM(2);
        int locatorPort = AvailablePortHelper.getRandomAvailableTCPPortOnVM(locator);
        this.startLocatorInVM(locator, locatorPort, "");
        String locators = CacheServerManagementDUnitTest.getServerHostName(locator.getHost()) + "[" + locatorPort + "]";
        int serverPort = this.startBridgeServerInVM(server, null, locators);
        this.addClientNotifListener(server, serverPort);
        this.startBridgeClientInVM(client, null, CacheServerManagementDUnitTest.getServerHostName(locator.getHost()), locatorPort);
        this.stopBridgeMemberVM(client);
        this.helper.closeCache(locator);
        this.helper.closeCache(server);
        this.helper.closeCache(client);
    }

    public void DISABLEDtestBug46049() throws Exception {
        Host host = Host.getHost(0);
        VM locator = host.getVM(0);
        VM server = host.getVM(1);
        final int locatorPort = AvailablePortHelper.getRandomAvailableTCPPortOnVM(locator);
        this.startLocator(locator, locatorPort, "");
        String locators = CacheServerManagementDUnitTest.getServerHostName(locator.getHost()) + "[" + locatorPort + "]";
        int serverPort = this.startBridgeServerInVM(server, null, locators);
        server.invoke(new SerializableRunnable("Check Server"){

            @Override
            public void run() {
                GemFireCacheImpl cache = GemFireCacheImpl.getInstance();
                TestCase.assertNotNull((Object)cache);
                SystemManagementService service = (SystemManagementService)ManagementService.getExistingManagementService((Cache)cache);
                TestCase.assertNotNull((Object)service);
                TestCase.assertFalse((boolean)service.isManager());
                TestCase.assertNotNull((Object)service.getMemberMXBean());
                service.getLocalManager().runManagementTaskAdhoc();
            }
        });
        JmxManagerLocatorResponse locRes = JmxManagerLocatorRequest.send((String)locator.getHost().getHostName(), (int)locatorPort, (int)CONNECT_LOCATOR_TIMEOUT_MS, Collections.emptyMap());
        locator.invoke(new SerializableRunnable("Check locator"){

            @Override
            public void run() {
                GemFireCacheImpl cache = GemFireCacheImpl.getInstance();
                TestCase.assertNotNull((Object)cache);
                ManagementService service = ManagementService.getExistingManagementService((Cache)cache);
                TestCase.assertNotNull((Object)service);
                TestCase.assertTrue((boolean)service.isManager());
                LocatorMXBean bean = service.getLocalLocatorMXBean();
                TestCase.assertEquals((int)locatorPort, (int)bean.getPort());
                DistributedSystemMXBean dsBean = service.getDistributedSystemMXBean();
                ObjectName[] names = dsBean.listMemberObjectNames();
                TestCase.assertEquals((int)2, (int)dsBean.listMemberObjectNames().length);
            }
        });
        this.helper.closeCache(locator);
        this.helper.closeCache(server);
    }

    protected void startLocator(final VM vm, final int locatorPort, final String otherLocators) {
        vm.invoke(new SerializableRunnable("Create Locator"){
            final String testName;
            {
                super(x0);
                this.testName = CacheServerManagementDUnitTest.this.getUniqueName();
            }

            @Override
            public void run() {
                DistributedTestCase.disconnectFromDS();
                Properties props = new Properties();
                props.setProperty("mcast-port", String.valueOf(0));
                props.setProperty("locators", otherLocators);
                props.setProperty("log-level", DistributedTestCase.getDUnitLogLevel());
                props.setProperty("jmx-manager-http-port", "0");
                try {
                    File logFile = new File(this.testName + "-locator" + locatorPort + ".log");
                    InetAddress bindAddr = null;
                    try {
                        bindAddr = InetAddress.getByName(DistributedTestCase.getServerHostName(vm.getHost()));
                    }
                    catch (UnknownHostException uhe) {
                        DistributedTestCase.fail("While resolving bind address ", uhe);
                    }
                    Locator locator = Locator.startLocatorAndDS((int)locatorPort, (File)logFile, (InetAddress)bindAddr, (Properties)props);
                    remoteObjects.put("LOCATOR", locator);
                }
                catch (IOException ex) {
                    DistributedTestCase.fail("While starting locator on port " + locatorPort, ex);
                }
            }
        });
    }

    protected void checkNavigation(VM vm, final DistributedMember cacheServerMember, final int serverPort) {
        SerializableRunnable checkNavigation = new SerializableRunnable("Check Navigation"){

            @Override
            public void run() {
                CacheServerManagementDUnitTest.this.helper;
                ManagementService service = ManagementTestBase.getManagementService();
                DistributedSystemMXBean disMBean = service.getDistributedSystemMXBean();
                try {
                    ObjectName expected = MBeanJMXAdapter.getClientServiceMBeanName((int)serverPort, (String)cacheServerMember.getId());
                    ObjectName actual = disMBean.fetchCacheServerObjectName(cacheServerMember.getId(), serverPort);
                    TestCase.assertEquals((Object)expected, (Object)actual);
                }
                catch (Exception e) {
                    TestCase.fail((String)("Cache Server Navigation Failed " + e));
                }
                try {
                    TestCase.assertEquals((int)1, (int)disMBean.listCacheServerObjectNames().length);
                }
                catch (Exception e) {
                    TestCase.fail((String)("Cache Server Navigation Failed " + e));
                }
            }
        };
        vm.invoke(checkNavigation);
    }

    protected void addClientNotifListener(VM vm, final int serverPort) throws Exception {
        SerializableRunnable addClientNotifListener = new SerializableRunnable("Add Client Notif Listener"){

            @Override
            public void run() {
                GemFireCacheImpl cache = GemFireCacheImpl.getInstance();
                ManagementService service = ManagementService.getManagementService((Cache)cache);
                final CacheServerMXBean bean = service.getLocalCacheServerMXBean(serverPort);
                TestCase.assertNotNull((Object)bean);
                DistributedTestCase.WaitCriterion ev = new DistributedTestCase.WaitCriterion(){

                    @Override
                    public boolean done() {
                        return bean.isRunning();
                    }

                    @Override
                    public String description() {
                        return null;
                    }
                };
                DistributedTestCase.waitForCriterion(ev, 10000L, 200L, true);
                TestCase.assertTrue((boolean)bean.isRunning());
                TestCacheServerNotif nt = new TestCacheServerNotif();
                try {
                    mbeanServer.addNotificationListener(MBeanJMXAdapter.getClientServiceMBeanName((int)serverPort, (String)cache.getDistributedSystem().getMemberId()), nt, null, null);
                }
                catch (InstanceNotFoundException e) {
                    TestCase.fail((String)("Failed With Exception " + e));
                }
            }
        };
        vm.invoke(addClientNotifListener);
    }

    protected void verifyIndex(VM vm, final int serverPort) throws Exception {
        SerializableRunnable verifyIndex = new SerializableRunnable("Verify Index "){

            @Override
            public void run() {
                GemFireCacheImpl cache = GemFireCacheImpl.getInstance();
                ManagementService service = ManagementService.getManagementService((Cache)cache);
                QueryService qs = cache.getQueryService();
                try {
                    qs.createIndex(CacheServerManagementDUnitTest.indexName, "p.ID", "/root/" + CacheServerManagementDUnitTest.this.cqDUnitTest.regions[0]);
                }
                catch (RegionNotFoundException e) {
                    TestCase.fail((String)("Failed With Exception " + (Object)((Object)e)));
                }
                catch (IndexInvalidException e) {
                    TestCase.fail((String)("Failed With Exception " + (Object)((Object)e)));
                }
                catch (IndexNameConflictException e) {
                    TestCase.fail((String)("Failed With Exception " + (Object)((Object)e)));
                }
                catch (IndexExistsException e) {
                    TestCase.fail((String)("Failed With Exception " + (Object)((Object)e)));
                }
                catch (UnsupportedOperationException e) {
                    TestCase.fail((String)("Failed With Exception " + e));
                }
                CacheServerMXBean bean = service.getLocalCacheServerMXBean(serverPort);
                TestCase.assertEquals((int)bean.getIndexCount(), (int)1);
                DistributedTestCase.getLogWriter().info("<ExpectedString> Index is   " + bean.getIndexList()[0] + "</ExpectedString> ");
                try {
                    bean.removeIndex(CacheServerManagementDUnitTest.indexName);
                }
                catch (Exception e) {
                    TestCase.fail((String)("Failed With Exception " + e));
                }
                TestCase.assertEquals((int)bean.getIndexCount(), (int)0);
            }
        };
        vm.invoke(verifyIndex);
    }

    protected void verifyClosedCQ(VM vm) throws Exception {
        SerializableRunnable verifyClosedCQ = new SerializableRunnable("Verify Closed CQ"){

            @Override
            public void run() {
                CqService cqService = CqService.getRunningCqService();
                if (cqService != null) {
                    TestCase.assertNull((Object)cqService.getCq(CacheServerManagementDUnitTest.queryName));
                }
            }
        };
        vm.invoke(verifyClosedCQ);
    }

    protected void verifyCacheServer(VM vm, final int serverPort) throws Exception {
        SerializableRunnable verifyCacheServer = new SerializableRunnable("Verify Cache Server"){

            @Override
            public void run() {
                GemFireCacheImpl cache = GemFireCacheImpl.getInstance();
                ManagementService service = ManagementService.getManagementService((Cache)cache);
                final CacheServerMXBean bean = service.getLocalCacheServerMXBean(serverPort);
                TestCase.assertNotNull((Object)bean);
                DistributedTestCase.WaitCriterion ev = new DistributedTestCase.WaitCriterion(){

                    @Override
                    public boolean done() {
                        return bean.isRunning();
                    }

                    @Override
                    public String description() {
                        return null;
                    }
                };
                DistributedTestCase.waitForCriterion(ev, 10000L, 200L, true);
                TestCase.assertTrue((boolean)bean.isRunning());
                CacheServerManagementDUnitTest.this.assertCacheServerConfig(bean);
            }
        };
        vm.invoke(verifyCacheServer);
    }

    protected void assertCacheServerConfig(CacheServerMXBean bean) {
        CacheServerManagementDUnitTest.assertEquals((String)"", (String)bean.getBindAddress());
        CacheServerManagementDUnitTest.assertEquals((String)"", (String)bean.getHostNameForClients());
        CacheServerManagementDUnitTest.assertEquals((int)32768, (int)bean.getSocketBufferSize());
        CacheServerManagementDUnitTest.assertEquals((int)60000, (int)bean.getMaximumTimeBetweenPings());
        CacheServerManagementDUnitTest.assertEquals((int)800, (int)bean.getMaxConnections());
        CacheServerManagementDUnitTest.assertEquals((int)0, (int)bean.getMaxThreads());
        CacheServerManagementDUnitTest.assertEquals((int)230000, (int)bean.getMaximumMessageCount());
        CacheServerManagementDUnitTest.assertEquals((int)180, (int)bean.getMessageTimeToLive());
        CacheServerManagementDUnitTest.assertEquals((long)5000L, (long)bean.getLoadPollInterval());
        CacheServerManagementDUnitTest.getLogWriter().info("<ExpectedString> LoadProbe of the Server is  " + bean.fetchLoadProbe().toString() + "</ExpectedString> ");
    }

    protected void verifyCacheServerRemote(VM vm, final DistributedMember serverMember, final int serverPort) {
        SerializableRunnable verifyCacheServerRemote = new SerializableRunnable("Verify Cache Server Remote"){

            @Override
            public void run() {
                GemFireCacheImpl cache = GemFireCacheImpl.getInstance();
                try {
                    CacheServerMXBean bean = MBeanUtil.getCacheServerMbeanProxy(serverMember, serverPort);
                    CacheServerManagementDUnitTest.this.assertCacheServerConfig(bean);
                    String clientId = bean.getClientIds()[0];
                    TestCase.assertNotNull((Object)clientId);
                    DistributedTestCase.getLogWriter().info("<ExpectedString> ClientId of the Server is  " + clientId + "</ExpectedString> ");
                    DistributedTestCase.getLogWriter().info("<ExpectedString> Active Query Count  " + bean.getActiveCQCount() + "</ExpectedString> ");
                    DistributedTestCase.getLogWriter().info("<ExpectedString> Registered Query Count  " + bean.getRegisteredCQCount() + "</ExpectedString> ");
                    bean.getContinuousQueryList();
                    bean.stopContinuousQuery(CacheServerManagementDUnitTest.queryName);
                    bean.executeContinuousQuery(CacheServerManagementDUnitTest.queryName);
                    bean.closeContinuousQuery(CacheServerManagementDUnitTest.queryName);
                }
                catch (Exception e) {
                    TestCase.fail((String)("Error while verifying cache server from remote member " + e));
                }
            }
        };
        vm.invoke(verifyCacheServerRemote);
    }

    private static class TestCacheServerNotif
    implements NotificationListener {
        private TestCacheServerNotif() {
        }

        @Override
        public void handleNotification(Notification notification, Object handback) {
            TestCase.assertNotNull((Object)notification);
            DistributedTestCase.getLogWriter().info("Expected String :" + notification.toString());
        }
    }
}

