/*
 * Decompiled with CFR 0.152.
 */
package com.gemstone.gemfire.management;

import com.gemstone.gemfire.internal.cache.GemFireCacheImpl;
import com.gemstone.gemfire.management.CompositeStats;
import com.gemstone.gemfire.management.CompositeTestMBean;
import com.gemstone.gemfire.management.CompositeTestMXBean;
import com.gemstone.gemfire.management.ManagementTestBase;
import com.gemstone.gemfire.management.internal.MBeanJMXAdapter;
import com.gemstone.gemfire.management.internal.SystemManagementService;
import dunit.DistributedTestCase;
import dunit.SerializableRunnable;
import dunit.VM;
import javax.management.MalformedObjectNameException;
import javax.management.ObjectName;

public class CompositeTypeTestDUnitTest
extends ManagementTestBase {
    private static final long serialVersionUID = 1L;
    private static ObjectName objectName;

    public CompositeTypeTestDUnitTest(String name) {
        super(name);
    }

    @Override
    public void setUp() throws Exception {
        super.setUp();
    }

    @Override
    public void tearDown2() throws Exception {
        super.tearDown2();
    }

    public void testCompositeTypeGetters() throws Exception {
        this.initManagement(false);
        String member = this.getMemberId(managedNode1);
        member = MBeanJMXAdapter.makeCompliantName((String)member);
        this.registerMBeanWithCompositeTypeGetters(managedNode1, member);
        this.checkMBeanWithCompositeTypeGetters(managingNode, member);
    }

    protected void registerMBeanWithCompositeTypeGetters(VM vm, String memberID) throws Exception {
        SerializableRunnable regMBean = new SerializableRunnable("Register CustomMBean with composite Type"){

            @Override
            public void run() {
                GemFireCacheImpl cache = GemFireCacheImpl.getInstance();
                SystemManagementService service = (SystemManagementService)ManagementTestBase.getManagementService();
                try {
                    ObjectName objectName = new ObjectName("GemFire:service=custom,type=composite");
                    CompositeTestMBean mbean = new CompositeTestMBean();
                    objectName = service.registerMBean((Object)mbean, objectName);
                    service.federate(objectName, CompositeTestMXBean.class, false);
                }
                catch (MalformedObjectNameException e) {
                    e.printStackTrace();
                }
                catch (NullPointerException e) {
                    e.printStackTrace();
                }
            }
        };
        vm.invoke(regMBean);
    }

    protected void checkMBeanWithCompositeTypeGetters(VM vm, final String memberID) throws Exception {
        SerializableRunnable checkMBean = new SerializableRunnable("Check CustomMBean with composite Type"){

            @Override
            public void run() {
                GemFireCacheImpl cache = GemFireCacheImpl.getInstance();
                final SystemManagementService service = (SystemManagementService)ManagementTestBase.getManagementService();
                try {
                    final ObjectName objectName = new ObjectName("GemFire:service=custom,type=composite,member=" + memberID);
                    DistributedTestCase.waitForCriterion(new DistributedTestCase.WaitCriterion(){

                        @Override
                        public String description() {
                            return "Waiting for Composite Type MBean";
                        }

                        @Override
                        public boolean done() {
                            CompositeTestMXBean bean = (CompositeTestMXBean)service.getMBeanInstance(objectName, CompositeTestMXBean.class);
                            boolean done = bean != null;
                            return done;
                        }
                    }, 8000L, 500L, true);
                    CompositeTestMXBean bean = (CompositeTestMXBean)service.getMBeanInstance(objectName, CompositeTestMXBean.class);
                    CompositeStats listData = bean.listCompositeStats();
                    System.out.println("connectionStatsType = " + listData.getConnectionStatsType());
                    System.out.println("connectionsOpened = " + listData.getConnectionsOpened());
                    System.out.println("connectionsClosed = " + listData.getConnectionsClosed());
                    System.out.println("connectionsAttempted = " + listData.getConnectionsAttempted());
                    System.out.println("connectionsFailed = " + listData.getConnectionsFailed());
                    CompositeStats getsData = bean.getCompositeStats();
                    System.out.println("connectionStatsType = " + getsData.getConnectionStatsType());
                    System.out.println("connectionsOpened = " + getsData.getConnectionsOpened());
                    System.out.println("connectionsClosed = " + getsData.getConnectionsClosed());
                    System.out.println("connectionsAttempted = " + getsData.getConnectionsAttempted());
                    System.out.println("connectionsFailed = " + getsData.getConnectionsFailed());
                    CompositeStats[] arrayData = bean.getCompositeArray();
                    Integer[] intArrayData = bean.getIntegerArray();
                    Thread.sleep(120000L);
                }
                catch (MalformedObjectNameException e) {
                    e.printStackTrace();
                }
                catch (NullPointerException e) {
                    e.printStackTrace();
                }
                catch (InterruptedException e) {
                    e.printStackTrace();
                }
            }
        };
        vm.invoke(checkMBean);
    }
}

