/*
 * Decompiled with CFR 0.152.
 */
package com.gemstone.gemfire.management;

import com.gemstone.gemfire.cache.Cache;
import com.gemstone.gemfire.distributed.DistributedMember;
import com.gemstone.gemfire.distributed.internal.InternalDistributedSystem;
import com.gemstone.gemfire.internal.LogWriterImpl;
import com.gemstone.gemfire.internal.ManagerLogWriter;
import com.gemstone.gemfire.internal.cache.GemFireCacheImpl;
import com.gemstone.gemfire.management.DistributedSystemMXBean;
import com.gemstone.gemfire.management.ManagementService;
import com.gemstone.gemfire.management.ManagementTestBase;
import com.gemstone.gemfire.management.internal.MBeanJMXAdapter;
import com.gemstone.gemfire.management.internal.NotificationHub;
import com.gemstone.gemfire.management.internal.SystemManagementService;
import com.gemstone.gemfire.management.internal.beans.MemberMBean;
import com.gemstone.gemfire.management.internal.beans.SequenceNumber;
import dunit.DistributedTestCase;
import dunit.Host;
import dunit.SerializableCallable;
import dunit.SerializableRunnable;
import dunit.VM;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.management.InstanceNotFoundException;
import javax.management.ListenerNotFoundException;
import javax.management.MBeanServer;
import javax.management.Notification;
import javax.management.NotificationListener;
import javax.management.ObjectName;
import junit.framework.TestCase;

public class DistributedSystemDUnitTest
extends ManagementTestBase {
    private static final long serialVersionUID = 1L;
    private static final int MAX_WAIT = 100000;
    private static MBeanServer mbeanServer = MBeanJMXAdapter.mbeanServer;
    static List<Notification> notifList = new ArrayList<Notification>();
    static Map<ObjectName, NotificationListener> notificationListenerMap = new HashMap<ObjectName, NotificationListener>();

    public DistributedSystemDUnitTest(String name) {
        super(name);
    }

    @Override
    public void setUp() throws Exception {
        super.setUp();
    }

    @Override
    public void tearDown2() throws Exception {
        super.tearDown2();
    }

    public void testDistributedSystemAggregate() throws Exception {
        VM managingNode = DistributedSystemDUnitTest.getManagingNode();
        this.createManagementCache(managingNode);
        this.startManagingNode(managingNode);
        this.addNotificationListener(managingNode);
        for (VM vm : DistributedSystemDUnitTest.getManagedNodeList()) {
            this.createCache(vm);
        }
        this.checkAggregate(managingNode);
        for (VM vm : DistributedSystemDUnitTest.getManagedNodeList()) {
            this.closeCache(vm);
        }
        this.closeCache(managingNode);
    }

    public void testAlert() throws Exception {
        VM managingNode = DistributedSystemDUnitTest.getManagingNode();
        this.createManagementCache(managingNode);
        this.startManagingNode(managingNode);
        this.addAlertListener(managingNode);
        this.resetAlertCounts(managingNode);
        DistributedMember managingMember = this.getMember(managingNode);
        for (VM vm : DistributedSystemDUnitTest.getManagedNodeList()) {
            this.createCache(vm);
            this.ensureLoggerState(vm, managingMember, 1000);
            this.warnLevelAlert(vm);
            this.severeLevelAlert(vm);
        }
        this.checkAlertCount(managingNode, 3, 0);
        this.resetAlertCounts(managingNode);
        this.setAlertLevel(managingNode, "warning");
        for (VM vm : DistributedSystemDUnitTest.getManagedNodeList()) {
            this.ensureLoggerState(vm, managingMember, 900);
            this.warnLevelAlert(vm);
            this.severeLevelAlert(vm);
        }
        this.checkAlertCount(managingNode, 3, 3);
        this.resetAlertCounts(managingNode);
        this.setAlertLevel(managingNode, "none");
        for (VM vm : DistributedSystemDUnitTest.getManagedNodeList()) {
            this.warnLevelAlert(vm);
            this.severeLevelAlert(vm);
        }
        this.checkAlertCount(managingNode, 0, 0);
        this.resetAlertCounts(managingNode);
        for (VM vm : DistributedSystemDUnitTest.getManagedNodeList()) {
            this.closeCache(vm);
        }
        this.closeCache(managingNode);
    }

    public void testAlertManagedNodeFirst() throws Exception {
        for (VM vm : DistributedSystemDUnitTest.getManagedNodeList()) {
            this.createCache(vm);
            this.warnLevelAlert(vm);
            this.severeLevelAlert(vm);
        }
        VM managingNode = DistributedSystemDUnitTest.getManagingNode();
        this.createManagementCache(managingNode);
        this.startManagingNode(managingNode);
        this.addAlertListener(managingNode);
        this.checkAlertCount(managingNode, 0, 0);
        DistributedMember managingMember = this.getMember(managingNode);
        for (VM vm : DistributedSystemDUnitTest.getManagedNodeList()) {
            this.ensureLoggerState(vm, managingMember, 1000);
            this.warnLevelAlert(vm);
            this.severeLevelAlert(vm);
        }
        this.checkAlertCount(managingNode, 3, 0);
        this.resetAlertCounts(managingNode);
        this.setAlertLevel(managingNode, "warning");
        for (VM vm : DistributedSystemDUnitTest.getManagedNodeList()) {
            this.ensureLoggerState(vm, managingMember, 900);
            this.warnLevelAlert(vm);
            this.severeLevelAlert(vm);
        }
        this.checkAlertCount(managingNode, 3, 3);
        this.resetAlertCounts(managingNode);
        for (VM vm : DistributedSystemDUnitTest.getManagedNodeList()) {
            this.closeCache(vm);
        }
        this.closeCache(managingNode);
    }

    public void ensureLoggerState(VM vm1, final DistributedMember member, final int alertLevel) throws Exception {
        vm1.invoke(new SerializableCallable("Ensure Logger State"){

            public Object call() throws Exception {
                DistributedTestCase.waitForCriterion(new DistributedTestCase.WaitCriterion(){

                    @Override
                    public String description() {
                        return "Waiting for all alert Listener to register with managed node";
                    }

                    @Override
                    public boolean done() {
                        return ((ManagerLogWriter)InternalDistributedSystem.getLoggerI18n()).hasAlertListenerFor(member, alertLevel);
                    }
                }, 100000L, 500L, true);
                return null;
            }
        });
    }

    public void testShutdownAll() throws Exception {
        Host host = Host.getHost(0);
        VM managedNode1 = host.getVM(0);
        VM managedNode2 = host.getVM(1);
        VM managedNode3 = host.getVM(2);
        VM managingNode = host.getVM(3);
        this.createManagementCache(managingNode);
        this.startManagingNode(managingNode);
        this.createCache(managedNode1);
        this.createCache(managedNode2);
        this.createCache(managedNode3);
        this.shutDownAll(managingNode);
        this.closeCache(managingNode);
    }

    public void testNavigationAPIS() throws Exception {
        Host host = Host.getHost(0);
        this.createManagementCache(managingNode);
        this.startManagingNode(managingNode);
        for (VM vm : managedNodeList) {
            this.createCache(vm);
        }
        this.checkNavigationAPIs(managingNode);
    }

    public void testNotificationHub() throws Exception {
        this.initManagement(false);
        managingNode.invoke(new SerializableRunnable("Add Listener to MemberMXBean"){

            @Override
            public void run() {
                Cache cache = DistributedSystemDUnitTest.this.getCache();
                ManagementService service = ManagementTestBase.getManagementService();
                final DistributedSystemMXBean bean = service.getDistributedSystemMXBean();
                DistributedTestCase.waitForCriterion(new DistributedTestCase.WaitCriterion(){

                    @Override
                    public String description() {
                        return "Waiting for all members to send their initial Data";
                    }

                    @Override
                    public boolean done() {
                        return bean.listMemberObjectNames().length == 5;
                    }
                }, 100000L, 500L, true);
                for (ObjectName objectName : bean.listMemberObjectNames()) {
                    class NotificationHubTestListener
                    implements NotificationListener {
                        NotificationHubTestListener() {
                        }

                        @Override
                        public void handleNotification(Notification notification, Object handback) {
                            notifList.add(notification);
                        }
                    }
                    NotificationHubTestListener listener = new NotificationHubTestListener();
                    try {
                        mbeanServer.addNotificationListener(objectName, listener, null, null);
                        notificationListenerMap.put(objectName, listener);
                    }
                    catch (InstanceNotFoundException e) {
                        DistributedTestCase.getLogWriter().error((Throwable)e);
                    }
                }
            }
        });
        for (VM vm : managedNodeList) {
            vm.invoke(new SerializableRunnable("Check Hub Listener num count"){

                @Override
                public void run() {
                    Cache cache = DistributedSystemDUnitTest.this.getCache();
                    SystemManagementService service = (SystemManagementService)ManagementTestBase.getManagementService();
                    NotificationHub hub = service.getNotificationHub();
                    Map listenerObjectMap = hub.getListenerObjectMap();
                    TestCase.assertEquals((int)1, (int)listenerObjectMap.keySet().size());
                    ObjectName memberMBeanName = MBeanJMXAdapter.getMemberMBeanName((DistributedMember)cache.getDistributedSystem().getDistributedMember());
                    NotificationHub.NotificationHubListener listener = (NotificationHub.NotificationHubListener)listenerObjectMap.get(memberMBeanName);
                    TestCase.assertEquals((int)2, (int)listener.getNumCounter());
                    MemberMBean memberLevelNotifEmitter = (MemberMBean)service.getMemberMXBean();
                    String memberSource = MBeanJMXAdapter.getMemberNameOrId((DistributedMember)cache.getDistributedSystem().getDistributedMember());
                    Notification notification = new Notification("gemfire.distributedsystem.cache.region.created", memberSource, SequenceNumber.next(), System.currentTimeMillis(), "Region Created With Name /test");
                    memberLevelNotifEmitter.sendNotification(notification);
                }
            });
        }
        managingNode.invoke(new SerializableRunnable("Check notifications && Remove Listeners"){

            @Override
            public void run() {
                DistributedTestCase.waitForCriterion(new DistributedTestCase.WaitCriterion(){

                    @Override
                    public String description() {
                        return "Waiting for all Notifications to reach the Managing Node";
                    }

                    @Override
                    public boolean done() {
                        return notifList.size() == 3;
                    }
                }, 100000L, 500L, true);
                notifList.clear();
                for (ObjectName objectName : notificationListenerMap.keySet()) {
                    NotificationListener listener = notificationListenerMap.get(objectName);
                    try {
                        mbeanServer.removeNotificationListener(objectName, listener);
                    }
                    catch (ListenerNotFoundException e) {
                        DistributedTestCase.getLogWriter().error((Throwable)e);
                    }
                    catch (InstanceNotFoundException e) {
                        DistributedTestCase.getLogWriter().error((Throwable)e);
                    }
                }
            }
        });
        for (VM vm : managedNodeList) {
            vm.invoke(new SerializableRunnable("Check Hub Listener num count Again"){

                @Override
                public void run() {
                    Cache cache = DistributedSystemDUnitTest.this.getCache();
                    SystemManagementService service = (SystemManagementService)ManagementTestBase.getManagementService();
                    NotificationHub hub = service.getNotificationHub();
                    Map listenerObjectMap = hub.getListenerObjectMap();
                    TestCase.assertEquals((int)1, (int)listenerObjectMap.keySet().size());
                    ObjectName memberMBeanName = MBeanJMXAdapter.getMemberMBeanName((DistributedMember)cache.getDistributedSystem().getDistributedMember());
                    NotificationHub.NotificationHubListener listener = (NotificationHub.NotificationHubListener)listenerObjectMap.get(memberMBeanName);
                    TestCase.assertEquals((int)1, (int)listener.getNumCounter());
                }
            });
        }
        for (VM vm : managedNodeList) {
            vm.invoke(new SerializableRunnable("Check Hub Listeners clean up"){

                @Override
                public void run() {
                    Cache cache = DistributedSystemDUnitTest.this.getCache();
                    SystemManagementService service = (SystemManagementService)ManagementTestBase.getManagementService();
                    NotificationHub hub = service.getNotificationHub();
                    hub.cleanUpListeners();
                    TestCase.assertEquals((int)0, (int)hub.getListenerObjectMap().size());
                    for (ObjectName objectName : notificationListenerMap.keySet()) {
                        NotificationListener listener = notificationListenerMap.get(objectName);
                        try {
                            mbeanServer.removeNotificationListener(objectName, listener);
                            TestCase.fail((String)"Found Listeners inspite of clearing them");
                        }
                        catch (ListenerNotFoundException listenerNotFoundException) {
                        }
                        catch (InstanceNotFoundException e) {
                            DistributedTestCase.getLogWriter().error((Throwable)e);
                        }
                    }
                }
            });
        }
    }

    public void checkAlertCount(VM vm1, final int expectedSevereAlertCount, final int expectedWarningAlertCount) throws Exception {
        vm1.invoke(new SerializableCallable("Check Alert Count"){

            public Object call() throws Exception {
                final AlertNotifListener nt = AlertNotifListener.getInstance();
                DistributedTestCase.waitForCriterion(new DistributedTestCase.WaitCriterion(){

                    @Override
                    public String description() {
                        return "Waiting for all alerts to reach the Managing Node";
                    }

                    @Override
                    public boolean done() {
                        return expectedSevereAlertCount == nt.getseverAlertCount() && expectedWarningAlertCount == nt.getWarnigAlertCount();
                    }
                }, 100000L, 500L, true);
                return null;
            }
        });
    }

    public void setAlertLevel(VM vm1, final String alertLevel) throws Exception {
        vm1.invoke(new SerializableCallable("Set Alert level"){

            public Object call() throws Exception {
                GemFireCacheImpl cache = GemFireCacheImpl.getInstance();
                ManagementService service = ManagementTestBase.getManagementService();
                DistributedSystemMXBean bean = service.getDistributedSystemMXBean();
                TestCase.assertNotNull((Object)bean);
                bean.changeAlertLevel(alertLevel);
                return null;
            }
        });
        DistributedSystemDUnitTest.pause(10000);
    }

    public void warnLevelAlert(VM vm1) throws Exception {
        vm1.invoke(new SerializableCallable("Warning level Alerts"){

            public Object call() throws Exception {
                DistributedTestCase.ExpectedException warnEx = DistributedTestCase.addExpectedException("Warninglevel Alert Message");
                ((LogWriterImpl)InternalDistributedSystem.getLoggerI18n()).warning("Warninglevel Alert Message ");
                warnEx.remove();
                return null;
            }
        });
    }

    public void resetAlertCounts(VM vm1) throws Exception {
        vm1.invoke(new SerializableCallable("Reset Alert Ccount"){

            public Object call() throws Exception {
                AlertNotifListener nt = AlertNotifListener.getInstance();
                nt.resetCount();
                return null;
            }
        });
    }

    public void severeLevelAlert(VM vm1) throws Exception {
        vm1.invoke(new SerializableCallable("Severe Level Alert"){

            public Object call() throws Exception {
                DistributedTestCase.ExpectedException severeEx = DistributedTestCase.addExpectedException("Severelevel Alert Message");
                ((LogWriterImpl)InternalDistributedSystem.getLoggerI18n()).severe("Severelevel Alert Message");
                severeEx.remove();
                return null;
            }
        });
    }

    public void addAlertListener(VM vm1) throws Exception {
        vm1.invoke(new SerializableCallable("Add Alert Listener"){

            public Object call() throws Exception {
                GemFireCacheImpl cache = GemFireCacheImpl.getInstance();
                ManagementService service = ManagementTestBase.getManagementService();
                DistributedSystemMXBean bean = service.getDistributedSystemMXBean();
                AlertNotifListener nt = AlertNotifListener.getInstance();
                nt.resetCount();
                mbeanServer.addNotificationListener(MBeanJMXAdapter.getDistributedSystemName(), nt, null, null);
                return null;
            }
        });
    }

    public void checkAggregate(VM vm1) throws Exception {
        vm1.invoke(new SerializableCallable("Chech Aggregate Attributes"){

            public Object call() throws Exception {
                GemFireCacheImpl cache = GemFireCacheImpl.getInstance();
                ManagementService service = ManagementTestBase.getManagementService();
                final DistributedSystemMXBean bean = service.getDistributedSystemMXBean();
                TestCase.assertNotNull((Object)service.getDistributedSystemMXBean());
                DistributedTestCase.waitForCriterion(new DistributedTestCase.WaitCriterion(){

                    @Override
                    public String description() {
                        return "Waiting All members to intitialize DistributedSystemMBean expect 5 but found " + bean.getMemberCount();
                    }

                    @Override
                    public boolean done() {
                        return bean.getMemberCount() == 5;
                    }
                }, 100000L, 500L, true);
                Set otherMemberSet = cache.getDistributionManager().getOtherNormalDistributionManagerIds();
                for (DistributedMember member : otherMemberSet) {
                    DistributedTestCase.getLogWriter().info("JVM Metrics For Member " + member.getId() + ":" + bean.showJVMMetrics(member.getId()));
                    DistributedTestCase.getLogWriter().info("OS Metrics For Member " + member.getId() + ":" + bean.showOSMetrics(member.getId()));
                }
                return null;
            }
        });
    }

    public void addNotificationListener(VM vm1) throws Exception {
        vm1.invoke(new SerializableCallable("Add Notification Listener"){

            public Object call() throws Exception {
                GemFireCacheImpl cache = GemFireCacheImpl.getInstance();
                ManagementService service = ManagementTestBase.getManagementService();
                DistributedSystemMXBean bean = service.getDistributedSystemMXBean();
                TestCase.assertNotNull((Object)bean);
                TestDistributedSystemNotif nt = new TestDistributedSystemNotif();
                mbeanServer.addNotificationListener(MBeanJMXAdapter.getDistributedSystemName(), nt, null, null);
                return null;
            }
        });
    }

    public void shutDownAll(VM vm1) throws Exception {
        vm1.invoke(new SerializableCallable("Shut Down All"){

            public Object call() throws Exception {
                GemFireCacheImpl cache = GemFireCacheImpl.getInstance();
                ManagementService service = ManagementTestBase.getManagementService();
                DistributedSystemMXBean bean = service.getDistributedSystemMXBean();
                TestCase.assertNotNull((Object)service.getDistributedSystemMXBean());
                bean.shutDownAllMembers();
                DistributedTestCase.staticPause(2000);
                TestCase.assertEquals((int)cache.getDistributedSystem().getAllOtherMembers().size(), (int)1);
                return null;
            }
        });
    }

    public void checkNavigationAPIs(VM vm1) throws Exception {
        vm1.invoke(new SerializableCallable("Check Navigation APIS"){

            public Object call() throws Exception {
                GemFireCacheImpl cache = GemFireCacheImpl.getInstance();
                ManagementService service = ManagementTestBase.getManagementService();
                DistributedSystemMXBean bean = service.getDistributedSystemMXBean();
                TestCase.assertNotNull((Object)service.getDistributedSystemMXBean());
                DistributedSystemDUnitTest.this.waitForAllMembers(4);
                for (int i = 0; i < bean.listMemberObjectNames().length; ++i) {
                    DistributedTestCase.getLogWriter().info("ObjectNames Of the Mmeber" + bean.listMemberObjectNames()[i]);
                }
                ObjectName thisMemberName = MBeanJMXAdapter.getMemberMBeanName((String)InternalDistributedSystem.getConnectedInstance().getDistributedMember().getId());
                ObjectName memberName = bean.fetchMemberObjectName(InternalDistributedSystem.getConnectedInstance().getDistributedMember().getId());
                TestCase.assertEquals((Object)thisMemberName, (Object)memberName);
                return null;
            }
        });
    }

    private static class AlertNotifListener
    implements NotificationListener {
        private static AlertNotifListener listener = new AlertNotifListener();
        private int warnigAlertCount = 0;
        private int severAlertCount = 0;

        private AlertNotifListener() {
        }

        public static AlertNotifListener getInstance() {
            return listener;
        }

        @Override
        public void handleNotification(Notification notification, Object handback) {
            TestCase.assertNotNull((Object)notification);
            String notifStr = notification.toString();
            if (notifStr.contains("Warninglevel")) {
                ++this.warnigAlertCount;
            }
            if (notifStr.contains("Severelevel")) {
                ++this.severAlertCount;
            }
        }

        public void resetCount() {
            this.warnigAlertCount = 0;
            this.severAlertCount = 0;
        }

        public int getWarnigAlertCount() {
            return this.warnigAlertCount;
        }

        public int getseverAlertCount() {
            return this.severAlertCount;
        }
    }

    private static class TestDistributedSystemNotif
    implements NotificationListener {
        private TestDistributedSystemNotif() {
        }

        @Override
        public void handleNotification(Notification notification, Object handback) {
            TestCase.assertNotNull((Object)notification);
        }
    }
}

