/*
 * Decompiled with CFR 0.152.
 */
package com.gemstone.gemfire.management;

import com.gemstone.gemfire.LogWriter;
import com.gemstone.gemfire.cache.Cache;
import com.gemstone.gemfire.cache.CacheFactory;
import com.gemstone.gemfire.cache.Region;
import com.gemstone.gemfire.cache.RegionFactory;
import com.gemstone.gemfire.cache.RegionShortcut;
import com.gemstone.gemfire.distributed.DistributedMember;
import com.gemstone.gemfire.distributed.DistributedSystem;
import com.gemstone.gemfire.distributed.internal.InternalDistributedSystem;
import com.gemstone.gemfire.internal.cache.GemFireCacheImpl;
import com.gemstone.gemfire.internal.statistics.SampleCollector;
import com.gemstone.gemfire.management.DistributedSystemMXBean;
import com.gemstone.gemfire.management.ManagementException;
import com.gemstone.gemfire.management.ManagementService;
import com.gemstone.gemfire.management.internal.FederatingManager;
import com.gemstone.gemfire.management.internal.LocalManager;
import com.gemstone.gemfire.management.internal.MBeanJMXAdapter;
import com.gemstone.gemfire.management.internal.ManagementStrings;
import com.gemstone.gemfire.management.internal.SystemManagementService;
import dunit.AsyncInvocation;
import dunit.DistributedTestCase;
import dunit.Host;
import dunit.SerializableCallable;
import dunit.SerializableRunnable;
import dunit.VM;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Properties;
import java.util.Set;
import javax.management.MBeanServer;
import javax.management.ObjectName;
import junit.framework.TestCase;

public class ManagementTestBase
extends DistributedTestCase {
    private static final int MAX_WAIT = 70000;
    private static final long serialVersionUID = 1L;
    private static LogWriter logWriter;
    private static Properties props;
    protected static DistributedSystem ds;
    protected static List<VM> managedNodeList;
    protected static VM managingNode;
    protected static ManagementService managementService;
    protected static VM managedNode1;
    protected static VM managedNode2;
    protected static VM managedNode3;
    protected static VM locatorVM;
    private static SampleCollector sampleCollector;
    protected static MBeanServer mbeanServer;
    private static int mcastPort;
    private static Cache cache;

    public ManagementTestBase(String name) {
        super(name);
    }

    @Override
    public void setUp() throws Exception {
        ManagementTestBase.disconnectAllFromDS();
        super.setUp();
        Host host = Host.getHost(0);
        managingNode = host.getVM(0);
        managedNode1 = host.getVM(1);
        managedNode2 = host.getVM(2);
        managedNode3 = host.getVM(3);
        managedNodeList = new ArrayList<VM>();
        managedNodeList.add(managedNode1);
        managedNodeList.add(managedNode2);
        managedNodeList.add(managedNode3);
        locatorVM = host.getLocator();
    }

    @Override
    public void tearDown2() throws Exception {
        super.tearDown2();
        this.closeAllCache();
        managementService = null;
        mcastPort = 0;
        ManagementTestBase.disconnectAllFromDS();
        props.clear();
    }

    public void closeAllCache() throws Exception {
        this.closeCache(managingNode);
        this.closeCache(managedNode1);
        this.closeCache(managedNode2);
        this.closeCache(managedNode3);
        cache = null;
    }

    public void enableManagement() {
        ManagementTestBase.invokeInEveryVM(new SerializableRunnable("Enable Management"){

            @Override
            public void run() {
                System.setProperty("gemfire.disableManagement", "false");
            }
        });
    }

    public void disableManagement() {
        ManagementTestBase.invokeInEveryVM(new SerializableRunnable("Disable Management"){

            @Override
            public void run() {
                System.setProperty("gemfire.disableManagement", "true");
            }
        });
    }

    public void initManagement(boolean managingNodeFirst) throws Exception {
        if (managingNodeFirst) {
            this.createManagementCache(managingNode);
            this.startManagingNode(managingNode);
            for (VM vm : managedNodeList) {
                this.createCache(vm);
            }
        } else {
            for (VM vm : managedNodeList) {
                this.createCache(vm);
            }
            this.createManagementCache(managingNode);
            this.startManagingNode(managingNode);
        }
    }

    public void createCache(VM vm1) throws Exception {
        vm1.invoke(new SerializableRunnable("Create Cache"){

            @Override
            public void run() {
                ManagementTestBase.this.createCache(false);
            }
        });
    }

    public void createCache(VM vm1, final Properties props) throws Exception {
        vm1.invoke(new SerializableRunnable("Create Cache"){

            @Override
            public void run() {
                ManagementTestBase.this.createCache(props);
            }
        });
    }

    public Cache createCache(Properties props) {
        System.setProperty("dunitLogPerTest", "true");
        props.setProperty("log-file", testName + "-.log");
        ds = new ManagementTestBase("temp").getSystem(props);
        cache = CacheFactory.create((DistributedSystem)ds);
        managementService = ManagementService.getManagementService((Cache)cache);
        logWriter = ds.getLogWriter();
        ManagementTestBase.assertNotNull((Object)cache);
        ManagementTestBase.assertNotNull((Object)managementService);
        return cache;
    }

    public Cache getCache() {
        return cache;
    }

    public Cache createCache(boolean management) {
        System.setProperty("dunitLogPerTest", "true");
        if (management) {
            props.setProperty("jmx-manager", "true");
            props.setProperty("jmx-manager-start", "false");
            props.setProperty("jmx-manager-port", "0");
            props.setProperty("jmx-manager-http-port", "0");
        }
        props.setProperty("enable-time-statistics", "true");
        props.setProperty("statistic-sampling-enabled", "true");
        props.setProperty("log-file", testName + "-.log");
        ds = new ManagementTestBase("temp").getSystem(props);
        cache = CacheFactory.create((DistributedSystem)ds);
        managementService = ManagementService.getManagementService((Cache)cache);
        logWriter = ds.getLogWriter();
        ManagementTestBase.assertNotNull((Object)cache);
        ManagementTestBase.assertNotNull((Object)managementService);
        return cache;
    }

    public void createManagementCache(VM vm1) throws Exception {
        vm1.invoke(new SerializableRunnable("Create Management Cache"){

            @Override
            public void run() {
                ManagementTestBase.this.createCache(true);
            }
        });
    }

    public void closeCache(VM vm1) throws Exception {
        vm1.invoke(new SerializableRunnable("Close Cache"){

            @Override
            public void run() {
                InternalDistributedSystem ds;
                GemFireCacheImpl existingInstance = GemFireCacheImpl.getInstance();
                if (existingInstance != null) {
                    existingInstance.close();
                }
                if ((ds = InternalDistributedSystem.getConnectedInstance()) != null) {
                    ds.disconnect();
                }
            }
        });
    }

    public String getMemberId(VM vm) {
        SerializableCallable getMember = new SerializableCallable("getMemberId"){

            public Object call() throws Exception {
                GemFireCacheImpl cache = GemFireCacheImpl.getInstance();
                return cache.getDistributedSystem().getDistributedMember().getId();
            }
        };
        return (String)vm.invoke(getMember);
    }

    protected void waitForProxy(final ObjectName objectName, final Class interfaceClass) {
        ManagementTestBase.waitForCriterion(new DistributedTestCase.WaitCriterion(){

            @Override
            public String description() {
                return "Waiting for the proxy of " + objectName.getCanonicalName() + " to get propagated to Manager";
            }

            @Override
            public boolean done() {
                SystemManagementService service = (SystemManagementService)managementService;
                return service.getMBeanProxy(objectName, interfaceClass) != null;
            }
        }, 70000L, 500L, true);
    }

    protected void runManagementTaskAdhoc() {
        SystemManagementService service = (SystemManagementService)managementService;
        service.getLocalManager().runManagementTaskAdhoc();
    }

    public void startManagingNode(VM vm1) throws Exception {
        vm1.invoke(new SerializableRunnable("Start Being Managing Node"){

            @Override
            public void run() {
                ManagementTestBase.this.startBeingManagingNode();
            }
        });
    }

    public void startBeingManagingNode() {
        GemFireCacheImpl existingCache = GemFireCacheImpl.getInstance();
        if (existingCache != null && !existingCache.isClosed()) {
            managementService = ManagementService.getManagementService((Cache)existingCache);
            SystemManagementService service = (SystemManagementService)managementService;
            service.createManager();
            service.startManager();
        }
    }

    public void startManagingNodeAsync(VM vm1) throws Exception {
        vm1.invokeAsync(new SerializableRunnable("Start Being Managing Node"){

            @Override
            public void run() {
                GemFireCacheImpl existingCache = GemFireCacheImpl.getInstance();
                if (existingCache != null && !existingCache.isClosed()) {
                    managementService = ManagementService.getManagementService((Cache)existingCache);
                    managementService.startManager();
                }
            }
        });
    }

    public void stopManagingNode(VM vm1) throws Exception {
        vm1.invoke(new SerializableRunnable("Stop Being Managing Node"){

            @Override
            public void run() {
                GemFireCacheImpl existingCache = GemFireCacheImpl.getInstance();
                if (existingCache != null && !existingCache.isClosed() && managementService.isManager()) {
                    managementService.stopManager();
                }
            }
        });
    }

    public void checkManagedNodeCleanup(VM vm) throws Exception {
        vm.invoke(new SerializableRunnable("Managing Node Clean up"){

            @Override
            public void run() {
                GemFireCacheImpl existingCache = GemFireCacheImpl.getInstance();
                if (existingCache != null) {
                    TestCase.assertEquals((boolean)true, (boolean)existingCache.isClosed());
                    LocalManager localManager = ((SystemManagementService)managementService).getLocalManager();
                    Region monitoringRegion = localManager.getManagementResourceRepo().getLocalMonitoringRegion();
                    TestCase.assertEquals(null, (Object)monitoringRegion);
                    Region notifRegion = localManager.getManagementResourceRepo().getLocalNotificationRegion();
                    TestCase.assertEquals(null, (Object)notifRegion);
                    TestCase.assertEquals((boolean)true, (boolean)localManager.getFederationSheduler().isShutdown());
                }
            }
        });
    }

    public void checkProxyCleanup(VM vm) throws Exception {
        vm.invoke(new SerializableRunnable("Managing Node Clean up"){

            @Override
            public void run() {
                try {
                    GemFireCacheImpl existingCache = GemFireCacheImpl.getInstance();
                    if (existingCache == null) {
                        return;
                    }
                    TestCase.assertEquals((boolean)false, (boolean)existingCache.isClosed());
                    Set otherMemberSet = existingCache.getDistributionManager().getOtherDistributionManagerIds();
                    Iterator it = otherMemberSet.iterator();
                    FederatingManager federatingManager = ((SystemManagementService)managementService).getFederatingManager();
                    while (it.hasNext()) {
                        DistributedMember member = (DistributedMember)it.next();
                        TestCase.assertNull((Object)federatingManager.getProxyFactory().findAllProxies(member));
                    }
                }
                catch (ManagementException e) {
                    DistributedTestCase.fail("failed with ManagementException", e);
                }
            }
        });
    }

    public boolean checkManagementExceptions(ManagementException e) {
        return !e.getMessage().equals(ManagementStrings.Management_Service_CLOSED_CACHE) && !e.getMessage().equals(ManagementStrings.Management_Service_MANAGEMENT_SERVICE_IS_CLOSED.toLocalizedString()) && !e.getMessage().equals(ManagementStrings.Management_Service_MANAGEMENT_SERVICE_NOT_STARTED_YET.toLocalizedString()) && !e.getMessage().equals(ManagementStrings.Management_Service__0__NOT_A__1__DOMAIN_MBEAN.toLocalizedString()) && !e.getMessage().equals(ManagementStrings.Management_Service_NOT_A_MANAGING_NODE_YET.toLocalizedString()) && !e.getMessage().equals(ManagementStrings.Management_Service_OPERATION_NOT_ALLOWED_FOR_CLIENT_CACHE.toLocalizedString()) && !e.getMessage().equals(ManagementStrings.Management_Service_PROXY_NOT_AVAILABLE.toLocalizedString());
    }

    public static List<VM> getManagedNodeList() {
        return managedNodeList;
    }

    public static VM getManagingNode() {
        return managingNode;
    }

    public static ManagementService getManagementService() {
        return managementService;
    }

    protected void createDistributedRegion(VM vm, String regionName) throws Exception {
        AsyncInvocation future = this.createDistributedRegionAsync(vm, regionName);
        future.join(70000L);
        if (future.isAlive()) {
            ManagementTestBase.fail((String)"Region not created within70000");
        }
        if (future.exceptionOccurred()) {
            throw new RuntimeException(future.getException());
        }
    }

    protected void createLocalRegion(VM vm, final String localRegionName) throws Exception {
        SerializableRunnable createLocalRegion = new SerializableRunnable("Create Local region"){

            @Override
            public void run() {
                GemFireCacheImpl cache = GemFireCacheImpl.getInstance();
                SystemManagementService service = (SystemManagementService)ManagementTestBase.getManagementService();
                RegionFactory rf = cache.createRegionFactory(RegionShortcut.LOCAL);
                DistributedTestCase.getLogWriter().info("Creating Local Region");
                rf.create(localRegionName);
            }
        };
        vm.invoke(createLocalRegion);
    }

    protected void createSubRegion(VM vm, final String parentRegionPath, final String subregionName) throws Exception {
        SerializableRunnable createSubRegion = new SerializableRunnable("Create Sub region"){

            @Override
            public void run() {
                GemFireCacheImpl cache = GemFireCacheImpl.getInstance();
                SystemManagementService service = (SystemManagementService)ManagementTestBase.getManagementService();
                Region region = cache.getRegion(parentRegionPath);
                DistributedTestCase.getLogWriter().info("Creating Sub Region");
                region.createSubregion(subregionName, region.getAttributes());
            }
        };
        vm.invoke(createSubRegion);
    }

    protected void putInDistributedRegion(VM vm, final String key, final String value, final String regionPath) {
        SerializableRunnable put = new SerializableRunnable("Put In Distributed Region"){

            @Override
            public void run() {
                GemFireCacheImpl cache = GemFireCacheImpl.getInstance();
                Region region = cache.getRegion(regionPath);
                region.put((Object)key, (Object)value);
            }
        };
        vm.invoke(put);
    }

    protected AsyncInvocation createDistributedRegionAsync(VM vm, final String regionName) {
        SerializableRunnable createRegion = new SerializableRunnable("Create Distributed region"){

            @Override
            public void run() {
                GemFireCacheImpl cache = GemFireCacheImpl.getInstance();
                SystemManagementService service = (SystemManagementService)ManagementTestBase.getManagementService();
                RegionFactory rf = cache.createRegionFactory(RegionShortcut.REPLICATE);
                DistributedTestCase.getLogWriter().info("Creating Dist Region");
                rf.create(regionName);
            }
        };
        return vm.invokeAsync(createRegion);
    }

    protected void createPartitionRegion(VM vm, final String partitionRegionName) {
        SerializableRunnable createParRegion = new SerializableRunnable("Create Partitioned region"){

            @Override
            public void run() {
                GemFireCacheImpl cache = GemFireCacheImpl.getInstance();
                SystemManagementService service = (SystemManagementService)ManagementTestBase.getManagementService();
                RegionFactory rf = cache.createRegionFactory(RegionShortcut.PARTITION_REDUNDANT);
                DistributedTestCase.getLogWriter().info("Creating Par Region");
                rf.create(partitionRegionName);
            }
        };
        vm.invoke(createParRegion);
    }

    protected void closeRegion(VM vm, final String regionPath) {
        SerializableRunnable closeRegion = new SerializableRunnable("Close Distributed region"){

            @Override
            public void run() {
                GemFireCacheImpl cache = GemFireCacheImpl.getInstance();
                DistributedTestCase.getLogWriter().info("Closing Dist Region");
                Region region = cache.getRegion(regionPath);
                region.close();
            }
        };
        vm.invoke(closeRegion);
    }

    public void waitForAllMembers(final int expectedCount) {
        ManagementService service = ManagementTestBase.getManagementService();
        final DistributedSystemMXBean bean = service.getDistributedSystemMXBean();
        ManagementTestBase.assertNotNull((Object)service.getDistributedSystemMXBean());
        ManagementTestBase.waitForCriterion(new DistributedTestCase.WaitCriterion(){

            @Override
            public String description() {
                return "Waiting All members to intimate DistributedSystemMBean";
            }

            @Override
            public boolean done() {
                if (bean.listMemberObjectNames() != null) {
                    DistributedTestCase.getLogWriter().info("Member Length " + bean.listMemberObjectNames().length);
                }
                return bean.listMemberObjectNames().length >= expectedCount;
            }
        }, 70000L, 500L, true);
        ManagementTestBase.assertNotNull((Object)bean.getManagerObjectName());
    }

    public void waitForRefresh(final int expectedRefreshCount, final ObjectName objectName) {
        final ManagementService service = ManagementTestBase.getManagementService();
        long currentTime = System.currentTimeMillis();
        ManagementTestBase.waitForCriterion(new DistributedTestCase.WaitCriterion(){
            int actualRefreshCount = 0;
            long lastRefreshTime = service.getLastUpdateTime(objectName);

            @Override
            public String description() {
                return "Waiting For Proxy Refresh Count = " + expectedRefreshCount;
            }

            @Override
            public boolean done() {
                long newRefreshTime = service.getLastUpdateTime(objectName);
                if (newRefreshTime > this.lastRefreshTime) {
                    this.lastRefreshTime = newRefreshTime;
                    ++this.actualRefreshCount;
                }
                return this.actualRefreshCount >= expectedRefreshCount;
            }
        }, 70000L, 500L, true);
    }

    public DistributedMember getMember(VM vm) {
        SerializableCallable getMember = new SerializableCallable("Get Member"){

            public Object call() {
                GemFireCacheImpl cache = GemFireCacheImpl.getInstance();
                return cache.getDistributedSystem().getDistributedMember();
            }
        };
        return (DistributedMember)vm.invoke(getMember);
    }

    static {
        props = new Properties();
        mbeanServer = MBeanJMXAdapter.mbeanServer;
    }
}

