/*
 * Decompiled with CFR 0.152.
 */
package com.gemstone.gemfire.management;

import com.gemstone.gemfire.cache.Region;
import com.gemstone.gemfire.cache.RegionFactory;
import com.gemstone.gemfire.cache.RegionShortcut;
import com.gemstone.gemfire.distributed.internal.InternalDistributedSystem;
import com.gemstone.gemfire.internal.NanoTimer;
import com.gemstone.gemfire.internal.cache.GemFireCacheImpl;
import com.gemstone.gemfire.internal.process.PidUnavailableException;
import com.gemstone.gemfire.internal.process.ProcessUtils;
import com.gemstone.gemfire.management.ManagementTestBase;
import com.gemstone.gemfire.management.MemberMXBean;
import dunit.DistributedTestCase;
import dunit.SerializableRunnable;
import dunit.VM;
import java.lang.management.ManagementFactory;
import junit.framework.TestCase;

public class MemberMBeanAttributesDUnitTest
extends ManagementTestBase {
    private static final long serialVersionUID = 1L;
    private static final long MBFactor = 0x100000L;
    private static final int MAX_WAIT = 70000;
    protected static final long SLEEP = 100L;

    public MemberMBeanAttributesDUnitTest(String name) {
        super(name);
    }

    @Override
    public void setUp() throws Exception {
        super.setUp();
    }

    @Override
    public void tearDown2() throws Exception {
        super.tearDown2();
    }

    protected void sample(VM vm1) {
        vm1.invoke(new SerializableRunnable("Create Cache"){

            @Override
            public void run() {
                InternalDistributedSystem.getConnectedInstance().getStatSampler().getSampleCollector().sample(NanoTimer.getTime());
            }
        });
    }

    public void testReplRegionAttributes() throws Exception {
        this.initManagement(false);
        this.setupForReplicateRegonAttributes((VM)managedNodeList.get(0), 1);
        this.setupForReplicateRegonAttributes((VM)managedNodeList.get(1), 201);
        this.sample((VM)managedNodeList.get(1));
        this.isReplicatedRegionAttrsOK((VM)managedNodeList.get(1));
    }

    public void testPRRegionAttributes() throws Exception {
        this.initManagement(false);
        this.setupForPartitionedRegonAttributes((VM)managedNodeList.get(0), 1);
        this.sample((VM)managedNodeList.get(0));
        this.isPartitionedRegionAttrsOK((VM)managedNodeList.get(0));
    }

    public void testOSAttributes() throws Exception {
        this.initManagement(false);
        this.isOSRelatedAttrsOK((VM)managedNodeList.get(0));
    }

    public void testConfigAttributes() throws Exception {
        this.initManagement(false);
        this.isConfigRelatedAttrsOK((VM)managedNodeList.get(0));
    }

    public void setupForReplicateRegonAttributes(VM vm1, final int offset) throws Exception {
        vm1.invoke(new SerializableRunnable("Create Cache"){

            @Override
            public void run() {
                GemFireCacheImpl cache = GemFireCacheImpl.getInstance();
                RegionFactory rf = cache.createRegionFactory(RegionShortcut.REPLICATE);
                DistributedTestCase.getLogWriter().info("Creating Dist Region");
                rf.create("testRegion1");
                rf.create("testRegion2");
                rf.create("testRegion3");
                Region r1 = cache.getRegion("/testRegion1");
                rf.createSubregion(r1, "testSubRegion1");
                Region r2 = cache.getRegion("/testRegion2");
                rf.createSubregion(r2, "testSubRegion2");
                Region r3 = cache.getRegion("/testRegion3");
                rf.createSubregion(r3, "testSubRegion3");
                for (int i = offset; i < offset + 200; ++i) {
                    r1.put((Object)new Integer(i), (Object)new Integer(i));
                    r2.put((Object)new Integer(i), (Object)new Integer(i));
                    r3.put((Object)new Integer(i), (Object)new Integer(i));
                }
            }
        });
    }

    public void setupForPartitionedRegonAttributes(VM vm1, final int offset) throws Exception {
        vm1.invoke(new SerializableRunnable("Create Cache"){

            @Override
            public void run() {
                GemFireCacheImpl cache = GemFireCacheImpl.getInstance();
                RegionFactory prRF = cache.createRegionFactory(RegionShortcut.PARTITION_REDUNDANT);
                prRF.create("testPRRegion1");
                prRF.create("testPRRegion2");
                prRF.create("testPRRegion3");
                Region pr1 = cache.getRegion("/testPRRegion1");
                Region pr2 = cache.getRegion("/testPRRegion2");
                Region pr3 = cache.getRegion("/testPRRegion3");
                for (int i = offset; i < offset + 200; ++i) {
                    pr1.put((Object)new Integer(i), (Object)new Integer(i));
                    pr2.put((Object)new Integer(i), (Object)new Integer(i));
                    pr3.put((Object)new Integer(i), (Object)new Integer(i));
                }
            }
        });
    }

    public void isPartitionedRegionAttrsOK(VM vm1) throws Exception {
        vm1.invoke(new SerializableRunnable("Create Cache"){

            @Override
            public void run() {
                MemberMXBean bean = ManagementTestBase.managementService.getMemberMXBean();
                TestCase.assertEquals((int)3, (int)bean.getPartitionRegionCount());
                TestCase.assertEquals((int)339, (int)bean.getTotalBucketCount());
                TestCase.assertEquals((int)339, (int)bean.getTotalPrimaryBucketCount());
            }
        });
    }

    public void isReplicatedRegionAttrsOK(VM vm1) throws Exception {
        vm1.invoke(new SerializableRunnable("Create Cache"){

            @Override
            public void run() {
                MemberMXBean bean = ManagementTestBase.managementService.getMemberMXBean();
                TestCase.assertEquals((int)6, (int)bean.getTotalRegionCount());
                TestCase.assertEquals((int)1200, (int)bean.getTotalRegionEntryCount());
                TestCase.assertEquals((int)3, (int)bean.getRootRegionNames().length);
                TestCase.assertEquals((int)600, (int)bean.getInitialImageKeysReceived());
                TestCase.assertEquals((int)6, (int)bean.listRegions().length);
            }
        });
    }

    public void isOSRelatedAttrsOK(VM vm1) throws Exception {
        vm1.invoke(new SerializableRunnable("Create Cache"){

            @Override
            public void run() {
                MemberMXBean bean = ManagementTestBase.managementService.getMemberMXBean();
                try {
                    TestCase.assertEquals((int)ProcessUtils.identifyPid(), (int)bean.getProcessId());
                }
                catch (PidUnavailableException e) {
                    e.printStackTrace();
                }
                TestCase.assertEquals((String)ManagementFactory.getRuntimeMXBean().getClassPath(), (String)bean.getClassPath());
                TestCase.assertTrue((bean.getCurrentTime() > 0L ? 1 : 0) != 0);
                try {
                    Thread.sleep(1000L);
                }
                catch (InterruptedException e) {
                    e.printStackTrace();
                }
                TestCase.assertTrue((bean.getMemberUpTime() > 0L ? 1 : 0) != 0);
                TestCase.assertTrue((bean.getCurrentHeapSize() > 10L ? 1 : 0) != 0);
                TestCase.assertTrue((bean.getFreeHeapSize() > 0L ? 1 : 0) != 0);
                TestCase.assertEquals((long)bean.getMaximumHeapSize(), (long)(ManagementFactory.getMemoryMXBean().getHeapMemoryUsage().getMax() / 0x100000L));
                TestCase.assertTrue((bean.fetchJvmThreads().length > 0 ? 1 : 0) != 0);
            }
        });
    }

    public void isConfigRelatedAttrsOK(VM vm1) throws Exception {
        vm1.invoke(new SerializableRunnable("Create Cache"){

            @Override
            public void run() {
                MemberMXBean bean = ManagementTestBase.managementService.getMemberMXBean();
                TestCase.assertFalse((boolean)bean.hasGatewayReceiver());
                TestCase.assertFalse((boolean)bean.hasGatewaySender());
                TestCase.assertFalse((boolean)bean.isLocator());
                TestCase.assertFalse((boolean)bean.isManager());
                TestCase.assertFalse((boolean)bean.isServer());
                TestCase.assertFalse((boolean)bean.isManagerCreated());
            }
        });
    }
}

