/*
 * Decompiled with CFR 0.152.
 */
package com.gemstone.gemfire.management;

import com.gemstone.gemfire.OutOfOffHeapMemoryException;
import com.gemstone.gemfire.cache.Cache;
import com.gemstone.gemfire.cache.DataPolicy;
import com.gemstone.gemfire.cache.Region;
import com.gemstone.gemfire.cache30.CacheTestCase;
import com.gemstone.gemfire.distributed.DistributedMember;
import com.gemstone.gemfire.distributed.internal.InternalDistributedSystem;
import com.gemstone.gemfire.internal.cache.GemFireCacheImpl;
import com.gemstone.gemfire.internal.offheap.OffHeapMemoryStats;
import com.gemstone.gemfire.management.ManagementService;
import com.gemstone.gemfire.management.MemberMXBean;
import com.gemstone.gemfire.management.OffHeapNotificationListener;
import com.gemstone.gemfire.management.RegionAttributesData;
import com.gemstone.gemfire.management.RegionMXBean;
import com.gemstone.gemfire.management.internal.MBeanJMXAdapter;
import com.gemstone.gemfire.management.internal.beans.MemberMBean;
import dunit.DistributedTestCase;
import dunit.Host;
import dunit.SerializableCallable;
import dunit.SerializableRunnable;
import dunit.VM;
import java.util.Properties;
import java.util.Set;
import javax.management.Attribute;
import javax.management.AttributeList;
import javax.management.InstanceNotFoundException;
import javax.management.MBeanRegistrationException;
import javax.management.MBeanServer;
import javax.management.MalformedObjectNameException;
import javax.management.NotificationListener;
import javax.management.ObjectInstance;
import javax.management.ObjectName;
import junit.framework.TestCase;

public class OffHeapManagementDUnitTest
extends CacheTestCase {
    private static final String OFF_HEAP_REGION_NAME = "offHeapRegion";
    private static final String OFF_HEAP_REGION_PATH = "/offHeapRegion";
    private static final long TOTAL_MEMORY = 0x100000L;
    private static final int HALF_TOTAL_MEMORY = 524288;
    private static final int ALLOCATION_SIZE = 100000;
    private static final int NEW_ALLOCATION_SIZE = 400000;
    private static final int OBJECT_OVERHEAD = 8;
    private static final String KEY = "key";
    private static final String KEY2 = "key2";
    private static final String KEY3 = "key3";
    private static final byte[] VALUE = "Proin lobortis enim vel sem congue ut condimentum leo rhoncus. In turpis lorem, rhoncus nec rutrum vel, sodales vitae lacus. Etiam nunc ligula, scelerisque id egestas vitae, gravida non enim. Donec ac ligula purus. Mauris gravida ligula sit amet mi ornare blandit. Aliquam at velit ac enim varius malesuada ut eu tortor. Quisque diam nisi, fermentum vel accumsan at, commodo et velit.".getBytes();
    private static final int OBJECT_SIZE = VALUE.length + 8;
    private static final OffHeapNotificationListener notificationListener = new OffHeapNotificationListener();
    private static MBeanServer mbeanServer = MBeanJMXAdapter.mbeanServer;

    public OffHeapManagementDUnitTest(String name) {
        super(name);
    }

    @Override
    public void setUp() throws Exception {
        super.setUp();
        Host.getHost(0).getVM(0).invoke(new SerializableRunnable(){

            @Override
            public void run() {
                System.setProperty("gemfire.offheap.stayConnectedOnOutOfOffHeapMemory", "true");
            }
        });
    }

    @Override
    public void tearDown2() throws Exception {
        Host.getHost(0).getVM(0).invoke(new SerializableRunnable(){

            @Override
            public void run() {
                System.clearProperty("gemfire.offheap.stayConnectedOnOutOfOffHeapMemory");
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testOffHeapMBeanAttributesAndStats() throws Exception {
        VM vm = Host.getHost(0).getVM(0);
        try {
            this.setSystemPropertiesOnVm(vm, true, this.getSystemProperties());
            OffHeapManagementDUnitTest.assertNotNull((Object)this.createOffHeapRegionOnVm(vm, OFF_HEAP_REGION_NAME, DataPolicy.REPLICATE));
            this.assertOffHeapRegionAttributesOnVm(vm);
            this.assertOffHeapMetricsOnVm(vm, 0x100000L, 0L, 0L, 0);
            this.doPutOnVm(vm, KEY, VALUE, OFF_HEAP_REGION_NAME, false);
            this.assertOffHeapMetricsOnVm(vm, 0x100000L - (long)OBJECT_SIZE, OBJECT_SIZE, 1L, 0);
            this.doPutOnVm(vm, KEY2, VALUE, OFF_HEAP_REGION_NAME, false);
            this.assertOffHeapMetricsOnVm(vm, 0x100000L - (long)(2 * OBJECT_SIZE), 2 * OBJECT_SIZE, 2L, 0);
            this.doPutOnVm(vm, KEY3, VALUE, OFF_HEAP_REGION_NAME, false);
            this.assertOffHeapMetricsOnVm(vm, 0x100000L - (long)(3 * OBJECT_SIZE), 3 * OBJECT_SIZE, 3L, 0);
            this.doDestroyOnVm(vm, KEY3, OFF_HEAP_REGION_NAME);
            this.assertOffHeapMetricsOnVm(vm, 0x100000L - (long)(2 * OBJECT_SIZE), 2 * OBJECT_SIZE, 2L, 0);
            this.doDestroyOnVm(vm, KEY2, OFF_HEAP_REGION_NAME);
            this.assertOffHeapMetricsOnVm(vm, 0x100000L - (long)OBJECT_SIZE, OBJECT_SIZE, 1L, 0);
            this.doDestroyOnVm(vm, KEY, OFF_HEAP_REGION_NAME);
            this.assertOffHeapMetricsOnVm(vm, 0x100000L, 0L, 0L, 0);
        }
        finally {
            this.doCleanupOnVm(vm);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testFragmentationStat() throws Exception {
        VM vm = Host.getHost(0).getVM(0);
        try {
            this.setSystemPropertiesOnVm(vm, true, this.getSystemProperties());
            OffHeapManagementDUnitTest.assertNotNull((Object)this.createOffHeapRegionOnVm(vm, OFF_HEAP_REGION_NAME, DataPolicy.REPLICATE));
            vm.invoke(new SerializableRunnable(){

                @Override
                public void run() {
                    Region region = OffHeapManagementDUnitTest.this.getCache().getRegion(OffHeapManagementDUnitTest.OFF_HEAP_REGION_NAME);
                    TestCase.assertNotNull((Object)region);
                }
            });
            this.assertOffHeapRegionAttributesOnVm(vm);
            this.assertOffHeapMetricsOnVm(vm, 0x100000L, 0L, 0L, 0);
            this.doPutOnVm(vm, KEY, new byte[524288], OFF_HEAP_REGION_NAME, false);
            this.assertFragmentationStatOnVm(vm, 0, ASSERT_OP.EQUAL);
            this.doDestroyOnVm(vm, KEY, OFF_HEAP_REGION_NAME);
            this.assertFragmentationStatOnVm(vm, 0, ASSERT_OP.EQUAL);
            int numAllocations = this.doConsumeOffHeapMemoryOnVm(vm, 100000);
            OffHeapManagementDUnitTest.assertTrue((numAllocations > 0 ? 1 : 0) != 0);
            this.doFreeOffHeapMemoryOnVm(vm, numAllocations, 3);
            this.setupOffHeapMonitorOnVm(vm, "OffHeapFragmentation", 0L, 0L, false);
            this.clearNotificationListenerOnVm(vm);
            this.doPutOnVm(vm, KEY, new byte[400000], OFF_HEAP_REGION_NAME, true);
            this.assertFragmentationStatOnVm(vm, 0, ASSERT_OP.GREATER_THAN);
            this.waitForNotificationListenerOnVm(vm, 5000L, 500L, true);
        }
        finally {
            this.doCleanupOnVm(vm);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testCompactionTimeStat() throws Exception {
        VM vm = Host.getHost(0).getVM(0);
        try {
            this.setSystemPropertiesOnVm(vm, true, this.getSystemProperties());
            OffHeapManagementDUnitTest.assertNotNull((Object)this.createOffHeapRegionOnVm(vm, OFF_HEAP_REGION_NAME, DataPolicy.REPLICATE));
            this.assertOffHeapRegionAttributesOnVm(vm);
            this.assertOffHeapMetricsOnVm(vm, 0x100000L, 0L, 0L, 0);
            this.doPutOnVm(vm, KEY, new byte[524288], OFF_HEAP_REGION_NAME, false);
            this.assertCompactionTimeStatOnVm(vm, 0L, ASSERT_OP.EQUAL);
            this.doDestroyOnVm(vm, KEY, OFF_HEAP_REGION_NAME);
            this.assertCompactionTimeStatOnVm(vm, 0L, ASSERT_OP.EQUAL);
            int numAllocations = this.doConsumeOffHeapMemoryOnVm(vm, 100000);
            OffHeapManagementDUnitTest.assertTrue((numAllocations > 0 ? 1 : 0) != 0);
            this.doFreeOffHeapMemoryOnVm(vm, numAllocations, 3);
            this.setupOffHeapMonitorOnVm(vm, "OffHeapCompactionTime", 0L, 0L, false);
            this.clearNotificationListenerOnVm(vm);
            this.doPutOnVm(vm, KEY, new byte[400000], OFF_HEAP_REGION_NAME, true);
            this.waitForNotificationListenerOnVm(vm, 5000L, 500L, true);
            this.assertCompactionTimeStatOnVm(vm, 0L, ASSERT_OP.GREATER_THAN_OR_EQUAL);
        }
        finally {
            this.doCleanupOnVm(vm);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testOffHeapObjectsMonitoring() throws Exception {
        VM vm = Host.getHost(0).getVM(0);
        try {
            this.setSystemPropertiesOnVm(vm, true, this.getSystemProperties());
            OffHeapManagementDUnitTest.assertNotNull((Object)this.createOffHeapRegionOnVm(vm, OFF_HEAP_REGION_NAME, DataPolicy.REPLICATE));
            this.assertOffHeapRegionAttributesOnVm(vm);
            this.assertOffHeapMetricsOnVm(vm, 0x100000L, 0L, 0L, 0);
            this.setupOffHeapMonitorOnVm(vm, "OffHeapObjects", 0L, -1L, false);
            this.clearNotificationListenerOnVm(vm);
            this.doPutOnVm(vm, KEY, VALUE, OFF_HEAP_REGION_NAME, false);
            this.waitForNotificationListenerOnVm(vm, 5000L, 500L, true);
        }
        finally {
            this.doCleanupOnVm(vm);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testOffHeapFreeSizeMonitoring() throws Exception {
        VM vm = Host.getHost(0).getVM(0);
        try {
            this.setSystemPropertiesOnVm(vm, true, this.getSystemProperties());
            OffHeapManagementDUnitTest.assertNotNull((Object)this.createOffHeapRegionOnVm(vm, OFF_HEAP_REGION_NAME, DataPolicy.REPLICATE));
            this.assertOffHeapRegionAttributesOnVm(vm);
            this.assertOffHeapMetricsOnVm(vm, 0x100000L, 0L, 0L, 0);
            this.setupOffHeapMonitorOnVm(vm, "OffHeapFreeMemory", 0x100000L, 0x100000L, false);
            this.clearNotificationListenerOnVm(vm);
            this.doPutOnVm(vm, KEY, VALUE, OFF_HEAP_REGION_NAME, false);
            this.waitForNotificationListenerOnVm(vm, 5000L, 500L, true);
        }
        finally {
            this.doCleanupOnVm(vm);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testOffHeapAllocatedSizeMonitoring() throws Exception {
        VM vm = Host.getHost(0).getVM(0);
        try {
            this.setSystemPropertiesOnVm(vm, true, this.getSystemProperties());
            OffHeapManagementDUnitTest.assertNotNull((Object)this.createOffHeapRegionOnVm(vm, OFF_HEAP_REGION_NAME, DataPolicy.REPLICATE));
            this.assertOffHeapRegionAttributesOnVm(vm);
            this.assertOffHeapMetricsOnVm(vm, 0x100000L, 0L, 0L, 0);
            this.setupOffHeapMonitorOnVm(vm, "OffHeapUsedMemory", 0L, OBJECT_SIZE, false);
            this.clearNotificationListenerOnVm(vm);
            this.doPutOnVm(vm, KEY, VALUE, OFF_HEAP_REGION_NAME, false);
            this.waitForNotificationListenerOnVm(vm, 5000L, 500L, true);
        }
        finally {
            this.doCleanupOnVm(vm);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testOffHeapUsedSizeAggregateMonitoring() throws Exception {
        Host host = Host.getHost(0);
        VM manager = host.getVM(0);
        VM managedNodeA = host.getVM(1);
        VM managedNodeB = host.getVM(2);
        VM managedNodeC = host.getVM(3);
        try {
            this.setSystemPropertiesOnVm(managedNodeA, false, this.getSystemProperties());
            this.setSystemPropertiesOnVm(managedNodeB, false, this.getSystemProperties());
            this.setSystemPropertiesOnVm(managedNodeC, false, this.getSystemProperties());
            this.setSystemPropertiesOnVm(manager, true, this.getSystemProperties());
            OffHeapManagementDUnitTest.assertNotNull((Object)this.createOffHeapRegionOnVm(managedNodeA, OFF_HEAP_REGION_NAME, DataPolicy.REPLICATE));
            OffHeapManagementDUnitTest.assertNotNull((Object)this.createOffHeapRegionOnVm(managedNodeB, OFF_HEAP_REGION_NAME, DataPolicy.REPLICATE));
            OffHeapManagementDUnitTest.assertNotNull((Object)this.createOffHeapRegionOnVm(managedNodeC, OFF_HEAP_REGION_NAME, DataPolicy.REPLICATE));
            this.assertOffHeapRegionAttributesOnVm(managedNodeA);
            this.assertOffHeapRegionAttributesOnVm(managedNodeB);
            this.assertOffHeapRegionAttributesOnVm(managedNodeC);
            this.assertOffHeapMetricsOnVm(managedNodeA, 0x100000L, 0L, 0L, 0);
            this.assertOffHeapMetricsOnVm(managedNodeB, 0x100000L, 0L, 0L, 0);
            this.assertOffHeapMetricsOnVm(managedNodeC, 0x100000L, 0L, 0L, 0);
            this.setupOffHeapMonitorOnVm(manager, "OffHeapUsedMemory", 0L, OBJECT_SIZE * 3, true);
            this.clearNotificationListenerOnVm(manager);
            this.doPutOnVm(managedNodeA, KEY, VALUE, OFF_HEAP_REGION_NAME, false);
            this.waitForNotificationListenerOnVm(manager, 5000L, 500L, true);
        }
        finally {
            this.doCleanupOnVm(managedNodeA);
            this.doCleanupOnVm(managedNodeB);
            this.doCleanupOnVm(managedNodeC);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testOffHeapFreeSizeAggregateMonitoring() throws Exception {
        Host host = Host.getHost(0);
        VM manager = host.getVM(0);
        VM managedNodeA = host.getVM(1);
        VM managedNodeB = host.getVM(2);
        VM managedNodeC = host.getVM(3);
        try {
            this.setSystemPropertiesOnVm(managedNodeA, false, this.getSystemProperties());
            this.setSystemPropertiesOnVm(managedNodeB, false, this.getSystemProperties());
            this.setSystemPropertiesOnVm(managedNodeC, false, this.getSystemProperties());
            this.setSystemPropertiesOnVm(manager, true, this.getSystemProperties());
            OffHeapManagementDUnitTest.assertNotNull((Object)this.createOffHeapRegionOnVm(managedNodeA, OFF_HEAP_REGION_NAME, DataPolicy.REPLICATE));
            OffHeapManagementDUnitTest.assertNotNull((Object)this.createOffHeapRegionOnVm(managedNodeB, OFF_HEAP_REGION_NAME, DataPolicy.REPLICATE));
            OffHeapManagementDUnitTest.assertNotNull((Object)this.createOffHeapRegionOnVm(managedNodeC, OFF_HEAP_REGION_NAME, DataPolicy.REPLICATE));
            this.assertOffHeapMetricsOnVm(managedNodeA, 0x100000L, 0L, 0L, 0);
            this.assertOffHeapMetricsOnVm(managedNodeB, 0x100000L, 0L, 0L, 0);
            this.assertOffHeapMetricsOnVm(managedNodeC, 0x100000L, 0L, 0L, 0);
            this.doPutOnVm(managedNodeA, KEY, VALUE, OFF_HEAP_REGION_NAME, false);
            this.setupOffHeapMonitorOnVm(manager, "OffHeapFreeMemory", 0x300000L, OBJECT_SIZE * 3, true);
            this.clearNotificationListenerOnVm(manager);
            this.doDestroyOnVm(managedNodeA, KEY, OFF_HEAP_REGION_NAME);
            this.waitForNotificationListenerOnVm(manager, 5000L, 500L, true);
        }
        finally {
            this.doCleanupOnVm(managedNodeA);
            this.doCleanupOnVm(managedNodeB);
            this.doCleanupOnVm(managedNodeC);
        }
    }

    protected void doFreeOffHeapMemoryOnVm(VM vm, final int numAllocations, final int numDestroys) {
        vm.invoke(new SerializableRunnable(){

            @Override
            public void run() {
                OffHeapManagementDUnitTest.this.doFreeOffHeapMemory(numAllocations, numDestroys);
            }
        });
    }

    protected void doFreeOffHeapMemory(int numAllocations, int numDestroys) {
        OffHeapManagementDUnitTest.assertTrue((numDestroys <= numAllocations ? 1 : 0) != 0);
        Region region = this.getCache().getRegion(OFF_HEAP_REGION_NAME);
        OffHeapManagementDUnitTest.assertNotNull((Object)region);
        OffHeapManagementDUnitTest.assertTrue((numDestroys <= region.size() ? 1 : 0) != 0);
        String key = "KEY0";
        Object value = key;
        int destroyed = 0;
        while (destroyed < numDestroys) {
            key = "KEY" + (int)(Math.random() * (double)numAllocations);
            value = region.get((Object)key);
            if (null == value) continue;
            region.destroy((Object)key);
            ++destroyed;
        }
    }

    protected int doConsumeOffHeapMemoryOnVm(VM vm, final int allocationSize) {
        return (Integer)vm.invoke(new SerializableCallable(){

            public Object call() {
                return OffHeapManagementDUnitTest.this.doConsumeOffHeapMemory(allocationSize);
            }
        });
    }

    protected int doConsumeOffHeapMemory(int allocationSize) {
        OffHeapMemoryStats stats = ((GemFireCacheImpl)this.getCache()).getOffHeapStore().getStats();
        int i = 0;
        try {
            while (true) {
                this.doPut("KEY" + i++, new byte[allocationSize], OFF_HEAP_REGION_NAME, false);
            }
        }
        catch (OutOfOffHeapMemoryException outOfOffHeapMemoryException) {
            return i;
        }
    }

    protected void assertCompactionTimeStatOnVm(VM vm, final long compactionTime, final ASSERT_OP op) {
        vm.invoke(new SerializableRunnable(){

            @Override
            public void run() {
                OffHeapManagementDUnitTest.this.assertCompactionTimeStat(compactionTime, op);
            }
        });
    }

    protected void assertCompactionTimeStat(long compactionTime, ASSERT_OP op) {
        ManagementService service = ManagementService.getExistingManagementService((Cache)this.getCache());
        OffHeapManagementDUnitTest.assertNotNull((Object)service);
        OffHeapManagementDUnitTest.assertTrue((boolean)service.isManager());
        MemberMXBean memberBean = service.getMemberMXBean();
        OffHeapManagementDUnitTest.assertNotNull((Object)memberBean);
        switch (op) {
            case EQUAL: {
                OffHeapManagementDUnitTest.assertEquals((long)compactionTime, (long)memberBean.getOffHeapCompactionTime());
                break;
            }
            case GREATER_THAN: {
                OffHeapManagementDUnitTest.assertTrue((compactionTime < memberBean.getOffHeapCompactionTime() ? 1 : 0) != 0);
                break;
            }
            case GREATER_THAN_OR_EQUAL: {
                OffHeapManagementDUnitTest.assertTrue((compactionTime <= memberBean.getOffHeapCompactionTime() ? 1 : 0) != 0);
                break;
            }
            case LESS_THAN: {
                OffHeapManagementDUnitTest.assertTrue((compactionTime > memberBean.getOffHeapCompactionTime() ? 1 : 0) != 0);
            }
        }
    }

    protected void assertFragmentationStatOnVm(VM vm, final int fragmentation, final ASSERT_OP op) {
        vm.invoke(new SerializableRunnable(){

            @Override
            public void run() {
                OffHeapManagementDUnitTest.this.assertFragmentationStat(fragmentation, op);
            }
        });
    }

    protected void assertFragmentationStat(int fragmentation, ASSERT_OP op) {
        ManagementService service = ManagementService.getExistingManagementService((Cache)this.getCache());
        OffHeapManagementDUnitTest.assertNotNull((Object)service);
        OffHeapManagementDUnitTest.assertTrue((boolean)service.isManager());
        MemberMXBean memberBean = service.getMemberMXBean();
        OffHeapManagementDUnitTest.assertNotNull((Object)memberBean);
        switch (op) {
            case EQUAL: {
                OffHeapManagementDUnitTest.assertEquals((int)fragmentation, (int)memberBean.getOffHeapFragmentation());
                break;
            }
            case GREATER_THAN: {
                OffHeapManagementDUnitTest.assertTrue((fragmentation < memberBean.getOffHeapFragmentation() ? 1 : 0) != 0);
                break;
            }
            case LESS_THAN: {
                OffHeapManagementDUnitTest.assertTrue((fragmentation > memberBean.getOffHeapFragmentation() ? 1 : 0) != 0);
            }
        }
    }

    protected Properties getSystemProperties() {
        Properties props = this.getDistributedSystemProperties();
        props.setProperty("off-heap-memory-size", "1m");
        props.setProperty("jmx-manager", "true");
        props.setProperty("jmx-manager-start", "true");
        return props;
    }

    protected void doCleanupOnVm(VM vm) {
        vm.invoke(new SerializableRunnable(){

            @Override
            public void run() {
                OffHeapManagementDUnitTest.this.cleanup();
            }
        });
    }

    protected void cleanup() {
        Region region = this.getCache().getRegion(OFF_HEAP_REGION_NAME);
        if (null != region) {
            region.destroyRegion();
        }
        try {
            Set<ObjectInstance> set = mbeanServer.queryMBeans(new ObjectName("monitors:type=Gauge,attr=*"), null);
            for (ObjectInstance obj : set) {
                mbeanServer.unregisterMBean(obj.getObjectName());
            }
        }
        catch (MalformedObjectNameException e) {
            OffHeapManagementDUnitTest.fail((String)e.getMessage());
        }
        catch (NullPointerException e) {
            OffHeapManagementDUnitTest.fail((String)e.getMessage());
        }
        catch (MBeanRegistrationException e) {
            OffHeapManagementDUnitTest.fail((String)e.getMessage());
        }
        catch (InstanceNotFoundException e) {
            OffHeapManagementDUnitTest.fail((String)e.getMessage());
        }
        OffHeapManagementDUnitTest.disconnectFromDS();
    }

    protected void assertOffHeapRegionAttributesOnVm(VM vm) {
        vm.invoke(new SerializableRunnable(){

            @Override
            public void run() {
                OffHeapManagementDUnitTest.this.assertOffHeapRegionAttributes();
            }
        });
    }

    protected void assertOffHeapRegionAttributes() {
        ManagementService service = ManagementService.getExistingManagementService((Cache)this.getCache());
        OffHeapManagementDUnitTest.assertNotNull((Object)service);
        OffHeapManagementDUnitTest.assertTrue((boolean)service.isManager());
        RegionMXBean regionBean = service.getLocalRegionMBean(OFF_HEAP_REGION_PATH);
        OffHeapManagementDUnitTest.assertNotNull((Object)regionBean);
        RegionAttributesData regionData = regionBean.listRegionAttributes();
        OffHeapManagementDUnitTest.assertNotNull((Object)regionData);
        OffHeapManagementDUnitTest.assertTrue((boolean)regionData.getEnableOffHeapMemory());
    }

    protected void assertOffHeapMetricsOnVm(VM vm, final long freeMemory, final long allocatedMemory, final long objects, final int fragmentation) {
        vm.invoke(new SerializableRunnable(){

            @Override
            public void run() {
                OffHeapManagementDUnitTest.this.assertOffHeapMetrics(freeMemory, allocatedMemory, objects, fragmentation);
            }
        });
    }

    protected void assertOffHeapMetrics(long freeMemory, long allocatedMemory, long objects, int fragmentation) {
        ManagementService service = ManagementService.getExistingManagementService((Cache)this.getCache());
        OffHeapManagementDUnitTest.assertNotNull((Object)service);
        OffHeapManagementDUnitTest.assertTrue((boolean)service.isManager());
        MemberMXBean memberBean = service.getMemberMXBean();
        OffHeapManagementDUnitTest.assertNotNull((Object)memberBean);
        OffHeapManagementDUnitTest.assertEquals((long)freeMemory, (long)memberBean.getOffHeapFreeMemory());
        OffHeapManagementDUnitTest.assertEquals((long)allocatedMemory, (long)memberBean.getOffHeapUsedMemory());
        OffHeapManagementDUnitTest.assertEquals((long)objects, (long)memberBean.getOffHeapObjects());
        OffHeapManagementDUnitTest.assertEquals((int)fragmentation, (int)memberBean.getOffHeapFragmentation());
    }

    protected boolean createOffHeapRegionOnVm(VM vm, final String name, final DataPolicy dataPolicy) {
        return (Boolean)vm.invoke(new SerializableCallable(){

            public Object call() throws Exception {
                return null != OffHeapManagementDUnitTest.this.createOffHeapRegion(name, dataPolicy);
            }
        });
    }

    protected Region createOffHeapRegion(String name, DataPolicy dataPolicy) {
        return this.getCache().createRegionFactory().setEnableOffHeapMemory(true).setDataPolicy(dataPolicy).create(name);
    }

    protected void setSystemPropertiesOnVm(VM vm, final boolean management, final Properties props) {
        vm.invoke(new SerializableRunnable(){

            @Override
            public void run() {
                OffHeapManagementDUnitTest.this.setSystemProperties(management, props);
            }
        });
    }

    protected void setSystemProperties(boolean management, Properties props) {
        this.getSystem(props);
        ManagementService service = ManagementService.getManagementService((Cache)this.getCache());
        if (management && !service.isManager()) {
            service.startManager();
        }
    }

    protected void doDestroyOnVm(VM vm, final Object key, final String regionName) {
        vm.invoke(new SerializableRunnable(){

            @Override
            public void run() {
                OffHeapManagementDUnitTest.this.doDestroy(key, regionName);
            }
        });
    }

    protected void doDestroy(Object key, String regionName) {
        Region region = this.getCache().getRegion(regionName);
        OffHeapManagementDUnitTest.assertNotNull((Object)region);
        region.destroy(key);
    }

    protected void doPutOnVm(VM vm, final Object key, final Object value, final String regionName, final boolean expectException) {
        vm.invoke(new SerializableRunnable(){

            @Override
            public void run() {
                OffHeapManagementDUnitTest.this.doPut(key, value, regionName, expectException);
            }
        });
    }

    protected void doPut(Object key, Object value, String regionName, boolean expectException) {
        block2: {
            Region region = this.getCache().getRegion(regionName);
            OffHeapManagementDUnitTest.assertNotNull((Object)region);
            try {
                region.put(key, value);
            }
            catch (OutOfOffHeapMemoryException e) {
                if (expectException) break block2;
                throw e;
            }
        }
    }

    protected void addOffHeapNotificationListenerOnVm(VM vm) {
        vm.invoke(new SerializableRunnable(){

            @Override
            public void run() {
                OffHeapManagementDUnitTest.this.addOffHeapNotificationListener();
            }
        });
    }

    protected void addOffHeapNotificationListener() {
        ManagementService service = ManagementService.getExistingManagementService((Cache)this.getCache());
        OffHeapManagementDUnitTest.assertNotNull((Object)service);
        OffHeapManagementDUnitTest.assertTrue((boolean)service.isManager());
        MemberMXBean memberBean = service.getMemberMXBean();
        OffHeapManagementDUnitTest.assertNotNull((Object)memberBean);
        OffHeapManagementDUnitTest.assertTrue((boolean)(memberBean instanceof MemberMBean));
        ((MemberMBean)memberBean).addNotificationListener((NotificationListener)notificationListener, null, null);
    }

    protected void setupOffHeapMonitorOnVm(VM vm, final String attribute, final long highThreshold, final long lowThreshold, final boolean aggregate) {
        vm.invoke(new SerializableRunnable(){

            @Override
            public void run() {
                OffHeapManagementDUnitTest.this.setupOffHeapMonitor(attribute, highThreshold, lowThreshold, aggregate);
            }
        });
    }

    protected void setupOffHeapMonitor(String attribute, long highThreshold, long lowThreshold, boolean aggregate) {
        ObjectName objectName = null;
        objectName = !aggregate ? MBeanJMXAdapter.getMemberMBeanName((DistributedMember)InternalDistributedSystem.getConnectedInstance().getDistributedMember()) : MBeanJMXAdapter.getDistributedSystemName();
        OffHeapManagementDUnitTest.assertNotNull((Object)objectName);
        try {
            ObjectName offHeapMonitorName = new ObjectName("monitors:type=Gauge,attr=" + attribute);
            mbeanServer.createMBean("javax.management.monitor.GaugeMonitor", offHeapMonitorName);
            AttributeList al = new AttributeList();
            al.add(new Attribute("ObservedObject", objectName));
            al.add(new Attribute("GranularityPeriod", 500));
            al.add(new Attribute("ObservedAttribute", attribute));
            al.add(new Attribute("Notify", true));
            al.add(new Attribute("NotifyHigh", true));
            al.add(new Attribute("NotifyLow", true));
            al.add(new Attribute("HighTheshold", highThreshold));
            al.add(new Attribute("LowThreshold", lowThreshold));
            mbeanServer.setAttributes(offHeapMonitorName, al);
            mbeanServer.addNotificationListener(offHeapMonitorName, notificationListener, null, null);
            mbeanServer.invoke(offHeapMonitorName, "start", new Object[0], new String[0]);
        }
        catch (Exception e) {
            e.printStackTrace();
            OffHeapManagementDUnitTest.fail((String)e.getMessage());
        }
    }

    protected void waitForNotificationListenerOnVm(VM vm, final long wait, final long interval, final boolean throwOnTimeout) {
        vm.invoke(new SerializableRunnable(){

            @Override
            public void run() {
                DistributedTestCase.waitForCriterion(new DistributedTestCase.WaitCriterion(){

                    @Override
                    public boolean done() {
                        return notificationListener.getNotificationSize() > 0;
                    }

                    @Override
                    public String description() {
                        return "Awaiting Notification Listener";
                    }
                }, wait, interval, throwOnTimeout);
            }
        });
    }

    protected void clearNotificationListenerOnVm(VM vm) {
        vm.invoke(new SerializableRunnable(){

            @Override
            public void run() {
                notificationListener.clear();
            }
        });
    }

    private static enum ASSERT_OP {
        EQUAL,
        GREATER_THAN,
        GREATER_THAN_OR_EQUAL,
        LESS_THAN;

    }
}

