/*
 * Decompiled with CFR 0.152.
 */
package com.gemstone.gemfire.management;

import com.gemstone.gemfire.cache.Cache;
import com.gemstone.gemfire.cache.CacheException;
import com.gemstone.gemfire.cache.CacheFactory;
import com.gemstone.gemfire.cache.DataPolicy;
import com.gemstone.gemfire.cache.Region;
import com.gemstone.gemfire.cache.RegionFactory;
import com.gemstone.gemfire.cache.RegionShortcut;
import com.gemstone.gemfire.cache.query.dunit.QueryUsingFunctionContextDUnitTest;
import com.gemstone.gemfire.cache.query.partitioned.PRQueryDUnitHelper;
import com.gemstone.gemfire.cache30.CacheSerializableRunnable;
import com.gemstone.gemfire.distributed.DistributedMember;
import com.gemstone.gemfire.management.DistributedSystemMXBean;
import com.gemstone.gemfire.management.MBeanUtil;
import com.gemstone.gemfire.management.ManagementTestBase;
import com.gemstone.gemfire.management.internal.ManagementStrings;
import com.gemstone.gemfire.management.internal.SystemManagementService;
import com.gemstone.gemfire.management.internal.beans.BeanUtilFuncs;
import com.gemstone.gemfire.management.internal.cli.json.GfJsonArray;
import com.gemstone.gemfire.management.internal.cli.json.GfJsonException;
import com.gemstone.gemfire.management.internal.cli.json.GfJsonObject;
import com.gemstone.gemfire.pdx.PdxInstance;
import com.gemstone.gemfire.pdx.PdxInstanceFactory;
import com.gemstone.gemfire.pdx.internal.PdxInstanceFactoryImpl;
import dunit.DistributedTestCase;
import dunit.SerializableRunnable;
import java.io.IOException;
import java.util.ArrayList;
import junit.framework.TestCase;

public class QueryDataDUnitTest
extends ManagementTestBase {
    private static final long serialVersionUID = 1L;
    private static final int MAX_WAIT = 100000;
    private static final int cntDest = 30;
    private static final int cnt = 0;
    static String PartitionedRegionName1 = "TestPartitionedRegion1";
    static String PartitionedRegionName2 = "TestPartitionedRegion2";
    static String PartitionedRegionName3 = "TestPartitionedRegion3";
    static String PartitionedRegionName4 = "TestPartitionedRegion4";
    static String PartitionedRegionName5 = "TestPartitionedRegion5";
    static String repRegionName = "TestRepRegion";
    static String repRegionName2 = "TestRepRegion2";
    static String repRegionName3 = "TestRepRegion3";
    static String repRegionName4 = "TestRepRegion4";
    static String localRegionName = "TestLocalRegion";
    private static PRQueryDUnitHelper PRQHelp = new PRQueryDUnitHelper("");
    public static String[] queries = new String[]{"select * from /" + PartitionedRegionName1 + " where ID>=0", "Select * from /" + PartitionedRegionName1 + " r1, /" + PartitionedRegionName2 + " r2 where r1.ID = r2.ID", "Select * from /" + PartitionedRegionName1 + " r1, /" + PartitionedRegionName2 + " r2 where r1.ID = r2.ID AND r1.status = r2.status", "Select * from /" + PartitionedRegionName1 + " r1, /" + PartitionedRegionName2 + " r2, /" + PartitionedRegionName3 + " r3 where r1.ID = r2.ID and r2.ID = r3.ID", "Select * from /" + PartitionedRegionName1 + " r1, /" + PartitionedRegionName2 + " r2, /" + PartitionedRegionName3 + " r3  , /" + repRegionName + " r4 where r1.ID = r2.ID and r2.ID = r3.ID and r3.ID = r4.ID", "Select * from /" + PartitionedRegionName4 + " r4 , /" + PartitionedRegionName5 + " r5 where r4.ID = r5.ID"};
    public static String[] nonColocatedQueries = new String[]{"Select * from /" + PartitionedRegionName1 + " r1, /" + PartitionedRegionName4 + " r4 where r1.ID = r4.ID", "Select * from /" + PartitionedRegionName1 + " r1, /" + PartitionedRegionName4 + " r4 , /" + PartitionedRegionName5 + " r5 where r1.ID = r42.ID and r4.ID = r5.ID"};
    public static String[] queriesForRR = new String[]{"<trace> select * from /" + repRegionName + " where ID>=0", "Select * from /" + repRegionName + " r1, /" + repRegionName2 + " r2 where r1.ID = r2.ID", "select * from /" + repRegionName3 + " where ID>=0", "select * from /" + repRegionName4};

    public QueryDataDUnitTest(String name) {
        super(name);
    }

    @Override
    public void setUp() throws Exception {
        super.setUp();
        this.initManagement(false);
        this.createRegionsInNodes();
        this.fillValuesInRegions();
    }

    @Override
    public void tearDown2() throws Exception {
        super.tearDown2();
    }

    public CacheSerializableRunnable getCacheSerializableRunnableForPRPuts(final String regionName, final Object[] portfolio, final int from, final int to) {
        CacheSerializableRunnable puts = new CacheSerializableRunnable("Region Puts"){

            @Override
            public void run2() throws CacheException {
                Cache cache = CacheFactory.getAnyInstance();
                Region region = cache.getRegion(regionName);
                for (int j = from; j < to; ++j) {
                    region.put((Object)new Integer(j), portfolio[j]);
                }
                DistributedTestCase.getLogWriter().info("PRQueryDUnitHelper#getCacheSerializableRunnableForPRPuts: Inserted Portfolio data on Region " + regionName);
            }
        };
        return puts;
    }

    public CacheSerializableRunnable getCacheSerializableRunnableForPDXPuts(final String regionName) {
        CacheSerializableRunnable puts = new CacheSerializableRunnable("Region Puts"){

            @Override
            public void run2() throws CacheException {
                QueryDataDUnitTest.this.putPdxInstances(regionName);
            }
        };
        return puts;
    }

    public CacheSerializableRunnable getCacheSerializableRunnableForBigCollPuts(final String regionName) {
        CacheSerializableRunnable bigPuts = new CacheSerializableRunnable("Big Coll Puts"){

            @Override
            public void run2() throws CacheException {
                QueryDataDUnitTest.this.putBigInstances(regionName);
            }
        };
        return bigPuts;
    }

    public void fillValuesInRegions() {
        Object[] portfolio = PRQHelp.createPortfoliosAndPositions(30);
        managedNode1.invoke(this.getCacheSerializableRunnableForPRPuts(localRegionName, portfolio, 0, 30));
        managedNode1.invoke(this.getCacheSerializableRunnableForPRPuts(repRegionName, portfolio, 0, 30));
        managedNode2.invoke(this.getCacheSerializableRunnableForPRPuts(repRegionName2, portfolio, 0, 30));
        managedNode1.invoke(this.getCacheSerializableRunnableForPRPuts(PartitionedRegionName1, portfolio, 0, 30));
        managedNode1.invoke(this.getCacheSerializableRunnableForPRPuts(PartitionedRegionName2, portfolio, 0, 30));
        managedNode1.invoke(this.getCacheSerializableRunnableForPRPuts(PartitionedRegionName3, portfolio, 0, 30));
        managedNode1.invoke(this.getCacheSerializableRunnableForPRPuts(PartitionedRegionName4, portfolio, 0, 30));
        managedNode1.invoke(this.getCacheSerializableRunnableForPRPuts(PartitionedRegionName5, portfolio, 0, 30));
        managedNode1.invoke(this.getCacheSerializableRunnableForPDXPuts(repRegionName3));
        managedNode1.invoke(this.getCacheSerializableRunnableForBigCollPuts(repRegionName4));
    }

    public void putPdxInstances(String regionName) throws CacheException {
        PdxInstanceFactory pf = PdxInstanceFactoryImpl.newCreator((String)"Portfolio", (boolean)false);
        Region r = this.getCache().getRegion(regionName);
        pf.writeInt("ID", 111);
        pf.writeString("status", "active");
        pf.writeString("secId", "IBM");
        PdxInstance pi = pf.create();
        r.put((Object)"IBM", (Object)pi);
        pf = PdxInstanceFactoryImpl.newCreator((String)"Portfolio", (boolean)false);
        pf.writeInt("ID", 222);
        pf.writeString("status", "inactive");
        pf.writeString("secId", "YHOO");
        pi = pf.create();
        r.put((Object)"YHOO", (Object)pi);
        pf = PdxInstanceFactoryImpl.newCreator((String)"Portfolio", (boolean)false);
        pf.writeInt("ID", 333);
        pf.writeString("status", "active");
        pf.writeString("secId", "GOOGL");
        pi = pf.create();
        r.put((Object)"GOOGL", (Object)pi);
        pf = PdxInstanceFactoryImpl.newCreator((String)"Portfolio", (boolean)false);
        pf.writeInt("ID", 111);
        pf.writeString("status", "inactive");
        pf.writeString("secId", "VMW");
        pi = pf.create();
        r.put((Object)"VMW", (Object)pi);
    }

    public void putBigInstances(String regionName) throws CacheException {
        Region r = this.getCache().getRegion(regionName);
        ArrayList<String> bigColl1 = new ArrayList<String>();
        ArrayList<String> bigColl2 = new ArrayList<String>();
        ArrayList<String> bigColl3 = new ArrayList<String>();
        for (int i = 0; i < 200; ++i) {
            bigColl1.add("BigColl_1_ElemenNo_" + i);
            bigColl2.add("BigColl_2_ElemenNo_" + i);
            bigColl3.add("BigColl_3_ElemenNo_" + i);
        }
        r.put((Object)"BigColl_1", bigColl1);
        r.put((Object)"BigColl_2", bigColl2);
        r.put((Object)"BigColl_3", bigColl3);
    }

    private void createRegionsInNodes() {
        managedNode1.invoke(QueryUsingFunctionContextDUnitTest.class, "createLocalRegion");
        managedNode1.invoke(QueryUsingFunctionContextDUnitTest.class, "createReplicatedRegion");
        managedNode2.invoke(QueryUsingFunctionContextDUnitTest.class, "createReplicatedRegion");
        managedNode3.invoke(QueryUsingFunctionContextDUnitTest.class, "createReplicatedRegion");
        try {
            this.createDistributedRegion(managedNode2, repRegionName2);
            this.createDistributedRegion(managedNode1, repRegionName3);
            this.createDistributedRegion(managedNode1, repRegionName4);
        }
        catch (Exception e1) {
            QueryDataDUnitTest.fail((String)("Test Failed while creating region " + e1.getMessage()));
        }
        managedNode1.invoke(QueryUsingFunctionContextDUnitTest.class, "createColocatedPR");
        managedNode2.invoke(QueryUsingFunctionContextDUnitTest.class, "createColocatedPR");
        managedNode3.invoke(QueryUsingFunctionContextDUnitTest.class, "createColocatedPR");
        managingNode.invoke(new SerializableRunnable("Wait for all Region Proxies to get replicated"){

            @Override
            public void run() {
                Cache cache = QueryDataDUnitTest.this.getCache();
                SystemManagementService service = (SystemManagementService)ManagementTestBase.getManagementService();
                DistributedSystemMXBean bean = service.getDistributedSystemMXBean();
                try {
                    MBeanUtil.getDistributedRegionMbean("/" + PartitionedRegionName1, 3);
                    MBeanUtil.getDistributedRegionMbean("/" + PartitionedRegionName2, 3);
                    MBeanUtil.getDistributedRegionMbean("/" + PartitionedRegionName3, 3);
                    MBeanUtil.getDistributedRegionMbean("/" + PartitionedRegionName4, 3);
                    MBeanUtil.getDistributedRegionMbean("/" + PartitionedRegionName5, 3);
                    MBeanUtil.getDistributedRegionMbean("/" + repRegionName, 3);
                    MBeanUtil.getDistributedRegionMbean("/" + repRegionName2, 1);
                    MBeanUtil.getDistributedRegionMbean("/" + repRegionName3, 1);
                    MBeanUtil.getDistributedRegionMbean("/" + repRegionName4, 1);
                }
                catch (Exception e) {
                    TestCase.fail((String)"Region proxies not replicated in time");
                }
            }
        });
    }

    public void testQueryOnPartitionedRegion() throws Exception {
        final DistributedMember member1 = this.getMember(managedNode1);
        DistributedMember member2 = this.getMember(managedNode2);
        DistributedMember member3 = this.getMember(managedNode3);
        managingNode.invoke(new SerializableRunnable("testQueryOnPartitionedRegion"){

            @Override
            public void run() {
                Cache cache = QueryDataDUnitTest.this.getCache();
                SystemManagementService service = (SystemManagementService)ManagementTestBase.getManagementService();
                DistributedSystemMXBean bean = service.getDistributedSystemMXBean();
                TestCase.assertNotNull((Object)bean);
                try {
                    for (int i = 0; i < queries.length; ++i) {
                        GfJsonObject gfJsonObj;
                        String jsonString = null;
                        if (i == 0) {
                            jsonString = bean.queryData(queries[i], null, 10);
                            if (jsonString.contains("result") && !jsonString.contains("No Data Found")) {
                                gfJsonObj = new GfJsonObject(jsonString);
                                DistributedTestCase.getLogWriter().info("testQueryOnPartitionedRegion" + queries[i] + " is = " + jsonString);
                                continue;
                            }
                            TestCase.fail((String)"Query On Cluster should have result");
                            continue;
                        }
                        jsonString = bean.queryData(queries[i], member1.getId(), 10);
                        if (jsonString.contains("member")) {
                            gfJsonObj = new GfJsonObject(jsonString);
                            DistributedTestCase.getLogWriter().info("testQueryOnPartitionedRegion" + queries[i] + " is = " + jsonString);
                            continue;
                        }
                        TestCase.fail((String)"Query On Member should have member");
                    }
                }
                catch (GfJsonException e) {
                    TestCase.fail((String)e.getMessage());
                }
                catch (Exception e) {
                    TestCase.fail((String)e.getMessage());
                }
            }
        });
    }

    public void testQueryOnReplicatedRegion() throws Exception {
        managingNode.invoke(new SerializableRunnable("Query Test For REPL1"){

            @Override
            public void run() {
                Cache cache = QueryDataDUnitTest.this.getCache();
                SystemManagementService service = (SystemManagementService)ManagementTestBase.getManagementService();
                DistributedSystemMXBean bean = service.getDistributedSystemMXBean();
                TestCase.assertNotNull((Object)bean);
                try {
                    for (int i = 0; i < queriesForRR.length; ++i) {
                        GfJsonObject gfJsonObject;
                        String jsonString1 = null;
                        if (i == 0) {
                            jsonString1 = bean.queryData(queriesForRR[i], null, 10);
                            if (jsonString1.contains("result") && !jsonString1.contains("No Data Found")) {
                                gfJsonObject = new GfJsonObject(jsonString1);
                                continue;
                            }
                            TestCase.fail((String)"Query On Cluster should have result");
                            continue;
                        }
                        jsonString1 = bean.queryData(queriesForRR[i], null, 10);
                        if (jsonString1.contains("result")) {
                            gfJsonObject = new GfJsonObject(jsonString1);
                            continue;
                        }
                        DistributedTestCase.getLogWriter().info("Failed Test String" + queriesForRR[i] + " is = " + jsonString1);
                        TestCase.fail((String)"Join on Replicated did not work.");
                    }
                }
                catch (GfJsonException e) {
                    TestCase.fail((String)e.getMessage());
                }
                catch (IOException e) {
                    TestCase.fail((String)e.getMessage());
                }
                catch (Exception e) {
                    TestCase.fail((String)e.getMessage());
                }
            }
        });
    }

    public void testMemberWise() throws Exception {
        final DistributedMember member1 = this.getMember(managedNode1);
        final DistributedMember member2 = this.getMember(managedNode2);
        managingNode.invoke(new SerializableRunnable("testMemberWise"){

            @Override
            public void run() {
                Cache cache = QueryDataDUnitTest.this.getCache();
                SystemManagementService service = (SystemManagementService)ManagementTestBase.getManagementService();
                DistributedSystemMXBean bean = service.getDistributedSystemMXBean();
                TestCase.assertNotNull((Object)bean);
                try {
                    byte[] bytes = bean.queryDataForCompressedResult(queriesForRR[0], member1.getId() + "," + member2.getId(), 2);
                    String jsonString = BeanUtilFuncs.decompress((byte[])bytes);
                    GfJsonObject gfJsonObj = new GfJsonObject(jsonString);
                    DistributedTestCase.getLogWriter().info("testMemberWise " + queriesForRR[2] + " is = " + jsonString);
                }
                catch (GfJsonException e) {
                    TestCase.fail((String)e.getMessage());
                }
                catch (IOException e) {
                    TestCase.fail((String)e.getMessage());
                }
                catch (Exception e) {
                    TestCase.fail((String)e.getMessage());
                }
            }
        });
    }

    public void testLimit() throws Exception {
        managingNode.invoke(new SerializableRunnable("Test Limit"){

            @Override
            public void run() {
                SystemManagementService service = (SystemManagementService)ManagementTestBase.getManagementService();
                DistributedSystemMXBean bean = service.getDistributedSystemMXBean();
                TestCase.assertNotNull((Object)bean);
                try {
                    String jsonString1 = null;
                    byte[] bytes = bean.queryDataForCompressedResult(queriesForRR[2], null, 2);
                    jsonString1 = BeanUtilFuncs.decompress((byte[])bytes);
                    if (jsonString1.contains("result") && !jsonString1.contains("No Data Found")) {
                        GfJsonObject gfJsonObj = new GfJsonObject(jsonString1);
                        DistributedTestCase.getLogWriter().info("testLimit" + queriesForRR[2] + " is = " + jsonString1);
                        GfJsonArray arr = gfJsonObj.getJSONArray("result");
                        TestCase.assertEquals((int)2, (int)arr.size());
                    } else {
                        TestCase.fail((String)"Query On Cluster should have result");
                    }
                }
                catch (GfJsonException e) {
                    TestCase.fail((String)e.getMessage());
                }
                catch (IOException e) {
                    TestCase.fail((String)e.getMessage());
                }
                catch (Exception e) {
                    TestCase.fail((String)e.getMessage());
                }
            }
        });
    }

    public void testErrors() throws Exception {
        final DistributedMember member1 = this.getMember(managedNode1);
        DistributedMember member2 = this.getMember(managedNode2);
        DistributedMember member3 = this.getMember(managedNode3);
        managingNode.invoke(new SerializableRunnable("Test Error"){

            @Override
            public void run() {
                SystemManagementService service = (SystemManagementService)ManagementTestBase.getManagementService();
                DistributedSystemMXBean bean = service.getDistributedSystemMXBean();
                TestCase.assertNotNull((Object)bean);
                try {
                    Exception expectedException;
                    Exception expectedException2;
                    Cache cache = QueryDataDUnitTest.this.getCache();
                    try {
                        byte[] bytes = bean.queryDataForCompressedResult("Select * from TestPartitionedRegion1", null, 2);
                        TestCase.fail((String)"Should have thrown Exception : Region mentioned in query probably missing");
                    }
                    catch (Exception e) {
                        expectedException2 = new Exception(ManagementStrings.QUERY__MSG__INVALID_QUERY.toLocalizedString(new Object[]{"Region mentioned in query probably missing /"}));
                        TestCase.assertEquals((String)expectedException2.getLocalizedMessage(), (String)e.getLocalizedMessage());
                    }
                    try {
                        String query = "Select * from /PartitionedRegionName9 r1, PartitionedRegionName2 r2 where r1.ID = r2.ID";
                        byte[] bytes = bean.queryDataForCompressedResult(query, null, 2);
                        TestCase.fail((String)"Should have thrown Exception : Cannot find regions <{0}> in any of the members");
                    }
                    catch (Exception e) {
                        expectedException2 = new Exception(ManagementStrings.QUERY__MSG__REGIONS_NOT_FOUND.toLocalizedString(new Object[]{"/PartitionedRegionName9"}));
                        TestCase.assertEquals((String)expectedException2.getLocalizedMessage(), (String)e.getLocalizedMessage());
                    }
                    String testTemp = "testTemp";
                    try {
                        RegionFactory rf = cache.createRegionFactory(RegionShortcut.REPLICATE);
                        rf.create("testTemp");
                        String query = "Select * from /testTemp";
                        bean.queryDataForCompressedResult(query, member1.getId(), 2);
                        TestCase.fail((String)"Should have thrown Exception : Cannot find regions <{0}> in specified members");
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                        expectedException = new Exception(ManagementStrings.QUERY__MSG__REGIONS_NOT_FOUND_ON_MEMBERS.toLocalizedString(new Object[]{"/testTemp"}));
                        TestCase.assertEquals((String)expectedException.getLocalizedMessage(), (String)e.getLocalizedMessage());
                    }
                    try {
                        String query = queries[1];
                        bean.queryDataForCompressedResult(query, null, 2);
                        TestCase.fail((String)"Should have thrown Exception : Join operation can only be executed on targeted members, please give member input");
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                        expectedException = new Exception(ManagementStrings.QUERY__MSG__JOIN_OP_EX.toLocalizedString());
                        TestCase.assertEquals((String)expectedException.getLocalizedMessage(), (String)e.getLocalizedMessage());
                    }
                }
                catch (Exception e) {
                    TestCase.fail((String)e.getMessage());
                }
            }
        });
    }

    public void testNormalRegions() throws Exception {
        DistributedMember member1 = this.getMember(managedNode1);
        DistributedMember member2 = this.getMember(managedNode2);
        DistributedMember member3 = this.getMember(managedNode3);
        managingNode.invoke(new SerializableRunnable("Test Error"){

            @Override
            public void run() {
                SystemManagementService service = (SystemManagementService)ManagementTestBase.getManagementService();
                DistributedSystemMXBean bean = service.getDistributedSystemMXBean();
                TestCase.assertNotNull((Object)bean);
                String testNormal = "testNormal";
                String testTemp = "testTemp";
                String testSNormal = "testSNormal";
                String testATemp = "testATemp";
                try {
                    Cache cache = QueryDataDUnitTest.this.getCache();
                    RegionFactory rf = cache.createRegionFactory(RegionShortcut.LOCAL_HEAP_LRU);
                    rf.create("testNormal");
                    rf.create("testSNormal");
                    Region region = cache.getRegion("/testNormal");
                    TestCase.assertTrue((region.getAttributes().getDataPolicy() == DataPolicy.NORMAL ? 1 : 0) != 0);
                    RegionFactory rf1 = cache.createRegionFactory(RegionShortcut.REPLICATE);
                    rf1.create("testTemp");
                    rf1.create("testATemp");
                    String query1 = "Select * from /testTemp r1,/testNormal r2 where r1.ID = r2.ID";
                    String query2 = "Select * from /testSNormal r1,/testATemp r2 where r1.ID = r2.ID";
                    String query3 = "Select * from /testSNormal";
                    try {
                        bean.queryDataForCompressedResult(query1, null, 2);
                        bean.queryDataForCompressedResult(query2, null, 2);
                        bean.queryDataForCompressedResult(query3, null, 2);
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                }
                catch (Exception e) {
                    TestCase.fail((String)e.getMessage());
                }
            }
        });
    }
}

