/*
 * Decompiled with CFR 0.152.
 */
package com.gemstone.gemfire.management;

import com.gemstone.gemfire.cache.Cache;
import com.gemstone.gemfire.distributed.DistributedMember;
import com.gemstone.gemfire.distributed.Locator;
import com.gemstone.gemfire.internal.cache.GemFireCacheImpl;
import com.gemstone.gemfire.internal.cache.wan.WANTestBase;
import com.gemstone.gemfire.management.AsyncEventQueueMXBean;
import com.gemstone.gemfire.management.DistributedSystemMXBean;
import com.gemstone.gemfire.management.GatewayReceiverMXBean;
import com.gemstone.gemfire.management.GatewaySenderMXBean;
import com.gemstone.gemfire.management.MBeanUtil;
import com.gemstone.gemfire.management.ManagementService;
import com.gemstone.gemfire.management.ManagementTestBase;
import com.gemstone.gemfire.management.RegionMXBean;
import com.gemstone.gemfire.management.internal.MBeanJMXAdapter;
import dunit.DistributedTestCase;
import dunit.Host;
import dunit.SerializableRunnable;
import dunit.VM;
import java.util.Map;
import javax.management.MBeanServer;
import javax.management.ObjectName;
import junit.framework.TestCase;

public class WANManagementDUnitTest
extends ManagementTestBase {
    private static final long serialVersionUID = 1L;
    public static MBeanServer mbeanServer = MBeanJMXAdapter.mbeanServer;

    public WANManagementDUnitTest(String name) throws Exception {
        super(name);
    }

    @Override
    public void tearDown2() throws Exception {
        super.tearDown2();
    }

    public void testMBeanCallback() throws Exception {
        VM nyLocator = WANManagementDUnitTest.getManagedNodeList().get(0);
        VM nyReceiver = WANManagementDUnitTest.getManagedNodeList().get(1);
        VM puneSender = WANManagementDUnitTest.getManagedNodeList().get(2);
        VM managing = WANManagementDUnitTest.getManagingNode();
        VM puneLocator = Host.getLocator();
        int punePort = (Integer)puneLocator.invoke(WANManagementDUnitTest.class, "getLocatorPort");
        Integer nyPort = (Integer)nyLocator.invoke(WANTestBase.class, "createFirstRemoteLocator", new Object[]{12, punePort});
        puneSender.invoke(WANTestBase.class, "createCache", new Object[]{punePort});
        managing.invoke(WANTestBase.class, "createManagementCache", new Object[]{punePort});
        this.startManagingNode(managing);
        puneSender.invoke(WANTestBase.class, "createSender", new Object[]{"pn", 12, true, 100, 300, false, false, null, true});
        managing.invoke(WANTestBase.class, "createSender", new Object[]{"pn", 12, true, 100, 300, false, false, null, true});
        puneSender.invoke(WANTestBase.class, "createPartitionedRegion", new Object[]{testName + "_PR", "pn", 1, 100, false});
        managing.invoke(WANTestBase.class, "createPartitionedRegion", new Object[]{testName + "_PR", "pn", 1, 100, false});
        nyReceiver.invoke(WANTestBase.class, "createReceiver", new Object[]{nyPort});
        nyReceiver.invoke(WANTestBase.class, "createPartitionedRegion", new Object[]{testName + "_PR", null, 1, 100, false});
        puneSender.invoke(WANTestBase.class, "startSender", new Object[]{"pn"});
        managing.invoke(WANTestBase.class, "startSender", new Object[]{"pn"});
        puneSender.invoke(WANTestBase.class, "waitForSenderRunningState", new Object[]{"pn"});
        managing.invoke(WANTestBase.class, "waitForSenderRunningState", new Object[]{"pn"});
        this.checkSenderMBean(puneSender, testName + "_PR");
        this.checkSenderMBean(managing, testName + "_PR");
        this.checkReceiverMBean(nyReceiver);
        this.stopGatewaySender(puneSender);
        this.startGatewaySender(puneSender);
        DistributedMember puneMember = (DistributedMember)puneSender.invoke(WANManagementDUnitTest.class, "getMember");
        this.checkProxySender(managing, puneMember);
        this.checkSenderNavigationAPIS(managing, puneMember);
    }

    public void testReceiverMBean() throws Exception {
        VM nyLocator = WANManagementDUnitTest.getManagedNodeList().get(0);
        VM nyReceiver = WANManagementDUnitTest.getManagedNodeList().get(1);
        VM puneSender = WANManagementDUnitTest.getManagedNodeList().get(2);
        VM managing = WANManagementDUnitTest.getManagingNode();
        VM puneLocator = Host.getLocator();
        int punePort = (Integer)puneLocator.invoke(WANManagementDUnitTest.class, "getLocatorPort");
        Integer nyPort = (Integer)nyLocator.invoke(WANTestBase.class, "createFirstRemoteLocator", new Object[]{12, punePort});
        puneSender.invoke(WANTestBase.class, "createCache", new Object[]{punePort});
        nyReceiver.invoke(WANTestBase.class, "createReceiver", new Object[]{nyPort});
        nyReceiver.invoke(WANTestBase.class, "createPartitionedRegion", new Object[]{testName + "_PR", null, 1, 100, false});
        puneSender.invoke(WANTestBase.class, "createSender", new Object[]{"pn", 12, true, 100, 300, false, false, null, true});
        puneSender.invoke(WANTestBase.class, "createPartitionedRegion", new Object[]{testName + "_PR", "pn", 1, 100, false});
        puneSender.invoke(WANTestBase.class, "startSender", new Object[]{"pn"});
        puneSender.invoke(WANTestBase.class, "waitForSenderRunningState", new Object[]{"pn"});
        managing.invoke(WANTestBase.class, "createManagementCache", new Object[]{nyPort});
        this.startManagingNode(managing);
        this.checkSenderMBean(puneSender, testName + "_PR");
        this.checkReceiverMBean(nyReceiver);
        DistributedMember nyMember = (DistributedMember)nyReceiver.invoke(WANManagementDUnitTest.class, "getMember");
        this.checkProxyReceiver(managing, nyMember);
        this.checkReceiverNavigationAPIS(managing, nyMember);
    }

    public void testAsyncEventQueue() throws Exception {
        VM nyLocator = WANManagementDUnitTest.getManagedNodeList().get(0);
        VM nyReceiver = WANManagementDUnitTest.getManagedNodeList().get(1);
        VM puneSender = WANManagementDUnitTest.getManagedNodeList().get(2);
        VM managing = WANManagementDUnitTest.getManagingNode();
        VM puneLocator = Host.getLocator();
        int punePort = (Integer)puneLocator.invoke(WANManagementDUnitTest.class, "getLocatorPort");
        Integer nyPort = (Integer)nyLocator.invoke(WANTestBase.class, "createFirstRemoteLocator", new Object[]{12, punePort});
        puneSender.invoke(WANTestBase.class, "createCache", new Object[]{punePort});
        managing.invoke(WANTestBase.class, "createManagementCache", new Object[]{punePort});
        this.startManagingNode(managing);
        puneSender.invoke(WANTestBase.class, "createAsyncEventQueue", new Object[]{"pn", false, 100, 100, false, false, "puneSender", false});
        managing.invoke(WANTestBase.class, "createAsyncEventQueue", new Object[]{"pn", false, 100, 100, false, false, "managing", false});
        puneSender.invoke(WANTestBase.class, "createReplicatedRegionWithAsyncEventQueue", new Object[]{testName + "_RR", "pn", false});
        managing.invoke(WANTestBase.class, "createReplicatedRegionWithAsyncEventQueue", new Object[]{testName + "_RR", "pn", false});
        nyReceiver.invoke(WANTestBase.class, "createReceiver", new Object[]{nyPort});
        nyReceiver.invoke(WANTestBase.class, "createPartitionedRegion", new Object[]{testName + "_PR", null, 1, 100, false});
        this.checkAsyncQueueMBean(puneSender);
        this.checkAsyncQueueMBean(managing);
        DistributedMember puneMember = (DistributedMember)puneSender.invoke(WANManagementDUnitTest.class, "getMember");
        this.checkProxyAsyncQueue(managing, puneMember);
    }

    protected void checkSenderNavigationAPIS(VM vm, final DistributedMember senderMember) {
        SerializableRunnable checkNavigationAPIS = new SerializableRunnable("Check Sender Navigation APIs"){

            @Override
            public void run() {
                GemFireCacheImpl cache = GemFireCacheImpl.getInstance();
                ManagementService service = ManagementService.getManagementService((Cache)cache);
                DistributedSystemMXBean bean = service.getDistributedSystemMXBean();
                ObjectName expectedName = service.getGatewaySenderMBeanName(senderMember, "pn");
                try {
                    ObjectName actualName = bean.fetchGatewaySenderObjectName(senderMember.getId(), "pn");
                    TestCase.assertEquals((Object)expectedName, (Object)actualName);
                }
                catch (Exception e) {
                    TestCase.fail((String)("Sender Navigation Failed " + e));
                }
                TestCase.assertEquals((int)2, (int)bean.listGatewaySenderObjectNames().length);
                try {
                    TestCase.assertEquals((int)1, (int)bean.listGatewaySenderObjectNames(senderMember.getId()).length);
                }
                catch (Exception e) {
                    TestCase.fail((String)("Sender Navigation Failed " + e));
                }
            }
        };
        vm.invoke(checkNavigationAPIS);
    }

    protected void checkReceiverNavigationAPIS(VM vm, final DistributedMember receiverMember) {
        SerializableRunnable checkNavigationAPIS = new SerializableRunnable("Check Receiver Navigation APIs"){

            @Override
            public void run() {
                GemFireCacheImpl cache = GemFireCacheImpl.getInstance();
                ManagementService service = ManagementService.getManagementService((Cache)cache);
                DistributedSystemMXBean bean = service.getDistributedSystemMXBean();
                ObjectName expectedName = service.getGatewayReceiverMBeanName(receiverMember);
                try {
                    ObjectName actualName = bean.fetchGatewayReceiverObjectName(receiverMember.getId());
                    TestCase.assertEquals((Object)expectedName, (Object)actualName);
                }
                catch (Exception e) {
                    TestCase.fail((String)("Receiver Navigation Failed " + e));
                }
                TestCase.assertEquals((int)1, (int)bean.listGatewayReceiverObjectNames().length);
            }
        };
        vm.invoke(checkNavigationAPIS);
    }

    private static int getLocatorPort() {
        return ((Locator)Locator.getLocators().get(0)).getPort();
    }

    private static DistributedMember getMember() {
        return GemFireCacheImpl.getInstance().getMyId();
    }

    protected void checkProxySender(VM vm, final DistributedMember senderMember) {
        SerializableRunnable checkProxySender = new SerializableRunnable("Check Proxy Sender"){

            @Override
            public void run() {
                GemFireCacheImpl cache = GemFireCacheImpl.getInstance();
                ManagementService service = ManagementService.getManagementService((Cache)cache);
                GatewaySenderMXBean bean = null;
                try {
                    bean = MBeanUtil.getGatewaySenderMbeanProxy(senderMember, "pn");
                }
                catch (Exception e) {
                    TestCase.fail((String)("Could not obtain Sender Proxy in desired time " + e));
                }
                TestCase.assertNotNull((Object)bean);
                ObjectName senderMBeanName = service.getGatewaySenderMBeanName(senderMember, "pn");
                try {
                    MBeanUtil.printBeanDetails(senderMBeanName);
                }
                catch (Exception e) {
                    TestCase.fail((String)("Error while Printing Bean Details " + e));
                }
                if (service.isManager()) {
                    DistributedSystemMXBean dsBean = service.getDistributedSystemMXBean();
                    Map dsMap = dsBean.viewRemoteClusterStatus();
                    DistributedTestCase.getLogWriter().info("<ExpectedString> Ds Map is: " + dsMap + "</ExpectedString> ");
                }
            }
        };
        vm.invoke(checkProxySender);
    }

    protected void checkProxyReceiver(VM vm, final DistributedMember senderMember) {
        SerializableRunnable checkProxySender = new SerializableRunnable("Check Proxy Receiver"){

            @Override
            public void run() {
                GemFireCacheImpl cache = GemFireCacheImpl.getInstance();
                ManagementService service = ManagementService.getManagementService((Cache)cache);
                GatewayReceiverMXBean bean = null;
                try {
                    bean = MBeanUtil.getGatewayReceiverMbeanProxy(senderMember);
                }
                catch (Exception e) {
                    TestCase.fail((String)("Could not obtain Sender Proxy in desired time " + e));
                }
                TestCase.assertNotNull((Object)bean);
                ObjectName receiverMBeanName = service.getGatewayReceiverMBeanName(senderMember);
                try {
                    MBeanUtil.printBeanDetails(receiverMBeanName);
                }
                catch (Exception e) {
                    TestCase.fail((String)("Error while Printing Bean Details " + e));
                }
            }
        };
        vm.invoke(checkProxySender);
    }

    protected void stopGatewaySender(VM vm) {
        SerializableRunnable stopGatewaySender = new SerializableRunnable("Stop Gateway Sender"){

            @Override
            public void run() {
                GemFireCacheImpl cache = GemFireCacheImpl.getInstance();
                ManagementService service = ManagementService.getManagementService((Cache)cache);
                GatewaySenderMXBean bean = service.getLocalGatewaySenderMXBean("pn");
                TestCase.assertNotNull((Object)bean);
                bean.stop();
                TestCase.assertFalse((boolean)bean.isRunning());
            }
        };
        vm.invoke(stopGatewaySender);
    }

    protected void startGatewaySender(VM vm) {
        SerializableRunnable stopGatewaySender = new SerializableRunnable("Start Gateway Sender"){

            @Override
            public void run() {
                GemFireCacheImpl cache = GemFireCacheImpl.getInstance();
                ManagementService service = ManagementService.getManagementService((Cache)cache);
                GatewaySenderMXBean bean = service.getLocalGatewaySenderMXBean("pn");
                TestCase.assertNotNull((Object)bean);
                bean.start();
                TestCase.assertTrue((boolean)bean.isRunning());
            }
        };
        vm.invoke(stopGatewaySender);
    }

    protected void checkReceiverMBean(VM vm) {
        SerializableRunnable checkMBean = new SerializableRunnable("Check Receiver MBean"){

            @Override
            public void run() {
                GemFireCacheImpl cache = GemFireCacheImpl.getInstance();
                ManagementService service = ManagementService.getManagementService((Cache)cache);
                GatewayReceiverMXBean bean = service.getLocalGatewayReceiverMXBean();
                TestCase.assertNotNull((Object)bean);
            }
        };
        vm.invoke(checkMBean);
    }

    protected void checkSenderMBean(VM vm, final String regionPath) {
        SerializableRunnable checkMBean = new SerializableRunnable("Check Sender MBean"){

            @Override
            public void run() {
                GemFireCacheImpl cache = GemFireCacheImpl.getInstance();
                ManagementService service = ManagementService.getManagementService((Cache)cache);
                GatewaySenderMXBean bean = service.getLocalGatewaySenderMXBean("pn");
                TestCase.assertNotNull((Object)bean);
                TestCase.assertTrue((boolean)bean.isConnected());
                ObjectName regionBeanName = service.getRegionMBeanName(cache.getDistributedSystem().getDistributedMember(), "/" + regionPath);
                RegionMXBean rBean = (RegionMXBean)service.getMBeanInstance(regionBeanName, RegionMXBean.class);
                TestCase.assertTrue((boolean)rBean.isGatewayEnabled());
            }
        };
        vm.invoke(checkMBean);
    }

    protected void checkAsyncQueueMBean(VM vm) {
        SerializableRunnable checkAsyncQueueMBean = new SerializableRunnable("Check Async Queue MBean"){

            @Override
            public void run() {
                GemFireCacheImpl cache = GemFireCacheImpl.getInstance();
                ManagementService service = ManagementService.getManagementService((Cache)cache);
                AsyncEventQueueMXBean bean = service.getLocalAsyncEventQueueMXBean("pn");
                TestCase.assertNotNull((Object)bean);
            }
        };
        vm.invoke(checkAsyncQueueMBean);
    }

    protected void checkProxyAsyncQueue(VM vm, final DistributedMember senderMember) {
        SerializableRunnable checkProxyAsyncQueue = new SerializableRunnable("Check Proxy Async Queue"){

            @Override
            public void run() {
                GemFireCacheImpl cache = GemFireCacheImpl.getInstance();
                ManagementService service = ManagementService.getManagementService((Cache)cache);
                AsyncEventQueueMXBean bean = null;
                try {
                    bean = MBeanUtil.getAsyncEventQueueMBeanProxy(senderMember, "pn");
                }
                catch (Exception e) {
                    TestCase.fail((String)("Could not obtain Sender Proxy in desired time " + e));
                }
                TestCase.assertNotNull((Object)bean);
                ObjectName queueMBeanName = service.getAsyncEventQueueMBeanName(senderMember, "pn");
                try {
                    MBeanUtil.printBeanDetails(queueMBeanName);
                }
                catch (Exception e) {
                    TestCase.fail((String)("Error while Printing Bean Details " + e));
                }
            }
        };
        vm.invoke(checkProxyAsyncQueue);
    }
}

