/*
 * Decompiled with CFR 0.152.
 */
package com.gemstone.gemfire.management.bean.stats;

import com.gemstone.gemfire.StatisticsFactory;
import com.gemstone.gemfire.distributed.DistributedMember;
import com.gemstone.gemfire.internal.cache.DiskStoreStats;
import com.gemstone.gemfire.internal.cache.GemFireCacheImpl;
import com.gemstone.gemfire.management.DistributedSystemMXBean;
import com.gemstone.gemfire.management.ManagementTestBase;
import com.gemstone.gemfire.management.MemberMXBean;
import com.gemstone.gemfire.management.internal.SystemManagementService;
import com.gemstone.gemfire.management.internal.beans.MemberMBean;
import com.gemstone.gemfire.management.internal.beans.MemberMBeanBridge;
import dunit.DistributedTestCase;
import dunit.SerializableRunnable;
import dunit.VM;
import java.util.Set;
import javax.management.ObjectName;
import junit.framework.TestCase;

public class DistributedSystemStatsDUnitTest
extends ManagementTestBase {
    private static final long serialVersionUID = 1L;

    public DistributedSystemStatsDUnitTest(String name) {
        super(name);
    }

    @Override
    public void setUp() throws Exception {
        super.setUp();
    }

    @Override
    public void tearDown2() throws Exception {
        super.tearDown2();
    }

    public void testDistributedSystemStats() throws Exception {
        this.initManagement(true);
        for (VM vm : managedNodeList) {
            this.setDiskStats(vm);
        }
        this.verifyDiskStats(managingNode);
    }

    public void setDiskStats(VM vm1) throws Exception {
        vm1.invoke(new SerializableRunnable("Set Member Stats"){

            @Override
            public void run() {
                MemberMBean bean = (MemberMBean)managementService.getMemberMXBean();
                MemberMBeanBridge bridge = bean.getBridge();
                DiskStoreStats diskStoreStats = new DiskStoreStats((StatisticsFactory)DistributedTestCase.system, "test");
                bridge.addDiskStoreStats(diskStoreStats);
                diskStoreStats.startRead();
                diskStoreStats.startWrite();
                diskStoreStats.startBackup();
                diskStoreStats.startRecovery();
                diskStoreStats.incWrittenBytes(20L, true);
                diskStoreStats.startFlush();
                diskStoreStats.setQueueSize(10);
            }
        });
    }

    public void verifyDiskStats(VM vm1) throws Exception {
        vm1.invoke(new SerializableRunnable("Set Member Stats"){

            @Override
            public void run() {
                GemFireCacheImpl cache = GemFireCacheImpl.getInstance();
                SystemManagementService service = (SystemManagementService)ManagementTestBase.getManagementService();
                DistributedSystemMXBean bean = service.getDistributedSystemMXBean();
                TestCase.assertNotNull((Object)bean);
                Set otherMemberSet = cache.getDistributionManager().getOtherNormalDistributionManagerIds();
                for (DistributedMember member : otherMemberSet) {
                    try {
                        ObjectName memberMBeanName = service.getMemberMBeanName(member);
                        DistributedSystemStatsDUnitTest.this.waitForProxy(memberMBeanName, MemberMXBean.class);
                        MemberMXBean memberBean = (MemberMXBean)service.getMBeanProxy(memberMBeanName, MemberMXBean.class);
                        DistributedSystemStatsDUnitTest.this.waitForRefresh(2, memberMBeanName);
                    }
                    catch (NullPointerException e) {
                        DistributedTestCase.fail("FAILED WITH EXCEPION", e);
                    }
                    catch (Exception e) {
                        DistributedTestCase.fail("FAILED WITH EXCEPION", e);
                    }
                }
            }
        });
    }
}

