/*
 * Decompiled with CFR 0.152.
 */
package com.gemstone.gemfire.management.internal.cli.commands;

import com.gemstone.gemfire.cache.Cache;
import com.gemstone.gemfire.cache30.CacheTestCase;
import com.gemstone.gemfire.internal.AvailablePortHelper;
import com.gemstone.gemfire.management.ManagementService;
import com.gemstone.gemfire.management.internal.cli.CommandManager;
import com.gemstone.gemfire.management.internal.cli.result.CommandResult;
import com.gemstone.gemfire.management.internal.cli.util.CommandStringBuilder;
import dunit.Host;
import dunit.SerializableCallable;
import dunit.SerializableRunnable;
import java.io.IOException;
import java.io.PrintStream;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.Map;
import java.util.Properties;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import management.cli.TestableGfsh;
import management.util.ManagementUtil;
import util.TestException;
import util.TestHelper;

public class CliCommandTestBase
extends CacheTestCase {
    private static final long serialVersionUID = 1L;
    protected static final String USE_HTTP_SYSTEM_PROPERTY = "useHTTP";
    private ManagementService managementService;
    private transient TestableGfsh shell;
    private boolean useHttpOnConnect = Boolean.getBoolean("useHTTP");
    private int httpPort;
    private int jmxPort;
    private String jmxHost;

    public CliCommandTestBase(String name) {
        super(name);
    }

    @Override
    public void setUp() throws Exception {
        super.setUp();
    }

    @Override
    public void tearDown2() throws Exception {
        this.destroyDefaultSetup();
        super.tearDown2();
    }

    protected final TestableGfsh createDefaultSetup(final Properties props) {
        Object[] result = (Object[])Host.getHost(0).getVM(0).invoke(new SerializableCallable(){

            public Object call() {
                Object[] result = new Object[3];
                Properties localProps = props != null ? props : new Properties();
                try {
                    CliCommandTestBase.this.jmxHost = InetAddress.getLocalHost().getHostName();
                }
                catch (UnknownHostException ignore) {
                    CliCommandTestBase.this.jmxHost = "localhost";
                }
                if (!localProps.containsKey("name")) {
                    localProps.setProperty("name", "Manager");
                }
                int[] ports = AvailablePortHelper.getRandomAvailableTCPPorts(2);
                CliCommandTestBase.this.jmxPort = ports[0];
                CliCommandTestBase.this.httpPort = ports[1];
                localProps.setProperty("jmx-manager", "true");
                localProps.setProperty("jmx-manager-start", "true");
                localProps.setProperty("jmx-manager-bind-address", String.valueOf(CliCommandTestBase.this.jmxHost));
                localProps.setProperty("jmx-manager-port", String.valueOf(CliCommandTestBase.this.jmxPort));
                if (Boolean.getBoolean(CliCommandTestBase.USE_HTTP_SYSTEM_PROPERTY)) {
                    localProps.setProperty("jmx-manager-http-port", String.valueOf(CliCommandTestBase.this.httpPort));
                }
                CliCommandTestBase.this.getSystem(localProps);
                CliCommandTestBase.this.verifyManagementServiceStarted(CliCommandTestBase.this.getCache());
                result[0] = CliCommandTestBase.this.jmxHost;
                result[1] = CliCommandTestBase.this.jmxPort;
                result[2] = CliCommandTestBase.this.httpPort;
                return result;
            }
        });
        this.jmxHost = (String)result[0];
        this.jmxPort = (Integer)result[1];
        this.httpPort = (Integer)result[2];
        return this.defaultShellConnect();
    }

    protected final void destroyDefaultSetup() {
        if (this.shell != null) {
            this.executeCommand(this.shell, "exit");
            this.shell.eof();
            this.shell = null;
        }
        CliCommandTestBase.disconnectAllFromDS();
        Host.getHost(0).getVM(0).invoke(new SerializableRunnable(){

            @Override
            public void run() {
                CliCommandTestBase.this.verifyManagementServiceStopped();
            }
        });
        if (Boolean.getBoolean(USE_HTTP_SYSTEM_PROPERTY)) {
            Host.getHost(0).getVM(0).bounce();
        }
    }

    private void verifyManagementServiceStarted(Cache cache) {
        assert (cache != null);
        this.managementService = ManagementService.getExistingManagementService((Cache)cache);
        CliCommandTestBase.assertNotNull((Object)this.managementService);
        CliCommandTestBase.assertTrue((boolean)this.managementService.isManager());
        CliCommandTestBase.assertTrue((boolean)ManagementUtil.checkIfCommandsAreLoadedOrNot());
    }

    private void verifyManagementServiceStopped() {
        if (this.managementService != null) {
            CliCommandTestBase.assertFalse((boolean)this.managementService.isManager());
            this.managementService = null;
        }
    }

    private TestableGfsh defaultShellConnect() {
        TestableGfsh shell = this.getDefaultShell();
        this.shellConnect(this.jmxHost, this.jmxPort, this.httpPort, shell);
        return shell;
    }

    protected void shellConnect(String host, int jmxPort, int httpPort, TestableGfsh shell) {
        String endpoint;
        assert (host != null);
        assert (shell != null);
        CommandStringBuilder command = new CommandStringBuilder("connect");
        if (this.useHttpOnConnect) {
            endpoint = "http://" + host + ":" + httpPort + "/gemfire/v1";
            command.addOption("use-http", Boolean.TRUE.toString());
            command.addOption("url", endpoint);
        } else {
            endpoint = host + "[" + jmxPort + "]";
            command.addOption("jmx-manager", endpoint);
        }
        CommandResult result = this.executeCommand(shell, command.toString());
        if (!shell.isConnectedAndReady()) {
            throw new TestException("Connect command failed to connect to manager " + endpoint + " result=" + this.commandResultToString(result));
        }
        this.info("Successfully connected to managing node using " + (this.useHttpOnConnect ? "HTTP" : "JMX"));
        CliCommandTestBase.assertEquals((boolean)true, (boolean)shell.isConnectedAndReady());
    }

    protected final synchronized TestableGfsh getDefaultShell() {
        if (this.shell == null) {
            this.shell = this.createShell();
        }
        return this.shell;
    }

    protected TestableGfsh createShell() {
        try {
            String shellId = this.getClass().getSimpleName() + "_" + this.getName();
            TestableGfsh shell = new TestableGfsh(shellId, true, new String[0]);
            shell.setTimeout(300L);
            shell.start();
            this.info("Started testable shell: " + shell);
            return shell;
        }
        catch (ClassNotFoundException e) {
            throw new TestException(TestHelper.getStackTrace(e));
        }
        catch (IOException e) {
            throw new TestException(TestHelper.getStackTrace(e));
        }
    }

    protected CommandResult executeCommand(String command) {
        assert (command != null);
        return this.executeCommand(this.getDefaultShell(), command);
    }

    protected CommandResult executeCommand(TestableGfsh shell, String command) {
        assert (shell != null);
        assert (command != null);
        CommandResult commandResult = this.executeCommandWithoutClear(shell, command);
        shell.clearEvents();
        return commandResult;
    }

    protected CommandResult executeCommandWithoutClear(String command) {
        assert (command != null);
        return this.executeCommandWithoutClear(this.getDefaultShell(), command);
    }

    protected CommandResult executeCommandWithoutClear(TestableGfsh shell, String command) {
        assert (shell != null);
        assert (command != null);
        try {
            this.info("Executing command " + command + " with command Mgr " + CommandManager.getInstance());
        }
        catch (ClassNotFoundException cnfex) {
            throw new TestException(TestHelper.getStackTrace(cnfex));
        }
        catch (IOException ioex) {
            throw new TestException(TestHelper.getStackTrace(ioex));
        }
        try {
            shell.addChars(command).addChars(";").newline();
        }
        catch (IOException ioex) {
            throw new TestException(TestHelper.getStackTrace(ioex));
        }
        shell.waitForOutput();
        return this.extractCommandResult(shell.getCommandOutput());
    }

    protected void printResult(CommandResult commandResult, PrintStream printStream) {
        assert (commandResult != null);
        assert (printStream != null);
        commandResult.resetToFirstLine();
        printStream.print(this.commandResultToString(commandResult));
    }

    protected String commandResultToString(CommandResult commandResult) {
        CliCommandTestBase.assertNotNull((Object)commandResult);
        commandResult.resetToFirstLine();
        StringBuilder buffer = new StringBuilder(commandResult.getHeader());
        while (commandResult.hasNextLine()) {
            buffer.append(commandResult.nextLine());
        }
        buffer.append(commandResult.getFooter());
        return buffer.toString();
    }

    protected CommandResult extractCommandResult(Map<String, Object> commandOutput) {
        assert (commandOutput != null);
        for (Object resultObject : commandOutput.values()) {
            if (!(resultObject instanceof CommandResult)) continue;
            CommandResult result = (CommandResult)resultObject;
            result.resetToFirstLine();
            return result;
        }
        return null;
    }

    protected int countMatchesInString(String stringToSearch, String stringToCount) {
        assert (stringToSearch != null);
        assert (stringToCount != null);
        int length = stringToSearch.length();
        int count = 0;
        for (int i = 0; i < length; ++i) {
            if (!stringToSearch.substring(i).startsWith(stringToCount)) continue;
            ++count;
        }
        return count;
    }

    protected boolean stringContainsLine(String stringToSearch, String stringPattern) {
        assert (stringToSearch != null);
        assert (stringPattern != null);
        Pattern pattern = Pattern.compile("^\\s*" + stringPattern + "\\s*$", 8);
        Matcher matcher = pattern.matcher(stringToSearch);
        return matcher.find();
    }

    protected int countLinesInString(String stringToSearch, boolean countBlankLines) {
        assert (stringToSearch != null);
        int length = stringToSearch.length();
        int count = 0;
        int character = 0;
        boolean foundNonSpaceChar = false;
        for (int i = 0; i < length; ++i) {
            character = stringToSearch.charAt(i);
            if (character == 10 || character == 13) {
                if (countBlankLines) {
                    ++count;
                } else if (foundNonSpaceChar) {
                    ++count;
                }
                foundNonSpaceChar = false;
                continue;
            }
            if (character == 32 || character == 9) continue;
            foundNonSpaceChar = true;
        }
        if (character != 10 && character != 13) {
            ++count;
        }
        return count;
    }

    protected String getLineFromString(String stringToSearch, int lineNumber) {
        assert (stringToSearch != null);
        assert (lineNumber > 0);
        int length = stringToSearch.length();
        int count = 0;
        int startIndex = 0;
        int endIndex = length;
        for (int i = 0; i < length; ++i) {
            char character = stringToSearch.charAt(i);
            if (character != '\n' && character != '\r') continue;
            if (lineNumber == 1) {
                endIndex = i;
                break;
            }
            if (++count == lineNumber - 1) {
                startIndex = i + 1;
                continue;
            }
            if (count < lineNumber) continue;
            endIndex = i;
            break;
        }
        return stringToSearch.substring(startIndex, endIndex);
    }

    protected void info(String string) {
        CliCommandTestBase.getLogWriter().info(string);
    }

    protected void debug(String string) {
        CliCommandTestBase.getLogWriter().fine(string);
    }

    protected void error(String string) {
        CliCommandTestBase.getLogWriter().error(string);
    }

    protected void error(String string, Throwable e) {
        CliCommandTestBase.getLogWriter().error(string, e);
    }
}

