/*
 * Decompiled with CFR 0.152.
 */
package com.gemstone.gemfire.management.internal.cli.commands;

import com.gemstone.gemfire.admin.AdminException;
import com.gemstone.gemfire.admin.jmx.AgentConfig;
import com.gemstone.gemfire.admin.jmx.AgentFactory;
import com.gemstone.gemfire.admin.jmx.internal.AgentConfigImpl;
import com.gemstone.gemfire.distributed.internal.DistributionManager;
import com.gemstone.gemfire.management.cli.Result;
import com.gemstone.gemfire.management.internal.cli.commands.CliCommandTestBase;
import com.gemstone.gemfire.management.internal.cli.commands.DeployCommands;
import com.gemstone.gemfire.management.internal.cli.remote.CommandExecutionContext;
import com.gemstone.gemfire.management.internal.cli.remote.CommandProcessor;
import com.gemstone.gemfire.management.internal.cli.result.CommandResult;
import dunit.DistributedTestCase;
import dunit.Host;
import dunit.SerializableRunnable;
import dunit.VM;
import java.io.File;
import java.io.FilenameFilter;
import java.io.IOException;
import java.util.Properties;
import java.util.regex.Pattern;
import util.ClassBuilder;

public class DeployCommandsDUnitTest
extends CliCommandTestBase {
    private static final long serialVersionUID = 1L;
    File newDeployableJarFile = new File("DeployCommandsDUnit1.jar");
    private transient ClassBuilder classBuilder = new ClassBuilder();
    private transient CommandProcessor commandProcessor;
    final Pattern pattern = Pattern.compile("^vf.gf#DeployCommandsDUnit.*#\\d++$");

    public DeployCommandsDUnitTest(String name) {
        super(name);
    }

    @Override
    public void setUp() throws Exception {
        super.setUp();
        this.commandProcessor = new CommandProcessor();
        DeployCommandsDUnitTest.assertFalse((boolean)this.commandProcessor.isStopped());
        Host.getHost(0).getVM(0).invoke(new SerializableRunnable(){

            @Override
            public void run() {
                DeployCommandsDUnitTest.this.deleteSavedJarFiles();
            }
        });
        this.deleteSavedJarFiles();
    }

    @Override
    public void tearDown2() throws Exception {
        Host.getHost(0).getVM(1).invoke(new SerializableRunnable(){

            @Override
            public void run() {
                DistributionManager.isDedicatedAdminVM = false;
            }
        });
        Host.getHost(0).getVM(0).invoke(new SerializableRunnable(){

            @Override
            public void run() {
                DeployCommandsDUnitTest.this.deleteSavedJarFiles();
            }
        });
        this.deleteSavedJarFiles();
        super.tearDown2();
    }

    public void testDeploy() throws IOException {
        final Properties props = new Properties();
        Host host = Host.getHost(0);
        VM vm = host.getVM(0);
        final String vmName = "VM" + vm.getPid();
        props.setProperty("name", "Controller");
        props.setProperty("groups", "Group1");
        this.getSystem(props);
        this.getCache();
        vm.invoke(new SerializableRunnable(){

            @Override
            public void run() {
                props.setProperty("name", vmName);
                props.setProperty("groups", "Group2");
                DeployCommandsDUnitTest.this.getSystem(props);
                DeployCommandsDUnitTest.this.getCache();
            }
        });
        DeployCommands deployCommands = new DeployCommands();
        CommandExecutionContext.setBytesFromShell((byte[][])new byte[][]{"DeployCommandsDUnit1.jar".getBytes(), this.classBuilder.createJarFromName("DeployCommandsDUnitA")});
        Result result = deployCommands.deploy(null, "DeployCommandsDUnit1.jar", null);
        DeployCommandsDUnitTest.assertEquals((boolean)true, (boolean)result.hasNextLine());
        String resultString = result.nextLine();
        DeployCommandsDUnitTest.assertEquals((boolean)false, (boolean)resultString.contains("ERROR"));
        DeployCommandsDUnitTest.assertEquals((int)1, (int)this.countMatchesInString(resultString, "Controller"));
        DeployCommandsDUnitTest.assertEquals((int)1, (int)this.countMatchesInString(resultString, vmName));
        DeployCommandsDUnitTest.assertEquals((int)4, (int)this.countMatchesInString(resultString, "DeployCommandsDUnit1.jar"));
        CommandExecutionContext.setBytesFromShell((byte[][])new byte[][]{"DeployCommandsDUnit2.jar".getBytes(), this.classBuilder.createJarFromName("DeployCommandsDUnitB")});
        result = deployCommands.deploy("Group2", "DeployCommandsDUnit2.jar", null);
        DeployCommandsDUnitTest.assertEquals((boolean)true, (boolean)result.hasNextLine());
        resultString = result.nextLine();
        DeployCommandsDUnitTest.assertEquals((boolean)false, (boolean)resultString.contains("ERROR"));
        DeployCommandsDUnitTest.assertEquals((boolean)false, (boolean)resultString.contains("Controller"));
        DeployCommandsDUnitTest.assertEquals((int)1, (int)this.countMatchesInString(resultString, vmName));
        DeployCommandsDUnitTest.assertEquals((int)2, (int)this.countMatchesInString(resultString, "DeployCommandsDUnit2.jar"));
        CommandExecutionContext.setBytesFromShell((byte[][])new byte[][]{"DeployCommandsDUnit3.jar".getBytes(), this.classBuilder.createJarFromName("DeployCommandsDUnitC"), "DeployCommandsDUnit4.jar".getBytes(), this.classBuilder.createJarFromName("DeployCommandsDUnitD")});
        result = deployCommands.deploy(null, null, "AnyDirectory");
        DeployCommandsDUnitTest.assertEquals((boolean)true, (boolean)result.hasNextLine());
        resultString = result.nextLine();
        DeployCommandsDUnitTest.assertEquals((boolean)false, (boolean)resultString.contains("ERROR"));
        DeployCommandsDUnitTest.assertEquals((int)2, (int)this.countMatchesInString(resultString, "Controller"));
        DeployCommandsDUnitTest.assertEquals((int)2, (int)this.countMatchesInString(resultString, vmName));
        DeployCommandsDUnitTest.assertEquals((int)4, (int)this.countMatchesInString(resultString, "DeployCommandsDUnit3.jar"));
        DeployCommandsDUnitTest.assertEquals((int)4, (int)this.countMatchesInString(resultString, "DeployCommandsDUnit4.jar"));
        CommandExecutionContext.setBytesFromShell((byte[][])new byte[][]{"DeployCommandsDUnit5.jar".getBytes(), this.classBuilder.createJarFromName("DeployCommandsDUnitE"), "DeployCommandsDUnit6.jar".getBytes(), this.classBuilder.createJarFromName("DeployCommandsDUnitF")});
        result = deployCommands.deploy("Group1", null, "AnyDirectory");
        DeployCommandsDUnitTest.assertEquals((boolean)true, (boolean)result.hasNextLine());
        resultString = result.nextLine();
        DeployCommandsDUnitTest.assertEquals((boolean)false, (boolean)resultString.contains("ERROR"));
        DeployCommandsDUnitTest.assertEquals((int)2, (int)this.countMatchesInString(resultString, "Controller"));
        DeployCommandsDUnitTest.assertEquals((boolean)false, (boolean)resultString.contains(vmName));
        DeployCommandsDUnitTest.assertEquals((int)2, (int)this.countMatchesInString(resultString, "DeployCommandsDUnit5.jar"));
        DeployCommandsDUnitTest.assertEquals((int)2, (int)this.countMatchesInString(resultString, "DeployCommandsDUnit6.jar"));
    }

    public void testUndeploy() throws IOException {
        final Properties props = new Properties();
        Host host = Host.getHost(0);
        VM vm = host.getVM(0);
        final String vmName = "VM" + vm.getPid();
        props.setProperty("name", "Controller");
        props.setProperty("groups", "Group1");
        this.getSystem(props);
        this.getCache();
        vm.invoke(new SerializableRunnable(){

            @Override
            public void run() {
                props.setProperty("name", vmName);
                props.setProperty("groups", "Group2");
                DeployCommandsDUnitTest.this.getSystem(props);
                DeployCommandsDUnitTest.this.getCache();
            }
        });
        DeployCommands deployCommands = new DeployCommands();
        CommandExecutionContext.setBytesFromShell((byte[][])new byte[][]{"DeployCommandsDUnit1.jar".getBytes(), this.classBuilder.createJarFromName("DeployCommandsDUnitA")});
        deployCommands.deploy("Group1", "DeployCommandsDUnit1.jar", null);
        CommandExecutionContext.setBytesFromShell((byte[][])new byte[][]{"DeployCommandsDUnit2.jar".getBytes(), this.classBuilder.createJarFromName("DeployCommandsDUnitB")});
        deployCommands.deploy("Group2", "DeployCommandsDUnit2.jar", null);
        CommandExecutionContext.setBytesFromShell((byte[][])new byte[][]{"DeployCommandsDUnit3.jar".getBytes(), this.classBuilder.createJarFromName("DeployCommandsDUnitC")});
        deployCommands.deploy(null, "DeployCommandsDUnit3.jar", null);
        CommandExecutionContext.setBytesFromShell((byte[][])new byte[][]{"DeployCommandsDUnit4.jar".getBytes(), this.classBuilder.createJarFromName("DeployCommandsDUnitD")});
        deployCommands.deploy(null, "DeployCommandsDUnit4.jar", null);
        CommandExecutionContext.setBytesFromShell((byte[][])new byte[][]{"DeployCommandsDUnit5.jar".getBytes(), this.classBuilder.createJarFromName("DeployCommandsDUnitE")});
        deployCommands.deploy(null, "DeployCommandsDUnit5.jar", null);
        Result result = deployCommands.undeploy("Group1", "DeployCommandsDUnit1.jar");
        DeployCommandsDUnitTest.assertEquals((boolean)true, (boolean)result.hasNextLine());
        String resultString = result.nextLine();
        DeployCommandsDUnitTest.assertEquals((boolean)false, (boolean)resultString.contains("ERROR"));
        DeployCommandsDUnitTest.assertEquals((int)1, (int)this.countMatchesInString(resultString, "Controller"));
        DeployCommandsDUnitTest.assertEquals((boolean)false, (boolean)resultString.contains(vmName));
        DeployCommandsDUnitTest.assertEquals((int)2, (int)this.countMatchesInString(resultString, "DeployCommandsDUnit1.jar"));
        result = deployCommands.undeploy(null, "DeployCommandsDUnit2.jar, DeployCommandsDUnit3.jar");
        DeployCommandsDUnitTest.assertEquals((boolean)true, (boolean)result.hasNextLine());
        resultString = result.nextLine();
        DeployCommandsDUnitTest.assertEquals((boolean)false, (boolean)resultString.contains("ERROR"));
        DeployCommandsDUnitTest.assertEquals((int)2, (int)this.countMatchesInString(resultString, "Controller"));
        DeployCommandsDUnitTest.assertEquals((int)2, (int)this.countMatchesInString(resultString, vmName));
        DeployCommandsDUnitTest.assertEquals((int)3, (int)this.countMatchesInString(resultString, "DeployCommandsDUnit2.jar"));
        DeployCommandsDUnitTest.assertEquals((int)4, (int)this.countMatchesInString(resultString, "DeployCommandsDUnit3.jar"));
        result = deployCommands.undeploy(null, null);
        DeployCommandsDUnitTest.assertEquals((boolean)true, (boolean)result.hasNextLine());
        resultString = result.nextLine();
        DeployCommandsDUnitTest.assertEquals((boolean)false, (boolean)resultString.contains("ERROR"));
        DeployCommandsDUnitTest.assertEquals((int)2, (int)this.countMatchesInString(resultString, "Controller"));
        DeployCommandsDUnitTest.assertEquals((int)2, (int)this.countMatchesInString(resultString, vmName));
        DeployCommandsDUnitTest.assertEquals((int)4, (int)this.countMatchesInString(resultString, "DeployCommandsDUnit4.jar"));
        DeployCommandsDUnitTest.assertEquals((int)4, (int)this.countMatchesInString(resultString, "DeployCommandsDUnit5.jar"));
    }

    public void testListDeployed() throws IOException {
        final Properties props = new Properties();
        Host host = Host.getHost(0);
        VM vm = host.getVM(0);
        final String vmName = "VM" + vm.getPid();
        props.setProperty("name", "Controller");
        props.setProperty("groups", "Group1");
        this.getSystem(props);
        this.getCache();
        vm.invoke(new SerializableRunnable(){

            @Override
            public void run() {
                props.setProperty("name", vmName);
                props.setProperty("groups", "Group2");
                DeployCommandsDUnitTest.this.getSystem(props);
                DeployCommandsDUnitTest.this.getCache();
            }
        });
        DeployCommands deployCommands = new DeployCommands();
        CommandExecutionContext.setBytesFromShell((byte[][])new byte[][]{"DeployCommandsDUnit1.jar".getBytes(), this.classBuilder.createJarFromName("DeployCommandsDUnitA")});
        deployCommands.deploy("Group1", "DeployCommandsDUnit1.jar", null);
        CommandExecutionContext.setBytesFromShell((byte[][])new byte[][]{"DeployCommandsDUnit2.jar".getBytes(), this.classBuilder.createJarFromName("DeployCommandsDUnitB")});
        deployCommands.deploy("Group2", "DeployCommandsDUnit2.jar", null);
        Result result = deployCommands.listDeployed(null);
        DeployCommandsDUnitTest.assertEquals((boolean)true, (boolean)result.hasNextLine());
        String resultString = result.nextLine();
        DeployCommandsDUnitTest.assertEquals((boolean)false, (boolean)resultString.contains("ERROR"));
        DeployCommandsDUnitTest.assertEquals((int)1, (int)this.countMatchesInString(resultString, "Controller"));
        DeployCommandsDUnitTest.assertEquals((int)1, (int)this.countMatchesInString(resultString, vmName));
        DeployCommandsDUnitTest.assertEquals((int)2, (int)this.countMatchesInString(resultString, "DeployCommandsDUnit1.jar"));
        DeployCommandsDUnitTest.assertEquals((int)2, (int)this.countMatchesInString(resultString, "DeployCommandsDUnit2.jar"));
        result = deployCommands.listDeployed("Group1");
        DeployCommandsDUnitTest.assertEquals((boolean)true, (boolean)result.hasNextLine());
        resultString = result.nextLine();
        DeployCommandsDUnitTest.assertEquals((boolean)false, (boolean)resultString.contains("ERROR"));
        DeployCommandsDUnitTest.assertEquals((int)1, (int)this.countMatchesInString(resultString, "Controller"));
        DeployCommandsDUnitTest.assertEquals((boolean)false, (boolean)resultString.contains(vmName));
        DeployCommandsDUnitTest.assertEquals((int)2, (int)this.countMatchesInString(resultString, "DeployCommandsDUnit1.jar"));
        DeployCommandsDUnitTest.assertEquals((boolean)false, (boolean)resultString.contains("DeployCommandsDUnit2.jar"));
        result = deployCommands.listDeployed("Group2");
        DeployCommandsDUnitTest.assertEquals((boolean)true, (boolean)result.hasNextLine());
        resultString = result.nextLine();
        DeployCommandsDUnitTest.assertEquals((boolean)false, (boolean)resultString.contains("ERROR"));
        DeployCommandsDUnitTest.assertEquals((boolean)false, (boolean)resultString.contains("Controller"));
        DeployCommandsDUnitTest.assertEquals((int)1, (int)this.countMatchesInString(resultString, vmName));
        DeployCommandsDUnitTest.assertEquals((boolean)false, (boolean)resultString.contains("DeployCommandsDUnit1.jar"));
        DeployCommandsDUnitTest.assertEquals((int)2, (int)this.countMatchesInString(resultString, "DeployCommandsDUnit2.jar"));
    }

    public void testEndToEnd() throws IOException {
        Properties localProps = new Properties();
        localProps.setProperty("groups", "Group1");
        this.createDefaultSetup(localProps);
        Host.getHost(0).getVM(1).invoke(new SerializableRunnable(){

            @Override
            public void run() {
                DistributionManager.isDedicatedAdminVM = true;
                Properties localProps = new Properties();
                DeployCommandsDUnitTest.this.getSystem(localProps);
                AgentConfigImpl config = new AgentConfigImpl(localProps);
                try {
                    AgentFactory.getAgent((AgentConfig)config);
                }
                catch (AdminException aex) {
                    DistributedTestCase.fail("Admin exception while attempting to create admin member", aex);
                }
            }
        });
        this.classBuilder.writeJarFromName("DeployCommandsDUnitA", this.newDeployableJarFile);
        CommandResult cmdResult = this.executeCommand("deploy --jar=DeployCommandsDUnit1.jar");
        DeployCommandsDUnitTest.assertEquals((Object)Result.Status.OK, (Object)cmdResult.getStatus());
        String stringResult = this.commandResultToString(cmdResult);
        DeployCommandsDUnitTest.assertEquals((int)3, (int)this.countLinesInString(stringResult, false));
        DeployCommandsDUnitTest.assertTrue((boolean)this.stringContainsLine(stringResult, "Member.*JAR.*JAR Location"));
        DeployCommandsDUnitTest.assertTrue((boolean)this.stringContainsLine(stringResult, "Manager.*DeployCommandsDUnit1.jar.*vf.gf#DeployCommandsDUnit1.jar#1"));
        cmdResult = this.executeCommand("undeploy --jar=DeployCommandsDUnit1.jar");
        DeployCommandsDUnitTest.assertEquals((Object)Result.Status.OK, (Object)cmdResult.getStatus());
        stringResult = this.commandResultToString(cmdResult);
        DeployCommandsDUnitTest.assertEquals((int)3, (int)this.countLinesInString(stringResult, false));
        DeployCommandsDUnitTest.assertTrue((boolean)this.stringContainsLine(stringResult, "Member.*JAR.*Un-Deployed From JAR Location"));
        DeployCommandsDUnitTest.assertTrue((boolean)this.stringContainsLine(stringResult, "Manager.*DeployCommandsDUnit1.jar.*vf.gf#DeployCommandsDUnit1.jar#1"));
        cmdResult = this.executeCommand("deploy --jar=DeployCommandsDUnit1.jar --group=Group1");
        DeployCommandsDUnitTest.assertEquals((Object)Result.Status.OK, (Object)cmdResult.getStatus());
        stringResult = this.commandResultToString(cmdResult);
        DeployCommandsDUnitTest.assertEquals((int)3, (int)this.countLinesInString(stringResult, false));
        DeployCommandsDUnitTest.assertTrue((boolean)this.stringContainsLine(stringResult, "Member.*JAR.*JAR Location"));
        DeployCommandsDUnitTest.assertTrue((boolean)this.stringContainsLine(stringResult, "Manager.*DeployCommandsDUnit1.jar.*vf.gf#DeployCommandsDUnit1.jar#1"));
        cmdResult = this.executeCommand("list deployed --group=Group1");
        DeployCommandsDUnitTest.assertEquals((Object)Result.Status.OK, (Object)cmdResult.getStatus());
        stringResult = this.commandResultToString(cmdResult);
        DeployCommandsDUnitTest.assertEquals((int)3, (int)this.countLinesInString(stringResult, false));
        DeployCommandsDUnitTest.assertTrue((boolean)this.stringContainsLine(stringResult, "Member.*JAR.*JAR Location"));
        DeployCommandsDUnitTest.assertTrue((boolean)this.stringContainsLine(stringResult, "Manager.*DeployCommandsDUnit1.jar.*vf.gf#DeployCommandsDUnit1.jar#1"));
        cmdResult = this.executeCommand("undeploy --group=Group1");
        DeployCommandsDUnitTest.assertEquals((Object)Result.Status.OK, (Object)cmdResult.getStatus());
        stringResult = this.commandResultToString(cmdResult);
        DeployCommandsDUnitTest.assertEquals((int)3, (int)this.countLinesInString(stringResult, false));
        DeployCommandsDUnitTest.assertTrue((boolean)this.stringContainsLine(stringResult, "Member.*JAR.*Un-Deployed From JAR Location"));
        DeployCommandsDUnitTest.assertTrue((boolean)this.stringContainsLine(stringResult, "Manager.*DeployCommandsDUnit1.jar.*vf.gf#DeployCommandsDUnit1.jar#1"));
        cmdResult = this.executeCommand("list deployed");
        DeployCommandsDUnitTest.assertEquals((Object)Result.Status.OK, (Object)cmdResult.getStatus());
        DeployCommandsDUnitTest.assertTrue((boolean)this.commandResultToString(cmdResult).contains("No JAR Files Found"));
    }

    void deleteSavedJarFiles() {
        this.newDeployableJarFile.delete();
        File dirFile = new File(".");
        File[] oldJarFiles = dirFile.listFiles(new FilenameFilter(){

            @Override
            public boolean accept(File file, String name) {
                return DeployCommandsDUnitTest.this.pattern.matcher(name).matches();
            }
        });
        if (oldJarFiles != null) {
            for (File oldJarFile : oldJarFiles) {
                oldJarFile.delete();
            }
        }
    }
}

