/*
 * Decompiled with CFR 0.152.
 */
package com.gemstone.gemfire.management.internal.cli.commands;

import com.gemstone.gemfire.cache.AttributesFactory;
import com.gemstone.gemfire.cache.CacheException;
import com.gemstone.gemfire.cache.DataPolicy;
import com.gemstone.gemfire.cache.PartitionAttributesFactory;
import com.gemstone.gemfire.cache.Region;
import com.gemstone.gemfire.cache.Scope;
import com.gemstone.gemfire.cache.client.ClientCache;
import com.gemstone.gemfire.cache.client.ClientCacheFactory;
import com.gemstone.gemfire.cache.query.CqAttributesFactory;
import com.gemstone.gemfire.cache.query.CqException;
import com.gemstone.gemfire.cache.query.CqExistsException;
import com.gemstone.gemfire.cache.query.QueryService;
import com.gemstone.gemfire.cache.query.RegionNotFoundException;
import com.gemstone.gemfire.cache.query.data.Portfolio;
import com.gemstone.gemfire.cache.server.CacheServer;
import com.gemstone.gemfire.cache30.CacheSerializableRunnable;
import com.gemstone.gemfire.internal.AvailablePortHelper;
import com.gemstone.gemfire.internal.cache.DistributedRegion;
import com.gemstone.gemfire.internal.cache.GemFireCacheImpl;
import com.gemstone.gemfire.internal.cache.PartitionedRegion;
import com.gemstone.gemfire.internal.cache.tier.sockets.CacheServerTestUtil;
import com.gemstone.gemfire.management.cli.Result;
import com.gemstone.gemfire.management.internal.cli.commands.CliCommandTestBase;
import com.gemstone.gemfire.management.internal.cli.i18n.CliStrings;
import com.gemstone.gemfire.management.internal.cli.result.CommandResult;
import com.gemstone.gemfire.management.internal.cli.util.CommandStringBuilder;
import dunit.DistributedTestCase;
import dunit.Host;
import dunit.SerializableCallable;
import dunit.VM;
import java.util.Properties;
import junit.framework.TestCase;

public class DurableClientCommandsDUnitTest
extends CliCommandTestBase {
    private static final long serialVersionUID = 1L;
    final String regionName = "stocks";
    final String cq1 = "cq1";
    final String cq2 = "cq2";
    final String cq3 = "cq3";
    final String clientName = "dc1";

    public DurableClientCommandsDUnitTest(String name) {
        super(name);
    }

    public void testListDurableClientCqs() throws Exception {
        this.setupSystem();
        this.setupCqs();
        CommandStringBuilder csb = new CommandStringBuilder("list durable-cqs");
        csb.addOption("durable-client-id", "dc1");
        String commandString = csb.toString();
        this.writeToLog("Command String :\n ", commandString);
        CommandResult commandResult = this.executeCommand(commandString);
        String resultAsString = this.commandResultToString(commandResult);
        this.writeToLog("Command Result :\n", resultAsString);
        DurableClientCommandsDUnitTest.assertTrue((boolean)Result.Status.OK.equals((Object)commandResult.getStatus()));
        DurableClientCommandsDUnitTest.assertTrue((boolean)resultAsString.contains("cq1"));
        DurableClientCommandsDUnitTest.assertTrue((boolean)resultAsString.contains("cq2"));
        DurableClientCommandsDUnitTest.assertTrue((boolean)resultAsString.contains("cq3"));
        this.closeCq("cq1");
        this.closeCq("cq2");
        this.closeCq("cq3");
        csb = new CommandStringBuilder("list durable-cqs");
        csb.addOption("durable-client-id", "dc1");
        commandString = csb.toString();
        this.writeToLog("Command String :\n ", commandString);
        commandResult = this.executeCommand(commandString);
        resultAsString = this.commandResultToString(commandResult);
        this.writeToLog("Command Result :\n", resultAsString);
        DurableClientCommandsDUnitTest.assertTrue((boolean)Result.Status.ERROR.equals((Object)commandResult.getStatus()));
        String errorMessage = CliStrings.format((String)"No durable cqs found for durable-client-id : \"{0}\".", (Object)"dc1");
        DurableClientCommandsDUnitTest.assertTrue((boolean)resultAsString.contains(errorMessage));
    }

    public void testCloseDurableClients() throws Exception {
        this.setupSystem();
        this.setupCqs();
        this.closeDurableClient();
        CommandStringBuilder csb = new CommandStringBuilder("close durable-client");
        csb.addOption("durable-client-id", "dc1");
        String commandString = csb.toString();
        this.writeToLog("Command String : ", commandString);
        CommandResult commandResult = this.executeCommand(commandString);
        String resultAsString = this.commandResultToString(commandResult);
        this.writeToLog("Command Result :\n", resultAsString);
        DurableClientCommandsDUnitTest.assertTrue((boolean)Result.Status.OK.equals((Object)commandResult.getStatus()));
        this.writeToLog("Command String : ", commandString);
        commandResult = this.executeCommand(commandString);
        resultAsString = this.commandResultToString(commandResult);
        this.writeToLog("Command Result :\n", resultAsString);
        DurableClientCommandsDUnitTest.assertTrue((boolean)Result.Status.ERROR.equals((Object)commandResult.getStatus()));
        String errorMessage = CliStrings.format((String)"No client found with client-id : {0}", (Object)"dc1");
        DurableClientCommandsDUnitTest.assertTrue((boolean)resultAsString.contains(errorMessage));
    }

    public void testCloseDurableCQ() throws Exception {
        this.setupSystem();
        this.setupCqs();
        this.closeDurableClient();
        CommandStringBuilder csb = new CommandStringBuilder("close durable-cq");
        csb.addOption("durable-client-id", "dc1");
        csb.addOption("durable-cq-name", "cq1");
        String commandString = csb.toString();
        this.writeToLog("Command String : ", commandString);
        CommandResult commandResult = this.executeCommand(commandString);
        String resultAsString = this.commandResultToString(commandResult);
        this.writeToLog("Command Result :\n", resultAsString);
        DurableClientCommandsDUnitTest.assertTrue((boolean)Result.Status.OK.equals((Object)commandResult.getStatus()));
        csb = new CommandStringBuilder("close durable-cq");
        csb.addOption("durable-client-id", "dc1");
        csb.addOption("durable-cq-name", "cq1");
        commandString = csb.toString();
        this.writeToLog("Command String : ", commandString);
        commandResult = this.executeCommand(commandString);
        resultAsString = this.commandResultToString(commandResult);
        this.writeToLog("Command Result : ", resultAsString);
        DurableClientCommandsDUnitTest.assertTrue((boolean)Result.Status.ERROR.equals((Object)commandResult.getStatus()));
    }

    public void testCountSubscriptionQueueSize() throws Exception {
        this.setupSystem();
        this.setupCqs();
        this.doPuts("stocks", Host.getHost(0).getVM(1));
        CommandStringBuilder csb = new CommandStringBuilder("show subscription-queue-size");
        csb.addOption("durable-client-Id", "dc1");
        String commandString = csb.toString();
        this.writeToLog("Command String : ", commandString);
        CommandResult commandResult = this.executeCommand(commandString);
        String resultAsString = this.commandResultToString(commandResult);
        this.writeToLog("Command Result :\n", resultAsString);
        DurableClientCommandsDUnitTest.assertTrue((boolean)Result.Status.OK.equals((Object)commandResult.getStatus()));
        DurableClientCommandsDUnitTest.assertTrue((boolean)resultAsString.contains("4"));
        csb = new CommandStringBuilder("show subscription-queue-size");
        csb.addOption("durable-client-Id", "dc1");
        csb.addOption("durable-cq-name", "cq3");
        commandString = csb.toString();
        this.writeToLog("Command String : ", commandString);
        commandResult = this.executeCommand(commandString);
        resultAsString = this.commandResultToString(commandResult);
        this.writeToLog("Command Result :\n", resultAsString);
        DurableClientCommandsDUnitTest.assertTrue((boolean)Result.Status.OK.equals((Object)commandResult.getStatus()));
        this.closeCq("cq1");
        this.closeCq("cq2");
        this.closeCq("cq3");
        csb = new CommandStringBuilder("show subscription-queue-size");
        csb.addOption("durable-client-Id", "dc1");
        csb.addOption("durable-cq-name", "cq1");
        commandString = csb.toString();
        this.writeToLog("Command String : ", commandString);
        commandResult = this.executeCommand(commandString);
        resultAsString = this.commandResultToString(commandResult);
        this.writeToLog("Command Result :\n", resultAsString);
        DurableClientCommandsDUnitTest.assertTrue((boolean)Result.Status.ERROR.equals((Object)commandResult.getStatus()));
        String errorMessage = CliStrings.format((String)"No cq found on server for client with durable-client-id : {0} with cq-name : {1}.", (Object[])new Object[]{"dc1", "cq1"});
        DurableClientCommandsDUnitTest.assertTrue((boolean)resultAsString.contains(errorMessage));
        csb = new CommandStringBuilder("show subscription-queue-size");
        csb.addOption("durable-client-Id", "dc1");
        commandString = csb.toString();
        this.writeToLog("Command String : ", commandString);
        commandResult = this.executeCommand(commandString);
        resultAsString = this.commandResultToString(commandResult);
        this.writeToLog("Command Result :\n", resultAsString);
        DurableClientCommandsDUnitTest.assertTrue((boolean)Result.Status.OK.equals((Object)commandResult.getStatus()));
        this.closeDurableClient();
        csb = new CommandStringBuilder("close durable-client");
        csb.addOption("durable-client-id", "dc1");
        commandString = csb.toString();
        this.writeToLog("Command String : ", commandString);
        commandResult = this.executeCommand(commandString);
        resultAsString = this.commandResultToString(commandResult);
        this.writeToLog("Command Result :\n", resultAsString);
        DurableClientCommandsDUnitTest.assertTrue((boolean)Result.Status.OK.equals((Object)commandResult.getStatus()));
        csb = new CommandStringBuilder("show subscription-queue-size");
        csb.addOption("durable-client-Id", "dc1");
        commandString = csb.toString();
        this.writeToLog("Command String : ", commandString);
        commandResult = this.executeCommand(commandString);
        resultAsString = this.commandResultToString(commandResult);
        this.writeToLog("Command Result :\n", resultAsString);
        DurableClientCommandsDUnitTest.assertTrue((boolean)Result.Status.ERROR.equals((Object)commandResult.getStatus()));
        DurableClientCommandsDUnitTest.assertTrue((boolean)resultAsString.contains(CliStrings.format((String)"No client found with client-id : {0}", (Object)"dc1")));
    }

    private void writeToLog(String text, String resultAsString) {
        DurableClientCommandsDUnitTest.getLogWriter().info(testName + "\n");
        DurableClientCommandsDUnitTest.getLogWriter().info(resultAsString);
    }

    private void setupSystem() throws Exception {
        DurableClientCommandsDUnitTest.disconnectAllFromDS();
        int[] port = AvailablePortHelper.getRandomAvailableTCPPorts(2);
        int mcastPort = AvailablePortHelper.getRandomAvailableUDPPort();
        this.createDefaultSetup(this.getServerProperties(mcastPort));
        VM manager = Host.getHost(0).getVM(0);
        VM server1 = Host.getHost(0).getVM(1);
        VM client1 = Host.getHost(0).getVM(2);
        this.startCacheServer(server1, port[0], mcastPort, false, "stocks");
        this.startDurableClient(client1, server1, port[0], "dc1", "300");
    }

    private void closeCq(final String cqName) {
        VM vm2 = Host.getHost(0).getVM(2);
        vm2.invoke(new SerializableCallable(){

            public Object call() {
                QueryService qs = DurableClientCommandsDUnitTest.this.getCache().getQueryService();
                CqAttributesFactory cqAf = new CqAttributesFactory();
                try {
                    qs.getCq(cqName).close();
                }
                catch (CqException e) {
                    e.printStackTrace();
                    return false;
                }
                return true;
            }
        });
    }

    private void setupCqs() {
        VM vm2 = Host.getHost(0).getVM(2);
        vm2.invoke(new SerializableCallable(){

            public Object call() {
                QueryService qs = DurableClientCommandsDUnitTest.this.getCache().getQueryService();
                CqAttributesFactory cqAf = new CqAttributesFactory();
                try {
                    qs.newCq("cq1", "select * from /stocks", cqAf.create(), true).execute();
                    qs.newCq("cq2", "select * from /stocks where id = 1", cqAf.create(), true).execute();
                    qs.newCq("cq3", "select * from /stocks where id > 2", cqAf.create(), true).execute();
                }
                catch (CqException e) {
                    e.printStackTrace();
                    return false;
                }
                catch (CqExistsException e) {
                    e.printStackTrace();
                    return false;
                }
                catch (RegionNotFoundException e) {
                    e.printStackTrace();
                    return false;
                }
                return true;
            }
        });
    }

    private void startCacheServer(VM server, final int port, final int mcastPort, final boolean createPR, final String regionName) throws Exception {
        server.invoke(new SerializableCallable(){

            public Object call() throws Exception {
                DurableClientCommandsDUnitTest.this.getSystem(DurableClientCommandsDUnitTest.this.getServerProperties(mcastPort));
                GemFireCacheImpl cache = (GemFireCacheImpl)DurableClientCommandsDUnitTest.this.getCache();
                AttributesFactory factory = new AttributesFactory();
                if (createPR) {
                    PartitionAttributesFactory paf = new PartitionAttributesFactory();
                    paf.setRedundantCopies(1);
                    paf.setTotalNumBuckets(11);
                    factory.setPartitionAttributes(paf.create());
                } else {
                    factory.setScope(Scope.DISTRIBUTED_ACK);
                    factory.setDataPolicy(DataPolicy.REPLICATE);
                }
                Region region = DurableClientCommandsDUnitTest.this.createRootRegion(regionName, factory.create());
                if (createPR) {
                    TestCase.assertTrue((boolean)(region instanceof PartitionedRegion));
                } else {
                    TestCase.assertTrue((boolean)(region instanceof DistributedRegion));
                }
                CacheServer cacheServer = DurableClientCommandsDUnitTest.this.getCache().addCacheServer();
                cacheServer.setPort(port);
                cacheServer.start();
                return null;
            }
        });
    }

    private void startDurableClient(VM client, final VM server, final int port, final String durableClientId, final String durableClientTimeout) {
        client.invoke(new CacheSerializableRunnable("Start client"){

            @Override
            public void run2() throws CacheException {
                Properties props = DurableClientCommandsDUnitTest.this.getClientProps(durableClientId, durableClientTimeout);
                DurableClientCommandsDUnitTest.this.getSystem(props);
                ClientCacheFactory ccf = new ClientCacheFactory(props);
                ccf.addPoolServer(DistributedTestCase.getServerHostName(server.getHost()), port);
                ccf.setPoolSubscriptionEnabled(true);
                ClientCache cache = DurableClientCommandsDUnitTest.this.getClientCache(ccf);
            }
        });
    }

    private void doPuts(final String regionName, VM server) {
        server.invoke(new SerializableCallable(){

            public Object call() throws Exception {
                GemFireCacheImpl cache = (GemFireCacheImpl)DurableClientCommandsDUnitTest.this.getCache();
                Region region = cache.getRegion(regionName);
                Portfolio p1 = new Portfolio();
                p1.ID = 1;
                p1.names = new String[]{"AAPL", "VMW"};
                Portfolio p2 = new Portfolio();
                p2.ID = 2;
                p2.names = new String[]{"EMC", "IBM"};
                Portfolio p3 = new Portfolio();
                p3.ID = 5;
                p3.names = new String[]{"DOW", "TON"};
                Portfolio p4 = new Portfolio();
                p4.ID = 5;
                p4.names = new String[]{"ABC", "EBAY"};
                region.put((Object)"p1", (Object)p1);
                region.put((Object)"p2", (Object)p2);
                region.put((Object)"p3", (Object)p3);
                region.put((Object)"p4", (Object)p4);
                return null;
            }
        });
    }

    private void closeDurableClient() {
        VM client = Host.getHost(0).getVM(2);
        client.invoke(new CacheSerializableRunnable("Stop client"){

            @Override
            public void run2() throws CacheException {
                ClientCacheFactory.getAnyInstance().close(true);
            }
        });
    }

    protected Properties getClientProps(String durableClientId, String durableClientTimeout) {
        Properties p = new Properties();
        p.setProperty("mcast-port", "0");
        p.setProperty("locators", "");
        p.setProperty("durable-client-id", durableClientId);
        p.setProperty("durable-client-timeout", String.valueOf(durableClientTimeout));
        return p;
    }

    protected Properties getServerProperties(int mcastPort) {
        Properties p = new Properties();
        p.setProperty("mcast-port", mcastPort + "");
        p.setProperty("locators", "");
        return p;
    }

    @Override
    public void tearDown2() throws Exception {
        Host.getHost(0).getVM(0).invoke(CacheServerTestUtil.class, "closeCache");
        Host.getHost(0).getVM(1).invoke(CacheServerTestUtil.class, "closeCache");
        Host.getHost(0).getVM(2).invoke(CacheServerTestUtil.class, "closeCache");
    }
}

