/*
 * Decompiled with CFR 0.152.
 */
package com.gemstone.gemfire.management.internal.cli.commands;

import com.gemstone.gemfire.cache.Cache;
import com.gemstone.gemfire.cache.DataPolicy;
import com.gemstone.gemfire.cache.DiskStore;
import com.gemstone.gemfire.cache.DiskStoreFactory;
import com.gemstone.gemfire.cache.RegionFactory;
import com.gemstone.gemfire.cache.Scope;
import com.gemstone.gemfire.cache30.CacheTestCase;
import com.gemstone.gemfire.management.cli.Result;
import com.gemstone.gemfire.management.internal.cli.commands.CliCommandTestBase;
import com.gemstone.gemfire.management.internal.cli.i18n.CliStrings;
import com.gemstone.gemfire.management.internal.cli.result.CommandResult;
import dunit.Host;
import dunit.SerializableRunnable;
import dunit.VM;
import java.io.Serializable;
import java.util.Properties;

public class ListAndDescribeDiskStoreCommandsDUnitTest
extends CliCommandTestBase {
    protected static String toString(Result result) {
        assert (result != null) : "The Result object from the command execution cannot be null!";
        StringBuilder buffer = new StringBuilder(System.getProperty("line.separator"));
        while (result.hasNextLine()) {
            buffer.append(result.nextLine());
            buffer.append(System.getProperty("line.separator"));
        }
        return buffer.toString().trim();
    }

    public ListAndDescribeDiskStoreCommandsDUnitTest(String testName) {
        super(testName);
    }

    @Override
    public void setUp() throws Exception {
        super.setUp();
        this.createDefaultSetup(null);
        this.setupGemFire();
    }

    @Override
    public void tearDown2() throws Exception {
        super.tearDown2();
    }

    protected Peer createPeer(Properties distributedSystemConfiguration, VM vm) {
        return new Peer(distributedSystemConfiguration, vm);
    }

    protected void setupGemFire() throws Exception {
        Host host = Host.getHost(0);
        VM vm1 = host.getVM(1);
        VM vm2 = host.getVM(2);
        Peer peer1 = this.createPeer(this.createDistributedSystemProperties("consumerServer"), vm1);
        Peer peer2 = this.createPeer(this.createDistributedSystemProperties("producerServer"), vm2);
        this.createPersistentRegion(peer1, "consumers", "consumerData");
        this.createPersistentRegion(peer1, "observers", "observerData");
        this.createPersistentRegion(peer2, "producer", "producerData");
        this.createPersistentRegion(peer2, "producer-factory", "producerData");
    }

    protected Properties createDistributedSystemProperties(String gemfireName) {
        Properties distributedSystemProperties = new Properties();
        distributedSystemProperties.setProperty("log-level", ListAndDescribeDiskStoreCommandsDUnitTest.getDUnitLogLevel());
        distributedSystemProperties.setProperty("name", gemfireName);
        return distributedSystemProperties;
    }

    protected void createPersistentRegion(final Peer peer, final String regionName, final String diskStoreName) {
        peer.run(new SerializableRunnable("Creating Persistent Region for Member " + peer.getName()){

            @Override
            public void run() {
                ListAndDescribeDiskStoreCommandsDUnitTest.this.getSystem(peer.getDistributedSystemConfiguration());
                Cache cache = ListAndDescribeDiskStoreCommandsDUnitTest.this.getCache();
                DiskStore diskStore = cache.findDiskStore(diskStoreName);
                if (diskStore == null) {
                    DiskStoreFactory diskStoreFactory = cache.createDiskStoreFactory();
                    diskStoreFactory.setDiskDirs(CacheTestCase.getDiskDirs());
                    diskStore = diskStoreFactory.create(diskStoreName);
                }
                RegionFactory regionFactory = cache.createRegionFactory();
                regionFactory.setDataPolicy(DataPolicy.PERSISTENT_REPLICATE);
                regionFactory.setDiskStoreName(diskStore.getName());
                regionFactory.setScope(Scope.DISTRIBUTED_NO_ACK);
                regionFactory.create(regionName);
            }
        });
    }

    public void testListDiskStore() throws Exception {
        CommandResult result = this.executeCommand("list disk-stores");
        ListAndDescribeDiskStoreCommandsDUnitTest.assertNotNull((Object)result);
        ListAndDescribeDiskStoreCommandsDUnitTest.getLogWriter().info(ListAndDescribeDiskStoreCommandsDUnitTest.toString((Result)result));
        ListAndDescribeDiskStoreCommandsDUnitTest.assertEquals((Object)Result.Status.OK, (Object)result.getStatus());
    }

    public void testDescribeDiskStore() throws Exception {
        CommandResult result = this.executeCommand("describe disk-store --member=producerServer --name=producerData");
        ListAndDescribeDiskStoreCommandsDUnitTest.assertNotNull((Object)result);
        ListAndDescribeDiskStoreCommandsDUnitTest.getLogWriter().info(ListAndDescribeDiskStoreCommandsDUnitTest.toString((Result)result));
        ListAndDescribeDiskStoreCommandsDUnitTest.assertEquals((Object)Result.Status.OK, (Object)result.getStatus());
    }

    public void testDescribeDiskStoreWithInvalidMemberName() throws Exception {
        CommandResult commandResult = this.executeCommand("describe disk-store --member=badMemberName --name=producerData");
        ListAndDescribeDiskStoreCommandsDUnitTest.assertNotNull((Object)commandResult);
        ListAndDescribeDiskStoreCommandsDUnitTest.assertEquals((Object)Result.Status.ERROR, (Object)commandResult.getStatus());
        ListAndDescribeDiskStoreCommandsDUnitTest.assertEquals((String)CliStrings.format((String)"Member {0} could not be found.  Please verify the member name or ID and try again.", (Object)"badMemberName"), (String)ListAndDescribeDiskStoreCommandsDUnitTest.toString((Result)commandResult));
    }

    public void testDescribeDiskStoreWithInvalidDiskStoreName() {
        CommandResult commandResult = this.executeCommand("describe disk-store --member=producerServer --name=badDiskStoreName");
        ListAndDescribeDiskStoreCommandsDUnitTest.assertNotNull((Object)commandResult);
        ListAndDescribeDiskStoreCommandsDUnitTest.assertEquals((Object)Result.Status.ERROR, (Object)commandResult.getStatus());
        ListAndDescribeDiskStoreCommandsDUnitTest.assertEquals((String)"A disk store with name (badDiskStoreName) was not found on member (producerServer).", (String)ListAndDescribeDiskStoreCommandsDUnitTest.toString((Result)commandResult));
    }

    protected static class Peer
    implements Serializable {
        private final Properties distributedSystemConfiguration;
        private final VM vm;

        protected Peer(Properties distributedSystemConfiguration, VM vm) {
            assert (distributedSystemConfiguration != null) : "The GemFire distributed system configuration properties cannot be null!";
            this.distributedSystemConfiguration = distributedSystemConfiguration;
            this.vm = vm;
        }

        public Properties getDistributedSystemConfiguration() {
            return this.distributedSystemConfiguration;
        }

        public String getName() {
            return this.getDistributedSystemConfiguration().getProperty("name");
        }

        public VM getVm() {
            return this.vm;
        }

        public void run(Runnable runnable) {
            if (this.getVm() == null) {
                runnable.run();
            } else {
                this.getVm().invoke(runnable);
            }
        }
    }
}

