/*
 * Decompiled with CFR 0.152.
 */
package com.gemstone.gemfire.management.internal.cli.commands;

import com.gemstone.gemfire.cache.Cache;
import com.gemstone.gemfire.cache.CacheListener;
import com.gemstone.gemfire.cache.EvictionAction;
import com.gemstone.gemfire.cache.EvictionAttributes;
import com.gemstone.gemfire.cache.FixedPartitionAttributes;
import com.gemstone.gemfire.cache.PartitionAttributes;
import com.gemstone.gemfire.cache.PartitionAttributesFactory;
import com.gemstone.gemfire.cache.Region;
import com.gemstone.gemfire.cache.RegionFactory;
import com.gemstone.gemfire.cache.RegionShortcut;
import com.gemstone.gemfire.cache.util.CacheListenerAdapter;
import com.gemstone.gemfire.compression.Compressor;
import com.gemstone.gemfire.compression.SnappyCompressor;
import com.gemstone.gemfire.management.cli.Result;
import com.gemstone.gemfire.management.internal.cli.commands.CliCommandTestBase;
import com.gemstone.gemfire.management.internal.cli.result.CommandResult;
import com.gemstone.gemfire.management.internal.cli.util.CommandStringBuilder;
import dunit.Host;
import dunit.SerializableRunnable;
import dunit.VM;
import java.util.Properties;
import junit.framework.TestCase;

public class ListAndDescribeRegionDUnitTest
extends CliCommandTestBase {
    private static final String REGION1 = "region1";
    private static final String REGION2 = "region2";
    private static final String REGION3 = "region3";
    private static final String SUBREGION1A = "subregion1A";
    private static final String SUBREGION1B = "subregion1B";
    private static final String SUBREGION1C = "subregion1C";
    private static final String PR1 = "PR1";
    private static final String LOCALREGIONONMANAGER = "LocalRegionOnManager";

    public ListAndDescribeRegionDUnitTest(String name) {
        super(name);
    }

    private Properties createProperties(String name, String groups) {
        Properties props = new Properties();
        props.setProperty("mcast-port", "0");
        props.setProperty("log-level", "info");
        props.setProperty("statistic-sampling-enabled", "true");
        props.setProperty("enable-time-statistics", "true");
        props.setProperty("name", name);
        props.setProperty("groups", groups);
        return props;
    }

    private void createPartitionedRegion1() {
        Cache cache = this.getCache();
        RegionFactory dataRegionFactory = cache.createRegionFactory(RegionShortcut.PARTITION);
        dataRegionFactory.create(PR1);
    }

    private void setupSystem() {
        Properties managerProps = this.createProperties("Manager", "G1");
        this.createDefaultSetup(managerProps);
        final Properties server1Props = this.createProperties("Server1", "G2");
        Host host = Host.getHost(0);
        VM[] servers = new VM[]{host.getVM(0), host.getVM(1)};
        servers[0].invoke(new SerializableRunnable(){

            @Override
            public void run() {
                Cache cache = ListAndDescribeRegionDUnitTest.this.getCache();
                RegionFactory dataRegionFactory = cache.createRegionFactory(RegionShortcut.PARTITION);
                dataRegionFactory.setConcurrencyLevel(4);
                EvictionAttributes ea = EvictionAttributes.createLIFOEntryAttributes((int)100, (EvictionAction)EvictionAction.LOCAL_DESTROY);
                dataRegionFactory.setEvictionAttributes(ea);
                dataRegionFactory.setEnableAsyncConflation(true);
                FixedPartitionAttributes fpa = FixedPartitionAttributes.createFixedPartition((String)"Par1", (boolean)true);
                PartitionAttributes pa = new PartitionAttributesFactory().setLocalMaxMemory(100).setRecoveryDelay(2L).setTotalMaxMemory(200L).setRedundantCopies(1).addFixedPartitionAttributes(fpa).create();
                dataRegionFactory.setPartitionAttributes(pa);
                dataRegionFactory.create(ListAndDescribeRegionDUnitTest.PR1);
                ListAndDescribeRegionDUnitTest.this.createLocalRegion(ListAndDescribeRegionDUnitTest.LOCALREGIONONMANAGER);
            }
        });
        servers[1].invoke(new SerializableRunnable(){

            @Override
            public void run() {
                ListAndDescribeRegionDUnitTest.this.getSystem(server1Props);
                Cache cache = ListAndDescribeRegionDUnitTest.this.getCache();
                RegionFactory dataRegionFactory = cache.createRegionFactory(RegionShortcut.PARTITION);
                dataRegionFactory.setConcurrencyLevel(4);
                EvictionAttributes ea = EvictionAttributes.createLIFOEntryAttributes((int)100, (EvictionAction)EvictionAction.LOCAL_DESTROY);
                dataRegionFactory.setEvictionAttributes(ea);
                dataRegionFactory.setEnableAsyncConflation(true);
                FixedPartitionAttributes fpa = FixedPartitionAttributes.createFixedPartition((String)"Par2", (int)4);
                PartitionAttributes pa = new PartitionAttributesFactory().setLocalMaxMemory(150).setRecoveryDelay(4L).setTotalMaxMemory(200L).setRedundantCopies(1).addFixedPartitionAttributes(fpa).create();
                dataRegionFactory.setPartitionAttributes(pa);
                dataRegionFactory.create(ListAndDescribeRegionDUnitTest.PR1);
                ListAndDescribeRegionDUnitTest.this.createRegionsWithSubRegions();
            }
        });
    }

    private void createPartitionedRegion(String regionName) {
        Cache cache = this.getCache();
        RegionFactory dataRegionFactory = cache.createRegionFactory(RegionShortcut.PARTITION);
        dataRegionFactory.setConcurrencyLevel(4);
        EvictionAttributes ea = EvictionAttributes.createLIFOEntryAttributes((int)100, (EvictionAction)EvictionAction.LOCAL_DESTROY);
        dataRegionFactory.setEvictionAttributes(ea);
        dataRegionFactory.setEnableAsyncConflation(true);
        FixedPartitionAttributes fpa = FixedPartitionAttributes.createFixedPartition((String)"Par1", (boolean)true);
        PartitionAttributes pa = new PartitionAttributesFactory().setLocalMaxMemory(100).setRecoveryDelay(2L).setTotalMaxMemory(200L).setRedundantCopies(1).addFixedPartitionAttributes(fpa).create();
        dataRegionFactory.setPartitionAttributes(pa);
        dataRegionFactory.addCacheListener((CacheListener)new CacheListener1());
        dataRegionFactory.addCacheListener((CacheListener)new CacheListener2());
        dataRegionFactory.create(regionName);
    }

    private void createLocalRegion(String regionName) {
        Cache cache = this.getCache();
        RegionFactory dataRegionFactory = cache.createRegionFactory(RegionShortcut.LOCAL);
        dataRegionFactory.create(regionName);
    }

    private void createCompressedRegion(String regionName) {
        Cache cache = this.getCache();
        RegionFactory dataRegionFactory = cache.createRegionFactory(RegionShortcut.REPLICATE);
        dataRegionFactory.setCompressor((Compressor)SnappyCompressor.getDefaultInstance());
        dataRegionFactory.create(regionName);
    }

    private void createRegionsWithSubRegions() {
        Cache cache = this.getCache();
        RegionFactory dataRegionFactory = cache.createRegionFactory(RegionShortcut.REPLICATE);
        dataRegionFactory.setConcurrencyLevel(3);
        Region region1 = dataRegionFactory.create(REGION1);
        region1.createSubregion(SUBREGION1C, region1.getAttributes());
        Region subregion2 = region1.createSubregion(SUBREGION1A, region1.getAttributes());
        subregion2.createSubregion(SUBREGION1B, subregion2.getAttributes());
        dataRegionFactory.create(REGION2);
        dataRegionFactory.create(REGION3);
    }

    public void testListRegion() {
        this.setupSystem();
        CommandStringBuilder csb = new CommandStringBuilder("list regions");
        String commandString = csb.toString();
        CommandResult commandResult = this.executeCommand(commandString);
        String commandResultAsString = this.commandResultToString(commandResult);
        ListAndDescribeRegionDUnitTest.getLogWriter().info("Command String : " + commandString);
        ListAndDescribeRegionDUnitTest.getLogWriter().info("Output : \n" + commandResultAsString);
        ListAndDescribeRegionDUnitTest.assertEquals((Object)Result.Status.OK, (Object)commandResult.getStatus());
        ListAndDescribeRegionDUnitTest.assertTrue((boolean)commandResultAsString.contains(PR1));
        ListAndDescribeRegionDUnitTest.assertTrue((boolean)commandResultAsString.contains(LOCALREGIONONMANAGER));
        ListAndDescribeRegionDUnitTest.assertTrue((boolean)commandResultAsString.contains(REGION1));
        ListAndDescribeRegionDUnitTest.assertTrue((boolean)commandResultAsString.contains(REGION2));
        ListAndDescribeRegionDUnitTest.assertTrue((boolean)commandResultAsString.contains(REGION3));
        csb = new CommandStringBuilder("list regions");
        csb.addOption("member", "Manager");
        commandString = csb.toString();
        commandResult = this.executeCommand(commandString);
        commandResultAsString = this.commandResultToString(commandResult);
        ListAndDescribeRegionDUnitTest.getLogWriter().info("Command String : " + commandString);
        ListAndDescribeRegionDUnitTest.getLogWriter().info("Output : \n" + commandResultAsString);
        ListAndDescribeRegionDUnitTest.assertEquals((Object)Result.Status.OK, (Object)commandResult.getStatus());
        ListAndDescribeRegionDUnitTest.assertTrue((boolean)commandResultAsString.contains(PR1));
        ListAndDescribeRegionDUnitTest.assertTrue((boolean)commandResultAsString.contains(LOCALREGIONONMANAGER));
        csb = new CommandStringBuilder("list regions");
        csb.addOption("member", "Server1");
        commandString = csb.toString();
        commandResult = this.executeCommand(commandString);
        commandResultAsString = this.commandResultToString(commandResult);
        ListAndDescribeRegionDUnitTest.getLogWriter().info("Command String : " + commandString);
        ListAndDescribeRegionDUnitTest.getLogWriter().info("Output : \n" + commandResultAsString);
        ListAndDescribeRegionDUnitTest.assertEquals((Object)Result.Status.OK, (Object)commandResult.getStatus());
        ListAndDescribeRegionDUnitTest.assertTrue((boolean)commandResultAsString.contains(PR1));
        ListAndDescribeRegionDUnitTest.assertTrue((boolean)commandResultAsString.contains(REGION1));
        ListAndDescribeRegionDUnitTest.assertTrue((boolean)commandResultAsString.contains(REGION2));
        ListAndDescribeRegionDUnitTest.assertTrue((boolean)commandResultAsString.contains(REGION3));
        ListAndDescribeRegionDUnitTest.assertTrue((boolean)commandResultAsString.contains(SUBREGION1A));
        csb = new CommandStringBuilder("list regions");
        csb.addOption("group", "G1");
        commandString = csb.toString();
        commandResult = this.executeCommand(commandString);
        commandResultAsString = this.commandResultToString(commandResult);
        ListAndDescribeRegionDUnitTest.getLogWriter().info("Command String : " + commandString);
        ListAndDescribeRegionDUnitTest.getLogWriter().info("Output : \n" + commandResultAsString);
        ListAndDescribeRegionDUnitTest.assertEquals((Object)Result.Status.OK, (Object)commandResult.getStatus());
        ListAndDescribeRegionDUnitTest.assertTrue((boolean)commandResultAsString.contains(PR1));
        ListAndDescribeRegionDUnitTest.assertTrue((boolean)commandResultAsString.contains(LOCALREGIONONMANAGER));
        csb = new CommandStringBuilder("list regions");
        csb.addOption("group", "G2");
        commandString = csb.toString();
        commandResult = this.executeCommand(commandString);
        commandResultAsString = this.commandResultToString(commandResult);
        ListAndDescribeRegionDUnitTest.getLogWriter().info("Command String : " + commandString);
        ListAndDescribeRegionDUnitTest.getLogWriter().info("Output : \n" + commandResultAsString);
        ListAndDescribeRegionDUnitTest.assertEquals((Object)Result.Status.OK, (Object)commandResult.getStatus());
        ListAndDescribeRegionDUnitTest.assertTrue((boolean)commandResultAsString.contains(PR1));
        ListAndDescribeRegionDUnitTest.assertTrue((boolean)commandResultAsString.contains(REGION1));
        ListAndDescribeRegionDUnitTest.assertTrue((boolean)commandResultAsString.contains(REGION2));
        ListAndDescribeRegionDUnitTest.assertTrue((boolean)commandResultAsString.contains(REGION3));
        ListAndDescribeRegionDUnitTest.assertTrue((boolean)commandResultAsString.contains(SUBREGION1A));
    }

    public void testDescribeRegion() {
        this.setupSystem();
        CommandStringBuilder csb = new CommandStringBuilder("describe region");
        csb.addOption("name", PR1);
        String commandString = csb.toString();
        CommandResult commandResult = this.executeCommand(commandString);
        String commandResultAsString = this.commandResultToString(commandResult);
        ListAndDescribeRegionDUnitTest.getLogWriter().info("Command String : " + commandString);
        ListAndDescribeRegionDUnitTest.getLogWriter().info("Output : \n" + commandResultAsString);
        ListAndDescribeRegionDUnitTest.assertEquals((Object)Result.Status.OK, (Object)commandResult.getStatus());
        ListAndDescribeRegionDUnitTest.assertTrue((boolean)commandResultAsString.contains(PR1));
        ListAndDescribeRegionDUnitTest.assertTrue((boolean)commandResultAsString.contains("Server1"));
        csb = new CommandStringBuilder("describe region");
        csb.addOption("name", LOCALREGIONONMANAGER);
        commandString = csb.toString();
        commandResult = this.executeCommand(commandString);
        commandResultAsString = this.commandResultToString(commandResult);
        ListAndDescribeRegionDUnitTest.getLogWriter().info("Command String : " + commandString);
        ListAndDescribeRegionDUnitTest.getLogWriter().info("Output : \n" + commandResultAsString);
        ListAndDescribeRegionDUnitTest.assertEquals((Object)Result.Status.OK, (Object)commandResult.getStatus());
        ListAndDescribeRegionDUnitTest.assertTrue((boolean)commandResultAsString.contains(LOCALREGIONONMANAGER));
        ListAndDescribeRegionDUnitTest.assertTrue((boolean)commandResultAsString.contains("Manager"));
    }

    public void testDescribeRegionWithCompressionCodec() {
        String regionName = "compressedRegion";
        VM vm = Host.getHost(0).getVM(1);
        this.setupSystem();
        vm.invoke(new SerializableRunnable(){

            @Override
            public void run() {
                ListAndDescribeRegionDUnitTest.this.createCompressedRegion("compressedRegion");
            }
        });
        CommandStringBuilder csb = new CommandStringBuilder("describe region");
        csb.addOption("name", "compressedRegion");
        String commandString = csb.toString();
        CommandResult commandResult = this.executeCommand(commandString);
        String commandResultAsString = this.commandResultToString(commandResult);
        ListAndDescribeRegionDUnitTest.assertEquals((Object)Result.Status.OK, (Object)commandResult.getStatus());
        ListAndDescribeRegionDUnitTest.assertTrue((boolean)commandResultAsString.contains("compressedRegion"));
        ListAndDescribeRegionDUnitTest.assertTrue((boolean)commandResultAsString.contains("compressor"));
        ListAndDescribeRegionDUnitTest.assertTrue((boolean)commandResultAsString.contains("com.gemstone.gemfire.compression.SnappyCompressor"));
        vm.invoke(new SerializableRunnable(){

            @Override
            public void run() {
                Region region = ListAndDescribeRegionDUnitTest.this.getCache().getRegion("compressedRegion");
                TestCase.assertNotNull((Object)region);
                region.destroyRegion();
            }
        });
    }

    static class CacheListener1
    extends CacheListenerAdapter {
        CacheListener1() {
        }
    }

    static class CacheListener2
    extends CacheListenerAdapter {
        CacheListener2() {
        }
    }
}

