/*
 * Decompiled with CFR 0.152.
 */
package com.gemstone.gemfire.management.internal.cli.commands;

import com.gemstone.gemfire.cache.Cache;
import com.gemstone.gemfire.cache.Region;
import com.gemstone.gemfire.cache.RegionFactory;
import com.gemstone.gemfire.cache.RegionShortcut;
import com.gemstone.gemfire.internal.FileUtil;
import com.gemstone.gemfire.internal.LogWriterImpl;
import com.gemstone.gemfire.management.cli.Result;
import com.gemstone.gemfire.management.internal.cli.commands.CliCommandTestBase;
import com.gemstone.gemfire.management.internal.cli.commands.GemfireDataCommandsDUnitTest;
import com.gemstone.gemfire.management.internal.cli.commands.MiscellaneousCommands;
import com.gemstone.gemfire.management.internal.cli.result.CommandResult;
import dunit.Host;
import dunit.SerializableRunnable;
import dunit.VM;
import java.io.File;
import java.io.IOException;
import java.text.SimpleDateFormat;
import java.util.Date;

public class MiscellaneousCommandsExportLogsPart2DUnitTest
extends CliCommandTestBase {
    private static final long serialVersionUID = 1L;

    public MiscellaneousCommandsExportLogsPart2DUnitTest(String name) {
        super(name);
    }

    public static String getMemberId() {
        Cache cache = new GemfireDataCommandsDUnitTest("test").getCache();
        return cache.getDistributedSystem().getDistributedMember().getId();
    }

    void setupForExportLogs() {
        VM vm1 = Host.getHost(0).getVM(1);
        this.createDefaultSetup(null);
        vm1.invoke(new SerializableRunnable(){

            @Override
            public void run() {
                Cache cache = MiscellaneousCommandsExportLogsPart2DUnitTest.this.getCache();
                RegionFactory dataRegionFactory = cache.createRegionFactory(RegionShortcut.PARTITION);
                Region region = dataRegionFactory.create("testRegion");
                for (int i = 0; i < 5; ++i) {
                    region.put((Object)("key" + (i + 200)), (Object)("value" + (i + 200)));
                }
            }
        });
    }

    String getCurrentTimeString() {
        SimpleDateFormat sf = new SimpleDateFormat("yyyy_MM_dd_HH_mm_ss_SSS_z");
        Date startDate = new Date(System.currentTimeMillis());
        String formattedStartDate = sf.format(startDate);
        return "_" + formattedStartDate;
    }

    public void testExportLogsForLogLevelWithUPTOLOGLEVEL() throws IOException {
        this.setupForExportLogs();
        Date startDate = new Date(System.currentTimeMillis() - 120000L);
        SimpleDateFormat sf = new SimpleDateFormat("yyyy/MM/dd");
        String start = sf.format(startDate);
        Date enddate = new Date(System.currentTimeMillis() + 0x6DDD00L);
        String end = sf.format(enddate);
        String dir = this.getCurrentTimeString();
        String logLevel = LogWriterImpl.levelToString((int)1000);
        MiscellaneousCommands misc = new MiscellaneousCommands();
        this.getCache();
        Result cmdResult = misc.exportLogsPreprocessing("./testExportLogsForLogLevelWithUPTOLOGLEVEL" + dir, null, null, logLevel, true, false, start, end, 1);
        MiscellaneousCommandsExportLogsPart2DUnitTest.getLogWriter().info("testExportLogsForLogLevelWithUPTOLOGLEVEL command=" + cmdResult);
        if (cmdResult != null) {
            String cmdStringRsult = this.commandResultToString((CommandResult)cmdResult);
            MiscellaneousCommandsExportLogsPart2DUnitTest.getLogWriter().info("testExportLogsForLogLevelWithUPTOLOGLEVEL cmdStringRsult=" + cmdStringRsult);
            MiscellaneousCommandsExportLogsPart2DUnitTest.assertEquals((Object)Result.Status.OK, (Object)cmdResult.getStatus());
        } else {
            MiscellaneousCommandsExportLogsPart2DUnitTest.fail((String)"testExportLogsForLogLevelWithUPTOLOGLEVEL failed as did not get CommandResult");
        }
        FileUtil.delete((File)new File("testExportLogsForLogLevelWithUPTOLOGLEVEL" + dir));
    }
}

