/*
 * Decompiled with CFR 0.152.
 */
package com.gemstone.gemfire.management.internal.cli.commands;

import com.gemstone.gemfire.cache.Cache;
import com.gemstone.gemfire.cache.Region;
import com.gemstone.gemfire.cache.RegionFactory;
import com.gemstone.gemfire.cache.RegionShortcut;
import com.gemstone.gemfire.internal.FileUtil;
import com.gemstone.gemfire.internal.LogWriterImpl;
import com.gemstone.gemfire.management.cli.Result;
import com.gemstone.gemfire.management.internal.cli.commands.CliCommandTestBase;
import com.gemstone.gemfire.management.internal.cli.commands.GemfireDataCommandsDUnitTest;
import com.gemstone.gemfire.management.internal.cli.commands.MiscellaneousCommands;
import com.gemstone.gemfire.management.internal.cli.commands.MiscellaneousCommandsDUnitTest;
import com.gemstone.gemfire.management.internal.cli.result.CommandResult;
import dunit.Host;
import dunit.SerializableRunnable;
import dunit.VM;
import java.io.File;
import java.io.IOException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Properties;

public class MiscellaneousCommandsExportLogsPart3DUnitTest
extends CliCommandTestBase {
    private static final long serialVersionUID = 1L;

    public MiscellaneousCommandsExportLogsPart3DUnitTest(String name) {
        super(name);
    }

    public static String getMemberId() {
        Cache cache = new GemfireDataCommandsDUnitTest("test").getCache();
        return cache.getDistributedSystem().getDistributedMember().getId();
    }

    void setupForExportLogs() {
        VM vm1 = Host.getHost(0).getVM(1);
        this.createDefaultSetup(null);
        vm1.invoke(new SerializableRunnable(){

            @Override
            public void run() {
                Cache cache = MiscellaneousCommandsExportLogsPart3DUnitTest.this.getCache();
                RegionFactory dataRegionFactory = cache.createRegionFactory(RegionShortcut.PARTITION);
                Region region = dataRegionFactory.create("testRegion");
                for (int i = 0; i < 5; ++i) {
                    region.put((Object)("key" + (i + 200)), (Object)("value" + (i + 200)));
                }
            }
        });
    }

    String getCurrentTimeString() {
        SimpleDateFormat sf = new SimpleDateFormat("yyyy_MM_dd_HH_mm_ss_SSS_z");
        Date startDate = new Date(System.currentTimeMillis());
        String formattedStartDate = sf.format(startDate);
        return "_" + formattedStartDate;
    }

    public void testExportLogsForGroup() throws IOException {
        Properties localProps = new Properties();
        localProps.setProperty("name", "Manager");
        localProps.setProperty("groups", "Group1");
        this.createDefaultSetup(localProps);
        String dir = this.getCurrentTimeString();
        Date startDate = new Date(System.currentTimeMillis() - 120000L);
        SimpleDateFormat sf = new SimpleDateFormat("yyyy/MM/dd");
        String start = sf.format(startDate);
        Date enddate = new Date(System.currentTimeMillis() + 0x6DDD00L);
        String end = sf.format(enddate);
        String logLevel = LogWriterImpl.levelToString((int)800);
        MiscellaneousCommands misc = new MiscellaneousCommands();
        this.getCache();
        String[] groups = new String[]{"Group1"};
        Result cmdResult = misc.exportLogsPreprocessing("./testExportLogsForGroup" + dir, groups, null, logLevel, false, false, start, end, 1);
        MiscellaneousCommandsExportLogsPart3DUnitTest.getLogWriter().info("testExportLogsForGroup command result =" + cmdResult);
        if (cmdResult != null) {
            String cmdStringRsult = this.commandResultToString((CommandResult)cmdResult);
            MiscellaneousCommandsExportLogsPart3DUnitTest.getLogWriter().info("testExportLogsForGroup cmdStringRsult=" + cmdStringRsult);
            MiscellaneousCommandsExportLogsPart3DUnitTest.assertEquals((Object)Result.Status.OK, (Object)cmdResult.getStatus());
        } else {
            MiscellaneousCommandsExportLogsPart3DUnitTest.fail((String)"testExportLogsForGroup failed as did not get CommandResult");
        }
        FileUtil.delete((File)new File("testExportLogsForGroup" + dir));
    }

    public void testExportLogsForMember() throws IOException {
        this.createDefaultSetup(null);
        Date startDate = new Date(System.currentTimeMillis() - 120000L);
        SimpleDateFormat sf = new SimpleDateFormat("yyyy/MM/dd");
        String start = sf.format(startDate);
        Date enddate = new Date(System.currentTimeMillis() + 0x6DDD00L);
        String end = sf.format(enddate);
        VM vm1 = Host.getHost(0).getVM(1);
        String vm1MemberId = (String)vm1.invoke(MiscellaneousCommandsDUnitTest.class, "getMemberId");
        String dir = this.getCurrentTimeString();
        String logLevel = LogWriterImpl.levelToString((int)800);
        MiscellaneousCommands misc = new MiscellaneousCommands();
        this.getCache();
        Result cmdResult = misc.exportLogsPreprocessing("./testExportLogsForMember" + dir, null, vm1MemberId, logLevel, false, false, start, end, 1);
        MiscellaneousCommandsExportLogsPart3DUnitTest.getLogWriter().info("testExportLogsForMember command result =" + cmdResult);
        if (cmdResult != null) {
            String cmdStringRsult = this.commandResultToString((CommandResult)cmdResult);
            MiscellaneousCommandsExportLogsPart3DUnitTest.getLogWriter().info("testExportLogsForMember cmdStringRsult=" + cmdStringRsult);
            MiscellaneousCommandsExportLogsPart3DUnitTest.assertEquals((Object)Result.Status.OK, (Object)cmdResult.getStatus());
        } else {
            MiscellaneousCommandsExportLogsPart3DUnitTest.fail((String)"testExportLogsForMember failed as did not get CommandResult");
        }
        FileUtil.delete((File)new File("testExportLogsForMember" + dir));
    }
}

