/*
 * Decompiled with CFR 0.152.
 */
package com.gemstone.gemfire.management.internal.cli.commands;

import com.gemstone.gemfire.cache.Cache;
import com.gemstone.gemfire.cache.execute.Function;
import com.gemstone.gemfire.cache.execute.FunctionContext;
import com.gemstone.gemfire.cache.execute.FunctionService;
import com.gemstone.gemfire.cache.execute.ResultCollector;
import com.gemstone.gemfire.cache30.CacheTestCase;
import com.gemstone.gemfire.distributed.DistributedLockService;
import com.gemstone.gemfire.distributed.DistributedMember;
import com.gemstone.gemfire.distributed.DistributedSystem;
import com.gemstone.gemfire.distributed.internal.deadlock.GemFireDeadlockDetector;
import com.gemstone.gemfire.distributed.internal.membership.InternalDistributedMember;
import com.gemstone.gemfire.management.cli.Result;
import com.gemstone.gemfire.management.internal.cli.remote.CommandProcessor;
import com.gemstone.gemfire.management.internal.cli.util.CommandStringBuilder;
import dunit.DistributedTestCase;
import dunit.Host;
import dunit.SerializableCallable;
import dunit.SerializableRunnable;
import dunit.VM;
import java.io.File;
import java.io.IOException;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import org.junit.FixMethodOrder;
import org.junit.runners.MethodSorters;

@FixMethodOrder(value=MethodSorters.JVM)
public class ShowDeadlockDUnitTest
extends CacheTestCase {
    private static final long serialVersionUID = 1L;
    private static final Set<Thread> stuckThreads = Collections.synchronizedSet(new HashSet());
    private static final Map<String, String> EMPTY_ENV = Collections.emptyMap();
    private static final Lock lock = new ReentrantLock();

    @Override
    public void tearDown2() throws Exception {
        ShowDeadlockDUnitTest.invokeInEveryVM(new SerializableRunnable(){
            private static final long serialVersionUID = 1L;

            @Override
            public void run() {
                for (Thread thread : stuckThreads) {
                    thread.interrupt();
                }
            }
        });
    }

    public ShowDeadlockDUnitTest(String name) {
        super(name);
    }

    public void testNoDeadlock() throws ClassNotFoundException, IOException {
        Host host = Host.getHost(0);
        VM vm0 = host.getVM(0);
        VM vm1 = host.getVM(1);
        ShowDeadlockDUnitTest.disconnectAllFromDS();
        this.createCache(vm0);
        this.createCache(vm1);
        this.createCache(new Properties());
        String fileName = "dependency.txt";
        GemFireDeadlockDetector detect = new GemFireDeadlockDetector();
        ShowDeadlockDUnitTest.assertEquals(null, (Object)detect.find().findCycle());
        CommandProcessor commandProcessor = new CommandProcessor();
        CommandStringBuilder csb = new CommandStringBuilder("show dead-locks");
        csb.addOption("file", fileName);
        Result result = commandProcessor.createCommandStatement(csb.toString(), EMPTY_ENV).process();
        String deadLockOutputFromCommand = this.getResultAsString(result);
        ShowDeadlockDUnitTest.getLogWriter().info("output = " + deadLockOutputFromCommand);
        ShowDeadlockDUnitTest.assertEquals((boolean)true, (boolean)result.hasIncomingFiles());
        ShowDeadlockDUnitTest.assertEquals((boolean)true, (boolean)result.getStatus().equals((Object)Result.Status.OK));
        ShowDeadlockDUnitTest.assertEquals((boolean)true, (boolean)deadLockOutputFromCommand.startsWith("No dead lock detected."));
        result.saveIncomingFiles(null);
        File file = new File(fileName);
        ShowDeadlockDUnitTest.assertTrue((boolean)file.exists());
        file.delete();
    }

    public void testDistributedDeadlockWithFunction() throws InterruptedException, ClassNotFoundException, IOException {
        Host host = Host.getHost(0);
        VM vm0 = host.getVM(0);
        VM vm1 = host.getVM(1);
        String filename = "gfeDependency.txt";
        InternalDistributedMember member1 = this.createCache(vm0);
        InternalDistributedMember member2 = this.createCache(vm1);
        this.createCache(new Properties());
        this.lockTheLocks(vm0, member2);
        this.lockTheLocks(vm1, member1);
        Thread.sleep(5000L);
        CommandProcessor commandProcessor = new CommandProcessor();
        CommandStringBuilder csb = new CommandStringBuilder("show dead-locks");
        csb.addOption("file", filename);
        Result result = commandProcessor.createCommandStatement(csb.toString(), EMPTY_ENV).process();
        String deadLockOutputFromCommand = this.getResultAsString(result);
        ShowDeadlockDUnitTest.getLogWriter().info("Deadlock = " + deadLockOutputFromCommand);
        result.saveIncomingFiles(null);
        ShowDeadlockDUnitTest.assertEquals((boolean)true, (boolean)deadLockOutputFromCommand.startsWith("Dead lock detected."));
        ShowDeadlockDUnitTest.assertEquals((boolean)true, (boolean)result.getStatus().equals((Object)Result.Status.OK));
        File file = new File(filename);
        ShowDeadlockDUnitTest.assertTrue((boolean)file.exists());
        file.delete();
    }

    private void createCache(Properties props) {
        this.getSystem(props);
        Cache cache = this.getCache();
    }

    private Properties createProperties(Host host, int locatorPort) {
        Properties props = new Properties();
        props.setProperty("mcast-port", "0");
        props.setProperty("log-level", "info");
        props.setProperty("statistic-sampling-enabled", "true");
        props.setProperty("enable-time-statistics", "true");
        props.put("enable-network-partition-detection", "true");
        return props;
    }

    private void lockTheLocks(VM vm0, final InternalDistributedMember member) {
        vm0.invokeAsync(new SerializableRunnable(){
            private static final long serialVersionUID = 1L;

            @Override
            public void run() {
                lock.lock();
                try {
                    Thread.sleep(1000L);
                }
                catch (InterruptedException e) {
                    DistributedTestCase.fail("interrupted", e);
                }
                ResultCollector collector = FunctionService.onMember((DistributedSystem)DistributedTestCase.system, (DistributedMember)member).execute((Function)new TestFunction());
                collector.getResult();
                lock.unlock();
            }
        });
    }

    public void testDistributedDeadlockWithDLock() throws InterruptedException, ClassNotFoundException, IOException {
        Host host = Host.getHost(0);
        VM vm0 = host.getVM(0);
        VM vm1 = host.getVM(1);
        this.createCache(new Properties());
        this.lockTheDLocks(vm0, "one", "two");
        this.lockTheDLocks(vm1, "two", "one");
        GemFireDeadlockDetector detect = new GemFireDeadlockDetector();
        LinkedList deadlock = null;
        for (int i = 0; i < 120 && (deadlock = detect.find().findCycle()) == null; ++i) {
            Thread.sleep(1000L);
        }
        String fileName = "dependency.txt";
        CommandProcessor commandProcessor = new CommandProcessor();
        CommandStringBuilder csb = new CommandStringBuilder("show dead-locks");
        csb.addOption("file", fileName);
        Result result = commandProcessor.createCommandStatement(csb.toString(), EMPTY_ENV).process();
        String deadLockOutputFromCommand = this.getResultAsString(result);
        ShowDeadlockDUnitTest.getLogWriter().info("Deadlock = " + deadLockOutputFromCommand);
        ShowDeadlockDUnitTest.assertTrue((deadlock != null ? 1 : 0) != 0);
        ShowDeadlockDUnitTest.assertEquals((boolean)true, (boolean)result.getStatus().equals((Object)Result.Status.OK));
        ShowDeadlockDUnitTest.assertEquals((boolean)true, (boolean)deadLockOutputFromCommand.startsWith("Dead lock detected."));
        result.saveIncomingFiles(".");
        File file = new File(fileName);
        ShowDeadlockDUnitTest.assertTrue((boolean)file.exists());
        file.delete();
    }

    private void lockTheDLocks(VM vm, final String first, final String second) {
        vm.invokeAsync(new SerializableRunnable(){
            private static final long serialVersionUID = 1L;

            @Override
            public void run() {
                ShowDeadlockDUnitTest.this.getCache();
                DistributedLockService dls = DistributedLockService.create((String)"deadlock_test", (DistributedSystem)ShowDeadlockDUnitTest.this.getSystem());
                dls.lock((Object)first, 10000L, -1L);
                try {
                    Thread.sleep(1000L);
                }
                catch (InterruptedException e) {
                    e.printStackTrace();
                }
                dls.lock((Object)second, 10000L, -1L);
            }
        });
    }

    private InternalDistributedMember createCache(VM vm) {
        return (InternalDistributedMember)vm.invoke(new SerializableCallable(){
            private static final long serialVersionUID = 1L;

            public Object call() {
                ShowDeadlockDUnitTest.this.getCache();
                return ShowDeadlockDUnitTest.this.getSystem().getDistributedMember();
            }
        });
    }

    private String getResultAsString(Result result) {
        StringBuilder sb = new StringBuilder();
        while (result.hasNextLine()) {
            sb.append(result.nextLine());
        }
        return sb.toString();
    }

    private static class TestFunction
    implements Function {
        private static final long serialVersionUID = 1L;
        private static final int LOCK_WAIT_TIME = 1000;

        private TestFunction() {
        }

        public boolean hasResult() {
            return true;
        }

        public void execute(FunctionContext context) {
            try {
                stuckThreads.add(Thread.currentThread());
                lock.tryLock(1000L, TimeUnit.SECONDS);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            context.getResultSender().lastResult(null);
        }

        public String getId() {
            return this.getClass().getCanonicalName();
        }

        public boolean optimizeForWrite() {
            return false;
        }

        public boolean isHA() {
            return false;
        }
    }
}

