/*
 * Decompiled with CFR 0.152.
 */
package com.gemstone.gemfire.management.internal.cli.commands;

import com.gemstone.gemfire.cache.AttributesFactory;
import com.gemstone.gemfire.cache.Cache;
import com.gemstone.gemfire.cache.CacheException;
import com.gemstone.gemfire.cache.DataPolicy;
import com.gemstone.gemfire.cache.DiskStore;
import com.gemstone.gemfire.cache.PartitionAttributesFactory;
import com.gemstone.gemfire.cache.Region;
import com.gemstone.gemfire.cache.RegionFactory;
import com.gemstone.gemfire.cache.RegionShortcut;
import com.gemstone.gemfire.cache.Scope;
import com.gemstone.gemfire.cache30.CacheSerializableRunnable;
import com.gemstone.gemfire.internal.AvailablePort;
import com.gemstone.gemfire.internal.SocketCreator;
import com.gemstone.gemfire.internal.cache.DiskStoreImpl;
import com.gemstone.gemfire.internal.cache.DistributedRegion;
import com.gemstone.gemfire.internal.cache.LocalRegion;
import com.gemstone.gemfire.internal.cache.PartitionedRegion;
import com.gemstone.gemfire.internal.cache.UpgradeDiskStoreDUnitTest;
import com.gemstone.gemfire.internal.cache.versions.VersionTag;
import com.gemstone.gemfire.internal.shared.Version;
import com.gemstone.gemfire.management.cli.Result;
import com.gemstone.gemfire.management.internal.cli.commands.CliCommandTestBase;
import com.gemstone.gemfire.management.internal.cli.result.CommandResult;
import com.gemstone.gemfire.management.internal.cli.util.CommandStringBuilder;
import dunit.AsyncInvocation;
import dunit.SerializableCallable;
import dunit.VM;
import hydra.FileUtil;
import hydra.HostDescription;
import hydra.HostHelper;
import hydra.HydraConfigException;
import hydra.Log;
import hydra.ProcessMgr;
import hydra.RemoteTestModule;
import hydra.TestConfig;
import java.io.File;
import java.rmi.RemoteException;
import junit.framework.TestCase;

public class UpgradeOfflineDiskStoreDUnitTest
extends CliCommandTestBase {
    private static final long serialVersionUID = 1L;
    final int mcastPort = AvailablePort.getRandomAvailablePort((int)1);
    final String member1_dir = "mem1_dir";
    final String member2_dir = "mem2_dir";
    final String member1_dir4test = "mem1_dir4test";
    final String member2_dir4test = "mem2_dir4test";
    int pid1;
    int pid2;

    public UpgradeOfflineDiskStoreDUnitTest(String name) {
        super(name);
    }

    @Override
    public void tearDown2() throws Exception {
        super.tearDown2();
        FileUtil.rmdir("mem1_dir4test", false);
        FileUtil.rmdir("mem2_dir4test", false);
        this.removePID(this.pid1);
        this.removePID(this.pid2);
    }

    public void testCommand() throws Throwable {
        UpgradeOfflineDiskStoreDUnitTest.disconnectAllFromDS();
        CommandResult cmdResult = this.executeUpgradeDiskStore("dd", "dddd", "1");
        UpgradeOfflineDiskStoreDUnitTest.assertTrue((boolean)Result.Status.ERROR.equals((Object)cmdResult.getStatus()));
    }

    public void testPR() throws Throwable {
        UpgradeOfflineDiskStoreDUnitTest.disconnectAllFromDS();
        this.createTestData("662", true);
        com.gemstone.gemfire.internal.FileUtil.copy((File)new File("mem1_dir"), (File)new File("mem1_dir4test"));
        com.gemstone.gemfire.internal.FileUtil.copy((File)new File("mem2_dir"), (File)new File("mem2_dir4test"));
        this.do_normal(true, true, false);
    }

    public void testDR() throws Throwable {
        UpgradeOfflineDiskStoreDUnitTest.disconnectAllFromDS();
        this.createTestData("662", false);
        com.gemstone.gemfire.internal.FileUtil.copy((File)new File("mem1_dir"), (File)new File("mem1_dir4test"));
        com.gemstone.gemfire.internal.FileUtil.copy((File)new File("mem2_dir"), (File)new File("mem2_dir4test"));
        this.do_normal(false, true, false);
    }

    public void testDR651() throws Throwable {
        UpgradeOfflineDiskStoreDUnitTest.disconnectAllFromDS();
        this.createTestData("651", false);
        com.gemstone.gemfire.internal.FileUtil.copy((File)new File("mem1_dir"), (File)new File("mem1_dir4test"));
        com.gemstone.gemfire.internal.FileUtil.copy((File)new File("mem2_dir"), (File)new File("mem2_dir4test"));
        this.do_normal(false, true, false);
    }

    protected void do_normal(boolean isPR, boolean upgradeVersionOnly, boolean doRecoveryOnly) throws Throwable {
        if (!doRecoveryOnly) {
            DiskStoreImpl rte2;
            DiskStoreImpl ds1_member2;
            UpgradeOfflineDiskStoreDUnitTest.printDirectory("mem1_dir4test", "before do_normal isPR=" + isPR);
            UpgradeOfflineDiskStoreDUnitTest.printDirectory("mem2_dir4test", "before do_normal isPR=" + isPR);
            CommandResult cmdResult = this.executeUpgradeDiskStore("ds1", "mem1_dir4test", "1");
            UpgradeOfflineDiskStoreDUnitTest.assertTrue((boolean)Result.Status.OK.equals((Object)cmdResult.getStatus()));
            cmdResult = this.executeUpgradeDiskStore("ds2", "mem1_dir4test", "1");
            UpgradeOfflineDiskStoreDUnitTest.assertTrue((boolean)Result.Status.OK.equals((Object)cmdResult.getStatus()));
            try {
                ds1_member2 = DiskStoreImpl.offlineCompact((String)"ds1", (File[])this.getDiskDirsForMember("mem1_dir4test"), (boolean)true, (long)1L);
                UpgradeOfflineDiskStoreDUnitTest.fail((String)"Did not throw the expected exception");
            }
            catch (RuntimeException rte2) {
                UpgradeOfflineDiskStoreDUnitTest.assertTrue((boolean)rte2.getMessage().contains("This disk store is already at version " + Version.CURRENT));
            }
            try {
                rte2 = DiskStoreImpl.offlineCompact((String)"ds2", (File[])this.getDiskDirsForMember("mem1_dir4test"), (boolean)true, (long)1L);
            }
            catch (RuntimeException rte3) {
                UpgradeOfflineDiskStoreDUnitTest.assertTrue((boolean)rte3.getMessage().contains("This disk store is already at version " + Version.CURRENT));
            }
            File drfFile1 = new File("mem1_dir4test", "BACKUPds1_2.drf");
            File drfFile2 = new File("mem1_dir4test", "BACKUPds2_2.drf");
            UpgradeOfflineDiskStoreDUnitTest.assertTrue((!drfFile1.exists() ? 1 : 0) != 0);
            UpgradeOfflineDiskStoreDUnitTest.assertTrue((!drfFile2.exists() ? 1 : 0) != 0);
            DiskStoreImpl.validate((String)"ds1", (File[])this.getDiskDirsForMember("mem1_dir4test"));
            DiskStoreImpl.validate((String)"ds2", (File[])this.getDiskDirsForMember("mem1_dir4test"));
            cmdResult = this.executeUpgradeDiskStore("ds1", "mem2_dir4test", "1");
            UpgradeOfflineDiskStoreDUnitTest.assertTrue((boolean)Result.Status.OK.equals((Object)cmdResult.getStatus()));
            cmdResult = this.executeUpgradeDiskStore("ds2", "mem2_dir4test", "1");
            UpgradeOfflineDiskStoreDUnitTest.assertTrue((boolean)Result.Status.OK.equals((Object)cmdResult.getStatus()));
            try {
                ds1_member2 = DiskStoreImpl.offlineCompact((String)"ds1", (File[])this.getDiskDirsForMember("mem2_dir4test"), (boolean)true, (long)1L);
                UpgradeOfflineDiskStoreDUnitTest.fail((String)"Did not throw the expected exception");
            }
            catch (RuntimeException rte4) {
                UpgradeOfflineDiskStoreDUnitTest.assertTrue((boolean)rte4.getMessage().contains("This disk store is already at version " + Version.CURRENT));
            }
            try {
                rte2 = DiskStoreImpl.offlineCompact((String)"ds2", (File[])this.getDiskDirsForMember("mem2_dir4test"), (boolean)true, (long)1L);
            }
            catch (RuntimeException rte5) {
                UpgradeOfflineDiskStoreDUnitTest.assertTrue((boolean)rte5.getMessage().contains("This disk store is already at version " + Version.CURRENT));
            }
            drfFile1 = new File("mem2_dir4test", "BACKUPds1_2.drf");
            drfFile2 = new File("mem2_dir4test", "BACKUPds2_2.drf");
            UpgradeOfflineDiskStoreDUnitTest.assertTrue((!drfFile1.exists() ? 1 : 0) != 0);
            UpgradeOfflineDiskStoreDUnitTest.assertTrue((!drfFile2.exists() ? 1 : 0) != 0);
            DiskStoreImpl.validate((String)"ds1", (File[])this.getDiskDirsForMember("mem2_dir4test"));
            DiskStoreImpl.validate((String)"ds2", (File[])this.getDiskDirsForMember("mem2_dir4test"));
        }
    }

    public File[] getDiskDirsForMember(String member_dir) {
        File dir = new File(member_dir);
        return new File[]{dir};
    }

    protected void createTestData(String version, boolean isPR) throws Throwable {
        FileUtil.rmdir("mem1_dir", false);
        FileUtil.rmdir("mem2_dir", false);
        this.pid1 = this.runScript(version, "mem1_dir", isPR, false, false);
        this.pid2 = this.runScript(version, "mem2_dir", isPR, true, false);
        String host = HostHelper.getLocalHost();
        int maxWaitSec = 300;
        if (!ProcessMgr.waitForDeath(host, this.pid1, maxWaitSec)) {
            UpgradeOfflineDiskStoreDUnitTest.fail((String)("The " + this.pid1 + " is still running"));
        }
        if (!ProcessMgr.waitForDeath(host, this.pid2, maxWaitSec)) {
            UpgradeOfflineDiskStoreDUnitTest.fail((String)("The " + this.pid2 + " is still running"));
        }
        File crfFile1 = new File("mem1_dir", "BACKUPds1_2.crf");
        File crfFile2 = new File("mem1_dir", "BACKUPds2_2.crf");
        File drfFile1 = new File("mem1_dir", "BACKUPds1_2.drf");
        File drfFile2 = new File("mem1_dir", "BACKUPds2_2.drf");
        UpgradeOfflineDiskStoreDUnitTest.assertEquals((boolean)true, (boolean)crfFile1.exists());
        UpgradeOfflineDiskStoreDUnitTest.assertEquals((boolean)true, (boolean)crfFile2.exists());
        UpgradeOfflineDiskStoreDUnitTest.assertEquals((boolean)true, (boolean)drfFile1.exists());
        UpgradeOfflineDiskStoreDUnitTest.assertEquals((boolean)true, (boolean)drfFile2.exists());
    }

    protected int runScript(String version, String diskdir, boolean isPR, boolean doOps, boolean isSDA) throws Throwable {
        String javacmd = System.getProperty("java.home") + File.separator + "bin" + File.separator + "java";
        String jtests = System.getProperty("JTESTS");
        String userDir = System.getProperty("user.dir");
        String oldgemfire = UpgradeDiskStoreDUnitTest.getGemfireLocation(version);
        String classpath = " -cp " + oldgemfire + File.separator + "lib" + File.separator + "gemfire.jar" + File.pathSeparator + jtests;
        String command = javacmd + classpath + " com.gemstone.gemfire.internal.cache.RunCacheInOldGemfire " + this.mcastPort + " " + diskdir + " " + isPR + " " + doOps + " " + isSDA + " " + SocketCreator.getLocalHost().getHostAddress();
        if (Log.getLogWriter() == null) {
            Log.createLogWriter("script.log", "info");
        }
        Log.getLogWriter().info("Running script: current directory is " + userDir);
        int pid = ProcessMgr.bgexec(command);
        Log.getLogWriter().info("Running script: calling " + command + " at pid " + pid);
        this.recordPID(pid);
        return pid;
    }

    protected void recordPID(int pid) throws RemoteException {
        String gemfireName = System.getProperty("gemfireName");
        if (gemfireName == null) {
            String s = "No gemfire name has been specified";
            throw new HydraConfigException(s);
        }
        HostDescription hd = TestConfig.getInstance().getGemFireDescription(gemfireName).getHostDescription();
        RemoteTestModule.Master.recordPID(hd, pid);
    }

    protected void removePID(int pid) throws RemoteException {
        if (pid <= 0) {
            return;
        }
        String gemfireName = System.getProperty("gemfireName");
        if (gemfireName == null) {
            String s = "No gemfire name has been specified";
            throw new HydraConfigException(s);
        }
        HostDescription hd = TestConfig.getInstance().getGemFireDescription(gemfireName).getHostDescription();
        RemoteTestModule.Master.removePID(hd, pid);
    }

    protected AsyncInvocation createPeerCache(VM server, int mcastPort, final String regionName, final boolean createPR, final String member_dir, final String diskStoreName) {
        AsyncInvocation inst = server.invokeAsync(new CacheSerializableRunnable("Create Cache and Region"){

            @Override
            public void run2() throws CacheException {
                Region region;
                AttributesFactory factory = new AttributesFactory();
                Cache cache = UpgradeOfflineDiskStoreDUnitTest.this.getCache();
                if (diskStoreName != null) {
                    DiskStore ds = cache.findDiskStore(diskStoreName);
                    if (ds == null) {
                        ds = cache.createDiskStoreFactory().setDiskDirs(UpgradeOfflineDiskStoreDUnitTest.this.getDiskDirsForMember(member_dir)).create(diskStoreName);
                    }
                    if (createPR) {
                        PartitionAttributesFactory paf = new PartitionAttributesFactory();
                        paf.setRedundantCopies(1);
                        factory.setPartitionAttributes(paf.create());
                        factory.setDataPolicy(DataPolicy.PERSISTENT_PARTITION);
                    } else {
                        factory.setScope(Scope.DISTRIBUTED_ACK);
                        factory.setDataPolicy(DataPolicy.PERSISTENT_REPLICATE);
                    }
                    factory.setConcurrencyChecksEnabled(true);
                    factory.setDiskStoreName(diskStoreName);
                    region = UpgradeOfflineDiskStoreDUnitTest.this.createRootRegion(regionName, factory.create());
                } else {
                    RegionFactory rf = createPR ? cache.createRegionFactory(RegionShortcut.PARTITION_REDUNDANT_PERSISTENT) : cache.createRegionFactory(RegionShortcut.REPLICATE_PERSISTENT);
                    rf.setConcurrencyChecksEnabled(true);
                    region = rf.create(regionName);
                }
                if (createPR) {
                    TestCase.assertTrue((boolean)(region instanceof PartitionedRegion));
                } else {
                    TestCase.assertTrue((boolean)(region instanceof DistributedRegion));
                }
            }
        });
        return inst;
    }

    private VersionTag getVersionTag(VM vm, final String regionName, final String key) {
        SerializableCallable getVersionTag = new SerializableCallable("verify version tag for key " + key){

            public Object call() {
                Cache cache = UpgradeOfflineDiskStoreDUnitTest.this.getCache();
                LocalRegion region = (LocalRegion)cache.getRegion(regionName);
                VersionTag tag = region.getVersionTag((Object)key);
                return tag;
            }
        };
        return (VersionTag)vm.invoke(getVersionTag);
    }

    private String getValue(VM vm, final String regionName, final String key) {
        SerializableCallable getValue = new SerializableCallable("verify value for key " + key){

            public Object call() {
                Cache cache = UpgradeOfflineDiskStoreDUnitTest.this.getCache();
                LocalRegion region = (LocalRegion)cache.getRegion(regionName);
                String value = (String)region.get((Object)key);
                return value;
            }
        };
        return (String)vm.invoke(getValue);
    }

    private int getRegionSize(VM vm, final String regionName) {
        SerializableCallable getRegionSize = new SerializableCallable("get region size for " + regionName){

            public Object call() {
                Cache cache = UpgradeOfflineDiskStoreDUnitTest.this.getCache();
                LocalRegion region = (LocalRegion)cache.getRegion(regionName);
                return region.size();
            }
        };
        return (Integer)vm.invoke(getRegionSize);
    }

    private static File[] listFiles(File dir) {
        File[] result = dir.listFiles();
        if (result == null) {
            result = new File[]{};
        }
        return result;
    }

    public static void printDirectory(String dirname, String testcasename) {
        File[] files = UpgradeOfflineDiskStoreDUnitTest.listFiles(new File(dirname));
        System.out.println(testcasename + ":list dir:" + dirname);
        for (File f : files) {
            System.out.println("list dir:" + f + ":size=" + f.length());
        }
    }

    private CommandResult executeUpgradeDiskStore(String name, String diskDirs, String maxOplogSize) {
        CommandStringBuilder csb = new CommandStringBuilder("upgrade offline-disk-store");
        csb.addOption("name", name);
        csb.addOption("disk-dirs", diskDirs);
        csb.addOption("max-oplog-size", maxOplogSize);
        String commandString = csb.toString();
        UpgradeOfflineDiskStoreDUnitTest.getLogWriter().info("Command String : " + commandString);
        CommandResult commandResult = this.executeCommand(commandString);
        String resultAsString = this.commandResultToString(commandResult);
        UpgradeOfflineDiskStoreDUnitTest.getLogWriter().info("Command Result : " + resultAsString);
        return commandResult;
    }
}

