/*
 * Decompiled with CFR 0.152.
 */
package com.gemstone.gemfire.management.internal.cli.commands;

import com.gemstone.gemfire.internal.ClassPathLoader;
import com.gemstone.gemfire.internal.FileUtil;
import com.gemstone.gemfire.management.cli.Result;
import com.gemstone.gemfire.management.internal.cli.CommandManager;
import com.gemstone.gemfire.management.internal.cli.commands.CliCommandTestBase;
import com.gemstone.gemfire.management.internal.cli.result.CommandResult;
import dunit.Host;
import dunit.SerializableRunnable;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.Properties;
import org.junit.Test;
import util.ClassBuilder;

public class UserCommandsDUnitTest
extends CliCommandTestBase {
    private static final long serialVersionUID = 1L;
    final File jarDirectory = new File(new File(ClassPathLoader.class.getProtectionDomain().getCodeSource().getLocation().getPath()).getParent(), "ext");
    final File jarFile = new File(this.jarDirectory, "UserCommandsDUnit.jar");
    boolean deleteJarDirectory = false;

    public UserCommandsDUnitTest(String name) throws Exception {
        super(name);
    }

    @Override
    public void setUp() throws Exception {
        super.setUp();
        this.createUserCommandJarFile();
    }

    @Override
    public void tearDown2() throws Exception {
        super.tearDown2();
        if (this.deleteJarDirectory) {
            FileUtil.delete((File)this.jarDirectory);
        } else {
            FileUtil.delete((File)this.jarFile);
        }
        System.clearProperty("gemfire.user-command-packages");
        ClassPathLoader.setLatestToDefault();
        CommandManager.clearInstance();
        Host.getHost(0).getVM(0).invoke(new SerializableRunnable(){
            private static final long serialVersionUID = 1L;

            @Override
            public void run() {
                System.clearProperty("gemfire.user-command-packages");
                ClassPathLoader.setLatestToDefault();
                CommandManager.clearInstance();
            }
        });
    }

    public void createUserCommandJarFile() throws IOException {
        this.deleteJarDirectory = this.jarDirectory.mkdir();
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("package junit.ucdunit;");
        stringBuffer.append("import org.springframework.shell.core.CommandMarker;");
        stringBuffer.append("import org.springframework.shell.core.annotation.CliAvailabilityIndicator;");
        stringBuffer.append("import org.springframework.shell.core.annotation.CliCommand;");
        stringBuffer.append("import org.springframework.shell.core.annotation.CliOption;");
        stringBuffer.append("import com.gemstone.gemfire.management.cli.Result;");
        stringBuffer.append("import com.gemstone.gemfire.management.internal.cli.CliUtil;");
        stringBuffer.append("import com.gemstone.gemfire.management.internal.cli.result.ResultBuilder;");
        stringBuffer.append("import com.gemstone.gemfire.management.internal.cli.shell.Gfsh;");
        stringBuffer.append("public final class UCDunitClass implements CommandMarker { public UCDunitClass() {}");
        stringBuffer.append("@CliCommand(value = { \"ucdunitcmd\" }, help = \"ucdunitcmd help\")");
        stringBuffer.append("public final Result ucdunitcmd(@CliOption(key = { \"name\" }, help = \"ucdunitcmd name help\") String name) {");
        stringBuffer.append("return ResultBuilder.createInfoResult(\"ucdunitcmd \" + name); }");
        stringBuffer.append("@CliAvailabilityIndicator({ \"ucdunitcmd\" })");
        stringBuffer.append("public final boolean isAvailable() { return true; } }");
        ClassBuilder classBuilder = new ClassBuilder();
        byte[] jarBytes = classBuilder.createJarFromClassContent("junit/ucdunit/UCDunitClass", stringBuffer.toString());
        FileOutputStream outStream = new FileOutputStream(this.jarFile);
        outStream.write(jarBytes);
        outStream.close();
    }

    @Test
    public void testCommandLineProperty() {
        System.setProperty("gemfire.user-command-packages", "junit.ucdunit");
        ClassPathLoader.setLatestToDefault();
        CommandManager.clearInstance();
        Host.getHost(0).getVM(0).invoke(new SerializableRunnable(){
            private static final long serialVersionUID = 1L;

            @Override
            public void run() {
                System.setProperty("gemfire.user-command-packages", "junit.ucdunit");
                ClassPathLoader.setLatestToDefault();
                CommandManager.clearInstance();
            }
        });
        this.createDefaultSetup(null);
        CommandResult cmdResult = this.executeCommand("ucdunitcmd");
        UserCommandsDUnitTest.assertEquals((Object)Result.Status.OK, (Object)cmdResult.getStatus());
    }

    @Test
    public void testGemFireProperty() {
        System.setProperty("gemfire.user-command-packages", "junit.ucdunit");
        ClassPathLoader.setLatestToDefault();
        CommandManager.clearInstance();
        Host.getHost(0).getVM(0).invoke(new SerializableRunnable(){
            private static final long serialVersionUID = 1L;

            @Override
            public void run() {
                ClassPathLoader.setLatestToDefault();
                CommandManager.clearInstance();
            }
        });
        Properties properties = new Properties();
        properties.setProperty("user-command-packages", "junit.ucdunit");
        this.createDefaultSetup(properties);
        CommandResult cmdResult = this.executeCommand("ucdunitcmd");
        UserCommandsDUnitTest.assertEquals((Object)Result.Status.OK, (Object)cmdResult.getStatus());
    }
}

