/*
 * Decompiled with CFR 0.152.
 */
package com.gemstone.gemfire.management.internal.pulse;

import com.gemstone.gemfire.cache.query.cq.dunit.CqQueryDUnitTest;
import com.gemstone.gemfire.internal.AvailablePortHelper;
import com.gemstone.gemfire.management.DistributedSystemMXBean;
import com.gemstone.gemfire.management.ManagementService;
import com.gemstone.gemfire.management.ManagementTestBase;
import dunit.DistributedTestCase;
import dunit.VM;

public class TestCQDUnitTest
extends ManagementTestBase {
    private static final long serialVersionUID = 1L;
    private static final String queryName = "testClientWithFeederAndCQ_0";
    private static final String queryName2 = "testClientWithFeederAndCQ_3";
    protected CqQueryDUnitTest cqDUnitTest = new CqQueryDUnitTest("CqDataDUnitTest");

    public TestCQDUnitTest(String name) {
        super(name);
    }

    @Override
    public void setUp() throws Exception {
        super.setUp();
    }

    @Override
    public void tearDown2() throws Exception {
        super.tearDown2();
    }

    public static long getNumOfCQ() {
        DistributedTestCase.WaitCriterion waitCriteria = new DistributedTestCase.WaitCriterion(){

            @Override
            public boolean done() {
                ManagementService service = ManagementTestBase.getManagementService();
                DistributedSystemMXBean bean = service.getDistributedSystemMXBean();
                return bean != null && bean.getActiveCQCount() > 0L;
            }

            @Override
            public String description() {
                return "wait for getNumOfCQ to complete and get results";
            }
        };
        TestCQDUnitTest.waitForCriterion(waitCriteria, 120000L, 3000L, true);
        DistributedSystemMXBean bean = TestCQDUnitTest.getManagementService().getDistributedSystemMXBean();
        TestCQDUnitTest.assertNotNull((Object)bean);
        return bean.getActiveCQCount();
    }

    public void testNumOfCQ() throws Exception {
        this.initManagement(false);
        TestCQDUnitTest.getLogWriter().info("started testNumOfCQ");
        VM server = (VM)managedNodeList.get(1);
        VM client = (VM)managedNodeList.get(2);
        String host0 = TestCQDUnitTest.getServerHostName(server.getHost());
        int serverPort = AvailablePortHelper.getRandomAvailableTCPPort();
        this.cqDUnitTest.createServer(server, serverPort);
        int port = server.invokeInt(CqQueryDUnitTest.class, "getCacheServerPort");
        this.cqDUnitTest.createClient(client, port, host0);
        this.cqDUnitTest.createCQ(client, queryName, this.cqDUnitTest.cqs[0]);
        this.cqDUnitTest.executeCQ(client, queryName, false, null);
        this.cqDUnitTest.createCQ(client, queryName2, this.cqDUnitTest.cqs[3]);
        this.cqDUnitTest.executeCQ(client, queryName2, false, null);
        int size = 1000;
        this.cqDUnitTest.createValues(client, this.cqDUnitTest.regions[0], 1000);
        this.cqDUnitTest.waitForCreated(client, queryName, "key-1000");
        this.cqDUnitTest.waitForCreated(client, queryName2, "key-1000");
        this.cqDUnitTest.validateCQ(client, queryName, CqQueryDUnitTest.noTest, 1000, 0, 0, 1000, 0, 0, 1000);
        this.cqDUnitTest.validateCQ(client, queryName2, CqQueryDUnitTest.noTest, 1000, 0, 0, 1000, 0, 0, 1000);
        long numOfCQ = ((Number)managingNode.invoke(TestCQDUnitTest.class, "getNumOfCQ")).intValue();
        TestCQDUnitTest.getLogWriter().info("testNumOfCQ numOfCQ= " + numOfCQ);
        this.cqDUnitTest.closeClient(client);
        this.cqDUnitTest.closeServer(server);
        TestCQDUnitTest.assertTrue((numOfCQ > 0L ? 1 : 0) != 0);
    }

    public void verifyStatistics() {
    }

    public void invokeOperations() {
    }
}

