/*
 * Decompiled with CFR 0.152.
 */
package com.gemstone.gemfire.management.internal.pulse;

import com.gemstone.gemfire.cache.AttributesFactory;
import com.gemstone.gemfire.cache.Cache;
import com.gemstone.gemfire.cache.CacheFactory;
import com.gemstone.gemfire.cache.DataPolicy;
import com.gemstone.gemfire.cache.Region;
import com.gemstone.gemfire.cache.RegionAttributes;
import com.gemstone.gemfire.cache.Scope;
import com.gemstone.gemfire.cache.client.PoolManager;
import com.gemstone.gemfire.cache.client.internal.PoolImpl;
import com.gemstone.gemfire.cache.server.CacheServer;
import com.gemstone.gemfire.distributed.DistributedMember;
import com.gemstone.gemfire.distributed.DistributedSystem;
import com.gemstone.gemfire.distributed.internal.InternalDistributedSystem;
import com.gemstone.gemfire.internal.AvailablePort;
import com.gemstone.gemfire.internal.cache.GemFireCacheImpl;
import com.gemstone.gemfire.management.CacheServerMXBean;
import com.gemstone.gemfire.management.MBeanUtil;
import com.gemstone.gemfire.management.ManagementTestBase;
import com.gemstone.gemfire.management.internal.cli.CliUtil;
import dunit.DistributedTestCase;
import dunit.Host;
import dunit.SerializableCallable;
import dunit.SerializableRunnable;
import dunit.VM;
import java.util.Properties;
import junit.framework.TestCase;

public class TestClientIdsDUnitTest
extends DistributedTestCase {
    private static final String k1 = "k1";
    private static final String k2 = "k2";
    private static final String client_k1 = "client-k1";
    private static final String client_k2 = "client-k2";
    private static final String REGION_NAME = "ClientHealthStatsDUnitTest_Region";
    private static VM server = null;
    private static VM client = null;
    private static VM client2 = null;
    private static VM managingNode = null;
    private ManagementTestBase helper;
    private static final long serialVersionUID = 1L;

    public TestClientIdsDUnitTest(String name) {
        super(name);
        this.helper = new ManagementTestBase(name);
    }

    @Override
    public void setUp() throws Exception {
        super.setUp();
        Host host = Host.getHost(0);
        managingNode = host.getVM(0);
        server = host.getVM(1);
        client = host.getVM(2);
        client2 = host.getVM(3);
    }

    @Override
    public void tearDown2() throws Exception {
        super.tearDown2();
        this.helper.closeCache(managingNode);
        this.helper.closeCache(server);
        this.helper.closeCache(client);
        this.helper.closeCache(client2);
        TestClientIdsDUnitTest.disconnectFromDS();
    }

    public void testClientIds() throws Exception {
        this.helper.createManagementCache(managingNode);
        this.helper.startManagingNode(managingNode);
        int port = (Integer)this.createServerCache(server);
        DistributedMember serverMember = this.helper.getMember(server);
        this.createClientCache(client, TestClientIdsDUnitTest.getServerHostName(server.getHost()), port);
        this.createClientCache(client2, TestClientIdsDUnitTest.getServerHostName(server.getHost()), port);
        this.put(client);
        this.put(client2);
        this.verifyClientIds(managingNode, serverMember, port);
        this.helper.stopManagingNode(managingNode);
    }

    private Object createServerCache(VM vm) {
        return vm.invoke(new SerializableCallable("Create Server Cache"){

            public Object call() {
                try {
                    return TestClientIdsDUnitTest.this.createServerCache();
                }
                catch (Exception e) {
                    TestCase.fail((String)("Error while createServerCache " + e));
                    return null;
                }
            }
        });
    }

    private void createClientCache(VM vm, final String host, final Integer port1) {
        vm.invoke(new SerializableCallable("Create Client Cache"){

            public Object call() {
                try {
                    TestClientIdsDUnitTest.this.createClientCache(host, port1);
                }
                catch (Exception e) {
                    TestCase.fail((String)("Error while createClientCache " + e));
                }
                return null;
            }
        });
    }

    private Cache createCache(Properties props) throws Exception {
        InternalDistributedSystem ds = this.getSystem(props);
        ds.disconnect();
        ds = this.getSystem(props);
        TestClientIdsDUnitTest.assertNotNull((Object)ds);
        GemFireCacheImpl cache = (GemFireCacheImpl)CacheFactory.create((DistributedSystem)ds);
        TestClientIdsDUnitTest.assertNotNull((Object)cache);
        return cache;
    }

    private Integer createServerCache(DataPolicy dataPolicy) throws Exception {
        Cache cache = this.helper.createCache(false);
        AttributesFactory factory = new AttributesFactory();
        factory.setScope(Scope.DISTRIBUTED_ACK);
        factory.setDataPolicy(dataPolicy);
        RegionAttributes attrs = factory.create();
        cache.createRegion(REGION_NAME, attrs);
        int port = AvailablePort.getRandomAvailablePort((int)0);
        CacheServer server1 = cache.addCacheServer();
        server1.setPort(port);
        server1.setNotifyBySubscription(true);
        server1.start();
        return new Integer(server1.getPort());
    }

    public Integer createServerCache() throws Exception {
        return this.createServerCache(DataPolicy.REPLICATE);
    }

    public Cache createClientCache(String host, Integer port1) throws Exception {
        Properties props = new Properties();
        props.setProperty("mcast-port", "0");
        props.setProperty("locators", "");
        Cache cache = this.createCache(props);
        PoolImpl p = (PoolImpl)PoolManager.createFactory().addServer(host, port1.intValue()).setSubscriptionEnabled(false).setThreadLocalConnections(true).setMinConnections(1).setReadTimeout(20000).setPingInterval(10000L).setRetryAttempts(1).setSubscriptionEnabled(true).setStatisticInterval(1000).create("CacheServerManagementDUnitTest");
        AttributesFactory factory = new AttributesFactory();
        factory.setScope(Scope.DISTRIBUTED_ACK);
        factory.setPoolName(p.getName());
        RegionAttributes attrs = factory.create();
        Region region = cache.createRegion(REGION_NAME, attrs);
        return cache;
    }

    protected static DistributedMember getMember() throws Exception {
        GemFireCacheImpl cache = GemFireCacheImpl.getInstance();
        return cache.getDistributedSystem().getDistributedMember();
    }

    protected void verifyClientIds(VM vm, final DistributedMember serverMember, final int serverPort) {
        SerializableRunnable verifyCacheServerRemote = new SerializableRunnable("Verify Cache Server Remote"){

            @Override
            public void run() {
                try {
                    DistributedTestCase.WaitCriterion waitCriteria = new DistributedTestCase.WaitCriterion(){

                        @Override
                        public boolean done() {
                            CacheServerMXBean bean = null;
                            try {
                                bean = MBeanUtil.getCacheServerMbeanProxy(serverMember, serverPort);
                                if (bean != null && bean.getClientIds().length > 0) {
                                    return true;
                                }
                            }
                            catch (Exception e) {
                                DistributedTestCase.getLogWriter().info("exception occured " + e.getMessage() + CliUtil.stackTraceAsString((Throwable)e));
                            }
                            return false;
                        }

                        @Override
                        public String description() {
                            return "wait for getNumOfClients bean to complete and get results";
                        }
                    };
                    DistributedTestCase.waitForCriterion(waitCriteria, 120000L, 3000L, true);
                    CacheServerMXBean bean = MBeanUtil.getCacheServerMbeanProxy(serverMember, serverPort);
                    DistributedTestCase.getLogWriter().info("verifyClientIds = " + bean.getClientIds().length);
                    TestCase.assertEquals((boolean)true, (bean.getClientIds().length > 0 ? 1 : 0) != 0);
                }
                catch (Exception e) {
                    TestCase.fail((String)("Error while verifying cache server from remote member " + e));
                }
            }
        };
        vm.invoke(verifyCacheServerRemote);
    }

    protected void put(VM vm) {
        SerializableRunnable put = new SerializableRunnable("put"){

            @Override
            public void run() {
                try {
                    GemFireCacheImpl cache = GemFireCacheImpl.getInstance();
                    Region r1 = cache.getRegion("/ClientHealthStatsDUnitTest_Region");
                    TestCase.assertNotNull((Object)r1);
                    r1.put((Object)TestClientIdsDUnitTest.k1, (Object)TestClientIdsDUnitTest.client_k1);
                    TestCase.assertEquals((Object)r1.getEntry((Object)TestClientIdsDUnitTest.k1).getValue(), (Object)TestClientIdsDUnitTest.client_k1);
                    r1.put((Object)TestClientIdsDUnitTest.k2, (Object)TestClientIdsDUnitTest.client_k2);
                    TestCase.assertEquals((Object)r1.getEntry((Object)TestClientIdsDUnitTest.k2).getValue(), (Object)TestClientIdsDUnitTest.client_k2);
                    try {
                        Thread.sleep(10000L);
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                    r1.clear();
                    r1.put((Object)TestClientIdsDUnitTest.k1, (Object)TestClientIdsDUnitTest.client_k1);
                    TestCase.assertEquals((Object)r1.getEntry((Object)TestClientIdsDUnitTest.k1).getValue(), (Object)TestClientIdsDUnitTest.client_k1);
                    r1.put((Object)TestClientIdsDUnitTest.k2, (Object)TestClientIdsDUnitTest.client_k2);
                    TestCase.assertEquals((Object)r1.getEntry((Object)TestClientIdsDUnitTest.k2).getValue(), (Object)TestClientIdsDUnitTest.client_k2);
                    try {
                        Thread.sleep(10000L);
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                    r1.clear();
                }
                catch (Exception ex) {
                    DistributedTestCase.fail("failed while put", ex);
                }
            }
        };
        vm.invoke(put);
    }
}

