/*
 * Decompiled with CFR 0.152.
 */
package com.gemstone.gemfire.management.internal.pulse;

import com.gemstone.gemfire.cache.Cache;
import com.gemstone.gemfire.cache.execute.Execution;
import com.gemstone.gemfire.cache.execute.Function;
import com.gemstone.gemfire.cache.execute.FunctionService;
import com.gemstone.gemfire.distributed.DistributedMember;
import com.gemstone.gemfire.internal.cache.functions.TestFunction;
import com.gemstone.gemfire.management.DistributedSystemMXBean;
import com.gemstone.gemfire.management.ManagementService;
import com.gemstone.gemfire.management.ManagementTestBase;
import dunit.DistributedTestCase;
import dunit.SerializableRunnable;
import dunit.VM;

public class TestFunctionsDUnitTest
extends ManagementTestBase {
    private static final long serialVersionUID = 1L;

    public TestFunctionsDUnitTest(String name) {
        super(name);
    }

    @Override
    public void setUp() throws Exception {
        super.setUp();
    }

    @Override
    public void tearDown2() throws Exception {
        super.tearDown2();
    }

    public static Integer getNumOfRunningFunction() {
        DistributedTestCase.WaitCriterion waitCriteria = new DistributedTestCase.WaitCriterion(){

            @Override
            public boolean done() {
                ManagementService service = ManagementTestBase.getManagementService();
                DistributedSystemMXBean bean = service.getDistributedSystemMXBean();
                if (bean != null) {
                    return bean.getNumRunningFunctions() > 0;
                }
                return false;
            }

            @Override
            public String description() {
                return "wait for getNumOfRunningFunction to complete and get results";
            }
        };
        TestFunctionsDUnitTest.waitForCriterion(waitCriteria, 120000L, 3000L, true);
        DistributedSystemMXBean bean = TestFunctionsDUnitTest.getManagementService().getDistributedSystemMXBean();
        TestFunctionsDUnitTest.assertNotNull((Object)bean);
        return bean.getNumRunningFunctions();
    }

    public void testNumOfRunningFunctions() throws Exception {
        this.initManagement(false);
        VM client = (VM)managedNodeList.get(2);
        client.invokeAsync(new SerializableRunnable(){

            @Override
            public void run() {
                Cache cache = TestFunctionsDUnitTest.this.getCache();
                TestFunction function = new TestFunction(true, "executeFunctionRunningForLongTime");
                Execution execution = FunctionService.onMember((DistributedMember)cache.getDistributedSystem().getDistributedMember());
                for (int i = 0; i < 100; ++i) {
                    execution.execute((Function)function);
                }
            }
        });
        Integer numOfRunningFunctions = (Integer)managingNode.invoke(TestFunctionsDUnitTest.class, "getNumOfRunningFunction");
        TestFunctionsDUnitTest.getLogWriter().info("TestNumOfFunctions numOfRunningFunctions= " + numOfRunningFunctions);
        TestFunctionsDUnitTest.assertTrue((numOfRunningFunctions > 0 ? 1 : 0) != 0);
    }

    public void verifyStatistics() {
    }

    public void invokeOperations() {
    }
}

