/*
 * Decompiled with CFR 0.152.
 */
package com.gemstone.gemfire.management.internal.pulse;

import com.gemstone.gemfire.management.DistributedSystemMXBean;
import com.gemstone.gemfire.management.ManagementService;
import com.gemstone.gemfire.management.ManagementTestBase;
import dunit.DistributedTestCase;

public class TestLocatorsDUnitTest
extends ManagementTestBase {
    private static final long serialVersionUID = 1L;

    public TestLocatorsDUnitTest(String name) {
        super(name);
    }

    @Override
    public void setUp() throws Exception {
        super.setUp();
    }

    @Override
    public void tearDown2() throws Exception {
        super.tearDown2();
    }

    public static int getNumOfLocatorFromMBean() {
        DistributedTestCase.WaitCriterion waitCriteria = new DistributedTestCase.WaitCriterion(){

            @Override
            public boolean done() {
                ManagementService service = ManagementTestBase.getManagementService();
                DistributedSystemMXBean bean = service.getDistributedSystemMXBean();
                return bean != null && bean.getLocatorCount() > 0;
            }

            @Override
            public String description() {
                return "wait for getNumOfLocatorFromMBean to complete and get results";
            }
        };
        TestLocatorsDUnitTest.waitForCriterion(waitCriteria, 120000L, 2000L, true);
        DistributedSystemMXBean bean = TestLocatorsDUnitTest.getManagementService().getDistributedSystemMXBean();
        TestLocatorsDUnitTest.assertNotNull((Object)bean);
        return bean.getLocatorCount();
    }

    public void testLocatorsDUnitTest() throws Exception {
        this.initManagement(false);
        int locatorCount = ((Number)managingNode.invoke(TestLocatorsDUnitTest.class, "getNumOfLocatorFromMBean")).intValue();
        TestLocatorsDUnitTest.getLogWriter().info("TestLocatorsDUnitTest locatorCount =" + locatorCount);
        TestLocatorsDUnitTest.assertEquals((int)1, (int)locatorCount);
    }

    public void verifyStatistics() {
    }

    public void invokeOperations() {
    }
}

