/*
 * Decompiled with CFR 0.152.
 */
package com.gemstone.gemfire.management.internal.pulse;

import com.gemstone.gemfire.cache.AttributesFactory;
import com.gemstone.gemfire.cache.Cache;
import com.gemstone.gemfire.cache.CacheFactory;
import com.gemstone.gemfire.cache.DataPolicy;
import com.gemstone.gemfire.cache.Region;
import com.gemstone.gemfire.cache.RegionAttributes;
import com.gemstone.gemfire.cache.Scope;
import com.gemstone.gemfire.cache.client.PoolManager;
import com.gemstone.gemfire.cache.client.internal.PoolImpl;
import com.gemstone.gemfire.cache.server.CacheServer;
import com.gemstone.gemfire.distributed.DistributedMember;
import com.gemstone.gemfire.distributed.DistributedSystem;
import com.gemstone.gemfire.distributed.internal.InternalDistributedSystem;
import com.gemstone.gemfire.internal.AvailablePort;
import com.gemstone.gemfire.internal.cache.GemFireCacheImpl;
import com.gemstone.gemfire.management.DistributedSystemMXBean;
import com.gemstone.gemfire.management.ManagementService;
import com.gemstone.gemfire.management.ManagementTestBase;
import dunit.DistributedTestCase;
import dunit.Host;
import dunit.SerializableCallable;
import dunit.SerializableRunnable;
import dunit.VM;
import java.util.Properties;
import junit.framework.TestCase;

public class TestSubscriptionsDUnitTest
extends DistributedTestCase {
    private static final String k1 = "k1";
    private static final String k2 = "k2";
    private static final String client_k1 = "client-k1";
    private static final String client_k2 = "client-k2";
    private static final String REGION_NAME = "TestSubscriptionsDUnitTest_Region";
    private static VM server = null;
    private static VM client = null;
    private static VM client2 = null;
    private static VM managingNode = null;
    private ManagementTestBase helper;
    private static final long serialVersionUID = 1L;

    public TestSubscriptionsDUnitTest(String name) {
        super(name);
        this.helper = new ManagementTestBase(name);
    }

    @Override
    public void setUp() throws Exception {
        super.setUp();
        Host host = Host.getHost(0);
        managingNode = host.getVM(0);
        server = host.getVM(1);
        client = host.getVM(2);
        client2 = host.getVM(3);
    }

    @Override
    public void tearDown2() throws Exception {
        super.tearDown2();
        this.helper.closeCache(managingNode);
        this.helper.closeCache(server);
        this.helper.closeCache(client);
        this.helper.closeCache(client2);
        TestSubscriptionsDUnitTest.disconnectFromDS();
    }

    public void testNoOfSubscription() throws Exception {
        this.helper.createManagementCache(managingNode);
        this.helper.startManagingNode(managingNode);
        int port = (Integer)this.createServerCache(server);
        DistributedMember serverMember = this.helper.getMember(server);
        this.createClientCache(client, TestSubscriptionsDUnitTest.getServerHostName(server.getHost()), port);
        this.createClientCache(client2, TestSubscriptionsDUnitTest.getServerHostName(server.getHost()), port);
        this.put(client);
        this.put(client2);
        this.registerInterest(client);
        this.registerInterest(client2);
        this.verifyClientStats(managingNode, serverMember, port);
        this.helper.stopManagingNode(managingNode);
    }

    private Object createServerCache(VM vm) {
        return vm.invoke(new SerializableCallable("Create Server Cache in TestSubscriptionsDUnitTest"){

            public Object call() {
                try {
                    return TestSubscriptionsDUnitTest.this.createServerCache();
                }
                catch (Exception e) {
                    TestCase.fail((String)("Error while createServerCache in TestSubscriptionsDUnitTest" + e));
                    return null;
                }
            }
        });
    }

    private void createClientCache(VM vm, final String host, final Integer port1) {
        vm.invoke(new SerializableCallable("Create Client Cache in TestSubscriptionsDUnitTest"){

            public Object call() {
                try {
                    TestSubscriptionsDUnitTest.this.createClientCache(host, port1);
                }
                catch (Exception e) {
                    TestCase.fail((String)("Error while createClientCache in TestSubscriptionsDUnitTest " + e));
                }
                return null;
            }
        });
    }

    private Cache createCache(Properties props) throws Exception {
        InternalDistributedSystem ds = this.getSystem(props);
        ds.disconnect();
        ds = this.getSystem(props);
        TestSubscriptionsDUnitTest.assertNotNull((Object)ds);
        GemFireCacheImpl cache = (GemFireCacheImpl)CacheFactory.create((DistributedSystem)ds);
        TestSubscriptionsDUnitTest.assertNotNull((Object)cache);
        return cache;
    }

    private Integer createServerCache(DataPolicy dataPolicy) throws Exception {
        Cache cache = this.helper.createCache(false);
        AttributesFactory factory = new AttributesFactory();
        factory.setScope(Scope.DISTRIBUTED_ACK);
        factory.setDataPolicy(dataPolicy);
        RegionAttributes attrs = factory.create();
        cache.createRegion(REGION_NAME, attrs);
        int port = AvailablePort.getRandomAvailablePort((int)0);
        CacheServer server1 = cache.addCacheServer();
        server1.setPort(port);
        server1.setNotifyBySubscription(true);
        server1.start();
        return new Integer(server1.getPort());
    }

    public Integer createServerCache() throws Exception {
        return this.createServerCache(DataPolicy.REPLICATE);
    }

    public Cache createClientCache(String host, Integer port1) throws Exception {
        Properties props = new Properties();
        props.setProperty("mcast-port", "0");
        props.setProperty("locators", "");
        Cache cache = this.createCache(props);
        PoolImpl p = (PoolImpl)PoolManager.createFactory().addServer(host, port1.intValue()).setSubscriptionEnabled(true).setThreadLocalConnections(true).setMinConnections(1).setReadTimeout(20000).setPingInterval(10000L).setRetryAttempts(1).setSubscriptionEnabled(true).setStatisticInterval(1000).create("TestSubscriptionsDUnitTest");
        AttributesFactory factory = new AttributesFactory();
        factory.setScope(Scope.DISTRIBUTED_ACK);
        factory.setPoolName(p.getName());
        RegionAttributes attrs = factory.create();
        Region region = cache.createRegion(REGION_NAME, attrs);
        return cache;
    }

    protected static DistributedMember getMember() throws Exception {
        GemFireCacheImpl cache = GemFireCacheImpl.getInstance();
        return cache.getDistributedSystem().getDistributedMember();
    }

    protected void verifyClientStats(VM vm, DistributedMember serverMember, int serverPort) {
        SerializableRunnable verifyCacheServerRemote = new SerializableRunnable("TestSubscriptionsDUnitTest Verify Cache Server Remote"){

            @Override
            public void run() {
                final GemFireCacheImpl cache = GemFireCacheImpl.getInstance();
                try {
                    DistributedTestCase.WaitCriterion waitCriteria = new DistributedTestCase.WaitCriterion(){

                        @Override
                        public boolean done() {
                            ManagementService service = ManagementService.getExistingManagementService((Cache)cache);
                            DistributedSystemMXBean dsBean = service.getDistributedSystemMXBean();
                            return dsBean != null && dsBean.getNumSubscriptions() > 1;
                        }

                        @Override
                        public String description() {
                            return "TestSubscriptionsDUnitTest wait for getDistributedSystemMXBean to complete and get results";
                        }
                    };
                    DistributedTestCase.waitForCriterion(waitCriteria, 120000L, 3000L, true);
                    DistributedSystemMXBean dsBean = ManagementService.getExistingManagementService((Cache)cache).getDistributedSystemMXBean();
                    TestCase.assertNotNull((Object)dsBean);
                    DistributedTestCase.getLogWriter().info("TestSubscriptionsDUnitTest dsBean.getNumSubscriptions() =" + dsBean.getNumSubscriptions());
                    TestCase.assertTrue((dsBean.getNumSubscriptions() == 2 ? 1 : 0) != 0);
                }
                catch (Exception e) {
                    TestCase.fail((String)("TestSubscriptionsDUnitTest Error while verifying subscription " + e.getMessage()));
                }
            }
        };
        vm.invoke(verifyCacheServerRemote);
    }

    protected void registerInterest(VM vm) {
        SerializableRunnable put = new SerializableRunnable("TestSubscriptionsDUnitTest registerInterest"){

            @Override
            public void run() {
                try {
                    GemFireCacheImpl cache = GemFireCacheImpl.getInstance();
                    Region r1 = cache.getRegion("/TestSubscriptionsDUnitTest_Region");
                    TestCase.assertNotNull((Object)r1);
                    r1.registerInterest((Object)TestSubscriptionsDUnitTest.k1);
                    r1.registerInterest((Object)TestSubscriptionsDUnitTest.k2);
                }
                catch (Exception ex) {
                    DistributedTestCase.fail("TestSubscriptionsDUnitTest failed while register Interest", ex);
                }
            }
        };
        vm.invoke(put);
    }

    protected void put(VM vm) {
        SerializableRunnable put = new SerializableRunnable("put"){

            @Override
            public void run() {
                try {
                    GemFireCacheImpl cache = GemFireCacheImpl.getInstance();
                    Region r1 = cache.getRegion("/TestSubscriptionsDUnitTest_Region");
                    TestCase.assertNotNull((Object)r1);
                    r1.put((Object)TestSubscriptionsDUnitTest.k1, (Object)TestSubscriptionsDUnitTest.client_k1);
                    TestCase.assertEquals((Object)r1.getEntry((Object)TestSubscriptionsDUnitTest.k1).getValue(), (Object)TestSubscriptionsDUnitTest.client_k1);
                    r1.put((Object)TestSubscriptionsDUnitTest.k2, (Object)TestSubscriptionsDUnitTest.client_k2);
                    TestCase.assertEquals((Object)r1.getEntry((Object)TestSubscriptionsDUnitTest.k2).getValue(), (Object)TestSubscriptionsDUnitTest.client_k2);
                }
                catch (Exception ex) {
                    DistributedTestCase.fail("failed while put", ex);
                }
            }
        };
        vm.invoke(put);
    }
}

