/*
 * Decompiled with CFR 0.152.
 */
package com.gemstone.gemfire.pdx;

import com.gemstone.gemfire.distributed.internal.DistributionManager;
import com.gemstone.gemfire.distributed.internal.InternalDistributedSystem;
import com.gemstone.gemfire.internal.AvailablePortHelper;
import dunit.DistributedTestCase;
import dunit.Host;
import dunit.SerializableCallable;
import dunit.VM;
import java.util.Properties;
import junit.framework.TestCase;

public class DistributedSystemIdDUnitTest
extends DistributedTestCase {
    public DistributedSystemIdDUnitTest(String name) {
        super(name);
    }

    public void testMatchingIds() {
        Host host = Host.getHost(0);
        VM vm0 = host.getVM(0);
        VM vm1 = host.getVM(1);
        VM vm2 = host.getVM(2);
        int locatorPort = this.createLocator(vm0, "1");
        this.createSystem(vm1, "1", locatorPort);
        this.createSystem(vm2, "1", locatorPort);
        this.checkId(vm0, 1);
        this.checkId(vm1, 1);
        this.checkId(vm2, 1);
    }

    public void testInfectousId() {
        Host host = Host.getHost(0);
        VM vm0 = host.getVM(0);
        VM vm1 = host.getVM(1);
        int locatorPort = this.createLocator(vm0, "1");
        this.createSystem(vm1, "-1", locatorPort);
        this.checkId(vm1, 1);
    }

    public void testMismatch() {
        Host host = Host.getHost(0);
        VM vm0 = host.getVM(0);
        VM vm1 = host.getVM(1);
        int locatorPort = this.createLocator(vm0, "1");
        try {
            this.createSystem(vm1, "2", locatorPort);
            DistributedSystemIdDUnitTest.fail((String)"Should have gotten an exception");
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.checkId(vm0, 1);
    }

    public void testInvalid() {
        Host host = Host.getHost(0);
        VM vm0 = host.getVM(0);
        VM vm1 = host.getVM(1);
        try {
            this.createLocator(vm0, "256");
            DistributedSystemIdDUnitTest.fail((String)"Should have gotten an exception");
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            this.createLocator(vm0, "aardvark");
            DistributedSystemIdDUnitTest.fail((String)"Should have gotten an exception");
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private void createSystem(VM vm, final String dsId, final int locatorPort) {
        SerializableCallable createSystem = new SerializableCallable(){

            public Object call() throws Exception {
                Properties props = new Properties();
                props.setProperty("distributed-system-id", dsId);
                props.setProperty("locators", "localhost[" + locatorPort + "]");
                DistributedSystemIdDUnitTest.this.getSystem(props);
                return null;
            }
        };
        vm.invoke(createSystem);
    }

    private int createLocator(VM vm, final String dsId) {
        SerializableCallable createSystem = new SerializableCallable(){

            public Object call() throws Exception {
                int port = AvailablePortHelper.getRandomAvailableTCPPort();
                Properties props = new Properties();
                props.setProperty("distributed-system-id", dsId);
                props.setProperty("mcast-port", "0");
                props.setProperty("locators", "localhost[" + port + "]");
                props.setProperty("start-locator", "localhost[" + port + "]");
                DistributedSystemIdDUnitTest.this.getSystem(props);
                return port;
            }
        };
        return (Integer)vm.invoke(createSystem);
    }

    private void checkId(VM vm, final int dsId) {
        SerializableCallable createSystem = new SerializableCallable(){

            public Object call() throws Exception {
                DistributionManager dm = (DistributionManager)InternalDistributedSystem.getAnyInstance().getDistributionManager();
                TestCase.assertEquals((int)dsId, (int)dm.getDistributedSystemId());
                return null;
            }
        };
        vm.invoke(createSystem);
    }
}

