/*
 * Decompiled with CFR 0.152.
 */
package com.gemstone.gemfire.pdx;

import com.gemstone.gemfire.DataSerializer;
import com.gemstone.gemfire.cache.AttributesFactory;
import com.gemstone.gemfire.cache.Cache;
import com.gemstone.gemfire.cache.CacheFactory;
import com.gemstone.gemfire.cache.DataPolicy;
import com.gemstone.gemfire.cache.Region;
import com.gemstone.gemfire.cache.Scope;
import com.gemstone.gemfire.cache.client.ClientCache;
import com.gemstone.gemfire.cache.client.ClientCacheFactory;
import com.gemstone.gemfire.cache.client.ClientRegionShortcut;
import com.gemstone.gemfire.cache.client.PoolFactory;
import com.gemstone.gemfire.cache.client.PoolManager;
import com.gemstone.gemfire.cache.query.internal.DefaultQuery;
import com.gemstone.gemfire.cache.server.CacheServer;
import com.gemstone.gemfire.cache.util.GatewayHub;
import com.gemstone.gemfire.cache30.CacheTestCase;
import com.gemstone.gemfire.internal.AvailablePortHelper;
import com.gemstone.gemfire.internal.HeapDataOutputStream;
import com.gemstone.gemfire.internal.cache.CachedDeserializableFactory;
import com.gemstone.gemfire.internal.cache.GemFireCacheImpl;
import com.gemstone.gemfire.internal.shared.Version;
import com.gemstone.gemfire.pdx.PdxInitializationException;
import com.gemstone.gemfire.pdx.PdxInstance;
import com.gemstone.gemfire.pdx.PdxReader;
import com.gemstone.gemfire.pdx.PdxSerializable;
import com.gemstone.gemfire.pdx.PdxWriter;
import com.gemstone.gemfire.pdx.SimpleClass;
import com.gemstone.gemfire.pdx.SimpleClass2;
import dunit.DistributedTestCase;
import dunit.Host;
import dunit.SerializableCallable;
import dunit.VM;
import java.io.ByteArrayInputStream;
import java.io.DataInput;
import java.io.DataInputStream;
import java.io.DataOutput;
import java.util.Properties;
import junit.framework.TestCase;

public class PdxClientServerDUnitTest
extends CacheTestCase {
    public PdxClientServerDUnitTest(String name) {
        super(name);
    }

    public void testSimplePut() {
        Host host = Host.getHost(0);
        VM vm0 = host.getVM(0);
        VM vm1 = host.getVM(1);
        VM vm2 = host.getVM(2);
        VM vm3 = host.getVM(3);
        this.createServerRegion(vm0);
        int port = this.createServerAccessor(vm3);
        this.createClientRegion(vm1, port);
        this.createClientRegion(vm2, port);
        vm1.invoke(new SerializableCallable(){

            public Object call() throws Exception {
                Region r = PdxClientServerDUnitTest.this.getRootRegion("testSimplePdx");
                r.put((Object)1, (Object)new SimpleClass(57, 3));
                return null;
            }
        });
        SerializableCallable checkValue = new SerializableCallable(){

            public Object call() throws Exception {
                Region r = PdxClientServerDUnitTest.this.getRootRegion("testSimplePdx");
                TestCase.assertEquals((Object)new SimpleClass(57, 3), (Object)r.get((Object)1));
                return null;
            }
        };
        vm2.invoke(checkValue);
        vm0.invoke(checkValue);
        vm1.invoke(checkValue);
    }

    public void testNonPersistentServerRestart() {
        Host host = Host.getHost(0);
        VM vm0 = host.getVM(0);
        VM vm1 = host.getVM(1);
        VM vm2 = host.getVM(2);
        int port = this.createServerRegion(vm0);
        this.createClientRegion(vm1, port);
        vm1.invoke(new SerializableCallable(){

            public Object call() throws Exception {
                Region r = PdxClientServerDUnitTest.this.getRootRegion("testSimplePdx");
                r.put((Object)1, (Object)new PdxType2(1, 1));
                r.get((Object)1);
                return null;
            }
        });
        this.closeCache(vm0);
        this.createServerRegion(vm0, port);
        this.createClientRegion(vm2, port);
        vm2.invoke(new SerializableCallable(){

            public Object call() throws Exception {
                Region r = PdxClientServerDUnitTest.this.getRootRegion("testSimplePdx");
                r.put((Object)3, (Object)new PdxType1(3));
                r.get((Object)3);
                return null;
            }
        });
        vm1.invoke(new SerializableCallable(){

            public Object call() throws Exception {
                Region r = PdxClientServerDUnitTest.this.getRootRegion("testSimplePdx");
                try {
                    r.get((Object)4);
                }
                catch (Exception exception) {
                    // empty catch block
                }
                PdxType1 results = (PdxType1)r.get((Object)3);
                TestCase.assertEquals((int)3, (int)results.int1);
                return null;
            }
        });
    }

    public void testServersWithPersistence() {
        Host host = Host.getHost(0);
        VM vm0 = host.getVM(0);
        VM vm1 = host.getVM(1);
        VM vm2 = host.getVM(2);
        VM vm3 = host.getVM(3);
        this.createServerRegionWithPersistence(vm0, false);
        int port = this.createServerAccessor(vm1);
        this.createClientRegion(vm2, port);
        this.createClientRegion(vm3, port);
        SerializableCallable createValue = new SerializableCallable(){

            public Object call() throws Exception {
                Region r = PdxClientServerDUnitTest.this.getRootRegion("testSimplePdx");
                try {
                    r.put((Object)1, (Object)new SimpleClass(57, 3));
                    TestCase.fail((String)"should have received an exception");
                }
                catch (PdxInitializationException pdxInitializationException) {
                    // empty catch block
                }
                return null;
            }
        };
    }

    private void closeCache(VM vm) {
        vm.invoke(new SerializableCallable(){

            public Object call() throws Exception {
                CacheTestCase.closeCache();
                return null;
            }
        });
    }

    public void testPutThreadLocalConnections() {
        Host host = Host.getHost(0);
        VM vm0 = host.getVM(0);
        VM vm1 = host.getVM(1);
        VM vm2 = host.getVM(2);
        int port = this.createServerRegion(vm0);
        this.createClientRegion(vm1, port, true);
        this.createClientRegion(vm2, port, true);
        vm1.invoke(new SerializableCallable(){

            public Object call() throws Exception {
                Region r = PdxClientServerDUnitTest.this.getRootRegion("testSimplePdx");
                r.put((Object)1, (Object)new SimpleClass(57, 3));
                r.put((Object)2, (Object)new SimpleClass2(57, 3));
                return null;
            }
        });
        SerializableCallable checkValue = new SerializableCallable(){

            public Object call() throws Exception {
                Region r = PdxClientServerDUnitTest.this.getRootRegion("testSimplePdx");
                TestCase.assertEquals((Object)new SimpleClass(57, 3), (Object)r.get((Object)1));
                TestCase.assertEquals((Object)new SimpleClass2(57, 3), (Object)r.get((Object)2));
                return null;
            }
        };
        vm2.invoke(checkValue);
        vm0.invoke(checkValue);
        vm1.invoke(checkValue);
    }

    public void testSimplePdxInstancePut() {
        Host host = Host.getHost(0);
        VM vm0 = host.getVM(0);
        VM vm1 = host.getVM(1);
        VM vm2 = host.getVM(2);
        int port = this.createServerRegion(vm0);
        this.createClientRegion(vm1, port);
        this.createClientRegion(vm2, port);
        vm1.invoke(new SerializableCallable(){

            public Object call() throws Exception {
                Region r = PdxClientServerDUnitTest.this.getRootRegion("testSimplePdx");
                r.put((Object)1, (Object)new SimpleClass(57, 3));
                return null;
            }
        });
        SerializableCallable checkValue = new SerializableCallable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public Object call() throws Exception {
                Region r = PdxClientServerDUnitTest.this.getRootRegion("testSimplePdx");
                DefaultQuery.setPdxReadSerialized((boolean)true);
                GemFireCacheImpl gfCache = GemFireCacheImpl.getInstance();
                boolean expectPdxInstance = gfCache.isClient() || !CachedDeserializableFactory.preferObject();
                try {
                    Object v = r.get((Object)1);
                    if (expectPdxInstance) {
                        if (!(v instanceof PdxInstance)) {
                            TestCase.fail((String)("expected v " + v.getClass() + " to be a PdxInstance"));
                        }
                        PdxInstance piv = (PdxInstance)v;
                        TestCase.assertEquals((Object)new SimpleClass(57, 3), (Object)piv.getObject());
                        Object v2 = r.get((Object)1);
                        if (v == v2) {
                            TestCase.fail((String)"expected v and v2 to have a different identity");
                        }
                        TestCase.assertEquals((Object)v, (Object)v2);
                    } else {
                        TestCase.assertEquals((Object)new SimpleClass(57, 3), (Object)v);
                        Object v2 = r.get((Object)1);
                        if (v != v2) {
                            TestCase.fail((String)"expected v and v2 to have the same identity");
                        }
                    }
                }
                finally {
                    DefaultQuery.setPdxReadSerialized((boolean)false);
                }
                return null;
            }
        };
        vm2.invoke(checkValue);
        vm0.invoke(checkValue);
    }

    public void testMultipleServerDSes() throws Exception {
        Host host = Host.getHost(0);
        final VM vm0 = host.getVM(0);
        VM vm1 = host.getVM(1);
        VM vm2 = host.getVM(2);
        VM vm3 = host.getVM(3);
        final int port1 = this.createLonerServerRegion(vm0, "region1", "1");
        final int port2 = this.createLonerServerRegion(vm1, "region2", "2");
        SerializableCallable createRegion = new SerializableCallable(){

            public Object call() throws Exception {
                Properties props = new Properties();
                props.setProperty("mcast-port", "0");
                props.setProperty("locators", "");
                PdxClientServerDUnitTest.this.getSystem(props);
                Cache cache = PdxClientServerDUnitTest.this.getCache();
                PoolFactory pf = PoolManager.createFactory();
                pf.addServer(DistributedTestCase.getServerHostName(vm0.getHost()), port1);
                pf.create("pool1");
                pf = PoolManager.createFactory();
                pf.addServer(DistributedTestCase.getServerHostName(vm0.getHost()), port2);
                pf.create("pool2");
                AttributesFactory af = new AttributesFactory();
                af.setPoolName("pool1");
                cache.createRegion("region1", af.create());
                af = new AttributesFactory();
                af.setPoolName("pool2");
                cache.createRegion("region2", af.create());
                return null;
            }
        };
        vm2.invoke(createRegion);
        vm3.invoke(createRegion);
        createRegion.call();
        vm2.invoke(new SerializableCallable(){

            public Object call() throws Exception {
                HeapDataOutputStream bytes = new HeapDataOutputStream(Version.CURRENT);
                Region r1 = PdxClientServerDUnitTest.this.getRootRegion("region1");
                r1.put((Object)1, (Object)new SimpleClass(57, 3));
                Region r2 = PdxClientServerDUnitTest.this.getRootRegion("region2");
                r2.put((Object)1, (Object)new SimpleClass(57, 3));
                return null;
            }
        });
        vm3.invoke(new SerializableCallable(){

            public Object call() throws Exception {
                Region r = PdxClientServerDUnitTest.this.getRootRegion("region1");
                TestCase.assertEquals((Object)new SimpleClass(57, 3), (Object)r.get((Object)1));
                return null;
            }
        });
        Region r = this.getRootRegion("region2");
        PdxClientServerDUnitTest.assertEquals((Object)new SimpleClass(57, 3), (Object)r.get((Object)1));
    }

    public void testUserSerializesObject() {
        Host host = Host.getHost(0);
        VM vm0 = host.getVM(0);
        VM vm1 = host.getVM(1);
        VM vm2 = host.getVM(2);
        int port = this.createServerRegion(vm0);
        this.createClientRegion(vm1, port);
        this.createClientRegion(vm2, port);
        vm1.invoke(new SerializableCallable(){

            public Object call() throws Exception {
                HeapDataOutputStream out = new HeapDataOutputStream(Version.CURRENT);
                DataSerializer.writeObject((Object)new SimpleClass(57, 3), (DataOutput)out);
                byte[] bytes = out.toByteArray();
                Region r = PdxClientServerDUnitTest.this.getRootRegion("testSimplePdx");
                r.put((Object)1, (Object)bytes);
                return null;
            }
        });
        SerializableCallable checkValue = new SerializableCallable(){

            public Object call() throws Exception {
                Region r = PdxClientServerDUnitTest.this.getRootRegion("testSimplePdx");
                byte[] bytes = (byte[])r.get((Object)1);
                DataInputStream bis = new DataInputStream(new ByteArrayInputStream(bytes));
                Object result = DataSerializer.readObject((DataInput)bis);
                TestCase.assertEquals((Object)new SimpleClass(57, 3), (Object)result);
                return null;
            }
        };
        vm2.invoke(checkValue);
        vm0.invoke(checkValue);
    }

    public void testLatePoolCreation() {
        Host host = Host.getHost(0);
        final VM vm0 = host.getVM(0);
        VM vm1 = host.getVM(1);
        VM vm2 = host.getVM(2);
        final int port = this.createServerRegion(vm0);
        SerializableCallable createRegion = new SerializableCallable(){

            public Object call() throws Exception {
                Properties props = new Properties();
                props.setProperty("mcast-port", "0");
                props.setProperty("locators", "");
                PdxClientServerDUnitTest.this.getSystem(props);
                Cache cache = PdxClientServerDUnitTest.this.getCache();
                PoolFactory pf = PoolManager.createFactory();
                pf.addServer(DistributedTestCase.getServerHostName(vm0.getHost()), port);
                pf.create("pool");
                AttributesFactory af = new AttributesFactory();
                af.setPoolName("pool");
                cache.createRegion("testSimplePdx", af.create());
                return null;
            }
        };
        vm1.invoke(createRegion);
        vm2.invoke(createRegion);
        vm1.invoke(new SerializableCallable(){

            public Object call() throws Exception {
                Region r = PdxClientServerDUnitTest.this.getRootRegion("testSimplePdx");
                r.put((Object)1, (Object)new SimpleClass(57, 3));
                return null;
            }
        });
        SerializableCallable checkValue = new SerializableCallable(){

            public Object call() throws Exception {
                Region r = PdxClientServerDUnitTest.this.getRootRegion("testSimplePdx");
                TestCase.assertEquals((Object)new SimpleClass(57, 3), (Object)r.get((Object)1));
                return null;
            }
        };
        vm2.invoke(checkValue);
        vm0.invoke(checkValue);
    }

    public void testExceptionWithPoolAfterTypeRegistryCreation() {
        Host host = Host.getHost(0);
        final VM vm0 = host.getVM(0);
        VM vm1 = host.getVM(1);
        final int port = this.createServerRegion(vm0);
        SerializableCallable createRegion = new SerializableCallable(){

            public Object call() throws Exception {
                Properties props = new Properties();
                props.setProperty("mcast-port", "0");
                props.setProperty("locators", "");
                PdxClientServerDUnitTest.this.getSystem(props);
                Cache cache = PdxClientServerDUnitTest.this.getCache();
                HeapDataOutputStream out = new HeapDataOutputStream(Version.CURRENT);
                DataSerializer.writeObject((Object)new SimpleClass(57, 3), (DataOutput)out);
                PoolFactory pf = PoolManager.createFactory();
                pf.addServer(DistributedTestCase.getServerHostName(vm0.getHost()), port);
                try {
                    pf.create("pool");
                    TestCase.fail((String)"should have received an exception");
                }
                catch (PdxInitializationException pdxInitializationException) {
                    // empty catch block
                }
                return null;
            }
        };
        vm1.invoke(createRegion);
    }

    public void testClientWithGateway() throws Exception {
        Host host = Host.getHost(0);
        final VM vm0 = host.getVM(0);
        VM vm1 = host.getVM(1);
        final int port = this.createServerRegion(vm0);
        vm1.invoke(new SerializableCallable(){

            public Object call() throws Exception {
                CacheTestCase.disconnectFromDS();
                Properties props = new Properties();
                props.setProperty("mcast-port", "0");
                props.setProperty("locators", "");
                PdxClientServerDUnitTest.this.getSystem(props);
                Cache cache = PdxClientServerDUnitTest.this.getCache();
                PoolFactory pf = PoolManager.createFactory();
                pf.addServer(DistributedTestCase.getServerHostName(vm0.getHost()), port);
                pf.create("pool");
                int hubPort = AvailablePortHelper.getRandomAvailableTCPPort();
                GatewayHub hub = cache.addGatewayHub("hub", hubPort);
                hub.start();
                try {
                    HeapDataOutputStream out = new HeapDataOutputStream(Version.CURRENT);
                    DataSerializer.writeObject((Object)new SimpleClass(57, 3), (DataOutput)out);
                    TestCase.fail((String)"should have received an exception");
                }
                catch (PdxInitializationException pdxInitializationException) {
                    // empty catch block
                }
                return null;
            }
        });
        vm1.invoke(new SerializableCallable(){

            public Object call() throws Exception {
                CacheTestCase.disconnectFromDS();
                Properties props = new Properties();
                props.setProperty("mcast-port", "0");
                props.setProperty("locators", "");
                PdxClientServerDUnitTest.this.getSystem(props);
                Cache cache = PdxClientServerDUnitTest.this.getCache();
                PoolFactory pf = PoolManager.createFactory();
                pf.addServer(DistributedTestCase.getServerHostName(vm0.getHost()), port);
                pf.create("pool");
                HeapDataOutputStream out = new HeapDataOutputStream(Version.CURRENT);
                DataSerializer.writeObject((Object)new SimpleClass(57, 3), (DataOutput)out);
                try {
                    int hubPort = AvailablePortHelper.getRandomAvailableTCPPort();
                    GatewayHub hub = cache.addGatewayHub("hub", hubPort);
                    hub.start();
                    TestCase.fail((String)"should have received an exception");
                }
                catch (PdxInitializationException pdxInitializationException) {
                    // empty catch block
                }
                return null;
            }
        });
    }

    private int createServerRegion(VM vm) {
        SerializableCallable createRegion = new SerializableCallable(){

            public Object call() throws Exception {
                AttributesFactory af = new AttributesFactory();
                af.setScope(Scope.DISTRIBUTED_ACK);
                af.setDataPolicy(DataPolicy.REPLICATE);
                PdxClientServerDUnitTest.this.createRootRegion("testSimplePdx", af.create());
                CacheServer server = PdxClientServerDUnitTest.this.getCache().addCacheServer();
                int port = AvailablePortHelper.getRandomAvailableTCPPort();
                server.setPort(port);
                server.start();
                return port;
            }
        };
        return (Integer)vm.invoke(createRegion);
    }

    private int createServerRegion(VM vm, final int port) {
        SerializableCallable createRegion = new SerializableCallable(){

            public Object call() throws Exception {
                AttributesFactory af = new AttributesFactory();
                af.setScope(Scope.DISTRIBUTED_ACK);
                af.setDataPolicy(DataPolicy.REPLICATE);
                PdxClientServerDUnitTest.this.createRootRegion("testSimplePdx", af.create());
                CacheServer server = PdxClientServerDUnitTest.this.getCache().addCacheServer();
                server.setPort(port);
                server.start();
                return port;
            }
        };
        return (Integer)vm.invoke(createRegion);
    }

    private int createServerRegionWithPersistence(VM vm, final boolean persistentPdxRegistry) {
        SerializableCallable createRegion = new SerializableCallable(){

            public Object call() throws Exception {
                CacheFactory cf = new CacheFactory();
                if (persistentPdxRegistry) {
                    cf.setPdxPersistent(true).setPdxDiskStore("store");
                }
                Cache cache = PdxClientServerDUnitTest.this.getCache(cf);
                cache.createDiskStoreFactory().setDiskDirs(CacheTestCase.getDiskDirs()).create("store");
                AttributesFactory af = new AttributesFactory();
                af.setScope(Scope.DISTRIBUTED_ACK);
                af.setDataPolicy(DataPolicy.PERSISTENT_REPLICATE);
                af.setDiskStoreName("store");
                PdxClientServerDUnitTest.this.createRootRegion("testSimplePdx", af.create());
                CacheServer server = PdxClientServerDUnitTest.this.getCache().addCacheServer();
                int port = AvailablePortHelper.getRandomAvailableTCPPort();
                server.setPort(port);
                server.start();
                return port;
            }
        };
        return (Integer)vm.invoke(createRegion);
    }

    private int createServerAccessor(VM vm) {
        SerializableCallable createRegion = new SerializableCallable(){

            public Object call() throws Exception {
                AttributesFactory af = new AttributesFactory();
                af.setScope(Scope.DISTRIBUTED_ACK);
                af.setDataPolicy(DataPolicy.EMPTY);
                PdxClientServerDUnitTest.this.createRootRegion("testSimplePdx", af.create());
                CacheServer server = PdxClientServerDUnitTest.this.getCache().addCacheServer();
                int port = AvailablePortHelper.getRandomAvailableTCPPort();
                server.setPort(port);
                server.start();
                return port;
            }
        };
        return (Integer)vm.invoke(createRegion);
    }

    private int createLonerServerRegion(VM vm, final String regionName, final String dsId) {
        SerializableCallable createRegion = new SerializableCallable(){

            public Object call() throws Exception {
                Properties props = new Properties();
                props.setProperty("locators", "");
                props.setProperty("distributed-system-id", dsId);
                PdxClientServerDUnitTest.this.getSystem(props);
                AttributesFactory af = new AttributesFactory();
                af.setScope(Scope.DISTRIBUTED_ACK);
                af.setDataPolicy(DataPolicy.REPLICATE);
                PdxClientServerDUnitTest.this.createRootRegion(regionName, af.create());
                CacheServer server = PdxClientServerDUnitTest.this.getCache().addCacheServer();
                int port = AvailablePortHelper.getRandomAvailableTCPPort();
                server.setPort(port);
                server.start();
                return port;
            }
        };
        return (Integer)vm.invoke(createRegion);
    }

    private void createClientRegion(VM vm, int port) {
        this.createClientRegion(vm, port, false);
    }

    private void createClientRegion(final VM vm, final int port, final boolean threadLocalConnections) {
        SerializableCallable createRegion = new SerializableCallable(){

            public Object call() throws Exception {
                ClientCacheFactory cf = new ClientCacheFactory();
                cf.addPoolServer(DistributedTestCase.getServerHostName(vm.getHost()), port);
                cf.setPoolThreadLocalConnections(threadLocalConnections);
                ClientCache cache = PdxClientServerDUnitTest.this.getClientCache(cf);
                cache.createClientRegionFactory(ClientRegionShortcut.CACHING_PROXY).create("testSimplePdx");
                return null;
            }
        };
        vm.invoke(createRegion);
    }

    public static class PdxType2
    implements PdxSerializable {
        int int1;
        int int2;

        public PdxType2() {
        }

        public PdxType2(int int1, int int2) {
            this.int1 = int1;
            this.int2 = int2;
        }

        public void toData(PdxWriter writer) {
            writer.writeInt("int1", this.int1);
            writer.writeInt("int2", this.int2);
        }

        public void fromData(PdxReader reader) {
            this.int2 = reader.readInt("int2");
            this.int2 = reader.readInt("int2");
        }
    }

    public static class PdxType1
    implements PdxSerializable {
        int int1;

        public PdxType1() {
        }

        public PdxType1(int int1) {
            this.int1 = int1;
        }

        public void toData(PdxWriter writer) {
            writer.writeInt("int1", this.int1);
        }

        public void fromData(PdxReader reader) {
            this.int1 = reader.readInt("int1");
        }
    }
}

